import { ActivatedRouteSnapshot, CanActivate, Router, RouterStateSnapshot, UrlTree } from '@angular/router';
import { Observable } from 'rxjs';
import { AbstractAuthService } from '../services/auth/abstract-auth.service';
import * as i0 from "@angular/core";
/**
 * Injectable
 */
export declare class AuthGuardLogin implements CanActivate {
    private authService;
    private router;
    /**
     * constructor
     * @param authService
     * @param router
     */
    constructor(authService: AbstractAuthService, router: Router);
    /**
     *  This method is responsable to check if there is a user logged on local storage and return true if not or redirect user to home page if there is a user logged
     * @param {ActivatedRouteSnapshot} route
     * @param {RouterStateSnapshot} state
     * @returns {Observable<boolean | UrlTree> | Promise<boolean | UrlTree> | boolean | UrlTree}
     */
    canActivate(route: ActivatedRouteSnapshot, state: RouterStateSnapshot): Observable<boolean | UrlTree> | Promise<boolean | UrlTree> | boolean | UrlTree;
    static ɵfac: i0.ɵɵFactoryDeclaration<AuthGuardLogin, never>;
    static ɵprov: i0.ɵɵInjectableDeclaration<AuthGuardLogin>;
}
