import { OnDestroy, OnInit } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { ActivatedRoute, Router } from '@angular/router';
import { NGXLogger } from 'ngx-logger';
import { PrimeNGConfig } from 'primeng/api';
import { IsLoadingDataService } from '../../../core/services/is-loading-data/isloadingdata.service';
import { PrgAuthConfig } from '../../models/prg-auth-config';
import { PasswordRequirements } from '../../models/user.model';
import { AbstractAuthService } from '../../services/auth/abstract-auth.service';
import * as i0 from "@angular/core";
/**
 * The form reset password component
 */
export declare class PrgFormResetPasswordComponent implements OnInit, OnDestroy {
    private route;
    private router;
    private logger;
    private authService;
    private primengConfig;
    private authRoutes;
    passwordRequirements: PasswordRequirements;
    isLoadingData: IsLoadingDataService;
    /**
     * The route for login page
     */
    loginPageRoute: string;
    /**
     * Shows/hide the login link.  Default true.
     */
    showLoginLink: boolean;
    /**
     * Shows/hide password on form. Default false.
     */
    showPassword: boolean;
    /**
     * Property of the class with type Form Group which bind to the register form
     */
    resetPasswordForm: FormGroup;
    /**
     * The reset password token taken from route parameters
     */
    private token;
    /**
     * The subscription of the observable of query parameters
     */
    private queryParamsSubscription;
    /**
     * Constructor
     * @param route
     * @param router
     * @param logger
     * @param authService
     * @param primengConfig
     * @param authRoutes
     * @param passwordRequirements passwordRequirements
     * @param isLoadingData isLoadingData
     */
    constructor(route: ActivatedRoute, router: Router, logger: NGXLogger, authService: AbstractAuthService, primengConfig: PrimeNGConfig, authRoutes: PrgAuthConfig, passwordRequirements: PasswordRequirements, isLoadingData: IsLoadingDataService);
    /**
     * ngOnInit
     */
    ngOnInit(): void;
    /**
     * ngOnDestroy
     */
    ngOnDestroy(): void;
    /**
     * Initiate the reset password form and its form controls with validators
     */
    private initFormResetPassword;
    /**
     * Function to display/hide password on click
     */
    onShowPassword(): void;
    /**
     * Form submission
     */
    onSubmitResetPassword(): Promise<void>;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgFormResetPasswordComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgFormResetPasswordComponent, "prg-form-reset-password", never, { "loginPageRoute": "loginPageRoute"; "showLoginLink": "showLoginLink"; }, {}, never, never, false>;
}
