import { OnDestroy, OnInit } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { NGXLogger } from 'ngx-logger';
import { PrimeNGConfig } from 'primeng/api';
import { IsLoadingDataService } from '../../../core/services/is-loading-data/isloadingdata.service';
import { PrgAuthConfig } from '../../models/prg-auth-config';
import { AbstractAuthService } from '../../services/auth/abstract-auth.service';
import * as i0 from "@angular/core";
/**
 * The form request password component
 */
export declare class PrgFormRequestPasswordComponent implements OnInit, OnDestroy {
    private logger;
    private authService;
    private primengConfig;
    private authRoutes;
    isLoadingData: IsLoadingDataService;
    /**
     * Shows/hide the login link.  Default true.
     */
    showLoginLink: boolean;
    /**
     * The default route for login page
     */
    loginPageRoute: string;
    /**
     * Property of the class with type Form Group binding to the request password form
     */
    requestPassForm: FormGroup;
    /**
     * constructor
     * @param logger
     * @param authService
     * @param primengConfig
     * @param authRoutes
     * @param isLoadingData isLoadingData
     */
    constructor(logger: NGXLogger, authService: AbstractAuthService, primengConfig: PrimeNGConfig, authRoutes: PrgAuthConfig, isLoadingData: IsLoadingDataService);
    /**
     * ngOnInit
     */
    ngOnInit(): void;
    /**
     * ngOnDestroy
     */
    ngOnDestroy(): void;
    /**
     * Initiate the request password form and its form controls with validators
     */
    private initFormRequestPass;
    /**
     * Form submission
     */
    onSubmitRequestPassword(): Promise<void>;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgFormRequestPasswordComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgFormRequestPasswordComponent, "prg-form-request-password", never, { "showLoginLink": "showLoginLink"; "loginPageRoute": "loginPageRoute"; }, {}, never, never, false>;
}
