import { OnDestroy, OnInit } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { NGXLogger } from 'ngx-logger';
import { PrimeNGConfig } from 'primeng/api';
import { IsLoadingDataService } from '../../../core/services/is-loading-data/isloadingdata.service';
import { PrgAuthConfig } from '../../models/prg-auth-config';
import { AbstractAuthService } from '../../services/auth/abstract-auth.service';
import * as i0 from "@angular/core";
/**
 * Form Register Component
 */
export declare class PrgFormRegisterComponent implements OnInit, OnDestroy {
    private logger;
    private authService;
    private primengConfig;
    private authRoutes;
    isLoadingData: IsLoadingDataService;
    /**
     * Shows/hide the checkbox terms of use. Default true.
     */
    showTermsOfUse: boolean;
    /**
     * Shows/hide the login link.  Default true.
     */
    showLoginLink: boolean;
    /**
     * The route for login page
     */
    loginPageRoute: string;
    /**
     * The route for terms of use page
     */
    termsOfUsePageRoute: string;
    /**
     * Property of the class with type string which bind to image logo form.
     */
    imagePathLogo: string;
    /**
     * Property of the class with type Form Group binding to the register form
     */
    registerForm: FormGroup;
    /**
     * Constructor
     * @param logger
     * @param authService
     * @param primengConfig
     * @param authRoutes
     * @param isLoadingData isLoadingData
     */
    constructor(logger: NGXLogger, authService: AbstractAuthService, primengConfig: PrimeNGConfig, authRoutes: PrgAuthConfig, isLoadingData: IsLoadingDataService);
    /**
     * ngOnInit
     */
    ngOnInit(): void;
    /**
     * ngOnDestroy
     */
    ngOnDestroy(): void;
    /**
     * Initiate the register form and its form controls with validators
     */
    private initFormRegister;
    /**
     * Form submission
     */
    onSubmitRegister(): Promise<void>;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgFormRegisterComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgFormRegisterComponent, "prg-form-register", never, { "showTermsOfUse": "showTermsOfUse"; "showLoginLink": "showLoginLink"; "loginPageRoute": "loginPageRoute"; "termsOfUsePageRoute": "termsOfUsePageRoute"; "imagePathLogo": "imagePathLogo"; }, {}, never, never, false>;
}
