import { OnDestroy, OnInit } from '@angular/core';
import { FormGroup } from '@angular/forms';
import { Router } from '@angular/router';
import { NGXLogger } from 'ngx-logger';
import { PrimeNGConfig } from 'primeng/api';
import { IsLoadingDataService } from '../../../core/services/is-loading-data/isloadingdata.service';
import { PrgAuthConfig } from '../../models/prg-auth-config';
import { AbstractAuthService } from '../../services/auth/abstract-auth.service';
import * as i0 from "@angular/core";
/**
 * Form Login Component
 */
export declare class PrgFormLoginComponent implements OnInit, OnDestroy {
    logger: NGXLogger;
    authService: AbstractAuthService;
    private primengConfig;
    private authRoutes;
    private router;
    isLoadingData: IsLoadingDataService;
    /**
     * Shows/hide the checkbox to save username on local storage. Default true.
     */
    showStoreUserName: boolean;
    /**
     * Shows/hide the reset password link.  Default true.
     */
    showResetPasswordLink: boolean;
    /**
     * Shows/hide sign up link.  Default true.
     */
    showSignUpRoute: boolean;
    /**
     * The route for signup page
     */
    signUpPageRoute: string;
    /**
     * The route to redirect after login success
     */
    loginOkRedirectLink: string;
    /**
     * The route for request new password
     */
    resetPasswordPageRoute: string;
    /**
     * Property of the class with type string which bind to image logo form.
     */
    imagePathLogo: string;
    /**
     * Shows/hide password on form. Default false.
     */
    showPassword: boolean;
    /**
     * Property of the class with type Form Group which bind to the register form
     */
    loginForm: FormGroup;
    /**
     * Property of the class with type boolean which bind to the checkbox "Remember me"
     */
    checkedStoreUserName: boolean;
    /**
     * constructor
     * @param {NGXLogger} logger logger
     * @param {AbstractAuthService} authService authService
     * @param {PrimeNGConfig} primengConfig
     * @param {PrgAuthConfig} authRoutes
     * @param {Router} router
     * @param {IsLoadingDataService} isLoadingData isLoadingData
     */
    constructor(logger: NGXLogger, authService: AbstractAuthService, primengConfig: PrimeNGConfig, authRoutes: PrgAuthConfig, // GCR: usar sempre o authConfig diretamente sem DI | Resp : Dá um erro de dependencia circular ao utilizar o authConfig
    router: Router, isLoadingData: IsLoadingDataService);
    /**
     * ngOnInit
     */
    ngOnInit(): void;
    /**
     * ngOnDestroy
     */
    ngOnDestroy(): void;
    /**
     * Initiate the login form and its form controls with validators
     */
    private initFormLogin;
    /**
     * Show/Hide the password on login form
     */
    onShowPassword(): void;
    /**
     * Form submission
     */
    onSubmitLogin(): Promise<void>;
    static ɵfac: i0.ɵɵFactoryDeclaration<PrgFormLoginComponent, never>;
    static ɵcmp: i0.ɵɵComponentDeclaration<PrgFormLoginComponent, "prg-form-login", never, { "showStoreUserName": "showStoreUserName"; "showResetPasswordLink": "showResetPasswordLink"; "showSignUpRoute": "showSignUpRoute"; "signUpPageRoute": "signUpPageRoute"; "loginOkRedirectLink": "loginOkRedirectLink"; "resetPasswordPageRoute": "resetPasswordPageRoute"; "imagePathLogo": "imagePathLogo"; }, {}, never, never, false>;
}
