import * as i0 from '@angular/core';
import { InjectionToken, Injectable, Inject, Component, Input, NgModule, Directive, EventEmitter, Output, ViewChild } from '@angular/core';
import * as i3 from '@angular/forms';
import { FormGroup, FormControl, Validators, FormsModule, ReactiveFormsModule, FormArray } from '@angular/forms';
import * as i1 from 'ngx-logger';
import { __decorate, __param } from 'tslib';
import { BehaviorSubject, firstValueFrom, filter, lastValueFrom, map } from 'rxjs';
import * as i7 from 'primeng/api';
import { FilterMatchMode, ConfirmationService } from 'primeng/api';
import * as i1$1 from '@angular/router';
import { RouterModule, ROUTES } from '@angular/router';
import * as i6 from 'primeng/inputtext';
import { InputTextModule } from 'primeng/inputtext';
import * as i1$2 from '@angular/common';
import { CommonModule } from '@angular/common';
import * as i8 from 'primeng/button';
import { ButtonModule } from 'primeng/button';
import * as i9 from 'primeng/checkbox';
import { CheckboxModule } from 'primeng/checkbox';
import * as i10 from 'primeng/image';
import { ImageModule } from 'primeng/image';
import * as i11 from 'primeng/ripple';
import { RippleModule } from 'primeng/ripple';
import * as i5 from '@ngx-translate/core';
import { TranslateModule, TranslateService } from '@ngx-translate/core';
import clone from 'just-clone';
import * as i4$2 from 'primeng/accordion';
import { AccordionModule } from 'primeng/accordion';
import * as i1$c from 'primeng/autocomplete';
import { AutoCompleteModule } from 'primeng/autocomplete';
import * as i1$g from 'primeng/calendar';
import { CalendarModule } from 'primeng/calendar';
import * as i1$d from 'primeng/cascadeselect';
import { CascadeSelectModule } from 'primeng/cascadeselect';
import * as i8$1 from 'primeng/chip';
import { ChipModule } from 'primeng/chip';
import * as i1$e from 'primeng/chips';
import { ChipsModule } from 'primeng/chips';
import * as i1$f from 'primeng/colorpicker';
import { ColorPickerModule } from 'primeng/colorpicker';
import * as i7$1 from 'primeng/confirmdialog';
import { ConfirmDialogModule } from 'primeng/confirmdialog';
import { ContextMenuModule } from 'primeng/contextmenu';
import { DialogModule } from 'primeng/dialog';
import * as i1$5 from 'primeng/dropdown';
import { DropdownModule } from 'primeng/dropdown';
import * as i2 from 'primeng/dynamicdialog';
import { DynamicDialogModule, DialogService, DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { FileUploadModule } from 'primeng/fileupload';
import * as i1$h from 'primeng/inputmask';
import { InputMaskModule } from 'primeng/inputmask';
import * as i1$4 from 'primeng/inputnumber';
import { InputNumberModule } from 'primeng/inputnumber';
import * as i1$6 from 'primeng/inputswitch';
import { InputSwitchModule } from 'primeng/inputswitch';
import * as i4 from 'primeng/inputtextarea';
import { InputTextareaModule } from 'primeng/inputtextarea';
import * as i1$i from 'primeng/knob';
import { KnobModule } from 'primeng/knob';
import * as i1$j from 'primeng/listbox';
import { ListboxModule } from 'primeng/listbox';
import * as i6$3 from 'primeng/menu';
import { MenuModule } from 'primeng/menu';
import { MessageModule } from 'primeng/message';
import * as i1$k from 'primeng/multiselect';
import { MultiSelectModule } from 'primeng/multiselect';
import * as i11$1 from 'primeng/orderlist';
import { OrderListModule } from 'primeng/orderlist';
import * as i1$l from 'primeng/password';
import { PasswordModule } from 'primeng/password';
import * as i9$1 from 'primeng/progressspinner';
import { ProgressSpinnerModule } from 'primeng/progressspinner';
import * as i1$m from 'primeng/radiobutton';
import { RadioButtonModule } from 'primeng/radiobutton';
import * as i1$n from 'primeng/rating';
import { RatingModule } from 'primeng/rating';
import * as i1$7 from 'primeng/selectbutton';
import { SelectButtonModule } from 'primeng/selectbutton';
import { SidebarModule } from 'primeng/sidebar';
import * as i1$o from 'primeng/slider';
import { SliderModule } from 'primeng/slider';
import * as i1$8 from 'primeng/speeddial';
import { SpeedDialModule } from 'primeng/speeddial';
import * as i1$9 from 'primeng/splitbutton';
import { SplitButtonModule } from 'primeng/splitbutton';
import * as i9$2 from 'primeng/splitter';
import { SplitterModule } from 'primeng/splitter';
import * as i10$2 from 'primeng/table';
import { TableModule, Table } from 'primeng/table';
import * as i6$2 from 'primeng/tabmenu';
import { TabMenuModule } from 'primeng/tabmenu';
import * as i6$4 from 'primeng/tieredmenu';
import { TieredMenuModule } from 'primeng/tieredmenu';
import * as i6$1 from 'primeng/toast';
import { ToastModule } from 'primeng/toast';
import * as i1$a from 'primeng/togglebutton';
import { ToggleButtonModule } from 'primeng/togglebutton';
import * as i7$2 from 'primeng/toolbar';
import { ToolbarModule } from 'primeng/toolbar';
import * as i7$3 from 'primeng/tree';
import { TreeModule } from 'primeng/tree';
import * as i10$1 from 'primeng/treetable';
import { TreeTableModule } from 'primeng/treetable';
import * as i1$p from 'primeng/tristatecheckbox';
import { TriStateCheckboxModule } from 'primeng/tristatecheckbox';
import * as i1$3 from '@angular/common/http';
import { HttpClientModule } from '@angular/common/http';
import * as i1$b from 'ng-dynamic-component';
import { DynamicModule, DynamicDirectivesModule } from 'ng-dynamic-component';
import * as i7$4 from 'primeng/tooltip';
import { trigger, state, style, transition, group, query, animate, animateChild } from '@angular/animations';
import * as i4$1 from 'primeng/chart';
import { ChartModule } from 'primeng/chart';
import * as i1$q from '@ionic/angular';
import * as i9$3 from 'angular-gridster2';
import { GridsterModule } from 'angular-gridster2';
import * as i21 from 'primeng/dragdrop';
import { DragDropModule } from 'primeng/dragdrop';
import * as i20 from 'primeng/overlaypanel';
import { OverlayPanelModule } from 'primeng/overlaypanel';

/**
 * Inject token
 */
const PRG_AUTH_CONFIG = new InjectionToken("PRG_AUTH_CONFIG");
/**
 * Injectable
 */
/**
 * PrgCoreConfigurationService class definition
 * <br />that specifies the properties that the
 * <br />application can send to the lib for
 * <br />configuration purposes
 */
class PrgAuthConfigurationService$1 {
    /**
     * Constructor
     *
     * @param prgAuthConfig
     */
    constructor(prgAuthConfig) {
        this.prgAuthConfig = prgAuthConfig;
    }
}
PrgAuthConfigurationService$1.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthConfigurationService$1, deps: [{ token: PRG_AUTH_CONFIG }], target: i0.ɵɵFactoryTarget.Injectable });
PrgAuthConfigurationService$1.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthConfigurationService$1, providedIn: "root" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthConfigurationService$1, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: "root",
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_AUTH_CONFIG]
                }] }]; } });

/**
 * AbstractAuthService class that defines an
 * <br />abstract authentication service to
 * <br />be extended by the mock and real
 * <br />authentication services
 */
let AbstractAuthService = class AbstractAuthService {
    /**
     * constructor
     * @param authStorage
     * @protected
     */
    constructor(authStorage) {
        this.authStorage = authStorage;
        /**
         * Currently logged user
         */
        this.loggedUserSubject = new BehaviorSubject(null);
        /**
         * Currently stored username to be used
         * <br />on the login form
         * // CR: devemos explicar melhor para que serve esta propriedade, eu não estava a perceber até olhar para o código do login,
         *        talvez mudar também o nome para algo mais explicito
         */
        this.storedUserNameSubject = new BehaviorSubject('');
        this.getUserNameFromStorage();
        this.getUserLoggedFromStorage();
    }
    /**
     * Setter for loggedUserSubject
     *
     * @param {User} userLogged The User object
     */
    setLoggedUser(userLogged) {
        // CR: falta guardar isto na storage (session ou local), não?
        this.authStorage.storage.setItem(this.authStorage.keyLoggedUser, JSON.stringify(userLogged));
        this.loggedUserSubject.next(userLogged);
    }
    /**
     * Setter for storedUserNameSubject and saving username on local storage
     *
     * @param {string} value The storedUserName string
     */
    setStoredUserName(value) {
        // ok CR: falta guardar isto na storage (session ou local), não?
        this.authStorage.storage.setItem(this.authStorage.keyStoredUserName, JSON.stringify(value));
        this.storedUserNameSubject.next(value);
    }
    /**
     * Remove username from local storage
     *
     */
    removeStoredUserName() {
        this.authStorage.storage.removeItem(this.authStorage.keyStoredUserName);
        this.storedUserNameSubject.next(null);
    }
    /**
     * Getter for loggedUserSubject
     *
     * @returns The loggedUserSubject as an observable
     */
    getLoggedUserObservable() {
        return this.loggedUserSubject.asObservable();
    }
    /**
     * Getter for loggedUserSubject
     *
     * @returns The loggedUserSubject current value
     */
    getLoggedUser() {
        return this.loggedUserSubject.getValue();
    }
    /**
     * Getter for storedUserNameSubject
     *
     * @returns The storedUserNameSubject as an observable
     */
    getStoredUserNameObservable() {
        return this.storedUserNameSubject.asObservable();
    }
    /**
     * Getter for storedUserNameSubject
     *
     * @returns The storedUserNameSubject current value
     */
    getStoredUserName() {
        return this.storedUserNameSubject.getValue();
    }
    /**
     * Get username from local storage and if it exists,
     *  the value is emitted on storedUserNameSubject
     */
    getUserNameFromStorage() {
        const userName = JSON.parse(this.authStorage.storage.getItem(this.authStorage.keyStoredUserName));
        if (userName == null || userName.length == 0) {
            return;
        }
        else {
            this.setStoredUserName(userName);
        }
    }
    /**
     * Get the user logged from local storage
     * @private
     */
    getUserLoggedFromStorage() {
        const user = JSON.parse(this.authStorage.storage.getItem(this.authStorage.keyLoggedUser));
        if (user == null) {
            return;
        }
        else {
            this.setLoggedUser(user);
        }
    }
    /**
     * User logout Base Method (Async)
     *
     * @returns Boolean promise, true when successful
     */
    baseLogoutAsync() {
        return new Promise((resolve) => {
            this.authStorage.storage.removeItem(this.authStorage.keyLoggedUser);
            this.setLoggedUser(null);
            resolve(true);
        });
    }
};
AbstractAuthService = __decorate([
    __param(0, Inject('AUTHSTORAGE'))
], AbstractAuthService);

/**
 * injectable
 */
class IsLoadingDataService {
    constructor() {
        /**
         * visibility BehaviorSubject
         */
        this.visibility = new BehaviorSubject(false);
    }
    /**
     * this function change visibility to true
     */
    show() {
        this.visibility.next(true);
    }
    /**
     * this function change visibility to false
     */
    hide() {
        this.visibility.next(false);
    }
}
IsLoadingDataService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: IsLoadingDataService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
IsLoadingDataService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: IsLoadingDataService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: IsLoadingDataService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }] });

/**
 * Form Login Component
 */
class PrgFormLoginComponent {
    // GCR: strings devem ser pelicas ('') em vez de aspas (""). está configurad no pretier devemos correr um comando para correr o pretier em todos os ficheiros
    /**
     * constructor
     * @param {NGXLogger} logger logger
     * @param {AbstractAuthService} authService authService
     * @param {PrimeNGConfig} primengConfig
     * @param {PrgAuthConfig} authRoutes
     * @param {Router} router
     * @param {IsLoadingDataService} isLoadingData isLoadingData
     */
    constructor(logger, authService, primengConfig, authRoutes, // GCR: usar sempre o authConfig diretamente sem DI | Resp : Dá um erro de dependencia circular ao utilizar o authConfig
    router, isLoadingData) {
        this.logger = logger;
        this.authService = authService;
        this.primengConfig = primengConfig;
        this.authRoutes = authRoutes;
        this.router = router;
        this.isLoadingData = isLoadingData;
        /**
         * Shows/hide the checkbox to save username on local storage. Default true.
         */
        this.showStoreUserName = true;
        /**
         * Shows/hide the reset password link.  Default true.
         */
        this.showResetPasswordLink = true;
        /**
         * Shows/hide sign up link.  Default true.
         */
        this.showSignUpRoute = true;
        /**
         * The route for signup page
         */
        this.signUpPageRoute = '/' +
            this.authRoutes.authRoutingBasePath +
            '/' +
            this.authRoutes.authRoutingSignupPath;
        /**
         * The route to redirect after login success
         */
        this.loginOkRedirectLink = '/' + this.authRoutes.authRoutingLoginOkRedirectPath;
        /**
         * The route for request new password
         */
        this.resetPasswordPageRoute = '/' +
            this.authRoutes.authRoutingBasePath +
            '/' +
            this.authRoutes.authRoutingRequestPasswordPath;
        /**
         * Property of the class with type string which bind to image logo form.
         */
        this.imagePathLogo = '';
        /**
         * Shows/hide password on form. Default false.
         */
        this.showPassword = false;
        /**
         * Property of the class with type boolean which bind to the checkbox "Remember me"
         */
        this.checkedStoreUserName = false;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.logger.debug('LOGIN FORM ON INIT');
        this.initFormLogin();
        this.authService.getStoredUserNameObservable().subscribe((userEmail) => {
            if (userEmail) {
                this.loginForm.controls['email'].setValue(userEmail);
                this.checkedStoreUserName = true;
            }
        });
        this.primengConfig.ripple = true;
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.logger.debug('LOGIN FORM ON DESTROY');
    }
    /**
     * Initiate the login form and its form controls with validators
     */
    initFormLogin() {
        this.loginForm = new FormGroup({
            email: new FormControl(null, [Validators.required]),
            check: new FormControl(),
            password: new FormControl(null, [Validators.required]),
            storeUserName: new FormControl(null),
        }, { updateOn: 'change' });
    }
    /**
     * Show/Hide the password on login form
     */
    onShowPassword() {
        this.showPassword = !this.showPassword;
    }
    /**
     * Form submission
     */
    async onSubmitLogin() {
        if (this.loginForm.invalid) {
            return;
        }
        const userEmail = this.loginForm.controls.email.value;
        const userPassword = this.loginForm.controls.password.value;
        const storeUserName = this.loginForm.controls.storeUserName.value;
        this.loginForm.disable();
        try {
            if (await this.authService.loginAsync(userEmail, userPassword, storeUserName)) {
                this.loginForm.reset();
                await this.router.navigate([this.loginOkRedirectLink]);
            }
        }
        catch (error) {
            this.logger.debug(error);
        }
        this.loginForm.enable();
    }
}
PrgFormLoginComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormLoginComponent, deps: [{ token: i1.NGXLogger }, { token: AbstractAuthService }, { token: i7.PrimeNGConfig }, { token: PRG_AUTH_CONFIG }, { token: i1$1.Router }, { token: IsLoadingDataService }], target: i0.ɵɵFactoryTarget.Component });
PrgFormLoginComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgFormLoginComponent, selector: "prg-form-login", inputs: { showStoreUserName: "showStoreUserName", showResetPasswordLink: "showResetPasswordLink", showSignUpRoute: "showSignUpRoute", signUpPageRoute: "signUpPageRoute", loginOkRedirectLink: "loginOkRedirectLink", resetPasswordPageRoute: "resetPasswordPageRoute", imagePathLogo: "imagePathLogo" }, ngImport: i0, template: "<div class=\"flex justify-content-center\">\r\n  <div\r\n    class=\"mainContainer shadow-3 border-1 border-300 surface-card border-round-lg w-28rem\"\r\n  >\r\n    <form\r\n      [formGroup]=\"loginForm\"\r\n      (ngSubmit)=\"onSubmitLogin()\"\r\n      novalidate\r\n      autocomplete=\"off\"\r\n    >\r\n      <div\r\n        class=\"text-center\"\r\n        [class]=\"{ 'my-3': imagePathLogo, 'my-1': !imagePathLogo }\"\r\n      >\r\n        <p-image [src]=\"imagePathLogo\" class=\"w-8\" alt=\"\"></p-image>\r\n      </div>\r\n      <div\r\n        class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 mb-4 text-center\"\r\n      >\r\n        {{ 'components.login.title' | translate | uppercase }}\r\n      </div>\r\n      <div class=\"px-5 mb-4\">\r\n        <h6 class=\"text-700\">\r\n          {{\r\n            ('entities.user.fields.email.label' | translate) +\r\n              ' ou ' +\r\n              ('entities.user.fields.token.unique_name.label'\r\n                | translate\r\n                | lowercase)\r\n          }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i class=\"bi bi-envelope\"></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.email.placeholder' | translate) +\r\n                ' ou ' +\r\n                ('entities.user.fields.token.unique_name.label'\r\n                  | translate\r\n                  | lowercase) +\r\n                '...'\r\n            }}\"\r\n            formControlName=\"email\"\r\n            id=\"email\"\r\n            autocomplete=\"off\"\r\n            autofocus\r\n            type=\"email\"\r\n            class=\"w-full\"\r\n            pInputText\r\n            [defaultValue]=\"authService.getStoredUserName()\"\r\n        /></span>\r\n        <div\r\n          class=\"flex flex-column mt-2\"\r\n          *ngIf=\"\r\n            loginForm.controls.email.touched && loginForm.controls.email.dirty\r\n          \"\r\n        >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"loginForm.controls.email.hasError('required')\"\r\n            >Email or username is required.</small\r\n          >\r\n        </div>\r\n      </div>\r\n      <div\r\n        class=\"px-5\"\r\n        [class]=\"{\r\n          'mb-3': showStoreUserName && showResetPasswordLink,\r\n          'mb-4': !showStoreUserName || !showResetPasswordLink\r\n        }\"\r\n      >\r\n        <h6 class=\"text-700\">\r\n          {{ 'entities.user.fields.password.label' | translate }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i\r\n            class=\"pi pi-lock\"\r\n            (click)=\"onShowPassword()\"\r\n            style=\"cursor: pointer\"\r\n          ></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.password.placeholder' | translate) + '...'\r\n            }}\"\r\n            formControlName=\"password\"\r\n            id=\"password\"\r\n            autocomplete=\"off\"\r\n            [type]=\"showPassword ? 'text' : 'password'\"\r\n            class=\"w-full\"\r\n            pInputText\r\n        /></span>\r\n        <div\r\n          class=\"flex flex-column mt-2\"\r\n          *ngIf=\"\r\n            loginForm.controls.password.touched &&\r\n            loginForm.controls.password.dirty\r\n          \"\r\n        >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"loginForm.controls.password.hasError('required')\"\r\n            >Password is required.</small\r\n          >\r\n        </div>\r\n      </div>\r\n\r\n      <div class=\"flex justify-content-between flex-wrap px-5 mb-4\">\r\n        <div\r\n          class=\"field-checkbox flex align-items-center justify-content-center\"\r\n          *ngIf=\"showStoreUserName\"\r\n        >\r\n          <p-checkbox\r\n            [(ngModel)]=\"checkedStoreUserName\"\r\n            formControlName=\"storeUserName\"\r\n            [binary]=\"true\"\r\n            inputId=\"storeUserName\"\r\n          ></p-checkbox>\r\n          <label for=\"storeUserName\" class=\"text-600 text-sm\">{{\r\n            'components.login.remember-me.label' | translate\r\n          }}</label>\r\n        </div>\r\n        <div\r\n          class=\"field flex align-items-center justify-content-center\"\r\n          *ngIf=\"showResetPasswordLink\"\r\n        >\r\n          <a\r\n            [style.pointer-events]=\"\r\n              (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n            \"\r\n            routerLink=\"{{\r\n              !(isLoadingData.visibility | async) ? resetPasswordPageRoute : ''\r\n            }}\"\r\n            class=\"underlineEffect text-sm blue-500 font-medium ml-1 cursor-pointer\"\r\n            style=\"text-decoration: none\"\r\n            >{{ 'components.login.forget-password-link.label' | translate }}</a\r\n          >\r\n        </div>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\">\r\n        <button\r\n          type=\"submit\"\r\n          [disabled]=\"!loginForm.valid || (isLoadingData.visibility | async)\"\r\n          pButton\r\n          pRipple\r\n          label=\"{{ 'components.login.button.label' | translate }}\"\r\n          icon=\"pi pi-unlock\"\r\n          class=\"w-full\"\r\n        ></button>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\" *ngIf=\"showSignUpRoute\">\r\n        <label class=\"text-600 text-sm\">{{\r\n          'components.login.question-account.label' | translate\r\n        }}</label>\r\n        <a\r\n          [style.pointer-events]=\"\r\n            (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n          \"\r\n          routerLink=\"{{ signUpPageRoute }}\"\r\n          class=\"underlineEffect text-sm blue-500 font-medium ml-1 text-right cursor-pointer\"\r\n          style=\"text-decoration: none\"\r\n          >{{ 'components.login.signup-link.label' | translate }}</a\r\n        >\r\n      </div>\r\n    </form>\r\n  </div>\r\n</div>\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:Hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"], dependencies: [{ kind: "directive", type: i1$1.RouterLinkWithHref, selector: "a[routerLink],area[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "state", "relativeTo", "preserveFragment", "skipLocationChange", "replaceUrl", "routerLink"] }, { kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i9.Checkbox, selector: "p-checkbox", inputs: ["value", "name", "disabled", "binary", "label", "ariaLabelledBy", "ariaLabel", "tabindex", "inputId", "style", "styleClass", "labelStyleClass", "formControl", "checkboxIcon", "readonly", "required", "trueValue", "falseValue"], outputs: ["onChange"] }, { kind: "component", type: i10.Image, selector: "p-image", inputs: ["imageClass", "imageStyle", "styleClass", "style", "src", "alt", "width", "height", "appendTo", "preview", "showTransitionOptions", "hideTransitionOptions"], outputs: ["onShow", "onHide", "onImageError"] }, { kind: "directive", type: i11.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i3.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "pipe", type: i1$2.AsyncPipe, name: "async" }, { kind: "pipe", type: i1$2.UpperCasePipe, name: "uppercase" }, { kind: "pipe", type: i1$2.LowerCasePipe, name: "lowercase" }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormLoginComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-form-login', template: "<div class=\"flex justify-content-center\">\r\n  <div\r\n    class=\"mainContainer shadow-3 border-1 border-300 surface-card border-round-lg w-28rem\"\r\n  >\r\n    <form\r\n      [formGroup]=\"loginForm\"\r\n      (ngSubmit)=\"onSubmitLogin()\"\r\n      novalidate\r\n      autocomplete=\"off\"\r\n    >\r\n      <div\r\n        class=\"text-center\"\r\n        [class]=\"{ 'my-3': imagePathLogo, 'my-1': !imagePathLogo }\"\r\n      >\r\n        <p-image [src]=\"imagePathLogo\" class=\"w-8\" alt=\"\"></p-image>\r\n      </div>\r\n      <div\r\n        class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 mb-4 text-center\"\r\n      >\r\n        {{ 'components.login.title' | translate | uppercase }}\r\n      </div>\r\n      <div class=\"px-5 mb-4\">\r\n        <h6 class=\"text-700\">\r\n          {{\r\n            ('entities.user.fields.email.label' | translate) +\r\n              ' ou ' +\r\n              ('entities.user.fields.token.unique_name.label'\r\n                | translate\r\n                | lowercase)\r\n          }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i class=\"bi bi-envelope\"></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.email.placeholder' | translate) +\r\n                ' ou ' +\r\n                ('entities.user.fields.token.unique_name.label'\r\n                  | translate\r\n                  | lowercase) +\r\n                '...'\r\n            }}\"\r\n            formControlName=\"email\"\r\n            id=\"email\"\r\n            autocomplete=\"off\"\r\n            autofocus\r\n            type=\"email\"\r\n            class=\"w-full\"\r\n            pInputText\r\n            [defaultValue]=\"authService.getStoredUserName()\"\r\n        /></span>\r\n        <div\r\n          class=\"flex flex-column mt-2\"\r\n          *ngIf=\"\r\n            loginForm.controls.email.touched && loginForm.controls.email.dirty\r\n          \"\r\n        >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"loginForm.controls.email.hasError('required')\"\r\n            >Email or username is required.</small\r\n          >\r\n        </div>\r\n      </div>\r\n      <div\r\n        class=\"px-5\"\r\n        [class]=\"{\r\n          'mb-3': showStoreUserName && showResetPasswordLink,\r\n          'mb-4': !showStoreUserName || !showResetPasswordLink\r\n        }\"\r\n      >\r\n        <h6 class=\"text-700\">\r\n          {{ 'entities.user.fields.password.label' | translate }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i\r\n            class=\"pi pi-lock\"\r\n            (click)=\"onShowPassword()\"\r\n            style=\"cursor: pointer\"\r\n          ></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.password.placeholder' | translate) + '...'\r\n            }}\"\r\n            formControlName=\"password\"\r\n            id=\"password\"\r\n            autocomplete=\"off\"\r\n            [type]=\"showPassword ? 'text' : 'password'\"\r\n            class=\"w-full\"\r\n            pInputText\r\n        /></span>\r\n        <div\r\n          class=\"flex flex-column mt-2\"\r\n          *ngIf=\"\r\n            loginForm.controls.password.touched &&\r\n            loginForm.controls.password.dirty\r\n          \"\r\n        >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"loginForm.controls.password.hasError('required')\"\r\n            >Password is required.</small\r\n          >\r\n        </div>\r\n      </div>\r\n\r\n      <div class=\"flex justify-content-between flex-wrap px-5 mb-4\">\r\n        <div\r\n          class=\"field-checkbox flex align-items-center justify-content-center\"\r\n          *ngIf=\"showStoreUserName\"\r\n        >\r\n          <p-checkbox\r\n            [(ngModel)]=\"checkedStoreUserName\"\r\n            formControlName=\"storeUserName\"\r\n            [binary]=\"true\"\r\n            inputId=\"storeUserName\"\r\n          ></p-checkbox>\r\n          <label for=\"storeUserName\" class=\"text-600 text-sm\">{{\r\n            'components.login.remember-me.label' | translate\r\n          }}</label>\r\n        </div>\r\n        <div\r\n          class=\"field flex align-items-center justify-content-center\"\r\n          *ngIf=\"showResetPasswordLink\"\r\n        >\r\n          <a\r\n            [style.pointer-events]=\"\r\n              (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n            \"\r\n            routerLink=\"{{\r\n              !(isLoadingData.visibility | async) ? resetPasswordPageRoute : ''\r\n            }}\"\r\n            class=\"underlineEffect text-sm blue-500 font-medium ml-1 cursor-pointer\"\r\n            style=\"text-decoration: none\"\r\n            >{{ 'components.login.forget-password-link.label' | translate }}</a\r\n          >\r\n        </div>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\">\r\n        <button\r\n          type=\"submit\"\r\n          [disabled]=\"!loginForm.valid || (isLoadingData.visibility | async)\"\r\n          pButton\r\n          pRipple\r\n          label=\"{{ 'components.login.button.label' | translate }}\"\r\n          icon=\"pi pi-unlock\"\r\n          class=\"w-full\"\r\n        ></button>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\" *ngIf=\"showSignUpRoute\">\r\n        <label class=\"text-600 text-sm\">{{\r\n          'components.login.question-account.label' | translate\r\n        }}</label>\r\n        <a\r\n          [style.pointer-events]=\"\r\n            (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n          \"\r\n          routerLink=\"{{ signUpPageRoute }}\"\r\n          class=\"underlineEffect text-sm blue-500 font-medium ml-1 text-right cursor-pointer\"\r\n          style=\"text-decoration: none\"\r\n          >{{ 'components.login.signup-link.label' | translate }}</a\r\n        >\r\n      </div>\r\n    </form>\r\n  </div>\r\n</div>\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:Hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.NGXLogger }, { type: AbstractAuthService }, { type: i7.PrimeNGConfig }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_AUTH_CONFIG]
                }] }, { type: i1$1.Router }, { type: IsLoadingDataService }]; }, propDecorators: { showStoreUserName: [{
                type: Input
            }], showResetPasswordLink: [{
                type: Input
            }], showSignUpRoute: [{
                type: Input
            }], signUpPageRoute: [{
                type: Input
            }], loginOkRedirectLink: [{
                type: Input
            }], resetPasswordPageRoute: [{
                type: Input
            }], imagePathLogo: [{
                type: Input
            }] } });

/**
 * Form Register Component
 */
class PrgFormRegisterComponent {
    /**
     * Constructor
     * @param logger
     * @param authService
     * @param primengConfig
     * @param authRoutes
     * @param isLoadingData isLoadingData
     */
    constructor(logger, authService, primengConfig, authRoutes, isLoadingData) {
        this.logger = logger;
        this.authService = authService;
        this.primengConfig = primengConfig;
        this.authRoutes = authRoutes;
        this.isLoadingData = isLoadingData;
        /**
         * Shows/hide the checkbox terms of use. Default true.
         */
        this.showTermsOfUse = true;
        /**
         * Shows/hide the login link.  Default true.
         */
        this.showLoginLink = true;
        /**
         * The route for login page
         */
        this.loginPageRoute = '/' +
            this.authRoutes.authRoutingBasePath +
            '/' +
            this.authRoutes.authRoutingLoginPath;
        /**
         * The route for terms of use page
         */
        this.termsOfUsePageRoute = '/' + this.authRoutes.termsOfUseRoutingPath;
        /**
         * Property of the class with type string which bind to image logo form.
         */
        this.imagePathLogo = '';
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.logger.debug('REGISTER FORM ON INIT');
        this.primengConfig.ripple = true;
        this.initFormRegister();
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.logger.debug('REGISTER FORM ON DESTROY');
    }
    /**
     * Initiate the register form and its form controls with validators
     */
    initFormRegister() {
        this.registerForm = new FormGroup({
            email: new FormControl(null, [Validators.required, Validators.email]),
            termsOfUse: new FormControl(null, [Validators.requiredTrue]),
        }, { updateOn: 'change' });
        if (!this.showTermsOfUse) {
            this.registerForm.controls.termsOfUse.removeValidators(Validators.requiredTrue);
        }
    }
    /**
     * Form submission
     */
    async onSubmitRegister() {
        if (this.registerForm.invalid) {
            return;
        }
        const userEmail = this.registerForm.controls.email.value;
        this.registerForm.disable();
        try {
            if (await this.authService.signupAsync(userEmail)) {
                this.registerForm.reset();
                // TODO: Falta reencaminhar o user após sucesso no registo .Rota??
            }
        }
        catch (error) {
            this.logger.debug(error);
        }
        this.registerForm.enable();
    }
}
PrgFormRegisterComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormRegisterComponent, deps: [{ token: i1.NGXLogger }, { token: AbstractAuthService }, { token: i7.PrimeNGConfig }, { token: PRG_AUTH_CONFIG }, { token: IsLoadingDataService }], target: i0.ɵɵFactoryTarget.Component });
PrgFormRegisterComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgFormRegisterComponent, selector: "prg-form-register", inputs: { showTermsOfUse: "showTermsOfUse", showLoginLink: "showLoginLink", loginPageRoute: "loginPageRoute", termsOfUsePageRoute: "termsOfUsePageRoute", imagePathLogo: "imagePathLogo" }, ngImport: i0, template: "<div class=\"flex justify-content-center\">\r\n  <div\r\n    class=\"mainContainer shadow-3 border-1 border-300 surface-card border-round-lg w-28rem\"\r\n  >\r\n    <form [formGroup]=\"registerForm\" (ngSubmit)=\"onSubmitRegister()\" novalidate>\r\n      <div\r\n        class=\"text-center\"\r\n        [class]=\"{ 'my-3': imagePathLogo, 'my-1': !imagePathLogo }\"\r\n      >\r\n        <p-image [src]=\"imagePathLogo\" class=\"w-8\" alt=\"\"></p-image>\r\n      </div>\r\n      <div\r\n        class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 mb-4 text-center\"\r\n      >\r\n        {{ 'components.register.title' | translate | uppercase }}\r\n      </div>\r\n      <div\r\n        class=\"px-5\"\r\n        [class]=\"{ 'mb-3': showTermsOfUse, 'mb-4': !showTermsOfUse }\"\r\n      >\r\n        <h6 class=\"text-700\">\r\n          {{ 'entities.user.fields.email.label' | translate }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i class=\"bi bi-envelope\"></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.email.placeholder' | translate) + '...'\r\n            }}\"\r\n            formControlName=\"email\"\r\n            id=\"email\"\r\n            autofocus\r\n            autocomplete=\"email\"\r\n            type=\"email\"\r\n            class=\"w-full\"\r\n            pInputText\r\n        /></span>\r\n        <div\r\n          class=\"flex flex-column mt-2\"\r\n          *ngIf=\"\r\n            registerForm.controls.email.touched &&\r\n            registerForm.controls.email.dirty\r\n          \"\r\n        >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"registerForm.controls.email.hasError('required')\"\r\n            >Email is required.</small\r\n          >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"registerForm.controls.email.hasError('email')\"\r\n            >Email is not valid.</small\r\n          >\r\n        </div>\r\n      </div>\r\n      <div class=\"flex align-items-center px-5 mb-4\" *ngIf=\"showTermsOfUse\">\r\n        <div class=\"field-checkbox\">\r\n          <p-checkbox\r\n            formControlName=\"termsOfUse\"\r\n            [binary]=\"true\"\r\n            inputId=\"termsOfUse\"\r\n          ></p-checkbox>\r\n          <label for=\"termsOfUse\" class=\"text-600 text-sm\">{{\r\n            'components.register.agree-terms.label' | translate\r\n          }}</label>\r\n          <a\r\n            [style.pointer-events]=\"\r\n              (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n            \"\r\n            routerLink=\"{{ termsOfUsePageRoute }}\"\r\n            class=\"underlineEffect text-sm blue-500 font-medium ml-1 text-right cursor-pointer\"\r\n            style=\"text-decoration: none\"\r\n            >{{ 'components.register.terms-link.label' | translate }}</a\r\n          >\r\n        </div>\r\n      </div>\r\n      <div class=\"px-5 mb-4 text-center\">\r\n        <button\r\n          type=\"submit\"\r\n          [disabled]=\"!registerForm.valid || (isLoadingData.visibility | async)\"\r\n          pButton\r\n          pRipple\r\n          label=\"{{ 'components.register.button.label' | translate }}\"\r\n          icon=\"pi pi-user\"\r\n          class=\"w-full\"\r\n        ></button>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\" *ngIf=\"showLoginLink\">\r\n        <label class=\"text-600 text-sm\">{{\r\n          'components.register.question-account.label' | translate\r\n        }}</label>\r\n        <a\r\n          routerLink=\"{{ loginPageRoute }}\"\r\n          [style.pointer-events]=\"\r\n            (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n          \"\r\n          class=\"underlineEffect text-sm blue-500 font-medium ml-1 text-right cursor-pointer\"\r\n          style=\"text-decoration: none\"\r\n          >{{ 'components.register.login-link.label' | translate }}</a\r\n        >\r\n      </div>\r\n    </form>\r\n  </div>\r\n</div>\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"], dependencies: [{ kind: "directive", type: i1$1.RouterLinkWithHref, selector: "a[routerLink],area[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "state", "relativeTo", "preserveFragment", "skipLocationChange", "replaceUrl", "routerLink"] }, { kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i9.Checkbox, selector: "p-checkbox", inputs: ["value", "name", "disabled", "binary", "label", "ariaLabelledBy", "ariaLabel", "tabindex", "inputId", "style", "styleClass", "labelStyleClass", "formControl", "checkboxIcon", "readonly", "required", "trueValue", "falseValue"], outputs: ["onChange"] }, { kind: "component", type: i10.Image, selector: "p-image", inputs: ["imageClass", "imageStyle", "styleClass", "style", "src", "alt", "width", "height", "appendTo", "preview", "showTransitionOptions", "hideTransitionOptions"], outputs: ["onShow", "onHide", "onImageError"] }, { kind: "directive", type: i11.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i3.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "pipe", type: i1$2.AsyncPipe, name: "async" }, { kind: "pipe", type: i1$2.UpperCasePipe, name: "uppercase" }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormRegisterComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-form-register', template: "<div class=\"flex justify-content-center\">\r\n  <div\r\n    class=\"mainContainer shadow-3 border-1 border-300 surface-card border-round-lg w-28rem\"\r\n  >\r\n    <form [formGroup]=\"registerForm\" (ngSubmit)=\"onSubmitRegister()\" novalidate>\r\n      <div\r\n        class=\"text-center\"\r\n        [class]=\"{ 'my-3': imagePathLogo, 'my-1': !imagePathLogo }\"\r\n      >\r\n        <p-image [src]=\"imagePathLogo\" class=\"w-8\" alt=\"\"></p-image>\r\n      </div>\r\n      <div\r\n        class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 mb-4 text-center\"\r\n      >\r\n        {{ 'components.register.title' | translate | uppercase }}\r\n      </div>\r\n      <div\r\n        class=\"px-5\"\r\n        [class]=\"{ 'mb-3': showTermsOfUse, 'mb-4': !showTermsOfUse }\"\r\n      >\r\n        <h6 class=\"text-700\">\r\n          {{ 'entities.user.fields.email.label' | translate }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i class=\"bi bi-envelope\"></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.email.placeholder' | translate) + '...'\r\n            }}\"\r\n            formControlName=\"email\"\r\n            id=\"email\"\r\n            autofocus\r\n            autocomplete=\"email\"\r\n            type=\"email\"\r\n            class=\"w-full\"\r\n            pInputText\r\n        /></span>\r\n        <div\r\n          class=\"flex flex-column mt-2\"\r\n          *ngIf=\"\r\n            registerForm.controls.email.touched &&\r\n            registerForm.controls.email.dirty\r\n          \"\r\n        >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"registerForm.controls.email.hasError('required')\"\r\n            >Email is required.</small\r\n          >\r\n          <small\r\n            class=\"p-error w-max\"\r\n            *ngIf=\"registerForm.controls.email.hasError('email')\"\r\n            >Email is not valid.</small\r\n          >\r\n        </div>\r\n      </div>\r\n      <div class=\"flex align-items-center px-5 mb-4\" *ngIf=\"showTermsOfUse\">\r\n        <div class=\"field-checkbox\">\r\n          <p-checkbox\r\n            formControlName=\"termsOfUse\"\r\n            [binary]=\"true\"\r\n            inputId=\"termsOfUse\"\r\n          ></p-checkbox>\r\n          <label for=\"termsOfUse\" class=\"text-600 text-sm\">{{\r\n            'components.register.agree-terms.label' | translate\r\n          }}</label>\r\n          <a\r\n            [style.pointer-events]=\"\r\n              (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n            \"\r\n            routerLink=\"{{ termsOfUsePageRoute }}\"\r\n            class=\"underlineEffect text-sm blue-500 font-medium ml-1 text-right cursor-pointer\"\r\n            style=\"text-decoration: none\"\r\n            >{{ 'components.register.terms-link.label' | translate }}</a\r\n          >\r\n        </div>\r\n      </div>\r\n      <div class=\"px-5 mb-4 text-center\">\r\n        <button\r\n          type=\"submit\"\r\n          [disabled]=\"!registerForm.valid || (isLoadingData.visibility | async)\"\r\n          pButton\r\n          pRipple\r\n          label=\"{{ 'components.register.button.label' | translate }}\"\r\n          icon=\"pi pi-user\"\r\n          class=\"w-full\"\r\n        ></button>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\" *ngIf=\"showLoginLink\">\r\n        <label class=\"text-600 text-sm\">{{\r\n          'components.register.question-account.label' | translate\r\n        }}</label>\r\n        <a\r\n          routerLink=\"{{ loginPageRoute }}\"\r\n          [style.pointer-events]=\"\r\n            (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n          \"\r\n          class=\"underlineEffect text-sm blue-500 font-medium ml-1 text-right cursor-pointer\"\r\n          style=\"text-decoration: none\"\r\n          >{{ 'components.register.login-link.label' | translate }}</a\r\n        >\r\n      </div>\r\n    </form>\r\n  </div>\r\n</div>\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.NGXLogger }, { type: AbstractAuthService }, { type: i7.PrimeNGConfig }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_AUTH_CONFIG]
                }] }, { type: IsLoadingDataService }]; }, propDecorators: { showTermsOfUse: [{
                type: Input
            }], showLoginLink: [{
                type: Input
            }], loginPageRoute: [{
                type: Input
            }], termsOfUsePageRoute: [{
                type: Input
            }], imagePathLogo: [{
                type: Input
            }] } });

/**
 * The form request password component
 */
class PrgFormRequestPasswordComponent {
    /**
     * constructor
     * @param logger
     * @param authService
     * @param primengConfig
     * @param authRoutes
     * @param isLoadingData isLoadingData
     */
    constructor(logger, authService, primengConfig, authRoutes, isLoadingData) {
        this.logger = logger;
        this.authService = authService;
        this.primengConfig = primengConfig;
        this.authRoutes = authRoutes;
        this.isLoadingData = isLoadingData;
        /**
         * Shows/hide the login link.  Default true.
         */
        this.showLoginLink = true;
        /**
         * The default route for login page
         */
        this.loginPageRoute = '/' +
            this.authRoutes.authRoutingBasePath +
            '/' +
            this.authRoutes.authRoutingLoginPath;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.logger.debug('REQUEST PASSWORD PAGE ON INIT');
        this.primengConfig.ripple = true;
        this.initFormRequestPass();
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.logger.debug('REQUEST PASSWORD PAGE ON DESTROY');
    }
    /**
     * Initiate the request password form and its form controls with validators
     */
    initFormRequestPass() {
        this.requestPassForm = new FormGroup({
            email: new FormControl(null, [Validators.required, Validators.email]),
        }, { updateOn: 'change' });
    }
    /**
     * Form submission
     */
    async onSubmitRequestPassword() {
        if (this.requestPassForm.invalid) {
            return;
        }
        const userEmail = this.requestPassForm.controls.email.value;
        this.requestPassForm.disable();
        try {
            if (await this.authService.requestResetPasswordAsync(userEmail)) {
                this.requestPassForm.reset();
                // TODO: Falta reencaminhar o user após pedido do reset da password .Rota??
            }
        }
        catch (error) {
            this.logger.debug(error);
        }
        this.requestPassForm.enable();
    }
}
PrgFormRequestPasswordComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormRequestPasswordComponent, deps: [{ token: i1.NGXLogger }, { token: AbstractAuthService }, { token: i7.PrimeNGConfig }, { token: PRG_AUTH_CONFIG }, { token: IsLoadingDataService }], target: i0.ɵɵFactoryTarget.Component });
PrgFormRequestPasswordComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgFormRequestPasswordComponent, selector: "prg-form-request-password", inputs: { showLoginLink: "showLoginLink", loginPageRoute: "loginPageRoute" }, ngImport: i0, template: "<div class=\"flex justify-content-center\">\r\n  <div\r\n    class=\"mainContainer shadow-3 border-1 border-300 surface-card border-round-lg w-28rem\"\r\n  >\r\n    <form\r\n      [formGroup]=\"requestPassForm\"\r\n      (ngSubmit)=\"onSubmitRequestPassword()\"\r\n      novalidate\r\n    >\r\n      <div\r\n        class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 my-4 text-center\"\r\n      >\r\n        {{ 'components.request-password.title' | translate | uppercase }}\r\n      </div>\r\n      <div class=\"px-5 mb-5\">\r\n        <h6 class=\"text-700\">\r\n          {{ 'entities.user.fields.email.label' | translate }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i class=\"bi bi-envelope\"></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.email.placeholder' | translate) + '...'\r\n            }}\"\r\n            formControlName=\"email\"\r\n            id=\"email\"\r\n            autofocus\r\n            autocomplete=\"email\"\r\n            type=\"email\"\r\n            class=\"w-full\"\r\n            pInputText\r\n        /></span>\r\n      </div>\r\n      <div class=\"px-5 text-center mb-3\">\r\n        <button\r\n          type=\"submit\"\r\n          [disabled]=\"\r\n            !requestPassForm.valid || (isLoadingData.visibility | async)\r\n          \"\r\n          pButton\r\n          pRipple\r\n          label=\"{{ 'components.request-password.button.label' | translate }}\"\r\n          icon=\"pi pi-lock\"\r\n          class=\"w-full\"\r\n        ></button>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\" *ngIf=\"showLoginLink\">\r\n        <a\r\n          [style.pointer-events]=\"\r\n            (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n          \"\r\n          routerLink=\"{{ loginPageRoute }}\"\r\n          class=\"underlineEffect text-sm blue-500 font-medium cursor-pointer\"\r\n          style=\"text-decoration: none\"\r\n          >{{ 'components.request-password.login-link.label' | translate }}</a\r\n        >\r\n      </div>\r\n    </form>\r\n  </div>\r\n</div>\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:Hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"], dependencies: [{ kind: "directive", type: i1$1.RouterLinkWithHref, selector: "a[routerLink],area[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "state", "relativeTo", "preserveFragment", "skipLocationChange", "replaceUrl", "routerLink"] }, { kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "directive", type: i11.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i3.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "pipe", type: i1$2.AsyncPipe, name: "async" }, { kind: "pipe", type: i1$2.UpperCasePipe, name: "uppercase" }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormRequestPasswordComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-form-request-password', template: "<div class=\"flex justify-content-center\">\r\n  <div\r\n    class=\"mainContainer shadow-3 border-1 border-300 surface-card border-round-lg w-28rem\"\r\n  >\r\n    <form\r\n      [formGroup]=\"requestPassForm\"\r\n      (ngSubmit)=\"onSubmitRequestPassword()\"\r\n      novalidate\r\n    >\r\n      <div\r\n        class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 my-4 text-center\"\r\n      >\r\n        {{ 'components.request-password.title' | translate | uppercase }}\r\n      </div>\r\n      <div class=\"px-5 mb-5\">\r\n        <h6 class=\"text-700\">\r\n          {{ 'entities.user.fields.email.label' | translate }}\r\n        </h6>\r\n        <span class=\"p-input-icon-left w-full\"\r\n          ><i class=\"bi bi-envelope\"></i>\r\n          <input\r\n            placeholder=\"{{\r\n              ('entities.user.fields.email.placeholder' | translate) + '...'\r\n            }}\"\r\n            formControlName=\"email\"\r\n            id=\"email\"\r\n            autofocus\r\n            autocomplete=\"email\"\r\n            type=\"email\"\r\n            class=\"w-full\"\r\n            pInputText\r\n        /></span>\r\n      </div>\r\n      <div class=\"px-5 text-center mb-3\">\r\n        <button\r\n          type=\"submit\"\r\n          [disabled]=\"\r\n            !requestPassForm.valid || (isLoadingData.visibility | async)\r\n          \"\r\n          pButton\r\n          pRipple\r\n          label=\"{{ 'components.request-password.button.label' | translate }}\"\r\n          icon=\"pi pi-lock\"\r\n          class=\"w-full\"\r\n        ></button>\r\n      </div>\r\n      <div class=\"px-5 mb-3 text-center\" *ngIf=\"showLoginLink\">\r\n        <a\r\n          [style.pointer-events]=\"\r\n            (isLoadingData.visibility | async) ? 'none' : 'auto'\r\n          \"\r\n          routerLink=\"{{ loginPageRoute }}\"\r\n          class=\"underlineEffect text-sm blue-500 font-medium cursor-pointer\"\r\n          style=\"text-decoration: none\"\r\n          >{{ 'components.request-password.login-link.label' | translate }}</a\r\n        >\r\n      </div>\r\n    </form>\r\n  </div>\r\n</div>\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:Hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.NGXLogger }, { type: AbstractAuthService }, { type: i7.PrimeNGConfig }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_AUTH_CONFIG]
                }] }, { type: IsLoadingDataService }]; }, propDecorators: { showLoginLink: [{
                type: Input
            }], loginPageRoute: [{
                type: Input
            }] } });

/**
 * Token class that defines some basic JWT
 * <br />properties and adds additional
 * <br />generic properties required by the
 * <br />front-end
 */
class Token {
    /**
     * Constructor
     */
    constructor(init) {
        Object.assign(this, init);
    }
}
/**
 * PasswordRequirements configuration items model
 * <br />to be used when creating or resetting
 * <br />user passwords
 */
class PasswordRequirements {
    constructor() {
        /**
         * Gets or sets the minimum length a password must be. Defaults to 6.
         */
        this.requiredLength = 6;
        /**
         * Gets or sets the minimum number of unique characters which a password must contain.
         *<br />Defaults to 1.
         */
        this.requiredUniqueChars = 1;
        /**
         * Gets or sets a flag indicating if passwords must contain a non-alphanumeric character.
         * <br />Defaults to true.
         */
        this.requireNonAlphanumeric = true;
        /**
         * Gets or sets a flag indicating if passwords must contain a lower case ASCII character.
         * <br />Defaults to true.
         */
        this.requireLowercase = true;
        /**
         * Gets or sets a flag indicating if passwords must contain a upper case ASCII character.
         * <br />Defaults to true.
         */
        this.requireUppercase = true;
        /**
         * Gets or sets a flag indicating if passwords must contain a digit.
         * <br />Defaults to true.
         */
        this.requireDigit = true;
    }
}
/**
 * User class that defines the basic properties
 * <br />of an user.
 */
class User {
    /**
     * Constructor
     * @param {Partial<User>} init
     */
    constructor(init) {
        Object.assign(this, init);
    }
}

/**
 * This class define methods to validate passwords
 */
class PrgAuthCustomPasswordRequirements {
    /**
     * Method to validate passwords through Regular Expression (RegExp)
     * @param {RegExp} regex
     * @param {ValidationErrors} error
     * @param {boolean} passwordRequirements
     * @returns {ValidatorFn}
     */
    static patternValidator(regex, error, passwordRequirements) {
        return (control) => {
            if (!control.value || !passwordRequirements) {
                return null;
            }
            const valid = regex.test(control.value);
            return valid ? null : error;
        };
    }
    /**
     * Method to validate passwords with a number of unique chars
     * @param {number} numberUniqueChars
     * @param {ValidationErrors} error
     * @returns {ValidatorFn}
     */
    static uniqueCharsValidator(numberUniqueChars, error) {
        return (control) => {
            if (!control.value) {
                return null;
            }
            const splitControlValueIntoArray = Array.from(control.value);
            const uniqueCharsArray = [...new Set(splitControlValueIntoArray)];
            if (uniqueCharsArray.length >= numberUniqueChars) {
                return null;
            }
            else {
                return error;
            }
        };
    }
}
/**
 * Method to validate if password and confirm password match
 * @param {AbstractControl} group
 * @returns {ValidationErrors | null}
 */
PrgAuthCustomPasswordRequirements.passwordMatchValidator = (group) => {
    let pass = group.get('password').value;
    let confirmPass = group.get('confirmPassword').value;
    return pass === confirmPass ? null : { passDontMatch: true };
};

/**
 * The form reset password component
 */
class PrgFormResetPasswordComponent {
    /**
     * Constructor
     * @param route
     * @param router
     * @param logger
     * @param authService
     * @param primengConfig
     * @param authRoutes
     * @param passwordRequirements passwordRequirements
     * @param isLoadingData isLoadingData
     */
    constructor(route, router, logger, authService, primengConfig, authRoutes, passwordRequirements, isLoadingData) {
        this.route = route;
        this.router = router;
        this.logger = logger;
        this.authService = authService;
        this.primengConfig = primengConfig;
        this.authRoutes = authRoutes;
        this.passwordRequirements = passwordRequirements;
        this.isLoadingData = isLoadingData;
        /**
         * The route for login page
         */
        this.loginPageRoute = '/' +
            this.authRoutes.authRoutingBasePath +
            '/' +
            this.authRoutes.authRoutingLoginPath;
        /**
         * Shows/hide the login link.  Default true.
         */
        this.showLoginLink = true;
        /**
         * Shows/hide password on form. Default false.
         */
        this.showPassword = false;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.logger.debug('RESET PASSWORD FORM ON INIT');
        this.token = this.route.snapshot.queryParams['token'];
        if (this.token == null || this.token.length === 0) {
            this.router.navigate([this.loginPageRoute]);
        }
        /*This observable is used when is necessary to reload the component within the same component*/
        this.queryParamsSubscription = this.route.queryParams.subscribe((queryParams) => {
            this.token = queryParams['token'];
        });
        this.initFormResetPassword();
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.logger.debug('RESET PASSWORD FORM ON DESTROY');
        this.queryParamsSubscription.unsubscribe();
    }
    /**
     * Initiate the reset password form and its form controls with validators
     */
    initFormResetPassword() {
        this.resetPasswordForm = new FormGroup({
            password: new FormControl(null, [
                Validators.required,
                Validators.minLength(this.passwordRequirements.requiredLength),
                PrgAuthCustomPasswordRequirements.patternValidator(/\d/, {
                    hasNumber: true,
                }, this.passwordRequirements.requireDigit),
                PrgAuthCustomPasswordRequirements.patternValidator(/[a-z]/, {
                    hasSmallCase: true,
                }, this.passwordRequirements.requireLowercase),
                PrgAuthCustomPasswordRequirements.patternValidator(/[A-Z]/, {
                    hasCapitalCase: true,
                }, this.passwordRequirements.requireUppercase),
                PrgAuthCustomPasswordRequirements.patternValidator(/[!@#$%^&*()_+\-=\[\]{};':"\\|,.<>\/?]/, {
                    hasSpecialCharacters: true,
                }, this.passwordRequirements.requireNonAlphanumeric),
                PrgAuthCustomPasswordRequirements.uniqueCharsValidator(this.passwordRequirements.requiredUniqueChars, {
                    numberOfUniqueChars: this.passwordRequirements.requiredUniqueChars,
                }),
            ]),
            confirmPassword: new FormControl(null, [Validators.required]),
        }, {
            validators: PrgAuthCustomPasswordRequirements.passwordMatchValidator,
            updateOn: 'change',
        });
    }
    /**
     * Function to display/hide password on click
     */
    onShowPassword() {
        this.showPassword = !this.showPassword;
    }
    /**
     * Form submission
     */
    async onSubmitResetPassword() {
        if (this.resetPasswordForm.invalid) {
            return;
        }
        const userNewPassword = this.resetPasswordForm.controls.password.value;
        this.resetPasswordForm.disable();
        try {
            if (await this.authService.resetPasswordAsync(userNewPassword, this.token)) {
                this.resetPasswordForm.reset();
                this.router.navigate([this.loginPageRoute]);
            }
        }
        catch (error) {
            this.logger.debug(error);
        }
        this.resetPasswordForm.enable();
    }
}
PrgFormResetPasswordComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormResetPasswordComponent, deps: [{ token: i1$1.ActivatedRoute }, { token: i1$1.Router }, { token: i1.NGXLogger }, { token: AbstractAuthService }, { token: i7.PrimeNGConfig }, { token: PRG_AUTH_CONFIG }, { token: PasswordRequirements }, { token: IsLoadingDataService }], target: i0.ɵɵFactoryTarget.Component });
PrgFormResetPasswordComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgFormResetPasswordComponent, selector: "prg-form-reset-password", inputs: { loginPageRoute: "loginPageRoute", showLoginLink: "showLoginLink" }, providers: [PasswordRequirements], ngImport: i0, template: "<div class=\"flex justify-content-center\">\r\n<div class=\"mainContainer shadow-3  border-1 border-300 surface-card border-round-lg w-28rem\">\r\n  <form [formGroup]=\"resetPasswordForm\" (ngSubmit)=\"onSubmitResetPassword()\" novalidate>\r\n    <div class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 my-4 text-center\">{{'components.reset-password.title'|translate|uppercase}}\r\n    </div>\r\n    <div class=\"px-5 mb-3\">\r\n      <h6 class=\"text-700\">{{'components.reset-password.new-password.label'|translate}}</h6>\r\n      <span class=\"p-input-icon-left w-full \"><i class=\"pi pi-lock\" (click)=\"onShowPassword()\"\r\n                                                 style=\"cursor: pointer\"></i>\r\n              <input placeholder=\"{{'components.reset-password.new-password.placeholder'|translate}}\" formControlName=\"password\" autofocus id=\"password\"\r\n                     autocomplete=\"new-password\"\r\n                     [type]=\"showPassword?'text':'password'\" class=\"w-full\"\r\n                     pInputText></span>\r\n      <div class=\"flex flex-column mt-2\"\r\n           *ngIf=\"resetPasswordForm.controls.password.touched&&resetPasswordForm.controls.password.dirty\">\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.controls.password.hasError('required')\">Password is\r\n          required.</small>\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasCapitalCase')\">Password\r\n          must have\r\n          one upper case.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasSmallCase')\">Password must have\r\n          one lower\r\n          case.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasNumber')\">Password must have one\r\n          number.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('minlength')\">Password must\r\n          have {{this.passwordRequirements.requiredLength}} chars in length.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasSpecialCharacters')\">Password\r\n          must have\r\n          one special char.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('numberOfUniqueChars')\">Password must\r\n          have {{this.passwordRequirements.requiredUniqueChars}} unique chars.</small>\r\n      </div>\r\n    </div>\r\n    <div class=\"px-5 mb-5\">\r\n      <h6 class=\"text-700\">{{'components.reset-password.new-password-confirmation.label'|translate}}</h6>\r\n      <span class=\"p-input-icon-left w-full \"><i class=\"pi pi-lock\" (click)=\"onShowPassword()\"\r\n                                                 style=\"cursor: pointer\"></i>\r\n              <input placeholder=\"{{'components.reset-password.new-password-confirmation.placeholder'|translate}}\" formControlName=\"confirmPassword\" id=\"confirmPassword\"\r\n                     autocomplete=\"new-password\"\r\n                     [type]=\"showPassword?'text':'password'\" class=\"w-full\"\r\n                     pInputText></span>\r\n\r\n      <div class=\"flex flex-column mt-2\"\r\n           *ngIf=\"resetPasswordForm.controls.confirmPassword.touched&&resetPasswordForm.controls.confirmPassword.dirty\">\r\n\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.controls.confirmPassword.hasError('required')\">Confirm\r\n          Password is\r\n          required.</small>\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.hasError('passDontMatch')\">Password and\r\n          confirm password do not match</small>\r\n      </div>\r\n    </div>\r\n    <div class=\"px-5 mb-3 text-center\">\r\n      <button type=\"submit\" [disabled]=\"!resetPasswordForm.valid||(isLoadingData.visibility|async)\" pButton pRipple\r\n              label=\"{{'components.reset-password.button.label'|translate}}\"\r\n              icon=\"pi pi-unlock\"\r\n              class=\"w-full\"></button>\r\n    </div>\r\n    <div class=\"px-5 mb-3  text-center\" *ngIf=\"showLoginLink\">\r\n      <a [style.pointer-events]=\"(isLoadingData.visibility|async)?'none':'auto'\"  routerLink=\"{{loginPageRoute}}\"\r\n         class=\"underlineEffect text-sm blue-500 font-medium cursor-pointer\"\r\n         style=\"text-decoration: none\">{{'components.request-password.login-link.label'|translate}}</a>\r\n    </div>\r\n\r\n  </form>\r\n</div>\r\n</div>\r\n\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:Hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"], dependencies: [{ kind: "directive", type: i1$1.RouterLinkWithHref, selector: "a[routerLink],area[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "state", "relativeTo", "preserveFragment", "skipLocationChange", "replaceUrl", "routerLink"] }, { kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "directive", type: i11.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i3.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "pipe", type: i1$2.AsyncPipe, name: "async" }, { kind: "pipe", type: i1$2.UpperCasePipe, name: "uppercase" }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgFormResetPasswordComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-form-reset-password', providers: [PasswordRequirements], template: "<div class=\"flex justify-content-center\">\r\n<div class=\"mainContainer shadow-3  border-1 border-300 surface-card border-round-lg w-28rem\">\r\n  <form [formGroup]=\"resetPasswordForm\" (ngSubmit)=\"onSubmitResetPassword()\" novalidate>\r\n    <div class=\"text-600 text-2xl w-full border-bottom-1 border-top-1 border-300 p-2 my-4 text-center\">{{'components.reset-password.title'|translate|uppercase}}\r\n    </div>\r\n    <div class=\"px-5 mb-3\">\r\n      <h6 class=\"text-700\">{{'components.reset-password.new-password.label'|translate}}</h6>\r\n      <span class=\"p-input-icon-left w-full \"><i class=\"pi pi-lock\" (click)=\"onShowPassword()\"\r\n                                                 style=\"cursor: pointer\"></i>\r\n              <input placeholder=\"{{'components.reset-password.new-password.placeholder'|translate}}\" formControlName=\"password\" autofocus id=\"password\"\r\n                     autocomplete=\"new-password\"\r\n                     [type]=\"showPassword?'text':'password'\" class=\"w-full\"\r\n                     pInputText></span>\r\n      <div class=\"flex flex-column mt-2\"\r\n           *ngIf=\"resetPasswordForm.controls.password.touched&&resetPasswordForm.controls.password.dirty\">\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.controls.password.hasError('required')\">Password is\r\n          required.</small>\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasCapitalCase')\">Password\r\n          must have\r\n          one upper case.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasSmallCase')\">Password must have\r\n          one lower\r\n          case.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasNumber')\">Password must have one\r\n          number.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('minlength')\">Password must\r\n          have {{this.passwordRequirements.requiredLength}} chars in length.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('hasSpecialCharacters')\">Password\r\n          must have\r\n          one special char.</small>\r\n        <small class=\"p-error\" *ngIf=\"resetPasswordForm.controls.password.hasError('numberOfUniqueChars')\">Password must\r\n          have {{this.passwordRequirements.requiredUniqueChars}} unique chars.</small>\r\n      </div>\r\n    </div>\r\n    <div class=\"px-5 mb-5\">\r\n      <h6 class=\"text-700\">{{'components.reset-password.new-password-confirmation.label'|translate}}</h6>\r\n      <span class=\"p-input-icon-left w-full \"><i class=\"pi pi-lock\" (click)=\"onShowPassword()\"\r\n                                                 style=\"cursor: pointer\"></i>\r\n              <input placeholder=\"{{'components.reset-password.new-password-confirmation.placeholder'|translate}}\" formControlName=\"confirmPassword\" id=\"confirmPassword\"\r\n                     autocomplete=\"new-password\"\r\n                     [type]=\"showPassword?'text':'password'\" class=\"w-full\"\r\n                     pInputText></span>\r\n\r\n      <div class=\"flex flex-column mt-2\"\r\n           *ngIf=\"resetPasswordForm.controls.confirmPassword.touched&&resetPasswordForm.controls.confirmPassword.dirty\">\r\n\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.controls.confirmPassword.hasError('required')\">Confirm\r\n          Password is\r\n          required.</small>\r\n        <small class=\"p-error w-max\" *ngIf=\"resetPasswordForm.hasError('passDontMatch')\">Password and\r\n          confirm password do not match</small>\r\n      </div>\r\n    </div>\r\n    <div class=\"px-5 mb-3 text-center\">\r\n      <button type=\"submit\" [disabled]=\"!resetPasswordForm.valid||(isLoadingData.visibility|async)\" pButton pRipple\r\n              label=\"{{'components.reset-password.button.label'|translate}}\"\r\n              icon=\"pi pi-unlock\"\r\n              class=\"w-full\"></button>\r\n    </div>\r\n    <div class=\"px-5 mb-3  text-center\" *ngIf=\"showLoginLink\">\r\n      <a [style.pointer-events]=\"(isLoadingData.visibility|async)?'none':'auto'\"  routerLink=\"{{loginPageRoute}}\"\r\n         class=\"underlineEffect text-sm blue-500 font-medium cursor-pointer\"\r\n         style=\"text-decoration: none\">{{'components.request-password.login-link.label'|translate}}</a>\r\n    </div>\r\n\r\n  </form>\r\n</div>\r\n</div>\r\n\r\n", styles: [".underlineEffect{display:inline-block;position:relative;color:var(--blue-500)}.underlineEffect:Hover{color:var(--blue-800)}.underlineEffect:after{content:\"\";position:absolute;width:100%;transform:scaleX(0);height:2px;bottom:0;left:0;background-color:var(--blue-800);transform-origin:bottom right;transition:transform .25s ease-out}.underlineEffect:hover:after{transform:scaleX(1);transform-origin:bottom left}.mainContainer{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: i1$1.ActivatedRoute }, { type: i1$1.Router }, { type: i1.NGXLogger }, { type: AbstractAuthService }, { type: i7.PrimeNGConfig }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_AUTH_CONFIG]
                }] }, { type: PasswordRequirements }, { type: IsLoadingDataService }]; }, propDecorators: { loginPageRoute: [{
                type: Input
            }], showLoginLink: [{
                type: Input
            }] } });

/**
 * class PrgError
 */
class PrgError {
    /**
     * constructor
     *
     * @param error
     */
    constructor(error) {
        /**
         * time to disappear
         */
        this.life = 3500;
        Object.assign(this, error);
    }
}

/**
 *  class PrgSucess
 */
class PrgSucess {
    /**
     * constructor
     *
     * @param success
     */
    constructor(success) {
        /**
         * time to disappear
         */
        this.life = 3500;
        Object.assign(this, success);
    }
}

/**
 * MockDatabase object to be used while developing
 * <br /> and/or testing the front-end
 */
const UsersBDMOCk = {
    Users: [
        {
            id: '1',
            name: 'Ivo Carvalho',
            token: new Token({
                imageUrl: '/assets/images/Image_profile_Example.jpg',
            }),
            email: 'ivo@gmail.com',
            password: 'Abcd1_',
            tokenResetPassword: 'reset',
        },
        {
            id: '2',
            name: 'Pedro Couto',
            token: null,
            email: 'pedrocouto@gmail.com',
            password: 'Abcd1_',
            tokenResetPassword: null,
        },
        {
            id: '3',
            name: 'Pedro Lima',
            token: null,
            email: 'pedrolima@gmail.com',
            password: 'Abcd1_',
            tokenResetPassword: null,
        },
        {
            id: '4',
            name: 'Luis Alves',
            token: null,
            email: 'luis@gmail.com',
            password: 'Abcd1_',
            tokenResetPassword: null,
        },
    ],
    /* TODO: MAP IDENTITY CONFIG TO CONFIGURATION ITEMS
      "Identity": {
        "DefaultEnabledUser": true, // user will be enabled on register
        "AllowSelfRegister": true,
        "LockoutEnabled": true,
        "CreateWorkspaceOnUserRegister": true,
        "SignIn": {
          "RequireEnabledUser": false,
          "RequireConfirmedAdmin": false,
          "RequireConfirmedEmail": true,
          "RequireConfirmedPhoneNumber": false
        },
        "Lockout": {
          "LockoutTimeSpan": "1.00:00:00" //lock out for 1 day
        },
        "Password": {
          "RequireDigit": true,
          "RequiredLength": 7,
          "RequireLowercase": true,
          "RequiredUniqueChars": 1,
          "RequireUppercase": true,
          "RequireNonAlphanumeric": true
        },
        "Callbacks": {
          "BaseUrl": "http://localhost:8100",
          "LoginUrl": "/auth/login",
          "ConfirmedAccountUrl": "/auth/confirm",
          "ResetPasswordUrl": "/auth/reset",
          "UnsubscribeUrl": "/auth/unsubscribe"
        },
        "Token": {
          "Audience": "Prg.Framework.Api.Audience",
          "Issuer": "Prg.Framework.Api.Issuer",
          "Seconds": 86400, // 24 hours
          "RefreshDuration": 24 // 24 hours
        }
      }
    */
};

/**
 * Injectable
 */
class NotificationsService {
    /**
     * constructor
     *
     * @param messageService
     */
    constructor(messageService, confirmationService, translateService) {
        this.messageService = messageService;
        this.confirmationService = confirmationService;
        this.translateService = translateService;
    }
    /**
     * this function fire an error toast
     * @param error
     */
    errorNotification(error) {
        this.messageService.add({
            key: 'message',
            severity: 'error',
            summary: error.titleKey,
            detail: error.detailKey,
            life: error.life,
        });
    }
    /**
     * this function fire an success toast
     * @param success
     */
    successNotification(success) {
        this.messageService.add({
            key: 'message',
            severity: 'success',
            summary: success.titleKey,
            detail: success.detailKey,
            life: success.life,
        });
    }
    async prgConfirmationService(translationPath, entityNameTranslationParameter = null, throwOnCancel = false) {
        return new Promise(async (resolve, reject) => {
            const confirmationServiceTranslations = await this.translateService
                .get([
                translationPath + '.message',
                translationPath + '.header',
                translationPath + '.icon',
                translationPath + '.reject-label',
                translationPath + '.accept-label',
            ], entityNameTranslationParameter != null
                ? {
                    entityName: entityNameTranslationParameter,
                }
                : null)
                .toPromise();
            this.confirmationService.confirm({
                key: 'confirmationDialog',
                message: confirmationServiceTranslations[translationPath + '.message'],
                header: confirmationServiceTranslations[translationPath + '.header'],
                icon: confirmationServiceTranslations[translationPath + '.icon'],
                rejectLabel: confirmationServiceTranslations[translationPath + '.reject-label'],
                acceptLabel: confirmationServiceTranslations[translationPath + '.accept-label'],
                accept: () => {
                    resolve(true);
                },
                reject: () => {
                    if (throwOnCancel) {
                        reject();
                    }
                    else {
                        resolve(false);
                    }
                },
            });
        });
    }
}
NotificationsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: NotificationsService, deps: [{ token: i7.MessageService }, { token: i7.ConfirmationService }, { token: i5.TranslateService }], target: i0.ɵɵFactoryTarget.Injectable });
NotificationsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: NotificationsService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: NotificationsService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: i7.MessageService }, { type: i7.ConfirmationService }, { type: i5.TranslateService }]; } });

/**
 * PRG validators
 */
class PrgValidators {
}
/**
 * Validators
 */
PrgValidators.Validators = Validators;

/**
 * injectable
 */
class ArrayUtilityService {
    /**
     * this function  compare two arrays
     * @param array1
     * @param array2
     * @returns boolean
     */
    compareTwoArray(array1, array2) {
        const arr1 = array1.slice().sort();
        return (arr1.length === array2.length &&
            array2
                .slice()
                .sort()
                .every(function (value, index) {
                return value === arr1[index];
            }));
    }
    /**
     * this service creates a treeNode grouped by a certain property
     * @param array
     * @param field
     * @returns TreeNode[]
     */
    groupByField(array, field) {
        let organisedByGroup = new Map();
        let organizedTreeNode = [];
        if (!array || !array.length) {
            return organizedTreeNode;
        }
        array.forEach((element) => {
            if (organisedByGroup.has(element[field])) {
                organisedByGroup.get(element[field]).push({ data: element });
            }
            else {
                organisedByGroup.set(element[field], [{ data: element }]);
            }
        });
        organisedByGroup.forEach((value, key) => {
            let treeNodeAux = {};
            let dataAux = { name: key };
            treeNodeAux.data = dataAux;
            treeNodeAux.children = value;
            treeNodeAux.expanded = true;
            organizedTreeNode.push(treeNodeAux);
        });
        return organizedTreeNode;
    }
    /**clone array
     *
     * @param arrayToClone
     * @returns cloned array
     */
    clone(arrayToClone) {
        return clone(arrayToClone);
    }
    /**
     *sortByProperty
  
     * @param arrayToSort
     * @param property
     * @returns
     */
    sortByProperty(arrayToSort, property, isAsc = true) {
        return this.clone(arrayToSort.sort((a, b) => {
            return this.compare(a[property], b[property], isAsc);
        }));
    }
    /**
     * aux function to sort items when it is static mode
     * @param a
     * @param b
     * @param isAsc
     * @returns
     */
    compare(a, b, isAsc) {
        return (a < b ? -1 : 1) * (isAsc ? 1 : -1);
    }
}
ArrayUtilityService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ArrayUtilityService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
ArrayUtilityService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ArrayUtilityService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ArrayUtilityService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }] });

/**
 * injectable
 */
class ObjectsUtilityService {
    /**
     * Constructor
     */
    constructor() { }
    /**
     * this function return an cloned object
     * @param objectToClone
     * @returns any
     */
    cloneObject(objectToClone) {
        // TODO: search a better way to clone object
        return clone(objectToClone);
    }
    /**
     * This function is responsible to transform a nested object into a flat object
     * @param object
     * @param {string} separator
     * @returns {{}}
     */
    flattenObj(object, separator) {
        // The object which contains the
        // final result
        let result = {};
        // loop through the object "ob"
        for (const i in object) {
            // We check the type of the i using
            // typeof() function and recursively
            // call the function again
            if (typeof object[i] === 'object' && !Array.isArray(object[i])) {
                const temp = this.flattenObj(object[i], separator);
                for (const j in temp) {
                    // Store temp in result
                    result[i + '.' + j] = temp[j];
                }
            }
            // Else store ob[i] in result directly
            else {
                result[i] = object[i];
            }
        }
        return result;
    }
    /**
     * This function is responsible a flat object into a nested object
     *
     * Nested object are define by a separator on properties ex :'.'
     * @param {object} object
     * @param {string} separator
     * @returns {object}
     */
    unFlattenObj(object, separator) {
        const result = {};
        let temp, substrings, property, i;
        for (property in object) {
            substrings = property.split(separator);
            temp = result;
            for (i = 0; i < substrings.length - 1; i++) {
                if (!(substrings[i] in temp)) {
                    if (isFinite(substrings[i + 1])) {
                        temp[substrings[i]] = [];
                    }
                    else {
                        temp[substrings[i]] = {};
                    }
                }
                temp = temp[substrings[i]];
            }
            temp[substrings[substrings.length - 1]] = object[property];
        }
        return result;
    }
}
ObjectsUtilityService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ObjectsUtilityService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
ObjectsUtilityService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ObjectsUtilityService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ObjectsUtilityService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return []; } });

/**
 * Injectable
 */
/**
 * UtilityService
 */
class UtilityService {
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(arrayUtilityService, objectsUtilityService) {
        this.arrayUtilityService = arrayUtilityService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * the default debounce time
         * @type {number}
         * @private
         */
        this.defaultDebounceTime = 1500;
    }
    /**
     * this function generate a string
     * @returns string
     */
    newGuid() {
        return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
            // tslint:disable-next-line: no-bitwise
            const r = (Math.random() * 16) | 0, 
            // tslint:disable-next-line: no-bitwise
            v = c === 'x' ? r : (r & 0x3) | 0x8;
            return v.toString(16);
        });
    }
    /**
     * this function make a timeout
     *
     * @param timeInMs
     * @returns Promise<void>
     */
    sleepMsAsync(timeInMs) {
        return new Promise((resolve) => {
            setTimeout(() => {
                resolve();
            }, timeInMs);
        });
    }
    /**
     * this function make a timeout
     *
     * @param timeInSec
     * @returns Promise<void>
     */
    sleepSecAsync(timeInSec) {
        return this.sleepMsAsync(timeInSec * 1000);
    }
    /**
     * Make eval of expression
     * @param {string} expression
     * @param context
     * @returns {any}
     */
    evalFunction(expression, ...context) {
        if (context == null || context.length === 0 || context[0] == null) {
            return function () {
                return eval(expression);
            };
        }
        let mergeContext = this.shallowClone(context[0]);
        context.forEach((cont) => {
            if (cont != null) {
                mergeContext = Object.assign(mergeContext, cont);
            }
        });
        return function () {
            return eval(expression);
        }.call(mergeContext);
        // return eval(expression.replace(new RegExp('this.', 'g'), 'context.'));
    }
    /**
     * An auxiliary function to make a deeper copy of the object
     * @param obj
     * @returns {any}
     * @private
     */
    shallowClone(obj) {
        var clone = Object.create(Object.getPrototypeOf(obj));
        var props = Object.getOwnPropertyNames(obj);
        props.forEach(function (key) {
            var desc = Object.getOwnPropertyDescriptor(obj, key);
            Object.defineProperty(clone, key, desc);
        });
        return clone;
    }
    /**
     * debounce function
     * @param func
     * @param wait
     * @param immediate
     * @returns
     */
    debounce(func, wait = this.defaultDebounceTime, immediate = false) {
        let timeout;
        return function (args = null) {
            const context = this;
            const later = function () {
                timeout = null;
                if (!immediate) {
                    if (Array.isArray(args)) {
                        func.apply(context, args);
                    }
                    else {
                        func.call(context, args);
                    }
                }
            };
            const callNow = immediate && !timeout;
            clearTimeout(timeout);
            timeout = setTimeout(later, wait);
            if (callNow) {
                if (Array.isArray(args)) {
                    func.apply(context, args);
                }
                else {
                    func.call(context, args);
                }
            }
        };
    }
    /**
     * this function transforms the guiSettings into an object,
     * even managing the validators if they exist
     * @param guiSettings
     * @param basePathTranslation
     * @returns
     */
    guiSettingToObject(guiSettings, basePathTranslation = null) {
        const guiSettingsObject = JSON.parse(guiSettings);
        if (!guiSettingsObject.basePathTranslation && basePathTranslation) {
            guiSettingsObject.basePathTranslation = basePathTranslation;
        }
        const validators = guiSettingsObject['validators'];
        if (validators) {
            guiSettingsObject['validators'] = [];
            validators.forEach((validator) => {
                guiSettingsObject['validators'].push(this.evalFunction('this.' + validator.trim(), PrgValidators));
            });
        }
        return guiSettingsObject;
    }
    /**
     * This function build a tree structure to be used on primeng from a list of paths (array of strings) that
     * are joined with a separator ex: "[Configs:UserPreferences:Defaults,Configs:UserPreferences:User...]"
     * @param {string[]} arrayOfPaths
     * @param {string} separator
     * @returns {TreeNode[]}
     */
    arrayOfPathsToTree(arrayOfPaths, separator) {
        //Remove duplicates from the array of paths
        const itemsUniquePath = this.arrayUtilityService.clone(Array.from(new Set(arrayOfPaths)));
        //Sort array of paths alphabetically
        const itemsUniquePathSorted = itemsUniquePath.sort((a, b) => a.localeCompare(b));
        //split the path in subArrays with separator
        const itemsSplitPath = itemsUniquePathSorted.map((value) => value.split(separator));
        //Find out the number of levels that will have the menu
        const menuLevels = itemsSplitPath.reduce((previousValue, currentValue) => previousValue > currentValue.length
            ? previousValue
            : currentValue.length, 0 // initial value
        );
        // Tree table construction
        const tree = [];
        const levels = [tree];
        let lastPath = [];
        itemsUniquePathSorted.forEach((path) => {
            let splitPathTemp = path.split(':');
            splitPathTemp.forEach((label, index) => {
                if (lastPath[index] === label)
                    return;
                let parentPath = [];
                splitPathTemp.map((path, subIndex) => {
                    if (index >= subIndex) {
                        parentPath.push(path);
                    }
                });
                if (index < menuLevels - 1) {
                    levels[index].push({
                        label,
                        expanded: true,
                        key: parentPath.join(separator),
                        children: (levels[index + 1] = []),
                        selectable: index === splitPathTemp.length - 1,
                    });
                }
                else {
                    levels[index].push({
                        label,
                        key: parentPath.join(separator),
                        selectable: true,
                    });
                }
            });
            lastPath = splitPathTemp;
        });
        return tree;
    }
    /**
     * This function is responsible to search for a key in map by a given value
     * @param map
     * @param searchValue
     * @returns {any}
     */
    getKeyByValueOnMap(map, searchValue) {
        for (let [key, value] of map.entries()) {
            if (value === searchValue)
                return key;
        }
    }
}
UtilityService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: UtilityService, deps: [{ token: ArrayUtilityService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Injectable });
UtilityService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: UtilityService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: UtilityService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: ArrayUtilityService }, { type: ObjectsUtilityService }]; } });

/**
 * Injectable
 */
/**
 * MOCK AbstractAuthService implementation
 */
class MockAuthService extends AbstractAuthService {
    /**
     * constructor
     * @param authStorage
     * @param notificationsService
     * @param utilityService
     * @param isLoadingData
     */
    constructor(authStorage, notificationsService, utilityService, isLoadingData) {
        super(authStorage);
        this.notificationsService = notificationsService;
        this.utilityService = utilityService;
        this.isLoadingData = isLoadingData;
        /**
         * default time in seconds
         */
        this.sleepTimeSec = 2;
    }
    /**
     * User login (Async)
     *
     * @param {string} email The user e-mail
     * @param {string} password The user password
     * @param {boolean} storeUserName Store username
     * @returns Boolean promise, true when successful
     */
    loginAsync(email, password, storeUserName) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const user = UsersBDMOCk.Users.find((u) => u.email === email || u.name === email);
            this.isLoadingData.hide();
            if (user && password === user.password) {
                this.setLoggedUser(user);
                if (storeUserName) {
                    this.setStoredUserName(email);
                }
                else {
                    this.removeStoredUserName();
                }
                resolve(true);
            }
            else {
                reject('Authentication has failed');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Login Error.',
                    detailKey: 'Invalid e-mail or password',
                }));
            }
        });
    }
    /**
     * User logout (Async)
     *
     * @returns Boolean promise, true when successful
     */
    logoutAsync() {
        return new Promise(async (resolve) => {
            const checkUserLogOut = await this.baseLogoutAsync();
            if (checkUserLogOut) {
                resolve(true);
            }
        });
    }
    /**
     * User sign up (Async)
     *
     * @returns Boolean promise, true when successful
     */
    signupAsync(email) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const checkUser = UsersBDMOCk.Users.find((u) => u.email === email);
            this.isLoadingData.hide();
            if (!checkUser) {
                let user = new User();
                user.name = email;
                user.id = this.utilityService.newGuid();
                user.token = null;
                user.email = email;
                UsersBDMOCk.Users.push(user);
                resolve(true);
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'Registration completed.',
                    detailKey: 'An email as been sent with a temporary password.',
                }));
            }
            else {
                reject('Registration has failed.');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Registration Error.',
                    detailKey: `The email ${email} already exists in database`,
                }));
            }
        });
    }
    /**
     * Request to reset the password (Async)
     *
     * @param {string} email The user e-mail
     * @returns Boolean promise, true when successful
     */
    requestResetPasswordAsync(email) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const checkUser = UsersBDMOCk.Users.find((u) => u.email === email);
            this.isLoadingData.hide();
            if (checkUser) {
                resolve(true);
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'Request Password completed.',
                    detailKey: 'An email as been sent with a link to reset password.',
                }));
            }
            else {
                reject('Request Password Failed');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Request Password Failed',
                    detailKey: `The email ${email} doesn't exist in database.`,
                }));
            }
        });
    }
    /**
     * Getter for token reset password (Async)
     *
     * @param {string} tokenReset The token reset password
     * @returns Boolean promise, true when successful
     */
    getTokenResetPasswordAsync(tokenReset) {
        return new Promise((resolve) => {
            const checkUser = UsersBDMOCk.Users.find((u) => u.tokenResetPassword === tokenReset);
            if (checkUser) {
                resolve(true);
            }
            else {
                resolve(false);
            }
        });
    }
    /**
     * Method for reset password (Async)
     *
     * @param {string} newPassword The new password
     * @param {string} tokenReset The token reset password
     * @returns Boolean promise, true when successful
     */
    resetPasswordAsync(newPassword, tokenReset) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const checkUser = UsersBDMOCk.Users.find((u) => u.tokenResetPassword === tokenReset);
            this.isLoadingData.hide();
            if (checkUser) {
                checkUser.password = newPassword;
                resolve(true);
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'New Password',
                    detailKey: 'Password Changed Successfully',
                }));
            }
            else {
                reject('The password change operation has failed.');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Password Error.',
                    detailKey: `The password change operation has failed.`,
                }));
            }
        });
    }
}
MockAuthService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockAuthService, deps: [{ token: 'AUTHSTORAGE' }, { token: NotificationsService }, { token: UtilityService }, { token: IsLoadingDataService }], target: i0.ɵɵFactoryTarget.Injectable });
MockAuthService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockAuthService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockAuthService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: ['AUTHSTORAGE']
                }] }, { type: NotificationsService }, { type: UtilityService }, { type: IsLoadingDataService }]; } });

class PrgSharedComponentsModule {
}
PrgSharedComponentsModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSharedComponentsModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
PrgSharedComponentsModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgSharedComponentsModule, imports: [CommonModule,
        InputTextareaModule,
        ProgressSpinnerModule,
        TableModule,
        CalendarModule,
        SliderModule,
        DialogModule,
        TreeModule,
        SidebarModule,
        ListboxModule,
        MultiSelectModule,
        ContextMenuModule,
        SelectButtonModule,
        KnobModule,
        DropdownModule,
        ButtonModule,
        ToastModule,
        ChipsModule,
        InputSwitchModule,
        InputTextModule,
        RatingModule,
        RadioButtonModule,
        CheckboxModule,
        TreeTableModule,
        TriStateCheckboxModule,
        SplitterModule,
        TabMenuModule,
        DynamicDialogModule,
        OrderListModule,
        FileUploadModule,
        InputNumberModule,
        PasswordModule,
        SpeedDialModule,
        AutoCompleteModule,
        SplitButtonModule,
        ToolbarModule,
        InputMaskModule,
        ImageModule,
        MessageModule,
        RippleModule,
        ColorPickerModule,
        CascadeSelectModule,
        TranslateModule,
        RouterModule,
        FormsModule,
        ReactiveFormsModule,
        ToggleButtonModule,
        ConfirmDialogModule,
        ChipModule,
        TieredMenuModule,
        MenuModule,
        AccordionModule], exports: [MenuModule,
        TieredMenuModule,
        SelectButtonModule,
        RadioButtonModule,
        ChipModule,
        ChipsModule,
        CommonModule,
        KnobModule,
        ProgressSpinnerModule,
        TableModule,
        TreeModule,
        CalendarModule,
        SliderModule,
        CascadeSelectModule,
        DialogModule,
        MultiSelectModule,
        ContextMenuModule,
        DropdownModule,
        ListboxModule,
        ButtonModule,
        ToastModule,
        InputTextModule,
        InputSwitchModule,
        RatingModule,
        CheckboxModule,
        TreeTableModule,
        AutoCompleteModule,
        TriStateCheckboxModule,
        SplitterModule,
        TabMenuModule,
        InputMaskModule,
        DynamicDialogModule,
        OrderListModule,
        FileUploadModule,
        SidebarModule,
        InputNumberModule,
        PasswordModule,
        SpeedDialModule,
        SplitButtonModule,
        ToolbarModule,
        ImageModule,
        MessageModule,
        RippleModule,
        TranslateModule,
        RouterModule,
        ColorPickerModule,
        FormsModule,
        ReactiveFormsModule,
        ToggleButtonModule,
        ConfirmDialogModule,
        AccordionModule,
        InputTextareaModule] });
PrgSharedComponentsModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSharedComponentsModule, imports: [CommonModule,
        InputTextareaModule,
        ProgressSpinnerModule,
        TableModule,
        CalendarModule,
        SliderModule,
        DialogModule,
        TreeModule,
        SidebarModule,
        ListboxModule,
        MultiSelectModule,
        ContextMenuModule,
        SelectButtonModule,
        KnobModule,
        DropdownModule,
        ButtonModule,
        ToastModule,
        ChipsModule,
        InputSwitchModule,
        InputTextModule,
        RatingModule,
        RadioButtonModule,
        CheckboxModule,
        TreeTableModule,
        TriStateCheckboxModule,
        SplitterModule,
        TabMenuModule,
        DynamicDialogModule,
        OrderListModule,
        FileUploadModule,
        InputNumberModule,
        PasswordModule,
        SpeedDialModule,
        AutoCompleteModule,
        SplitButtonModule,
        ToolbarModule,
        InputMaskModule,
        ImageModule,
        MessageModule,
        RippleModule,
        ColorPickerModule,
        CascadeSelectModule,
        TranslateModule,
        RouterModule,
        FormsModule,
        ReactiveFormsModule,
        ToggleButtonModule,
        ConfirmDialogModule,
        ChipModule,
        TieredMenuModule,
        MenuModule,
        AccordionModule, MenuModule,
        TieredMenuModule,
        SelectButtonModule,
        RadioButtonModule,
        ChipModule,
        ChipsModule,
        CommonModule,
        KnobModule,
        ProgressSpinnerModule,
        TableModule,
        TreeModule,
        CalendarModule,
        SliderModule,
        CascadeSelectModule,
        DialogModule,
        MultiSelectModule,
        ContextMenuModule,
        DropdownModule,
        ListboxModule,
        ButtonModule,
        ToastModule,
        InputTextModule,
        InputSwitchModule,
        RatingModule,
        CheckboxModule,
        TreeTableModule,
        AutoCompleteModule,
        TriStateCheckboxModule,
        SplitterModule,
        TabMenuModule,
        InputMaskModule,
        DynamicDialogModule,
        OrderListModule,
        FileUploadModule,
        SidebarModule,
        InputNumberModule,
        PasswordModule,
        SpeedDialModule,
        SplitButtonModule,
        ToolbarModule,
        ImageModule,
        MessageModule,
        RippleModule,
        TranslateModule,
        RouterModule,
        ColorPickerModule,
        FormsModule,
        ReactiveFormsModule,
        ToggleButtonModule,
        ConfirmDialogModule,
        AccordionModule,
        InputTextareaModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSharedComponentsModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [],
                    imports: [
                        CommonModule,
                        InputTextareaModule,
                        ProgressSpinnerModule,
                        TableModule,
                        CalendarModule,
                        SliderModule,
                        DialogModule,
                        TreeModule,
                        SidebarModule,
                        ListboxModule,
                        MultiSelectModule,
                        ContextMenuModule,
                        SelectButtonModule,
                        KnobModule,
                        DropdownModule,
                        ButtonModule,
                        ToastModule,
                        ChipsModule,
                        InputSwitchModule,
                        InputTextModule,
                        RatingModule,
                        RadioButtonModule,
                        CheckboxModule,
                        TreeTableModule,
                        TriStateCheckboxModule,
                        SplitterModule,
                        TabMenuModule,
                        DynamicDialogModule,
                        OrderListModule,
                        FileUploadModule,
                        InputNumberModule,
                        PasswordModule,
                        SpeedDialModule,
                        AutoCompleteModule,
                        SplitButtonModule,
                        ToolbarModule,
                        InputMaskModule,
                        ImageModule,
                        MessageModule,
                        RippleModule,
                        ColorPickerModule,
                        CascadeSelectModule,
                        TranslateModule,
                        RouterModule,
                        FormsModule,
                        ReactiveFormsModule,
                        ToggleButtonModule,
                        ConfirmDialogModule,
                        ChipModule,
                        TieredMenuModule,
                        MenuModule,
                        AccordionModule,
                    ],
                    exports: [
                        MenuModule,
                        TieredMenuModule,
                        SelectButtonModule,
                        RadioButtonModule,
                        ChipModule,
                        ChipsModule,
                        CommonModule,
                        KnobModule,
                        ProgressSpinnerModule,
                        TableModule,
                        TreeModule,
                        CalendarModule,
                        SliderModule,
                        CascadeSelectModule,
                        DialogModule,
                        MultiSelectModule,
                        ContextMenuModule,
                        DropdownModule,
                        ListboxModule,
                        ButtonModule,
                        ToastModule,
                        InputTextModule,
                        InputSwitchModule,
                        RatingModule,
                        CheckboxModule,
                        TreeTableModule,
                        AutoCompleteModule,
                        TriStateCheckboxModule,
                        SplitterModule,
                        TabMenuModule,
                        InputMaskModule,
                        DynamicDialogModule,
                        OrderListModule,
                        FileUploadModule,
                        SidebarModule,
                        InputNumberModule,
                        PasswordModule,
                        SpeedDialModule,
                        SplitButtonModule,
                        ToolbarModule,
                        ImageModule,
                        MessageModule,
                        RippleModule,
                        TranslateModule,
                        RouterModule,
                        ColorPickerModule,
                        FormsModule,
                        ReactiveFormsModule,
                        ToggleButtonModule,
                        ConfirmDialogModule,
                        AccordionModule,
                        InputTextareaModule,
                    ],
                }]
        }] });

/**
 * Login Page
 */
class PrgAuthLoginPage {
    /**
     * constructor
     * @param logger
     */
    constructor(logger) {
        this.logger = logger;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.logger.debug('Login Page on Init');
    }
}
PrgAuthLoginPage.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthLoginPage, deps: [{ token: i1.NGXLogger }], target: i0.ɵɵFactoryTarget.Component });
PrgAuthLoginPage.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgAuthLoginPage, selector: "prg-auth-login", ngImport: i0, template: "<div>\r\n  <prg-form-login ></prg-form-login>\r\n</div>\r\n\r\n", styles: [""], dependencies: [{ kind: "component", type: PrgFormLoginComponent, selector: "prg-form-login", inputs: ["showStoreUserName", "showResetPasswordLink", "showSignUpRoute", "signUpPageRoute", "loginOkRedirectLink", "resetPasswordPageRoute", "imagePathLogo"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthLoginPage, decorators: [{
            type: Component,
            args: [{ selector: 'prg-auth-login', template: "<div>\r\n  <prg-form-login ></prg-form-login>\r\n</div>\r\n\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.NGXLogger }]; } });

/**
 * Register page
 */
class PrgAuthRegisterPage {
}
PrgAuthRegisterPage.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthRegisterPage, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgAuthRegisterPage.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgAuthRegisterPage, selector: "prg-auth-register", ngImport: i0, template: "<div>\r\n  <prg-form-register ></prg-form-register>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "component", type: PrgFormRegisterComponent, selector: "prg-form-register", inputs: ["showTermsOfUse", "showLoginLink", "loginPageRoute", "termsOfUsePageRoute", "imagePathLogo"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthRegisterPage, decorators: [{
            type: Component,
            args: [{ selector: 'prg-auth-register', template: "<div>\r\n  <prg-form-register ></prg-form-register>\r\n</div>\r\n" }]
        }] });

/**
 * Request password page
 */
class PrgAuthRequestPasswordPage {
}
PrgAuthRequestPasswordPage.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthRequestPasswordPage, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgAuthRequestPasswordPage.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgAuthRequestPasswordPage, selector: "prg-auth-request-password", ngImport: i0, template: "<div>\r\n  <prg-form-request-password></prg-form-request-password>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "component", type: PrgFormRequestPasswordComponent, selector: "prg-form-request-password", inputs: ["showLoginLink", "loginPageRoute"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthRequestPasswordPage, decorators: [{
            type: Component,
            args: [{ selector: 'prg-auth-request-password', template: "<div>\r\n  <prg-form-request-password></prg-form-request-password>\r\n</div>\r\n" }]
        }] });

/**
 * Reset password page
 */
class PrgAuthResetPasswordPage {
}
PrgAuthResetPasswordPage.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthResetPasswordPage, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgAuthResetPasswordPage.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgAuthResetPasswordPage, selector: "prg-auth-reset-password", ngImport: i0, template: "<div>\r\n  <prg-form-reset-password></prg-form-reset-password>\r\n</div>\r\n\r\n", styles: [""], dependencies: [{ kind: "component", type: PrgFormResetPasswordComponent, selector: "prg-form-reset-password", inputs: ["loginPageRoute", "showLoginLink"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthResetPasswordPage, decorators: [{
            type: Component,
            args: [{ selector: 'prg-auth-reset-password', template: "<div>\r\n  <prg-form-reset-password></prg-form-reset-password>\r\n</div>\r\n\r\n" }]
        }] });

/**
 * Empty Layout component, contains a router-outlet
 * <br />that displays child components
 */
class PrgLayoutsEmptyComponent {
    /**
     * Constructor
     * @param logger
     * @param isLoadingData isLoadingData
     * @param cdr
     */
    constructor(logger, isLoadingData, cdr) {
        this.logger = logger;
        this.isLoadingData = isLoadingData;
        this.cdr = cdr;
        /**
         * spinnerVisible value
         */
        this.spinnerVisible = false;
        /**
         * subscriptions
         */
        this.subscriptions = [];
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.logger.debug('EMPTY LAYOUT ON INIT');
    }
    /**
     * ngOnInit
     */
    ionViewWillEnter() {
        this.logger.debug('EMPTY LAYOUT WILL ENTER');
    }
    /**
     * ngOnInit
     */
    ionViewWillLeave() {
        this.logger.debug('EMPTY LAYOUT WILL LEAVE');
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.logger.debug('EMPTY LAYOUT ON DESTROY');
        this.subscriptions.forEach((subscription) => {
            subscription.unsubscribe();
        });
        this.subscriptions = [];
    }
    /**
     * ngAfterContentChecked
     */
    ngAfterContentChecked() {
        this.subscriptions.push(this.isLoadingData.visibility.subscribe((visible) => {
            this.spinnerVisible = visible;
            this.cdr.detectChanges();
        }));
    }
}
PrgLayoutsEmptyComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLayoutsEmptyComponent, deps: [{ token: i1.NGXLogger }, { token: IsLoadingDataService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component });
PrgLayoutsEmptyComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgLayoutsEmptyComponent, selector: "prg-layouts-empty", ngImport: i0, template: "<main>\r\n  <router-outlet></router-outlet>\r\n  <p-toast\r\n    [showTransitionOptions]=\"'350ms'\"\r\n    [hideTransitionOptions]=\"'350ms'\"\r\n    [showTransformOptions]=\"'translateY(-100%)'\"\r\n    key=\"message\"\r\n    position=\"top-center\"\r\n    appendTo=\"body\"\r\n  ></p-toast>\r\n  <p-confirmDialog\r\n    [style]=\"{ width: '50vw' }\"\r\n    rejectButtonStyleClass=\"p-button-text\"\r\n    key=\"confirmationDialog\"\r\n    appendTo=\"body\"\r\n    [dismissableMask]=\"true\"\r\n  ></p-confirmDialog>\r\n\r\n  <p-progressSpinner\r\n    *ngIf=\"spinnerVisible\"\r\n    class=\"spinnerPNG\"\r\n    [style]=\"{ width: '120px', height: '120px' }\"\r\n  ></p-progressSpinner>\r\n  <div class=\"mainContainer\"></div>\r\n</main>\r\n", styles: [".spinnerPNG{width:100%;height:100%;position:sticky;display:flex;align-items:center;z-index:999999}.mainContainer{position:relative}main{height:100vh;overflow:auto}\n"], dependencies: [{ kind: "directive", type: i1$1.RouterOutlet, selector: "router-outlet", outputs: ["activate", "deactivate", "attach", "detach"], exportAs: ["outlet"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i9$1.ProgressSpinner, selector: "p-progressSpinner", inputs: ["style", "styleClass", "strokeWidth", "fill", "animationDuration"] }, { kind: "component", type: i6$1.Toast, selector: "p-toast", inputs: ["key", "autoZIndex", "baseZIndex", "style", "styleClass", "position", "preventOpenDuplicates", "preventDuplicates", "showTransformOptions", "hideTransformOptions", "showTransitionOptions", "hideTransitionOptions", "breakpoints"], outputs: ["onClose"] }, { kind: "component", type: i7$1.ConfirmDialog, selector: "p-confirmDialog", inputs: ["header", "icon", "message", "style", "styleClass", "maskStyleClass", "acceptIcon", "acceptLabel", "acceptAriaLabel", "acceptVisible", "rejectIcon", "rejectLabel", "rejectAriaLabel", "rejectVisible", "acceptButtonStyleClass", "rejectButtonStyleClass", "closeOnEscape", "dismissableMask", "blockScroll", "rtl", "closable", "appendTo", "key", "autoZIndex", "baseZIndex", "transitionOptions", "focusTrap", "defaultFocus", "breakpoints", "visible", "position"], outputs: ["onHide"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLayoutsEmptyComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-layouts-empty', template: "<main>\r\n  <router-outlet></router-outlet>\r\n  <p-toast\r\n    [showTransitionOptions]=\"'350ms'\"\r\n    [hideTransitionOptions]=\"'350ms'\"\r\n    [showTransformOptions]=\"'translateY(-100%)'\"\r\n    key=\"message\"\r\n    position=\"top-center\"\r\n    appendTo=\"body\"\r\n  ></p-toast>\r\n  <p-confirmDialog\r\n    [style]=\"{ width: '50vw' }\"\r\n    rejectButtonStyleClass=\"p-button-text\"\r\n    key=\"confirmationDialog\"\r\n    appendTo=\"body\"\r\n    [dismissableMask]=\"true\"\r\n  ></p-confirmDialog>\r\n\r\n  <p-progressSpinner\r\n    *ngIf=\"spinnerVisible\"\r\n    class=\"spinnerPNG\"\r\n    [style]=\"{ width: '120px', height: '120px' }\"\r\n  ></p-progressSpinner>\r\n  <div class=\"mainContainer\"></div>\r\n</main>\r\n", styles: [".spinnerPNG{width:100%;height:100%;position:sticky;display:flex;align-items:center;z-index:999999}.mainContainer{position:relative}main{height:100vh;overflow:auto}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.NGXLogger }, { type: IsLoadingDataService }, { type: i0.ChangeDetectorRef }]; } });

/**
 * Injectable
 */
/**
 * Guard to verify if there is a logged user. If true, user can't access login page and register page.
 */
class AuthGuardLogin {
    /**
     * constructor
     * @param authService
     * @param router
     */
    constructor(authService, router) {
        this.authService = authService;
        this.router = router;
    }
    /**
     *  This method is responsable to check if there is a user logged on local storage and return true if not or redirect user to home page if there is a user logged
     * @param {ActivatedRouteSnapshot} route
     * @param {RouterStateSnapshot} state
     * @returns {Observable<boolean | UrlTree> | Promise<boolean | UrlTree> | boolean | UrlTree}
     */
    canActivate(route, state) {
        if (!this.authService.getLoggedUser()) {
            return true;
        }
        else {
            return this.router.createUrlTree(['']);
        }
    }
}
AuthGuardLogin.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AuthGuardLogin, deps: [{ token: AbstractAuthService }, { token: i1$1.Router }], target: i0.ɵɵFactoryTarget.Injectable });
AuthGuardLogin.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AuthGuardLogin, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AuthGuardLogin, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: AbstractAuthService }, { type: i1$1.Router }]; } });

/**
 * Authentication routing module routes
 */
const standardRoutes$7 = [];
/**
 * Authentication Routing Module
 */
class PrgAuthRoutingModule {
}
PrgAuthRoutingModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthRoutingModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
PrgAuthRoutingModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthRoutingModule, imports: [i1$1.RouterModule], exports: [RouterModule] });
PrgAuthRoutingModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthRoutingModule, providers: [
        {
            provide: ROUTES,
            useFactory: () => {
                let routes = [];
                routes.push({
                    path: authConfig.authRoutingBasePath,
                    component: PrgLayoutsEmptyComponent,
                    children: [
                        {
                            path: authConfig.authRoutingSignupPath,
                            component: PrgAuthRegisterPage,
                            canActivate: [AuthGuardLogin],
                        },
                        {
                            path: authConfig.authRoutingLoginPath,
                            component: PrgAuthLoginPage,
                            canActivate: [AuthGuardLogin],
                        },
                        {
                            path: authConfig.authRoutingRequestPasswordPath,
                            component: PrgAuthRequestPasswordPage,
                        },
                        {
                            path: authConfig.authRoutingResetPasswordPath,
                            /*canActivate: [PrgAuthGuardPassword],*/
                            component: PrgAuthResetPasswordPage,
                        },
                        {
                            path: '',
                            redirectTo: authConfig.authRoutingLoginPath,
                            pathMatch: 'full',
                        },
                    ],
                });
                return [...routes, ...standardRoutes$7];
            },
            multi: true,
        },
    ], imports: [RouterModule.forChild(standardRoutes$7), RouterModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthRoutingModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [RouterModule.forChild(standardRoutes$7)],
                    exports: [RouterModule],
                    providers: [
                        {
                            provide: ROUTES,
                            useFactory: () => {
                                let routes = [];
                                routes.push({
                                    path: authConfig.authRoutingBasePath,
                                    component: PrgLayoutsEmptyComponent,
                                    children: [
                                        {
                                            path: authConfig.authRoutingSignupPath,
                                            component: PrgAuthRegisterPage,
                                            canActivate: [AuthGuardLogin],
                                        },
                                        {
                                            path: authConfig.authRoutingLoginPath,
                                            component: PrgAuthLoginPage,
                                            canActivate: [AuthGuardLogin],
                                        },
                                        {
                                            path: authConfig.authRoutingRequestPasswordPath,
                                            component: PrgAuthRequestPasswordPage,
                                        },
                                        {
                                            path: authConfig.authRoutingResetPasswordPath,
                                            /*canActivate: [PrgAuthGuardPassword],*/
                                            component: PrgAuthResetPasswordPage,
                                        },
                                        {
                                            path: '',
                                            redirectTo: authConfig.authRoutingLoginPath,
                                            pathMatch: 'full',
                                        },
                                    ],
                                });
                                return [...routes, ...standardRoutes$7];
                            },
                            multi: true,
                        },
                    ],
                }]
        }] });

/**
 * Injectable
 */
/**
 * REAL AbstractAuthService implementation
 */
class AuthService extends AbstractAuthService {
    /**
     * constructor
     * @param {AuthStorage} authStorage
     * @param {HttpClient} http
     */
    constructor(authStorage, http) {
        super(authStorage);
        this.http = http;
        this.baseUrl = 'http://localhost:8080';
    }
    /**
     * User login (Async)
     *
     * @param {string} email The user e-mail
     * @param {string} password The user password
     * @param {boolean} storeUserName Store username
     * @returns Boolean promise, true when successful
     */
    loginAsync(email, password, storeUserName) {
        return firstValueFrom(this.http.get(this.baseUrl));
    }
    /**
     * User logout (Async)
     *
     * @returns Boolean promise, true when successful
     */
    logoutAsync() {
        return new Promise((resolve) => {
            this.setLoggedUser(null);
            resolve(true);
        });
    }
    /**
     * User sign up (Async)
     *
     * @param {string} email The user e-mail
     * @returns Boolean promise, true when successful
     */
    signupAsync(email) {
        throw new Error('Method not implemented.');
    }
    /**
     * Request to reset the password (Async)
     *
     * @param {string} email The user e-mail
     * @returns Boolean promise, true when successful
     */
    requestResetPasswordAsync(email) {
        return Promise.resolve(false);
    }
    /**
     * Getter for token reset password (Async)
     *
     * @param {string} tokenReset The token reset password
     * @returns Boolean promise, true when successful
     */
    getTokenResetPasswordAsync(tokenReset) {
        return Promise.resolve(false);
    }
    /**
     * Method for reset password (Async)
     *
     * @param {string} newPassword The new password
     * @param {string} tokenReset The token reset password
     * @returns Boolean promise, true when successful
     */
    resetPasswordAsync(newPassword, tokenReset) {
        return Promise.resolve(false);
    }
}
AuthService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AuthService, deps: [{ token: 'AUTHSTORAGE' }, { token: i1$3.HttpClient }], target: i0.ɵɵFactoryTarget.Injectable });
AuthService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AuthService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AuthService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: ['AUTHSTORAGE']
                }] }, { type: i1$3.HttpClient }]; } });

// CR: falta o multilingue em todo o módulo
/**
 * Module that handles authentication
 */
class PrgAuthModule {
    constructor(injector) {
        this.injector = injector;
        appInjector$8 = this.injector;
    }
    static forRoot(prgAuthConfig) {
        authConfig = prgAuthConfig;
        return {
            ngModule: PrgAuthModule,
            providers: [
                {
                    provide: PRG_AUTH_CONFIG,
                    useValue: prgAuthConfig,
                },
                {
                    provide: AbstractAuthService,
                    useClass: prgAuthConfig.useMockServices
                        ? MockAuthService
                        : AuthService,
                },
                {
                    provide: 'AUTHSTORAGE',
                    useValue: authConfig.authStorage,
                }, // CR: ok o tipo de storage deve ser uma configuração no environment e o nome que lhe damos deve ser mais generico (ex: "AUTHSTORAGE")
            ],
        };
    }
}
PrgAuthModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgAuthModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthModule, declarations: [PrgAuthRegisterPage,
        PrgFormRegisterComponent,
        PrgAuthLoginPage,
        PrgFormLoginComponent,
        PrgFormRequestPasswordComponent,
        PrgAuthRequestPasswordPage,
        PrgFormResetPasswordComponent,
        PrgAuthResetPasswordPage], imports: [PrgSharedComponentsModule, PrgAuthRoutingModule], exports: [PrgFormRegisterComponent,
        PrgFormLoginComponent,
        PrgFormRequestPasswordComponent,
        PrgFormResetPasswordComponent] });
PrgAuthModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthModule, imports: [PrgSharedComponentsModule, PrgAuthRoutingModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        PrgAuthRegisterPage,
                        PrgFormRegisterComponent,
                        PrgAuthLoginPage,
                        PrgFormLoginComponent,
                        PrgFormRequestPasswordComponent,
                        PrgAuthRequestPasswordPage,
                        PrgFormResetPasswordComponent,
                        PrgAuthResetPasswordPage,
                    ],
                    imports: [PrgSharedComponentsModule, PrgAuthRoutingModule],
                    exports: [
                        PrgFormRegisterComponent,
                        PrgFormLoginComponent,
                        PrgFormRequestPasswordComponent,
                        PrgFormResetPasswordComponent,
                    ],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
let appInjector$8;
/**
 * Exports the AuthCoreConfig object
 */
let authConfig;

/**
 * BaseEntity class extended by most framework entities
 */
class BaseEntity {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        /**
         * Universal State lookup table item id (foreign key)
         */
        this.universalStateId = UniversalState.Active;
        Object.assign(this, init);
    }
}
var UniversalState;
(function (UniversalState) {
    UniversalState["Inactive"] = "0";
    UniversalState["Active"] = "1";
})(UniversalState || (UniversalState = {}));

/**
 * ConfigurationItem class that defines generic configurations
 */
/**
 * The model of Configuration Items
 */
class ConfigurationItem extends BaseEntity {
    //isSystem
    /**
     * Constructor
     * @param {Partial<ConfigurationItem>} init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/**
 * Enum of most common sub-paths of config items
 */
var ConfigItemsPath;
(function (ConfigItemsPath) {
    ConfigItemsPath["Defaults"] = "Defaults";
    ConfigItemsPath["UserPreferences"] = "User-Preferences";
})(ConfigItemsPath || (ConfigItemsPath = {}));

/**
 * ConfigurationItemsService class that defines an
 * <br />abstract authentication service to
 * <br />be extended by the mock and real
 * <br />configuration items services
 */
class AbstractConfigurationItemsService$1 {
    constructor() {
        /**
         * Current configurationItems
         */
        this.configurationItemsSubject = new BehaviorSubject(null);
    }
    /**
     * Setter for configurationItemsSubject
     *
     * @param {ConfigurationItem[]} value The ConfigurationItems array
     */
    setConfigurationItems(value) {
        this.configurationItemsSubject.next(value);
    }
    /**
     * Getter for configurationItemsSubject
     *
     * @returns The configurationItemsSubject as an observable
     */
    getConfigurationItemsObservable() {
        return this.configurationItemsSubject.asObservable();
    }
    /**
     * Getter for configurationItemsSubject
     *
     * @returns The configurationItemsSubject current value
     */
    getConfigurationItemsValue() {
        return this.configurationItemsSubject.getValue();
    }
}

/**
 * Class BaseField
 */
class BaseField {
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init) {
        /**
         * read only
         */
        this.readonly = false;
        /**
         * disabled
         */
        this.disabled = false;
        /**
         * path to translation
         */
        this.basePathTranslation = null;
        /**
         * Disabled output event
         * @type {boolean}
         */
        this.disabledOutputEvent = true;
        Object.assign(this, init);
    }
}

var ControlName;
(function (ControlName) {
    ControlName["inputText"] = "inputText";
    ControlName["inputNumber"] = "inputNumber";
    ControlName["inputDateTime"] = "inputDateTime";
    ControlName["inputPassword"] = "inputPassword";
    ControlName["dropdown"] = "dropdown";
    ControlName["multiSelect"] = "multiSelect";
    ControlName["checkbox"] = "checkbox";
    ControlName["triStateCheckbox"] = "triStateCheckbox";
    ControlName["inputTextArea"] = "inputTextArea";
    ControlName["selectButton"] = "selectButton";
    ControlName["radioButton"] = "radioButton";
    ControlName["colorPicker"] = "colorPicker";
    ControlName["inputMask"] = "inputMask";
    ControlName["slider"] = "slider";
    ControlName["inputSwitch"] = "inputSwitch";
    ControlName["rating"] = "rating";
    ControlName["knob"] = "knob";
    ControlName["chips"] = "chips";
    ControlName["toggleButton"] = "toggleButton";
    ControlName["listBox"] = "listBox";
    ControlName["cascadeSelect"] = "cascadeSelect";
    ControlName["autoComplete"] = "autoComplete";
})(ControlName || (ControlName = {}));

/**
 * Class CheckBox
 */
class CheckboxConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.checkbox;
        /**
         *Name of the checkbox group.
         */
        this.name = null;
        /*  /!**
         *Value of the checkbox.
         *!/
        public value: any = null;*/ //Property already on Base Field
        /**
         *Label of the checkbox.
         */
        this.label = null;
        /*
        /!**
         *When present, it specifies that the element should be disabled.
         *!/
        public disabled: boolean = false;*/ //Property already on Base Field
        /**
         *Allows to select a boolean value instead of multiple values.
         */
        this.binary = true;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Used to define a string that labels the input element.
         */
        this.ariaLabel = null;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Style class of the label.
         */
        this.labelStyleClass = null;
        /**
         *Icon class of the checkbox icon.
         */
        this.checkboxIcon = 'pi pi-check';
        /*  /!**
         *When present, it specifies that the component cannot be edited.
         *!/
        public readonly: boolean = false;*/ //Property already on Base Field
        /**
         *When present, it specifies that checkbox must be checked before submitting the form.
         */
        this.required = false;
        /**
         *An array of objects to display as dynamic values.Mandatory field.
         */
        this.options = null;
        /**
         *Name of the value field of an option. Default 'value'.
         */
        this.optionValue = 'value';
        /**
         *Name of the key field of an option.Default 'key'.Also used to bring the translation of the field
         */
        this.optionKey = 'key';
        /**
         * Allow multiple checkbox selection. On false , whenever a checkbox is checked the others became disabled.
         */
        this.allowMultipleCheckBoxSelection = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetCheckboxConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input checkbox configs and assign configs to element
     */
    set setCheckboxConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetCheckboxConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetCheckboxConfigsDirective, deps: [{ token: i9.Checkbox }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetCheckboxConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetCheckboxConfigsDirective, selector: "[setCheckboxConfigs]", inputs: { setCheckboxConfigs: "setCheckboxConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetCheckboxConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setCheckboxConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i9.Checkbox }]; }, propDecorators: { setCheckboxConfigs: [{
                type: Input
            }] } });

/**
 * Class Input Fiels
 */
class InputNumberConfiguration extends BaseField {
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputNumber;
        /**
         *Whether to format the value.
         */
        this.format = true;
        /**
         *Displays spinner buttons.
         */
        this.showButtons = false;
        /**
         *Layout of the buttons, valid values are stacked (default), horizontal and vertical.
         */
        this.buttonLayout = 'stacked';
        /**
         *Style class of the increment button.
         */
        this.incrementButtonClass = null;
        /**
         *Style class of the decrement button.
         */
        this.decrementButtonClass = null;
        /**
         *Style class of the increment button.
         */
        this.incrementButtonIcon = 'pi pi-chevron-up';
        /**
         *Style class of the decrement button.
         */
        this.decrementButtonIcon = 'pi pi-chevron-down';
        /**
         *Locale to be used in formatting.
         */
        this.locale = undefined;
        /**
         *The locale matching algorithm to use. Possible values are lookup and best fit; the default is best fit. See Locale Negotation for details.
         */
        this.localeMatcher = 'best fit';
        /**
         *Defines the behavior of the component, valid values are decimal and currency.
         */
        this.mode = 'decimal';
        /**
         *Text to display before the value.
         */
        this.prefix = null;
        /**
         *Text to display after the value.
         */
        this.suffix = null;
        /**
         *The currency to use in currency formatting. Possible values are the ISO 4217 currency codes, such as USD for the US dollar, EUR for the euro, or CNY for the Chinese RMB. There is no default value; if the style is currency, the currency property must be provided.
         */
        this.currency = undefined;
        /**
         *How to display the currency in currency formatting. Possible values are symbol to use a localized currency symbol such as €, ücode to use the ISO currency code, name to use a localized currency name such as dollar; the default is symbol.
         */
        this.currencyDisplay = 'symbol';
        /**
         *Whether to use grouping separators, such as thousands separators or thousand/lakh/crore separators.
         */
        this.useGrouping = true;
        /**
         *The minimum number of fraction digits to use. Possible values are from 0 to 20; the default for plain number and percent formatting is 0; the default for currency formatting is the number of minor unit digits provided by the ISO 4217 currency code list (2 if the list doesn't provide that information).
         */
        this.minFractionDigits = null;
        /**
         *The maximum number of fraction digits to use. Possible values are from 0 to 20; the default for plain number formatting is the larger of minimumFractionDigits and 3; the default for currency formatting is the larger of minimumFractionDigits and the number of minor unit digits provided by the ISO 4217 currency code list (2 if the list doesn't provide that information).
         */
        this.maxFractionDigits = null;
        /**
         *Mininum boundary value.
         */
        this.min = null;
        /**
         *Maximum boundary value.
         */
        this.max = null;
        /**
         *Step factor to increment/decrement the value.
         */
        this.step = 1;
        /**
         *Determines whether the input field is empty.
         */
        this.allowEmpty = true;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Inline style of the input field.
         */
        this.inputStyle = null;
        /**
         *Style class of the input field.
         */
        this.inputStyleClass = null;
        /**
         *Advisory information to display on input.
         */
        /*  public placeholder: string = null;*/ // this property is translated on multilingue
        /**
         *Size of the input field.
         */
        this.size = null;
        /**
         *Maximum number of character allows in the input field.
         */
        this.maxlength = null;
        /**
         *Specifies tab order of the element.
         */
        this.tabindex = null;
        /*
        /!**
         *When present, it specifies that the element should be disabled.
         *!/
        public disabled: boolean = false;*/ //Property already on Base Field
        /**
         *When present, it specifies that an input field is read-only.
         */
        // public readonly: boolean = false; // CR: already in base field
        /**
         *Title text of the input text.
         */
        this.title = null;
        /**
         *Used to define a string that labels the input element.
         */
        this.ariaLabel = null;
        /**
         *Used to indicate that user input is required on an element before a form can be submitted.
         */
        this.ariaRequired = false;
        /**
         *Name of the input field.
         */
        // public name: string = null; // this property is translated on multilingue
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.autocomplete = null;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        Object.assign(this, init);
    }
}
/**
 * directive
 */
class PrgSetInputNumberConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input number configs and assign configs to element
     */
    set setInputNumberConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetInputNumberConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputNumberConfigsDirective, deps: [{ token: i1$4.InputNumber }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetInputNumberConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetInputNumberConfigsDirective, selector: "[setInputNumberConfigs]", inputs: { setInputNumberConfigs: "setInputNumberConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputNumberConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setInputNumberConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$4.InputNumber }]; }, propDecorators: { setInputNumberConfigs: [{
                type: Input
            }] } });

var ReferenceType;
(function (ReferenceType) {
    ReferenceType["LookupTable"] = "lookupTable";
    ReferenceType["EntityType"] = "entityType";
    ReferenceType["EntityTypeAllData"] = "entityTypeAllData";
})(ReferenceType || (ReferenceType = {}));

/**
 * Injectable
 */
/**
 * BaseCacheService
 */
class BaseCacheService {
    constructor() {
        /**
         * map with a BehaviorSubject for each element
         */
        this.cacheMapSubject = new Map();
        /**
         * BehaviorSubject of a list of elements
         */
        this.cacheListSubject = new BehaviorSubject(null);
        /**
         * cache expiration time
         */
        this.cacheTimeMs = 15000;
        /**
         * saves the date the cache was updated
         */
        this.entityTypeGetDate = null;
    }
    /**
     *
     * @param values
     * @param key
     */
    setToCache(values, key = 'id') {
        this.setToCacheMap(values, key);
        this.setToCacheList(values);
    }
    /**
     * this function is responsible for managing the cache of each element
     * @param values
     * @param key
     */
    setToCacheMap(values, key = 'id') {
        if (this.cacheMapSubject == null) {
            this.cacheMapSubject = new Map();
        }
        if (!Array.isArray(values)) {
            values = [values];
        }
        if (Array.isArray(values)) {
            values.forEach((value) => {
                if (value[key]) {
                    if (this.cacheMapSubject.has(value[key])) {
                        this.cacheMapSubject.get(value[key]).next(value);
                    }
                    else {
                        this.cacheMapSubject.set(value[key], new BehaviorSubject(value));
                    }
                }
            });
        }
        this.entityTypeGetDate = new Date();
    }
    /**
     * this function is responsible for managing the cache of a list of elements
     * @param values
     */
    setToCacheList(values) {
        if (this.cacheListSubject.getValue() == null) {
            this.cacheListSubject.next([]);
        }
        if (!Array.isArray(values)) {
            values = [values];
        }
        values.forEach((value) => {
            if (value['id'] != null) {
                const element = this.cacheListSubject
                    .getValue()
                    .find((el) => el['id'] === value['id']);
                if (element != null) {
                    Object.assign(element, value);
                    return;
                }
            }
            this.cacheListSubject.getValue().push(value);
        });
        this.cacheListSubject.next(this.cacheListSubject.getValue());
    }
    /**
     * Getter for cache map element by key
     *
     * @returns The elmement as an observable
     */
    getElementObservableByKey(key) {
        return this.cacheMapSubject.get(key);
    }
    /**
     * Getter for element value by key
     *
     * @returns Element current value
     */
    getElementByKey(key) {
        const subjectByKey = this.cacheMapSubject.get(key);
        return subjectByKey ? subjectByKey.getValue() : null;
    }
    /**
     * returns the observale of the list
     * @returns
     */
    getElementsListObservable() {
        return this.cacheListSubject.asObservable();
    }
    /**
     * returns the elements of the list
     * @returns
     */
    getElementsList() {
        return this.cacheListSubject.getValue();
    }
    /**
     * return if cache is valid
     * @returns boolean
     */
    isCacheValid() {
        if (!this.entityTypeGetDate ||
            new Date().getTime() - this.entityTypeGetDate.getTime() >=
                this.cacheTimeMs) {
            return false;
        }
        else {
            return true;
        }
    }
}
BaseCacheService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: BaseCacheService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
BaseCacheService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: BaseCacheService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: BaseCacheService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }] });

/**
 * AbstractLookupTableService class that defines an
 * <br />abstract lookup tables service to
 * <br />be extended by the mock and real
 * <br />lookup tables services
 */
class AbstractLookupTableService extends BaseCacheService {
    /** constructor */
    constructor(translationService) {
        super();
        this.translationService = translationService;
    }
    /**
     * this service get translations for all lookup table items
     *
     * @param lookupTable
     * @returns
     */
    async getTranslations(lookupTable) {
        return new Promise((resolve, reject) => {
            lookupTable.items.map(async (item) => {
                item.label = await this.translationService
                    .get('lookup-tables.' +
                    lookupTable.name +
                    '.items.' +
                    lookupTable.name +
                    '.' +
                    item['name'] +
                    '.name')
                    .toPromise();
                item.description = await this.translationService
                    .get('lookup-tables.' +
                    lookupTable.name +
                    '.items.' +
                    lookupTable.name +
                    '.' +
                    item['name'] +
                    '.description')
                    .toPromise();
            });
            resolve(lookupTable);
        });
        return lookupTable;
    }
}

/**
 * Injectable
 */
class AbstractEntityTypeService extends BaseCacheService {
    /**
     * constructor
     * @param notificationsService notificationsService
     * @param translationService
     */
    constructor(notificationsService, translationService) {
        super();
        this.notificationsService = notificationsService;
        this.translationService = translationService;
        this.cacheTimeMs = 5000;
    }
    /* this service get translations for all entity types,properties and attributes
     * @param {EntityType[] | EntityType} entities
     * @returns {Promise<EntityType[] | EntityType>}
     * @protected
     */
    async getTranslationsAsync(entities) {
        return new Promise((resolve, reject) => {
            if (Array.isArray(entities)) {
                //Translate Entities
                let entitiesType = entities;
                entitiesType.map(async (entityType) => {
                    entityType.label = await this.translationService
                        .get('entities.' + entityType.name.toLowerCase() + '.label')
                        .toPromise();
                    if (entityType.operations) {
                        entityType.operations.map(async (operation) => {
                            operation.label = await this.translationService
                                .get('entities.' +
                                entityType.name.toLowerCase() +
                                '.operations.' +
                                operation.name.toLowerCase() +
                                '.label')
                                .toPromise();
                        });
                    }
                });
                resolve(entitiesType);
            }
            else {
                //Translate properties and attributes of the entity
                let entity = entities;
                if (entity.properties) {
                    entity.properties.map(async (property) => {
                        property.label = await this.translationService
                            .get('entities.' +
                            entity.name.toLowerCase() +
                            '.fields.' +
                            property.name.toLowerCase() +
                            '.label')
                            .toPromise();
                    });
                }
                if (entity.attributes) {
                    entity.attributes.map(async (attribute) => {
                        attribute.label = await this.translationService
                            .get('entities.' +
                            entity.name.toLowerCase() +
                            '.fields.' +
                            attribute.name.toLowerCase() +
                            '.label')
                            .toPromise();
                    });
                }
                if (entity.operations) {
                    entity.operations.map(async (operation) => {
                        operation.label = await this.translationService
                            .get('entities.' +
                            entity.name.toLowerCase() +
                            '.operations.' +
                            operation.name.toLowerCase() +
                            '.label')
                            .toPromise();
                    });
                }
                resolve(entity);
            }
        });
    }
}
AbstractEntityTypeService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AbstractEntityTypeService, deps: [{ token: NotificationsService }, { token: i5.TranslateService }], target: i0.ɵɵFactoryTarget.Injectable });
AbstractEntityTypeService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AbstractEntityTypeService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AbstractEntityTypeService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: NotificationsService }, { type: i5.TranslateService }]; } });

/**
 * Class Select
 */
class SelectConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.dropdown;
        /**
         * Reference type
         */
        this.referenceType = null;
        /**
         * Reference name -> shoud be a lookup table name
         */
        this.referenceName = null;
        /**
         *An array of objects to display as the available options.
         */
        this.options = null;
        /**
         *Name of the label field of an option.
         */
        this.optionLabel = 'label';
        /**
         *Name of the value field of an option.
         */
        this.optionValue = 'value';
        /**
         *Name of the disabled field of an option.
         */
        this.optionDisabled = 'disabled';
        /**
         *Name of the label field of an option group.
         */
        this.optionGroupLabel = 'label';
        /**
         *Name of the options field of an option group.
         */
        this.optionGroupChildren = 'items';
        /**
         *Name of the input element.
         */
        this.name = null;
        /**
         *Height of the viewport in pixels, a scrollbar is defined if height of list exceeds this value.
         */
        this.scrollHeight = '200px';
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Inline style of the overlay panel element.
         */
        this.panelStyle = null;
        /**
         *Style class of the element.
         */
        this.styleClass = null;
        /**
         *Style class of the overlay panel element.
         */
        this.panelStyleClass = null;
        /**
         *When specified, displays an input field to filter the items on keyup.
         */
        this.filter = false;
        /**
         *When specified, filter displays with this value.
         */
        this.filterValue = null;
        /**
         *When filtering is enabled, filterBy decides which field or fields (comma separated) to search against.
         */
        this.filterBy = null;
        /**
         *Defines how the items are filtered, valid values are contains (default) startsWith, endsWith, equals, notEquals, in, lt, lte, gt and gte.
         */
        this.filterMatchMode = 'contains';
        /**
         *Placeholder text to show when filter input is empty.
         */
        this.filterPlaceholder = null;
        /**
         *Locale to use in filtering. The default locale is the host environment's current locale.
         */
        this.filterLocale = 'undefined';
        /**
         *When present, it specifies that an input field must be filled out before submitting the form.
         */
        this.required = false;
        /*
        /!**
         *When present, it specifies that the component should be disabled.
         *!/
        public disabled: boolean = false;*/ //Property already on Base Field
        /*  /!**
         *When present, it specifies that the component cannot be edited.
         *!/
        public readonly: boolean = false;*/ //Property already on Base Field
        /**
         *Text to display when there is no data. Defaults to global value in i18n translation configuration.
         */
        this.emptyMessage = 'No records found.';
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *When present, custom value instead of predefined options can be entered using the editable input field.
         */
        this.editable = false;
        /**
         *Maximum number of character allows in the editable input field.
         */
        this.maxlength = null;
        /**
         *Target element to attach the overlay, valid values are body or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]=mydiv for a div element having #mydiv as variable name).
         */
        this.appendTo = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Default text to display when no option is selected.
         */
        this.placeholder = null;
        /**
         *Identifier of the accessible input element.
         */
        this.inputId = null;
        /**
         *A property to uniquely identify a value in options.
         */
        this.dataKey = null;
        /**
         *When present, it specifies that the component should automatically get focus on load.
         */
        this.autofocus = false;
        /**
         *Applies focus to the filter element when the overlay is shown.
         */
        this.autofocusFilter = false;
        /**
         *Clears the filter value when hiding the dropdown.
         */
        this.resetFilterOnHide = false;
        /**
         *Icon class of the dropdown icon.
         */
        this.dropdownIcon = 'pi pi-chevron-down';
        /**
         *Text to display when filtering does not return any results.
         */
        this.emptyFilterMessage = 'No results found';
        /**
         *Whether to display the first item as the label if no placeholder is defined and value is null.
         */
        this.autoDisplayFirst = true;
        /**
         *Whether to display options as grouped when nested options are provided.
         */
        this.group = false;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        /**
         *Base zIndex value to use in layering.
         */
        this.baseZIndex = 0;
        /**
         *Whether to automatically manage layering.
         */
        this.autoZIndex = true;
        /**
         *Transition options of the show animation.
         */
        this.showTransitionOptions = '.12s cubic-bezier(0, 0, 0.2, 1)';
        /**
         *Transition options of the hide animation.
         */
        this.hideTransitionOptions = '.1s linear';
        /**
         *Defines a string that labels the filter input.
         */
        this.ariaFilterLabel = null;
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.ariaLabel = null;
        /**
         *Advisory information to display in a tooltip on hover.
         */
        this.tooltip = null;
        /**
         *Style class of the tooltip.
         */
        this.tooltipStyleClass = null;
        /**
         *Position of the tooltip, valid values are right, left, top and bottom.
         */
        this.tooltipPosition = 'top';
        /**
         *Type of CSS position.
         */
        this.tooltipPositionStyle = 'absolute';
        /**
         *Whether the data should be loaded on demand during scroll.
         */
        this.virtualScroll = false;
        /**
         *Height of an item in the list for VirtualScrolling.
         */
        this.virtualScrollItemSize = null;
        /**
         *Whether to use the scroller feature. The properties of scroller component can be used like an object in it.
         */
        this.virtualScrollOptions = null;
        /**
         *Defines if data is loaded and interacted with in lazy manner.
         */
        this.lazy = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetSelectConfigsDirective {
    /**
     * constructor
     * @param {Dropdown} element
     * @param {AbstractLookupTableService} lookupTableService
     * @param {AbstractEntityTypeService} entityTypeService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(element, lookupTableService, entityTypeService, cd, arrayUtilityService, objectsUtilityService) {
        this.element = element;
        this.lookupTableService = lookupTableService;
        this.entityTypeService = entityTypeService;
        this.cd = cd;
        this.arrayUtilityService = arrayUtilityService;
        this.objectsUtilityService = objectsUtilityService;
    }
    /**
     * get options from lookup table or entity type list
     * and assign configs to element
     */
    set setSelectConfigs(configs) {
        switch (configs.referenceType) {
            case ReferenceType.LookupTable:
                if (configs.referenceName !== null && configs.referenceName.length) {
                    this.lookupTableService
                        .getLookupTableItemsByLookupTableNameAsync(configs.referenceName)
                        .then((options) => {
                        configs.options = this.objectsUtilityService.cloneObject(options);
                        Object.assign(this.element, configs);
                        /**
                         * we need to set the value of the control
                         * again because for some reason it stays null
                         * and doesn't map the value selected by default,
                         * we've already had to analyse this
                         * and for now we can't understand why this behaviour
                         */
                        if (!this.form) {
                            this.form = new FormGroup({
                                [configs.key]: new FormControl(),
                            });
                        }
                        if (configs.value != null) {
                            this.form.get(configs.key).setValue(configs.value);
                            this.cd.detectChanges();
                        }
                    });
                    this.cd.detectChanges();
                }
                else {
                    this.lookupTableService.getAllLookupTableAsync().then((options) => {
                        configs.options = this.objectsUtilityService.cloneObject(options);
                        Object.assign(this.element, configs);
                        /**
                         * we need to set the value of the control
                         * again because for some reason it stays null
                         * and doesn't map the value selected by default,
                         * we've already had to analyse this
                         * and for now we can't understand why this behaviour
                         */
                        if (configs.value) {
                            this.form.get(configs.key).setValue(configs.value);
                        }
                    });
                }
                break;
            case ReferenceType.EntityType:
                this.entityTypeService.getEntityTypeListAsync().then((value) => {
                    configs.options = value;
                    Object.assign(this.element, configs);
                    if (configs.value) {
                        this.form.get(configs.key).setValue(configs.value);
                    }
                });
                this.cd.detectChanges();
                break;
            case ReferenceType.EntityTypeAllData:
                this.entityTypeService.getEntityTypeListAsync().then((value) => {
                    let entities = this.arrayUtilityService.clone(value);
                    entities.map(async (entityType, index) => {
                        let entityTypeAllData = this.objectsUtilityService.cloneObject(await this.entityTypeService.getAllEntityTypeDataByName(entityType.name));
                        entities[index].properties = this.objectsUtilityService.cloneObject(entityTypeAllData.properties);
                        entities[index].attributes = this.objectsUtilityService.cloneObject(entityTypeAllData.attributes);
                        entities[index].operations = this.objectsUtilityService.cloneObject(entityTypeAllData.operations);
                        /* entities[index]['data'] = [];
                        entities[index]['data'].push({
                          subData: this.arrayUtilityService.clone(
                            entityTypeAllData.operations
                          ),
                          label: 'operations',
                        });
            
                        entities[index]['data'].push({
                          subData: this.arrayUtilityService.clone(
                            entityTypeAllData.properties
                          ),
                          label: 'properties',
                        });
                        entities[index]['data'].push({
                          subData: this.arrayUtilityService.clone(
                            entityTypeAllData.attributes
                          ),
                          label: 'attributes',
                        });*/
                    });
                    configs.options = entities;
                    Object.assign(this.element, configs);
                    if (configs.value) {
                        this.form.get(configs.key).setValue(configs.value);
                    }
                });
                break;
            default:
                Object.assign(this.element, configs);
                break;
        }
    }
}
PrgSetSelectConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSelectConfigsDirective, deps: [{ token: i1$5.Dropdown }, { token: AbstractLookupTableService }, { token: AbstractEntityTypeService }, { token: i0.ChangeDetectorRef }, { token: ArrayUtilityService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetSelectConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetSelectConfigsDirective, selector: "[setSelectConfigs]", inputs: { form: "form", setSelectConfigs: "setSelectConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSelectConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setSelectConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$5.Dropdown }, { type: AbstractLookupTableService }, { type: AbstractEntityTypeService }, { type: i0.ChangeDetectorRef }, { type: ArrayUtilityService }, { type: ObjectsUtilityService }]; }, propDecorators: { form: [{
                type: Input
            }], setSelectConfigs: [{
                type: Input
            }] } });

/**
 * MockDatabase object to be used while developing
 * <br /> and/or testing the front-end
 */
const MockDatabase$3 = {
    ConfigurationItems: [
        {
            id: '1',
            name: 'language',
            createdBy: '1',
            path: 'Config-Items:User-Preferences:Defaults',
            value: 'language.portuguese',
            guiSettings: JSON.stringify(new SelectConfiguration({
                controlName: ControlName.dropdown,
                referenceType: ReferenceType.LookupTable,
                referenceName: 'language',
                key: 'language',
                optionLabel: 'label',
                optionValue: 'id',
                basePathTranslation: 'lookup-tables',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '2',
            name: 'language',
            createdBy: '2',
            path: 'Config-Items:User-Preferences:pedrocouto@gmail.com',
            value: 'language.english',
            guiSettings: JSON.stringify(new SelectConfiguration({
                referenceType: ReferenceType.LookupTable,
                referenceName: 'language',
                key: 'language',
                optionLabel: 'label',
                optionValue: 'id',
                basePathTranslation: 'lookup-tables',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '3',
            name: 'theme',
            createdBy: '1',
            path: 'Config-Items:User-Preferences:Defaults',
            value: 'theme.lara-light-blue',
            guiSettings: JSON.stringify(new SelectConfiguration({
                referenceType: ReferenceType.LookupTable,
                referenceName: 'theme',
                key: 'theme',
                optionLabel: 'label',
                optionValue: 'id',
                basePathTranslation: 'lookup-tables',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '4',
            name: 'theme',
            createdBy: '3',
            path: 'Config-Items:User-Preferences:pedrolima@gmail.com',
            value: 'theme.bootstrap4-dark-purple',
            guiSettings: JSON.stringify(new SelectConfiguration({
                referenceType: ReferenceType.LookupTable,
                referenceName: 'theme',
                key: 'theme',
                optionLabel: 'label',
                optionValue: 'id',
                basePathTranslation: 'lookup-tables',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '5',
            name: 'theme',
            createdBy: '4',
            path: 'Config-Items:User-Preferences:luis@gmail.com',
            value: 'theme.rhea',
            guiSettings: JSON.stringify(new SelectConfiguration({
                referenceType: ReferenceType.LookupTable,
                referenceName: 'theme',
                key: 'theme',
                optionLabel: 'label',
                optionValue: 'id',
                basePathTranslation: 'lookup-tables',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '7',
            name: 'RequiredLength',
            createdBy: '1',
            path: 'Config-Items:Identity:Password',
            value: 5,
            guiSettings: JSON.stringify(new InputNumberConfiguration({
                key: 'RequiredLength',
                min: 1,
                max: 10,
                showButtons: true,
                validators: ['Validators.required'],
                basePathTranslation: 'config-items.identity.password',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '9',
            name: 'RequiredUniqueChars',
            createdBy: '1',
            path: 'Config-Items:Identity:Password',
            value: '1',
            guiSettings: JSON.stringify(new InputNumberConfiguration({
                key: 'RequiredUniqueChars',
                min: 1,
                max: 10,
                showButtons: true,
                validators: ['Validators.required'],
                basePathTranslation: 'config-items.identity.password',
                showClear: true,
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '8',
            name: 'RequireLowercase',
            createdBy: '1',
            path: 'Config-Items:Identity:Password',
            value: true,
            guiSettings: JSON.stringify(new CheckboxConfiguration({
                key: 'RequireLowercase',
                basePathTranslation: 'config-items.identity.password',
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '6',
            name: 'RequireDigit',
            createdBy: '1',
            path: 'Config-Items:Identity:Password',
            value: false,
            guiSettings: JSON.stringify(new CheckboxConfiguration({
                key: 'RequireDigit',
                basePathTranslation: 'config-items.identity.password',
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '10',
            name: 'RequireUppercase',
            createdBy: '1',
            path: 'Config-Items:Identity:Password',
            value: true,
            guiSettings: JSON.stringify(new CheckboxConfiguration({
                key: 'RequireUppercase',
                basePathTranslation: 'config-items.identity.password',
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '11',
            name: 'RequireNonAlphanumeric',
            createdBy: '1',
            path: 'Config-Items:Identity:Password',
            value: true,
            guiSettings: JSON.stringify(new CheckboxConfiguration({
                key: 'RequireNonAlphanumeric',
                validators: ['Validators.required'],
                basePathTranslation: 'config-items.identity.password',
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
        {
            id: '12',
            name: 'AllowSelfRegister',
            createdBy: '1',
            path: 'Config-Items:Identity',
            value: true,
            guiSettings: JSON.stringify(new CheckboxConfiguration({
                key: 'AllowSelfRegister',
                basePathTranslation: 'config-items.identity',
            })),
            readonly: false,
            modifiedOn: null,
            modifiedBy: null,
            createdOn: null,
            operationId: null,
            transactionId: null,
            universalStateId: null,
        },
    ],
    /* TODO: MAP Identity CONFIG TO CONFIGURATION ITEMS
      "Identity": {
        "DefaultEnabledUser": true, // user will be enabled on register
        "AllowSelfRegister": true,
        "LockoutEnabled": true,
        "CreateWorkspaceOnUserRegister": true,
        "SignIn": {
          "RequireEnabledUser": false,
          "RequireConfirmedAdmin": false,
          "RequireConfirmedEmail": true,
          "RequireConfirmedPhoneNumber": false
        },
        "Lockout": {
          "LockoutTimeSpan": "1.00:00:00" //lock out for 1 day
        },
        "Password": {
          "RequireDigit": true,
          "RequiredLength": 7,
          "RequireLowercase": true,
          "RequiredUniqueChars": 1,
          "RequireUppercase": true,
          "RequireNonAlphanumeric": true
        },
        "Callbacks": {
          "BaseUrl": "http://localhost:8100",
          "LoginUrl": "/auth/login",
          "ConfirmedAccountUrl": "/auth/confirm",
          "ResetPasswordUrl": "/auth/reset",
          "UnsubscribeUrl": "/auth/unsubscribe"
        },
        "Token": {
          "Audience": "Prg.Framework.Api.Audience",
          "Issuer": "Prg.Framework.Api.Issuer",
          "Seconds": 86400, // 24 hours
          "RefreshDuration": 24 // 24 hours
        }
      }
    */
};

/**
 * Injectable
 */
/**
 * Injectable
 */
/**
 * MOCK AbstractConfigurationItemsService implementation
 */
class MockConfigurationItemsService$1 extends AbstractConfigurationItemsService$1 {
    /**
     * Constructor
     * @param {NotificationsService} notificationsService
     * @param {UtilityService} utilityService
     * @param {IsLoadingDataService} isLoadingData
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {AbstractAuthService} authService
     */
    constructor(notificationsService, utilityService, isLoadingData, objectsUtilityService, arrayUtilityService, authService) {
        super();
        this.notificationsService = notificationsService;
        this.utilityService = utilityService;
        this.isLoadingData = isLoadingData;
        this.objectsUtilityService = objectsUtilityService;
        this.arrayUtilityService = arrayUtilityService;
        this.authService = authService;
        /**
         * default time in seconds
         */
        this.sleepTimeSec = 0.5;
    }
    /**
     * Get a list of all configuration items
     * @returns {Promise<ConfigurationItem[]>}
     */
    getAllConfigurationItemsAsync() {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const configsItems = this.arrayUtilityService.clone(MockDatabase$3.ConfigurationItems);
            this.isLoadingData.hide();
            if (configsItems) {
                resolve(configsItems);
            }
            else {
                reject('Config Items could not be loaded');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Config Items could not be loaded.',
                    detailKey: 'Server is down',
                }));
            }
        });
    }
    /**
     * Update a configuration items
     * @param configItemData
     * @returns {Promise<ConfigurationItem[]>}
     */
    updateConfigurationItemsAsync(configItemData) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            this.isLoadingData.hide();
            if (configItemData.path && configItemData.path != '') {
                Object.keys(configItemData).map((key) => {
                    if (key != 'path') {
                        let configItemToUpdate = MockDatabase$3.ConfigurationItems.find((configItem) => configItem.name === key &&
                            configItem.path === configItemData.path);
                        if (configItemToUpdate) {
                            configItemToUpdate.value = configItemData[key];
                        }
                        else {
                            let newConfigItem = this.objectsUtilityService.cloneObject({
                                path: configItemData.path,
                                name: key,
                                value: configItemData[key],
                                id: this.utilityService.newGuid(),
                                guiSettings: null,
                                universalStateId: UniversalState.Active,
                                createdOn: new Date(),
                                operationId: null,
                                modifiedBy: this.authService.getLoggedUser()?.id
                                    ? this.authService.getLoggedUser().id
                                    : null,
                                modifiedOn: new Date(),
                                createdBy: this.authService.getLoggedUser()?.id
                                    ? this.authService.getLoggedUser().id
                                    : null,
                                transactionId: null,
                                readonly: null,
                            });
                            MockDatabase$3.ConfigurationItems.push(newConfigItem);
                        }
                    }
                });
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'Configuration Item Updated.',
                    detailKey: 'Success.',
                }));
                this.setConfigurationItems(MockDatabase$3.ConfigurationItems);
                resolve(MockDatabase$3.ConfigurationItems);
            }
            else {
                reject('Configuration Items could not be save.');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Error.',
                    detailKey: 'Config Item Path is not present',
                }));
            }
        });
    }
    /**
     * Get configuration items by path
     * @param {string} path
     * @returns {Promise<any>}
     */
    getConfigurationItemsByPathAsync(path) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const configItemsBypath = this.arrayUtilityService.clone(MockDatabase$3.ConfigurationItems.filter((configItems) => {
                return configItems.path.includes(path);
            }));
            const userAndDefaultsConfigsItems = {};
            const configItemsDefaults = configItemsBypath.filter((configItemsDefaults) => {
                return configItemsDefaults.path === path + ConfigItemsPath.Defaults;
            });
            const configItemsUser = configItemsBypath.filter((configItemsUser) => {
                return (configItemsUser.path ===
                    path + this.authService.getLoggedUser()?.email);
            });
            Object.assign(userAndDefaultsConfigsItems, {
                user: configItemsUser,
                defaults: configItemsDefaults,
            });
            this.isLoadingData.hide();
            if (userAndDefaultsConfigsItems) {
                resolve(userAndDefaultsConfigsItems);
            }
            else {
                reject('Config Items could not be loaded');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Config Items could not be loaded.',
                    detailKey: 'Server is down',
                }));
            }
        });
    }
}
MockConfigurationItemsService$1.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockConfigurationItemsService$1, deps: [{ token: NotificationsService }, { token: UtilityService }, { token: IsLoadingDataService }, { token: ObjectsUtilityService }, { token: ArrayUtilityService }, { token: AbstractAuthService }], target: i0.ɵɵFactoryTarget.Injectable });
MockConfigurationItemsService$1.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockConfigurationItemsService$1, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockConfigurationItemsService$1, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: NotificationsService }, { type: UtilityService }, { type: IsLoadingDataService }, { type: ObjectsUtilityService }, { type: ArrayUtilityService }, { type: AbstractAuthService }]; } });

var ActionName;
(function (ActionName) {
    ActionName["Button"] = "button";
    ActionName["SplitButton"] = "splitButton";
    ActionName["SpeedDial"] = "speedDial";
    ActionName["SelectButton"] = "selectButton";
    ActionName["ToggleButton"] = "toggleButton";
    ActionName["InputSwitch"] = "inputSwitch";
})(ActionName || (ActionName = {}));

/**
 * class action
 */
class BaseAction {
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init) {
        /**
         * defines the element to be used
         * default is button
         */
        this.controlName = ActionName.Button;
        /**
         * with {@link #isDisabled} set to true we use this
         * field to enable or disable the button depending
         * on the validation state of the form
         */
        this.disableWhenFormInvalid = false;
        /**
         * translation base path
         */
        this.translationBasePath = 'buttons';
        /**
         * this property is only relevant for actions that go into a
         * toolbar, it indicates the slot (position) in which the
         * action should be inserted
         *
         * options: end, start
         */
        this.toolbarSlot = 'left';
        /**
         * order
         */
        this.order = 0;
        Object.assign(this, init);
    }
}
/**
 * Action output
 */
class ActionOutput {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        Object.assign(this, init);
    }
}
/**
 * Field output
 */
class FieldChangeOutput {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        Object.assign(this, init);
    }
}
/**
 * Dynamic Form Action output
 */
class DynamicFormActionOutput extends ActionOutput {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/**
 * Dynamic Form Field Change output
 */
class DynamicFormFieldChangeOutput extends FieldChangeOutput {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/**
 * Actions input type
 */
var ActionInputType;
(function (ActionInputType) {
    ActionInputType["Submit"] = "submit";
    ActionInputType["Cancel"] = "cancel";
    ActionInputType["Reset"] = "reset";
    ActionInputType["Delete"] = "delete";
    ActionInputType["Linear"] = "linear";
})(ActionInputType || (ActionInputType = {}));
/**
 * form status
 */
var FormStatus;
(function (FormStatus) {
    FormStatus["Valid"] = "valid";
    FormStatus["Invalid"] = "invalid";
    FormStatus["Disabled"] = "disabled";
})(FormStatus || (FormStatus = {}));
/**
 * base actions keys
 */
var BaseActionKey;
(function (BaseActionKey) {
    BaseActionKey["Edit"] = "edit";
    BaseActionKey["Add"] = "add";
    BaseActionKey["Reset"] = "reset";
    BaseActionKey["Delete"] = "delete";
    BaseActionKey["Save"] = "save";
    BaseActionKey["Cancel"] = "cancel";
})(BaseActionKey || (BaseActionKey = {}));

/**
 * class ButtonConfiguration
 */
class ButtonConfiguration extends BaseAction {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * Control name
         */
        this.controlName = ActionName.Button;
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.ariaLabel = null;
        /**
         *Value of the badge.
         */
        this.badge = null;
        /**
         *Style class of the badge.
         */
        this.badgeClass = null;
        /**
         *When present, it specifies that the component should be disabled.
         */
        this.disabled = false;
        /**
         *Name of the icon.
         */
        this.icon = null;
        /**
         *Position of the icon, valid values are left and right.
         */
        this.iconPos = 'left';
        /**
         *Text of the button.
         */
        this.label = null;
        /**
         *Whether the button is in loading state.
         */
        this.loading = false;
        /**
         *Icon to display in loading state.
         */
        this.loadingIcon = 'pi pi-spinner pi-spin';
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Style class of the element.
         */
        this.styleClass = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgButtonConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * set button configs, assign configs received to element
     */
    set setButtonConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgButtonConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgButtonConfigsDirective, deps: [{ token: i8.Button }], target: i0.ɵɵFactoryTarget.Directive });
PrgButtonConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgButtonConfigsDirective, selector: "[setButtonConfigs]", inputs: { setButtonConfigs: "setButtonConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgButtonConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setButtonConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i8.Button }]; }, propDecorators: { setButtonConfigs: [{
                type: Input
            }] } });

/**
 * component button
 */
class PrgButtonComponent {
    constructor() {
        /**
         * output
         */
        this.actionClick = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onButtonClicked() {
        this.actionClick.emit(new ActionOutput({ action: this.configs.key }));
    }
}
PrgButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgButtonComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgButtonComponent, selector: "prg-button-action", inputs: { configs: "configs", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<p-button\r\n\r\n  [setButtonConfigs]=\"configs\"\r\n  [label]=\"\r\n    configs.translationBasePath + '.' + configs.key + '.label' | translate\r\n  \"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n  (onClick)=\"onButtonClicked()\"\r\n></p-button>\r\n\r\n", dependencies: [{ kind: "component", type: i8.Button, selector: "p-button", inputs: ["type", "iconPos", "icon", "badge", "label", "disabled", "loading", "loadingIcon", "style", "styleClass", "badgeClass", "ariaLabel"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "directive", type: PrgButtonConfigsDirective, selector: "[setButtonConfigs]", inputs: ["setButtonConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-button-action', template: "<p-button\r\n\r\n  [setButtonConfigs]=\"configs\"\r\n  [label]=\"\r\n    configs.translationBasePath + '.' + configs.key + '.label' | translate\r\n  \"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n  (onClick)=\"onButtonClicked()\"\r\n></p-button>\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });

/**
 * Class Input Switch Action
 */
class InputSwitchActionConfiguration extends BaseAction {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ActionName.InputSwitch;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the input element.
         */
        this.inputId = null;
        /**
         *Name of the input element.
         */
        this.name = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.ariaLabel = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetInputSwitchActionConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * Input Switch Action configs and assign configs to element
     */
    set setInputSwitchActionConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetInputSwitchActionConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputSwitchActionConfigsDirective, deps: [{ token: i1$6.InputSwitch }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetInputSwitchActionConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetInputSwitchActionConfigsDirective, selector: "[setInputSwitchActionConfigs]", inputs: { setInputSwitchActionConfigs: "setInputSwitchActionConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputSwitchActionConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setInputSwitchActionConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$6.InputSwitch }]; }, propDecorators: { setInputSwitchActionConfigs: [{
                type: Input
            }] } });

/**
 * Component Input Switch Action
 */
class PrgInputSwitchActionComponent {
    constructor() {
        /**
         * output
         */
        this.actionClick = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onButtonClicked(event) {
        this.actionClick.emit(new ActionOutput({ action: this.configs.key, value: event.checked }));
    }
}
PrgInputSwitchActionComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputSwitchActionComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgInputSwitchActionComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgInputSwitchActionComponent, selector: "prg-input-switch-action", inputs: { configs: "configs", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<div class=\"field-checkbox\">\r\n  <p-inputSwitch\r\n    (onChange)=\"onButtonClicked($event)\"\r\n    [setInputSwitchActionConfigs]=\"configs\"\r\n    [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n    [inputId]=\"configs.key\"></p-inputSwitch>\r\n  <label for=\"{{configs.key}}\">{{configs.translationBasePath + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n\r\n", dependencies: [{ kind: "component", type: i1$6.InputSwitch, selector: "p-inputSwitch", inputs: ["style", "styleClass", "tabindex", "inputId", "name", "disabled", "readonly", "trueValue", "falseValue", "ariaLabel", "ariaLabelledBy"], outputs: ["onChange"] }, { kind: "directive", type: PrgSetInputSwitchActionConfigsDirective, selector: "[setInputSwitchActionConfigs]", inputs: ["setInputSwitchActionConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputSwitchActionComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-input-switch-action', template: "<div class=\"field-checkbox\">\r\n  <p-inputSwitch\r\n    (onChange)=\"onButtonClicked($event)\"\r\n    [setInputSwitchActionConfigs]=\"configs\"\r\n    [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n    [inputId]=\"configs.key\"></p-inputSwitch>\r\n  <label for=\"{{configs.key}}\">{{configs.translationBasePath + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });

/**
 * Class Select Button Action
 */
class SelectButtonActionConfiguration extends BaseAction {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ActionName.SelectButton;
        /**
         *An array of selectitems to display as the available options.
         */
        this.options = null;
        /**
         *Name of the label field of an option.
         */
        this.optionLabel = 'label';
        /**
         *Name of the value field of an option.
         */
        this.optionValue = 'value';
        /**
         *Name of the disabled field of an option.
         */
        this.optionDisabled = 'disabled';
        /**
         *When specified, allows selecting multiple values.
         */
        this.multiple = false;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = 0;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *A property to uniquely identify a value in options.
         */
        this.dataKey = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetSelectButtonActionConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * Set Select Button configs and assign configs to element
     */
    set setSelectButtonActionConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetSelectButtonActionConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSelectButtonActionConfigsDirective, deps: [{ token: i1$7.SelectButton }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetSelectButtonActionConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetSelectButtonActionConfigsDirective, selector: "[setSelectButtonActionConfigs]", inputs: { setSelectButtonActionConfigs: "setSelectButtonActionConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSelectButtonActionConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setSelectButtonActionConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$7.SelectButton }]; }, propDecorators: { setSelectButtonActionConfigs: [{
                type: Input
            }] } });

/**
 * component select button
 */
class PrgSelectButtonActionComponent {
    constructor() {
        /**
         * output
         */
        this.actionClick = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onButtonClicked(event) {
        this.actionClick.emit(new ActionOutput({
            action: this.configs.key,
            value: event?.option?.value,
            group: event?.option?.name,
        }));
    }
}
PrgSelectButtonActionComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectButtonActionComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgSelectButtonActionComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSelectButtonActionComponent, selector: "prg-select-button-action", inputs: { configs: "configs", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<p>{{\r\n    configs.translationBasePath + '.' + configs.key + '.label' | translate\r\n    }}</p>\r\n<p-selectButton\r\n  (onOptionClick)=\"onButtonClicked($event)\"\r\n  [setSelectButtonActionConfigs]=\"configs\"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n  >\r\n</p-selectButton>\r\n\r\n", dependencies: [{ kind: "component", type: i1$7.SelectButton, selector: "p-selectButton", inputs: ["options", "optionLabel", "optionValue", "optionDisabled", "tabindex", "multiple", "style", "styleClass", "ariaLabelledBy", "disabled", "dataKey"], outputs: ["onOptionClick", "onChange"] }, { kind: "directive", type: PrgSetSelectButtonActionConfigsDirective, selector: "[setSelectButtonActionConfigs]", inputs: ["setSelectButtonActionConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectButtonActionComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-select-button-action', template: "<p>{{\r\n    configs.translationBasePath + '.' + configs.key + '.label' | translate\r\n    }}</p>\r\n<p-selectButton\r\n  (onOptionClick)=\"onButtonClicked($event)\"\r\n  [setSelectButtonActionConfigs]=\"configs\"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n  >\r\n</p-selectButton>\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });

/**
 * class SpeedDialConfiguration
 */
class SpeedDialConfiguration extends BaseAction {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * Control name
         */
        this.controlName = ActionName.SpeedDial;
        /**
         *Style class of the button element.
         */
        this.buttonClassName = null;
        /**
         *Inline style of the button element.
         */
        this.buttonStyle = null;
        /**
         *Template of button element.
         */
        this.buttonTemplate = null;
        /**
         *Style class of the element.
         */
        this.className = null;
        /**
         *Specifies the opening direction of actions. Valid values are 'up', 'down', 'left', 'right', 'up-left', 'up-right', 'down-left' and 'down-right'
         */
        this.direction = 'up';
        /**
         *Whether the component is disabled.
         */
        this.disabled = false;
        /**
         *Hide icon of the button element.
         */
        this.hideIcon = null;
        /**
         *Whether the actions close when clicked outside.
         */
        this.hideOnClickOutside = true;
        /**
         *Unique identifier of the element.
         */
        this.id = null;
        /**
         *Whether to show a mask element behind the speeddial
         */
        this.mask = false;
        /**
         *Style class of the mask element.
         */
        this.maskClassName = null;
        /**
         *Inline style of the mask element.
         */
        this.maskStyle = null;
        /**
         *MenuModel instance to define the action items.
         */
        this.model = null;
        /**
         *Radius for *circle types.
         */
        this.radius = 0;
        /**
         *Defined to rotate showIcon when hideIcon is not present.
         */
        this.rotateAnimation = true;
        /**
         *Show icon of the button element.
         */
        this.showIcon = 'pi pi-plus';
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Transition delay step for each action item.
         */
        this.transitionDelay = 30;
        /**
         *Specifies the visibility of the overlay.
         */
        this.visible = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSpeedDialConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * set button configs, assign configs received to element
     */
    set setSpeedDialConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSpeedDialConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSpeedDialConfigsDirective, deps: [{ token: i1$8.SpeedDial }], target: i0.ɵɵFactoryTarget.Directive });
PrgSpeedDialConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSpeedDialConfigsDirective, selector: "[setSpeedDialConfigs]", inputs: { setSpeedDialConfigs: "setSpeedDialConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSpeedDialConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setSpeedDialConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$8.SpeedDial }]; }, propDecorators: { setSpeedDialConfigs: [{
                type: Input
            }] } });

/**
 * component speed dial
 */
class PrgSpeedDialComponent {
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     */
    constructor(arrayUtilityService) {
        this.arrayUtilityService = arrayUtilityService;
        /**
         * Data of speed button menu
         * @type {PrgMenuItem[]}
         */
        this.menuButton = [];
        /**
         * output
         */
        this.actionClick = new EventEmitter();
    }
    /**
     * Speed Dial configs
     */
    set configs(configs) {
        this._configs = configs;
        this.assignCommandsToMenuButton(configs.items);
    }
    /**
     * Getter of configs
     * @returns {SpeedDialConfiguration}
     */
    get configs() {
        return this._configs;
    }
    /**
     * function that triggers the output
     * @param {PrgMenuItem} menuItem
     */
    onButtonClicked(menuItem) {
        if (menuItem?.key) {
            this.actionClick.emit({
                action: menuItem?.key,
                group: menuItem?.group,
            });
        }
    }
    /**
     * Assign commands to menu button
     * @param {PrgMenuItem[]} menuItems
     */
    assignCommandsToMenuButton(menuItems) {
        this.menuButton = this.arrayUtilityService.clone(menuItems);
        this.menuButton.map((item) => {
            if (item.key) {
                item.command = (event) => {
                    this.onButtonClicked(event.item);
                };
            }
        });
    }
}
PrgSpeedDialComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSpeedDialComponent, deps: [{ token: ArrayUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgSpeedDialComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSpeedDialComponent, selector: "prg-speed-dial-action", inputs: { configs: "configs", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<p-speedDial\r\n  [setSpeedDialConfigs]=\"configs\"\r\n  [model]=\"menuButton\"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n></p-speedDial>\r\n", dependencies: [{ kind: "component", type: i1$8.SpeedDial, selector: "p-speedDial", inputs: ["id", "model", "visible", "style", "className", "direction", "transitionDelay", "type", "radius", "mask", "disabled", "hideOnClickOutside", "buttonStyle", "buttonClassName", "maskStyle", "maskClassName", "showIcon", "hideIcon", "rotateAnimation"], outputs: ["onVisibleChange", "visibleChange", "onClick", "onShow", "onHide"] }, { kind: "directive", type: PrgSpeedDialConfigsDirective, selector: "[setSpeedDialConfigs]", inputs: ["setSpeedDialConfigs"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSpeedDialComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-speed-dial-action', template: "<p-speedDial\r\n  [setSpeedDialConfigs]=\"configs\"\r\n  [model]=\"menuButton\"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n></p-speedDial>\r\n" }]
        }], ctorParameters: function () { return [{ type: ArrayUtilityService }]; }, propDecorators: { configs: [{
                type: Input,
                args: ['configs']
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });

/**
 * Split Button Model
 */
class SplitButtonConfiguration extends BaseAction {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * Control name
         */
        this.controlName = ActionName.SplitButton;
        /**
         *Target element to attach the overlay, valid values are body or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]=mydiv for a div element having #mydiv as variable name).
         */
        this.appendTo = null;
        /**
         *Indicates the direction of the element.
         */
        this.dir = null;
        /**
         *When present, it specifies that the component should be disabled.
         */
        this.disabled = false;
        /**
         *Defines a string that labels the expand button for accessibility.
         */
        this.expandAriaLabel = null;
        /**
         *Transition options of the hide animation.
         */
        this.hideTransitionOptions = '195ms ease-in';
        /**
         *Name of the icon.
         */
        this.icon = null;
        /**
         *Position of the icon, valid values are left and right.
         */
        this.iconPos = 'left';
        /**
         *Text of the button.
         */
        this.label = null;
        /**
         *Inline style of the overlay menu.
         */
        this.menuStyle = null;
        /**
         *Style class of the overlay menu.
         */
        this.menuStyleClass = null;
        /**
         *Transition options of the show animation.
         */
        this.showTransitionOptions = '225ms ease-out';
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSplitButtonConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * set button configs, assign configs received to element
     */
    set setSplitButtonConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSplitButtonConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSplitButtonConfigsDirective, deps: [{ token: i1$9.SplitButton }], target: i0.ɵɵFactoryTarget.Directive });
PrgSplitButtonConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSplitButtonConfigsDirective, selector: "[setSplitButtonConfigs]", inputs: { setSplitButtonConfigs: "setSplitButtonConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSplitButtonConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setSplitButtonConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$9.SplitButton }]; }, propDecorators: { setSplitButtonConfigs: [{
                type: Input
            }] } });

/**
 * component split button
 */
class PrgSplitButtonComponent {
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     */
    constructor(arrayUtilityService) {
        this.arrayUtilityService = arrayUtilityService;
        /**
         * Data of split button menu
         * @type {PrgMenuItem[]}
         */
        this.menuButton = [];
        /**
         * output
         */
        this.actionClick = new EventEmitter();
    }
    /**
     * Split Button configs
     */
    set configs(configs) {
        this._configs = configs;
        this.assignCommandsToMenuButton(configs.items);
    }
    /**
     * Getter of configs
     * @returns {SplitButtonConfiguration}
     */
    get configs() {
        return this._configs;
    }
    /**
     * function that triggers the output
     * @param {PrgMenuItem} menuItem
     */
    onButtonClicked(menuItem = null) {
        if (menuItem?.key) {
            this.actionClick.emit({
                action: menuItem?.key,
                group: menuItem?.group,
            });
        }
        else {
            this.actionClick.emit(new ActionOutput({ action: this.configs.key }));
        }
    }
    /**
     * Assign commands to menu button
     * @param {PrgMenuItem[]} menuItems
     */
    assignCommandsToMenuButton(menuItems) {
        this.menuButton = this.arrayUtilityService.clone(menuItems);
        this.menuButton.map((item) => {
            let path;
            path = item?.label;
            if (item.key) {
                item.command = (event) => {
                    this.onButtonClicked(event.item);
                };
                item.group = path;
            }
            if (item.items != null && item.items.length > 0) {
                let children = item.items;
                children.forEach((itemChildren) => {
                    return this.iterateOverChildren(itemChildren, path);
                });
            }
        });
    }
    /**
     * Iterate over all children of menu button
     * @param {PrgMenuItem} itemChildren
     * @param {string} path
     * @returns {PrgMenuItem}
     */
    iterateOverChildren(itemChildren, path) {
        let currentChildren = itemChildren;
        path = path + ':' + itemChildren.label;
        if (currentChildren.key) {
            currentChildren.command = (event) => {
                this.onButtonClicked(event.item);
            };
            itemChildren.group = path;
        }
        if (currentChildren.items != null && currentChildren.items.length > 0) {
            currentChildren.items.forEach((child) => {
                if (child.key) {
                    child.group = path + ':' + child.label;
                    child.command = (event) => {
                        this.onButtonClicked(event.item);
                    };
                }
                if (child.items != null && child.items.length > 0) {
                    this.iterateOverChildren(child, path);
                }
            });
        }
        return currentChildren;
    }
}
PrgSplitButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSplitButtonComponent, deps: [{ token: ArrayUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgSplitButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSplitButtonComponent, selector: "prg-button-action", inputs: { configs: "configs", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<p-splitButton\r\n  [setSplitButtonConfigs]=\"configs\"\r\n  [label]=\"configs.translationBasePath + '.' + configs.key + '.label' | translate\r\n\"\r\n  [model]=\"menuButton\"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!||configs.disabled\"\r\n  (onClick)=\"onButtonClicked()\"\r\n></p-splitButton>\r\n", dependencies: [{ kind: "component", type: i1$9.SplitButton, selector: "p-splitButton", inputs: ["model", "icon", "iconPos", "label", "style", "styleClass", "menuStyle", "menuStyleClass", "disabled", "tabindex", "appendTo", "dir", "expandAriaLabel", "showTransitionOptions", "hideTransitionOptions"], outputs: ["onClick", "onDropdownClick"] }, { kind: "directive", type: PrgSplitButtonConfigsDirective, selector: "[setSplitButtonConfigs]", inputs: ["setSplitButtonConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSplitButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-button-action', template: "<p-splitButton\r\n  [setSplitButtonConfigs]=\"configs\"\r\n  [label]=\"configs.translationBasePath + '.' + configs.key + '.label' | translate\r\n\"\r\n  [model]=\"menuButton\"\r\n  [disabled]=\"!form.valid && configs.disableWhenFormInvalid!||configs.disabled\"\r\n  (onClick)=\"onButtonClicked()\"\r\n></p-splitButton>\r\n" }]
        }], ctorParameters: function () { return [{ type: ArrayUtilityService }]; }, propDecorators: { configs: [{
                type: Input,
                args: ['configs']
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });

/**
 * Class ToggleButton Action
 */
class ToggleButtonActionConfiguration extends BaseAction {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ActionName.ToggleButton;
        /**
         *Enable inline label of the toggle button.
         */
        this.hasLabel = false;
        /**
         *Label for the on state.
         */
        this.onLabel = null;
        /**
         *Label for the off state.
         */
        this.offLabel = null;
        /**
         *Icon for the on state.
         */
        this.onIcon = 'pi pi-check';
        /**
         *Icon for the off state.
         */
        this.offIcon = 'pi pi-times';
        /**
         *Position of the icon, valid values are "left" and "right".
         */
        this.iconPos = 'left';
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Style class of the element.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetToggleButtonActionConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input ToggleButton configs and assign configs to element
     */
    set setToggleButtonActionConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetToggleButtonActionConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetToggleButtonActionConfigsDirective, deps: [{ token: i1$a.ToggleButton }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetToggleButtonActionConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetToggleButtonActionConfigsDirective, selector: "[setToggleButtonActionConfigs]", inputs: { setToggleButtonActionConfigs: "setToggleButtonActionConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetToggleButtonActionConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setToggleButtonActionConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$a.ToggleButton }]; }, propDecorators: { setToggleButtonActionConfigs: [{
                type: Input
            }] } });

/**
 * Toggle Button Action Component
 */
class PrgToggleButtonActionComponent {
    constructor() {
        /**
         * output
         */
        this.actionClick = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onButtonClicked(event) {
        this.actionClick.emit(new ActionOutput({ action: this.configs.key, value: event.checked }));
    }
}
PrgToggleButtonActionComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgToggleButtonActionComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgToggleButtonActionComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgToggleButtonActionComponent, selector: "prg-toggle-button-action", inputs: { configs: "configs", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<div class=\"field-checkbox\">\r\n    <p-toggleButton\r\n      (onChange)=\"onButtonClicked($event)\"\r\n      [setToggleButtonActionConfigs]=\"configs\"\r\n      [inputId]=\"configs.key\"\r\n      [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n      [onLabel]=\"configs.hasLabel?(configs.translationBasePath + '.' + configs.key + '.onLabel' | translate):''\"\r\n      [offLabel]=\"configs.hasLabel?(configs.translationBasePath + '.' + configs.key + '.offLabel' | translate):''\"\r\n      ></p-toggleButton>\r\n  <label for=\"{{configs.key}}\">{{configs.translationBasePath + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n\r\n\r\n", dependencies: [{ kind: "component", type: i1$a.ToggleButton, selector: "p-toggleButton", inputs: ["onLabel", "offLabel", "onIcon", "offIcon", "ariaLabelledBy", "disabled", "style", "styleClass", "inputId", "tabindex", "iconPos"], outputs: ["onChange"] }, { kind: "directive", type: PrgSetToggleButtonActionConfigsDirective, selector: "[setToggleButtonActionConfigs]", inputs: ["setToggleButtonActionConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgToggleButtonActionComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-toggle-button-action', template: "<div class=\"field-checkbox\">\r\n    <p-toggleButton\r\n      (onChange)=\"onButtonClicked($event)\"\r\n      [setToggleButtonActionConfigs]=\"configs\"\r\n      [inputId]=\"configs.key\"\r\n      [disabled]=\"!form.valid && configs.disableWhenFormInvalid!\"\r\n      [onLabel]=\"configs.hasLabel?(configs.translationBasePath + '.' + configs.key + '.onLabel' | translate):''\"\r\n      [offLabel]=\"configs.hasLabel?(configs.translationBasePath + '.' + configs.key + '.offLabel' | translate):''\"\r\n      ></p-toggleButton>\r\n  <label for=\"{{configs.key}}\">{{configs.translationBasePath + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });

/**
 * list of types of action
 */
const ActionTypes = {
    button: PrgButtonComponent,
    splitButton: PrgSplitButtonComponent,
    speedDial: PrgSpeedDialComponent,
    selectButton: PrgSelectButtonActionComponent,
    toggleButton: PrgToggleButtonActionComponent,
    inputSwitch: PrgInputSwitchActionComponent,
};

/**
 * Dynamic form action component
 */
class PrgDynamicFormActionComponent {
    constructor() {
        /**
         * actions types
         */
        this.actionTypes = ActionTypes;
        /**
         * action Click output
         */
        this.actionClick = new EventEmitter();
        /**
         * output to dynamic component
         */
        this.outputs = {
            actionClick: (action) => {
                this.actionClick.emit(action);
            },
        };
    }
}
PrgDynamicFormActionComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDynamicFormActionComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgDynamicFormActionComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDynamicFormActionComponent, selector: "prg-dynamic-form-action", inputs: { action: "action", form: "form" }, outputs: { actionClick: "actionClick" }, ngImport: i0, template: "<div class=\"button\">\r\n  <ndc-dynamic\r\n    [ndcDynamicComponent]=\"actionTypes[action.controlName]\"\r\n    [ndcDynamicInputs]=\"{ configs: action, form: form }\"\r\n    [ndcDynamicOutputs]=\"outputs\"\r\n  ></ndc-dynamic>\r\n</div>\r\n", styles: [".button{margin:0 5px}\n"], dependencies: [{ kind: "component", type: i1$b.DynamicComponent, selector: "ndc-dynamic", inputs: ["ndcDynamicComponent", "ndcDynamicInjector", "ndcDynamicProviders", "ndcDynamicContent"], outputs: ["ndcDynamicCreated"] }, { kind: "directive", type: i1$b.DynamicIoDirective, selector: "[ndcDynamicInputs],[ndcDynamicOutputs]", inputs: ["ndcDynamicInputs", "ndcDynamicOutputs"], exportAs: ["ndcDynamicIo"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDynamicFormActionComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-dynamic-form-action', template: "<div class=\"button\">\r\n  <ndc-dynamic\r\n    [ndcDynamicComponent]=\"actionTypes[action.controlName]\"\r\n    [ndcDynamicInputs]=\"{ configs: action, form: form }\"\r\n    [ndcDynamicOutputs]=\"outputs\"\r\n  ></ndc-dynamic>\r\n</div>\r\n", styles: [".button{margin:0 5px}\n"] }]
        }], propDecorators: { action: [{
                type: Input
            }], form: [{
                type: Input
            }], actionClick: [{
                type: Output
            }] } });

/**
 * Class Auto Complete
 */
class AutoCompleteConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.autoComplete;
        /**
         * An array of data to perform a search for autocomplete purpose
         */
        this.dataToSearch = null;
        /**
         *Field of a suggested object to resolve and display.
         */
        this.field = null;
        /**
         *Maximum height of the suggestions panel.
         */
        this.scrollHeight = '200px';
        /**
         *Displays a button next to the input field when enabled.
         */
        this.dropdown = false;
        /**
         *Specifies if multiple values can be selected.
         */
        this.multiple = false;
        /**
         *Icon class of the dropdown icon.
         */
        this.dropdownIcon = 'pi pi-chevron-down;';
        /**
         *Minimum number of characters to initiate a search.
         */
        this.minLength = 1;
        /**
         *Delay between keystrokes to wait before sending a query.
         */
        this.delay = 300;
        /**
         *Whether to run a query when input receives focus.
         */
        this.completeOnFocus = false;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Inline style of the input field.
         */
        this.inputStyle = null;
        /**
         *Inline style of the overlay panel element.
         */
        this.panelStyle = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Inline style of the input field.
         */
        this.inputStyleClass = null;
        /**
         *Style class of the overlay panel element.
         */
        this.panelStyleClass = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Name of the input element.
         */
        this.name = null;
        /**
         *Name of the label field of an option group.
         */
        this.optionGroupLabel = 'label';
        /**
         *Whether to display options as grouped when nested options are provided.
         */
        this.group = false;
        /**
         *Name of the options field of an option group.
         */
        this.optionGroupChildren = 'items';
        /**
         *Hint text for the input field.
         */
        this.placeholder = null;
        /**
         *Maximum number of character allows in the input field.
         */
        this.maxlength = null;
        /**
         *Size of the input field.
         */
        this.size = null;
        /**
         *Target element to attach the overlay, valid values are "body" or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]="mydiv" for a div element having #mydiv as variable name).
         */
        this.appendTo = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *A property to uniquely identify a value in options.
         */
        this.dataKey = null;
        /**
         *When enabled, highlights the first item in the list by default.
         */
        this.autoHighlight = false;
        /**
         *Type of the input, defaults to "text".
         */
        this.type = 'text';
        /**
         *Whether to show the empty message or not.
         */
        this.showEmptyMessage = false;
        /**
         *Text to display when there is no data. Defaults to global value in i18n translation configuration.
         */
        this.emptyMessage = 'No results found';
        /**
         *Defines how the suggestions should be manipulated. More information is available at "Change Detection" section above.
         */
        this.immutable = true;
        /**
         *When present, it specifies that an input field must be filled out before submitting the form.
         */
        this.required = false;
        /**
         *When present, it specifies that the component should automatically get focus on load.
         */
        this.autofocus = false;
        /**
         *When present, autocomplete clears the manual input if it does not match of the suggestions to force only accepting values from the suggestions.
         */
        this.forceSelection = false;
        /**
         *Specifies the behavior dropdown button. Default "blank" mode sends an empty string and "current" mode sends the input value.
         */
        this.dropdownMode = 'blank';
        /**
         *Base zIndex value to use in layering.
         */
        this.baseZIndex = 0;
        /**
         *Whether to automatically manage layering.
         */
        this.autoZIndex = true;
        /**
         *Transition options of the show animation.
         */
        this.showTransitionOptions = '.12s cubic-bezier(0, 0, 0.2, 1)';
        /**
         *Transition options of the hide animation.
         */
        this.hideTransitionOptions = '.1s linear';
        /**
         *Defines a string that labels the input for accessibility.
         */
        this.ariaLabel = null;
        /**
         *Specifies one or more IDs in the DOM that labels the input field.
         */
        this.ariaLabelledBy = null;
        /**
         *Defines a string that labels the dropdown button for accessibility.
         */
        this.dropdownAriaLabel = null;
        /**
         *Ensures uniqueness of selected items on multiple mode.
         */
        this.unique = true;
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.autocomplete = null;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        /**
         *Whether the data should be loaded on demand during scroll.
         */
        this.virtualScroll = false;
        /**
         *Height of an item in the list for VirtualScrolling.
         */
        this.virtualScrollItemSize = null;
        /**
         *Whether to use the scroller feature. The properties of scroller component can be used like an object in it.
         */
        this.virtualScrollOptions = null;
        /**
         *Defines if data is loaded and interacted with in lazy manner.
         */
        this.lazy = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetAutoCompleteConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Auto Complete configs and assign configs to element
     */
    set setAutoCompleteConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetAutoCompleteConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetAutoCompleteConfigsDirective, deps: [{ token: i1$c.AutoComplete }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetAutoCompleteConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetAutoCompleteConfigsDirective, selector: "[setAutoCompleteConfigs]", inputs: { setAutoCompleteConfigs: "setAutoCompleteConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetAutoCompleteConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setAutoCompleteConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$c.AutoComplete }]; }, propDecorators: { setAutoCompleteConfigs: [{
                type: Input
            }] } });

/**
 * Component Auto Complete
 */
class PrgAutoCompleteComponent {
    /**
     * Constructor
     * @param {ArrayUtilityService} arrayUtilityService
     */
    constructor(arrayUtilityService) {
        this.arrayUtilityService = arrayUtilityService;
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the search for auto complete purpose
     */
    search(event) {
        let suggestions = [];
        let query = event.query;
        this.configs.dataToSearch.map((data) => {
            if (this.configs.field) {
                if (data[this.configs.field].toLowerCase().includes(query)) {
                    suggestions.push(data);
                }
            }
            else {
                if (data.toLowerCase().includes(query)) {
                    suggestions.push(data);
                }
            }
        });
        this.configs.suggestions = this.arrayUtilityService.clone(suggestions);
    }
}
PrgAutoCompleteComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAutoCompleteComponent, deps: [{ token: ArrayUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgAutoCompleteComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgAutoCompleteComponent, selector: "prg-auto-complete-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate)}}</p>\r\n  <p-autoComplete\r\n    [setAutoCompleteConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [emptyMessage]=\"(configs.basePathTranslation + '.' + configs.key + '.emptyMessage' | translate)\"\r\n    [inputId]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.filterPlaceholder'\r\n          | translate\r\n      \"\r\n    (completeMethod)=\"search($event)\"\r\n    [suggestions]=\"configs.suggestions\"\r\n\r\n  ></p-autoComplete>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$c.AutoComplete, selector: "p-autoComplete", inputs: ["minLength", "delay", "style", "panelStyle", "styleClass", "panelStyleClass", "inputStyle", "inputId", "inputStyleClass", "placeholder", "readonly", "disabled", "scrollHeight", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "maxlength", "name", "required", "size", "appendTo", "autoHighlight", "forceSelection", "type", "autoZIndex", "baseZIndex", "ariaLabel", "dropdownAriaLabel", "ariaLabelledBy", "dropdownIcon", "unique", "group", "completeOnFocus", "showClear", "field", "dropdown", "showEmptyMessage", "dropdownMode", "multiple", "tabindex", "dataKey", "emptyMessage", "showTransitionOptions", "hideTransitionOptions", "autofocus", "autocomplete", "optionGroupChildren", "optionGroupLabel", "itemSize", "suggestions"], outputs: ["completeMethod", "onSelect", "onUnselect", "onFocus", "onBlur", "onDropdownClick", "onClear", "onKeyUp", "onShow", "onHide", "onLazyLoad"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetAutoCompleteConfigsDirective, selector: "[setAutoCompleteConfigs]", inputs: ["setAutoCompleteConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAutoCompleteComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-auto-complete-field', template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate)}}</p>\r\n  <p-autoComplete\r\n    [setAutoCompleteConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [emptyMessage]=\"(configs.basePathTranslation + '.' + configs.key + '.emptyMessage' | translate)\"\r\n    [inputId]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.filterPlaceholder'\r\n          | translate\r\n      \"\r\n    (completeMethod)=\"search($event)\"\r\n    [suggestions]=\"configs.suggestions\"\r\n\r\n  ></p-autoComplete>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: ArrayUtilityService }]; }, propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class Cascade Select
 */
class CascadeSelectConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.cascadeSelect;
        /**
         *An array of selectitems to display as the available options.
         */
        this.options = null;
        /**
         *Property name or getter function to use as the label of an option.
         */
        this.optionLabel = null;
        /**
         *Property name or getter function to use as the value of an option, defaults to the option itself when not defined.
         */
        this.optionValue = null;
        /**
         *Property name or getter function to use as the label of an option group.
         */
        this.optionGroupLabel = null;
        /**
         *Property name or getter function to retrieve the items of a group.
         */
        this.optionGroupChildren = null;
        /**
         *Default text to display when no option is selected.
         */
        this.placeholder = null;
        /**
         *When present, it specifies that the component should be disabled.
         */
        this.disabled = false;
        /**
         *A property to uniquely identify an option.
         */
        this.dataKey = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the underlying input element.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Id of the element or "body" for document where the overlay should be appended to.
         */
        this.appendTo = null;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Inline style of the overlay panel.
         */
        this.panelStyle = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Style class of the overlay panel.
         */
        this.panelStyleClass = null;
        /**
         *Label of the input for accessibility.
         */
        this.inputLabel = null;
        /**
         *Defines a string that labels the input for accessibility.
         */
        this.ariaLabel = null;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetCascadeSelectConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Cascade Selected configs and assign configs to element
     */
    set setCascadeSelectConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetCascadeSelectConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetCascadeSelectConfigsDirective, deps: [{ token: i1$d.CascadeSelect }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetCascadeSelectConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetCascadeSelectConfigsDirective, selector: "[setCascadeSelectConfigs]", inputs: { setCascadeSelectConfigs: "setCascadeSelectConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetCascadeSelectConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setCascadeSelectConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$d.CascadeSelect }]; }, propDecorators: { setCascadeSelectConfigs: [{
                type: Input
            }] } });

/**
 * component Cascade Select
 */
class PrgCascadeSelectComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgCascadeSelectComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCascadeSelectComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgCascadeSelectComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgCascadeSelectComponent, selector: "prg-cascade-select-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "\r\n<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n  <p-cascadeSelect\r\n    [setCascadeSelectConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n    [inputId]=\"configs.key\"\r\n    (onChange)=\"onChanged($event)\"\r\n  ></p-cascadeSelect>\r\n\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$d.CascadeSelect, selector: "p-cascadeSelect", inputs: ["styleClass", "style", "options", "optionLabel", "optionValue", "optionGroupLabel", "optionGroupChildren", "placeholder", "value", "dataKey", "inputId", "tabindex", "ariaLabelledBy", "inputLabel", "ariaLabel", "appendTo", "disabled", "rounded", "showTransitionOptions", "hideTransitionOptions", "showClear", "panelStyleClass", "panelStyle"], outputs: ["onChange", "onGroupChange", "onShow", "onHide", "onClear", "onBeforeShow", "onBeforeHide"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetCascadeSelectConfigsDirective, selector: "[setCascadeSelectConfigs]", inputs: ["setCascadeSelectConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCascadeSelectComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-cascade-select-field', template: "\r\n<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n  <p-cascadeSelect\r\n    [setCascadeSelectConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n    [inputId]=\"configs.key\"\r\n    (onChange)=\"onChanged($event)\"\r\n  ></p-cascadeSelect>\r\n\r\n</div>\r\n" }]
        }], propDecorators: { onValueChange: [{
                type: Output
            }], configs: [{
                type: Input
            }], form: [{
                type: Input
            }] } });

/**
 * Checkbox Component
 */
class PrgCheckboxComponent {
    constructor() {
        /**
         * Property binding of checkbox values (multiple checkboxes)
         * @type {any}
         */
        this.valueChecked = [];
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.checked,
                event: event,
            }));
        }
    }
}
PrgCheckboxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCheckboxComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgCheckboxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgCheckboxComponent, selector: "prg-checkbox-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<ng-container *ngIf=\"configs.options;else singleCheckbox\">\r\n  <div *ngIf=\"form\" [formGroup]=\"form\">\r\n    <div *ngFor=\"let option of configs.options; let i=index\" class=\"field-checkbox\">\r\n      <p-checkbox\r\n                  [formControlName]=\"configs.key\"\r\n                  (onChange)=\"onChanged($event)\"\r\n                  [setCheckboxConfigs]=\"configs\"\r\n                  [inputId]=\"option[configs.optionKey]\"\r\n                  [value]=\"option[configs.optionValue]\"\r\n                  [binary]=\"false\"\r\n                  [name]=\"option[configs.optionKey]\"\r\n                  [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n                  [(ngModel)]=\"valueChecked\"\r\n                  [disabled]=\"configs.disabled||(!configs.allowMultipleCheckBoxSelection&&valueChecked?.length>0&&valueChecked!=option[configs.optionValue])\"\r\n      >\r\n      </p-checkbox>\r\n      <label\r\n        for=\"{{option[configs.optionKey]}}\">{{configs.basePathTranslation + '.' + configs.key + '.' + option[configs.optionKey] + '.label' | translate}}</label>\r\n    </div>\r\n  </div>\r\n</ng-container>\r\n<ng-template #singleCheckbox>\r\n  <div class=\"field-checkbox\" *ngIf=\"form\" [formGroup]=\"form\">\r\n    <p-checkbox\r\n      (onChange)=\"onChanged($event)\"\r\n      [setCheckboxConfigs]=\"configs\"\r\n      [formControlName]=\"configs.key\"\r\n      [inputId]=\"configs.key\"\r\n      [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n      [name]=\"configs.key + '.name' | translate\"></p-checkbox>\r\n    <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n  </div>\r\n</ng-template>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i9.Checkbox, selector: "p-checkbox", inputs: ["value", "name", "disabled", "binary", "label", "ariaLabelledBy", "ariaLabel", "tabindex", "inputId", "style", "styleClass", "labelStyleClass", "formControl", "checkboxIcon", "readonly", "required", "trueValue", "falseValue"], outputs: ["onChange"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetCheckboxConfigsDirective, selector: "[setCheckboxConfigs]", inputs: ["setCheckboxConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCheckboxComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-checkbox-field', template: "<ng-container *ngIf=\"configs.options;else singleCheckbox\">\r\n  <div *ngIf=\"form\" [formGroup]=\"form\">\r\n    <div *ngFor=\"let option of configs.options; let i=index\" class=\"field-checkbox\">\r\n      <p-checkbox\r\n                  [formControlName]=\"configs.key\"\r\n                  (onChange)=\"onChanged($event)\"\r\n                  [setCheckboxConfigs]=\"configs\"\r\n                  [inputId]=\"option[configs.optionKey]\"\r\n                  [value]=\"option[configs.optionValue]\"\r\n                  [binary]=\"false\"\r\n                  [name]=\"option[configs.optionKey]\"\r\n                  [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n                  [(ngModel)]=\"valueChecked\"\r\n                  [disabled]=\"configs.disabled||(!configs.allowMultipleCheckBoxSelection&&valueChecked?.length>0&&valueChecked!=option[configs.optionValue])\"\r\n      >\r\n      </p-checkbox>\r\n      <label\r\n        for=\"{{option[configs.optionKey]}}\">{{configs.basePathTranslation + '.' + configs.key + '.' + option[configs.optionKey] + '.label' | translate}}</label>\r\n    </div>\r\n  </div>\r\n</ng-container>\r\n<ng-template #singleCheckbox>\r\n  <div class=\"field-checkbox\" *ngIf=\"form\" [formGroup]=\"form\">\r\n    <p-checkbox\r\n      (onChange)=\"onChanged($event)\"\r\n      [setCheckboxConfigs]=\"configs\"\r\n      [formControlName]=\"configs.key\"\r\n      [inputId]=\"configs.key\"\r\n      [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n      [name]=\"configs.key + '.name' | translate\"></p-checkbox>\r\n    <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n  </div>\r\n</ng-template>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class Chips
 */
class ChipsConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.chips;
        /**
         *Name of the property to display on a chip.
         */
        this.field = null;
        /**
         *Maximum number of entries allowed.
         */
        this.max = null;
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Style class of the element.
         */
        this.styleClass = null;
        /**
         *Advisory information to display on input.
         */
        this.placeholder = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Whether to allow duplicate values or not.
         */
        this.allowDuplicate = true;
        /**
         *Inline style of the input field.
         */
        this.inputStyle = null;
        /**
         *Style class of the input field.
         */
        this.inputStyleClass = null;
        /**
         *Whether to add an item on tab key press.
         */
        this.addOnTab = false;
        /**
         *Whether to add an item when the input loses focus.
         */
        this.addOnBlur = false;
        /**
         *Separator char to add an item when pressed in addition to the enter key. Currently only possible value is ","
         */
        this.separator = ',';
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetChipsConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Chips configs and assign configs to element
     */
    set setChipsConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetChipsConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetChipsConfigsDirective, deps: [{ token: i1$e.Chips }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetChipsConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetChipsConfigsDirective, selector: "[setChipsConfigs]", inputs: { setChipsConfigs: "setChipsConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetChipsConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setChipsConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$e.Chips }]; }, propDecorators: { setChipsConfigs: [{
                type: Input
            }] } });

/**
 * Component Rating
 */
class PrgChipsComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgChipsComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgChipsComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgChipsComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgChipsComponent, selector: "prg-chips-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<span *ngIf=\"form\" [formGroup]=\"form\">\r\n  <span class=\"p-float-label\">\r\n  <p-chips\r\n    [setChipsConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [inputId]=\"configs?.key\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    (onAdd)=\"onChanged($event)\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n  ></p-chips>\r\n      <label for=\"{{configs.key}}\">{{\r\n        configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n        }}</label>\r\n\r\n  </span>\r\n</span>\r\n", dependencies: [{ kind: "component", type: i1$e.Chips, selector: "p-chips", inputs: ["style", "styleClass", "disabled", "field", "placeholder", "max", "ariaLabelledBy", "tabindex", "inputId", "allowDuplicate", "inputStyle", "inputStyleClass", "addOnTab", "addOnBlur", "separator", "showClear"], outputs: ["onAdd", "onRemove", "onFocus", "onBlur", "onChipClick", "onClear"] }, { kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetChipsConfigsDirective, selector: "[setChipsConfigs]", inputs: ["setChipsConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgChipsComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-chips-field', template: "<span *ngIf=\"form\" [formGroup]=\"form\">\r\n  <span class=\"p-float-label\">\r\n  <p-chips\r\n    [setChipsConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [inputId]=\"configs?.key\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    (onAdd)=\"onChanged($event)\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n  ></p-chips>\r\n      <label for=\"{{configs.key}}\">{{\r\n        configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n        }}</label>\r\n\r\n  </span>\r\n</span>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class Color Picker
 */
class ColorPickerConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.colorPicker;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Whether to display as an overlay or not.
         */
        this.inline = false;
        /**
         *Format to use in value binding, supported formats are "hex", "rgb" and "hsb".
         */
        this.format = 'hex';
        /**
         *Target element to attach the overlay, valid values are "body" or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]="mydiv" for a div element having #mydiv as variable name).
         */
        this.appendTo = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the dropdown.
         */
        this.inputId = null;
        /**
         *Base zIndex value to use in layering.
         */
        this.baseZIndex = 0;
        /**
         *Whether to automatically manage layering.
         */
        this.autoZIndex = true;
        /**
         *Transition options of the show animation.
         */
        this.showTransitionOptions = '.12s cubic-bezier(0, 0, 0.2, 1)';
        /**
         *Transition options of the hide animation.
         */
        this.hideTransitionOptions = '.1s linear';
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetColorPickerConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Color Picker configs and assign configs to element
     */
    set setColorPickerConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetColorPickerConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetColorPickerConfigsDirective, deps: [{ token: i1$f.ColorPicker }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetColorPickerConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetColorPickerConfigsDirective, selector: "[setColorPickerConfigs]", inputs: { setColorPickerConfigs: "setColorPickerConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetColorPickerConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setColorPickerConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$f.ColorPicker }]; }, propDecorators: { setColorPickerConfigs: [{
                type: Input
            }] } });

/**
 * Component Color Picker
 */
class PrgColorPickerComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                event: event,
                value: event.value,
            }));
        }
    }
}
PrgColorPickerComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgColorPickerComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgColorPickerComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgColorPickerComponent, selector: "prg-color-picker-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div class=\"field-color-picker\" *ngIf=\"form\" [formGroup]=\"form\">\r\n\r\n  <p-colorPicker\r\n    (onChange)=\"onChanged($event)\"\r\n    [setColorPickerConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [inputId]=\"configs.key\">\r\n  </p-colorPicker>\r\n  <label [ngClass]=\"['pl-1']\" for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$f.ColorPicker, selector: "p-colorPicker", inputs: ["style", "styleClass", "inline", "format", "appendTo", "disabled", "tabindex", "inputId", "autoZIndex", "baseZIndex", "showTransitionOptions", "hideTransitionOptions"], outputs: ["onChange", "onShow", "onHide"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetColorPickerConfigsDirective, selector: "[setColorPickerConfigs]", inputs: ["setColorPickerConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgColorPickerComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-color-picker-field', template: "<div class=\"field-color-picker\" *ngIf=\"form\" [formGroup]=\"form\">\r\n\r\n  <p-colorPicker\r\n    (onChange)=\"onChanged($event)\"\r\n    [setColorPickerConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [inputId]=\"configs.key\">\r\n  </p-colorPicker>\r\n  <label [ngClass]=\"['pl-1']\" for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class Input Text
 */
class DateTimeConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputDateTime;
        /**
         *Set the date to highlight on first opening if the field is blank.
         */
        this.defaultDate = null;
        /**
         *Defines the quantity of the selection, valid values are single, multiple and range.
         */
        this.selectionMode = 'single';
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Inline style of the input field.
         */
        this.inputStyle = null;
        /**
         *Style class of the input field.
         */
        this.inputStyleClass = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Name of the input element.
         */
        // public name: string = null;
        /*
        /!**
         *When specified, disables the component.
         *!/
        public disabled: boolean = false;*/ //Property already on Base Field
        /**
         *Format of the date which can also be defined at locale settings.
         */
        this.dateFormat = 'mm/dd/yy';
        /**
         *When enabled, displays the calendar as inline. Default is false for popup mode.
         */
        this.inline = false;
        /**
         *Whether to display dates in other months (non-selectable) at the start or end of the current month. To make these days selectable use the selectOtherMonths option.
         */
        this.showOtherMonths = true;
        /**
         *Whether days in other months shown before or after the current month are selectable. This only applies if the showOtherMonths option is set to true.
         */
        this.selectOtherMonths = false;
        /**
         *When enabled, displays a button with icon next to input.
         */
        this.showIcon = false;
        /**
         *When disabled, datepicker will not be visible with input focus.
         */
        this.showOnFocus = true;
        /**
         *When enabled, calendar will show week numbers.
         */
        this.showWeek = false;
        /**
         *Icon of the calendar button.
         */
        this.icon = 'pi pi-calendar';
        /**
         *Target element to attach the overlay, valid values are body or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]=mydiv for a div element having #mydiv as variable name).
         */
        this.appendTo = null;
        /**
         *When specified, prevents entering the date manually with keyboard.
         */
        this.readonlyInput = null;
        /**
         *The cutoff year for determining the century for a date.
         */
        this.shortYearCutoff = '10';
        /**
         *The minimum selectable date.
         */
        this.minDate = null;
        /**
         *The maximum selectable date.
         */
        this.maxDate = null;
        /**
         *Array with dates that should be disabled (not selectable).
         */
        this.disabledDates = null;
        /**
         *Array with weekday numbers that should be disabled (not selectable).
         */
        this.disabledDays = null;
        /**
         *Whether the month should be rendered as a dropdown instead of text.
         */
        this.monthNavigator = false;
        /**
         *Whether the year should be rendered as a dropdown instead of text.
         */
        this.yearNavigator = false;
        /**
         *The range of years displayed in the year drop-down in (nnnn:nnnn) format such as (2000:2020).
         */
        this.yearRange = null;
        /**
         *Whether to display timepicker.
         */
        this.showTime = false;
        /**
         *Specifies 12 or 24 hour format.
         */
        this.hourFormat = '24';
        /**
         *Whether to display timepicker only.
         */
        this.timeOnly = false;
        /**
         *Separator of time selector.
         */
        this.timeSeparator = ':';
        /**
         *Type of the value to write back to ngModel, default is date and alternative is string.
         */
        this.dataType = 'date';
        /**
         *When present, it specifies that an input field must be filled out before submitting the form.
         */
        this.required = false;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Defines a string that labels the icon button for accessibility.
         */
        this.iconAriaLabel = null;
        /**
         *Whether to show the seconds in time picker.
         */
        this.showSeconds = false;
        /**
         *Hours to change per step.
         */
        this.stepHour = 1;
        /**
         *Minutes to change per step.
         */
        this.stepMinute = 1;
        /**
         *Seconds to change per step.
         */
        this.stepSecond = 1;
        /**
         *Maximum number of selectable dates in multiple mode.
         */
        this.maxDateCount = null;
        /**
         *Whether to display today and clear buttons at the footer
         */
        this.showButtonBar = false;
        /**
         *Style class of the today button.
         */
        this.todayButtonStyleClass = 'p-secondary-button';
        /**
         *Style class of the clear button.
         */
        this.clearButtonStyleClass = 'p-secondary-button';
        /**
         *Base zIndex value to use in layering.
         */
        this.baseZIndex = 0;
        /**
         *Whether to automatically manage layering.
         */
        this.autoZIndex = true;
        /**
         *Style class of the datetimepicker container element.
         */
        this.panelStyleClass = null;
        /**
         *Inline style of the datetimepicker container element.
         */
        this.panelStyle = null;
        /**
         *Keep invalid value when input blur.
         */
        this.keepInvalid = false;
        /**
         *Whether to hide the overlay on date selection.
         */
        this.hideOnDateTimeSelect = true;
        /**
         *Number of months to display.
         */
        this.numberOfMonths = 1;
        //TODO: see this
        /**
         *Type of view to display, valid values are date for datepicker and month for month picker.
         */
        this.view = 'date';
        /**
         *Separator for multiple selection mode.
         */
        this.multipleSeparator = ',';
        /**
         *Separator for joining start and end dates on range selection mode.
         */
        this.rangeSeparator = '-';
        /**
         *When enabled, calendar overlay is displayed as optimized for touch devices.
         */
        this.touchUI = false;
        /**
         *When enabled, can only focus on elements inside the calendar.
         */
        this.focusTrap = true;
        /**
         *Transition options of the show animation.
         */
        this.showTransitionOptions = '.12s cubic-bezier(0, 0, 0.2, 1)';
        /**
         *Transition options of the hide animation.
         */
        this.hideTransitionOptions = '.1s linear';
        /**
         *Defines the first of the week for various date calculations.
         */
        this.firstDayOfWeek = 0;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetDateTimeConfigsDirective {
    /**
     * constructor
     * @param cal
     */
    constructor(cal) {
        this.cal = cal;
    }
    /**
     * input data time configs and assign configs to element
     */
    set setDateTimeConfigs(configs) {
        Object.assign(this.cal, configs);
    }
}
PrgSetDateTimeConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetDateTimeConfigsDirective, deps: [{ token: i1$g.Calendar }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetDateTimeConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetDateTimeConfigsDirective, selector: "[setDateTimeConfigs]", inputs: { setDateTimeConfigs: "setDateTimeConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetDateTimeConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setDateTimeConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$g.Calendar }]; }, propDecorators: { setDateTimeConfigs: [{
                type: Input
            }] } });

/**
 * component date time
 */
class PrgDateTimeComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event,
            }));
        }
    }
}
PrgDateTimeComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDateTimeComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgDateTimeComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDateTimeComponent, selector: "prg-date-time-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <p-calendar\r\n    [inputId]=\"configs.key\"\r\n    [setDateTimeConfigs]=\"configs\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [name]=\"configs.key + '.name' | translate\"\r\n    [placeholder]=\"\r\n      configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n        | translate\r\n    \"\r\n    (ngModelChange)=\"onChanged($event)\"\r\n  >\r\n  </p-calendar>\r\n\r\n  <label for=\"{{ configs.key }}\"\r\n    >{{\r\n      configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n    }}\r\n  </label>\r\n</span>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$g.Calendar, selector: "p-calendar", inputs: ["style", "styleClass", "inputStyle", "inputId", "name", "inputStyleClass", "placeholder", "ariaLabelledBy", "iconAriaLabel", "disabled", "dateFormat", "multipleSeparator", "rangeSeparator", "inline", "showOtherMonths", "selectOtherMonths", "showIcon", "icon", "appendTo", "readonlyInput", "shortYearCutoff", "monthNavigator", "yearNavigator", "hourFormat", "timeOnly", "stepHour", "stepMinute", "stepSecond", "showSeconds", "required", "showOnFocus", "showWeek", "showClear", "dataType", "selectionMode", "maxDateCount", "showButtonBar", "todayButtonStyleClass", "clearButtonStyleClass", "autoZIndex", "baseZIndex", "panelStyleClass", "panelStyle", "keepInvalid", "hideOnDateTimeSelect", "touchUI", "timeSeparator", "focusTrap", "showTransitionOptions", "hideTransitionOptions", "tabindex", "view", "defaultDate", "minDate", "maxDate", "disabledDates", "disabledDays", "yearRange", "showTime", "responsiveOptions", "numberOfMonths", "firstDayOfWeek", "locale"], outputs: ["onFocus", "onBlur", "onClose", "onSelect", "onClear", "onInput", "onTodayClick", "onClearClick", "onMonthChange", "onYearChange", "onClickOutside", "onShow"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetDateTimeConfigsDirective, selector: "[setDateTimeConfigs]", inputs: ["setDateTimeConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDateTimeComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-date-time-field', template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <p-calendar\r\n    [inputId]=\"configs.key\"\r\n    [setDateTimeConfigs]=\"configs\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [name]=\"configs.key + '.name' | translate\"\r\n    [placeholder]=\"\r\n      configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n        | translate\r\n    \"\r\n    (ngModelChange)=\"onChanged($event)\"\r\n  >\r\n  </p-calendar>\r\n\r\n  <label for=\"{{ configs.key }}\"\r\n    >{{\r\n      configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n    }}\r\n  </label>\r\n</span>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class Input Mask
 */
class InputMaskConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputMask;
        /**
         *HTML5 input type
         */
        this.type = 'text';
        /**
         *Mask pattern.
         */
        this.mask = null;
        /**
         *Placeholder character in mask, default is underscore.
         */
        this.slotChar = '_';
        /**
         *Clears the incomplete value on blur.
         */
        this.autoClear = true;
        /**
         *Defines if ngModel sets the raw unmasked value to bound value or the formatted mask value.
         */
        this.unmask = false;
        /**
         *Inline style of the input field.
         */
        this.style = null;
        /**
         *Style class of the input field.
         */
        this.styleClass = null;
        /**
         *Advisory information to display on input.
         */
        this.placeholder = null;
        /**
         *Size of the input field.
         */
        this.size = null;
        /**
         *Maximum number of character allows in the input field.
         */
        this.maxlength = null;
        /**
         *Specifies tab order of the element.
         */
        this.tabindex = null;
        /**
         *Name of the input field.
         */
        this.name = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *When present, it specifies that an input field must be filled out before submitting the form.
         */
        this.required = false;
        /**
         *Regex pattern for alpha characters
         */
        this.characterPattern = '[a-Za-z]';
        /**
         *When present, the input gets a focus automatically on load.
         */
        this.autoFocus = false;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.autocomplete = null;
        /**
         *Used to define a string that labels the input element.
         */
        this.ariaLabel = null;
        /**
         *Used to indicate that user input is required on an element before a form can be submitted.
         */
        this.ariaRequired = false;
        /**
         *Title text of the input text.
         */
        this.title = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetInputMaskConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Input Mask configs and assign configs to element
     */
    set setInputMaskConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetInputMaskConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputMaskConfigsDirective, deps: [{ token: i1$h.InputMask }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetInputMaskConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetInputMaskConfigsDirective, selector: "[setInputMaskConfigs]", inputs: { setInputMaskConfigs: "setInputMaskConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputMaskConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setInputMaskConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$h.InputMask }]; }, propDecorators: { setInputMaskConfigs: [{
                type: Input
            }] } });

/**
 * component Input Mask
 */
class PrgInputMaskComponent {
}
PrgInputMaskComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputMaskComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgInputMaskComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgInputMaskComponent, selector: "prg-input-mask-field", inputs: { configs: "configs", form: "form" }, ngImport: i0, template: "<span  class=\"p-float-label\"  *ngIf=\"form\" [formGroup]=\"form\">\r\n<span class=\"p-float-label\">\r\n  <p-inputMask\r\n    [setInputMaskConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [inputId]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n\r\n  >\r\n  </p-inputMask>\r\n    <label for=\"{{configs.key}}\">{{  configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n      }}</label>\r\n  </span>\r\n\r\n</span>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$h.InputMask, selector: "p-inputMask", inputs: ["type", "slotChar", "autoClear", "showClear", "style", "inputId", "styleClass", "placeholder", "size", "maxlength", "tabindex", "title", "ariaLabel", "ariaRequired", "disabled", "readonly", "unmask", "name", "required", "characterPattern", "autoFocus", "autocomplete", "mask"], outputs: ["onComplete", "onFocus", "onBlur", "onInput", "onKeydown", "onClear"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetInputMaskConfigsDirective, selector: "[setInputMaskConfigs]", inputs: ["setInputMaskConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputMaskComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-input-mask-field', template: "<span  class=\"p-float-label\"  *ngIf=\"form\" [formGroup]=\"form\">\r\n<span class=\"p-float-label\">\r\n  <p-inputMask\r\n    [setInputMaskConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [inputId]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n\r\n  >\r\n  </p-inputMask>\r\n    <label for=\"{{configs.key}}\">{{  configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n      }}</label>\r\n  </span>\r\n\r\n</span>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }] } });

/**
 * component input number
 */
class PrgInputNumberComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event,
            }));
        }
    }
}
PrgInputNumberComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputNumberComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgInputNumberComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgInputNumberComponent, selector: "prg-input-number-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form\"  [formGroup]=\"form\">\r\n\r\n <p>{{\r\n   configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n   }}</p>\r\n\r\n  <p-inputNumber\r\n\r\n    [placeholder]=\"\r\nconfigs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n| translate\r\n\"\r\n    [setInputNumberConfigs]=\"configs\"\r\n    [inputId]=\"configs?.key\"\r\n    [formControlName]=\"configs?.key\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n\r\n    [name]=\"configs?.key + '.name' | translate\"\r\n(ngModelChange)=\"onChanged($event)\"\r\n\r\n  >\r\n  </p-inputNumber>\r\n</div\r\n>\r\n\r\n", dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$4.InputNumber, selector: "p-inputNumber", inputs: ["showButtons", "format", "buttonLayout", "inputId", "styleClass", "style", "placeholder", "size", "maxlength", "tabindex", "title", "ariaLabel", "ariaRequired", "name", "required", "autocomplete", "min", "max", "incrementButtonClass", "decrementButtonClass", "incrementButtonIcon", "decrementButtonIcon", "readonly", "step", "allowEmpty", "locale", "localeMatcher", "mode", "currency", "currencyDisplay", "useGrouping", "minFractionDigits", "maxFractionDigits", "prefix", "suffix", "inputStyle", "inputStyleClass", "showClear", "disabled"], outputs: ["onInput", "onFocus", "onBlur", "onKeyDown", "onClear"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetInputNumberConfigsDirective, selector: "[setInputNumberConfigs]", inputs: ["setInputNumberConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputNumberComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-input-number-field', template: "<div *ngIf=\"form\"  [formGroup]=\"form\">\r\n\r\n <p>{{\r\n   configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n   }}</p>\r\n\r\n  <p-inputNumber\r\n\r\n    [placeholder]=\"\r\nconfigs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n| translate\r\n\"\r\n    [setInputNumberConfigs]=\"configs\"\r\n    [inputId]=\"configs?.key\"\r\n    [formControlName]=\"configs?.key\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n\r\n    [name]=\"configs?.key + '.name' | translate\"\r\n(ngModelChange)=\"onChanged($event)\"\r\n\r\n  >\r\n  </p-inputNumber>\r\n</div\r\n>\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class Input Switch
 */
class InputSwitchConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputSwitch;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the input element.
         */
        this.inputId = null;
        /**
         *Name of the input element.
         */
        this.name = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Used to define a string that autocomplete attribute the current element.
         */
        this.ariaLabel = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetInputSwitchConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * Input Switch configs and assign configs to element
     */
    set setInputSwitchConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetInputSwitchConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputSwitchConfigsDirective, deps: [{ token: i1$6.InputSwitch }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetInputSwitchConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetInputSwitchConfigsDirective, selector: "[setInputSwitchConfigs]", inputs: { setInputSwitchConfigs: "setInputSwitchConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputSwitchConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setInputSwitchConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$6.InputSwitch }]; }, propDecorators: { setInputSwitchConfigs: [{
                type: Input
            }] } });

/**
 * component Input Switch
 */
class PrgInputSwitchComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                event: event,
                value: event.checked,
            }));
        }
    }
}
PrgInputSwitchComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputSwitchComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgInputSwitchComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgInputSwitchComponent, selector: "prg-input-switch-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div class=\"field-checkbox\" *ngIf=\"form\" [formGroup]=\"form\">\r\n\r\n  <p-inputSwitch\r\n    (onChange)=\"onChanged($event)\"\r\n    [setInputSwitchConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [inputId]=\"configs.key\"\r\n    [name]=\"configs.key + '.name' | translate\"></p-inputSwitch>\r\n  <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n\r\n", dependencies: [{ kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$6.InputSwitch, selector: "p-inputSwitch", inputs: ["style", "styleClass", "tabindex", "inputId", "name", "disabled", "readonly", "trueValue", "falseValue", "ariaLabel", "ariaLabelledBy"], outputs: ["onChange"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetInputSwitchConfigsDirective, selector: "[setInputSwitchConfigs]", inputs: ["setInputSwitchConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputSwitchComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-input-switch-field', template: "<div class=\"field-checkbox\" *ngIf=\"form\" [formGroup]=\"form\">\r\n\r\n  <p-inputSwitch\r\n    (onChange)=\"onChanged($event)\"\r\n    [setInputSwitchConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    [inputId]=\"configs.key\"\r\n    [name]=\"configs.key + '.name' | translate\"></p-inputSwitch>\r\n  <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * component input text area
 */
class PrgInputTextAreaComponent {
    /**
     * Constructor
     * @param {UtilityService} utilityService
     */
    constructor(utilityService) {
        this.utilityService = utilityService;
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
        /**
         * Debounced method onChanged
         * @type {(args?: any) => void}
         */
        this.debounceOnChanged = this.utilityService.debounce((event) => {
            this.onChanged(event);
        }, 500);
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event,
            }));
        }
    }
}
PrgInputTextAreaComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputTextAreaComponent, deps: [{ token: UtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgInputTextAreaComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgInputTextAreaComponent, selector: "prg-input-text-area-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <span class=\"p-float-label\">\r\n    <textarea\r\n      type=\"text\"\r\n      [id]=\"configs.key\"\r\n      [formControlName]=\"configs.key\"\r\n      [cols]=\"configs.cols\"\r\n      [rows]=\"configs.rows\"\r\n      [attr.disabled]=\"configs.disabled?configs.disabled:null\"\r\n      [readonly]=\"configs.readonly\"\r\n      [autoResize]=\"configs.autoResize\"\r\n      pInputTextarea\r\n      [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n      [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n      (ngModelChange)=\"debounceOnChanged($event)\"\r\n      [name]=\"configs.key + '.name' | translate\">\r\n    </textarea>\r\n    <label for=\"{{configs.key}}\">{{  configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n      }}</label>\r\n  </span>\r\n</span>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i4.InputTextarea, selector: "[pInputTextarea]", inputs: ["autoResize"], outputs: ["onResize"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputTextAreaComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-input-text-area-field', template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <span class=\"p-float-label\">\r\n    <textarea\r\n      type=\"text\"\r\n      [id]=\"configs.key\"\r\n      [formControlName]=\"configs.key\"\r\n      [cols]=\"configs.cols\"\r\n      [rows]=\"configs.rows\"\r\n      [attr.disabled]=\"configs.disabled?configs.disabled:null\"\r\n      [readonly]=\"configs.readonly\"\r\n      [autoResize]=\"configs.autoResize\"\r\n      pInputTextarea\r\n      [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n      [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n      (ngModelChange)=\"debounceOnChanged($event)\"\r\n      [name]=\"configs.key + '.name' | translate\">\r\n    </textarea>\r\n    <label for=\"{{configs.key}}\">{{  configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n      }}</label>\r\n  </span>\r\n</span>\r\n" }]
        }], ctorParameters: function () { return [{ type: UtilityService }]; }, propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * component input text
 */
class PrgInputTextComponent {
    /**
     * Constructor
     * @param {UtilityService} utilityService
     */
    constructor(utilityService) {
        this.utilityService = utilityService;
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
        /**
         * Debounced method onChanged
         * @type {(args?: any) => void}
         */
        this.debounceOnChanged = this.utilityService.debounce((event) => {
            this.onChanged(event);
        }, 500);
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event,
            }));
        }
    }
}
PrgInputTextComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputTextComponent, deps: [{ token: UtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgInputTextComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgInputTextComponent, selector: "prg-input-text-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <span class=\"p-float-label\">\r\n    <input\r\n      pInputText\r\n      type=\"text\"\r\n      [formControlName]=\"configs?.key\"\r\n      [id]=\"configs?.key\"\r\n      [attr.disabled]=\"configs.disabled?configs.disabled:null\"\r\n      [readonly]=\"configs.readonly\"\r\n      [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n      [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n      [name]=\"configs.key + '.name' | translate\"\r\n      (ngModelChange)=\"debounceOnChanged($event)\"\r\n\r\n\r\n    />\r\n    <label for=\"{{configs.key}}\">{{\r\n      configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n    }}</label>\r\n  </span>\r\n</span>\r\n", dependencies: [{ kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgInputTextComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-input-text-field', template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <span class=\"p-float-label\">\r\n    <input\r\n      pInputText\r\n      type=\"text\"\r\n      [formControlName]=\"configs?.key\"\r\n      [id]=\"configs?.key\"\r\n      [attr.disabled]=\"configs.disabled?configs.disabled:null\"\r\n      [readonly]=\"configs.readonly\"\r\n      [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n      [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n      [name]=\"configs.key + '.name' | translate\"\r\n      (ngModelChange)=\"debounceOnChanged($event)\"\r\n\r\n\r\n    />\r\n    <label for=\"{{configs.key}}\">{{\r\n      configs.basePathTranslation + '.' + configs.key + '.label' | translate\r\n    }}</label>\r\n  </span>\r\n</span>\r\n" }]
        }], ctorParameters: function () { return [{ type: UtilityService }]; }, propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class Knob
 */
class KnobConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.knob;
        /**
         *Size of the component in pixels.
         */
        this.size = 100;
        /**
         *Step factor to increment/decrement the value.
         */
        this.step = 1;
        /**
         *Mininum boundary value.
         */
        this.min = 0;
        /**
         *Maximum boundary value.
         */
        this.max = 100;
        /**
         *Width of the knob stroke.
         */
        this.strokeWidth = 14;
        /**
         *Whether the show the value inside the knob.
         */
        this.showValue = true;
        /**
         *Template string of the value.
         */
        this.valueTemplate = '{value}';
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetKnobConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Knob configs and assign configs to element
     */
    set setKnobConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetKnobConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetKnobConfigsDirective, deps: [{ token: i1$i.Knob }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetKnobConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetKnobConfigsDirective, selector: "[setKnobConfigs]", inputs: { setKnobConfigs: "setKnobConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetKnobConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setKnobConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$i.Knob }]; }, propDecorators: { setKnobConfigs: [{
                type: Input
            }] } });

/**
 * Component Knob
 */
class PrgKnobComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event,
            }));
        }
    }
}
PrgKnobComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgKnobComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgKnobComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgKnobComponent, selector: "prg-knob-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate)}}</p>\r\n  <p-knob\r\n    [setKnobConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    (onChange)=\"onChanged($event)\"\r\n    [(ngModel)]=\"value\"\r\n  ></p-knob>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$i.Knob, selector: "p-knob", inputs: ["styleClass", "style", "severity", "valueColor", "rangeColor", "textColor", "valueTemplate", "name", "size", "step", "min", "max", "strokeWidth", "disabled", "showValue", "readonly"], outputs: ["onChange"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetKnobConfigsDirective, selector: "[setKnobConfigs]", inputs: ["setKnobConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgKnobComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-knob-field', template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate)}}</p>\r\n  <p-knob\r\n    [setKnobConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    (onChange)=\"onChanged($event)\"\r\n    [(ngModel)]=\"value\"\r\n  ></p-knob>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class List box
 */
class ListBoxConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.listBox;
        /**
         * Reference type
         */
        this.referenceType = null;
        /**
         * Reference name -> shoud be a lookup table name
         */
        this.referenceName = null;
        /**
         *Defines a string that labels the filter input.
         */
        this.ariaFilterLabel = null;
        /**
         *When specified, allows selecting items with checkboxes.
         */
        this.checkbox = false;
        /**
         *A property to uniquely identify a value in options.
         */
        this.dataKey = null;
        /**
         *When specified, displays a filter input at header.
         */
        this.filter = false;
        /**
         *Defines how the items are filtered, valid values are "contains" (default) "startsWith", "endsWith", "equals", "notEquals", "in", "lt", "lte", "gt" and "gte".
         */
        this.filterMatchMode = 'contains';
        /**
         *When specified, filter displays with this value.
         */
        this.filterValue = null;
        /**
         *Locale to use in filtering. The default locale is the host environment's current locale.
         */
        this.filterLocale = undefined;
        /**
         *When filtering is enabled, filterBy decides which field or fields (comma separated) to search against.
         */
        this.filterBy = null;
        /**
         *Defines placeholder of the filter input.
         */
        this.filterPlaceHolder = null;
        /**
         *Inline style of the list element.
         */
        this.listStyle = null;
        /**
         *Style class of the list element.
         */
        this.listStyleClass = null;
        /**
         *Defines how multiple items can be selected, when true metaKey needs to be pressed to select or unselect an item and when set to false selection of each item can be toggled individually. On touch enabled devices, metaKeySelection is turned off automatically.
         */
        this.metaKeySelection = true;
        /**
         *When specified, allows selecting multiple values.
         */
        this.multiple = false;
        /**
         *Text to display when there is no data. Defaults to global value in i18n translation configuration.
         */
        this.emptyMessage = 'No records found';
        /**
         *Text to display when filtering does not return any results. Defaults to global value in i18n translation configuration.
         */
        this.emptyFilterMessage = 'No results found';
        /**
         *An array of selectitems to display as the available options.
         */
        this.options = null;
        /**
         *Name of the label field of an option.
         */
        this.optionLabel = 'label';
        /**
         *Name of the value field of an option.
         */
        this.optionValue = 'value';
        /**
         *Name of the disabled field of an option.
         */
        this.optionDisabled = 'disabled';
        /**
         *Name of the label field of an option group.
         */
        this.optionGroupLabel = 'label';
        /**
         *Name of the options field of an option group.
         */
        this.optionGroupChildren = 'items';
        /**
         *Whether to display options as grouped when nested options are provided.
         */
        this.group = false;
        /**
         *Whether header checkbox is shown in multiple mode.
         */
        this.showToggleAll = true;
        /**
         *Inline style of the container.
         */
        this.style = null;
        /**
         *Style class of the container.
         */
        this.styleClass = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetListBoxConfigsDirective {
    /**
     * Constructor
     * @param {Listbox} element
     * @param {AbstractLookupTableService} lookupTableService
     * @param {AbstractEntityTypeService} entityTypeService
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ChangeDetectorRef} cdc
     */
    constructor(element, lookupTableService, entityTypeService, objectsUtilityService, cdc) {
        this.element = element;
        this.lookupTableService = lookupTableService;
        this.entityTypeService = entityTypeService;
        this.objectsUtilityService = objectsUtilityService;
        this.cdc = cdc;
    }
    /**
     * get options from lookup table or entity type list
     * and assign configs to element
     */
    set setListBoxConfigs(configs) {
        switch (configs.referenceType) {
            case ReferenceType.LookupTable:
                if (configs.referenceName !== null && configs.referenceName.length) {
                    this.lookupTableService
                        .getLookupTableItemsByLookupTableNameAsync(configs.referenceName)
                        .then((options) => {
                        configs.options = options;
                        Object.assign(this.element, configs);
                        /**
                         * We have to initiate change detection
                         * through ChangeDetectorRef because for some reason
                         * this object assignment is not reflected in the template
                         */
                        this.cdc.detectChanges();
                        /**
                         * we need to set the value of the control
                         * again because for some reason it stays null
                         * and doesn't map the value selected by default,
                         * we've already had to analyse this
                         * and for now we can't understand why this behaviour
                         */
                        if (configs.value) {
                            this.form.get(configs.key).setValue(configs.value);
                        }
                    });
                }
                else {
                    this.lookupTableService.getAllLookupTableAsync().then((options) => {
                        configs.options = options;
                        Object.assign(this.element, configs);
                        /**
                         * we need to set the value of the control
                         * again because for some reason it stays null
                         * and doesn't map the value selected by default,
                         * we've already had to analyse this
                         * and for now we can't understand why this behaviour
                         */
                        if (configs.value) {
                            this.form.get(configs.key).setValue(configs.value);
                        }
                    });
                }
                break;
            case ReferenceType.EntityType:
                this.entityTypeService.getEntityTypeListAsync().then((value) => {
                    configs.options = value;
                    Object.assign(this.element, configs);
                    /**
                     * We have to initiate change detection
                     * through ChangeDetectorRef because for some reason
                     * this object assignment is not reflected in the template
                     */
                    this.cdc.detectChanges();
                    if (configs.value) {
                        this.form.get(configs.key).setValue(configs.value);
                    }
                });
                break;
            default:
                Object.assign(this.element, configs);
                break;
        }
    }
}
PrgSetListBoxConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetListBoxConfigsDirective, deps: [{ token: i1$j.Listbox }, { token: AbstractLookupTableService }, { token: AbstractEntityTypeService }, { token: ObjectsUtilityService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetListBoxConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetListBoxConfigsDirective, selector: "[setListBoxConfigs]", inputs: { form: "form", setListBoxConfigs: "setListBoxConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetListBoxConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setListBoxConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$j.Listbox }, { type: AbstractLookupTableService }, { type: AbstractEntityTypeService }, { type: ObjectsUtilityService }, { type: i0.ChangeDetectorRef }]; }, propDecorators: { form: [{
                type: Input
            }], setListBoxConfigs: [{
                type: Input
            }] } });

/**
 * component List Box
 */
class PrgListBoxComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgListBoxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgListBoxComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgListBoxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgListBoxComponent, selector: "prg-list-box-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "\r\n<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n  <p-listbox\r\n    [form]=\"form\"\r\n    [setListBoxConfigs]=\"configs\"\r\n    [id]=\"configs.key\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [filterPlaceHolder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.filterPlaceholder'\r\n          | translate\r\n      \"\r\n    (onChange)=\"onChanged($event)\"\r\n  ></p-listbox>\r\n\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$j.Listbox, selector: "p-listbox", inputs: ["multiple", "style", "styleClass", "listStyle", "listStyleClass", "readonly", "disabled", "checkbox", "filter", "filterBy", "filterMatchMode", "filterLocale", "metaKeySelection", "dataKey", "showToggleAll", "optionLabel", "optionValue", "optionGroupChildren", "optionGroupLabel", "optionDisabled", "ariaFilterLabel", "filterPlaceHolder", "emptyFilterMessage", "emptyMessage", "group", "options", "filterValue"], outputs: ["onChange", "onClick", "onDblClick"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetListBoxConfigsDirective, selector: "[setListBoxConfigs]", inputs: ["form", "setListBoxConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgListBoxComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-list-box-field', template: "\r\n<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n  <p-listbox\r\n    [form]=\"form\"\r\n    [setListBoxConfigs]=\"configs\"\r\n    [id]=\"configs.key\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [filterPlaceHolder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.filterPlaceholder'\r\n          | translate\r\n      \"\r\n    (onChange)=\"onChanged($event)\"\r\n  ></p-listbox>\r\n\r\n</div>\r\n" }]
        }], propDecorators: { onValueChange: [{
                type: Output
            }], configs: [{
                type: Input
            }], form: [{
                type: Input
            }] } });

/**
 * Class Input Text
 */
class MultiSelectConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.multiSelect;
        /**
         * Reference type
         */
        this.referenceType = null;
        /**
         * Reference name -> shoud be a lookup table name
         */
        this.referenceName = null;
        /**
         *Target element to attach the overlay, valid values are body or a local ng-template variable of another element (note: use binding with brackets for template variables, e.g. [appendTo]=mydiv for a div element having #mydiv as variable name).
         */
        this.appendTo = null;
        /**
         *Defines a string that labels the filter input.
         */
        this.ariaFilterLabel = null;
        /**
         *Label of the input for accessibility.
         */
        this.label = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Applies focus to the filter element when the overlay is shown.
         */
        this.autofocusFilter = false;
        /**
         *Whether to automatically manage layering.
         */
        this.autoZIndex = true;
        /**
         *Base zIndex value to use in layering.
         */
        this.baseZIndex = 0;
        /**
         *Label to display when there are no selections. Deprecated: Use placeholder instead.
         */
        this.defaultLabel = 'Choose';
        /**
         *A property to uniquely identify a value in options.
         */
        this.dataKey = null;
        /*
        /!**
         *When present, it specifies that the element should be disabled.
         *!/
        public disabled: boolean = false;*/ //Property already on Base Field
        /**
         *Whether to show labels of selected item labels or use default label.
         */
        this.displaySelectedLabel = true;
        /**
         *Icon class of the dropdown icon.
         */
        this.dropdownIcon = 'pi pi-chevron-down';
        /**
         *Text to display when filtering does not return any results.
         */
        this.emptyFilterMessage = 'No results found';
        /**
         *When specified, displays an input field to filter the items on keyup.
         */
        this.filter = true;
        /**
         *Defines how the items are filtered, valid values are contains (default) startsWith, endsWith, equals, notEquals, in, lt, lte, gt and gte.
         */
        this.filterMatchMode = 'contains';
        /**
         *When specified, filter displays with this value.
         */
        this.filterValue = null;
        /**
         *Locale to use in filtering. The default locale is the host environment's current locale.
         */
        this.filterLocale = 'undefined';
        /**
         *When filtering is enabled, filterBy decides which field or fields (comma separated) to search against.
         */
        this.filterBy = null;
        /**
         *Defines placeholder of the filter input.
         */
        this.filterPlaceHolder = null;
        /**
         *Transition options of the hide animation.
         */
        this.hideTransitionOptions = '.1s linear';
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Decides how many selected item labels to show at most.
         */
        this.maxSelectedLabels = 3;
        /**
         *Name of the input element.
         */
        this.name = null;
        /**
         *An array of objects to display as the available options.
         */
        this.options = [];
        /**
         *Name of the label field of an option.
         */
        this.optionLabel = 'label';
        /**
         *Name of the value field of an option.
         */
        this.optionValue = 'value';
        /**
         *Name of the disabled field of an option.
         */
        this.optionDisabled = 'disabled';
        /**
         *Name of the label field of an option group.
         */
        this.optionGroupLabel = 'label';
        /**
         *Name of the options field of an option group.
         */
        this.optionGroupChildren = 'items';
        /**
         *Whether to display options as grouped when nested options are provided.
         */
        this.group = false;
        /**
         *Specifies the visibility of the options panel.
         */
        this.overlayVisible = false;
        /**
         *Inline style of the overlay panel.
         */
        this.panelStyle = null;
        /**
         *Label to display when there are no selections.
         */
        this.placeholder = null;
        /**
         *When present, it specifies that the component cannot be edited.
         */
        this.readonly = false;
        /**
         *Text to display when there is no data. Defaults to global value in i18n translation configuration.
         */
        this.emptyMessage = 'No records found.';
        /**
         *Clears the filter value when hiding the dropdown.
         */
        this.resetFilterOnHide = false;
        /**
         *Height of the viewport in pixels, a scrollbar is defined if height of list exceeds this value.
         */
        this.scrollHeight = '200px';
        /**
         *Label to display after exceeding max selected labels e.g. ({0} items selected), defaults ellipsis keyword to indicate a text-overflow.
         */
        this.selectedItemsLabel = 'ellipsis';
        /**
         *Number of maximum options that can be selected.
         */
        this.selectionLimit = null;
        /**
         *Whether to show the header.
         */
        this.showHeader = true;
        /**
         *Transition options of the show animation.
         */
        this.showTransitionOptions = '.12s cubic-bezier(0, 0, 0.2, 1)';
        /**
         *Whether to show the checkbox at header to toggle all items at once.
         */
        this.showToggleAll = true;
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Style class of the element.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Advisory information to display in a tooltip on hover.
         */
        this.tooltip = null;
        /**
         *Style class of the tooltip.
         */
        this.tooltipStyleClass = null;
        /**
         *Position of the tooltip, valid values are right, left, top and bottom.
         */
        this.tooltipPosition = 'top';
        /**
         *Type of CSS position.
         */
        this.tooltipPositionStyle = 'absolute';
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        /**
         *Whether the data should be loaded on demand during scroll.
         */
        this.virtualScroll = false;
        /**
         *Height of an item in the list for VirtualScrolling.
         */
        this.virtualScrollItemSize = null;
        /**
         *Whether to use the scroller feature. The properties of scroller component can be used like an object in it.
         */
        this.virtualScrollOptions = null;
        /**
         *Defines if data is loaded and interacted with in lazy manner.
         */
        this.lazy = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetMultiselectConfigsDirective {
    /**
     * constructor
     * @param {MultiSelect} element
     * @param {AbstractLookupTableService} lookupTableService
     * @param {AbstractEntityTypeService} entityTypeService
     * @param {ChangeDetectorRef} cd
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(element, lookupTableService, entityTypeService, cd, arrayUtilityService, objectsUtilityService) {
        this.element = element;
        this.lookupTableService = lookupTableService;
        this.entityTypeService = entityTypeService;
        this.cd = cd;
        this.arrayUtilityService = arrayUtilityService;
        this.objectsUtilityService = objectsUtilityService;
    }
    /**
     * input multi select configs and assign configs to element
     */
    set setMultiSelectConfigs(configs) {
        switch (configs.referenceType) {
            case ReferenceType.LookupTable:
                if (configs.referenceName !== null && configs.referenceName.length) {
                    this.lookupTableService
                        .getLookupTableItemsByLookupTableNameAsync(configs.referenceName)
                        .then((options) => {
                        configs.options = this.objectsUtilityService.cloneObject(options);
                        Object.assign(this.element, configs);
                        /**
                         * we need to set the value of the control
                         * again because for some reason it stays null
                         * and doesn't map the value selected by default,
                         * we've already had to analyse this
                         * and for now we can't understand why this behaviour
                         */
                        if (!this.form) {
                            this.form = new FormGroup({
                                [configs.key]: new FormControl(),
                            });
                        }
                        if (configs.value != null) {
                            this.form.get(configs.key).setValue(configs.value);
                            this.cd.detectChanges();
                        }
                    });
                    this.cd.detectChanges();
                }
                else {
                    this.lookupTableService.getAllLookupTableAsync().then((options) => {
                        configs.options = this.objectsUtilityService.cloneObject(options);
                        Object.assign(this.element, configs);
                        /**
                         * we need to set the value of the control
                         * again because for some reason it stays null
                         * and doesn't map the value selected by default,
                         * we've already had to analyse this
                         * and for now we can't understand why this behaviour
                         */
                        if (configs.value) {
                            this.form.get(configs.key).setValue(configs.value);
                        }
                    });
                }
                break;
            case ReferenceType.EntityType:
                this.entityTypeService.getEntityTypeListAsync().then((value) => {
                    configs.options = value;
                    Object.assign(this.element, configs);
                    if (configs.value) {
                        this.form.get(configs.key).setValue(configs.value);
                    }
                });
                this.cd.detectChanges();
                break;
            case ReferenceType.EntityTypeAllData:
                this.entityTypeService.getEntityTypeListAsync().then((value) => {
                    let entities = this.arrayUtilityService.clone(value);
                    entities.map(async (entityType, index) => {
                        let entityTypeAllData = this.objectsUtilityService.cloneObject(await this.entityTypeService.getAllEntityTypeDataByName(entityType.name));
                        entities[index].properties = this.objectsUtilityService.cloneObject(entityTypeAllData.properties);
                        entities[index].attributes = this.objectsUtilityService.cloneObject(entityTypeAllData.attributes);
                        entities[index].operations = this.objectsUtilityService.cloneObject(entityTypeAllData.operations);
                        /* entities[index]['data'] = [];
                        entities[index]['data'].push({
                          subData: this.arrayUtilityService.clone(
                            entityTypeAllData.operations
                          ),
                          label: 'operations',
                        });
            
                        entities[index]['data'].push({
                          subData: this.arrayUtilityService.clone(
                            entityTypeAllData.properties
                          ),
                          label: 'properties',
                        });
                        entities[index]['data'].push({
                          subData: this.arrayUtilityService.clone(
                            entityTypeAllData.attributes
                          ),
                          label: 'attributes',
                        });*/
                    });
                    configs.options = entities;
                    Object.assign(this.element, configs);
                    if (configs.value) {
                        this.form.get(configs.key).setValue(configs.value);
                    }
                });
                break;
            default:
                Object.assign(this.element, configs);
                break;
        }
    }
}
PrgSetMultiselectConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetMultiselectConfigsDirective, deps: [{ token: i1$k.MultiSelect }, { token: AbstractLookupTableService }, { token: AbstractEntityTypeService }, { token: i0.ChangeDetectorRef }, { token: ArrayUtilityService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetMultiselectConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetMultiselectConfigsDirective, selector: "[setMultiSelectConfigs]", inputs: { form: "form", setMultiSelectConfigs: "setMultiSelectConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetMultiselectConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setMultiSelectConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$k.MultiSelect }, { type: AbstractLookupTableService }, { type: AbstractEntityTypeService }, { type: i0.ChangeDetectorRef }, { type: ArrayUtilityService }, { type: ObjectsUtilityService }]; }, propDecorators: { form: [{
                type: Input
            }], setMultiSelectConfigs: [{
                type: Input
            }] } });

/**
 * component multi select
 */
class PrgMultiSelectComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgMultiSelectComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgMultiSelectComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgMultiSelectComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgMultiSelectComponent, selector: "prg-multi-select-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.name' | translate}}</p>\r\n  <p-multiSelect\r\n    display=\"chip\"\r\n    [form]=\"form\"\r\n    (onChange)=\"onChanged($event)\"\r\n    [options]=\"configs.options\"\r\n    [setMultiSelectConfigs]=\"configs\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n    [name]=\"configs.key + '.name' | translate\"\r\n  ></p-multiSelect>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$k.MultiSelect, selector: "p-multiSelect", inputs: ["style", "styleClass", "panelStyle", "panelStyleClass", "inputId", "disabled", "readonly", "group", "filter", "filterPlaceHolder", "filterLocale", "overlayVisible", "tabindex", "appendTo", "dataKey", "name", "label", "ariaLabelledBy", "displaySelectedLabel", "maxSelectedLabels", "selectionLimit", "selectedItemsLabel", "showToggleAll", "emptyFilterMessage", "emptyMessage", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "showHeader", "autoZIndex", "baseZIndex", "filterBy", "scrollHeight", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "filterMatchMode", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "display", "autocomplete", "showClear", "defaultLabel", "placeholder", "options", "filterValue", "itemSize"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onClear", "onPanelShow", "onPanelHide", "onLazyLoad"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetMultiselectConfigsDirective, selector: "[setMultiSelectConfigs]", inputs: ["form", "setMultiSelectConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgMultiSelectComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-multi-select-field', template: "<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.name' | translate}}</p>\r\n  <p-multiSelect\r\n    display=\"chip\"\r\n    [form]=\"form\"\r\n    (onChange)=\"onChanged($event)\"\r\n    [options]=\"configs.options\"\r\n    [setMultiSelectConfigs]=\"configs\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n    [name]=\"configs.key + '.name' | translate\"\r\n  ></p-multiSelect>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class Input Text
 */
class InputPasswordConfiguration extends BaseField {
    /**
     * constructor
     * @param init init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputPassword;
        /**
         *Text to prompt password entry. Defaults to PrimeNG I18N API configuration.
         */
        this.promptLabel = null;
        /**
         *^(((?=.*[a-z])(?=.*[A-Z]))|((?=.*[a-z])(?=.*[0-9]))|((?=.*[A-Z])(?=.*[0-9])))(?=.{6,}).
         */
        this.mediumRegex = 'Regex for a medium level password.';
        /**
         *^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9])(?=.{8,})
         */
        this.strongRegex = 'Regex for a strong level password.';
        /**
         *Text for a weak password. Defaults to PrimeNG I18N API configuration.
         */
        this.weakLabel = null;
        /**
         *Text for a medium password. Defaults to PrimeNG I18N API configuration.
         */
        this.mediumLabel = null;
        /**
         *Text for a strong password. Defaults to PrimeNG I18N API configuration.
         */
        this.strongLabel = null;
        /**
         *Whether to show the strength indicator or not.
         */
        this.feedback = true;
        /**
         *Whether to show an icon to display the password as plain text.
         */
        this.toggleMask = false;
        /**
         *Id of the element or body for document where the overlay should be appended to.
         */
        this.appendTo = null;
        /**
         *Inline style of the input field.
         */
        this.inputStyle = null;
        /**
         *Style class of the input field.
         */
        this.inputStyleClass = null;
        /**
         *Identifier of the accessible input element.
         */
        this.inputId = null;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Advisory information to display on input.
         */
        this.placeholder = null;
        /**
         *Label of the input for accessibility.
         */
        this.label = null;
        /**
         *Defines a string that labels the input for accessibility.
         */
        this.ariaLabel = null;
        /**
         *Specifies one or more IDs in the DOM that labels the input field.
         */
        this.ariaLabelledBy = null;
        /**
         *When enabled, a clear icon is displayed to clear the value.
         */
        this.showClear = false;
        Object.assign(this, init);
    }
}
/**
 * Directive
 * */
class PrgSetInputPasswordConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input password configs and assign configs to element
     */
    set setInputPasswordConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetInputPasswordConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputPasswordConfigsDirective, deps: [{ token: i1$l.Password }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetInputPasswordConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetInputPasswordConfigsDirective, selector: "[setInputPasswordConfigs]", inputs: { setInputPasswordConfigs: "setInputPasswordConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetInputPasswordConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setInputPasswordConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$l.Password }]; }, propDecorators: { setInputPasswordConfigs: [{
                type: Input
            }] } });

/**
 * component input password
 */
class PrgPasswordComponent {
}
PrgPasswordComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgPasswordComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgPasswordComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgPasswordComponent, selector: "prg-password-field", inputs: { configs: "configs", form: "form" }, ngImport: i0, template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <p-password [inputId]=\"configs.key\" [setInputPasswordConfigs]=\"configs\" [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\" [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n  ></p-password>\r\n  <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n</span>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$l.Password, selector: "p-password", inputs: ["ariaLabel", "ariaLabelledBy", "label", "disabled", "promptLabel", "mediumRegex", "strongRegex", "weakLabel", "mediumLabel", "strongLabel", "inputId", "feedback", "appendTo", "toggleMask", "inputStyleClass", "styleClass", "style", "inputStyle", "showTransitionOptions", "hideTransitionOptions", "placeholder", "showClear"], outputs: ["onFocus", "onBlur", "onClear"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetInputPasswordConfigsDirective, selector: "[setInputPasswordConfigs]", inputs: ["setInputPasswordConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgPasswordComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-password-field', template: "<span *ngIf=\"form\" class=\"p-float-label\" [formGroup]=\"form\">\r\n  <p-password [inputId]=\"configs.key\" [setInputPasswordConfigs]=\"configs\" [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\" [placeholder]=\"\r\n        configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n          | translate\r\n      \"\r\n  ></p-password>\r\n  <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n</span>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }] } });

/**
 * Class Radio Button
 */
class RadioButtonConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.radioButton;
        /**
         *Name of the radiobutton group.
         */
        this.name = null;
        /**
         *Value of the radiobutton.
         */
        this.value = null;
        /**
         *Label of the radiobutton.
         */
        this.label = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Used to define a string that labels the input element.
         */
        this.ariaLabel = null;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Style class of the label.
         */
        this.labelStyleClass = null;
        /**
         *An array of objects to display as dynamic values.Mandatory field.
         */
        this.options = null;
        /**
         *Name of the value field of an option. Default 'value'.
         */
        this.optionValue = 'value';
        /**
         *Name of the key field of an option.Default 'key'.Also used to bring the translation of the field
         */
        this.optionKey = 'key';
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetRadioButtonConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Radio Button configs and assign configs to element
     */
    set setRadioButtonConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetRadioButtonConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetRadioButtonConfigsDirective, deps: [{ token: i1$m.RadioButton }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetRadioButtonConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetRadioButtonConfigsDirective, selector: "[setRadioButtonConfigs]", inputs: { setRadioButtonConfigs: "setRadioButtonConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetRadioButtonConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setRadioButtonConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$m.RadioButton }]; }, propDecorators: { setRadioButtonConfigs: [{
                type: Input
            }] } });

/**
 * component Radio button
 */
class PrgRadioButtonComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                event: event,
                value: event.value,
            }));
        }
    }
}
PrgRadioButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRadioButtonComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgRadioButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgRadioButtonComponent, selector: "prg-radio-button-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div class=\"field-radio-button\" *ngIf=\"form\" [formGroup]=\"form\">\r\n<!--//TODO Colocar title na tradu\u00E7\u00E3o dos radio-button-->\r\n  <label>{{configs.basePathTranslation + '.' + configs.key + '.title' | translate}}</label>\r\n  <ng-container *ngIf=\"configs.options;else singleRadio\"  >\r\n  <div *ngFor=\"let option of configs.options \" [ngClass]=\"['py-1']\">\r\n    <p-radioButton\r\n      [formControlName]=\"configs.key\"\r\n      [setRadioButtonConfigs]=\"configs\"\r\n      (onClick)=\"onChanged($event)\"\r\n      [inputId]=\"option[configs.optionKey]\"\r\n      [value]=\"option[configs.optionValue]\">\r\n    </p-radioButton>\r\n    <label\r\n      for=\"{{option[configs.optionKey]}}\">{{configs.basePathTranslation + '.' + configs.key + '.' + option[configs.optionKey] + '.label' | translate}}</label>\r\n  </div>\r\n  </ng-container>\r\n  <ng-template #singleRadio>\r\n    <p-radioButton\r\n      [formControlName]=\"configs.key\"\r\n      [setRadioButtonConfigs]=\"configs\"\r\n      (onClick)=\"onChanged($event)\"\r\n      [inputId]=\"configs.key\"\r\n      [label]=\"configs.basePathTranslation + '.' + configs.key  + '.label' | translate\">\r\n    </p-radioButton>\r\n\r\n  </ng-template>\r\n</div>\r\n", dependencies: [{ kind: "component", type: i1$m.RadioButton, selector: "p-radioButton", inputs: ["value", "formControlName", "name", "disabled", "label", "tabindex", "inputId", "ariaLabelledBy", "ariaLabel", "style", "styleClass", "labelStyleClass"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetRadioButtonConfigsDirective, selector: "[setRadioButtonConfigs]", inputs: ["setRadioButtonConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRadioButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-radio-button-field', template: "<div class=\"field-radio-button\" *ngIf=\"form\" [formGroup]=\"form\">\r\n<!--//TODO Colocar title na tradu\u00E7\u00E3o dos radio-button-->\r\n  <label>{{configs.basePathTranslation + '.' + configs.key + '.title' | translate}}</label>\r\n  <ng-container *ngIf=\"configs.options;else singleRadio\"  >\r\n  <div *ngFor=\"let option of configs.options \" [ngClass]=\"['py-1']\">\r\n    <p-radioButton\r\n      [formControlName]=\"configs.key\"\r\n      [setRadioButtonConfigs]=\"configs\"\r\n      (onClick)=\"onChanged($event)\"\r\n      [inputId]=\"option[configs.optionKey]\"\r\n      [value]=\"option[configs.optionValue]\">\r\n    </p-radioButton>\r\n    <label\r\n      for=\"{{option[configs.optionKey]}}\">{{configs.basePathTranslation + '.' + configs.key + '.' + option[configs.optionKey] + '.label' | translate}}</label>\r\n  </div>\r\n  </ng-container>\r\n  <ng-template #singleRadio>\r\n    <p-radioButton\r\n      [formControlName]=\"configs.key\"\r\n      [setRadioButtonConfigs]=\"configs\"\r\n      (onClick)=\"onChanged($event)\"\r\n      [inputId]=\"configs.key\"\r\n      [label]=\"configs.basePathTranslation + '.' + configs.key  + '.label' | translate\">\r\n    </p-radioButton>\r\n\r\n  </ng-template>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class Rating
 */
class RatingConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.rating;
        /**
         *Number of stars.
         */
        this.stars = 5;
        /**
         *When specified a cancel icon is displayed to allow removing the value.
         */
        this.cancel = true;
        /**
         *Style class of the on icon.
         */
        this.iconOnClass = 'pi pi-star-fill';
        /**
         *Style class of the off icon.
         */
        this.iconOffClass = 'pi pi-star';
        /**
         *Style class of the cancel icon.
         */
        this.iconCancelClass = 'pi pi-ban';
        /**
         *Inline style of the on icon.
         */
        this.iconOnStyle = null;
        /**
         *Inline style of the off icon.
         */
        this.iconOffStyle = null;
        /**
         *Inline style of the cancel icon.
         */
        this.iconCancelStyle = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetRatingConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Rating configs and assign configs to element
     */
    set setRatingConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetRatingConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetRatingConfigsDirective, deps: [{ token: i1$n.Rating }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetRatingConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetRatingConfigsDirective, selector: "[setRatingConfigs]", inputs: { setRatingConfigs: "setRatingConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetRatingConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setRatingConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$n.Rating }]; }, propDecorators: { setRatingConfigs: [{
                type: Input
            }] } });

/**
 * Component Rating
 */
class PrgRatingComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgRatingComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRatingComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgRatingComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgRatingComponent, selector: "prg-rating-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate)}}</p>\r\n  <p-rating\r\n    [setRatingConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    (onRate)=\"onChanged($event)\"\r\n\r\n  ></p-rating>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$n.Rating, selector: "p-rating", inputs: ["disabled", "readonly", "stars", "cancel", "iconOnClass", "iconOnStyle", "iconOffClass", "iconOffStyle", "iconCancelClass", "iconCancelStyle"], outputs: ["onRate", "onCancel"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetRatingConfigsDirective, selector: "[setRatingConfigs]", inputs: ["setRatingConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRatingComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-rating-field', template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate)}}</p>\r\n  <p-rating\r\n    [setRatingConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    (onRate)=\"onChanged($event)\"\r\n\r\n  ></p-rating>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class Select Button
 */
class SelectButtonConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.selectButton;
        /**
         *An array of selectitems to display as the available options.
         */
        this.options = null;
        /**
         *Name of the label field of an option.
         */
        this.optionLabel = 'label';
        /**
         *Name of the value field of an option.
         */
        this.optionValue = 'value';
        /**
         *Name of the disabled field of an option.
         */
        this.optionDisabled = 'disabled';
        /**
         *When specified, allows selecting multiple values.
         */
        this.multiple = false;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = 0;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *A property to uniquely identify a value in options.
         */
        this.dataKey = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetSelectButtonConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Select Button configs and assign configs to element
     */
    set setSelectButtonConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetSelectButtonConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSelectButtonConfigsDirective, deps: [{ token: i1$7.SelectButton }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetSelectButtonConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetSelectButtonConfigsDirective, selector: "[setSelectButtonConfigs]", inputs: { setSelectButtonConfigs: "setSelectButtonConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSelectButtonConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setSelectButtonConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$7.SelectButton }]; }, propDecorators: { setSelectButtonConfigs: [{
                type: Input
            }] } });

/**
 * component select button
 */
class PrgSelectButtonComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                event: event,
                value: event.value,
            }));
        }
    }
}
PrgSelectButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectButtonComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgSelectButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSelectButtonComponent, selector: "prg-select-button-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div class=\"field-select-button\" *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n<p-selectButton\r\n  (onChange)=\"onChanged($event)\"\r\n  [setSelectButtonConfigs]=\"configs\"\r\n  [formControlName]=\"configs.key\"\r\n  [id]=\"configs.key\"\r\n  [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\">\r\n</p-selectButton>\r\n</div>\r\n", dependencies: [{ kind: "component", type: i1$7.SelectButton, selector: "p-selectButton", inputs: ["options", "optionLabel", "optionValue", "optionDisabled", "tabindex", "multiple", "style", "styleClass", "ariaLabelledBy", "disabled", "dataKey"], outputs: ["onOptionClick", "onChange"] }, { kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetSelectButtonConfigsDirective, selector: "[setSelectButtonConfigs]", inputs: ["setSelectButtonConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-select-button-field', template: "<div class=\"field-select-button\" *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n<p-selectButton\r\n  (onChange)=\"onChanged($event)\"\r\n  [setSelectButtonConfigs]=\"configs\"\r\n  [formControlName]=\"configs.key\"\r\n  [id]=\"configs.key\"\r\n  [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\">\r\n</p-selectButton>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * component dropdown/select
 */
class PrgSelectComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgSelectComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgSelectComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSelectComponent, selector: "prg-select-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.name' | translate}}</p>\r\n  <p-dropdown\r\n    [form]=\"form\"\r\n    [options]=\"configs.options\"\r\n    [setSelectConfigs]=\"configs\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [placeholder]=\"\r\n      configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n        | translate\r\n    \"\r\n    [name]=\"configs.key + '.name' | translate\"\r\n    (onChange)=\"onChanged($event)\"\r\n  ></p-dropdown>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$5.Dropdown, selector: "p-dropdown", inputs: ["scrollHeight", "filter", "name", "style", "panelStyle", "styleClass", "panelStyleClass", "readonly", "required", "editable", "appendTo", "tabindex", "placeholder", "filterPlaceholder", "filterLocale", "inputId", "selectId", "dataKey", "filterBy", "autofocus", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "autoDisplayFirst", "group", "showClear", "emptyFilterMessage", "emptyMessage", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "autoZIndex", "baseZIndex", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "ariaLabel", "ariaLabelledBy", "filterMatchMode", "maxlength", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "disabled", "itemSize", "options", "filterValue"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onShow", "onHide", "onClear", "onLazyLoad"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetSelectConfigsDirective, selector: "[setSelectConfigs]", inputs: ["form", "setSelectConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-select-field', template: "<div *ngIf=\"form && configs != null\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.name' | translate}}</p>\r\n  <p-dropdown\r\n    [form]=\"form\"\r\n    [options]=\"configs.options\"\r\n    [setSelectConfigs]=\"configs\"\r\n    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n    [formControlName]=\"configs.key\"\r\n    [placeholder]=\"\r\n      configs.basePathTranslation + '.' + configs.key + '.placeholder'\r\n        | translate\r\n    \"\r\n    [name]=\"configs.key + '.name' | translate\"\r\n    (onChange)=\"onChanged($event)\"\r\n  ></p-dropdown>\r\n</div>\r\n" }]
        }], propDecorators: { onValueChange: [{
                type: Output
            }], configs: [{
                type: Input
            }], form: [{
                type: Input
            }] } });

/**
 * Class Slider
 */
class SliderConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.slider;
        /**
         *When enabled, displays an animation on click of the slider bar.
         */
        this.animate = false;
        /**
         *Mininum boundary value.
         */
        this.min = 0;
        /**
         *Maximum boundary value.
         */
        this.max = 100;
        /**
         *Orientation of the slider, valid values are horizontal and vertical.
         */
        this.orientation = 'horizontal';
        /**
         *Step factor to increment/decrement the value.
         */
        this.step = 1;
        /**
         *When specified, allows two boundary values to be picked.
         */
        this.range = false;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = 0;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetSliderConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input slider configs and assign configs to element
     */
    set setSliderConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetSliderConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSliderConfigsDirective, deps: [{ token: i1$o.Slider }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetSliderConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetSliderConfigsDirective, selector: "[setSliderConfigs]", inputs: { setSliderConfigs: "setSliderConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetSliderConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setSliderConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$o.Slider }]; }, propDecorators: { setSliderConfigs: [{
                type: Input
            }] } });

/**
 * Component Slider
 */
class PrgSliderComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the outpout
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.value,
                event: event,
            }));
        }
    }
}
PrgSliderComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSliderComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgSliderComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSliderComponent, selector: "prg-slider-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate) + ': '}}{{value?value:''}}</p>\r\n  <p-slider\r\n    [setSliderConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    (onChange)=\"onChanged($event)\"\r\n    [(ngModel)]=\"value\"\r\n  ></p-slider>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$o.Slider, selector: "p-slider", inputs: ["animate", "disabled", "min", "max", "orientation", "step", "range", "style", "styleClass", "ariaLabelledBy", "tabindex"], outputs: ["onChange", "onSlideEnd"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetSliderConfigsDirective, selector: "[setSliderConfigs]", inputs: ["setSliderConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSliderComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-slider-field', template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{(configs.basePathTranslation + '.' + configs.key + '.label' | translate) + ': '}}{{value?value:''}}</p>\r\n  <p-slider\r\n    [setSliderConfigs]=\"configs\"\r\n    [formControlName]=\"configs.key\"\r\n    (onChange)=\"onChanged($event)\"\r\n    [(ngModel)]=\"value\"\r\n  ></p-slider>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class ToggleButton
 */
class ToggleButtonConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.toggleButton;
        /**
         *Enable inline label of the toggle button.
         */
        this.hasLabel = false;
        /**
         *Label for the on state.
         */
        this.onLabel = null;
        /**
         *Label for the off state.
         */
        this.offLabel = null;
        /**
         *Icon for the on state.
         */
        this.onIcon = 'pi pi-check';
        /**
         *Icon for the off state.
         */
        this.offIcon = 'pi pi-times';
        /**
         *Position of the icon, valid values are "left" and "right".
         */
        this.iconPos = 'left';
        /**
         *Inline style of the element.
         */
        this.style = null;
        /**
         *Style class of the element.
         */
        this.styleClass = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetToggleButtonConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input ToggleButton configs and assign configs to element
     */
    set setToggleButtonConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetToggleButtonConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetToggleButtonConfigsDirective, deps: [{ token: i1$a.ToggleButton }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetToggleButtonConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetToggleButtonConfigsDirective, selector: "[setToggleButtonConfigs]", inputs: { setToggleButtonConfigs: "setToggleButtonConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetToggleButtonConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setToggleButtonConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$a.ToggleButton }]; }, propDecorators: { setToggleButtonConfigs: [{
                type: Input
            }] } });

/**
 * Toggle button component
 */
class PrgToggleButtonComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                value: event.checked,
                event: event,
            }));
        }
    }
}
PrgToggleButtonComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgToggleButtonComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgToggleButtonComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgToggleButtonComponent, selector: "prg-toggle-button-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n    <p-toggleButton\r\n      (onChange)=\"onChanged($event)\"\r\n      [setToggleButtonConfigs]=\"configs\"\r\n      [formControlName]=\"configs.key\"\r\n      [inputId]=\"configs.key\"\r\n      [onLabel]=\"configs.hasLabel?(configs.basePathTranslation + '.' + configs.key + '.onLabel' | translate):''\"\r\n      [offLabel]=\"configs.hasLabel?(configs.basePathTranslation + '.' + configs.key + '.offLabel' | translate):''\"\r\n      ></p-toggleButton>\r\n</div>\r\n\r\n\r\n", dependencies: [{ kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "component", type: i1$a.ToggleButton, selector: "p-toggleButton", inputs: ["onLabel", "offLabel", "onIcon", "offIcon", "ariaLabelledBy", "disabled", "style", "styleClass", "inputId", "tabindex", "iconPos"], outputs: ["onChange"] }, { kind: "directive", type: PrgSetToggleButtonConfigsDirective, selector: "[setToggleButtonConfigs]", inputs: ["setToggleButtonConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgToggleButtonComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-toggle-button-field', template: "<div *ngIf=\"form\" [formGroup]=\"form\">\r\n  <p>{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</p>\r\n    <p-toggleButton\r\n      (onChange)=\"onChanged($event)\"\r\n      [setToggleButtonConfigs]=\"configs\"\r\n      [formControlName]=\"configs.key\"\r\n      [inputId]=\"configs.key\"\r\n      [onLabel]=\"configs.hasLabel?(configs.basePathTranslation + '.' + configs.key + '.onLabel' | translate):''\"\r\n      [offLabel]=\"configs.hasLabel?(configs.basePathTranslation + '.' + configs.key + '.offLabel' | translate):''\"\r\n      ></p-toggleButton>\r\n</div>\r\n\r\n\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * Class TriState Checkbox
 */
class TriStateCheckboxConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.triStateCheckbox;
        /**
         *Name of the component.
         */
        this.name = null;
        /**
         *Label of the checkbox.
         */
        this.label = null;
        /**
         *Index of the element in tabbing order.
         */
        this.tabindex = null;
        /**
         *Identifier of the focus input to match a label defined for the component.
         */
        this.inputId = null;
        /**
         *Establishes relationships between the component and label(s) where its value should be one or more element IDs.
         */
        this.ariaLabelledBy = null;
        /**
         *Inline style of the component.
         */
        this.style = null;
        /**
         *Style class of the component.
         */
        this.styleClass = null;
        /**
         *Specifies the icon for checkbox true value.
         */
        this.checkboxTrueIcon = 'pi pi-check';
        /**
         *Specifies the icon for checkbox false value.
         */
        this.checkboxFalseIcon = 'pi pi-times';
        Object.assign(this, init);
    }
}
/**
 * Directive
 */
class PrgSetTriStateCheckboxConfigsDirective {
    /**
     * constructor
     * @param element
     */
    constructor(element) {
        this.element = element;
    }
    /**
     * input Tri State Checkbox configs and assign configs to element
     */
    set setTriStateCheckboxConfigs(configs) {
        Object.assign(this.element, configs);
    }
}
PrgSetTriStateCheckboxConfigsDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetTriStateCheckboxConfigsDirective, deps: [{ token: i1$p.TriStateCheckbox }], target: i0.ɵɵFactoryTarget.Directive });
PrgSetTriStateCheckboxConfigsDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.2.0", type: PrgSetTriStateCheckboxConfigsDirective, selector: "[setTriStateCheckboxConfigs]", inputs: { setTriStateCheckboxConfigs: "setTriStateCheckboxConfigs" }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSetTriStateCheckboxConfigsDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[setTriStateCheckboxConfigs]',
                }]
        }], ctorParameters: function () { return [{ type: i1$p.TriStateCheckbox }]; }, propDecorators: { setTriStateCheckboxConfigs: [{
                type: Input
            }] } });

/**
 * component tri state checkbox
 */
class PrgTriStateCheckboxComponent {
    constructor() {
        /**
         * output
         */
        this.onValueChange = new EventEmitter();
    }
    /**
     * function that triggers the output
     */
    onChanged(event) {
        if (!this.configs.disabledOutputEvent) {
            this.onValueChange.emit(new FieldChangeOutput({
                field: this.configs.key,
                event: event,
                value: event.value,
            }));
        }
    }
}
PrgTriStateCheckboxComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTriStateCheckboxComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgTriStateCheckboxComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgTriStateCheckboxComponent, selector: "prg-tri-state-checkbox-field", inputs: { configs: "configs", form: "form" }, outputs: { onValueChange: "onValueChange" }, ngImport: i0, template: "<div class=\"field-tri-state-checkbox\" *ngIf=\"form\" [formGroup]=\"form\">\r\n\r\n<p-triStateCheckbox (onChange)=\"onChanged($event)\"\r\n                    [setTriStateCheckboxConfigs]=\"configs\"\r\n                    [formControlName]=\"configs.key\"\r\n                    [inputId]=\"configs.key\"\r\n                    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n                    [name]=\"configs.key + '.name' | translate\">\r\n</p-triStateCheckbox>\r\n  <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n", dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i1$p.TriStateCheckbox, selector: "p-triStateCheckbox", inputs: ["disabled", "name", "ariaLabelledBy", "tabindex", "inputId", "style", "styleClass", "label", "readonly", "checkboxTrueIcon", "checkboxFalseIcon"], outputs: ["onChange"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: PrgSetTriStateCheckboxConfigsDirective, selector: "[setTriStateCheckboxConfigs]", inputs: ["setTriStateCheckboxConfigs"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTriStateCheckboxComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-tri-state-checkbox-field', template: "<div class=\"field-tri-state-checkbox\" *ngIf=\"form\" [formGroup]=\"form\">\r\n\r\n<p-triStateCheckbox (onChange)=\"onChanged($event)\"\r\n                    [setTriStateCheckboxConfigs]=\"configs\"\r\n                    [formControlName]=\"configs.key\"\r\n                    [inputId]=\"configs.key\"\r\n                    [ngClass]=\"{ 'p-filled': form.controls[configs?.key]?.value !== '' }\"\r\n                    [name]=\"configs.key + '.name' | translate\">\r\n</p-triStateCheckbox>\r\n  <label for=\"{{configs.key}}\">{{configs.basePathTranslation + '.' + configs.key + '.label' | translate}}</label>\r\n</div>\r\n" }]
        }], propDecorators: { configs: [{
                type: Input
            }], form: [{
                type: Input
            }], onValueChange: [{
                type: Output
            }] } });

/**
 * list of types of fields
 */
const ControlTypes = {
    inputText: PrgInputTextComponent,
    inputNumber: PrgInputNumberComponent,
    inputDateTime: PrgDateTimeComponent,
    inputPassword: PrgPasswordComponent,
    dropdown: PrgSelectComponent,
    multiSelect: PrgMultiSelectComponent,
    checkbox: PrgCheckboxComponent,
    inputTextArea: PrgInputTextAreaComponent,
    triStateCheckbox: PrgTriStateCheckboxComponent,
    selectButton: PrgSelectButtonComponent,
    radioButton: PrgRadioButtonComponent,
    colorPicker: PrgColorPickerComponent,
    inputMask: PrgInputMaskComponent,
    slider: PrgSliderComponent,
    inputSwitch: PrgInputSwitchComponent,
    rating: PrgRatingComponent,
    knob: PrgKnobComponent,
    chips: PrgChipsComponent,
    toggleButton: PrgToggleButtonComponent,
    listBox: PrgListBoxComponent,
    cascadeSelect: PrgCascadeSelectComponent,
    autoComplete: PrgAutoCompleteComponent,
};

/**
 * Dynamic form field component
 */
class PrgDynamicFormFieldComponent {
    constructor() {
        /**
         * Emit a new FieldChangeOutput whenever a field value changes
         */
        this.onChange = new EventEmitter();
        /**
         * output to dynamic component
         */
        this.outputs = {
            onValueChange: (fieldChangeOutput) => {
                this.onChange.emit(fieldChangeOutput);
            },
        };
        /**
         * fields type
         * @type {{inputNumber: PrgInputNumberComponent, inputTextArea: PrgInputTextAreaComponent, checkbox: PrgCheckboxComponent, inputText: PrgInputTextComponent, inputDateTime: PrgDateTimeComponent, inputPassword: PrgPasswordComponent, dropdown: PrgSelectComponent, multiSelect: PrgMultiSelectComponent}}
         */
        this.fieldTypes = ControlTypes;
    }
    /**
     * @returns boolean if question is valid or not
     */
    get isValid() {
        return this.form.controls[this.field.key].valid;
    }
    /**
     * @returns string with error
     */
    get errors() {
        return this.form.controls[this.field.key].errors;
    }
    /**
     * get control
     * @returns control
     */
    get formControl() {
        return this.form.controls[this.field.key];
    }
    /**
     * get control name
     * @return controlname
     */
    get controlNames() {
        return ControlName;
    }
}
PrgDynamicFormFieldComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDynamicFormFieldComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgDynamicFormFieldComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDynamicFormFieldComponent, selector: "prg-dynamic-form-field", inputs: { field: "field", form: "form" }, outputs: { onChange: "onChange" }, ngImport: i0, template: "<div [formGroup]=\"form\" class=\"field\">\r\n      <ndc-dynamic  [ndcDynamicComponent]=\"fieldTypes[field.controlName]\"\r\n       [ndcDynamicInputs]=\"{configs: field, form: form}\"\r\n                   [ndcDynamicOutputs]=\"outputs\">\r\n      </ndc-dynamic>\r\n</div>\r\n", styles: [".p-float-label{margin:40px 0 40px 30px}.field{margin:30px}\n"], dependencies: [{ kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "component", type: i1$b.DynamicComponent, selector: "ndc-dynamic", inputs: ["ndcDynamicComponent", "ndcDynamicInjector", "ndcDynamicProviders", "ndcDynamicContent"], outputs: ["ndcDynamicCreated"] }, { kind: "directive", type: i1$b.DynamicIoDirective, selector: "[ndcDynamicInputs],[ndcDynamicOutputs]", inputs: ["ndcDynamicInputs", "ndcDynamicOutputs"], exportAs: ["ndcDynamicIo"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDynamicFormFieldComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-dynamic-form-field', template: "<div [formGroup]=\"form\" class=\"field\">\r\n      <ndc-dynamic  [ndcDynamicComponent]=\"fieldTypes[field.controlName]\"\r\n       [ndcDynamicInputs]=\"{configs: field, form: form}\"\r\n                   [ndcDynamicOutputs]=\"outputs\">\r\n      </ndc-dynamic>\r\n</div>\r\n", styles: [".p-float-label{margin:40px 0 40px 30px}.field{margin:30px}\n"] }]
        }], propDecorators: { field: [{
                type: Input
            }], form: [{
                type: Input
            }], onChange: [{
                type: Output
            }] } });

/**
 * Inject token
 */
const PRG_ENTITY_TYPES_CONFIG = new InjectionToken("PRG_ENTITY_TYPES_CONFIG");
/**
 * Injectable
 */
class PrgEntityTypesConfigurationService {
    /**
     * constructor
     *
     * @param prgEntityTypesConfig
     */
    constructor(prgEntityTypesConfig) {
        this.prgEntityTypesConfig = prgEntityTypesConfig;
    }
}
PrgEntityTypesConfigurationService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesConfigurationService, deps: [{ token: PRG_ENTITY_TYPES_CONFIG }], target: i0.ɵɵFactoryTarget.Injectable });
PrgEntityTypesConfigurationService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesConfigurationService, providedIn: "root" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesConfigurationService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: "root",
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ENTITY_TYPES_CONFIG]
                }] }]; } });

var ViewMode;
(function (ViewMode) {
    ViewMode["Edit"] = "edit";
    ViewMode["View"] = "view";
    ViewMode["Read"] = "read";
    ViewMode["Create"] = "create";
    ViewMode["Add"] = "add";
})(ViewMode || (ViewMode = {}));

/**
 * injectable
 */
class FormGroupService {
    /**constructor */
    constructor() { }
    /**
     * this function is responsible for creating a formGroup[]
     * with the respective values and validations for each field of the object
     * @param objects
     * @param columnsData
     * @returns
     */
    toFormGroupMultipleObjects(objects, columnsData) {
        const objectProperties = Object.getOwnPropertyNames(objects[0]);
        let formGroupArray = [];
        objects.forEach((object) => {
            const formGroupAux = new FormGroup(this.getFormGroup(objectProperties, columnsData));
            formGroupAux.setValue(object);
            formGroupArray.push(formGroupAux);
        });
        return formGroupArray;
    }
    /**
     * this function is responsible for creating a formGroup
     * with the respective values and validations for a given object
     *
     * @param object
     * @param columnsData
     * @returns
     */
    toFormGroupOneObject(object, columnsData) {
        const objectProperties = Object.getOwnPropertyNames(object);
        const formGroup = new FormGroup(this.getFormGroup(objectProperties, columnsData));
        formGroup.setValue(object);
        return formGroup;
    }
    /**
     * this function returns an object with the
     * required fields with its formControl
     *
     * @param objectProperties
     * @param columnsData
     * @returns any
     */
    getFormGroup(objectProperties, columnsData) {
        let objectWithValidators = {};
        objectProperties.forEach((property) => {
            const column = columnsData.find((column) => column.key === property);
            let validators = null;
            if (column) {
                validators = column.validators;
            }
            objectWithValidators[property] = new FormControl(null, validators);
        });
        return objectWithValidators;
    }
    /**
     * this function recive fields and transform it in a form group
     * @param fields
     * @returns FormGroup
     */
    toFormGroup(fields) {
        const group = {};
        fields.forEach((field) => {
            group[field.key] = new FormControl(field.value, field.validators);
        });
        return new FormGroup(group);
    }
}
FormGroupService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: FormGroupService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
FormGroupService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: FormGroupService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: FormGroupService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return []; } });

/**
 * Dynamic form component
 */
class PrgDynamicFormComponent {
    /**
     * constructor
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {FormGroupService} formGroupService
     * @param {UtilityService} utilityService
     * @param {PrgEntityTypesConfig} entityConfigs
     */
    constructor(objectsUtilityService, arrayUtilityService, formGroupService, utilityService, entityConfigs) {
        this.objectsUtilityService = objectsUtilityService;
        this.arrayUtilityService = arrayUtilityService;
        this.formGroupService = formGroupService;
        this.utilityService = utilityService;
        this.entityConfigs = entityConfigs;
        /**
         * Tab menu items
         * @type {PrgMenuItem[]}
         */
        this.tabMenuItemsDynamicForm = [];
        /**
         * Context of class where dynamic form component is used
         * @type {any}
         */
        this.context = null;
        /**
         * fields aux
         */
        this._fields = [];
        /**
         * fields aux
         */
        this._originalFields = [];
        /**
         * actions aux
         */
        this._actions = [];
        /**
         * action output
         */
        this.actionOutput = new EventEmitter();
        /**
         * Field output onChange
         * @type {EventEmitter<DynamicFormFieldChangeOutput>}
         */
        this.fieldChangeOutput = new EventEmitter();
        /**
         * left actions
         */
        this.leftActions = [];
        /**
         * middle actions
         */
        this.middleActions = [];
        /**
         * right actions
         */
        this.rightActions = [];
    }
    /**
     *array with the fields
     */
    set fields(fields) {
        this._fields = this.arrayUtilityService.clone(fields);
        this._originalFields = this.arrayUtilityService.clone(fields);
        this.form = this.formGroupService.toFormGroup(fields);
    }
    /**
     * get fields
     */
    get fields() {
        return this._fields;
    }
    /**
     *array with the actions
     */
    set actions(actions) {
        this._actions = actions;
        this.createActionsArray();
    }
    /**
     * get actions
     */
    get actions() {
        return this._actions;
    }
    /**
     * input entity
     */
    set entity(entity) {
        if (entity) {
            this._entity = this.objectsUtilityService.cloneObject(entity);
            this._entityTemp = this.objectsUtilityService.cloneObject(entity);
            this.mapValueToFields(entity);
        }
    }
    /**
     * get entity
     */
    get entity() {
        return this._entity;
    }
    /**
     * getter entity temp
     * @returns {any}
     */
    get entityTemp() {
        return this._entityTemp;
    }
    /**
     * input view mode
     */
    set viewMode(viewMode) {
        this._viewMode = viewMode;
        this.fields.forEach((field) => {
            field.readonly = viewMode !== ViewMode.Edit;
            field.disabled = viewMode !== ViewMode.Edit;
        });
        this.fields = this.arrayUtilityService.clone(this.fields);
    }
    /**
     * get View Mode
     */
    get viewMode() {
        return this._viewMode;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        if (this.formGroupType === 'tab') {
            this.createTabMenu();
        }
    }
    /**
     * this function divides the actions by their respective positions
     */
    createActionsArray() {
        if (this._actions) {
            this._actions = this.arrayUtilityService.sortByProperty(this._actions, 'order');
            this.leftActions = this._actions.reduce((prev, curr) => {
                if (curr.toolbarSlot == 'left') {
                    prev.push(curr);
                }
                return prev;
            }, []);
            this.middleActions = this._actions.reduce((prev, curr) => {
                if (curr.toolbarSlot == 'middle') {
                    prev.push(curr);
                }
                return prev;
            }, []);
            this.rightActions = this._actions.reduce((prev, curr) => {
                if (curr.toolbarSlot == 'right') {
                    prev.push(curr);
                }
                return prev;
            }, []);
        }
    }
    /**
     * this function fire the output
     * @param action
     */
    onActionClicked(action) {
        if (this.viewMode !== ViewMode.Add) {
            this.mapFieldsToValue();
        }
        this.actionOutput.emit(new DynamicFormActionOutput({
            action: action.action,
            value: action.value,
            group: action.group,
            formEntity: this.entity,
            formStatus: this.form.status.toLowerCase(),
            isChanged: !this.form.pristine,
        }));
    }
    /**
     * this function maps the new values in the entity
     */
    mapFieldsToValue(data = null) {
        if (data == null) {
            data = this.entity;
        }
        Object.keys(this.form.getRawValue()).forEach((key) => {
            data[key] = this.form.controls[key].getRawValue();
        });
    }
    /**
     * this function maps the entity values in the fields
     * @param entity
     */
    mapValueToFields(entity) {
        this._fields = this.arrayUtilityService.clone(this._originalFields);
        this.fieldsReadonly();
        this._fields.forEach((field) => {
            if (entity[field.key]) {
                field.value = entity[field.key];
            }
        });
        this.form = this.formGroupService.toFormGroup(this.fields);
    }
    /**
     * this function depending on the view mode changes the read only and disabled value
     */
    fieldsReadonly() {
        this._fields.forEach((field) => {
            field.readonly = this.viewMode !== ViewMode.Edit;
            field.disabled = this.viewMode !== ViewMode.Edit;
        });
    }
    /**
     * this function calls the service that does the expression eval for fields
     * @param {string} expression
     * @param {boolean} defaultValue
     * @param {string | null} formFieldGroup
     * @returns {boolean}
     */
    evalExpression(expression, defaultValue = false, formFieldGroup = null) {
        if (this.formGroupType &&
            formFieldGroup != null &&
            formFieldGroup !== this.activeTabMenuItemsDynamicForm.id) {
            return false;
        }
        if (!expression)
            return defaultValue;
        return this.utilityService.evalFunction(expression, this, this.context != null ? this.context : {});
    }
    /**
     * this function fire the output for the fields
     * @param {FieldChangeOutput} field
     */
    onFieldChanged(field) {
        // Set Fields to Value before emit, to reflect changes instantly
        let data = {};
        if (this.viewMode !== ViewMode.Add) {
            this.mapFieldsToValue(data);
        }
        this._entityTemp = { ...this._entityTemp, ...data };
        this.fieldChangeOutput.emit(new DynamicFormFieldChangeOutput({
            field: field.field,
            value: field.value,
            event: field.event,
            formEntity: this.entityTemp, //need this field to access all fields values of the form whenever there is a change in fields
        }));
    }
    /**
     * This function is responsible to change the active tab property of the class whenever a tab is change on form
     * @param event
     * @private
     */
    onChangeTab(event) {
        this.activeTabMenuItemsDynamicForm = event?.item;
    }
    /**
     * This function construct the tab menu base on property groupFieldsId of the fields
     * @private
     */
    createTabMenu() {
        const tabGroups = this.fields.map((field) => {
            return field.groupFieldsId;
        });
        const tabGroupsUnique = this.arrayUtilityService.clone(Array.from(new Set(tabGroups)));
        tabGroupsUnique.map((value) => {
            this.tabMenuItemsDynamicForm.push({
                label: value,
                id: value,
                command: (event) => this.onChangeTab(event),
            });
        });
        this.activeTabMenuItemsDynamicForm = this.tabMenuItemsDynamicForm[0];
    }
}
PrgDynamicFormComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDynamicFormComponent, deps: [{ token: ObjectsUtilityService }, { token: ArrayUtilityService }, { token: FormGroupService }, { token: UtilityService }, { token: PRG_ENTITY_TYPES_CONFIG }], target: i0.ɵɵFactoryTarget.Component });
PrgDynamicFormComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDynamicFormComponent, selector: "prg-dynamic-form", inputs: { context: "context", fields: "fields", actions: "actions", entity: "entity", viewMode: "viewMode", formGroupType: "formGroupType" }, outputs: { actionOutput: "actionOutput", fieldChangeOutput: "fieldChangeOutput" }, ngImport: i0, template: "\r\n<div class=\"dynamic-form\">\r\n  <p-tabMenu *ngIf=\"formGroupType==='tab'&&tabMenuItemsDynamicForm.length>0\" [model]=\"tabMenuItemsDynamicForm\" [activeItem]=\"activeTabMenuItemsDynamicForm\">\r\n\r\n  </p-tabMenu>\r\n\r\n\r\n  <form [formGroup]=\"form\">\r\n    <div class=\"form-row\" *ngIf=\"actions!=null&&actions.length>0\">\r\n      <p-toolbar >\r\n        <div class=\"p-toolbar-group-left\">\r\n          <ng-container *ngFor=\"let action of leftActions\">\r\n            <prg-dynamic-form-action\r\n              *ngIf=\"evalExpression(action.visibleExpression,true)\"\r\n              [action]=\"action\"\r\n              [form]=\"form\"\r\n              (actionClick)=\"onActionClicked($event)\"\r\n            >\r\n            </prg-dynamic-form-action>\r\n          </ng-container>\r\n        </div>\r\n        <div>\r\n          <ng-container *ngFor=\"let action of middleActions\">\r\n            <prg-dynamic-form-action\r\n              *ngIf=\"evalExpression(action.visibleExpression, true)\"\r\n              [action]=\"action\"\r\n              [form]=\"form\"\r\n              (actionClick)=\"onActionClicked($event)\"\r\n            >\r\n            </prg-dynamic-form-action>\r\n          </ng-container>\r\n        </div>\r\n        <div class=\"p-toolbar-group-right\">\r\n          <ng-container *ngFor=\"let action of rightActions\">\r\n            <prg-dynamic-form-action\r\n              *ngIf=\"evalExpression(action.visibleExpression, true)\"\r\n              [action]=\"action\"\r\n              [form]=\"form\"\r\n              (actionClick)=\"onActionClicked($event)\"\r\n            >\r\n            </prg-dynamic-form-action>\r\n          </ng-container>\r\n        </div>\r\n      </p-toolbar>\r\n    </div>\r\n    <ng-container *ngIf=\"viewMode !== 'add' && form != null\">\r\n      <div *ngFor=\"let field of fields\" class=\"form-row dynamic-form-fields\">\r\n\r\n        <prg-dynamic-form-field\r\n          *ngIf=\"evalExpression(field.visibleExpression, true,field.groupFieldsId)\"\r\n          [field]=\"field\"\r\n          [form]=\"form\"\r\n          (onChange)=\"onFieldChanged($event)\"\r\n        ></prg-dynamic-form-field>\r\n      </div>\r\n    </ng-container>\r\n  </form>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "directive", type: i1$2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i6$2.TabMenu, selector: "p-tabMenu", inputs: ["model", "activeItem", "scrollable", "popup", "style", "styleClass"] }, { kind: "component", type: i7$2.Toolbar, selector: "p-toolbar", inputs: ["style", "styleClass"] }, { kind: "directive", type: i3.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "component", type: PrgDynamicFormFieldComponent, selector: "prg-dynamic-form-field", inputs: ["field", "form"], outputs: ["onChange"] }, { kind: "component", type: PrgDynamicFormActionComponent, selector: "prg-dynamic-form-action", inputs: ["action", "form"], outputs: ["actionClick"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDynamicFormComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-dynamic-form', template: "\r\n<div class=\"dynamic-form\">\r\n  <p-tabMenu *ngIf=\"formGroupType==='tab'&&tabMenuItemsDynamicForm.length>0\" [model]=\"tabMenuItemsDynamicForm\" [activeItem]=\"activeTabMenuItemsDynamicForm\">\r\n\r\n  </p-tabMenu>\r\n\r\n\r\n  <form [formGroup]=\"form\">\r\n    <div class=\"form-row\" *ngIf=\"actions!=null&&actions.length>0\">\r\n      <p-toolbar >\r\n        <div class=\"p-toolbar-group-left\">\r\n          <ng-container *ngFor=\"let action of leftActions\">\r\n            <prg-dynamic-form-action\r\n              *ngIf=\"evalExpression(action.visibleExpression,true)\"\r\n              [action]=\"action\"\r\n              [form]=\"form\"\r\n              (actionClick)=\"onActionClicked($event)\"\r\n            >\r\n            </prg-dynamic-form-action>\r\n          </ng-container>\r\n        </div>\r\n        <div>\r\n          <ng-container *ngFor=\"let action of middleActions\">\r\n            <prg-dynamic-form-action\r\n              *ngIf=\"evalExpression(action.visibleExpression, true)\"\r\n              [action]=\"action\"\r\n              [form]=\"form\"\r\n              (actionClick)=\"onActionClicked($event)\"\r\n            >\r\n            </prg-dynamic-form-action>\r\n          </ng-container>\r\n        </div>\r\n        <div class=\"p-toolbar-group-right\">\r\n          <ng-container *ngFor=\"let action of rightActions\">\r\n            <prg-dynamic-form-action\r\n              *ngIf=\"evalExpression(action.visibleExpression, true)\"\r\n              [action]=\"action\"\r\n              [form]=\"form\"\r\n              (actionClick)=\"onActionClicked($event)\"\r\n            >\r\n            </prg-dynamic-form-action>\r\n          </ng-container>\r\n        </div>\r\n      </p-toolbar>\r\n    </div>\r\n    <ng-container *ngIf=\"viewMode !== 'add' && form != null\">\r\n      <div *ngFor=\"let field of fields\" class=\"form-row dynamic-form-fields\">\r\n\r\n        <prg-dynamic-form-field\r\n          *ngIf=\"evalExpression(field.visibleExpression, true,field.groupFieldsId)\"\r\n          [field]=\"field\"\r\n          [form]=\"form\"\r\n          (onChange)=\"onFieldChanged($event)\"\r\n        ></prg-dynamic-form-field>\r\n      </div>\r\n    </ng-container>\r\n  </form>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: ObjectsUtilityService }, { type: ArrayUtilityService }, { type: FormGroupService }, { type: UtilityService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ENTITY_TYPES_CONFIG]
                }] }]; }, propDecorators: { context: [{
                type: Input
            }], fields: [{
                type: Input,
                args: ['fields']
            }], actions: [{
                type: Input,
                args: ['actions']
            }], entity: [{
                type: Input,
                args: ['entity']
            }], viewMode: [{
                type: Input,
                args: ['viewMode']
            }], formGroupType: [{
                type: Input
            }], actionOutput: [{
                type: Output
            }], fieldChangeOutput: [{
                type: Output
            }] } });

class PrgCoreDynamicFormModule {
}
PrgCoreDynamicFormModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreDynamicFormModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
PrgCoreDynamicFormModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreDynamicFormModule, declarations: [PrgDynamicFormComponent,
        PrgDynamicFormFieldComponent,
        PrgDynamicFormActionComponent,
        PrgSetDateTimeConfigsDirective,
        PrgSetRadioButtonConfigsDirective,
        PrgSetSelectButtonConfigsDirective,
        PrgSetSliderConfigsDirective,
        PrgSetColorPickerConfigsDirective,
        PrgSetAutoCompleteConfigsDirective,
        PrgSetInputSwitchConfigsDirective,
        PrgSetKnobConfigsDirective,
        PrgSetCheckboxConfigsDirective,
        PrgSetInputNumberConfigsDirective,
        PrgSetTriStateCheckboxConfigsDirective,
        PrgSetCascadeSelectConfigsDirective,
        PrgSetRatingConfigsDirective,
        PrgSetInputMaskConfigsDirective,
        PrgSetSelectConfigsDirective,
        PrgSetInputPasswordConfigsDirective,
        PrgSetMultiselectConfigsDirective,
        PrgSetChipsConfigsDirective,
        PrgSetToggleButtonConfigsDirective,
        PrgSetListBoxConfigsDirective,
        PrgListBoxComponent,
        PrgInputNumberComponent,
        PrgSelectComponent,
        PrgToggleButtonComponent,
        PrgChipsComponent,
        PrgRatingComponent,
        PrgRadioButtonComponent,
        PrgAutoCompleteComponent,
        PrgInputSwitchComponent,
        PrgKnobComponent,
        PrgCascadeSelectComponent,
        PrgTriStateCheckboxComponent,
        PrgColorPickerComponent,
        PrgSliderComponent,
        PrgDateTimeComponent,
        PrgSelectButtonComponent,
        PrgInputMaskComponent,
        PrgInputTextComponent,
        PrgMultiSelectComponent,
        PrgPasswordComponent,
        PrgButtonComponent,
        PrgButtonConfigsDirective,
        PrgSplitButtonComponent,
        PrgSplitButtonConfigsDirective,
        PrgSpeedDialComponent,
        PrgSpeedDialConfigsDirective,
        PrgSelectButtonActionComponent,
        PrgSetSelectButtonActionConfigsDirective,
        PrgToggleButtonActionComponent,
        PrgSetToggleButtonActionConfigsDirective,
        PrgInputSwitchActionComponent,
        PrgSetInputSwitchActionConfigsDirective,
        PrgCheckboxComponent,
        PrgInputTextAreaComponent], imports: [PrgSharedComponentsModule,
        DynamicModule,
        DynamicDirectivesModule,
        HttpClientModule], exports: [PrgDynamicFormComponent,
        PrgInputTextComponent,
        PrgInputNumberComponent,
        PrgDynamicFormFieldComponent,
        PrgSelectComponent,
        PrgDateTimeComponent,
        PrgSetSelectConfigsDirective,
        PrgCheckboxComponent,
        PrgInputTextAreaComponent,
        PrgCascadeSelectComponent] });
PrgCoreDynamicFormModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreDynamicFormModule, imports: [PrgSharedComponentsModule,
        DynamicModule,
        DynamicDirectivesModule,
        HttpClientModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreDynamicFormModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        PrgDynamicFormComponent,
                        PrgDynamicFormFieldComponent,
                        PrgDynamicFormActionComponent,
                        PrgSetDateTimeConfigsDirective,
                        PrgSetRadioButtonConfigsDirective,
                        PrgSetSelectButtonConfigsDirective,
                        PrgSetSliderConfigsDirective,
                        PrgSetColorPickerConfigsDirective,
                        PrgSetAutoCompleteConfigsDirective,
                        PrgSetInputSwitchConfigsDirective,
                        PrgSetKnobConfigsDirective,
                        PrgSetCheckboxConfigsDirective,
                        PrgSetInputNumberConfigsDirective,
                        PrgSetTriStateCheckboxConfigsDirective,
                        PrgSetCascadeSelectConfigsDirective,
                        PrgSetRatingConfigsDirective,
                        PrgSetInputMaskConfigsDirective,
                        PrgSetSelectConfigsDirective,
                        PrgSetInputPasswordConfigsDirective,
                        PrgSetMultiselectConfigsDirective,
                        PrgSetChipsConfigsDirective,
                        PrgSetToggleButtonConfigsDirective,
                        PrgSetListBoxConfigsDirective,
                        PrgListBoxComponent,
                        PrgInputNumberComponent,
                        PrgSelectComponent,
                        PrgToggleButtonComponent,
                        PrgChipsComponent,
                        PrgRatingComponent,
                        PrgRadioButtonComponent,
                        PrgAutoCompleteComponent,
                        PrgInputSwitchComponent,
                        PrgKnobComponent,
                        PrgCascadeSelectComponent,
                        PrgTriStateCheckboxComponent,
                        PrgColorPickerComponent,
                        PrgSliderComponent,
                        PrgDateTimeComponent,
                        PrgSelectButtonComponent,
                        PrgInputMaskComponent,
                        PrgInputTextComponent,
                        PrgMultiSelectComponent,
                        PrgPasswordComponent,
                        PrgButtonComponent,
                        PrgButtonConfigsDirective,
                        PrgSplitButtonComponent,
                        PrgSplitButtonConfigsDirective,
                        PrgSpeedDialComponent,
                        PrgSpeedDialConfigsDirective,
                        PrgSelectButtonActionComponent,
                        PrgSetSelectButtonActionConfigsDirective,
                        PrgToggleButtonActionComponent,
                        PrgSetToggleButtonActionConfigsDirective,
                        PrgInputSwitchActionComponent,
                        PrgSetInputSwitchActionConfigsDirective,
                        PrgCheckboxComponent,
                        PrgInputTextAreaComponent,
                    ],
                    imports: [
                        PrgSharedComponentsModule,
                        DynamicModule,
                        DynamicDirectivesModule,
                        HttpClientModule,
                    ],
                    exports: [
                        PrgDynamicFormComponent,
                        PrgInputTextComponent,
                        PrgInputNumberComponent,
                        PrgDynamicFormFieldComponent,
                        PrgSelectComponent,
                        PrgDateTimeComponent,
                        PrgSetSelectConfigsDirective,
                        PrgCheckboxComponent,
                        PrgInputTextAreaComponent,
                        PrgCascadeSelectComponent,
                    ],
                }]
        }] });

var ToolbarSlot;
(function (ToolbarSlot) {
    ToolbarSlot["Left"] = "left";
    ToolbarSlot["Right"] = "right";
    ToolbarSlot["Center"] = "center";
})(ToolbarSlot || (ToolbarSlot = {}));

/**
 * Constant that defines the fields and actions for the dynamic form config items
 */
const CONFIG_ITEMS_DYNAMIC_FORM = {
    fields: [],
    actions: [
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Save,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='read'",
        }),
    ],
};

/**
 * Config items admin component
 */
class PrgConfigItemsAdminComponent {
    /**
     * Constructor
     * @param {AbstractConfigurationItemsService} configurationItemsService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {UtilityService} utilityService
     * @param {TranslateService} translateService
     * @param {ObjectsUtilityService} objectUtility
     */
    constructor(configurationItemsService, arrayUtilityService, utilityService, translateService, objectUtility) {
        this.configurationItemsService = configurationItemsService;
        this.arrayUtilityService = arrayUtilityService;
        this.utilityService = utilityService;
        this.translateService = translateService;
        this.objectUtility = objectUtility;
        /**
         * The view mode type of the form. Default is "read"
         * @type {ViewMode}
         */
        this.configItemsViewMode = ViewMode.Read;
        /**
         * A boolean property of the class to show/hide form. Default is false(hide)
         * @type {boolean}
         */
        this.initForm = false;
        /**
         * An object with the data to build form , keys and values
         * @type {any}
         */
        this.entityConfigItems = {};
        /**
         * The dynamic form fields to build dynamic form config items in template
         */
        this.configItemsDynamicFormFields = this.arrayUtilityService.clone(CONFIG_ITEMS_DYNAMIC_FORM.fields);
        /**
         * The dynamic form actions to build dynamic form config items in template
         */
        this.configItemsDynamicFormActions = this.arrayUtilityService.clone(CONFIG_ITEMS_DYNAMIC_FORM.actions);
        /**
         * A copy of entityConfigItems object
         * @type {any}
         * @private
         */
        this.entityConfigItemCopy = {};
        /**
         * The list of configuration items
         * @type {ConfigurationItem[]}
         */
        this.configItemsList = [];
        /**
         * The configuration items defaults selected on tree
         * @type {ConfigurationItem[]}
         */
        this.configItemsSelectedDefaults = [];
        /**
         * The configuration items selected on tree
         * @type {ConfigurationItem[]}
         */
        this.configItemsSelected = [];
    }
    /**
     * ngOnInit
     *
     * Get all configuration item
     * @returns {Promise<void>}
     */
    async ngOnInit() {
        //fetch all configuration items
        this.configItemsList =
            await this.configurationItemsService.getAllConfigurationItemsAsync();
        this.setTreeData();
    }
    /**
     * This function call rearrange all config item paths and build tree menu
     * @private
     */
    setTreeData() {
        //get only the path of all configuration items
        const configItemsPath = this.configItemsList.map((configItem) => configItem.path);
        //Build tree
        this.configItemsTree = this.arrayUtilityService.clone(this.utilityService.arrayOfPathsToTree(configItemsPath, ':'));
    }
    /**
     * This function is responsible toe execute actions whenever a node is selected on tree
     * @param {TreeNode} node
     */
    onSelectItem(node) {
        // Return View mode back to read
        this.configItemsViewMode = ViewMode.Read;
        // Set config items selected
        this.setConfigItemsSelected(node);
        //Dynamic Form Fields
        this.configItemsDynamicFormFields = this.arrayUtilityService.clone(this.getAndParseGuiSettingsItems());
        // Assign config item data to form - entities
        this.assignConfigItemDataToForm();
        // Title of Form
        this.setTitleForm();
        //Initiate Form
        this.initForm = true;
    }
    /**
     * This function is responsible to get the complete path of item selected and their default path if
     * they exist. Then it will get the data of config items selected
     * @param {TreeNode} node
     * @private
     */
    setConfigItemsSelected(node) {
        const pathConfigItem = PrgConfigItemsAdminComponent.getCompletePathOfItem(node);
        // Path of default config-items
        const pathConfigItemDefaults = pathConfigItem.substring(0, pathConfigItem.lastIndexOf(':')) +
            ':' +
            ConfigItemsPath.Defaults;
        // Config-items of the selectable node
        this.configItemsSelected = this.configItemsList.filter((configItem) => configItem.path === pathConfigItem);
        // Config-items Defaults of the selectable node
        this.configItemsSelectedDefaults = this.configItemsList.filter((configItem) => configItem.path === pathConfigItemDefaults);
    }
    /**
     * This function is responsible to get the complete path of the item in tree
     * @param {TreeNode} node
     * @returns {string}
     * @private
     */
    static getCompletePathOfItem(node) {
        // Find the complete path of the item
        const completePathItem = [];
        let flag = true;
        let parent = node?.parent;
        while (flag == true) {
            if (parent) {
                completePathItem.unshift(parent.label);
                parent = parent?.parent;
            }
            else {
                flag = false;
            }
        }
        completePathItem.push(node?.label);
        return completePathItem.join(':');
    }
    /**
     * This function it will set the title of the form
     * @private
     */
    setTitleForm() {
        // Title of Form
        if (this.entityConfigItems.path.includes(ConfigItemsPath.UserPreferences)) {
            this.titleForm = this.entityConfigItems.path
                .substring(0, this.entityConfigItems.path.lastIndexOf(':'))
                .replaceAll(':', '.')
                .toLowerCase();
        }
        else {
            this.titleForm = this.entityConfigItems?.path
                .replaceAll(':', '.')
                .toLowerCase();
        }
    }
    /**
     * This function will assign config items data to form
     * @private
     */
    assignConfigItemDataToForm() {
        // Assign config item data to form - entities
        const mapConfigItemsIntoEntity = [];
        this.configItemsSelected.map((configItems) => {
            mapConfigItemsIntoEntity[configItems.name] = configItems.value;
            mapConfigItemsIntoEntity['path'] = configItems.path;
        });
        if (this.configItemsSelectedDefaults != null &&
            this.configItemsSelectedDefaults.length > 0) {
            this.configItemsSelectedDefaults.map(async (configItems) => {
                if (!mapConfigItemsIntoEntity[configItems.name]) {
                    mapConfigItemsIntoEntity[configItems.name] = null;
                }
                let fieldGuiSettings = this.configItemsDynamicFormFields.find((value) => value.key === configItems.name);
                if (fieldGuiSettings.basePathTranslation.includes('lookup-tables')) {
                    fieldGuiSettings.placeholder =
                        this.translateService.instant(fieldGuiSettings.basePathTranslation +
                            '.' +
                            fieldGuiSettings.key +
                            '.items.' +
                            configItems.value +
                            '.name') + ' (default)';
                }
                else {
                    fieldGuiSettings.placeholder = configItems.value + ' (default)';
                }
            });
        }
        this.entityConfigItems = Object.assign({}, mapConfigItemsIntoEntity);
        this.entityConfigItemCopy = this.objectUtility.cloneObject(this.entityConfigItems);
    }
    /**
     * This function is responsible to get the gui settings of the item selected and parse it
     * @returns {any}
     * @private
     */
    getAndParseGuiSettingsItems() {
        //Gui Settings
        let guiSettings;
        if (this.configItemsSelectedDefaults == null ||
            this.configItemsSelectedDefaults.length == 0) {
            guiSettings = this.configItemsSelected.map((configItem) => {
                return this.utilityService.guiSettingToObject(configItem.guiSettings);
            });
        }
        else {
            guiSettings = this.configItemsSelectedDefaults.map((configItem) => {
                return this.utilityService.guiSettingToObject(configItem.guiSettings);
            });
            if (this.selectedNode.key.includes(ConfigItemsPath.Defaults)) {
                guiSettings.forEach((gui) => {
                    gui.validators = Validators.required;
                });
            }
        }
        return guiSettings;
    }
    /**
     * This function is responsible to handle actions from the dynamic config items form
     * @param {DynamicFormActionOutput} event
     * @returns {Promise<void>}
     */
    async onActionConfigItems(event) {
        switch (event.action) {
            case BaseActionKey.Save:
                await this.configItemsSave(event);
                break;
            case BaseActionKey.Cancel:
                this.configItemsViewMode = ViewMode.Read;
                this.entityConfigItems = this.objectUtility.cloneObject(this.entityConfigItemCopy);
                break;
            case BaseActionKey.Edit:
                this.configItemsViewMode = ViewMode.Edit;
                break;
            default:
                break;
        }
    }
    /**
     * This function is responsible to save a new config item or update an existing one
     * @param {DynamicFormActionOutput} event
     * @returns {Promise<void>}
     * @private
     */
    async configItemsSave(event) {
        this.configItemsViewMode = ViewMode.Read;
        try {
            this.initForm = false;
            await this.configurationItemsService.updateConfigurationItemsAsync(event.formEntity);
            this.configItemsList = this.arrayUtilityService.clone(this.configurationItemsService.getConfigurationItemsValue());
            this.setTreeData();
            if (this.selectedNode) {
                this.onSelectItem(this.selectedNode);
            }
            this.initForm = true;
        }
        catch (e) { }
    }
}
PrgConfigItemsAdminComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigItemsAdminComponent, deps: [{ token: AbstractConfigurationItemsService$1 }, { token: ArrayUtilityService }, { token: UtilityService }, { token: i5.TranslateService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgConfigItemsAdminComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgConfigItemsAdminComponent, selector: "prg-config-items-admin", ngImport: i0, template: "<div class=\"grid grid-nogutter\">\r\n  <div class=\"col-fixed grid-nogutter\">\r\n    <p-tree [(selection)]=\"selectedNode\"  [filter]=\"true\" filterPlaceholder=\"Search Item...\" selectionMode=\"single\"\r\n            (onNodeSelect)=\"onSelectItem($event.node)\" layout=\"vertical\" [value]=\"configItemsTree\"></p-tree>\r\n  </div>\r\n <div class=\"col grid-nogutter px-2 \" *ngIf=\"initForm\">\r\n   <p [ngClass]=\"['text-center' ,'bg-blue-50' ,'text-3xl' ,'border-round', 'mb-2', 'py-3', 'w-full', 'border-300', 'border-1' ,'shadow-1', 'mt-0' ,'text-700']\"  >{{titleForm + '.label'|translate|uppercase}}</p>\r\n\r\n   <prg-dynamic-form [viewMode]=\"configItemsViewMode\" [actions]=\"configItemsDynamicFormActions\"\r\n                     [fields]=\"configItemsDynamicFormFields\" [entity]=\"entityConfigItems\"\r\n                     (actionOutput)=\"onActionConfigItems($event)\">\r\n   </prg-dynamic-form>\r\n </div>\r\n</div>\r\n\r\n", styles: [":host ::ng-deep .p-dropdown .p-dropdown-label.p-placeholder{color:#08f}:host ::ng-deep p-inputnumber.p-inputnumber-clearable .p-inputnumber-input{width:260px}:host ::ng-deep p-inputnumber.p-inputnumber-clearable .p-inputnumber-input{padding-right:.75rem}:host ::ng-deep .p-inputnumber-buttons-stacked .p-inputnumber-input::placeholder{color:#08f!important;font-size:15px}\n"], dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7$3.Tree, selector: "p-tree", inputs: ["value", "selectionMode", "selection", "style", "styleClass", "contextMenu", "layout", "draggableScope", "droppableScope", "draggableNodes", "droppableNodes", "metaKeySelection", "propagateSelectionUp", "propagateSelectionDown", "loading", "loadingIcon", "emptyMessage", "ariaLabel", "togglerAriaLabel", "ariaLabelledBy", "validateDrop", "filter", "filterBy", "filterMode", "filterPlaceholder", "filteredNodes", "filterLocale", "scrollHeight", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "indentation", "_templateMap", "trackBy", "virtualNodeHeight"], outputs: ["selectionChange", "onNodeSelect", "onNodeUnselect", "onNodeExpand", "onNodeCollapse", "onNodeContextMenuSelect", "onNodeDrop", "onLazyLoad", "onScroll", "onScrollIndexChange", "onFilter"] }, { kind: "component", type: PrgDynamicFormComponent, selector: "prg-dynamic-form", inputs: ["context", "fields", "actions", "entity", "viewMode", "formGroupType"], outputs: ["actionOutput", "fieldChangeOutput"] }, { kind: "pipe", type: i1$2.UpperCasePipe, name: "uppercase" }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigItemsAdminComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-config-items-admin', template: "<div class=\"grid grid-nogutter\">\r\n  <div class=\"col-fixed grid-nogutter\">\r\n    <p-tree [(selection)]=\"selectedNode\"  [filter]=\"true\" filterPlaceholder=\"Search Item...\" selectionMode=\"single\"\r\n            (onNodeSelect)=\"onSelectItem($event.node)\" layout=\"vertical\" [value]=\"configItemsTree\"></p-tree>\r\n  </div>\r\n <div class=\"col grid-nogutter px-2 \" *ngIf=\"initForm\">\r\n   <p [ngClass]=\"['text-center' ,'bg-blue-50' ,'text-3xl' ,'border-round', 'mb-2', 'py-3', 'w-full', 'border-300', 'border-1' ,'shadow-1', 'mt-0' ,'text-700']\"  >{{titleForm + '.label'|translate|uppercase}}</p>\r\n\r\n   <prg-dynamic-form [viewMode]=\"configItemsViewMode\" [actions]=\"configItemsDynamicFormActions\"\r\n                     [fields]=\"configItemsDynamicFormFields\" [entity]=\"entityConfigItems\"\r\n                     (actionOutput)=\"onActionConfigItems($event)\">\r\n   </prg-dynamic-form>\r\n </div>\r\n</div>\r\n\r\n", styles: [":host ::ng-deep .p-dropdown .p-dropdown-label.p-placeholder{color:#08f}:host ::ng-deep p-inputnumber.p-inputnumber-clearable .p-inputnumber-input{width:260px}:host ::ng-deep p-inputnumber.p-inputnumber-clearable .p-inputnumber-input{padding-right:.75rem}:host ::ng-deep .p-inputnumber-buttons-stacked .p-inputnumber-input::placeholder{color:#08f!important;font-size:15px}\n"] }]
        }], ctorParameters: function () { return [{ type: AbstractConfigurationItemsService$1 }, { type: ArrayUtilityService }, { type: UtilityService }, { type: i5.TranslateService }, { type: ObjectsUtilityService }]; } });

/**
 * Config items user component
 */
class PrgConfigItemsUserComponent {
    /**
     * Constructor
     * @param {AbstractConfigurationItemsService} configurationItemsService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {UtilityService} utilityService
     * @param {TranslateService} translateService
     * @param {ObjectsUtilityService} objectUtility
     * @param {AbstractAuthService} authService
     */
    constructor(configurationItemsService, arrayUtilityService, utilityService, translateService, objectUtility, authService) {
        this.configurationItemsService = configurationItemsService;
        this.arrayUtilityService = arrayUtilityService;
        this.utilityService = utilityService;
        this.translateService = translateService;
        this.objectUtility = objectUtility;
        this.authService = authService;
        /**
         * The view mode type of the form. Default is "read"
         * @type {ViewMode}
         */
        this.configItemsViewMode = ViewMode.Read;
        /**
         * The complete path for the config item user-preferences defaults
         * @type {string}
         */
        this.configItemUserPreferencesDefaultsPath = 'Config-Items:User-Preferences:';
        /**
         * A boolean property of the class to show/hide form. Default is false(hide)
         * @type {boolean}
         */
        this.initForm = false;
        /**
         * An object with the data to build form , keys and values
         * @type {any}
         */
        this.entityConfigItems = {};
        /**
         * The dynamic form fields to build dynamic form config items in template
         */
        this.configItemsDynamicFormFields = this.arrayUtilityService.clone(CONFIG_ITEMS_DYNAMIC_FORM.fields);
        /**
         * The dynamic form actions to build dynamic form config items in template
         */
        this.configItemsDynamicFormActions = this.arrayUtilityService.clone(CONFIG_ITEMS_DYNAMIC_FORM.actions);
        /**
         * A copy of entityConfigItems object
         * @type {any}
         * @private
         */
        this.entityConfigItemCopy = {};
        /**
         * User and defaults config items
         * @type {any}
         */
        this.userAndDefaultsConfigsItems = {};
        /**
         * The configuration items defaults of user preferences
         * @type {ConfigurationItem[]}
         * @private
         */
        this.configItemsUserPreferencesDefaults = [];
        /**
         * The configuration items of user preferences of current user
         * @type {ConfigurationItem[]}
         * @private
         */
        this.configItemsUserPreferences = [];
    }
    /**
     * ngOnInit
     *
     * Get  configuration items User Preferences and settings to initiate the template
     * @returns {Promise<void>}
     */
    async ngOnInit() {
        this.userAndDefaultsConfigsItems =
            await this.configurationItemsService.getConfigurationItemsByPathAsync(this.configItemUserPreferencesDefaultsPath);
        this.configItemsUserPreferencesDefaults = this.objectUtility.cloneObject(this.userAndDefaultsConfigsItems.defaults);
        await this.getConfigItemsUserPreferencesByLoggedUser();
        this.configItemsDynamicFormFields = this.arrayUtilityService.clone(this.getAndParseGuiSettingsItems());
        this.assignConfigItemDataToForm();
        this.setTitleForm();
        //Initiate Form
        this.initForm = true;
    }
    /**
     * This function is responsible to get Config Items regarding user logged
     * @returns {Promise<void>}
     */
    async getConfigItemsUserPreferencesByLoggedUser() {
        this.loggedUser = this.objectUtility.cloneObject(this.authService.getLoggedUser());
        this.configItemUserPath =
            this.configItemUserPreferencesDefaultsPath + this.loggedUser?.email;
        this.configItemsUserPreferences = this.objectUtility.cloneObject(this.userAndDefaultsConfigsItems.user);
    }
    /**
     * This function is responsible to get the gui settings of config item and parse it
     * @returns {any}
     * @private
     */
    getAndParseGuiSettingsItems() {
        //Gui Settings
        let guiSettings;
        if (this.configItemsUserPreferencesDefaults != null &&
            this.configItemsUserPreferencesDefaults.length > 0) {
            guiSettings = this.configItemsUserPreferencesDefaults.map((configItem) => {
                return this.utilityService.guiSettingToObject(configItem.guiSettings);
            });
        }
        else {
            guiSettings = [];
        }
        return guiSettings;
    }
    /**
     * This function will assign config items data to form
     * @private
     */
    assignConfigItemDataToForm() {
        // Assign config item data to form - entities
        const mapConfigItemsIntoEntity = [];
        this.configItemsUserPreferences.map((configItems) => {
            mapConfigItemsIntoEntity[configItems.name] = configItems.value;
        });
        if (this.configItemsUserPreferencesDefaults != null &&
            this.configItemsUserPreferencesDefaults.length > 0) {
            this.configItemsUserPreferencesDefaults.map(async (configItems) => {
                if (!mapConfigItemsIntoEntity[configItems.name]) {
                    mapConfigItemsIntoEntity[configItems.name] = null;
                }
                let fieldGuiSettings = this.configItemsDynamicFormFields.find((value) => value.key === configItems.name);
                if (fieldGuiSettings.basePathTranslation.includes('lookup-tables')) {
                    fieldGuiSettings.placeholder =
                        this.translateService.instant(fieldGuiSettings.basePathTranslation +
                            '.' +
                            fieldGuiSettings.key +
                            '.items.' +
                            configItems.value +
                            '.name') + ' (default)';
                }
                else {
                    fieldGuiSettings.placeholder = configItems.value + ' (default)';
                }
            });
        }
        mapConfigItemsIntoEntity['path'] = this.configItemUserPath;
        this.entityConfigItems = Object.assign({}, mapConfigItemsIntoEntity);
        this.entityConfigItemCopy = this.objectUtility.cloneObject(this.entityConfigItems);
    }
    /**
     * This function will set the title of the form
     * @private
     */
    setTitleForm() {
        // Title of Form
        if (this.entityConfigItems.path) {
            this.titleForm = this.entityConfigItems.path
                .substring(0, this.entityConfigItems.path.lastIndexOf(':'))
                .replaceAll(':', '.')
                .toLowerCase();
        }
    }
    /**
     * This function is responsible to handle actions from the dynamic config items form
     * @param {DynamicFormActionOutput} event
     * @returns {Promise<void>}
     */
    async onActionConfigItems(event) {
        switch (event.action) {
            case BaseActionKey.Save:
                await this.configItemsSave(event);
                break;
            case BaseActionKey.Cancel:
                this.configItemsViewMode = ViewMode.Read;
                this.entityConfigItems = this.objectUtility.cloneObject(this.entityConfigItemCopy);
                break;
            case BaseActionKey.Edit:
                this.configItemsViewMode = ViewMode.Edit;
                break;
            default:
                break;
        }
    }
    /**
     * This function is responsible to save a new config item or update an existing one
     * @param {DynamicFormActionOutput} event
     * @returns {Promise<void>}
     * @private
     */
    async configItemsSave(event) {
        this.configItemsViewMode = ViewMode.Read;
        try {
            this.initForm = false;
            await this.configurationItemsService.updateConfigurationItemsAsync(event.formEntity);
            this.configItemsUserPreferences = this.arrayUtilityService.clone(this.configurationItemsService
                .getConfigurationItemsValue()
                .filter((configItem) => configItem.path === this.configItemUserPath));
            this.assignConfigItemDataToForm();
            this.initForm = true;
        }
        catch (e) { }
    }
}
PrgConfigItemsUserComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigItemsUserComponent, deps: [{ token: AbstractConfigurationItemsService$1 }, { token: ArrayUtilityService }, { token: UtilityService }, { token: i5.TranslateService }, { token: ObjectsUtilityService }, { token: AbstractAuthService }], target: i0.ɵɵFactoryTarget.Component });
PrgConfigItemsUserComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgConfigItemsUserComponent, selector: "prg-config-items-user", inputs: { configItemUserPreferencesDefaultsPath: "configItemUserPreferencesDefaultsPath" }, ngImport: i0, template: "<div class=\"col grid-nogutter px-2 \" *ngIf=\"initForm\">\r\n  <p [ngClass]=\"['text-center' ,'bg-blue-50' ,'text-3xl' ,'border-round', 'mb-2', 'py-3', 'w-full', 'border-300', 'border-1' ,'shadow-1', 'mt-0' ,'text-700']\"  >{{titleForm + '.label'|translate|uppercase}} {{\" : \"+loggedUser?.name|uppercase}}</p>\r\n  <prg-dynamic-form [viewMode]=\"configItemsViewMode\" [actions]=\"configItemsDynamicFormActions\"\r\n                    [fields]=\"configItemsDynamicFormFields\" [entity]=\"entityConfigItems\"\r\n                    (actionOutput)=\"onActionConfigItems($event)\">\r\n  </prg-dynamic-form>\r\n</div>\r\n", styles: [":host ::ng-deep .p-dropdown .p-dropdown-label.p-placeholder{color:#08f}:host ::ng-deep p-inputnumber.p-inputnumber-clearable .p-inputnumber-input{width:260px}:host ::ng-deep p-inputnumber.p-inputnumber-clearable .p-inputnumber-input{padding-right:.75rem}:host ::ng-deep .p-inputnumber-buttons-stacked .p-inputnumber-input::placeholder{color:#08f!important;font-size:15px}\n"], dependencies: [{ kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: PrgDynamicFormComponent, selector: "prg-dynamic-form", inputs: ["context", "fields", "actions", "entity", "viewMode", "formGroupType"], outputs: ["actionOutput", "fieldChangeOutput"] }, { kind: "pipe", type: i1$2.UpperCasePipe, name: "uppercase" }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigItemsUserComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-config-items-user', template: "<div class=\"col grid-nogutter px-2 \" *ngIf=\"initForm\">\r\n  <p [ngClass]=\"['text-center' ,'bg-blue-50' ,'text-3xl' ,'border-round', 'mb-2', 'py-3', 'w-full', 'border-300', 'border-1' ,'shadow-1', 'mt-0' ,'text-700']\"  >{{titleForm + '.label'|translate|uppercase}} {{\" : \"+loggedUser?.name|uppercase}}</p>\r\n  <prg-dynamic-form [viewMode]=\"configItemsViewMode\" [actions]=\"configItemsDynamicFormActions\"\r\n                    [fields]=\"configItemsDynamicFormFields\" [entity]=\"entityConfigItems\"\r\n                    (actionOutput)=\"onActionConfigItems($event)\">\r\n  </prg-dynamic-form>\r\n</div>\r\n", styles: [":host ::ng-deep .p-dropdown .p-dropdown-label.p-placeholder{color:#08f}:host ::ng-deep p-inputnumber.p-inputnumber-clearable .p-inputnumber-input{width:260px}:host ::ng-deep p-inputnumber.p-inputnumber-clearable .p-inputnumber-input{padding-right:.75rem}:host ::ng-deep .p-inputnumber-buttons-stacked .p-inputnumber-input::placeholder{color:#08f!important;font-size:15px}\n"] }]
        }], ctorParameters: function () { return [{ type: AbstractConfigurationItemsService$1 }, { type: ArrayUtilityService }, { type: UtilityService }, { type: i5.TranslateService }, { type: ObjectsUtilityService }, { type: AbstractAuthService }]; }, propDecorators: { configItemUserPreferencesDefaultsPath: [{
                type: Input
            }] } });

/**
 * Constant that defines the menu items for user menu
 */
const USER_MENU_HEADER = [
    {
        id: 'user-menu',
        items: [
            { separator: true },
            {
                icon: 'pi pi-user',
                id: 'my-account',
                visibleString: '!!this.user',
            },
            {
                icon: 'pi pi-sign-out',
                commandString: 'this.onClickLogout',
                id: 'logout',
                visibleString: '!!this.user',
            },
            {
                icon: 'pi pi-sign-in',
                visibleString: '!this.user',
                id: 'login',
                routerLinkString: "['/' + this.authConfig.authRoutingBasePath + '/' + this.authConfig.authRoutingLoginPath,]",
            },
        ],
    },
];
/**
 * Constant that defines the menu items for language menu on header
 */
const LANGUAGE_MENU_HEADER = [
    {
        id: 'language-menu',
        items: [
            { separator: true },
            {
                id: 'pt',
                commandString: '($event) => this.changeLanguage($event.item.id)',
            },
            {
                id: 'en',
                commandString: '($event) => this.changeLanguage($event.item.id)',
            },
        ],
    },
];

/**
 * Inject token
 */
const PRG_CONFIGURATION_ITEMS_CONFIG = new InjectionToken('PRG_CONFIGURATION_ITEMS_CONFIG');
/**
 * Injectable
 */
/**
 * PrgCoreConfigurationService class definition
 * <br />that specifies the properties that the
 * <br />application can send to the lib for
 * <br />configuration purposes
 */
class PrgAuthConfigurationService {
    /**
     * Constructor
     *
     * @param prgConfigurationItemsConfig
     */
    constructor(prgConfigurationItemsConfig) {
        this.prgConfigurationItemsConfig = prgConfigurationItemsConfig;
    }
}
PrgAuthConfigurationService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthConfigurationService, deps: [{ token: PRG_CONFIGURATION_ITEMS_CONFIG }], target: i0.ɵɵFactoryTarget.Injectable });
PrgAuthConfigurationService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthConfigurationService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgAuthConfigurationService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_CONFIGURATION_ITEMS_CONFIG]
                }] }]; } });

/**
 * Inject token
 */
const PRG_DASHBOARD_CONFIG = new InjectionToken('PRG_DASHBOARD_CONFIG');
/**
 * Injectable
 */
/**
 * PrgCoreConfigurationService class definition
 * <br />that specifies the properties that the
 * <br />application can send to the lib for
 * <br />configuration purposes
 */
class PrgDashboardConfigurationService {
    /**
     * Constructor
     * @param {PrgDashboardConfig} prgDashboardConfig
     */
    constructor(prgDashboardConfig) {
        this.prgDashboardConfig = prgDashboardConfig;
    }
}
PrgDashboardConfigurationService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardConfigurationService, deps: [{ token: PRG_DASHBOARD_CONFIG }], target: i0.ɵɵFactoryTarget.Injectable });
PrgDashboardConfigurationService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardConfigurationService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardConfigurationService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_DASHBOARD_CONFIG]
                }] }]; } });

/**
 * Inject token
 */
const PRG_LOOKUP_TABLE_CONFIG = new InjectionToken('PRG_LOOKUP_TABLE_CONFIG');
/**
 * Injectable
 */
class PrgLookupTableConfigurationService {
    /**
     * constructor
     * @param prgLookupTableConfig
     */
    constructor(prgLookupTableConfig) {
        this.prgLookupTableConfig = prgLookupTableConfig;
    }
}
PrgLookupTableConfigurationService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableConfigurationService, deps: [{ token: PRG_LOOKUP_TABLE_CONFIG }], target: i0.ɵɵFactoryTarget.Injectable });
PrgLookupTableConfigurationService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableConfigurationService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableConfigurationService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_LOOKUP_TABLE_CONFIG]
                }] }]; } });

/**
 * Inject token
 */
const PRG_QUERIES_CONFIG = new InjectionToken('PRG_QUERIES_CONFIG');
/**
 * Injectable
 */
/**
 * PrgCoreConfigurationService class definition
 * <br />that specifies the properties that the
 * <br />application can send to the lib for
 * <br />configuration purposes
 */
class PrgQueriesConfigurationService {
    /**
     * Constructor
     *
     * @param prgQueriesConfig
     */
    constructor(prgQueriesConfig) {
        this.prgQueriesConfig = prgQueriesConfig;
    }
}
PrgQueriesConfigurationService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesConfigurationService, deps: [{ token: PRG_QUERIES_CONFIG }], target: i0.ɵɵFactoryTarget.Injectable });
PrgQueriesConfigurationService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesConfigurationService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesConfigurationService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_QUERIES_CONFIG]
                }] }]; } });

/**
 * Inject token
 */
const PRG_ROLES_SCOPES_CONFIG = new InjectionToken("PRG_ROLES_SCOPES_CONFIG");
/**
 * Injectable
 */
/**
 * PrgRolesScopesConfigurationService class definition
 * <br />that specifies the properties that the
 * <br />application can send to the lib for
 * <br />configuration purposes
 */
class PrgRolesScopesConfigurationService {
    /**
     * Constructor
     *
     * @param prgRolesScopesConfig
     */
    constructor(prgRolesScopesConfig) {
        this.prgRolesScopesConfig = prgRolesScopesConfig;
    }
}
PrgRolesScopesConfigurationService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRolesScopesConfigurationService, deps: [{ token: PRG_ROLES_SCOPES_CONFIG }], target: i0.ɵɵFactoryTarget.Injectable });
PrgRolesScopesConfigurationService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRolesScopesConfigurationService, providedIn: "root" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRolesScopesConfigurationService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: "root",
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ROLES_SCOPES_CONFIG]
                }] }]; } });

/**
 * Inject token
 */
const PRG_TERMS_CONFIG = new InjectionToken("PRG_TERMS_CONFIG");
/**
 * Injectable
 */
/**
 * PrgCoreConfigurationService class definition
 * <br />that specifies the properties that the
 * <br />application can send to the lib for
 * <br />configuration purposes
 */
class PrgTermsConfigurationService {
    /**
     * Constructor
     *
     * @param prgTermsConfig
     */
    constructor(prgTermsConfig) {
        this.prgTermsConfig = prgTermsConfig;
    }
}
PrgTermsConfigurationService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTermsConfigurationService, deps: [{ token: PRG_TERMS_CONFIG }], target: i0.ɵɵFactoryTarget.Injectable });
PrgTermsConfigurationService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTermsConfigurationService, providedIn: "root" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTermsConfigurationService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: "root",
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_TERMS_CONFIG]
                }] }]; } });

/**
 * Injectable
 */
/**
 * Main Layout Service
 */
class MainLayoutService {
    /**
     * constructor
     * @param {PrgAuthConfig} authConfig
     * @param {PrgEntityTypesConfig} entityTypesConfig
     * @param {PrgLookupTableConfig} lookupTableConfig
     * @param {PrgQueriesConfig} queriesConfig
     * @param {PrgRolesScopesConfig} rolesScopesConfig
     * @param {PrgTermsConfig} termsConfig
     * @param {PrgDashboardConfig} dashboardConfig
     * @param {PrgConfigurationItemsConfig} configItemsConfig
     * @param {ArrayUtilityService} arrayUtility
     * @param {TranslateService} translateService
     * @param {UtilityService} utilityService
     */
    constructor(authConfig, entityTypesConfig, lookupTableConfig, queriesConfig, rolesScopesConfig, termsConfig, configItemsConfig, dashboardConfig, arrayUtility, translateService, utilityService) {
        this.authConfig = authConfig;
        this.entityTypesConfig = entityTypesConfig;
        this.lookupTableConfig = lookupTableConfig;
        this.queriesConfig = queriesConfig;
        this.rolesScopesConfig = rolesScopesConfig;
        this.termsConfig = termsConfig;
        this.configItemsConfig = configItemsConfig;
        this.dashboardConfig = dashboardConfig;
        this.arrayUtility = arrayUtility;
        this.translateService = translateService;
        this.utilityService = utilityService;
        /**
         * Current state of SideBar
         */
        this.sideBarSubject = new BehaviorSubject(null);
        /**
         * Show/hide header subject
         * @type {BehaviorSubject<boolean>}
         * @private
         */
        this.displayHeaderSubject = new BehaviorSubject(true);
    }
    /**
     * Setter for sideBarSubject
     * @param value
     */
    setSideBarState(value) {
        this.sideBarSubject.next(value);
    }
    /**
     * Getter for sideBarSubject
     *
     * @returns The sideBarSubject as an observable
     */
    getSideBarStateObservable() {
        return this.sideBarSubject.asObservable();
    }
    /**
     * Getter for sideBarSubject
     *
     * @returns The sideBarSubject current value
     */
    getSideBarStateValue() {
        return this.sideBarSubject.getValue();
    }
    /**
     * Setter for displayHeaderSubject
     * @param value
     */
    setDisplayHeaderState(value) {
        this.displayHeaderSubject.next(value);
    }
    /**
     * Getter for displayHeaderSubject
     *
     * @returns The sideBarSubject as an observable
     */
    getDisplayHeaderStateObservable() {
        return this.displayHeaderSubject.asObservable();
    }
    /**
     * Getter for displayHeaderSubject
     *
     * @returns The sideBarSubject current value
     */
    getDisplayHeaderStateValue() {
        return this.displayHeaderSubject.getValue();
    }
    /**
  
    /**
     * Function responsible to complete sidebar menu with labels of selected language
     * @param {PrgMenuItem[]} mainMenu
     * @param {boolean} mainMenuExpanded
     * @returns {Promise<MenuItem[]>}
     */
    async getSideBarMenuItemsWithLabelsAsync(mainMenu, mainMenuExpanded) {
        let sideBarMenuItems = this.arrayUtility.clone(mainMenu);
        sideBarMenuItems.map(async (item) => {
            if (item.id) {
                if (mainMenuExpanded) {
                    item.label = await this.translateService
                        .get('components.sidebar.' + item.id + '.label')
                        .toPromise();
                }
                else {
                    if (!item.items) {
                        item.tooltipOptions = {
                            tooltipLabel: await this.translateService
                                .get('components.sidebar.' + item.id + '.label')
                                .toPromise(),
                        };
                    }
                }
            }
            if (item.items) {
                if (!mainMenuExpanded) {
                    item.items.unshift({
                        separator: true,
                    });
                    item.items.unshift({
                        label: await this.translateService
                            .get('components.sidebar.' + item.id + '.label')
                            .toPromise(),
                        style: {
                            'pointer-events': 'none',
                            'font-weight': 'bold',
                        },
                    });
                }
                item.items.map(async (itemChildren) => {
                    if (itemChildren.id) {
                        itemChildren.label = await this.translateService
                            .get('components.sidebar.' +
                            item.id +
                            '.' +
                            itemChildren.id +
                            '.label')
                            .toPromise();
                    }
                });
            }
        });
        return Promise.all(sideBarMenuItems);
    }
    /**
     * Function responsible to complete header menus (user and language) with labels of selected language
     * @param {PrgMenuItem[]} menuItem
     * @returns {Promise<PrgMenuItem[]>}
     */
    async getHeaderMenuItemsWithLabelsAsync(menuItem) {
        let menuItemWithLabels = this.arrayUtility.clone(menuItem);
        if (menuItem[0].id) {
            menuItemWithLabels[0].label = await this.translateService
                .get('components.header.' + menuItem[0].id + '.label')
                .toPromise();
        }
        menuItem[0].items.map(async (item, index) => {
            if (item.id) {
                menuItemWithLabels[0].items[index].label = await this.translateService
                    .get('components.header.' + menuItem[0].id + '.' + item.id + '.label')
                    .toPromise();
            }
        });
        return Promise.all(menuItemWithLabels);
    }
    /**
     * Function responsible to handle auxiliary string properties of menu type PrgMenuItem
     * @param {PrgMenuItem[]} menuItems
     * @param context
     * @returns {PrgMenuItem[]}
     */
    mapMenuItemsHelpers(menuItems, context) {
        let menuItemsWithHelpersMapped = this.arrayUtility.clone(menuItems);
        menuItemsWithHelpersMapped.map((items, mainIndex) => {
            if (items.commandString) {
                items.command = this.utilityService.evalFunction(items.commandString, context);
            }
            if (items.visibleString) {
                items.visible = this.utilityService.evalFunction(items.visibleString, context);
            }
            if (items.routerLinkString) {
                items.routerLink = this.utilityService.evalFunction(items.routerLinkString, this);
            }
            if (menuItemsWithHelpersMapped[mainIndex].items) {
                menuItemsWithHelpersMapped[mainIndex].items.forEach((subItems) => {
                    if (subItems.commandString) {
                        subItems.command = this.utilityService.evalFunction(subItems.commandString, context);
                    }
                    if (subItems.visibleString) {
                        subItems.visible = this.utilityService.evalFunction(subItems.visibleString, context);
                    }
                    if (subItems.routerLinkString) {
                        subItems.routerLink = this.utilityService.evalFunction(subItems.routerLinkString, this);
                    }
                });
            }
        });
        return menuItemsWithHelpersMapped;
    }
}
MainLayoutService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MainLayoutService, deps: [{ token: PRG_AUTH_CONFIG }, { token: PRG_ENTITY_TYPES_CONFIG }, { token: PRG_LOOKUP_TABLE_CONFIG }, { token: PRG_QUERIES_CONFIG }, { token: PRG_ROLES_SCOPES_CONFIG }, { token: PRG_TERMS_CONFIG }, { token: PRG_CONFIGURATION_ITEMS_CONFIG }, { token: PRG_DASHBOARD_CONFIG }, { token: ArrayUtilityService }, { token: i5.TranslateService }, { token: UtilityService }], target: i0.ɵɵFactoryTarget.Injectable });
MainLayoutService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MainLayoutService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MainLayoutService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_AUTH_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ENTITY_TYPES_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_LOOKUP_TABLE_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_QUERIES_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ROLES_SCOPES_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_TERMS_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_CONFIGURATION_ITEMS_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_DASHBOARD_CONFIG]
                }] }, { type: ArrayUtilityService }, { type: i5.TranslateService }, { type: UtilityService }]; } });

//TODO: It's missing a way to save user and language preferences (Session / Locale Storage)
/**
 * Header Component
 */
class PrgHeaderComponent {
    /**
     * Constructor
     * @param {AbstractAuthService} authService
     * @param {ObjectsUtilityService} objectUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {TranslateService} translateService
     * @param {MainLayoutService} mainLayoutService
     */
    constructor(authService, objectUtilityService, arrayUtilityService, translateService, mainLayoutService) {
        this.authService = authService;
        this.objectUtilityService = objectUtilityService;
        this.arrayUtilityService = arrayUtilityService;
        this.translateService = translateService;
        this.mainLayoutService = mainLayoutService;
        /**
         * Property of the class with type string which bind to menu logo.
         */
        this.imagePathLogo = '/assets/images/pragma_h.png';
        /**
         * Property of the class with type string which bind to user default image
         */
        this.imagePathUserDefault = '/assets/images/Profile_image.jpg';
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         * @type {Subscription[]}
         * @private
         */
        this.subscription = [];
        /**
         * A class property that defines if header is display
         * @type {boolean}
         */
        this.displayHeader = true;
        /**
         * Menu Items data of user menu
         * @type {PrgMenuItem[]}
         */
        this.menuItemsUser = this.arrayUtilityService.clone(USER_MENU_HEADER);
        /**
         * Menu Items data of language menu
         * @type {PrgMenuItem[]}
         */
        this.menuItemsLanguage = this.arrayUtilityService.clone(LANGUAGE_MENU_HEADER);
        /**
         * This method is responsible for calling the function that will log out user
         * @returns {Promise<void>}
         */
        this.onClickLogout = async () => {
            if (await this.authService.logoutAsync()) {
                //TODO Redirect after logout success. Route?
            }
        };
    }
    /**
     * ngOnInit
     *
     * @returns {Promise<void>}
     */
    async ngOnInit() {
        this.subscription.push(this.authService.getLoggedUserObservable().subscribe((user) => {
            this.user = this.objectUtilityService.cloneObject(user);
            if (this.user && this.user.token !== null) {
                this.imagePathUser = this.user.token.imageUrl;
            }
            else {
                this.imagePathUser = null;
            }
            this.initMenuUser();
        }));
        this.subscription.push(this.mainLayoutService
            .getDisplayHeaderStateObservable()
            .subscribe((display) => {
            this.displayHeader = display;
        }));
        await this.initMenuLanguage();
    }
    /**
     * Function responsible to reload menu data when user change language
     * @param {string} lang
     * @returns {Promise<void>}
     */
    async changeLanguage(lang) {
        this.translateService.use(lang);
        await this.initMenuLanguage();
        await this.initMenuUser();
    }
    /**
     * ngOnDestroy
     *
     * Unsubscribe the user logged observable
     */
    ngOnDestroy() {
        this.subscription.forEach((subscription) => {
            subscription.unsubscribe();
        });
        this.subscription = [];
    }
    /**
     * This method is responsible for calling the functions that will build the language menu
     * @returns {Promise<void>}
     */
    async initMenuLanguage() {
        this.menuItemsLanguage = this.arrayUtilityService.clone(this.mainLayoutService.mapMenuItemsHelpers(this.menuItemsLanguage, this));
        this.menuItemsLanguage = this.arrayUtilityService.clone(await this.mainLayoutService.getHeaderMenuItemsWithLabelsAsync(this.menuItemsLanguage));
    }
    /**
     * This method is responsible for calling the functions that will build the user menu
     * @returns {Promise<void>}
     */
    async initMenuUser() {
        this.menuItemsUser = this.arrayUtilityService.clone(this.mainLayoutService.mapMenuItemsHelpers(this.menuItemsUser, this));
        this.menuItemsUser = this.arrayUtilityService.clone(await this.mainLayoutService.getHeaderMenuItemsWithLabelsAsync(this.menuItemsUser));
    }
}
PrgHeaderComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgHeaderComponent, deps: [{ token: AbstractAuthService }, { token: ObjectsUtilityService }, { token: ArrayUtilityService }, { token: i5.TranslateService }, { token: MainLayoutService }], target: i0.ɵɵFactoryTarget.Component });
PrgHeaderComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgHeaderComponent, selector: "prg-header", inputs: { imagePathLogo: "imagePathLogo", imagePathUserDefault: "imagePathUserDefault", menuItemsUser: "menuItemsUser", menuItemsLanguage: "menuItemsLanguage" }, ngImport: i0, template: "<header class=\"shadow-5 \"  >\r\n  <div class=\"grid grid-nogutter p-1\" style=\"height: 70px\" *ngIf=\"displayHeader\">\r\n    <div class=\"col-2 flex justify-content-center \">\r\n      <img [src]=\"imagePathLogo\"  style=\"width: 80%;height: 90%\">\r\n    </div>\r\n    <div class=\"col flex align-items-center justify-content-end pr-6\">\r\n      <p-chip pTooltip=\"{{'components.header.user-menu.label'|translate}}\" tooltipPosition=\"top\" class=\"cursor-pointer px-3\" (click)=\"menuUser.toggle($event)\"\r\n              label=\"{{user?user.name:('components.header.user-menu.anonymous-user'|translate)}}\" image=\"{{imagePathUser?imagePathUser:imagePathUserDefault}}\"\r\n              styleClass=\"mr-2\"></p-chip>\r\n      <p-menu [showTransitionOptions]=\"'0.3s'\" [hideTransitionOptions]=\"'0.3s'\" #menuUser [popup]=\"true\"\r\n              [model]=\"menuItemsUser\"></p-menu>\r\n      <button pTooltip=\"{{'components.header.language-menu.label'|translate}}\" tooltipPosition=\"top\" (click)=\"menuLanguage.toggle($event)\"\r\n              pButton pRipple type=\"button\" icon=\"bi bi-globe text-2xl\"\r\n              class=\"px-3 p-button-rounded p-button-text p-button-plain \"></button>\r\n      <p-menu [showTransitionOptions]=\"'0.3s'\" [hideTransitionOptions]=\"'0.3s'\" #menuLanguage [popup]=\"true\"\r\n              [model]=\"menuItemsLanguage\"></p-menu>\r\n    </div>\r\n  </div>\r\n</header>\r\n", styles: [":host ::ng-deep .p-menu{width:max-content}\n"], dependencies: [{ kind: "component", type: i6$3.Menu, selector: "p-menu", inputs: ["model", "popup", "style", "styleClass", "appendTo", "autoZIndex", "baseZIndex", "showTransitionOptions", "hideTransitionOptions"], outputs: ["onShow", "onHide"] }, { kind: "directive", type: i7$4.Tooltip, selector: "[pTooltip]", inputs: ["tooltipPosition", "tooltipEvent", "appendTo", "positionStyle", "tooltipStyleClass", "tooltipZIndex", "escape", "showDelay", "hideDelay", "life", "positionTop", "positionLeft", "fitContent", "pTooltip", "tooltipDisabled", "tooltipOptions"] }, { kind: "component", type: i8$1.Chip, selector: "p-chip", inputs: ["label", "icon", "image", "style", "styleClass", "removable", "removeIcon"], outputs: ["onRemove", "onImageError"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "directive", type: i11.Ripple, selector: "[pRipple]" }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgHeaderComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-header', template: "<header class=\"shadow-5 \"  >\r\n  <div class=\"grid grid-nogutter p-1\" style=\"height: 70px\" *ngIf=\"displayHeader\">\r\n    <div class=\"col-2 flex justify-content-center \">\r\n      <img [src]=\"imagePathLogo\"  style=\"width: 80%;height: 90%\">\r\n    </div>\r\n    <div class=\"col flex align-items-center justify-content-end pr-6\">\r\n      <p-chip pTooltip=\"{{'components.header.user-menu.label'|translate}}\" tooltipPosition=\"top\" class=\"cursor-pointer px-3\" (click)=\"menuUser.toggle($event)\"\r\n              label=\"{{user?user.name:('components.header.user-menu.anonymous-user'|translate)}}\" image=\"{{imagePathUser?imagePathUser:imagePathUserDefault}}\"\r\n              styleClass=\"mr-2\"></p-chip>\r\n      <p-menu [showTransitionOptions]=\"'0.3s'\" [hideTransitionOptions]=\"'0.3s'\" #menuUser [popup]=\"true\"\r\n              [model]=\"menuItemsUser\"></p-menu>\r\n      <button pTooltip=\"{{'components.header.language-menu.label'|translate}}\" tooltipPosition=\"top\" (click)=\"menuLanguage.toggle($event)\"\r\n              pButton pRipple type=\"button\" icon=\"bi bi-globe text-2xl\"\r\n              class=\"px-3 p-button-rounded p-button-text p-button-plain \"></button>\r\n      <p-menu [showTransitionOptions]=\"'0.3s'\" [hideTransitionOptions]=\"'0.3s'\" #menuLanguage [popup]=\"true\"\r\n              [model]=\"menuItemsLanguage\"></p-menu>\r\n    </div>\r\n  </div>\r\n</header>\r\n", styles: [":host ::ng-deep .p-menu{width:max-content}\n"] }]
        }], ctorParameters: function () { return [{ type: AbstractAuthService }, { type: ObjectsUtilityService }, { type: ArrayUtilityService }, { type: i5.TranslateService }, { type: MainLayoutService }]; }, propDecorators: { imagePathLogo: [{
                type: Input
            }], imagePathUserDefault: [{
                type: Input
            }], menuItemsUser: [{
                type: Input
            }], menuItemsLanguage: [{
                type: Input
            }] } });

/**
 * Constant that defines the menu items for main menu
 */
const SIDEBAR_MENU = [
    {
        id: 'home',
        icon: 'pi pi-home',
        routerLink: [''],
        routerLinkActiveOptions: { exact: true },
    },
    {
        id: 'auth',
        icon: 'pi pi-user',
        items: [
            {
                icon: 'pi pi-sign-in',
                id: 'login',
                routerLinkString: "['/' + this.authConfig.authRoutingBasePath + '/' + this.authConfig.authRoutingLoginPath]",
                routerLinkActiveOptions: { exact: true },
                visibleString: '!this.user',
            },
            {
                icon: 'pi pi-book',
                id: 'signup',
                routerLinkString: "['/' + this.authConfig.authRoutingBasePath + '/' + this.authConfig.authRoutingSignupPath]",
                routerLinkActiveOptions: { exact: true },
                visibleString: '!this.user',
            },
            {
                icon: 'pi pi-key',
                id: 'request-pass',
                routerLinkString: "['/' + this.authConfig.authRoutingBasePath + '/' + this.authConfig.authRoutingRequestPasswordPath]",
                routerLinkActiveOptions: { exact: true },
            },
            {
                icon: 'pi pi-key',
                id: 'reset-pass',
                routerLinkString: "['/' + this.authConfig.authRoutingBasePath + '/' + this.authConfig.authRoutingResetPasswordPath]",
                routerLinkActiveOptions: { exact: true },
            },
        ],
    },
    {
        id: 'entity-types',
        icon: 'pi pi-database',
        routerLinkString: "['/' + this.entityTypesConfig.entityTypeBasePath]",
        routerLinkActiveOptions: { exact: true },
    },
    {
        id: 'lookup-table',
        icon: 'pi pi-map',
        routerLinkString: "['/' + this.lookupTableConfig.lookupTableBasePath]",
        routerLinkActiveOptions: { exact: true },
    },
    {
        id: 'queries',
        icon: 'pi pi-filter',
        routerLinkString: "['/' + this.queriesConfig.queriesRoutingPath]",
        routerLinkActiveOptions: { exact: true },
    },
    {
        id: 'roles-scopes',
        icon: 'pi pi-user-edit',
        routerLinkString: "['/' + this.rolesScopesConfig.rolesScopesBasePath]",
        routerLinkActiveOptions: { exact: true },
    },
    {
        id: 'terms',
        icon: 'pi pi-book',
        routerLinkString: "['/' + this.termsConfig.termsOfUseRoutingPath]",
        routerLinkActiveOptions: { exact: true },
    },
    {
        id: 'config-items',
        icon: 'pi pi-cog',
        items: [
            {
                icon: 'pi pi-user-edit',
                id: 'admin',
                routerLinkString: "['/' + this.configItemsConfig.configurationItemsRoutingBasePath + '/' + this.configItemsConfig.configurationItemsRoutingAdminPath]",
                routerLinkActiveOptions: { exact: true },
            },
            {
                icon: 'pi pi-user',
                id: 'user',
                routerLinkString: "['/' + this.configItemsConfig.configurationItemsRoutingBasePath + '/' + this.configItemsConfig.configurationItemsRoutingUserPath]",
                routerLinkActiveOptions: { exact: true },
            },
        ],
    },
    {
        id: 'dashboard',
        icon: 'pi pi-chart-bar',
        items: [
            {
                icon: 'pi pi-plus-circle',
                id: 'create',
                routerLinkString: "['/' + this.dashboardConfig.dashboardRoutingBasePath + '/' + this.dashboardConfig.dashboardCreateRoutingPath]",
                routerLinkActiveOptions: { exact: true },
            },
            {
                icon: 'pi pi-list',
                id: 'list',
                routerLinkString: "['/' + this.dashboardConfig.dashboardRoutingBasePath + '/' + this.dashboardConfig.dashboardListRoutingPath]",
                routerLinkActiveOptions: { exact: true },
            },
            {
                icon: 'pi pi-eye',
                id: 'display',
                routerLinkString: "['/' + this.dashboardConfig.dashboardRoutingBasePath + '/' + this.dashboardConfig.dashboardDisplayRoutingPath]",
                routerLinkActiveOptions: { exact: true },
            },
        ],
    },
];

//TODO: It's missing a way to save user and language preferences (Session / Locale Storage)
/**
 * Component decorator
 */
/**
 * Sidebar Component
 */
class PrgSidebarComponent {
    /**
     * Constructor
     * @param {MainLayoutService} mainLayoutService mainLayoutService
     * @param {ArrayUtilityService} arrayUtility
     * @param {TranslateService} translateService
     * @param {AuthService} authService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(mainLayoutService, arrayUtility, translateService, authService, objectsUtilityService) {
        this.mainLayoutService = mainLayoutService;
        this.arrayUtility = arrayUtility;
        this.translateService = translateService;
        this.authService = authService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * The current state of sidebar menu. Expanded is true and collapsed is false.
         *
         * Default is false.
         * @type {boolean}
         */
        this.mainMenuExpanded = false;
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         * @type {Subscription}
         * @private
         */
        this.subscription = [];
        /**
         * The original Menu data
         * @type {PrgMenuItem[]}
         * @private
         */
        this.mainMenuOriginal = this.arrayUtility.clone(SIDEBAR_MENU);
        /**
         * Defines if header is displayed or not.
         * @type {boolean}
         */
        this.headerDisplay = true;
    }
    /**
     * ngOnInit
     *
     * This method is responsible for:
     *
     * Get the saved state of sidebar in local storage.
     *
     * Verify if are any changes on language selected through on observable
     *
     * @returns {Promise<void>}
     */
    async ngOnInit() {
        let savedStateSideBar = JSON.parse(localStorage.getItem('savedStateSideBar'));
        if (savedStateSideBar) {
            this.mainMenuExpanded = savedStateSideBar;
        }
        this.subscription.push(this.authService.getLoggedUserObservable().subscribe(async (user) => {
            if (user) {
                this.user = this.objectsUtilityService.cloneObject(user);
            }
            else {
                this.user = null;
            }
            await this.getMainMenuItems();
        }));
        await this.getMainMenuItems();
        this.subscription.push(this.translateService.onLangChange.subscribe(async () => {
            await this.getMainMenuItems();
        }));
        this.subscription.push(this.mainLayoutService
            .getDisplayHeaderStateObservable()
            .subscribe((display) => {
            this.headerDisplay = display;
        }));
    }
    /**
     * This method is responsible for calling the functions that will build the menus, one with labels and icons and other with only icons
     * @returns {Promise<void>}
     * @private
     */
    async getMainMenuItems() {
        this.mainMenu = this.arrayUtility.clone(this.mainLayoutService.mapMenuItemsHelpers(this.mainMenuOriginal, this));
        this.mainMenu = this.arrayUtility.clone(await this.mainLayoutService.getSideBarMenuItemsWithLabelsAsync(this.mainMenu, true));
        this.mainMenuIcons = this.arrayUtility.clone(this.mainLayoutService.mapMenuItemsHelpers(this.mainMenuOriginal, this));
        this.mainMenuIcons = this.arrayUtility.clone(await this.mainLayoutService.getSideBarMenuItemsWithLabelsAsync(this.mainMenuIcons, false));
    }
    /**
     * ngOnDestroy
     *
     * Unsubscribe all the observables
     */
    ngOnDestroy() {
        this.subscription.forEach((subscription) => {
            subscription.unsubscribe();
        });
    }
    /**
     * This function is responsible to save the current state of the sidebar menu (expanded - true or collapsed - false) in local storage
     * @returns {Promise<void>}
     */
    async onShowHideSideBarDetails() {
        localStorage.removeItem('savedStateSideBar');
        this.mainMenuExpanded = !this.mainMenuExpanded;
        localStorage.setItem('savedStateSideBar', JSON.stringify(this.mainMenuExpanded));
        this.mainLayoutService.setSideBarState(this.mainMenuExpanded);
    }
}
PrgSidebarComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSidebarComponent, deps: [{ token: MainLayoutService }, { token: ArrayUtilityService }, { token: i5.TranslateService }, { token: AbstractAuthService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgSidebarComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSidebarComponent, selector: "prg-sidebar", inputs: { mainMenuOriginal: "mainMenuOriginal" }, ngImport: i0, template: "<div class=\"grid-nogutter max-w-max shadow-5\" [ngClass]=\"headerDisplay?'sidebar':'sidebar-no-header'\" >\r\n  <aside class=\"shadow-5 \" >\r\n    <div  class=\"flex flex-column \"\r\n          [@OnExpandSideBar]=\"mainMenuExpanded?'open':'closed'\" [ngClass]=\"headerDisplay?'sidebar':'sidebar-no-header'\">\r\n      <div class=\"pt-2\" *ngIf=\"!mainMenuExpanded\">\r\n        <p-tieredMenu  [styleClass]=\"'collapseSideBar'\"   [autoDisplay]=\"true\" [model]=\"mainMenuIcons\" ></p-tieredMenu>\r\n      </div>\r\n      <section  [@OnExpandSideBarText]=\"mainMenuExpanded?'show-content':'hide-content'\">\r\n        <div class=\"pt-2\" *ngIf=\"mainMenuExpanded\">\r\n          <p-tieredMenu   [autoDisplay]=\"true\" [model]=\"mainMenu\"></p-tieredMenu>\r\n        </div>\r\n      </section>\r\n      <div class=\"flex flex-column pb-2 flex-grow-1 justify-content-end\" [ngClass]=\"mainMenuExpanded?'align-items-end':'align-items-center'\">\r\n\r\n          <button (click)=\" onShowHideSideBarDetails()\" pButton pRipple type=\"button\" icon=\"{{mainMenuExpanded?'pi pi-angle-double-left':'pi pi-angle-double-right'}} text-2xl\" class=\"p-button-rounded p-button-text p-button-plain\"></button></div>\r\n      </div>\r\n\r\n\r\n\r\n  </aside>\r\n</div>\r\n\r\n\r\n<!--<div class=\"grid-nogutter max-w-max sidebar shadow-5\" >\r\n  <aside class=\"shadow-5\" >\r\n    <div  class=\"flex flex-column h-screen py-2\"\r\n          [@OnExpandSideBar]=\"mainMenuExpanded?'open':'closed'\">\r\n      <div class=\"pt-3\" *ngIf=\"!mainMenuExpanded\">\r\n        <p-tieredMenu  [styleClass]=\"'collapseSideBar'\"   [autoDisplay]=\"true\" [model]=\"mainMenuIcons\" ></p-tieredMenu>\r\n      </div>\r\n      <section  [@OnExpandSideBarText]=\"mainMenuExpanded?'show-content':'hide-content'\">\r\n        <div class=\"flex flex-column align-self-start pt-3\" *ngIf=\"mainMenuExpanded\">\r\n          <p-tieredMenu   [autoDisplay]=\"true\" [model]=\"mainMenu\"></p-tieredMenu>\r\n        </div>\r\n      </section>\r\n      <div class=\"flex flex-column h-screen justify-content-end\">\r\n        <div class=\"flex \" [ngClass]=\"mainMenuExpanded?'justify-content-end':'align-self-center'\" style=\"padding-bottom: 70px\">\r\n          <button (click)=\" onShowHideSideBarDetails()\" pButton pRipple type=\"button\" icon=\"{{mainMenuExpanded?'pi pi-angle-double-left':'pi pi-angle-double-right'}} text-2xl\" class=\"p-button-rounded p-button-text p-button-plain\"></button></div>\r\n      </div>\r\n    </div>\r\n\r\n\r\n  </aside>\r\n</div>-->\r\n\r\n\r\n\r\n\r\n\r\n", styles: [".sidebar{height:calc(100vh - 70px);z-index:100}.sidebar-no-header{height:100vh;z-index:100}:host ::ng-deep .p-tieredmenu .p-menuitem-link{padding:1.2rem 1.25rem}:host ::ng-deep .p-menuitem-link.p-menuitem-link-active{background:#d6e1ff}:host ::ng-deep .p-menuitem-link.p-menuitem-link-active .p-menuitem-text,:host ::ng-deep .p-menuitem-link.p-menuitem-link-active .p-menuitem-icon{color:#1d4ed8}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link .p-menuitem-text{color:#495057}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link .p-menuitem-icon,:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link .p-submenu-icon{color:#495057}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link-active .p-menuitem-text,:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link-active .p-menuitem-icon{color:#1d4ed8}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link.p-menuitem-link-active{background:#d6e1ff}:host ::ng-deep .p-tieredmenu{border:0;width:100%}:host ::ng-deep .collapseSideBar.p-tieredmenu{width:70px}:host ::ng-deep .p-tieredmenu .p-submenu-list{width:max-content;z-index:100}:host ::ng-deep .p-tieredmenu .p-menuitem-active>p-tieredmenusub>.p-submenu-list{left:102%}\n"], dependencies: [{ kind: "component", type: i6$4.TieredMenu, selector: "p-tieredMenu", inputs: ["model", "popup", "style", "styleClass", "appendTo", "autoZIndex", "baseZIndex", "autoDisplay", "showTransitionOptions", "hideTransitionOptions"], outputs: ["onShow", "onHide"] }, { kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "directive", type: i11.Ripple, selector: "[pRipple]" }], animations: [
        trigger('OnExpandSideBar', [
            state('open', style({
                width: '100%',
            })),
            state('closed', style({
                width: '70px',
            })),
            transition('open => closed', [
                group([
                    query(':self', [animate('0s')]),
                    query('@OnExpandSideBarText', [animateChild()]),
                ]),
            ]),
            transition('closed => open', [
                group([
                    query(':self', [animate('0.2s')]),
                    query('@OnExpandSideBarText', [animateChild()]),
                ]),
            ]),
        ]),
        trigger('OnExpandSideBarText', [
            // ...
            state('show-content', style({
                opacity: '1',
            })),
            state('hide-content', style({
                opacity: '0',
                overflow: 'hidden',
            })),
            transition('show-content => hide-content', [animate('0s')]),
            transition('hide-content => show-content', [animate('0.2s 0.3s')]),
        ]),
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSidebarComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-sidebar', animations: [
                        trigger('OnExpandSideBar', [
                            state('open', style({
                                width: '100%',
                            })),
                            state('closed', style({
                                width: '70px',
                            })),
                            transition('open => closed', [
                                group([
                                    query(':self', [animate('0s')]),
                                    query('@OnExpandSideBarText', [animateChild()]),
                                ]),
                            ]),
                            transition('closed => open', [
                                group([
                                    query(':self', [animate('0.2s')]),
                                    query('@OnExpandSideBarText', [animateChild()]),
                                ]),
                            ]),
                        ]),
                        trigger('OnExpandSideBarText', [
                            // ...
                            state('show-content', style({
                                opacity: '1',
                            })),
                            state('hide-content', style({
                                opacity: '0',
                                overflow: 'hidden',
                            })),
                            transition('show-content => hide-content', [animate('0s')]),
                            transition('hide-content => show-content', [animate('0.2s 0.3s')]),
                        ]),
                    ], template: "<div class=\"grid-nogutter max-w-max shadow-5\" [ngClass]=\"headerDisplay?'sidebar':'sidebar-no-header'\" >\r\n  <aside class=\"shadow-5 \" >\r\n    <div  class=\"flex flex-column \"\r\n          [@OnExpandSideBar]=\"mainMenuExpanded?'open':'closed'\" [ngClass]=\"headerDisplay?'sidebar':'sidebar-no-header'\">\r\n      <div class=\"pt-2\" *ngIf=\"!mainMenuExpanded\">\r\n        <p-tieredMenu  [styleClass]=\"'collapseSideBar'\"   [autoDisplay]=\"true\" [model]=\"mainMenuIcons\" ></p-tieredMenu>\r\n      </div>\r\n      <section  [@OnExpandSideBarText]=\"mainMenuExpanded?'show-content':'hide-content'\">\r\n        <div class=\"pt-2\" *ngIf=\"mainMenuExpanded\">\r\n          <p-tieredMenu   [autoDisplay]=\"true\" [model]=\"mainMenu\"></p-tieredMenu>\r\n        </div>\r\n      </section>\r\n      <div class=\"flex flex-column pb-2 flex-grow-1 justify-content-end\" [ngClass]=\"mainMenuExpanded?'align-items-end':'align-items-center'\">\r\n\r\n          <button (click)=\" onShowHideSideBarDetails()\" pButton pRipple type=\"button\" icon=\"{{mainMenuExpanded?'pi pi-angle-double-left':'pi pi-angle-double-right'}} text-2xl\" class=\"p-button-rounded p-button-text p-button-plain\"></button></div>\r\n      </div>\r\n\r\n\r\n\r\n  </aside>\r\n</div>\r\n\r\n\r\n<!--<div class=\"grid-nogutter max-w-max sidebar shadow-5\" >\r\n  <aside class=\"shadow-5\" >\r\n    <div  class=\"flex flex-column h-screen py-2\"\r\n          [@OnExpandSideBar]=\"mainMenuExpanded?'open':'closed'\">\r\n      <div class=\"pt-3\" *ngIf=\"!mainMenuExpanded\">\r\n        <p-tieredMenu  [styleClass]=\"'collapseSideBar'\"   [autoDisplay]=\"true\" [model]=\"mainMenuIcons\" ></p-tieredMenu>\r\n      </div>\r\n      <section  [@OnExpandSideBarText]=\"mainMenuExpanded?'show-content':'hide-content'\">\r\n        <div class=\"flex flex-column align-self-start pt-3\" *ngIf=\"mainMenuExpanded\">\r\n          <p-tieredMenu   [autoDisplay]=\"true\" [model]=\"mainMenu\"></p-tieredMenu>\r\n        </div>\r\n      </section>\r\n      <div class=\"flex flex-column h-screen justify-content-end\">\r\n        <div class=\"flex \" [ngClass]=\"mainMenuExpanded?'justify-content-end':'align-self-center'\" style=\"padding-bottom: 70px\">\r\n          <button (click)=\" onShowHideSideBarDetails()\" pButton pRipple type=\"button\" icon=\"{{mainMenuExpanded?'pi pi-angle-double-left':'pi pi-angle-double-right'}} text-2xl\" class=\"p-button-rounded p-button-text p-button-plain\"></button></div>\r\n      </div>\r\n    </div>\r\n\r\n\r\n  </aside>\r\n</div>-->\r\n\r\n\r\n\r\n\r\n\r\n", styles: [".sidebar{height:calc(100vh - 70px);z-index:100}.sidebar-no-header{height:100vh;z-index:100}:host ::ng-deep .p-tieredmenu .p-menuitem-link{padding:1.2rem 1.25rem}:host ::ng-deep .p-menuitem-link.p-menuitem-link-active{background:#d6e1ff}:host ::ng-deep .p-menuitem-link.p-menuitem-link-active .p-menuitem-text,:host ::ng-deep .p-menuitem-link.p-menuitem-link-active .p-menuitem-icon{color:#1d4ed8}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link .p-menuitem-text{color:#495057}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link .p-menuitem-icon,:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link .p-submenu-icon{color:#495057}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link-active .p-menuitem-text,:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link-active .p-menuitem-icon{color:#1d4ed8}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link.p-menuitem-link-active{background:#d6e1ff}:host ::ng-deep .p-tieredmenu{border:0;width:100%}:host ::ng-deep .collapseSideBar.p-tieredmenu{width:70px}:host ::ng-deep .p-tieredmenu .p-submenu-list{width:max-content;z-index:100}:host ::ng-deep .p-tieredmenu .p-menuitem-active>p-tieredmenusub>.p-submenu-list{left:102%}\n"] }]
        }], ctorParameters: function () { return [{ type: MainLayoutService }, { type: ArrayUtilityService }, { type: i5.TranslateService }, { type: AbstractAuthService }, { type: ObjectsUtilityService }]; }, propDecorators: { mainMenuOriginal: [{
                type: Input
            }] } });

/**
 * layout page
 */
/**
 * Page Main Layout
 */
class PrgLayoutsHeaderSidebarComponent {
    /**
     * constructor
     * @param cdr
     */
    constructor(cdr) {
        this.cdr = cdr;
    }
    /**
     * ngAfterViewInit
     */
    ngAfterViewInit() {
        this.cdr.detectChanges();
    }
}
PrgLayoutsHeaderSidebarComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLayoutsHeaderSidebarComponent, deps: [{ token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component });
PrgLayoutsHeaderSidebarComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgLayoutsHeaderSidebarComponent, selector: "prg-layouts-header-sidebar", ngImport: i0, template: "<prg-header></prg-header>\r\n<div class=\"grid grid-nogutter\">\r\n  <prg-sidebar class=\"col-fixed grid-nogutter\"></prg-sidebar>\r\n\r\n  <main class=\"col grid-nogutter pt-2 px-2\">\r\n    <router-outlet></router-outlet>\r\n  </main>\r\n</div>\r\n\r\n<!--\r\n\r\n<div>\r\n<prg-header></prg-header>\r\n<div class=\"flex\">\r\n  <div class=\"flex-none flex\">\r\n\r\n    <prg-sidebar></prg-sidebar>\r\n  </div>\r\n\r\n  <div class=\"flex-grow-1 justify-content-center flex pt-2 px-5\">\r\n    <router-outlet ></router-outlet>\r\n  </div>\r\n</div>\r\n</div>\r\n-->\r\n", styles: [""], dependencies: [{ kind: "directive", type: i1$1.RouterOutlet, selector: "router-outlet", outputs: ["activate", "deactivate", "attach", "detach"], exportAs: ["outlet"] }, { kind: "component", type: PrgHeaderComponent, selector: "prg-header", inputs: ["imagePathLogo", "imagePathUserDefault", "menuItemsUser", "menuItemsLanguage"] }, { kind: "component", type: PrgSidebarComponent, selector: "prg-sidebar", inputs: ["mainMenuOriginal"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLayoutsHeaderSidebarComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-layouts-header-sidebar', template: "<prg-header></prg-header>\r\n<div class=\"grid grid-nogutter\">\r\n  <prg-sidebar class=\"col-fixed grid-nogutter\"></prg-sidebar>\r\n\r\n  <main class=\"col grid-nogutter pt-2 px-2\">\r\n    <router-outlet></router-outlet>\r\n  </main>\r\n</div>\r\n\r\n<!--\r\n\r\n<div>\r\n<prg-header></prg-header>\r\n<div class=\"flex\">\r\n  <div class=\"flex-none flex\">\r\n\r\n    <prg-sidebar></prg-sidebar>\r\n  </div>\r\n\r\n  <div class=\"flex-grow-1 justify-content-center flex pt-2 px-5\">\r\n    <router-outlet ></router-outlet>\r\n  </div>\r\n</div>\r\n</div>\r\n-->\r\n" }]
        }], ctorParameters: function () { return [{ type: i0.ChangeDetectorRef }]; } });

/**
 * Config Items routing module routes
 */
const standardRoutes$6 = [];
/**
 * Config Items Routing Module
 */
class PrgConfigurationItemsRoutingModule {
}
PrgConfigurationItemsRoutingModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigurationItemsRoutingModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
PrgConfigurationItemsRoutingModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigurationItemsRoutingModule, imports: [i1$1.RouterModule], exports: [RouterModule] });
PrgConfigurationItemsRoutingModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigurationItemsRoutingModule, providers: [
        {
            provide: ROUTES,
            useFactory: () => {
                let routes = [];
                routes.push({
                    path: configurationItemsConfig.configurationItemsRoutingBasePath,
                    component: PrgLayoutsHeaderSidebarComponent,
                    children: [
                        {
                            path: configurationItemsConfig.configurationItemsRoutingAdminPath,
                            component: PrgConfigItemsAdminComponent,
                        },
                        {
                            path: configurationItemsConfig.configurationItemsRoutingUserPath,
                            component: PrgConfigItemsUserComponent,
                        },
                    ],
                });
                return [...routes, ...standardRoutes$6];
            },
            multi: true,
        },
    ], imports: [RouterModule.forChild(standardRoutes$6), RouterModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigurationItemsRoutingModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [RouterModule.forChild(standardRoutes$6)],
                    exports: [RouterModule],
                    providers: [
                        {
                            provide: ROUTES,
                            useFactory: () => {
                                let routes = [];
                                routes.push({
                                    path: configurationItemsConfig.configurationItemsRoutingBasePath,
                                    component: PrgLayoutsHeaderSidebarComponent,
                                    children: [
                                        {
                                            path: configurationItemsConfig.configurationItemsRoutingAdminPath,
                                            component: PrgConfigItemsAdminComponent,
                                        },
                                        {
                                            path: configurationItemsConfig.configurationItemsRoutingUserPath,
                                            component: PrgConfigItemsUserComponent,
                                        },
                                    ],
                                });
                                return [...routes, ...standardRoutes$6];
                            },
                            multi: true,
                        },
                    ],
                }]
        }] });

/**
 * Injectable
 */
/**
 * REAL ConfigurationItemsService implementation
 */
class ConfigurationItemsService$1 extends AbstractConfigurationItemsService$1 {
    /**
     * Get a list of all configuration items
     * @returns {Promise<ConfigurationItem[]>}
     */
    getAllConfigurationItemsAsync() {
        throw new Error('Method not implemented.');
    }
    /**
     * Function responsible to update Config Items
     * @param configItemData
     * @returns {Promise<ConfigurationItem[]>}
     */
    updateConfigurationItemsAsync(configItemData) {
        throw new Error('Method not implemented.');
    }
    /**
     * Get configuration items by path
     * @param {string} path
     * @returns {Promise<any>}
     */
    getConfigurationItemsByPathAsync(path) {
        throw new Error('Method not implemented.');
    }
}
ConfigurationItemsService$1.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ConfigurationItemsService$1, deps: null, target: i0.ɵɵFactoryTarget.Injectable });
ConfigurationItemsService$1.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ConfigurationItemsService$1, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ConfigurationItemsService$1, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }] });

/**
 * Module that handles authentication
 */
class PrgConfigurationItemsModule {
    constructor(injector) {
        this.injector = injector;
        appInjector$7 = this.injector;
    }
    static forRoot(prgConfigurationItemsConfig) {
        configurationItemsConfig = prgConfigurationItemsConfig;
        return {
            ngModule: PrgConfigurationItemsModule,
            providers: [
                {
                    provide: PRG_CONFIGURATION_ITEMS_CONFIG,
                    useValue: prgConfigurationItemsConfig,
                },
                {
                    provide: AbstractConfigurationItemsService$1,
                    useClass: prgConfigurationItemsConfig.useMockServices
                        ? MockConfigurationItemsService$1
                        : ConfigurationItemsService$1,
                },
            ],
        };
    }
}
PrgConfigurationItemsModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigurationItemsModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgConfigurationItemsModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigurationItemsModule, declarations: [PrgConfigItemsUserComponent, PrgConfigItemsAdminComponent], imports: [PrgSharedComponentsModule,
        PrgConfigurationItemsRoutingModule,
        PrgCoreDynamicFormModule] });
PrgConfigurationItemsModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigurationItemsModule, imports: [PrgSharedComponentsModule,
        PrgConfigurationItemsRoutingModule,
        PrgCoreDynamicFormModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgConfigurationItemsModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [PrgConfigItemsUserComponent, PrgConfigItemsAdminComponent],
                    imports: [
                        PrgSharedComponentsModule,
                        PrgConfigurationItemsRoutingModule,
                        PrgCoreDynamicFormModule,
                    ],
                    exports: [],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
let appInjector$7;
/**
 * Exports the ConfigItemsCoreConfig object
 */
let configurationItemsConfig;

/**
 * Class Pagination
 */
class Pagination {
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init) {
        /**
         * set the pagination type
         *
         * pages - the data is presented page by page
         *
         * infiniteLoading - the data is presented with scroll
         */
        this.type = PaginationType.pages;
        /**
         * number of items per page
         */
        this.totalRows = 3;
        /**
         * options for choosing items per page(by pages)
         */
        this.rowsPerPageOptions = [2, 3, 5, 10, 100];
        Object.assign(this, init);
    }
}
var PaginationType;
(function (PaginationType) {
    // eslint-disable-next-line no-unused-vars
    PaginationType["infiniteLoading"] = "infiniteLoading";
    // eslint-disable-next-line no-unused-vars
    PaginationType["pages"] = "pages";
})(PaginationType || (PaginationType = {}));

var FilterExpressions;
(function (FilterExpressions) {
    FilterExpressions[FilterExpressions["And"] = 0] = "And";
    FilterExpressions[FilterExpressions["Or"] = 1] = "Or";
})(FilterExpressions || (FilterExpressions = {}));
/**
 * Map primeng expressions to out expressions
 */
const MapPrimeNgExpressionsToFilterExpressions = new Map([
    ['and', FilterExpressions.And],
    ['or', FilterExpressions.Or],
]);
var FilterOperations;
(function (FilterOperations) {
    FilterOperations[FilterOperations["EqualTo"] = 0] = "EqualTo";
    FilterOperations[FilterOperations["NotEqualTo"] = 1] = "NotEqualTo";
    FilterOperations[FilterOperations["GreaterThan"] = 2] = "GreaterThan";
    FilterOperations[FilterOperations["GreaterThanOrEqualTo"] = 3] = "GreaterThanOrEqualTo";
    FilterOperations[FilterOperations["LessThan"] = 4] = "LessThan";
    FilterOperations[FilterOperations["LessThanOrEqualTo"] = 5] = "LessThanOrEqualTo";
    FilterOperations[FilterOperations["Between"] = 6] = "Between";
    FilterOperations[FilterOperations["Contains"] = 7] = "Contains";
    FilterOperations[FilterOperations["DoesNotContain"] = 8] = "DoesNotContain";
    FilterOperations[FilterOperations["EndsWith"] = 9] = "EndsWith";
    FilterOperations[FilterOperations["In"] = 10] = "In";
    FilterOperations[FilterOperations["IsEmpty"] = 11] = "IsEmpty";
    FilterOperations[FilterOperations["IsNotEmpty"] = 12] = "IsNotEmpty";
    FilterOperations[FilterOperations["IsNotNull"] = 13] = "IsNotNull";
    FilterOperations[FilterOperations["IsNotNullNorWhiteSpace"] = 14] = "IsNotNullNorWhiteSpace";
    FilterOperations[FilterOperations["IsNull"] = 15] = "IsNull";
    FilterOperations[FilterOperations["IsNullOrWhiteSpace"] = 16] = "IsNullOrWhiteSpace";
    FilterOperations[FilterOperations["StartsWith"] = 17] = "StartsWith";
    FilterOperations[FilterOperations["NotIn"] = 18] = "NotIn";
})(FilterOperations || (FilterOperations = {}));
/**
 * Map primeng operations to out filter operations
 */
const MapPrimeNgFilterOperationsToFilterOperations = new Map([
    [FilterMatchMode.STARTS_WITH, FilterOperations.StartsWith],
    [FilterMatchMode.CONTAINS, FilterOperations.Contains],
    [FilterMatchMode.NOT_CONTAINS, FilterOperations.DoesNotContain],
    [FilterMatchMode.ENDS_WITH, FilterOperations.EndsWith],
    [FilterMatchMode.EQUALS, FilterOperations.EqualTo],
    [FilterMatchMode.NOT_EQUALS, FilterOperations.NotEqualTo],
    [FilterMatchMode.IN, FilterOperations.In],
    [FilterMatchMode.LESS_THAN, FilterOperations.LessThan],
    [FilterMatchMode.LESS_THAN_OR_EQUAL_TO, FilterOperations.LessThanOrEqualTo],
    [FilterMatchMode.GREATER_THAN, FilterOperations.GreaterThan],
    [
        FilterMatchMode.GREATER_THAN_OR_EQUAL_TO,
        FilterOperations.GreaterThanOrEqualTo,
    ],
    [FilterMatchMode.BETWEEN, FilterOperations.Between],
    [FilterMatchMode.IS, FilterOperations.EqualTo],
    [FilterMatchMode.IS_NOT, FilterOperations.NotEqualTo],
    [FilterMatchMode.BEFORE, FilterOperations.LessThan],
    [FilterMatchMode.AFTER, FilterOperations.GreaterThan],
    [FilterMatchMode.DATE_IS, FilterOperations.EqualTo],
    [FilterMatchMode.DATE_IS_NOT, FilterOperations.NotEqualTo],
    [FilterMatchMode.DATE_BEFORE, FilterOperations.LessThan],
    [FilterMatchMode.DATE_AFTER, FilterOperations.GreaterThan],
]);
/**
 * enum to convert our datatypes to those supported by primeng
 */
var PrimeNgTypeToOurTypes;
(function (PrimeNgTypeToOurTypes) {
    PrimeNgTypeToOurTypes["dataType.string"] = "text";
    PrimeNgTypeToOurTypes["dataType.number"] = "numeric";
    PrimeNgTypeToOurTypes["dataType.date"] = "date";
})(PrimeNgTypeToOurTypes || (PrimeNgTypeToOurTypes = {}));
/**
 * Filter operations in string format
 */
var FilterOperationsString;
(function (FilterOperationsString) {
    FilterOperationsString[FilterOperationsString["EqualTo"] = 0] = "EqualTo";
    FilterOperationsString[FilterOperationsString["NotEqualTo"] = 1] = "NotEqualTo";
    FilterOperationsString[FilterOperationsString["GreaterThan"] = 2] = "GreaterThan";
    FilterOperationsString[FilterOperationsString["GreaterThanOrEqualTo"] = 3] = "GreaterThanOrEqualTo";
    FilterOperationsString[FilterOperationsString["LessThan"] = 4] = "LessThan";
    FilterOperationsString[FilterOperationsString["LessThanOrEqualTo"] = 5] = "LessThanOrEqualTo";
    FilterOperationsString[FilterOperationsString["Between"] = 6] = "Between";
    FilterOperationsString[FilterOperationsString["Contains"] = 7] = "Contains";
    FilterOperationsString[FilterOperationsString["DoesNotContain"] = 8] = "DoesNotContain";
    FilterOperationsString[FilterOperationsString["EndsWith"] = 9] = "EndsWith";
    FilterOperationsString[FilterOperationsString["In"] = 10] = "In";
    FilterOperationsString[FilterOperationsString["IsEmpty"] = 11] = "IsEmpty";
    FilterOperationsString[FilterOperationsString["IsNotEmpty"] = 12] = "IsNotEmpty";
    FilterOperationsString[FilterOperationsString["IsNotNull"] = 13] = "IsNotNull";
    FilterOperationsString[FilterOperationsString["IsNotNullNorWhiteSpace"] = 14] = "IsNotNullNorWhiteSpace";
    FilterOperationsString[FilterOperationsString["IsNull"] = 15] = "IsNull";
    FilterOperationsString[FilterOperationsString["IsNullOrWhiteSpace"] = 16] = "IsNullOrWhiteSpace";
    FilterOperationsString[FilterOperationsString["StartsWith"] = 17] = "StartsWith";
    FilterOperationsString[FilterOperationsString["NotIn"] = 18] = "NotIn";
})(FilterOperationsString || (FilterOperationsString = {}));
var OrderTypes;
(function (OrderTypes) {
    OrderTypes[OrderTypes["Ascending"] = 0] = "Ascending";
    OrderTypes[OrderTypes["Descending"] = 1] = "Descending";
})(OrderTypes || (OrderTypes = {}));
/**
 * Map primeng sort order to ou orderTypes
 */
const PrimeNgSortToOrderTypeMap = new Map([
    [-1, OrderTypes.Descending],
    [1, OrderTypes.Ascending],
]);
class Filter {
    constructor() {
        this.filterOperation = FilterOperations.Contains;
        this.filterExpression = FilterExpressions.And;
    }
}
class Order {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        Object.assign(this, init);
    }
}
class FilterGroup {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        Object.assign(this, init);
    }
}
class FilterCollection {
}
class GenericFilter {
    constructor() {
        this.filterOperation = FilterOperations.Contains;
        this.filterExpression = FilterExpressions.And;
        this.isStartGroup = false;
        this.visible = true;
    }
}

/**
 * TableConfigs
 */
class TableConfigs {
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init) {
        /**
         * defines the type of pagination we want and all the pagination settings
         */
        this.pagination = new Pagination();
        /**
         * default columns to show
         */
        this.defaultColumns = [];
        /**
         * columns in which the global filter is searched
         */
        this.globalFilterFields = [];
        /**
         * global filter oprarion out value
         */
        this.globalFilterOperation = FilterOperations.Contains;
        /**
         * global filter expression
         */
        this.globalFilterExpression = FilterExpressions.Or;
        /**
         * filter delay
         */
        this.filterDelay = 1000;
        /**
         * multi sorte meta
         */
        this.multiSortMeta = [];
        Object.assign(this, init);
    }
}

/**
 * Module that handles all page layouts
 */
class PrgLayoutsModule {
}
PrgLayoutsModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLayoutsModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
PrgLayoutsModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgLayoutsModule, declarations: [PrgLayoutsEmptyComponent,
        PrgHeaderComponent,
        PrgSidebarComponent,
        PrgLayoutsHeaderSidebarComponent], imports: [PrgSharedComponentsModule], exports: [PrgLayoutsEmptyComponent,
        PrgHeaderComponent,
        PrgSidebarComponent,
        PrgLayoutsHeaderSidebarComponent] });
PrgLayoutsModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLayoutsModule, imports: [PrgSharedComponentsModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLayoutsModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        PrgLayoutsEmptyComponent,
                        PrgHeaderComponent,
                        PrgSidebarComponent,
                        PrgLayoutsHeaderSidebarComponent,
                    ],
                    imports: [PrgSharedComponentsModule],
                    exports: [
                        PrgLayoutsEmptyComponent,
                        PrgHeaderComponent,
                        PrgSidebarComponent,
                        PrgLayoutsHeaderSidebarComponent,
                    ],
                }]
        }] });

/**
 * AbstractConfigurationItemsService class that defines an
 * <br />abstract configuration items service to
 * <br />be extended by the mock and real
 * <br />authentication services
 */
class AbstractConfigurationItemsService {
    constructor() {
        /**
         * Current configurationItems
         */
        this.configurationItemsSubject = new BehaviorSubject(null);
    }
    /**
     * Setter for configurationItemsSubject
     *
     * @param {ConfigurationItem[]} value The ConfigurationItems array
     */
    setConfigurationItems(value) {
        this.configurationItemsSubject.next(value);
    }
    /**
     * Getter for configurationItemsSubject
     *
     * @returns The configurationItemsSubject as an observable
     */
    getConfigurationItemsObservable() {
        return this.configurationItemsSubject.asObservable();
    }
    /**
     * Getter for configurationItemsSubject
     *
     * @returns The configurationItemsSubject current value
     */
    getConfigurationItemsValue() {
        return this.configurationItemsSubject.getValue();
    }
}

/**
 * Injectable
 */
/**
 * REAL ConfigurationItemsService implementation
 */
class ConfigurationItemsService extends AbstractConfigurationItemsService {
    /**
     * constructor
     */
    constructor() {
        super();
    }
    /**
     * Gets the real configuration items from
     * <br />the api and sets them on the
     * <br />configurationItemsSubject
     *
     * @returns Boolean promise, true when successful
     */
    getConfigurationItemsAsync() {
        return new Promise((resolve) => {
            resolve(false);
        });
    }
}
ConfigurationItemsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ConfigurationItemsService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
ConfigurationItemsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ConfigurationItemsService, providedIn: "root" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ConfigurationItemsService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: "root",
                }]
        }], ctorParameters: function () { return []; } });

// GCR: por cada módulo criar uma pasta mock onde tem uma bd desse módulo apenas, ou seja,
// cada módulo ter a sua mock database para podermos, no futuro,
// separar os modulos em packages sem alterar código
// GCR: todos os ficheiros mock deve estar na pasta mock com a mesma estrutura dos reais
/**
 * MockDatabase object to be used while developing
 * <br /> and/or testing the front-end
 */
const MockDatabase$2 = {
    /*  EntityTypes: [
      {
        id: '1',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'Customer',
        createdBy: null,
        modifiedBy: null,
        label: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        guiSettings: '',
        group: 'System',
        properties: null /!*definidas inicialmente e nunca mais alteradas*!/,
        attributes: null /!*são atributos que podem adicionados/editados*!/,
        operations: [
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label:null,
            name: 'view',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'create',
            createdBy: null,
            label:null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
  
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'update',
            createdBy: null,
            modifiedBy: null,
            label:null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'delete',
            createdBy: null,
            label:null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
        ],
      },
      {
        id: '2',
        label: null,
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'User',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        guiSettings: '',
        group: 'System',
        properties: null,
        attributes: null,
        operations: [
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'view',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'create',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'update',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
        ],
      },
      {
        id: '3',
        label: null,
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'Product',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        guiSettings: '',
        group: 'Store',
        properties: null,
        attributes: null,
        operations: [
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'view',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'create',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
        ],
      },
      {
        id: '4',
        label: null,
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'Orders',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        guiSettings: '',
        group: 'Store',
        properties: null,
        attributes: null,
        operations: [
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'create',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'viewUserOrder',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
          {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'updateUserOrder',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
          },
        ],
      },
    ],
  
    EntityTypesOperations: [
      {
        id: '1',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'getCustomer',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '3',
        guiSettings: 'string',
        override: false,
        imports: null,
        sourceCode: 'string',
        httpVerb: HttpVerb.Get,
        order: 0,
      },
    ],
    EntityTypesProperties: [
      {
        id: '1',
        label: null,
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'customer name',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '1',
        guiSettings: 'customer name',
        dataTypeId: 'dataType.string',
        order: 1,
        reference: 'customer name',
      },
      {
        id: '2',
        universalStateId: '1',
        transactionId: null,
        label: null,
        operationId: null,
        name: 'customer Id',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '1',
        guiSettings: 'customer Id',
        dataTypeId: 'dataType.number',
        order: 1,
        reference: 'customer Id',
      },
      {
        id: '3',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'date of birth',
        createdBy: null,
        modifiedBy: null,
        label: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '1',
        guiSettings: 'date of birth',
        dataTypeId: 'dataType.date',
        order: 1,
        reference: 'date of birth',
      },
  
      {
        id: '4',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'user name',
        label: null,
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '2',
        guiSettings: 'user name',
        dataTypeId: 'dataType.string',
        order: 1,
        reference: 'user name',
      },
      {
        id: '5',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'user Id',
        label: null,
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '2',
        guiSettings: 'user Id',
        dataTypeId: 'dataType.number',
        order: 1,
        reference: 'user Id',
      },
      {
        id: '6',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'RegisterDate',
        createdBy: null,
        modifiedBy: null,
        label: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '2',
        guiSettings: 'RegisterDate',
        dataTypeId: 'dataType.date',
        order: 1,
        reference: 'RegisterDate',
      },
    ],
    EntityTypesAttributes: [
      {
        id: '1',
        universalStateId: '1',
        transactionId: null,
        label: null,
        operationId: null,
        name: 'customer address',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '1',
        guiSettings: 'customer address',
        dataTypeId: 'dataType.string',
        order: 1,
        reference: 'customer address',
      },
      {
        id: '2',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        label: null,
        name: 'VAT',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '1',
        guiSettings: 'VAT',
        dataTypeId: 'dataType.number',
        order: 1,
        reference: 'VAT',
      },
      {
        id: '3',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'city',
        createdBy: null,
        label: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '1',
        guiSettings: 'city',
        dataTypeId: 'dataType.string',
        order: 1,
        reference: 'city',
      },
      {
        id: '4',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        label: null,
        name: 'user address',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '2',
        guiSettings: 'user address',
        dataTypeId: 'dataType.string',
        order: 1,
        reference: 'user address',
      },
      {
        id: '5',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        label: null,
        name: 'user date of birth',
        createdBy: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '2',
        guiSettings: 'user date of birth',
        dataTypeId: 'dataType.date',
        order: 1,
        reference: 'user date of birth',
      },
      {
        id: '6',
        universalStateId: '1',
        transactionId: null,
        operationId: null,
        name: 'email',
        createdBy: null,
        label: null,
        modifiedBy: null,
        createdOn: null,
        modifiedOn: null,
        workspaceId: '1',
        entityTypeId: '2',
        guiSettings: 'email',
        dataTypeId: 'dataType.string',
        order: 1,
        reference: 'email',
      },
    ],*/
    /* TODO: MAP IDENTITY CONFIG TO CONFIGURATION ITEMS
      "Identity": {
        "DefaultEnabledUser": true, // user will be enabled on register
        "AllowSelfRegister": true,
        "LockoutEnabled": true,
        "CreateWorkspaceOnUserRegister": true,
        "SignIn": {
          "RequireEnabledUser": false,
          "RequireConfirmedAdmin": false,
          "RequireConfirmedEmail": true,
          "RequireConfirmedPhoneNumber": false
        },
        "Lockout": {
          "LockoutTimeSpan": "1.00:00:00" //lock out for 1 day
        },
        "Password": {
          "RequireDigit": true,
          "RequiredLength": 7,
          "RequireLowercase": true,
          "RequiredUniqueChars": 1,
          "RequireUppercase": true,
          "RequireNonAlphanumeric": true
        },
        "Callbacks": {
          "BaseUrl": "http://localhost:8100",
          "LoginUrl": "/auth/login",
          "ConfirmedAccountUrl": "/auth/confirm",
          "ResetPasswordUrl": "/auth/reset",
          "UnsubscribeUrl": "/auth/unsubscribe"
        },
        "Token": {
          "Audience": "Prg.Framework.Api.Audience",
          "Issuer": "Prg.Framework.Api.Issuer",
          "Seconds": 86400, // 24 hours
          "RefreshDuration": 24 // 24 hours
        }
      }
    */
    ConfigurationItems: [],
};

/**
 * Injectable
 */
/**
 * MOCK ConfigurationItemsService implementation
 */
class MockConfigurationItemsService extends AbstractConfigurationItemsService {
    /**
     * constructor
     */
    constructor() {
        super();
    }
    /**
     * Gets the mock configuration items from
     * <br />the mock database and sets them
     * <br />on the configurationItemsSubject
     *
     * @returns Boolean promise, true when successful
     */
    getConfigurationItemsAsync() {
        return new Promise((resolve) => {
            const items = MockDatabase$2.ConfigurationItems;
            if (items != null && items.length) {
                this.setConfigurationItems(items);
                resolve(true);
            }
            else {
                resolve(false);
            }
        });
    }
}
MockConfigurationItemsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockConfigurationItemsService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
MockConfigurationItemsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockConfigurationItemsService, providedIn: "root" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockConfigurationItemsService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: "root",
                }]
        }], ctorParameters: function () { return []; } });

/**
 * Inject token
 */
const PRG_CORE_CONFIG = new InjectionToken("PRG_CORE_CONFIG");
/**
 * Injectable
 */
/**
 * PrgCoreConfigurationService class definition
 * <br />that specifies the properties that the
 * <br />application can send to the lib for
 * <br />configuration purposes
 */
class PrgCoreConfigurationService {
    /**
     * Constructor
     *
     * @param prgCoreConfig
     */
    constructor(prgCoreConfig) {
        this.prgCoreConfig = prgCoreConfig;
    }
}
PrgCoreConfigurationService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreConfigurationService, deps: [{ token: PRG_CORE_CONFIG }], target: i0.ɵɵFactoryTarget.Injectable });
PrgCoreConfigurationService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreConfigurationService, providedIn: "root" });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreConfigurationService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: "root",
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_CORE_CONFIG]
                }] }]; } });

/**
 * Lib Core (main) module, must provide the correct
 * implementation of its services, as well as the lib
 * configurations object
 */
class PrgCoreModule {
    constructor(injector) {
        this.injector = injector;
        appInjector$6 = this.injector;
    }
    static forRoot(prgCoreConfig) {
        coreConfig = prgCoreConfig;
        return {
            ngModule: PrgCoreModule,
            providers: [
                {
                    provide: PRG_CORE_CONFIG,
                    useValue: prgCoreConfig,
                },
                {
                    provide: AbstractConfigurationItemsService,
                    useClass: prgCoreConfig.useMockServices
                        ? MockConfigurationItemsService
                        : ConfigurationItemsService,
                },
            ],
        };
    }
}
PrgCoreModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgCoreModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreModule, imports: [PrgLayoutsModule, PrgCoreDynamicFormModule], exports: [PrgLayoutsModule, PrgDynamicFormComponent] });
PrgCoreModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreModule, imports: [PrgLayoutsModule, PrgCoreDynamicFormModule, PrgLayoutsModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCoreModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [],
                    imports: [PrgLayoutsModule, PrgCoreDynamicFormModule],
                    exports: [PrgLayoutsModule, PrgDynamicFormComponent],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
let appInjector$6;
/**
 * Exports the PrgCoreConfig object
 */
let coreConfig;

/**
 * Injectable
 */
/**
 * Generic context service, provides a way to store information in any context
 */
class ContextGenericService {
    constructor() {
        /**
         * Map that holds all the variables and actions.
         * <br />-> key - owner name
         * <br />-> value object that holds a map for variables and a map for actions
         */
        this.context = new Map();
        /**
         * Array that holds all subscriptions, used to clean up on destroy
         */
        this.subscriptions = [];
    }
    /**
     * Clean up all
     */
    ngOnDestroy() {
        while (this.subscriptions.length > 0) {
            this.unsubscribe(this.subscriptions[0]);
        }
    }
    /**
     * Get owner context using name, if the context does not exist, it is created
     * @param ownerName Name of the owner
     * @returns The owner full context
     */
    getOwnerContext(ownerName) {
        let ownerContext = this.context[ownerName];
        if (!ownerContext) {
            // owner context does not exist, create it
            ownerContext = {
                variables: new Map(),
                actions: new Map(),
            };
            this.context[ownerName] = ownerContext;
        }
        return ownerContext;
    }
    /**
     * Get a variable subject using owner and name, if the variable does not exist, it is created
     * @param ownerName Name of the owner
     * @param variableName Name of the variable
     * @returns Subject of the variable
     */
    getVariable(ownerName, variableName) {
        // Check if owner context exist
        let ownerContext = this.getOwnerContext(ownerName);
        // check if variable exist for this owner
        let variable = ownerContext.variables[variableName];
        if (!variable) {
            // variable does not exist, create it
            variable = new BehaviorSubject(null);
            ownerContext.variables[variableName] = variable;
        }
        return variable;
    }
    /**
     * Subscribes to a variable subject using owner and name, if the variable does not exist, it is created
     * @param ownerName Name of the owner
     * @param variableName Name of the variable
     * @param callback callback function of the subscriber
     * @returns Susbcription
     */
    subscribeVariable(ownerName, variableName, callback) {
        const subject = this.getVariable(ownerName, variableName);
        const subscription = subject.asObservable().subscribe((data) => {
            callback(this.cloneObject(data));
        });
        this.subscriptions.push(subscription);
        return subscription;
    }
    /**
     *  // TODO: This method should be changed to a generic utils class
     */
    cloneObject(obj) {
        return obj ? Object.assign({}, obj) : null; // TODO: check best way to clone a full deep copy
    }
    /**
     * Set data to a variable subject using owner and name, if the variable does not exist, it is created
     * @param ownerName Name of the owner
     * @param variableName Name of the variable
     * @param data Data to be set
     */
    setVariableData(ownerName, variableName, data) {
        const subject = this.getVariable(ownerName, variableName);
        const newValue = this.cloneObject(data);
        subject.next(newValue);
    }
    /**
     * Get an action event using owner and name, if the action does not exist, it is created
     * @param ownerName Name of the owner
     * @param actionName Name of the action
     * @returns Event of the action
     */
    getAction(ownerName, actionName) {
        // Check if owner context exist
        let ownerContext = this.getOwnerContext(ownerName);
        // check if variable exist for this owner
        let action = ownerContext.actions[actionName];
        if (!action) {
            // variable does not exist, create it
            action = new EventEmitter(true);
            ownerContext.actions[actionName] = action;
        }
        return action;
    }
    /**
     * Subscribes to an action using owner and name, if the variable does not exist, it is created
     * @param ownerName Name of the owner
     * @param actionName Name of the action
     * @param callback callback function of the subscriber
     * @returns Susbcription
     */
    subscribeAction(ownerName, actionName, callback) {
        const subject = this.getAction(ownerName, actionName);
        const subscription = subject.subscribe((data) => {
            callback(this.cloneObject(data));
        });
        this.subscriptions.push(subscription);
        return subscription;
    }
    /**
     * Send action using owner and name, if the action does not exist, it is created
     * @param ownerName Name of the owner
     * @param actionName Name of the action
     * @param data Data to be set
     */
    sendAction(ownerName, actionName, data) {
        const action = this.getAction(ownerName, actionName);
        action.emit(this.cloneObject(data));
    }
    /**
     * Unsubscribes a subscription
     * @param subscription Subscription to unsubscribe
     */
    unsubscribe(subscription) {
        if (!subscription)
            return;
        if (Array.isArray(subscription)) {
            // TODO:
        }
        else {
            const index = this.subscriptions.findIndex((s) => s === subscription);
            subscription.unsubscribe();
            if (index >= 0) {
                this.subscriptions.splice(index, 1);
            }
        }
    }
}
ContextGenericService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ContextGenericService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
ContextGenericService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ContextGenericService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ContextGenericService, decorators: [{
            type: Injectable
        }] });

/**
 * Injectable
 */
/**
 * App context service, provides a way to store information
 * <br />in the context of an app that can be used in its components
 */
class ContextAppService extends ContextGenericService {
    /**
     * constructor
     */
    constructor() {
        super();
    }
}
ContextAppService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ContextAppService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
ContextAppService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ContextAppService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: ContextAppService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });

/**
 * Injectable
 */
/**
 * Page context service, provides a way to store information
 * <br />in the context of a page that can be used in its components
 */
class PageContextService extends ContextGenericService {
    /**
     * constructor
     */
    constructor() {
        super();
    }
}
PageContextService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PageContextService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
PageContextService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PageContextService });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PageContextService, decorators: [{
            type: Injectable
        }], ctorParameters: function () { return []; } });

class PrgEntityTypeElementComponent {
    /**
     * constructor
     *
     * @param arrayUtilityService
     * @param utilityService
     * @param entityTypeService
     * @param ref
     * @param config
     * @param objectsUtilityService
     */
    constructor(arrayUtilityService, utilityService, entityTypeService, ref, config, objectsUtilityService, notificationsService, translateService, router, route) {
        this.arrayUtilityService = arrayUtilityService;
        this.utilityService = utilityService;
        this.entityTypeService = entityTypeService;
        this.ref = ref;
        this.config = config;
        this.objectsUtilityService = objectsUtilityService;
        this.notificationsService = notificationsService;
        this.translateService = translateService;
        this.router = router;
        this.route = route;
        /**
         * entity type view mode
         */
        this.elementViewMode = ViewMode.Read;
        /**
         * entity type form fields
         */
        this.entityTypeDynamicFormElementFields = [];
        /**
         * entity type form actions
         */
        this.entityTypeDynamicFormElementActions = [];
        /**
         * variable to save if is a popup
         */
        this.isPopup = false;
    }
    /**
     * element input
     */
    set element(element) {
        this._element = element;
    }
    /**
     * element getter
     */
    get element() {
        return this._element;
    }
    /**
     * entity type input
     */
    set entityType(entityType) {
        if (entityType) {
            this._entityType = entityType;
            this.getBaseFieldsFromEntityType(entityType);
            this.getActionsFromEntityType(entityType.operations);
        }
    }
    /**
     * entity type getter
     */
    get entityType() {
        return this._entityType;
    }
    /**
     * ngOnInit
     *
     *  if this component is contained in a dialog it fetches the data from the config
     */
    ngOnInit() {
        if (this.config.hasOwnProperty('data')) {
            this._entityType = this.config.data.entityType;
            this._element = this.config.data.element;
            this.elementViewMode = this.config.data.viewMode;
            this.getBaseFieldsFromEntityType(this.config.data.entityType);
            this.getActionsFromEntityType(this.config.data.entityType.operations);
            this.isPopup = true;
        }
        this.entityTypeDynamicFormElementActions.push(new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='read'",
        }), new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: ' this.entity!= null && this.entity.id == null',
        }));
    }
    /**
     * this function receives the output and depending on
     * the action clicked performs a certain set of actions
     *
     * @param event
     */
    async onActionOutputed(event) {
        switch (event.action) {
            case BaseActionKey.Cancel:
                if (event.formEntity.id) {
                    this.element = this.objectsUtilityService.cloneObject(this.element);
                    this.elementViewMode = ViewMode.Read;
                }
                if (this.isPopup) {
                    this.ref.close();
                }
                else {
                    window.location.href = window.location.href.replace('/new', '');
                }
                break;
            case BaseActionKey.Edit:
                this.elementViewMode = ViewMode.Edit;
                break;
            default:
                let actionResult;
                const action = this.entityTypeDynamicFormElementActions.find((a) => a.key === event.action);
                if (action == null || action['operation'] == null) {
                    return;
                }
                if (action.hasOwnProperty('confirmationModal') &&
                    action.hasOwnProperty('confirmationModal') !== null) {
                    if (await this.notificationsService.prgConfirmationService('messages.delete-confirmation', await this.translateService
                        .get('entities.' + this.entityType.name + '.label')
                        .toPromise())) {
                        actionResult = await this.entityTypeService.executeAction(this.entityType.name, action['operation'], event.formEntity);
                    }
                }
                else {
                    actionResult = await this.entityTypeService.executeAction(this.entityType.name, action['operation'], event.formEntity);
                }
                if (!action.executedActionBehaviour) {
                    break;
                }
                if (action.executedActionBehaviour.changeViewModeToRead) {
                    this.elementViewMode = ViewMode.Read;
                }
                if (action.executedActionBehaviour.redirectToList) {
                    if (this.isPopup) {
                        this.ref.close(action.executedActionBehaviour);
                    }
                    else {
                        this.router.navigate(['../'], { relativeTo: this.route });
                    }
                }
                break;
        }
    }
    /**
     * this function creates the filds for the dynamic
     * form according to the properties of an entity type
     * @param entityType
     */
    getBaseFieldsFromEntityType(entityType) {
        if (entityType.properties.length) {
            entityType.properties.forEach((property) => {
                if (property.guiSettings) {
                    const guiSettings = this.utilityService.guiSettingToObject(property.guiSettings, 'entities.' + entityType.name + '.fields');
                    if (!guiSettings.key) {
                        guiSettings.key = property.name;
                    }
                    this.entityTypeDynamicFormElementFields.push(guiSettings);
                }
            });
        }
        this.entityTypeDynamicFormElementFields = this.arrayUtilityService.clone(this.entityTypeDynamicFormElementFields);
    }
    /**
     * this function creates the actions depending
     * on the operations associated to a given entity type
     *
     * @param entityTypeOperations
     */
    getActionsFromEntityType(entityTypeOperations) {
        entityTypeOperations.forEach((operation) => {
            if (operation.guiSettings) {
                const guiSettingsObject = this.utilityService.guiSettingToObject(operation.guiSettings);
                guiSettingsObject.operation = operation;
                const baseAction = new BaseAction(guiSettingsObject);
                this.entityTypeDynamicFormElementActions.push(baseAction);
            }
        });
        this.entityTypeDynamicFormElementActions = this.arrayUtilityService.clone(this.entityTypeDynamicFormElementActions);
    }
}
PrgEntityTypeElementComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypeElementComponent, deps: [{ token: ArrayUtilityService }, { token: UtilityService }, { token: AbstractEntityTypeService }, { token: i2.DynamicDialogRef }, { token: i2.DynamicDialogConfig }, { token: ObjectsUtilityService }, { token: NotificationsService }, { token: i5.TranslateService }, { token: i1$1.Router }, { token: i1$1.ActivatedRoute }], target: i0.ɵɵFactoryTarget.Component });
PrgEntityTypeElementComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgEntityTypeElementComponent, selector: "prg-entity-type-element", inputs: { element: "element", entityType: "entityType", elementViewMode: "elementViewMode" }, ngImport: i0, template: "<div>\r\n  <prg-dynamic-form\r\n    [fields]=\"entityTypeDynamicFormElementFields\"\r\n    [actions]=\"entityTypeDynamicFormElementActions\"\r\n    [entity]=\"element\"\r\n    [viewMode]=\"elementViewMode\"\r\n    (actionOutput)=\"onActionOutputed($event)\"\r\n  ></prg-dynamic-form>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "component", type: PrgDynamicFormComponent, selector: "prg-dynamic-form", inputs: ["context", "fields", "actions", "entity", "viewMode", "formGroupType"], outputs: ["actionOutput", "fieldChangeOutput"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypeElementComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-entity-type-element', template: "<div>\r\n  <prg-dynamic-form\r\n    [fields]=\"entityTypeDynamicFormElementFields\"\r\n    [actions]=\"entityTypeDynamicFormElementActions\"\r\n    [entity]=\"element\"\r\n    [viewMode]=\"elementViewMode\"\r\n    (actionOutput)=\"onActionOutputed($event)\"\r\n  ></prg-dynamic-form>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: ArrayUtilityService }, { type: UtilityService }, { type: AbstractEntityTypeService }, { type: i2.DynamicDialogRef }, { type: i2.DynamicDialogConfig }, { type: ObjectsUtilityService }, { type: NotificationsService }, { type: i5.TranslateService }, { type: i1$1.Router }, { type: i1$1.ActivatedRoute }]; }, propDecorators: { element: [{
                type: Input
            }], entityType: [{
                type: Input
            }], elementViewMode: [{
                type: Input
            }] } });

/**
 * Default actions
 * This array contains the add, edit, save and cancel actions,
 * as well as the visibility expression for the logic of these actions
 */
const ACTIONS_BASE_STRUCTURE = {
    actions: [
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Add,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='add' || this.viewMode ==='read'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='read'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Save,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='edit'",
        }),
    ],
};

/**
 * Dynamic form fields configurations to Entity type Attribute
 */
const ENTITY_TYPE_ATTRIBUTE_DYNAMIC_FORM = {
    fields: [
        {
            controlName: ControlName.inputText,
            readonly: false,
            key: 'name',
            validators: [Validators.required],
        },
        {
            controlName: ControlName.inputText,
            readonly: false,
            key: 'guiSettings',
            validators: [Validators.required],
        },
        new SelectConfiguration({
            referenceType: ReferenceType.LookupTable,
            referenceName: 'dataType',
            readonly: false,
            key: 'dataTypeId',
            optionLabel: 'name',
            optionValue: 'id',
            validators: [Validators.required],
        }),
    ],
};

/**
 * Dynamic form fields and actions configurations to Entity type
 */
const ENTITY_TYPE_DYNAMIC_FORM = {
    fields: [
        new BaseField({
            controlName: ControlName.inputText,
            value: null,
            key: 'name',
            validators: [Validators.required],
            basePathTranslation: 'entity-type.fields',
        }),
        new BaseField({
            controlName: ControlName.inputText,
            value: null,
            key: 'guiSettings',
            validators: [Validators.required],
            basePathTranslation: 'entity-type.fields',
        }),
        new BaseField({
            controlName: ControlName.inputText,
            value: null,
            key: 'group',
            validators: [Validators.required],
            basePathTranslation: 'entity-type.fields',
        }),
        new BaseField({
            controlName: ControlName.inputText,
            visibleExpression: ' this.entity!= null && this.entity.id',
            value: '1',
            key: 'universalStateId',
            basePathTranslation: 'entity-type.fields',
        }),
    ],
    actions: [
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Save,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='read'",
        }),
    ],
};

/**
 * HttpVerb string enum
 */
var HttpVerb;
(function (HttpVerb) {
    HttpVerb["Get"] = "GET";
    HttpVerb["Post"] = "POST";
    HttpVerb["Put"] = "PUT";
    HttpVerb["Patch"] = "PATCH";
    HttpVerb["Delete"] = "DELETE";
})(HttpVerb || (HttpVerb = {}));
/**
 * EntityTypeProperty class that defines a dynamic
 * <br />property of an EntityType, which WILL BE
 * <br />COMPILED into the dll
 */
class EntityTypeProperty extends BaseEntity {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * this field is to indicate if
         * we are going to have an array of some type
         */
        this.isArray = false;
        Object.assign(this, init);
    }
}
/**
 * EntityTypeAttribute class that defines an
 * <br />attribute of an EntityType, which WILL NOT
 * <br />BE COMPILED into the dll
 */
class EntityTypeAttribute extends BaseEntity {
    /**constructor */
    constructor(init) {
        super();
        /**
         * this field is to indicate if
         * we are going to have an array of some type
         */
        this.isArray = false;
        Object.assign(this, init);
    }
}
/**
 * EntityTypeOperation class that defines a
 * <br />custom operation for an EntityType,
 * <br />which WILL BE COMPILED into the dll
 */
class EntityTypeOperation extends BaseEntity {
    /**constructor */
    constructor(init) {
        super();
        /**
         * Operation order
         */
        this.order = 0;
        Object.assign(this, init);
    }
}
/**
 * EntityTypeOperation class that defines a
 * <br />generic EntityType, its properties,
 * <br />attributes and operations
 */
class EntityType extends BaseEntity {
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}

/**
 * Dynamic form fields configurations to Entity type operation
 */
const ENTITY_TYPE_OPERATION_DYNAMIC_FORM = {
    fields: [
        {
            controlName: ControlName.inputText,
            value: null,
            readonly: false,
            key: 'name',
            validators: [Validators.required],
        },
        {
            controlName: ControlName.inputText,
            value: null,
            readonly: false,
            key: 'guiSettings',
            validators: [Validators.required],
        },
        new SelectConfiguration({
            controlName: ControlName.dropdown,
            value: null,
            readonly: false,
            key: 'httpVerb',
            options: [
                { value: HttpVerb.Get, label: 'get' },
                { value: HttpVerb.Post, label: 'post' },
                { value: HttpVerb.Delete, label: 'delete' },
                { value: HttpVerb.Put, label: 'put' },
                { value: HttpVerb.Patch, label: 'patch' },
            ],
            filter: true,
            validators: [Validators.required],
        }),
    ],
};

/**
 * Dynamic form fields configurations to Entity type property
 */
const ENTITY_TYPE_PROPERTY_DYNAMIC_FORM = {
    fields: [
        {
            controlName: ControlName.inputText,
            readonly: false,
            key: 'name',
            validators: [Validators.required],
            basePathTranslation: 'entity-type.properties.fields',
        },
        {
            controlName: ControlName.inputText,
            readonly: false,
            key: 'guiSettings',
            validators: [Validators.required],
            basePathTranslation: 'entity-type.properties.fields',
        },
        new SelectConfiguration({
            referenceType: ReferenceType.LookupTable,
            referenceName: 'dataType',
            readonly: false,
            key: 'dataTypeId',
            optionLabel: 'label',
            optionValue: 'id',
            validators: [Validators.required],
            basePathTranslation: 'entity-type.properties.fields',
        }),
        new CheckboxConfiguration({
            key: 'isArray',
            basePathTranslation: 'entity-type.properties.fields',
        }),
        new SelectConfiguration({
            referenceType: ReferenceType.LookupTable,
            readonly: false,
            key: 'reference',
            optionLabel: 'label',
            optionValue: 'name',
            visibleExpression: "this.form.get('dataTypeId').getRawValue() && this.form.get('dataTypeId').getRawValue().toLowerCase()==='datatype.lookuptable'",
        }),
        new SelectConfiguration({
            referenceType: ReferenceType.EntityType,
            readonly: false,
            key: 'reference',
            optionLabel: 'name',
            optionValue: 'name',
            visibleExpression: "this.form.get('dataTypeId').getRawValue() && this.form.get('dataTypeId').getRawValue().toLowerCase()==='datatype.entitytype'",
        }),
    ],
};

/**
 * class MenuTab
 */
class MenuTab {
    constructor() {
        /**
         * disabled
         */
        this.disabled = false;
    }
}
var MenuTabEntityType;
(function (MenuTabEntityType) {
    MenuTabEntityType["EntityTypeProperty"] = "EntityTypeProperty";
    MenuTabEntityType["EntityTypeAttribute"] = "EntityTypeAttribute";
    MenuTabEntityType["EntityTypeOperation"] = "EntityTypeOperation";
})(MenuTabEntityType || (MenuTabEntityType = {}));

/**
 * entity type configuration component
 */
class PrgEntityTypeConfigsComponent {
    /**
     * constructor
     * @param entityTypeService
     * @param config
     * @param ref
     * @param notificationsService
     * @param arrayUtilityService
     * @param objectsUtilityService
     * @param utilityService
     */
    constructor(entityTypeService, config, ref, notificationsService, arrayUtilityService, objectsUtilityService, utilityService) {
        this.entityTypeService = entityTypeService;
        this.config = config;
        this.ref = ref;
        this.notificationsService = notificationsService;
        this.arrayUtilityService = arrayUtilityService;
        this.objectsUtilityService = objectsUtilityService;
        this.utilityService = utilityService;
        /**
         * elements list (properties, attributes, operations)
         */
        this.elements = [];
        /**
         * element selected
         */
        this.elementsSelected = [];
        /**
         * entity type form fields
         */
        this.entityTypeDynamicFormFields = this.arrayUtilityService.clone(ENTITY_TYPE_DYNAMIC_FORM.fields);
        /**
         * entity type form actions
         */
        this.entityTypeDynamicFormActions = this.arrayUtilityService.clone(ENTITY_TYPE_DYNAMIC_FORM.actions);
        /**
         * elements form fields (default is fields from properties)
         */
        this.elementDynamicFormFields = this.arrayUtilityService.clone(ENTITY_TYPE_PROPERTY_DYNAMIC_FORM.fields);
        /**
         * elements form actions
         */
        this.elementDynamicFormActions = this.arrayUtilityService.clone(ACTIONS_BASE_STRUCTURE.actions);
        /**
         * entity type view mode
         */
        this.entityTypeViewMode = ViewMode.Read;
        /**
         * elements view mode
         */
        this.elementViewMode = ViewMode.Add;
        /**
         * diabled list
         */
        this.disabledList = false;
        /**
         * debounce time
         */
        this.debounceTime = 200;
        /**
         * this function is responsible for updating
         * the elements in the database when they have their order changed
         */
        this.reorderElements = this.utilityService.debounce(() => {
            let mapElements = new Map();
            for (let i = 0; i < this.elements.length; i++) {
                this.elements[i].order = i + 1;
                mapElements.set(this.elements[i].id, { order: this.elements[i].order });
            }
            switch (this.activeItem.type) {
                case MenuTabEntityType.EntityTypeProperty:
                    this.entityTypeService.updateEntityTypePropertiesAsync(mapElements);
                    break;
                case MenuTabEntityType.EntityTypeAttribute:
                    this.entityTypeService.updateEntityTypeAttributesAsync(mapElements);
                    break;
                default:
                    this.notificationsService.errorNotification(new PrgError({
                        titleKey: 'error',
                        detailKey: 'notUpdated',
                    }));
                    break;
            }
        }, this.debounceTime);
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.menuTabItems = [
            {
                label: 'properties',
                icon: 'pi pi-fw pi-pencil',
                type: MenuTabEntityType.EntityTypeProperty,
                disabled: false,
            },
            {
                label: 'attributes',
                icon: 'pi pi-fw pi-pencil',
                type: MenuTabEntityType.EntityTypeAttribute,
                disabled: false,
            },
            {
                label: 'operations',
                icon: 'pi pi-fw pi-pencil',
                type: MenuTabEntityType.EntityTypeOperation,
                disabled: false,
            },
        ];
        this.activeItem = this.menuTabItems[0];
        this.entityType = this.config.data.entityType;
        this.entityTypeViewMode = this.config.data.viewMode;
        if (!this.entityType.id) {
            this.menuTabsItemsManage(null);
        }
        this.loadElements();
    }
    /**
     * this function receives the event
     * when a new element is selected in the list
     * @param event
     * @returns
     */
    onSelectionChanged(event) {
        if (event.value == null) {
            return;
        }
        this.elementsSelected = [event.value[event.value.length - 1]];
        this.elementViewMode = ViewMode.Read;
    }
    /**
     * this function receives the output referring to the actions of an entity
     * type and in function of the received action performs the corresponding actions
     * @param event
     */
    async onEntityTypeActionOutputted(event) {
        this.menuTabsItemsManage(null);
        switch (event.action) {
            case BaseActionKey.Save:
                this.entityType = await this.entityTypeService.saveEntityTypeAsync(event.formEntity);
                this.menuTabsItemsManage(null, false);
                this.activeItem = this.menuTabItems[0];
                this.entityTypeViewMode = ViewMode.Read;
                break;
            case BaseActionKey.Cancel:
                this.entityTypeViewMode = ViewMode.Read;
                if (event.formEntity.id) {
                    this.entityType = this.objectsUtilityService.cloneObject(this.entityType);
                }
                else {
                    this.ref.close();
                }
                break;
            case BaseActionKey.Edit:
                this.entityTypeViewMode = ViewMode.Edit;
                break;
            default:
                break;
        }
    }
    /**
     * this function is responsible for receiving the changes from the selected tab and loading the respective data
     * @param event
     */
    tabChange(event) {
        this.activeItem = event;
        this.elementsSelected = [];
        this.elementViewMode = ViewMode.Add;
        this.loadElements();
    }
    /**
     * this function manages the status of the
     * tabs according to the parameters
     * it can activate or deactivate all tabs as well
     * as change the status of a single tab
     *
     * @param menuTabItem
     * @param status
     */
    menuTabsItemsManage(menuTabItem, status = true) {
        this.menuTabItems.forEach((item) => {
            item.disabled = status;
        });
        if (menuTabItem) {
            const item = this.menuTabItems.find((item) => (item.type = menuTabItem.type));
            item.disabled = true;
        }
        this.menuTabItems = this.arrayUtilityService.clone(this.menuTabItems);
        this.activeItem = this.menuTabItems.find((item) => item.type === this.activeItem.type);
    }
    /**
     * create empty element, depending on the tab selected
     */
    addNewElement() {
        let newElement = null;
        if (this.entityType && this.activeItem) {
            this.disabledList = true;
            switch (this.activeItem.type) {
                case MenuTabEntityType.EntityTypeProperty:
                    newElement = new EntityTypeProperty({
                        entityTypeId: this.entityType.id,
                        order: this.elements.length + 1,
                    });
                    break;
                case MenuTabEntityType.EntityTypeAttribute:
                    newElement = new EntityTypeAttribute({
                        entityTypeId: this.entityType.id,
                        order: this.elements.length + 1,
                    });
                    break;
                case MenuTabEntityType.EntityTypeOperation:
                    newElement = new EntityTypeOperation({
                        entityTypeId: this.entityType.id,
                    });
                    break;
                default:
                    this.notificationsService.errorNotification(new PrgError({
                        titleKey: 'error',
                        detailKey: 'cantFindEntity',
                    }));
                    break;
            }
        }
        // add element to elements to array
        this.elements.push(newElement);
        //this.elements = this.arrayUtilityService.clone(this.elements);
        this.elementsSelected = [this.elements[this.elements.length - 1]];
    }
    /**
     * this function loads the elements according to the tab selected,
     *  and changes the form's data
     */
    async loadElements() {
        if (this.entityType && this.activeItem) {
            switch (this.activeItem.type) {
                case MenuTabEntityType.EntityTypeProperty:
                    this.elementDynamicFormFields = this.arrayUtilityService.clone(ENTITY_TYPE_PROPERTY_DYNAMIC_FORM.fields);
                    this.elements = this.arrayUtilityService.sortByProperty(await this.entityTypeService.getAllPropertiesByEntityTypeIdAsync(this.entityType.id), 'order');
                    break;
                case MenuTabEntityType.EntityTypeAttribute:
                    this.elementDynamicFormFields = this.arrayUtilityService.clone(ENTITY_TYPE_ATTRIBUTE_DYNAMIC_FORM.fields);
                    this.elements = this.arrayUtilityService.sortByProperty(await this.entityTypeService.getAllAttributesByEntityTypeIdAsync(this.entityType.id), 'order');
                    break;
                case MenuTabEntityType.EntityTypeOperation:
                    this.elementDynamicFormFields = this.arrayUtilityService.clone(ENTITY_TYPE_OPERATION_DYNAMIC_FORM.fields);
                    this.elements =
                        await this.entityTypeService.getAllOperationsByEntityTypeIdAsync(this.entityType.id);
                    break;
                default:
                    this.notificationsService.errorNotification(new PrgError({
                        titleKey: 'error',
                        detailKey: 'cantAddNewElement',
                    }));
                    break;
            }
        }
    }
    /**
     * this function receives the output of an entity,
     * and treats each of the actions with the respective logic to be applied
     * @param event
     */
    onEntityActionOutputted(event) {
        switch (event.action) {
            case BaseActionKey.Save:
                this.saveNewElement(event.formEntity);
                this.menuTabsItemsManage(null, false);
                break;
            case BaseActionKey.Edit:
                this.disabledList = true;
                this.elementViewMode = ViewMode.Edit;
                this.menuTabsItemsManage(null, true);
                break;
            case BaseActionKey.Cancel:
                if (event.formEntity.id) {
                    this.elementsSelected = this.arrayUtilityService.clone(this.elementsSelected);
                    this.elementViewMode = ViewMode.Read;
                }
                else {
                    this.elementViewMode = ViewMode.Add;
                    this.elementsSelected = [];
                    this.elements.splice(this.elements.length - 1, 1);
                }
                this.disabledList = false;
                this.menuTabsItemsManage(null, false);
                break;
            case BaseActionKey.Add:
                this.menuTabsItemsManage(null, true);
                this.elementViewMode = ViewMode.Edit;
                this.addNewElement();
                break;
            default:
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'error',
                    detailKey: 'actionNotFound',
                }));
                break;
        }
    }
    /**
     * this function is responsible for saving the new element added,
     * depending on the selected tab it calls the respective method
     * @param newElement
     */
    async saveNewElement(newElement) {
        let addedElement;
        switch (this.activeItem.type) {
            case MenuTabEntityType.EntityTypeProperty:
                addedElement = await this.entityTypeService.saveEntityTypePropertyAsync(newElement);
                break;
            case MenuTabEntityType.EntityTypeAttribute:
                addedElement =
                    await this.entityTypeService.saveEntityTypeAttributeAsync(newElement);
                break;
            case MenuTabEntityType.EntityTypeOperation:
                addedElement =
                    await this.entityTypeService.saveEntityTypeOperationAsync(newElement);
                break;
            default:
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'error',
                    detailKey: 'tabNotFound',
                }));
                break;
        }
        if (!newElement.id) {
            this.elements.splice(this.elements.length - 1, 1);
        }
        this.elementViewMode = ViewMode.Read;
        this.elementsSelected = [];
        this.disabledList = false;
        await this.loadElements();
        const elementAux = this.elements.find((element) => element.id === addedElement.id);
        this.elementsSelected = [elementAux];
    }
}
PrgEntityTypeConfigsComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypeConfigsComponent, deps: [{ token: AbstractEntityTypeService }, { token: i2.DynamicDialogConfig }, { token: i2.DynamicDialogRef }, { token: NotificationsService }, { token: ArrayUtilityService }, { token: ObjectsUtilityService }, { token: UtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgEntityTypeConfigsComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgEntityTypeConfigsComponent, selector: "prg-entity-type-configs", ngImport: i0, template: "<div>\r\n  <prg-dynamic-form\r\n    [fields]=\"entityTypeDynamicFormFields\"\r\n    [actions]=\"entityTypeDynamicFormActions\"\r\n    [entity]=\"entityType\"\r\n    [viewMode]=\"entityTypeViewMode\"\r\n    (actionOutput)=\"onEntityTypeActionOutputted($event)\"\r\n  ></prg-dynamic-form>\r\n\r\n  <p-tabMenu\r\n    [model]=\"menuTabItems\"\r\n    [activeItem]=\"activeItem\"\r\n    styleClass=\"p-tabmenu-nav\"\r\n  >\r\n    <ng-template pTemplate=\"item\" let-item let-i=\"index\">\r\n      <div (click)=\"!item.disabled && tabChange(item)\">\r\n        <i [class]=\"item.icon\"></i>\r\n        {{ 'entity-type.tabs.' + item.label + '.label' | translate }}\r\n      </div>\r\n    </ng-template>\r\n  </p-tabMenu>\r\n\r\n  <p-splitter\r\n    *ngIf=\"entityType.id\"\r\n    [style]=\"{ height: '300px' }\"\r\n    [panelSizes]=\"[30, 70]\"\r\n    [minSizes]=\"[20, 40]\"\r\n  >\r\n    <ng-template pTemplate>\r\n      <p-orderList\r\n        *ngIf=\"elements.length > 0\"\r\n        [value]=\"elements\"\r\n        [disabled]=\"disabledList\"\r\n        [selection]=\"elementsSelected\"\r\n        (onSelectionChange)=\"onSelectionChanged($event)\"\r\n        filterBy=\"name\"\r\n        [dragdrop]=\"true\"\r\n        styleClass=\"p-tabmenu-nav\"\r\n        (onReorder)=\"reorderElements($event)\"\r\n      >\r\n        <ng-template let-element pTemplate=\"list\">\r\n          <div>\r\n            <div>\r\n              {{\r\n                element.id != null\r\n                  ? ('entities.' +\r\n                      entityType.name +\r\n                      '.fields.' +\r\n                      element.name +\r\n                      '.label' | translate)\r\n                  : ('entity.new.' + activeItem.type.toLowerCase() | translate)\r\n              }}\r\n            </div>\r\n          </div>\r\n        </ng-template>\r\n      </p-orderList></ng-template\r\n    >\r\n    <ng-template pTemplate=\"dynamicForm\">\r\n      <div>\r\n        <prg-dynamic-form\r\n          [fields]=\"elementDynamicFormFields\"\r\n          [actions]=\"elementDynamicFormActions\"\r\n          [entity]=\"elementsSelected.length ? elementsSelected[0] : null\"\r\n          [viewMode]=\"elementViewMode\"\r\n          (actionOutput)=\"onEntityActionOutputted($event)\"\r\n        ></prg-dynamic-form>\r\n      </div>\r\n    </ng-template>\r\n  </p-splitter>\r\n</div>\r\n", styles: [":host ::ng-deep .p-tabmenu-nav{width:-moz-fit-content!important;width:fit-content!important;margin:auto!important}\n"], dependencies: [{ kind: "directive", type: i7.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i9$2.Splitter, selector: "p-splitter", inputs: ["styleClass", "panelStyleClass", "style", "panelStyle", "stateStorage", "stateKey", "layout", "gutterSize", "minSizes", "panelSizes"], outputs: ["onResizeEnd", "onResizeStart"] }, { kind: "component", type: i6$2.TabMenu, selector: "p-tabMenu", inputs: ["model", "activeItem", "scrollable", "popup", "style", "styleClass"] }, { kind: "component", type: i11$1.OrderList, selector: "p-orderList", inputs: ["header", "style", "styleClass", "listStyle", "responsive", "filterBy", "filterPlaceholder", "filterLocale", "metaKeySelection", "dragdrop", "controlsPosition", "ariaFilterLabel", "filterMatchMode", "breakpoint", "stripedRows", "disabled", "trackBy", "selection", "value"], outputs: ["selectionChange", "onReorder", "onSelectionChange", "onFilterEvent"] }, { kind: "component", type: PrgDynamicFormComponent, selector: "prg-dynamic-form", inputs: ["context", "fields", "actions", "entity", "viewMode", "formGroupType"], outputs: ["actionOutput", "fieldChangeOutput"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypeConfigsComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-entity-type-configs', template: "<div>\r\n  <prg-dynamic-form\r\n    [fields]=\"entityTypeDynamicFormFields\"\r\n    [actions]=\"entityTypeDynamicFormActions\"\r\n    [entity]=\"entityType\"\r\n    [viewMode]=\"entityTypeViewMode\"\r\n    (actionOutput)=\"onEntityTypeActionOutputted($event)\"\r\n  ></prg-dynamic-form>\r\n\r\n  <p-tabMenu\r\n    [model]=\"menuTabItems\"\r\n    [activeItem]=\"activeItem\"\r\n    styleClass=\"p-tabmenu-nav\"\r\n  >\r\n    <ng-template pTemplate=\"item\" let-item let-i=\"index\">\r\n      <div (click)=\"!item.disabled && tabChange(item)\">\r\n        <i [class]=\"item.icon\"></i>\r\n        {{ 'entity-type.tabs.' + item.label + '.label' | translate }}\r\n      </div>\r\n    </ng-template>\r\n  </p-tabMenu>\r\n\r\n  <p-splitter\r\n    *ngIf=\"entityType.id\"\r\n    [style]=\"{ height: '300px' }\"\r\n    [panelSizes]=\"[30, 70]\"\r\n    [minSizes]=\"[20, 40]\"\r\n  >\r\n    <ng-template pTemplate>\r\n      <p-orderList\r\n        *ngIf=\"elements.length > 0\"\r\n        [value]=\"elements\"\r\n        [disabled]=\"disabledList\"\r\n        [selection]=\"elementsSelected\"\r\n        (onSelectionChange)=\"onSelectionChanged($event)\"\r\n        filterBy=\"name\"\r\n        [dragdrop]=\"true\"\r\n        styleClass=\"p-tabmenu-nav\"\r\n        (onReorder)=\"reorderElements($event)\"\r\n      >\r\n        <ng-template let-element pTemplate=\"list\">\r\n          <div>\r\n            <div>\r\n              {{\r\n                element.id != null\r\n                  ? ('entities.' +\r\n                      entityType.name +\r\n                      '.fields.' +\r\n                      element.name +\r\n                      '.label' | translate)\r\n                  : ('entity.new.' + activeItem.type.toLowerCase() | translate)\r\n              }}\r\n            </div>\r\n          </div>\r\n        </ng-template>\r\n      </p-orderList></ng-template\r\n    >\r\n    <ng-template pTemplate=\"dynamicForm\">\r\n      <div>\r\n        <prg-dynamic-form\r\n          [fields]=\"elementDynamicFormFields\"\r\n          [actions]=\"elementDynamicFormActions\"\r\n          [entity]=\"elementsSelected.length ? elementsSelected[0] : null\"\r\n          [viewMode]=\"elementViewMode\"\r\n          (actionOutput)=\"onEntityActionOutputted($event)\"\r\n        ></prg-dynamic-form>\r\n      </div>\r\n    </ng-template>\r\n  </p-splitter>\r\n</div>\r\n", styles: [":host ::ng-deep .p-tabmenu-nav{width:-moz-fit-content!important;width:fit-content!important;margin:auto!important}\n"] }]
        }], ctorParameters: function () { return [{ type: AbstractEntityTypeService }, { type: i2.DynamicDialogConfig }, { type: i2.DynamicDialogRef }, { type: NotificationsService }, { type: ArrayUtilityService }, { type: ObjectsUtilityService }, { type: UtilityService }]; } });

/**
 * entity type component
 */
class PrgEntityTypeComponent {
}
PrgEntityTypeComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypeComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgEntityTypeComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgEntityTypeComponent, selector: "prg-entity-type", ngImport: i0, template: "<div>\r\n  <prg-entity-type-configs></prg-entity-type-configs>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "component", type: PrgEntityTypeConfigsComponent, selector: "prg-entity-type-configs" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypeComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-entity-type', template: "<div>\r\n  <prg-entity-type-configs></prg-entity-type-configs>\r\n</div>\r\n" }]
        }] });

/**
 * component List entity types
 */
/**
 * class PrgListEntityTypesComponent
 */
class PrgListEntityTypesComponent {
    /**
     * constructor
     * @param entityTypeService
     * @param arrayUtilityService
     * @param prgEntityTypesConfig
     * @param dialogService dialogService
     * @param objectsUtilityService
     */
    constructor(entityTypeService, arrayUtilityService, prgEntityTypesConfig, dialogService, objectsUtilityService) {
        this.entityTypeService = entityTypeService;
        this.arrayUtilityService = arrayUtilityService;
        this.prgEntityTypesConfig = prgEntityTypesConfig;
        this.dialogService = dialogService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * table columns
         */
        this.tableEntityTypeColumns = this.prgEntityTypesConfig.entityTypeTableColumns;
        /**
         * subscriptions
         */
        this.subscriptions = [];
        /**
         * property name to group
         */
        this.GROUP_BY_PROPERTY_NAME = 'group';
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.entityTypeService.getEntityTypeListAsync().then(() => {
            this.subscriptions.push(this.entityTypeService
                .getElementObservableByKey('product')
                .subscribe((value) => { }));
        });
        this.subscriptions.push(this.entityTypeService
            .getElementsListObservable()
            .subscribe((entityTypeList) => {
            this.treeData = this.arrayUtilityService.groupByField(entityTypeList, this.GROUP_BY_PROPERTY_NAME);
        }));
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.subscriptions.forEach((subscription) => {
            subscription.unsubscribe();
        });
        this.subscriptions = [];
    }
    /**
     * this function is responsible for generating and sending the necessary data to the dialog
     * @param entityType
     */
    showEntityTypeData(entityType) {
        let entityTypeAux;
        if (entityType) {
            entityTypeAux = this.objectsUtilityService.cloneObject(entityType);
        }
        else {
            entityTypeAux = new EntityType();
        }
        this.ref = this.dialogService.open(PrgEntityTypeComponent, {
            data: {
                entityType: entityTypeAux,
                viewMode: entityTypeAux.id ? ViewMode.Read : ViewMode.Edit,
            },
            width: '90vw',
            showHeader: true,
            contentStyle: { 'max-height': '70%', overflow: 'auto' },
            baseZIndex: 10000,
            //dismissableMask: true,
        });
    }
}
PrgListEntityTypesComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgListEntityTypesComponent, deps: [{ token: AbstractEntityTypeService }, { token: ArrayUtilityService }, { token: PRG_ENTITY_TYPES_CONFIG }, { token: i2.DialogService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgListEntityTypesComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgListEntityTypesComponent, selector: "prg-list-entity-types", providers: [DialogService], ngImport: i0, template: "<div>\r\n  <p-button\r\n    [label]=\"'buttons.add.label' | translate\"\r\n    (click)=\"showEntityTypeData(null)\"\r\n  ></p-button>\r\n\r\n  <p-treeTable [value]=\"treeData\">\r\n    <ng-template pTemplate=\"header\">\r\n      <tr>\r\n        <th *ngFor=\"let col of tableEntityTypeColumns\">\r\n          {{ 'entity-type.fields.' + col.key + '.label' | translate }}\r\n        </th>\r\n      </tr>\r\n    </ng-template>\r\n    <ng-template pTemplate=\"body\" let-rowNode let-rowData=\"rowData\">\r\n      <tr\r\n        [ttRow]=\"rowNode\"\r\n        (click)=\"rowNode.level !== 0 && showEntityTypeData(rowData)\"\r\n        [ngClass]=\"{ clickableRow: rowNode.level !== 0 }\"\r\n      >\r\n        <td *ngFor=\"let col of tableEntityTypeColumns; let i = index\">\r\n          <p-treeTableToggler\r\n            *ngIf=\"i == 0\"\r\n            [rowNode]=\"rowNode\"\r\n          ></p-treeTableToggler>\r\n          <ng-container *ngIf=\"col.key === 'name'; else elseBlock\">\r\n            {{\r\n              (rowNode.level == 0 ? 'entity-type.groups.' : 'entities.') +\r\n                rowData[col.key].toLowerCase() +\r\n                '.label' | translate\r\n            }}\r\n          </ng-container>\r\n          <ng-template #elseBlock> {{ rowData[col.key] }} </ng-template>\r\n        </td>\r\n      </tr>\r\n    </ng-template>\r\n  </p-treeTable>\r\n</div>\r\n", styles: [".clickableRow{cursor:pointer}.clickableRow:hover{background-color:#cbf6f6}body .p-orderlist-controls{display:none!important}\n"], dependencies: [{ kind: "directive", type: i7.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i8.Button, selector: "p-button", inputs: ["type", "iconPos", "icon", "badge", "label", "disabled", "loading", "loadingIcon", "style", "styleClass", "badgeClass", "ariaLabel"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "component", type: i10$1.TreeTable, selector: "p-treeTable", inputs: ["columns", "style", "styleClass", "tableStyle", "tableStyleClass", "autoLayout", "lazy", "lazyLoadOnInit", "paginator", "rows", "first", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "customSort", "selectionMode", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "compareSelectionBy", "rowHover", "loading", "loadingIcon", "showLoader", "scrollable", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "frozenColumns", "resizableColumns", "columnResizeMode", "reorderableColumns", "contextMenu", "rowTrackBy", "filters", "globalFilterFields", "filterDelay", "filterMode", "filterLocale", "virtualRowHeight", "value", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection"], outputs: ["selectionChange", "contextMenuSelectionChange", "onFilter", "onNodeExpand", "onNodeCollapse", "onPage", "onSort", "onLazyLoad", "sortFunction", "onColResize", "onColReorder", "onNodeSelect", "onNodeUnselect", "onContextMenuSelect", "onHeaderCheckboxToggle", "onEditInit", "onEditComplete", "onEditCancel"] }, { kind: "component", type: i10$1.TreeTableToggler, selector: "p-treeTableToggler", inputs: ["rowNode"] }, { kind: "directive", type: i10$1.TTRow, selector: "[ttRow]", inputs: ["ttRow"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgListEntityTypesComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-list-entity-types', providers: [DialogService], template: "<div>\r\n  <p-button\r\n    [label]=\"'buttons.add.label' | translate\"\r\n    (click)=\"showEntityTypeData(null)\"\r\n  ></p-button>\r\n\r\n  <p-treeTable [value]=\"treeData\">\r\n    <ng-template pTemplate=\"header\">\r\n      <tr>\r\n        <th *ngFor=\"let col of tableEntityTypeColumns\">\r\n          {{ 'entity-type.fields.' + col.key + '.label' | translate }}\r\n        </th>\r\n      </tr>\r\n    </ng-template>\r\n    <ng-template pTemplate=\"body\" let-rowNode let-rowData=\"rowData\">\r\n      <tr\r\n        [ttRow]=\"rowNode\"\r\n        (click)=\"rowNode.level !== 0 && showEntityTypeData(rowData)\"\r\n        [ngClass]=\"{ clickableRow: rowNode.level !== 0 }\"\r\n      >\r\n        <td *ngFor=\"let col of tableEntityTypeColumns; let i = index\">\r\n          <p-treeTableToggler\r\n            *ngIf=\"i == 0\"\r\n            [rowNode]=\"rowNode\"\r\n          ></p-treeTableToggler>\r\n          <ng-container *ngIf=\"col.key === 'name'; else elseBlock\">\r\n            {{\r\n              (rowNode.level == 0 ? 'entity-type.groups.' : 'entities.') +\r\n                rowData[col.key].toLowerCase() +\r\n                '.label' | translate\r\n            }}\r\n          </ng-container>\r\n          <ng-template #elseBlock> {{ rowData[col.key] }} </ng-template>\r\n        </td>\r\n      </tr>\r\n    </ng-template>\r\n  </p-treeTable>\r\n</div>\r\n", styles: [".clickableRow{cursor:pointer}.clickableRow:hover{background-color:#cbf6f6}body .p-orderlist-controls{display:none!important}\n"] }]
        }], ctorParameters: function () { return [{ type: AbstractEntityTypeService }, { type: ArrayUtilityService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ENTITY_TYPES_CONFIG]
                }] }, { type: i2.DialogService }, { type: ObjectsUtilityService }]; } });

/**
 * Injectable
 */
/**
 * PrimengUtilityService
 */
class PrimengUtilityService {
    /**
     * this function is to calculate the index of the page we need to request
     * @param event
     * @returns
     */
    calcPageIndex(event) {
        let pageIndex = 0;
        if (event.first != 0) {
            pageIndex = event.first / event.rows;
        }
        return pageIndex;
    }
    /**
     * this function processes the filters coming from
     * the event thrown by primeng and returns
     *  a working filter array to our api
     * @param filters
     * @param globalFilterFields
     * @param globalFilterExpression
     * @returns Filter[]
     */
    filtersProcessing(filters, globalFilterFields, globalFilterExpression) {
        let filtersArray = [];
        const filtersKeys = Object.keys(filters);
        if (filtersKeys.includes('global')) {
            globalFilterFields.forEach((globalFilterField) => {
                filtersArray.push(this.generateFilter(filters['global'].value, globalFilterField, globalFilterExpression, MapPrimeNgFilterOperationsToFilterOperations.get(filters['global'].matchMode)));
            });
        }
        else {
            filtersKeys.forEach((key) => {
                Object.keys(filters[key]).forEach((keySubFilter) => {
                    let eventFilter = filters[key][keySubFilter];
                    if (eventFilter.value) {
                        filtersArray.push(this.generateFilter(eventFilter.value, key, MapPrimeNgExpressionsToFilterExpressions.get(eventFilter.operator), MapPrimeNgFilterOperationsToFilterOperations.get(eventFilter.matchMode)));
                    }
                });
            });
        }
        return filtersArray;
    }
    /**
     * this function creates a filter with the received parameters
     * @param filterValue
     * @param propertyName
     * @param filterExpression
     * @param filterOperation
     * @returns
     */
    generateFilter(filterValue, propertyName, filterExpression, filterOperation) {
        let filter = new Filter();
        filter.value = filterValue;
        filter.propertyName = propertyName;
        filter.filterExpression = filterExpression;
        filter.filterOperation = filterOperation;
        return filter;
    }
    /**
     * this function processes the sort from the primeng
     * event and returns a functional order array to our api
     *
     * @param multiSortMeta
     * @param sortField
     * @param sortOrder
     * @returns Order[]
     */
    sortProcessing(multiSortMeta, sortField, sortOrder) {
        let filterOrders = [];
        if (multiSortMeta) {
            multiSortMeta.forEach((sortElement) => {
                filterOrders.push(new Order({
                    propertyName: sortElement.field,
                    orderType: PrimeNgSortToOrderTypeMap.get(sortElement.order),
                }));
            });
        }
        else {
            filterOrders.push(new Order({
                propertyName: sortField,
                orderType: PrimeNgSortToOrderTypeMap.get(sortOrder),
            }));
        }
        return filterOrders;
    }
    /**
     * this function receives the event from primeng and returns
     * the filtergroup with all the necessary information to be used by our api
     * @param event
     * @param globalFilterFields
     * @param globalFilterExpression
     * @returns FilterGroup
     */
    getFilterGroupByLazyLoadEvent(event, globalFilterFields = [], globalFilterExpression = FilterExpressions.Or) {
        let filterGroup = new FilterGroup();
        filterGroup.pageIndex = this.calcPageIndex(event);
        filterGroup.pageSize = event.rows;
        if (event.sortField || event.multiSortMeta) {
            filterGroup.orderCollection = this.sortProcessing(event.multiSortMeta, event.sortField, event.sortOrder);
        }
        if (event.filters != null && Object.keys(event.filters).length) {
            filterGroup.filterCollections = this.filtersProcessing(event.filters, globalFilterFields, globalFilterExpression);
        }
        return filterGroup;
    }
}
PrimengUtilityService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrimengUtilityService, deps: [], target: i0.ɵɵFactoryTarget.Injectable });
PrimengUtilityService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrimengUtilityService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrimengUtilityService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }] });

/**
 * list specific entity type elemens
 */
/**
 * PrgListSpecificEntityTypeComponent
 */
class PrgListSpecificEntityTypeComponent {
    /**
     * constructor
     *
     * @param entityTypeService
     * @param lookupTableService
     * @param dialogService
     * @param prgEntityTypesConfig
     * @param primengUtilityService
     * @param translateService
     * @param router
     */
    constructor(entityTypeService, dialogService, prgEntityTypesConfig, primengUtilityService, translateService, router) {
        this.entityTypeService = entityTypeService;
        this.dialogService = dialogService;
        this.prgEntityTypesConfig = prgEntityTypesConfig;
        this.primengUtilityService = primengUtilityService;
        this.translateService = translateService;
        this.router = router;
        this.onClickGoTo = null;
        /**
         * entity type elemens
         */
        this.entityTypeAllElements = [];
        /**
         * auxiliar primeNgTypeToOurTypes enum
         */
        this.primeNgTypeToOurTypes = PrimeNgTypeToOurTypes;
        /**
         * auxiliar ReferenceType enum
         */
        this.ReferenceType = ReferenceType;
        /**
         * selected columns objects data
         */
        this.selectedColumnsObject = [];
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         */
        this.subscription = [];
        /**
         * glabal filter is active
         */
        this.globalFilterIsActive = false;
        /**
         * global filtar diabled
         */
        this.globalFilterDisabled = false;
    }
    /**
     * ngOnInit
     */
    async ngOnInit() {
        this.tableConfigs = this.prgEntityTypesConfig.specificEntityTypeListConfigs;
        this.entityType = await this.entityTypeService.getAllEntityTypeDataByName(this.entityTypeName);
        this.columnsSelectedLabel = await this.translateService
            .get('primeng.columns-selected')
            .toPromise();
        this.groupPropertyAndAttributesToColumnsSelect();
        this.getColumnsData();
        this.loading = true;
    }
    /**
     * ngOnDestroy
     *
     * Unsubscribe all subscriptions
     */
    ngOnDestroy() {
        this.subscription.forEach((subscription) => {
            subscription.unsubscribe();
        });
        this.subscription = [];
    }
    /**
     * this function is executed every time
     * there is a change in the table's settings (pagination filters, etc)
     * @param event
     */
    async lazyLoadElements(event) {
        if (event.globalFilter) {
            this.globalFilterIsActive = true;
        }
        else {
            this.globalFilterIsActive = false;
        }
        if (this.checkIfHaveColumnFilter(event.filters)) {
            this.globalFilterValue = '';
            this.globalFilterDisabled = true;
        }
        else {
            this.globalFilterDisabled = false;
        }
        this.createFilterGroup(event);
        this.getTableData();
    }
    /**
     * this function make an reset to table
     */
    clearAllFilters() {
        this.dataTableComponent.reset();
    }
    /**
     * open popup to edit or create an element
     * @param element
     */
    editElement(event, onPopup, element) {
        if (onPopup) {
            event.stopPropagation();
            this.elementOnPopUp(element, ViewMode.Read);
        }
        else {
            if (this.onClickGoTo) {
                this.router.navigate([this.onClickGoTo, element.id]);
            }
            else {
                this.router.navigate([this.router.url, element.id]);
            }
        }
    }
    /**
     * this function is responsible for opening the popup or
     * redirect to the page to be created a new element
     */
    addNewElement(onPopup) {
        if (onPopup) {
            this.elementOnPopUp({}, ViewMode.Edit);
        }
        else {
            this.router.navigate([this.router.url, 'new']);
        }
    }
    /**
     * this function is used when we have a custom filter,
     * and the value is a lookuptable, when we click on apply
     * we don't have the value set in the filters,
     * and I do this setter here, it just allows to have a search(not add option a and b)
     * @param value
     * @param field
     * @param matchMode
     */
    lookupTableFilterChange(value, field, matchMode) {
        let operator = 'and';
        const filterAux = this.dataTableComponent.filters[field];
        if (filterAux) {
            operator = filterAux[0].operator;
        }
        this.dataTableComponent.filters[field] = [
            { value: value, matchMode: matchMode, operator: operator },
        ];
    }
    /**
     * get columns object by columns name in table configs
     */
    getColumnsData() {
        this.tableConfigs.defaultColumns.forEach((col) => {
            let field = this.entityType.properties.find((property) => property.name === col);
            if (!field) {
                field = this.entityType.attributes.find((attribute) => attribute.name === col);
            }
            if (field) {
                this.selectedColumnsObject.push(field);
            }
        });
    }
    /**
     * create multiselect groups
     */
    groupPropertyAndAttributesToColumnsSelect() {
        this.entityGroups = [
            {
                label: 'Properties',
                value: 'properties',
                items: this.entityType.properties,
            },
            // {
            //   label: 'Attributes',
            //   value: 'attributes',
            //   items: this.entityType.attributes,
            // },
        ];
    }
    /**
     * this function makes the request to get the data to be showed in the table
     */
    async getTableData() {
        const paginationResponse = await this.entityTypeService.getEntityTypeElements(this.entityTypeName, this.filterGroup);
        this.entityTypeAllElements = paginationResponse.items;
        this.totalRecords = paginationResponse.totalItems;
        this.loading = false;
    }
    /**
     * this is an auxiliary function to check
     * if any of the table's filters are active
     * @param filters
     * @returns
     */
    checkIfHaveColumnFilter(filters) {
        let filtersKeys = Object.keys(filters);
        let findValue = false;
        if (filtersKeys.length) {
            let index = filtersKeys.indexOf('global');
            if (index !== -1) {
                filtersKeys.splice(index, 1);
            }
            filtersKeys.forEach((filterKey) => {
                if (filters[filterKey][0].value) {
                    findValue = true;
                }
            });
            return findValue;
        }
        else {
            return false;
        }
    }
    /**
     * this function calls the service that receives
     * the event (LazyLoadEvent) and creates a filterGroup
     * @param event
     * @returns
     */
    createFilterGroup(event) {
        this.filterGroup = this.primengUtilityService.getFilterGroupByLazyLoadEvent(event, this.tableConfigs.globalFilterFields);
    }
    /**
     * this function is responsible for creating
     *  the popup to edit or add an element
     * @param element
     * @param viewMode
     */
    elementOnPopUp(element, viewMode) {
        this.elementRef = this.dialogService.open(PrgEntityTypeElementComponent, {
            data: {
                element: element,
                entityType: this.entityType,
                viewMode: viewMode,
            },
            width: '90vw',
            showHeader: true,
            contentStyle: { 'max-height': '70%', overflow: 'auto' },
            dismissableMask: true,
        });
        this.subscription.push(this.elementRef.onClose.subscribe((data) => {
            if (data) {
                if (data.reloadData) {
                    this.getTableData();
                }
                else if (data.resetTable) {
                    this.dataTableComponent.reset();
                }
            }
            this.elementRef.destroy();
        }));
    }
}
PrgListSpecificEntityTypeComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgListSpecificEntityTypeComponent, deps: [{ token: AbstractEntityTypeService }, { token: i2.DialogService }, { token: PRG_ENTITY_TYPES_CONFIG }, { token: PrimengUtilityService }, { token: i5.TranslateService }, { token: i1$1.Router }], target: i0.ɵɵFactoryTarget.Component });
PrgListSpecificEntityTypeComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgListSpecificEntityTypeComponent, selector: "prg-list-specific-entity-type", inputs: { entityTypeName: "entityTypeName", onClickGoTo: "onClickGoTo" }, providers: [DialogService, ConfirmationService], viewQueries: [{ propertyName: "dataTableComponent", first: true, predicate: Table, descendants: true }], ngImport: i0, template: "<div>\r\n  <p-table\r\n    #dataTableComponent\r\n    [value]=\"entityTypeAllElements\"\r\n    [lazy]=\"true\"\r\n    (onLazyLoad)=\"lazyLoadElements($event)\"\r\n    [columns]=\"selectedColumnsObject\"\r\n    [paginator]=\"true\"\r\n    [rows]=\"tableConfigs.pagination.totalRows\"\r\n    [totalRecords]=\"totalRecords\"\r\n    [rowsPerPageOptions]=\"tableConfigs.pagination.rowsPerPageOptions\"\r\n    [reorderableColumns]=\"true\"\r\n    [globalFilterFields]=\"['name']\"\r\n    [filterDelay]=\"1000\"\r\n    [sortMode]=\"'multiple'\"\r\n    [multiSortMeta]=\"tableConfigs.multiSortMeta\"\r\n    responsiveLayout=\"scroll\"\r\n  >\r\n    <ng-template pTemplate=\"caption\">\r\n      <div style=\"text-align: left\">\r\n        <p-button\r\n          [label]=\"'buttons.add.label' | translate\"\r\n          (click)=\"addNewElement(false)\"\r\n        ></p-button>\r\n        <p-multiSelect\r\n          [options]=\"entityGroups\"\r\n          [group]=\"true\"\r\n          [(ngModel)]=\"selectedColumnsObject\"\r\n          scrollHeight=\"250px\"\r\n          optionLabel=\"name\"\r\n          [maxSelectedLabels]=\"1\"\r\n          selectedItemsLabel=\"{0} {{ columnsSelectedLabel }}\"\r\n        >\r\n          <ng-template let-group pTemplate=\"group\">\r\n            <div *ngIf=\"group.items.length\" class=\"flex align-items-center\">\r\n              <span>\r\n                {{ 'entity-type.tabs.' + group.value + '.label' | translate }}\r\n              </span>\r\n            </div>\r\n          </ng-template>\r\n        </p-multiSelect>\r\n        <!--we are calling this function on the input to trigger the lazy load function-->\r\n        <span class=\"p-input-icon-left ml-auto\">\r\n          <i class=\"pi pi-search\"></i>\r\n          <input\r\n            pInputText\r\n            type=\"text\"\r\n            (input)=\"\r\n              dataTableComponent.filterGlobal(\r\n                $any($event).target.value,\r\n                'contains'\r\n              )\r\n            \"\r\n            [ngModel]=\"globalFilterValue\"\r\n            [disabled]=\"globalFilterDisabled\"\r\n            placeholder=\"{{\r\n              'components.entity-type.global-search.placeholder' | translate\r\n            }}\"\r\n          />\r\n        </span>\r\n        <button\r\n          pButton\r\n          label=\"{{ 'buttons.reset-table.label' | translate }}\"\r\n          class=\"p-button-outlined\"\r\n          icon=\"pi pi-filter-slash\"\r\n          (click)=\"clearAllFilters()\"\r\n        ></button>\r\n      </div>\r\n    </ng-template>\r\n    <ng-template pTemplate=\"header\" let-columns>\r\n      <tr>\r\n        <th style=\"width: 2rem\">\r\n          <p-button\r\n            type=\"button\"\r\n            icon=\"pi pi-plus-circle\"\r\n            pAddRow\r\n            (click)=\"addNewElement(true)\"\r\n          ></p-button>\r\n        </th>\r\n        <ng-container *ngFor=\"let col of selectedColumnsObject\">\r\n          <th [pSortableColumn]=\"col.name\" pReorderableColumn>\r\n            {{\r\n              'entities.' + entityType.name + '.fields.' + col.name + '.label'\r\n                | translate\r\n            }}\r\n            <p-sortIcon [field]=\"col.name\"></p-sortIcon>\r\n            <p-columnFilter\r\n              [hidden]=\"globalFilterIsActive\"\r\n              [type]=\"primeNgTypeToOurTypes[col.dataTypeId]\"\r\n              [field]=\"col.name\"\r\n              [matchMode]=\"\r\n                col.dataTypeId === 'dataType.lookupTable' ? 'equals' : null\r\n              \"\r\n              display=\"menu\"\r\n              [showAddButton]=\"\r\n                col.dataTypeId === 'dataType.lookupTable' ? false : true\r\n              \"\r\n            >\r\n              <ng-template\r\n                *ngIf=\"col.dataTypeId === 'dataType.lookupTable'\"\r\n                pTemplate=\"filter\"\r\n                let-value\r\n                let-filter=\"filterCallback\"\r\n              >\r\n                <p-dropdown\r\n                  [setSelectConfigs]=\"{\r\n                    readonly: false,\r\n                    optionLabel: 'label',\r\n                    optionValue: 'id',\r\n                    key: col.name,\r\n                    value: dataTableComponent.filters[col.name][0].value,\r\n                    referenceType: ReferenceType.LookupTable,\r\n                    referenceName: col.reference\r\n                  }\"\r\n                  (onChange)=\"\r\n                    lookupTableFilterChange($event.value, col.name, 'equals')\r\n                  \"\r\n                  placeholder=\"Select any\"\r\n                >\r\n                </p-dropdown>\r\n              </ng-template>\r\n            </p-columnFilter>\r\n          </th>\r\n        </ng-container>\r\n      </tr>\r\n    </ng-template>\r\n    <ng-template pTemplate=\"body\" let-element>\r\n      <tr style=\"cursor: pointer\" (click)=\"editElement($event, false, element)\">\r\n        <td>\r\n          <i class=\"pi pi-eye\" (click)=\"editElement($event, true, element)\"></i>\r\n        </td>\r\n        <td *ngFor=\"let col of selectedColumnsObject; let i = index\">\r\n          <ng-container [ngSwitch]=\"col.dataTypeId\">\r\n            <p *ngSwitchCase=\"'dataType.lookupTable'\">\r\n              <p-dropdown\r\n                [setSelectConfigs]=\"{\r\n                  readonly: true,\r\n                  optionLabel: 'label',\r\n                  optionValue: 'id',\r\n                  key: col.name,\r\n                  value: element[col.name],\r\n                  referenceType: ReferenceType.LookupTable,\r\n                  referenceName: col.reference\r\n                }\"\r\n              ></p-dropdown>\r\n            </p>\r\n            <p *ngSwitchCase=\"'dataType.date'\">\r\n              {{ element[col.name] | date: ('app.date-format' | translate) }}\r\n            </p>\r\n            <p *ngSwitchDefault>{{ element[col.name] }}</p>\r\n          </ng-container>\r\n        </td>\r\n      </tr>\r\n    </ng-template>\r\n  </p-table>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i7.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i1$2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i1$2.NgSwitch, selector: "[ngSwitch]", inputs: ["ngSwitch"] }, { kind: "directive", type: i1$2.NgSwitchCase, selector: "[ngSwitchCase]", inputs: ["ngSwitchCase"] }, { kind: "directive", type: i1$2.NgSwitchDefault, selector: "[ngSwitchDefault]" }, { kind: "component", type: i10$2.Table, selector: "p-table", inputs: ["frozenColumns", "frozenValue", "style", "styleClass", "tableStyle", "tableStyleClass", "paginator", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "paginatorDropdownScrollHeight", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showJumpToPageInput", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "selectionMode", "selectionPageOnly", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "rowSelectable", "rowTrackBy", "lazy", "lazyLoadOnInit", "compareSelectionBy", "csvSeparator", "exportFilename", "filters", "globalFilterFields", "filterDelay", "filterLocale", "expandedRowKeys", "editingRowKeys", "rowExpandMode", "scrollable", "scrollDirection", "rowGroupMode", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "responsive", "contextMenu", "resizableColumns", "columnResizeMode", "reorderableColumns", "loading", "loadingIcon", "showLoader", "rowHover", "customSort", "showInitialSortBadge", "autoLayout", "exportFunction", "exportHeader", "stateKey", "stateStorage", "editMode", "groupRowsBy", "groupRowsByOrder", "responsiveLayout", "breakpoint", "virtualRowHeight", "value", "columns", "first", "rows", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection", "selectAll"], outputs: ["selectAllChange", "selectionChange", "contextMenuSelectionChange", "onRowSelect", "onRowUnselect", "onPage", "onSort", "onFilter", "onLazyLoad", "onRowExpand", "onRowCollapse", "onContextMenuSelect", "onColResize", "onColReorder", "onRowReorder", "onEditInit", "onEditComplete", "onEditCancel", "onHeaderCheckboxToggle", "sortFunction", "firstChange", "rowsChange", "onStateSave", "onStateRestore"] }, { kind: "directive", type: i10$2.SortableColumn, selector: "[pSortableColumn]", inputs: ["pSortableColumn", "pSortableColumnDisabled"] }, { kind: "directive", type: i10$2.ReorderableColumn, selector: "[pReorderableColumn]", inputs: ["pReorderableColumnDisabled"] }, { kind: "component", type: i10$2.SortIcon, selector: "p-sortIcon", inputs: ["field"] }, { kind: "component", type: i10$2.ColumnFilter, selector: "p-columnFilter", inputs: ["field", "type", "display", "showMenu", "matchMode", "operator", "showOperator", "showClearButton", "showApplyButton", "showMatchModes", "showAddButton", "hideOnClear", "placeholder", "matchModeOptions", "maxConstraints", "minFractionDigits", "maxFractionDigits", "prefix", "suffix", "locale", "localeMatcher", "currency", "currencyDisplay", "useGrouping", "showButtons"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i8.Button, selector: "p-button", inputs: ["type", "iconPos", "icon", "badge", "label", "disabled", "loading", "loadingIcon", "style", "styleClass", "badgeClass", "ariaLabel"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "component", type: i1$k.MultiSelect, selector: "p-multiSelect", inputs: ["style", "styleClass", "panelStyle", "panelStyleClass", "inputId", "disabled", "readonly", "group", "filter", "filterPlaceHolder", "filterLocale", "overlayVisible", "tabindex", "appendTo", "dataKey", "name", "label", "ariaLabelledBy", "displaySelectedLabel", "maxSelectedLabels", "selectionLimit", "selectedItemsLabel", "showToggleAll", "emptyFilterMessage", "emptyMessage", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "showHeader", "autoZIndex", "baseZIndex", "filterBy", "scrollHeight", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "filterMatchMode", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "display", "autocomplete", "showClear", "defaultLabel", "placeholder", "options", "filterValue", "itemSize"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onClear", "onPanelShow", "onPanelHide", "onLazyLoad"] }, { kind: "component", type: i1$5.Dropdown, selector: "p-dropdown", inputs: ["scrollHeight", "filter", "name", "style", "panelStyle", "styleClass", "panelStyleClass", "readonly", "required", "editable", "appendTo", "tabindex", "placeholder", "filterPlaceholder", "filterLocale", "inputId", "selectId", "dataKey", "filterBy", "autofocus", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "autoDisplayFirst", "group", "showClear", "emptyFilterMessage", "emptyMessage", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "autoZIndex", "baseZIndex", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "ariaLabel", "ariaLabelledBy", "filterMatchMode", "maxlength", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "disabled", "itemSize", "options", "filterValue"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onShow", "onHide", "onClear", "onLazyLoad"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "directive", type: PrgSetSelectConfigsDirective, selector: "[setSelectConfigs]", inputs: ["form", "setSelectConfigs"] }, { kind: "pipe", type: i1$2.DatePipe, name: "date" }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgListSpecificEntityTypeComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-list-specific-entity-type', providers: [DialogService, ConfirmationService], template: "<div>\r\n  <p-table\r\n    #dataTableComponent\r\n    [value]=\"entityTypeAllElements\"\r\n    [lazy]=\"true\"\r\n    (onLazyLoad)=\"lazyLoadElements($event)\"\r\n    [columns]=\"selectedColumnsObject\"\r\n    [paginator]=\"true\"\r\n    [rows]=\"tableConfigs.pagination.totalRows\"\r\n    [totalRecords]=\"totalRecords\"\r\n    [rowsPerPageOptions]=\"tableConfigs.pagination.rowsPerPageOptions\"\r\n    [reorderableColumns]=\"true\"\r\n    [globalFilterFields]=\"['name']\"\r\n    [filterDelay]=\"1000\"\r\n    [sortMode]=\"'multiple'\"\r\n    [multiSortMeta]=\"tableConfigs.multiSortMeta\"\r\n    responsiveLayout=\"scroll\"\r\n  >\r\n    <ng-template pTemplate=\"caption\">\r\n      <div style=\"text-align: left\">\r\n        <p-button\r\n          [label]=\"'buttons.add.label' | translate\"\r\n          (click)=\"addNewElement(false)\"\r\n        ></p-button>\r\n        <p-multiSelect\r\n          [options]=\"entityGroups\"\r\n          [group]=\"true\"\r\n          [(ngModel)]=\"selectedColumnsObject\"\r\n          scrollHeight=\"250px\"\r\n          optionLabel=\"name\"\r\n          [maxSelectedLabels]=\"1\"\r\n          selectedItemsLabel=\"{0} {{ columnsSelectedLabel }}\"\r\n        >\r\n          <ng-template let-group pTemplate=\"group\">\r\n            <div *ngIf=\"group.items.length\" class=\"flex align-items-center\">\r\n              <span>\r\n                {{ 'entity-type.tabs.' + group.value + '.label' | translate }}\r\n              </span>\r\n            </div>\r\n          </ng-template>\r\n        </p-multiSelect>\r\n        <!--we are calling this function on the input to trigger the lazy load function-->\r\n        <span class=\"p-input-icon-left ml-auto\">\r\n          <i class=\"pi pi-search\"></i>\r\n          <input\r\n            pInputText\r\n            type=\"text\"\r\n            (input)=\"\r\n              dataTableComponent.filterGlobal(\r\n                $any($event).target.value,\r\n                'contains'\r\n              )\r\n            \"\r\n            [ngModel]=\"globalFilterValue\"\r\n            [disabled]=\"globalFilterDisabled\"\r\n            placeholder=\"{{\r\n              'components.entity-type.global-search.placeholder' | translate\r\n            }}\"\r\n          />\r\n        </span>\r\n        <button\r\n          pButton\r\n          label=\"{{ 'buttons.reset-table.label' | translate }}\"\r\n          class=\"p-button-outlined\"\r\n          icon=\"pi pi-filter-slash\"\r\n          (click)=\"clearAllFilters()\"\r\n        ></button>\r\n      </div>\r\n    </ng-template>\r\n    <ng-template pTemplate=\"header\" let-columns>\r\n      <tr>\r\n        <th style=\"width: 2rem\">\r\n          <p-button\r\n            type=\"button\"\r\n            icon=\"pi pi-plus-circle\"\r\n            pAddRow\r\n            (click)=\"addNewElement(true)\"\r\n          ></p-button>\r\n        </th>\r\n        <ng-container *ngFor=\"let col of selectedColumnsObject\">\r\n          <th [pSortableColumn]=\"col.name\" pReorderableColumn>\r\n            {{\r\n              'entities.' + entityType.name + '.fields.' + col.name + '.label'\r\n                | translate\r\n            }}\r\n            <p-sortIcon [field]=\"col.name\"></p-sortIcon>\r\n            <p-columnFilter\r\n              [hidden]=\"globalFilterIsActive\"\r\n              [type]=\"primeNgTypeToOurTypes[col.dataTypeId]\"\r\n              [field]=\"col.name\"\r\n              [matchMode]=\"\r\n                col.dataTypeId === 'dataType.lookupTable' ? 'equals' : null\r\n              \"\r\n              display=\"menu\"\r\n              [showAddButton]=\"\r\n                col.dataTypeId === 'dataType.lookupTable' ? false : true\r\n              \"\r\n            >\r\n              <ng-template\r\n                *ngIf=\"col.dataTypeId === 'dataType.lookupTable'\"\r\n                pTemplate=\"filter\"\r\n                let-value\r\n                let-filter=\"filterCallback\"\r\n              >\r\n                <p-dropdown\r\n                  [setSelectConfigs]=\"{\r\n                    readonly: false,\r\n                    optionLabel: 'label',\r\n                    optionValue: 'id',\r\n                    key: col.name,\r\n                    value: dataTableComponent.filters[col.name][0].value,\r\n                    referenceType: ReferenceType.LookupTable,\r\n                    referenceName: col.reference\r\n                  }\"\r\n                  (onChange)=\"\r\n                    lookupTableFilterChange($event.value, col.name, 'equals')\r\n                  \"\r\n                  placeholder=\"Select any\"\r\n                >\r\n                </p-dropdown>\r\n              </ng-template>\r\n            </p-columnFilter>\r\n          </th>\r\n        </ng-container>\r\n      </tr>\r\n    </ng-template>\r\n    <ng-template pTemplate=\"body\" let-element>\r\n      <tr style=\"cursor: pointer\" (click)=\"editElement($event, false, element)\">\r\n        <td>\r\n          <i class=\"pi pi-eye\" (click)=\"editElement($event, true, element)\"></i>\r\n        </td>\r\n        <td *ngFor=\"let col of selectedColumnsObject; let i = index\">\r\n          <ng-container [ngSwitch]=\"col.dataTypeId\">\r\n            <p *ngSwitchCase=\"'dataType.lookupTable'\">\r\n              <p-dropdown\r\n                [setSelectConfigs]=\"{\r\n                  readonly: true,\r\n                  optionLabel: 'label',\r\n                  optionValue: 'id',\r\n                  key: col.name,\r\n                  value: element[col.name],\r\n                  referenceType: ReferenceType.LookupTable,\r\n                  referenceName: col.reference\r\n                }\"\r\n              ></p-dropdown>\r\n            </p>\r\n            <p *ngSwitchCase=\"'dataType.date'\">\r\n              {{ element[col.name] | date: ('app.date-format' | translate) }}\r\n            </p>\r\n            <p *ngSwitchDefault>{{ element[col.name] }}</p>\r\n          </ng-container>\r\n        </td>\r\n      </tr>\r\n    </ng-template>\r\n  </p-table>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: AbstractEntityTypeService }, { type: i2.DialogService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ENTITY_TYPES_CONFIG]
                }] }, { type: PrimengUtilityService }, { type: i5.TranslateService }, { type: i1$1.Router }]; }, propDecorators: { dataTableComponent: [{
                type: ViewChild,
                args: [Table]
            }], entityTypeName: [{
                type: Input
            }], onClickGoTo: [{
                type: Input
            }] } });

/**
 * Class ItemsData
 */
class PaginationResponse {
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init) {
        /**
         * array of items
         */
        this.items = [];
        Object.assign(this, init);
    }
}

/**
 * Class Input Text
 */
class InputTextConfiguration extends BaseField {
    /* /!**
     * When present, it specifies that the element should be disabled.
     *!/
    public disabled: boolean = false;*/ //Property already on Base Field
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputText;
        Object.assign(this, init);
    }
}

/**
 * this class serves to have a configuration of
 *  what happens after a certain action is successfully executed
 */
class ExecutedActionBehaviour {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        /**
         * reset table does a complete reset of the table(clean filters, paginations)
         */
        this.resetTable = false;
        /**
         * reload data
         */
        this.reloadData = true;
        /**
         * redirect to list
         */
        this.redirectToList = true;
        /**
         * change view mode to read
         */
        this.changeViewModeToRead = true;
        Object.assign(this, init);
    }
}

/**
 * Class that define the common properties that will be used for each component on dashboard
 */
class BaseDashboardComponent {
}
/**
 * Configurations settings for the component
 * @type {any}
 */
BaseDashboardComponent.configurationSettings = { fields: [] };

/**
 *  Constant that define the key , configuration settings and settings for bar chart component
 * @type {{staticSettings: string, configurationSettings: {fields: InputNumberConfiguration[]}, key: string}}
 */
const PRG_BAR_CHART_SETTINGS = {
    key: 'Bar-chart',
    configurationSettings: {
        fields: [
            new InputNumberConfiguration({
                key: 'barChartProperty1',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'barChartProperty2',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'barChartProperty3',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'barChartProperty4',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'barChartProperty5',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'barChartProperty6',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'barChartProperty7',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
        ],
    },
    staticSettings: JSON.stringify({
        barChartProperty1: 1,
        barChartProperty2: 15,
        barChartProperty3: 30,
        barChartProperty4: 45,
        barChartProperty5: 120,
        barChartProperty6: 80,
        barChartProperty7: 152,
    }),
};

/**
 * AbstractQueriesService class that defines an
 * <br />abstract dashboard service to
 * <br />be extended by the mock and real
 * <br />dashboard services
 */
class AbstractDashboardService {
    /**
     * Constructor
     * @param {HttpClient} http
     */
    constructor(http) {
        this.http = http;
        /**
         * Detect changes on dashboard options made on prg-dashboard-options.component
         */
        this.dashboardOptionsChangesSubject = new BehaviorSubject(null);
        /**
         * Detect changes on the size of dashboardItems
         * @type {BehaviorSubject<GridsterItemComponentInterface>}
         * @protected
         */
        this.dashboardItemsResizeSubject = new BehaviorSubject(null);
        /**
         * Detect changes on the list of dashboards
         * @type {BehaviorSubject<Dashboard[]>}
         * @protected
         */
        this.dashboardListUpdatedSubject = new BehaviorSubject(null);
    }
    /**
     * Setter for dashboardOptionsChangesSubject
     * @param {GridConfigsAndItems} value
     */
    setDashboardOptionsChanges(value) {
        this.dashboardOptionsChangesSubject.next(value);
    }
    /**
     * Getter for dashboardOptionsChangesSubject
     * @returns {Observable<GridConfigsAndItems>}
     */
    getDashboardOptionsChangesObservable() {
        return this.dashboardOptionsChangesSubject.asObservable();
    }
    /**
     * Getter for dashboardOptionsChangesSubject
     * @returns {GridConfigsAndItems}
     */
    getDashboardOptionsChangesValue() {
        return this.dashboardOptionsChangesSubject.getValue();
    }
    /**
     * Setter for dashboardItemsResizeSubject
     * @param {GridsterItemComponentInterface} value
     */
    setDashboardItemsResize(value) {
        this.dashboardItemsResizeSubject.next(value);
    }
    /**
     * Getter for dashboardItemsResizeSubject
     * @returns {Observable<GridsterItemComponentInterface>}
     */
    getDashboardItemsResizeObservable() {
        return this.dashboardItemsResizeSubject.asObservable();
    }
    /**
     * Getter for dashboardItemsResizeSubject
     * @returns {GridsterItemComponentInterface}
     */
    getDashboardItemsResizeValue() {
        return this.dashboardItemsResizeSubject.getValue();
    }
    /**
     * Setter for dashboardListUpdatedSubject
     * @param {Dashboard[]} value
     */
    setDashboardListUpdated(value) {
        this.dashboardListUpdatedSubject.next(value);
    }
    /**
     * Getter for dashboardListUpdatedSubject
     * @returns {Observable<Dashboard[]>}
     */
    getDashboardListUpdatedObservable() {
        return this.dashboardListUpdatedSubject.asObservable();
    }
    /**
     * Getter for dashboardListUpdatedSubject
     * @returns {Dashboard[]}
     */
    getDashboardListUpdatedValue() {
        return this.dashboardListUpdatedSubject.getValue();
    }
}

/**
 * Bar Chart Component
 */
class PrgBarChartComponent extends BaseDashboardComponent {
    /**
     * Constructor
     * @param {AbstractDashboardService} dashboardService
     * @param {UtilityService} utilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(dashboardService, utilityService, objectsUtilityService) {
        super();
        this.dashboardService = dashboardService;
        this.utilityService = utilityService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         * @type {Subscription[]}
         * @private
         */
        this.subscription = [];
        PrgBarChartComponent.key = PRG_BAR_CHART_SETTINGS.key;
        PrgBarChartComponent.staticSettings = PRG_BAR_CHART_SETTINGS.staticSettings;
        PrgBarChartComponent.configurationSettings =
            PRG_BAR_CHART_SETTINGS.configurationSettings;
    }
    /**
     * The custom settings for this component
     * @param itemSettings
     */
    set itemSettings(itemSettings) {
        if (itemSettings != null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(itemSettings));
        }
    }
    /**
     * Getter for item settings
     * @returns {any}
     */
    get itemSettings() {
        return this._itemSettings;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.subscription.push(this.dashboardService
            .getDashboardItemsResizeObservable()
            .pipe(filter((item) => item?.item?.id === this.itemId))
            .subscribe((item) => {
            this.height = (item.height - item.height * 0.05).toString() + 'px';
            this.width = (item.width - item.width * 0.02).toString() + 'px';
            if (this.chart?.chart) {
                this.chart.chart.canvas.parentNode.style.height =
                    (item.height - item.height * 0.05).toString() + 'px';
                this.chart.chart.canvas.parentNode.style.width =
                    (item.width - item.width * 0.02).toString() + 'px';
                this.chart.reinit();
            }
        }));
        if (this._itemSettings == null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(PrgBarChartComponent.staticSettings));
        }
        this._itemSettings = Object.values(this._itemSettings);
        this.basicData = {
            labels: ['January', 'February', 'March', 'April', 'May', 'June', 'July'],
            datasets: [
                {
                    label: 'My First dataset',
                    backgroundColor: '#42A5F5',
                    data: this._itemSettings,
                },
                {
                    label: 'My Second dataset',
                    backgroundColor: '#FFA726',
                    data: [28, 48, 40, 19, 86, 27, 90],
                },
            ],
        };
        this.basicOptions = {
            maintainAspectRatio: false,
            responsive: true,
            plugins: {
                legend: {
                    labels: {
                        color: '#495057',
                    },
                },
            },
            scales: {
                x: {
                    ticks: {
                        color: '#495057',
                    },
                    grid: {
                        color: '#ebedef',
                    },
                },
                y: {
                    ticks: {
                        color: '#495057',
                    },
                    grid: {
                        color: '#ebedef',
                    },
                },
            },
        };
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.subscription.forEach((subs) => {
            subs.unsubscribe();
        });
    }
}
PrgBarChartComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgBarChartComponent, deps: [{ token: AbstractDashboardService }, { token: UtilityService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgBarChartComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgBarChartComponent, selector: "prg-bar-chart", inputs: { itemId: "itemId", itemSettings: "itemSettings" }, viewQueries: [{ propertyName: "chart", first: true, predicate: ["chart"], descendants: true }], usesInheritance: true, ngImport: i0, template: "<div  class=\"graph-size\" [style]=\"{'height':height,'width':width}\">\r\n\r\n  <p-chart type=\"bar\"    #chart  [data]=\"basicData\" [options]=\"basicOptions\"></p-chart>\r\n\r\n</div>\r\n\r\n\r\n", styles: [".graph-size{position:relative}\n"], dependencies: [{ kind: "component", type: i4$1.UIChart, selector: "p-chart", inputs: ["type", "plugins", "width", "height", "responsive", "data", "options"], outputs: ["onDataSelect"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgBarChartComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-bar-chart', template: "<div  class=\"graph-size\" [style]=\"{'height':height,'width':width}\">\r\n\r\n  <p-chart type=\"bar\"    #chart  [data]=\"basicData\" [options]=\"basicOptions\"></p-chart>\r\n\r\n</div>\r\n\r\n\r\n", styles: [".graph-size{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: AbstractDashboardService }, { type: UtilityService }, { type: ObjectsUtilityService }]; }, propDecorators: { itemId: [{
                type: Input,
                args: ['itemId']
            }], itemSettings: [{
                type: Input,
                args: ['itemSettings']
            }], chart: [{
                type: ViewChild,
                args: ['chart']
            }] } });

/**
 * Constant that define the key , configuration settings and settings for line chart component
 * @type {{staticSettings: string, configurationSettings: {fields: InputNumberConfiguration[]}, key: string}}
 */
const PRG_BAR_LINE_SETTINGS = {
    key: 'Line-Chart',
    configurationSettings: {
        fields: [
            new InputNumberConfiguration({
                key: 'lineChartProperty1',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'lineChartProperty2',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'lineChartProperty3',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'lineChartProperty4',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'lineChartProperty5',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'lineChartProperty6',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'lineChartProperty7',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
        ],
    },
    staticSettings: JSON.stringify({
        lineChartProperty1: 35,
        lineChartProperty2: 58,
        lineChartProperty3: 85,
        lineChartProperty4: 33,
        lineChartProperty5: 99,
        lineChartProperty6: 120,
        lineChartProperty7: 150,
    }),
};

/**
 * Line Chart Component
 */
class PrgLineChartComponent extends BaseDashboardComponent {
    /**
     * Constructor
     * @param {AbstractDashboardService} dashboardService
     * @param {UtilityService} utilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(dashboardService, utilityService, objectsUtilityService) {
        super();
        this.dashboardService = dashboardService;
        this.utilityService = utilityService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         * @type {Subscription[]}
         * @private
         */
        this.subscription = [];
        PrgLineChartComponent.key = PRG_BAR_LINE_SETTINGS.key;
        PrgLineChartComponent.staticSettings = PRG_BAR_LINE_SETTINGS.staticSettings;
        PrgLineChartComponent.configurationSettings =
            PRG_BAR_LINE_SETTINGS.configurationSettings;
    }
    /**
     * The custom settings for this component
     * @param itemSettings
     */
    set itemSettings(itemSettings) {
        if (itemSettings != null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(itemSettings));
        }
    }
    /**
     * Getter for item settings
     * @returns {any}
     */
    get itemSettings() {
        return this._itemSettings;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        if (this._itemSettings == null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(PrgLineChartComponent.staticSettings));
        }
        this._itemSettings = Object.values(this._itemSettings);
        this.basicData = {
            labels: ['January', 'February', 'March', 'April', 'May', 'June', 'July'],
            datasets: [
                {
                    label: 'First Dataset',
                    data: this._itemSettings,
                    fill: false,
                    borderColor: '#42A5F5',
                    tension: 0.4,
                },
                {
                    label: 'Second Dataset',
                    data: [28, 48, 40, 19, 86, 27, 90],
                    fill: false,
                    borderColor: '#FFA726',
                    tension: 0.4,
                },
            ],
        };
        this.basicOptions = {
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    labels: {
                        color: '#495057',
                    },
                },
            },
            scales: {
                x: {
                    ticks: {
                        color: '#495057',
                    },
                    grid: {
                        color: '#ebedef',
                    },
                },
                y: {
                    ticks: {
                        color: '#495057',
                    },
                    grid: {
                        color: '#ebedef',
                    },
                },
            },
        };
        this.subscription.push(this.dashboardService
            .getDashboardItemsResizeObservable()
            .pipe(filter((item) => item?.item?.id === this.itemId))
            .subscribe((item) => {
            this.height = (item.height - item.height * 0.05).toString() + 'px';
            this.width = (item.width - item.width * 0.02).toString() + 'px';
            if (this.chart?.chart) {
                this.chart.chart.canvas.parentNode.style.height =
                    (item.height - item.height * 0.05).toString() + 'px';
                this.chart.chart.canvas.parentNode.style.width =
                    (item.width - item.width * 0.02).toString() + 'px';
                this.chart.reinit();
            }
        }));
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.subscription.forEach((subs) => {
            subs.unsubscribe();
        });
    }
}
PrgLineChartComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLineChartComponent, deps: [{ token: AbstractDashboardService }, { token: UtilityService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgLineChartComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgLineChartComponent, selector: "prg-line-chart", inputs: { itemId: "itemId", itemSettings: "itemSettings" }, viewQueries: [{ propertyName: "chart", first: true, predicate: ["chart"], descendants: true }], usesInheritance: true, ngImport: i0, template: "<div class=\"graph-size\" [style]=\"{'height':height,'width':width}\">\r\n  <p-chart  type=\"line\"  #chart  [data]=\"basicData\" [options]=\"basicOptions\"></p-chart>\r\n\r\n</div>\r\n", styles: [".graph-size{position:relative}\n"], dependencies: [{ kind: "component", type: i4$1.UIChart, selector: "p-chart", inputs: ["type", "plugins", "width", "height", "responsive", "data", "options"], outputs: ["onDataSelect"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLineChartComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-line-chart', template: "<div class=\"graph-size\" [style]=\"{'height':height,'width':width}\">\r\n  <p-chart  type=\"line\"  #chart  [data]=\"basicData\" [options]=\"basicOptions\"></p-chart>\r\n\r\n</div>\r\n", styles: [".graph-size{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: AbstractDashboardService }, { type: UtilityService }, { type: ObjectsUtilityService }]; }, propDecorators: { itemId: [{
                type: Input,
                args: ['itemId']
            }], itemSettings: [{
                type: Input,
                args: ['itemSettings']
            }], chart: [{
                type: ViewChild,
                args: ['chart']
            }] } });

/**
 * Constant that define the key , configuration settings and settings for doughnut chart component
 * @type {{staticSettings: string, configurationSettings: {fields: InputNumberConfiguration[]}, key: string}}
 */
const PRG_BAR_DOUGHNUT_SETTINGS = {
    key: 'Doughnut-settings',
    configurationSettings: {
        fields: [
            new InputNumberConfiguration({
                key: 'donutChartProperty1',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'donutChartProperty2',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'donutChartProperty3',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
        ],
    },
    staticSettings: JSON.stringify({
        donutChartProperty1: 30,
        donutChartProperty2: 58,
        donutChartProperty3: 29,
    }),
};

/**
 * Doughnut Chart Component
 */
class PrgDoughnutChartComponent extends BaseDashboardComponent {
    /**
     * Cosntructor
     * @param {AbstractDashboardService} dashboardService
     * @param {UtilityService} utilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(dashboardService, utilityService, objectsUtilityService) {
        super();
        this.dashboardService = dashboardService;
        this.utilityService = utilityService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         * @type {Subscription[]}
         * @private
         */
        this.subscription = [];
        PrgDoughnutChartComponent.key = PRG_BAR_DOUGHNUT_SETTINGS.key;
        PrgDoughnutChartComponent.staticSettings =
            PRG_BAR_DOUGHNUT_SETTINGS.staticSettings;
        PrgDoughnutChartComponent.configurationSettings =
            PRG_BAR_DOUGHNUT_SETTINGS.configurationSettings;
    }
    /**
     * The custom settings for this component
     * @param itemSettings
     */
    set itemSettings(itemSettings) {
        if (itemSettings != null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(itemSettings));
        }
    }
    /**
     * Getter for item settings
     * @returns {any}
     */
    get itemSettings() {
        return this._itemSettings;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        if (this._itemSettings == null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(PrgDoughnutChartComponent.staticSettings));
        }
        this._itemSettings = Object.values(this._itemSettings);
        this.basicData = {
            labels: ['A', 'B', 'C'],
            datasets: [
                {
                    data: this._itemSettings,
                    backgroundColor: ['#FF6384', '#36A2EB', '#FFCE56'],
                    hoverBackgroundColor: ['#FF6384', '#36A2EB', '#FFCE56'],
                },
            ],
        };
        this.basicOptions = {
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    labels: {
                        color: '#495057',
                    },
                },
            },
        };
        this.subscription.push(this.dashboardService
            .getDashboardItemsResizeObservable()
            .pipe(filter((item) => item?.item?.id === this.itemId))
            .subscribe((item) => {
            this.height = (item.height - item.height * 0.05).toString() + 'px';
            this.width = (item.width - item.width * 0.02).toString() + 'px';
            if (this.chart?.chart) {
                this.chart.chart.canvas.parentNode.style.height =
                    (item.height - item.height * 0.05).toString() + 'px';
                this.chart.chart.canvas.parentNode.style.width =
                    (item.width - item.width * 0.02).toString() + 'px';
                this.chart.reinit();
            }
        }));
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.subscription.forEach((subs) => {
            subs.unsubscribe();
        });
    }
}
PrgDoughnutChartComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDoughnutChartComponent, deps: [{ token: AbstractDashboardService }, { token: UtilityService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgDoughnutChartComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgDoughnutChartComponent, selector: "prg-doughnut-chart", inputs: { itemId: "itemId", itemSettings: "itemSettings" }, viewQueries: [{ propertyName: "chart", first: true, predicate: ["chart"], descendants: true }], usesInheritance: true, ngImport: i0, template: "<div  class=\"graph-size\" [style]=\"{'height':height,'width':width}\">\r\n\r\n  <p-chart type=\"doughnut\"   #chart  [data]=\"basicData\" [options]=\"basicOptions\"></p-chart>\r\n\r\n</div>\r\n\r\n\r\n", styles: [".graph-size{position:relative}\n"], dependencies: [{ kind: "component", type: i4$1.UIChart, selector: "p-chart", inputs: ["type", "plugins", "width", "height", "responsive", "data", "options"], outputs: ["onDataSelect"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDoughnutChartComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-doughnut-chart', template: "<div  class=\"graph-size\" [style]=\"{'height':height,'width':width}\">\r\n\r\n  <p-chart type=\"doughnut\"   #chart  [data]=\"basicData\" [options]=\"basicOptions\"></p-chart>\r\n\r\n</div>\r\n\r\n\r\n", styles: [".graph-size{position:relative}\n"] }]
        }], ctorParameters: function () { return [{ type: AbstractDashboardService }, { type: UtilityService }, { type: ObjectsUtilityService }]; }, propDecorators: { itemId: [{
                type: Input,
                args: ['itemId']
            }], itemSettings: [{
                type: Input,
                args: ['itemSettings']
            }], chart: [{
                type: ViewChild,
                args: ['chart']
            }] } });

/**
 * Constant that define the key , configuration settings and settings for table component
 * @type {{staticSettings: string, configurationSettings: {fields: (InputNumberConfiguration | InputTextConfiguration)[]}, key: string}}
 */
const PRG_TABLE_SETTINGS = {
    key: 'Table',
    configurationSettings: {
        fields: [
            new InputNumberConfiguration({
                key: 'tableProperty1',
                disabledOutputEvent: false,
                showButtons: true,
                allowEmpty: false,
            }),
            new InputNumberConfiguration({
                key: 'tableProperty2',
                disabledOutputEvent: false,
                showButtons: true,
                validators: [Validators.required],
            }),
            new InputTextConfiguration({
                key: 'tableProperty3',
                disabledOutputEvent: false,
            }),
        ],
    },
    staticSettings: JSON.stringify({
        tableProperty1: 1,
        tableProperty2: 10,
        tableProperty3: 15,
    }),
};

/**
 * Table Component
 */
class PrgTableComponent extends BaseDashboardComponent {
    /**
     * Constructor
     * @param {HttpClient} http
     * @param {MainLayoutService} mainLayoutService
     * @param {AbstractDashboardService} dashboardService
     * @param {UtilityService} utilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(http, mainLayoutService, dashboardService, utilityService, objectsUtilityService) {
        super();
        this.http = http;
        this.mainLayoutService = mainLayoutService;
        this.dashboardService = dashboardService;
        this.utilityService = utilityService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         * @type {Subscription[]}
         * @private
         */
        this.subscription = [];
        PrgTableComponent.key = PRG_TABLE_SETTINGS.key;
        PrgTableComponent.staticSettings = PRG_TABLE_SETTINGS.staticSettings;
        PrgTableComponent.configurationSettings =
            PRG_TABLE_SETTINGS.configurationSettings;
    }
    /**
     * The custom settings for this component
     * @param itemSettings
     */
    set itemSettings(itemSettings) {
        if (itemSettings != null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(itemSettings));
        }
    }
    /**
     * Getter for item settings
     * @returns {any}
     */
    get itemSettings() {
        return this._itemSettings;
    }
    /**
     * ngOnInit
     * @returns {Promise<void>}
     */
    async ngOnInit() {
        if (this._itemSettings == null) {
            this._itemSettings = this.objectsUtilityService.cloneObject(this.utilityService.guiSettingToObject(PrgTableComponent.staticSettings));
        }
        this._itemSettings = Object.values(this._itemSettings);
        this.subscription.push(this.dashboardService
            .getDashboardItemsResizeObservable()
            .pipe(filter((item) => item?.item?.id === this.itemId))
            .subscribe((item) => {
            this.height = (item.height - item.height * 0.05).toString() + 'px';
            this.width = (item.width - item.width * 0.02).toString() + 'px';
        }));
        this.products = await lastValueFrom(this.http
            .get('assets/products.json')
            .pipe(map((res) => res.data)));
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.subscription.forEach((subs) => {
            subs.unsubscribe();
        });
    }
}
PrgTableComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTableComponent, deps: [{ token: i1$3.HttpClient }, { token: MainLayoutService }, { token: AbstractDashboardService }, { token: UtilityService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgTableComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgTableComponent, selector: "prg-table", inputs: { itemId: "itemId", itemSettings: "itemSettings" }, usesInheritance: true, ngImport: i0, template: "<div *ngIf=\"height&&width\" class=\"card\" [style]=\"{'height':height,'width':width}\">\r\n<p-table   [value]=\"products\"  [scrollable]=\"true\" [scrollHeight]=\"height\" >\r\n  <ng-template pTemplate=\"header\">\r\n    <tr style=\"text-align: center\">\r\n      <th style=\"text-align: center\" >Code</th>\r\n      <th style=\"text-align: center\">Name</th>\r\n      <th style=\"text-align: center\">Category</th>\r\n      <th style=\"text-align: center\">Quantity</th>\r\n    </tr>\r\n  </ng-template>\r\n  <ng-template pTemplate=\"body\" let-product>\r\n    <tr style=\"text-align: center\">\r\n      <td style=\"text-align: center\">{{product.code}}</td>\r\n      <td style=\"text-align: center\">{{product.name}}</td>\r\n      <td style=\"text-align: center\">{{product.category}}</td>\r\n      <td style=\"text-align: center\">{{product.quantity}}</td>\r\n    </tr>\r\n  </ng-template>\r\n</p-table>\r\n</div>\r\n", styles: [":host ::ng-deep .p-datatable-scrollable .p-datatable-thead>tr>th,:host .p-datatable-scrollable .p-datatable-tbody>tr>td,:host .p-datatable-scrollable .p-datatable-tfoot>tr>td{justify-content:center}:host ::ng-deep .p-datatable-scrollable .p-datatable-tbody>tr>td{justify-content:center}\n"], dependencies: [{ kind: "directive", type: i7.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i10$2.Table, selector: "p-table", inputs: ["frozenColumns", "frozenValue", "style", "styleClass", "tableStyle", "tableStyleClass", "paginator", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "paginatorDropdownScrollHeight", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showJumpToPageInput", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "selectionMode", "selectionPageOnly", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "rowSelectable", "rowTrackBy", "lazy", "lazyLoadOnInit", "compareSelectionBy", "csvSeparator", "exportFilename", "filters", "globalFilterFields", "filterDelay", "filterLocale", "expandedRowKeys", "editingRowKeys", "rowExpandMode", "scrollable", "scrollDirection", "rowGroupMode", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "responsive", "contextMenu", "resizableColumns", "columnResizeMode", "reorderableColumns", "loading", "loadingIcon", "showLoader", "rowHover", "customSort", "showInitialSortBadge", "autoLayout", "exportFunction", "exportHeader", "stateKey", "stateStorage", "editMode", "groupRowsBy", "groupRowsByOrder", "responsiveLayout", "breakpoint", "virtualRowHeight", "value", "columns", "first", "rows", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection", "selectAll"], outputs: ["selectAllChange", "selectionChange", "contextMenuSelectionChange", "onRowSelect", "onRowUnselect", "onPage", "onSort", "onFilter", "onLazyLoad", "onRowExpand", "onRowCollapse", "onContextMenuSelect", "onColResize", "onColReorder", "onRowReorder", "onEditInit", "onEditComplete", "onEditCancel", "onHeaderCheckboxToggle", "sortFunction", "firstChange", "rowsChange", "onStateSave", "onStateRestore"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTableComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-table', template: "<div *ngIf=\"height&&width\" class=\"card\" [style]=\"{'height':height,'width':width}\">\r\n<p-table   [value]=\"products\"  [scrollable]=\"true\" [scrollHeight]=\"height\" >\r\n  <ng-template pTemplate=\"header\">\r\n    <tr style=\"text-align: center\">\r\n      <th style=\"text-align: center\" >Code</th>\r\n      <th style=\"text-align: center\">Name</th>\r\n      <th style=\"text-align: center\">Category</th>\r\n      <th style=\"text-align: center\">Quantity</th>\r\n    </tr>\r\n  </ng-template>\r\n  <ng-template pTemplate=\"body\" let-product>\r\n    <tr style=\"text-align: center\">\r\n      <td style=\"text-align: center\">{{product.code}}</td>\r\n      <td style=\"text-align: center\">{{product.name}}</td>\r\n      <td style=\"text-align: center\">{{product.category}}</td>\r\n      <td style=\"text-align: center\">{{product.quantity}}</td>\r\n    </tr>\r\n  </ng-template>\r\n</p-table>\r\n</div>\r\n", styles: [":host ::ng-deep .p-datatable-scrollable .p-datatable-thead>tr>th,:host .p-datatable-scrollable .p-datatable-tbody>tr>td,:host .p-datatable-scrollable .p-datatable-tfoot>tr>td{justify-content:center}:host ::ng-deep .p-datatable-scrollable .p-datatable-tbody>tr>td{justify-content:center}\n"] }]
        }], ctorParameters: function () { return [{ type: i1$3.HttpClient }, { type: MainLayoutService }, { type: AbstractDashboardService }, { type: UtilityService }, { type: ObjectsUtilityService }]; }, propDecorators: { itemId: [{
                type: Input,
                args: ['itemId']
            }], itemSettings: [{
                type: Input,
                args: ['itemSettings']
            }] } });

/**
 * Enum for dynamic components to be used on dashboards
 */
var ComponentTypeEnum;
(function (ComponentTypeEnum) {
    ComponentTypeEnum["BarChart"] = "Bar-Chart";
    ComponentTypeEnum["LineChart"] = "Line-Chart";
    ComponentTypeEnum["DoughnutChart"] = "Doughnut-Chart";
    ComponentTypeEnum["Table"] = "Table";
})(ComponentTypeEnum || (ComponentTypeEnum = {}));
/**
 * Map name of componentType to classes
 */
const MapComponentTypesToClass = new Map([
    [ComponentTypeEnum.BarChart, PrgBarChartComponent],
    [ComponentTypeEnum.LineChart, PrgLineChartComponent],
    [ComponentTypeEnum.DoughnutChart, PrgDoughnutChartComponent],
    [ComponentTypeEnum.Table, PrgTableComponent],
]);
/**
 * Dashboard Class
 */
class Dashboard extends BaseEntity {
    /**
     * Cosntructor
     * @param {Partial<Dashboard>} init
     */
    constructor(init) {
        super();
        /**
         * Read only
         * @type {boolean}
         */
        this.isPublic = true;
        Object.assign(this, init);
    }
}
/**
 * Dashboard Items CLass
 */
class DashboardItem extends BaseEntity {
    /**
     * Constructor
     * @param {Partial<DashboardItem>} init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/**
 * Component Type Class
 */
class ComponentType extends BaseEntity {
    /**
     * Constructor
     * @param {Partial<DashboardItem>} init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}

/**
 * Mock Database
 */
const MockDatabase$1 = {
    EntityTypes: [
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'Customer',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'qwertty',
            group: 'System',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '2',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'User',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: '12346',
            group: 'System',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '3',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'Refunds',
            createdBy: null,
            label: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'new ModelQualquer({list : {pagination:false, columns: string[]} ,form:{} })',
            group: 'Store',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '4',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'Orders',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'nccnnc',
            group: 'Store',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '5',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'product',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'new ModelQualquer({list : {pagination:false, columns: BaseFields[]} ,form:{} })',
            group: 'Store',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '6',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'dashboard',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'new ModelQualquer({list : {pagination:false, columns: BaseFields[]} ,form:{} })',
            group: 'System',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '7',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'dashboarditem',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'new ModelQualquer({list : {pagination:false, columns: BaseFields[]} ,form:{} })',
            group: 'System',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '8',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'componentType',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'new ModelQualquer({list : {pagination:false, columns: BaseFields[]} ,form:{} })',
            group: 'System',
            properties: null,
            attributes: null,
            operations: null,
        },
    ],
    EntityTypeProperty: [
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'property1',
            createdBy: null,
            label: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            //referenceName
            reference: 'dataType',
        },
        {
            id: '2',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'property2',
            createdBy: null,
            label: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'number',
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 3,
            reference: 'sis',
        },
        {
            id: '3',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'property3',
            createdBy: null,
            label: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: "String(new InputTextConfiguration({disabled:true, visibleExpression:'sisisi'}))",
            dataTypeId: 'dataType.lookupTable',
            isArray: false,
            order: 3,
            reference: 'sis',
        },
        {
            id: '4',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label: null,
            name: 'property4',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 4,
            reference: 'sis',
        },
        {
            id: '5',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'customername',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'customername',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'customer name',
        },
        {
            id: '6',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'customerId',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'customerId',
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 1,
            reference: 'customerId',
        },
        {
            id: '7',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'dateofbirth',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'dateofbirth',
            dataTypeId: 'dataType.date',
            isArray: false,
            order: 1,
            reference: 'dateofbirth',
        },
        {
            id: '8',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'name',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'name',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'name',
        },
        {
            id: '9',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'userId',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'userId',
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 1,
            reference: 'userId',
        },
        {
            id: '10',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label: null,
            name: 'RegisterDate',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'RegisterDate',
            dataTypeId: 'dataType.date',
            isArray: false,
            order: 1,
            reference: 'RegisterDate',
        },
        {
            id: '99999991',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'id',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: null,
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: null,
        },
        {
            id: '99999992',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'name',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify(new InputTextConfiguration({
                readonly: false,
                key: 'name',
                validators: ['Validators.required'],
                basePathTranslation: 'entities.product.fields',
            })),
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 2,
            reference: null,
        },
        {
            id: '99999993',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'description',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify(new InputTextConfiguration({
                readonly: false,
                key: 'description',
                validators: ['Validators.maxLength(20)'],
                basePathTranslation: 'entities.product.fields',
            })),
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 2,
            reference: null,
        },
        {
            id: '99999994',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'expiryDate',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify(new DateTimeConfiguration({
                key: 'expiryDate',
                validators: ['Validators.required'],
            })),
            dataTypeId: 'dataType.date',
            isArray: true,
            order: 3,
            reference: null,
        },
        {
            id: '99999995',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'value',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify(new InputNumberConfiguration({
                readonly: false,
                key: 'value',
                validators: ['Validators.required'],
            })),
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 4,
            reference: null,
        },
        {
            id: '99999996',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'stock',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify({
                controlName: ControlName.dropdown,
                referenceType: ReferenceType.LookupTable,
                referenceName: 'stockStatus',
                readonly: false,
                key: 'stock',
                optionLabel: 'label',
                optionValue: 'id',
                validators: ['Validators.required'],
            }),
            dataTypeId: 'dataType.lookupTable',
            isArray: false,
            order: 4,
            reference: 'stockStatus',
        },
        {
            id: '9999996',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'stock',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify({
                controlName: ControlName.dropdown,
                referenceType: ReferenceType.LookupTable,
                referenceName: 'stockStatus',
                readonly: false,
                key: 'stock',
                optionLabel: 'label',
                optionValue: 'id',
                validators: ['Validators.required'],
            }),
            dataTypeId: 'dataType.lookupTable',
            isArray: false,
            order: 4,
            reference: 'stockStatus',
        },
        {
            id: '70000',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'name',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '6',
            guiSettings: JSON.stringify(new InputTextConfiguration({
                readonly: false,
                key: 'name',
                validators: ['Validators.required'],
                basePathTranslation: 'entities.product.fields', //mudar
            })),
            dataTypeId: 'dataType.text',
            isArray: false,
            order: 1,
            reference: null, //referencia lookup
        },
        {
            id: '700001',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'id',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '6',
            guiSettings: null,
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: null,
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.entityType',
            entityTypeId: '6',
            guiSettings: 'asa',
            id: '225f5414-e317-4fd8-a6ed-d5cdd23e1e9c',
            isArray: true,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'items',
            operationId: null,
            order: 1,
            reference: 'DashboardItem',
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '6',
            guiSettings: 'sda',
            id: 'b8f206a8-44f6-41d0-853f-d3204fba1fa0',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'path',
            operationId: null,
            order: 1,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.default',
            entityTypeId: '6',
            guiSettings: 'ddd',
            id: '1a244e5d-6968-4c2e-b115-49b2d985d223',
            isArray: false,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'isPublic',
            operationId: null,
            order: 1,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '6',
            guiSettings: 'dddd',
            id: '805b41f8-a758-4b7e-8482-8c369aac37df',
            isArray: false,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'settings',
            operationId: null,
            order: 1,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '6',
            guiSettings: 'fd',
            id: 'd13ed5eb-ac5e-48dc-9e23-cda2637a41f6',
            isArray: true,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'entityTypeIds',
            operationId: null,
            order: 1,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '6',
            guiSettings: 'sdasd',
            id: 'b1631498-aad2-4871-8ba2-ffdfeeb0d235',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'createdBy',
            operationId: null,
            order: 8,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '8',
            guiSettings: 'hgfhghf',
            id: '9184e87c-2476-48c9-a867-9ece03c5bbbf',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'generalSettings',
            operationId: null,
            order: 1,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '8',
            guiSettings: 'asdasd',
            id: '6c9711c5-f885-4b9d-ae36-b9f989605ce6',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'imageUrl',
            operationId: null,
            order: 2,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '8',
            guiSettings: 'asdsfdf',
            id: '290aa8e8-65c3-4857-a75c-b0d367655d44',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'type',
            operationId: null,
            order: 3,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '8',
            guiSettings: 'asdsad',
            id: '1d058896-3622-4af8-82b6-f700097a7c3b',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'label',
            operationId: null,
            order: 4,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '8',
            guiSettings: 'sdads',
            id: '777bbf19-d863-41d3-8454-faefef83d381',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'id',
            operationId: null,
            order: 5,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
    ],
    EntityTypeAttribute: [
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'attribute111',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'sis',
        },
        {
            id: '2',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'attribute2',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 3,
            reference: 'sis',
        },
        {
            id: '3',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'attribute3',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            dataTypeId: 'dataType.default',
            isArray: false,
            order: 3,
            reference: 'sis',
        },
        {
            id: '4',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'attribute4',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 4,
            reference: 'sis',
        },
        {
            id: '5',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'customeraddress',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'customeraddress',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'customeraddress',
        },
        {
            id: '6',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'VAT',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'VAT',
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 1,
            reference: 'VAT',
        },
        {
            id: '7',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'city',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'city',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'city',
        },
        {
            id: '8',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'useraddress',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'useraddress',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'user address',
        },
        {
            id: '9',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'userdateofbirth',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'userdateofbirth',
            dataTypeId: 'dataType.date',
            isArray: false,
            order: 1,
            reference: 'user date of birth',
        },
        {
            id: '10',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'email',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'email',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'email',
        },
        {
            id: '9999999',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'discount',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: null,
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 5,
            reference: null,
        },
    ],
    EntityTypesOperations: [
        {
            id: '1',
            universalStateId: '1',
            label: null,
            transactionId: null,
            operationId: null,
            name: 'operation1',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '2',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label: null,
            name: 'operation2',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '3',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label: null,
            name: 'operation3',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '4',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label: null,
            name: 'operation4',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '5',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label: null,
            name: 'operation5',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '6',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'save',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify({
                disableWhenFormInvalid: true,
                visibleExpression: 'this.viewMode==="edit" && this.entity!= null && this.entity.id == null',
                key: 'save',
                toolbarSlot: ToolbarSlot.Left,
            }),
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Post,
            order: 0,
        },
        {
            id: '7',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'update',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify({
                key: 'update',
                disableWhenFormInvalid: true,
                visibleExpression: 'this.viewMode==="edit" && this.entity!= null && this.entity.id != null',
                toolbarSlot: ToolbarSlot.Left,
                executedActionBehaviour: new ExecutedActionBehaviour(),
            }),
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Put,
            order: 0,
        },
        {
            id: '8',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'delete',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify({
                visibleExpression: 'this.entity!= null && this.entity.id != null',
                key: 'delete',
                toolbarSlot: ToolbarSlot.Left,
                confirmationModal: 'message.delete-confirmation',
                executedActionBehaviour: new ExecutedActionBehaviour(),
            }),
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Delete,
            order: 0,
        },
        {
            id: '9',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'get',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: null,
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '10',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'updatePut',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: null,
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Put,
            order: 0,
        },
        {
            id: '999282828',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'view',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'create',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'update',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'delete',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
    ],
    product: [
        {
            id: '1',
            name: 'produto-1',
            description: 'produto-1-descrição',
            expiryDate: new Date(),
            value: 20,
            stock: 'stockStatus.available',
        },
        {
            id: '2',
            name: 'produto-2',
            description: 'produto-2-descrição',
            expiryDate: new Date(),
            value: 40,
            stock: 'stockStatus.unavailable',
        },
        {
            id: '3',
            name: 'produto-3',
            description: 'produto-3-descrição',
            expiryDate: new Date(),
            value: 15,
            stock: 'stockStatus.unavailable',
        },
        {
            id: '4',
            name: 'produto-4',
            description: 'produto-4-descrição',
            expiryDate: new Date(),
            value: 24,
            stock: 'stockStatus.available',
        },
        {
            id: '5',
            name: 'produto-5',
            description: 'produto-5-descrição',
            expiryDate: new Date(),
            value: 100,
            stock: 'stockStatus.available',
        },
        {
            id: '6',
            name: 'produto-6',
            description: 'produto-6-descrição',
            expiryDate: new Date(),
            value: 2,
            stock: 'stockStatus.available',
        },
        {
            id: '7',
            name: 'produto-7',
            description: 'produto-7-descrição',
            expiryDate: new Date(),
            value: 15.99,
            stock: 'stockStatus.unavailable',
        },
        {
            id: '8',
            name: 'produto-8',
            description: 'produto-8-descrição',
            expiryDate: new Date(),
            value: 92,
            stock: 'stockStatus.unavailable',
            attributes: {
                discount: 50,
            },
        },
        {
            id: '9',
            name: 'produto-9',
            description: 'produto-9-descrição',
            expiryDate: new Date(),
            value: 165,
            stock: 'stockStatus.available',
        },
        {
            id: '10',
            name: 'produto-10',
            description: 'produto-10-descrição',
            expiryDate: new Date(),
            value: 11,
            stock: 'stockStatus.available',
        },
    ],
    dashboard: [
        new Dashboard({
            name: 'MainDashboard',
            id: '1',
            path: 'Config/DashBoards/1',
            isPublic: true,
            settings: null,
            items: [
                new DashboardItem({
                    universalStateId: '1',
                    x: 1,
                    y: 0,
                    cols: 1,
                    id: '1679938981323',
                    rows: 1,
                    dashboardId: '1',
                    settings: null,
                    componentType: 'Bar-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 0,
                    cols: 1,
                    id: '1679931545',
                    rows: 1,
                    dashboardId: '1',
                    settings: null,
                    componentType: 'Table',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 1,
                    cols: 1,
                    rows: 1,
                    id: '1679995',
                    dashboardId: '1',
                    settings: null,
                    componentType: 'Line-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 1,
                    y: 1,
                    cols: 1,
                    rows: 1,
                    dashboardId: '1',
                    id: '1678975',
                    settings: null,
                    componentType: 'Table',
                }),
            ],
            entityTypeIds: ['1'],
            createdBy: '1',
        }),
        new Dashboard({
            name: 'SecondDashboard',
            id: '2',
            path: 'Config/DashBoards/2',
            isPublic: true,
            settings: null,
            items: [
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 0,
                    cols: 2,
                    rows: 1,
                    id: '165455',
                    dashboardId: '1',
                    settings: null,
                    componentType: 'Bar-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 1,
                    cols: 1,
                    rows: 1,
                    id: '16547775',
                    dashboardId: '1',
                    settings: null,
                    componentType: 'Line-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 1,
                    y: 1,
                    cols: 1,
                    rows: 1,
                    dashboardId: '1',
                    id: '1654754878775',
                    settings: null,
                    componentType: 'Table',
                }),
            ],
            entityTypeIds: ['1'],
            createdBy: '1',
        }),
        new Dashboard({
            universalStateId: '1',
            isPublic: true,
            id: '3',
            name: 'ThirdDashboard',
            createdBy: '2',
            entityTypeIds: ['1', '4'],
            items: [
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 0,
                    cols: 1,
                    rows: 1,
                    dashboardId: '3',
                    id: '1679933',
                    settings: null,
                    componentType: 'Bar-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 1,
                    cols: 1,
                    rows: 1,
                    id: '16799387851543',
                    dashboardId: '3',
                    settings: null,
                    componentType: 'Bar-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 1,
                    y: 0,
                    cols: 1,
                    rows: 1,
                    id: '16799387851548',
                    dashboardId: '3',
                    settings: null,
                    componentType: 'Bar-Chart',
                }),
            ],
            settings: '{"gridType":"fit","scale":1,"fixedColWidth":250,"fixedRowHeight":250,"keepFixedHeightInMobile":false,"keepFixedWidthInMobile":false,"setGridSize":false,"useBodyForBreakpoint":false,"compactType":"none","mobileBreakpoint":640,"allowMultiLayer":false,"defaultLayerIndex":1,"maxLayerIndex":2,"baseLayerIndex":1,"minCols":1,"maxCols":100,"minRows":1,"maxRows":100,"defaultItemCols":1,"defaultItemRows":1,"maxItemCols":50,"maxItemRows":50,"minItemCols":1,"minItemRows":1,"minItemArea":1,"maxItemArea":2500,"addEmptyRowsCount":0,"rowHeightRatio":1,"margin":5,"outerMargin":true,"useTransformPositioning":true,"scrollSensitivity":10,"scrollSpeed":20,"draggable.enabled":true,"draggable.delayStart":0,"draggable.ignoreContentClass":"gridster-item-content","draggable.ignoreContent":false,"draggable.dragHandleClass":"drag-handle","draggable.dropOverItems":false,"resizable.enabled":true,"resizable.delayStart":0,"resizable.handles.s":true,"resizable.handles.e":true,"resizable.handles.n":true,"resizable.handles.w":true,"resizable.handles.se":true,"resizable.handles.ne":true,"resizable.handles.sw":true,"resizable.handles.nw":true,"swap":true,"swapWhileDragging":false,"pushItems":false,"disablePushOnDrag":false,"disablePushOnResize":false,"disableAutoPositionOnConflict":false,"pushDirections.north":true,"pushDirections.east":true,"pushDirections.south":true,"pushDirections.west":true,"pushResizeItems":false,"displayGrid":"always","disableWindowResize":false,"disableWarnings":false,"scrollToNewItems":false,"disableScrollHorizontal":false,"disableScrollVertical":false,"enableBoundaryControl":false,"enableEmptyCellClick":true,"enableEmptyCellContextMenu":false,"enableEmptyCellDrop":false,"enableEmptyCellDrag":true,"enableOccupiedCellDrop":false,"emptyCellDragMaxCols":50,"emptyCellDragMaxRows":50,"ignoreMarginInRow":false,"dirType":"ltr"}',
        }),
        new Dashboard({
            universalStateId: '1',
            isPublic: true,
            id: '725cc79c-6e7e-4391-81cc-42de6ed8781e',
            name: 'FouthDashboard',
            entityTypeIds: ['1', '2'],
            items: [
                new DashboardItem({
                    universalStateId: '1',
                    x: 1,
                    y: 0,
                    cols: 1,
                    rows: 1,
                    id: '16799387851888',
                    dashboardId: '725cc79c-6e7e-4391-81cc-42de6ed8781e',
                    settings: null,
                    componentType: 'Line-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 0,
                    cols: 1,
                    id: '1679938785788',
                    rows: 1,
                    dashboardId: '725cc79c-6e7e-4391-81cc-42de6ed8781e',
                    settings: null,
                    componentType: 'Doughnut-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 1,
                    cols: 1,
                    rows: 1,
                    dashboardId: '725cc79c-6e7e-4391-81cc-42de6ed8781e',
                    id: '1679938785788444',
                    settings: null,
                    componentType: 'Bar-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 1,
                    y: 1,
                    cols: 1,
                    id: '2679938785788',
                    rows: 1,
                    dashboardId: '725cc79c-6e7e-4391-81cc-42de6ed8781e',
                    settings: null,
                    componentType: 'Table',
                }),
            ],
            createdBy: '2',
            settings: '{"gridType":"fit","scale":1,"fixedColWidth":250,"fixedRowHeight":250,"keepFixedHeightInMobile":false,"keepFixedWidthInMobile":false,"setGridSize":false,"useBodyForBreakpoint":false,"compactType":"none","mobileBreakpoint":640,"allowMultiLayer":false,"defaultLayerIndex":1,"maxLayerIndex":2,"baseLayerIndex":1,"minCols":1,"maxCols":100,"minRows":1,"maxRows":100,"defaultItemCols":1,"defaultItemRows":1,"maxItemCols":50,"maxItemRows":50,"minItemCols":1,"minItemRows":1,"minItemArea":1,"maxItemArea":2500,"addEmptyRowsCount":0,"rowHeightRatio":1,"margin":5,"outerMargin":true,"useTransformPositioning":true,"scrollSensitivity":10,"scrollSpeed":20,"draggable.enabled":true,"draggable.delayStart":0,"draggable.ignoreContentClass":"gridster-item-content","draggable.ignoreContent":false,"draggable.dragHandleClass":"drag-handle","draggable.dropOverItems":false,"resizable.enabled":true,"resizable.delayStart":0,"resizable.handles.s":true,"resizable.handles.e":true,"resizable.handles.n":true,"resizable.handles.w":true,"resizable.handles.se":true,"resizable.handles.ne":true,"resizable.handles.sw":true,"resizable.handles.nw":true,"swap":true,"swapWhileDragging":false,"pushItems":false,"disablePushOnDrag":false,"disablePushOnResize":false,"disableAutoPositionOnConflict":false,"pushDirections.north":true,"pushDirections.east":true,"pushDirections.south":true,"pushDirections.west":true,"pushResizeItems":false,"displayGrid":"always","disableWindowResize":false,"disableWarnings":false,"scrollToNewItems":false,"disableScrollHorizontal":false,"disableScrollVertical":false,"enableBoundaryControl":false,"enableEmptyCellClick":true,"enableEmptyCellContextMenu":false,"enableEmptyCellDrop":false,"enableEmptyCellDrag":true,"enableOccupiedCellDrop":false,"emptyCellDragMaxCols":50,"emptyCellDragMaxRows":50,"ignoreMarginInRow":false,"dirType":"ltr"}',
        }),
    ],
    componentType: [
        new ComponentType({
            id: '1',
            type: ComponentTypeEnum.BarChart,
            name: 'Bar Chart',
            imageUrl: '/assets/images/component_type_images/bar-chart.PNG',
            generalSettings: null,
        }),
        new ComponentType({
            id: '2',
            type: ComponentTypeEnum.LineChart,
            name: 'Line Chart',
            imageUrl: '/assets/images/component_type_images/line-chart.PNG',
            generalSettings: null,
        }),
        new ComponentType({
            id: '3',
            type: ComponentTypeEnum.DoughnutChart,
            name: 'Donut Chart',
            imageUrl: '/assets/images/component_type_images/donut-chart.PNG',
            generalSettings: null,
        }),
        new ComponentType({
            id: '4',
            type: ComponentTypeEnum.Table,
            name: 'Table',
            imageUrl: '/assets/images/component_type_images/table.PNG',
            generalSettings: null,
        }),
    ],
};

/**
 * injectable
 */
/**
 * class MockEntityTypesService
 */
class MockEntityTypesService extends AbstractEntityTypeService {
    /**
     * constructor
     * @param utilityService
     * @param objectsUtilityService
     * @param notificationsService
     * @param arrayUtilityService
     * @param isLoadingData
     * @param translateService
     */
    constructor(utilityService, objectsUtilityService, notificationsService, arrayUtilityService, isLoadingData, translateService) {
        super(notificationsService, translateService);
        this.utilityService = utilityService;
        this.objectsUtilityService = objectsUtilityService;
        this.arrayUtilityService = arrayUtilityService;
        this.isLoadingData = isLoadingData;
        /**
         * default time in seconds
         */
        this.sleepTimeSec = 0.2;
    }
    /**
     * Get all Entity Types
     *
     * @Returns Entity types[]
     */
    getEntityTypeListAsync() {
        return new Promise(async (resolve, reject) => {
            if (this.isCacheValid()) {
                const values = this.getElementsList();
                resolve(values);
            }
            else {
                this.isLoadingData.show();
                await this.utilityService.sleepSecAsync(this.sleepTimeSec);
                const entityTypeList = this.arrayUtilityService.clone(MockDatabase$1.EntityTypes);
                this.isLoadingData.hide();
                if (entityTypeList !== null && entityTypeList.length > 0) {
                    const entityTypeTranslation = (await this.getTranslationsAsync(entityTypeList));
                    this.setToCache(entityTypeTranslation, 'name');
                    resolve(entityTypeTranslation);
                }
                else {
                    this.notificationsService.errorNotification(new PrgError({
                        titleKey: 'error',
                        detailKey: 'errorGetEntityTypeList',
                    }));
                    reject('Error');
                }
            }
        });
    }
    /**
     * Get entity type list with operation
     *
     *  @Returns Entity types[]
     */
    getEntityTypeListWithOperationAsync() {
        return new Promise(async (resolve, reject) => {
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const entityTypeList = this.arrayUtilityService.clone(MockDatabase$1.EntityTypes);
            this.isLoadingData.hide();
            if (entityTypeList !== null && entityTypeList.length > 0) {
                entityTypeList.forEach((entityType) => {
                    entityType.operations = this.arrayUtilityService
                        .clone(MockDatabase$1.EntityTypesOperations)
                        .filter((operation) => operation.entityTypeId === entityType.id);
                });
                const entityTypeTranslation = (await this.getTranslationsAsync(entityTypeList));
                this.setToCache(entityTypeTranslation, 'name');
                resolve(entityTypeTranslation);
            }
            else {
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'error',
                    detailKey: 'errorGetEntityTypeList',
                }));
                reject('Error');
            }
        });
    }
    /**
     * save entity type
     * @param entityType
     * @return Entity type
     */
    saveEntityTypeAsync(entityType) {
        return new Promise(async (resolve, reject) => {
            if (entityType.id) {
                const entityTypeToUpdate = MockDatabase$1.EntityTypes.find((et) => et.id === entityType.id);
                if (entityTypeToUpdate) {
                    entityTypeToUpdate.guiSettings = entityType.guiSettings;
                    entityTypeToUpdate.group = entityType.group;
                    entityTypeToUpdate.universalStateId = entityType.universalStateId;
                    //set catch
                    this.setToCache(this.objectsUtilityService.cloneObject(entityTypeToUpdate), 'name');
                    resolve(this.objectsUtilityService.cloneObject(entityTypeToUpdate));
                    this.notificationsService.successNotification(new PrgSucess({
                        titleKey: 'success',
                        detailKey: 'entityTypeUpdatedSucess',
                    }));
                }
                else {
                    this.notificationsService.errorNotification(new PrgError({
                        titleKey: 'error',
                        detailKey: 'entityTypeUpdatedError',
                    }));
                    reject(null);
                }
            }
            else {
                const newEntityType = {
                    id: this.utilityService.newGuid(),
                    universalStateId: entityType.universalStateId,
                    transactionId: null,
                    operationId: null,
                    label: null,
                    name: entityType.name,
                    createdBy: null,
                    modifiedBy: null,
                    createdOn: null,
                    modifiedOn: null,
                    stateId: '1',
                    workspaceId: '1',
                    guiSettings: entityType.guiSettings,
                    group: entityType.group,
                    properties: null,
                    attributes: null,
                    operations: null,
                };
                const entityTypeList = MockDatabase$1.EntityTypes;
                entityTypeList.unshift(newEntityType);
                this.setToCache(this.objectsUtilityService.cloneObject(newEntityType), 'name');
                resolve(this.objectsUtilityService.cloneObject(newEntityType));
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'success',
                    detailKey: 'entityTypeSuccessAdded',
                }));
            }
        });
    }
    /**
     * get all operations of an entity
     * @param entityTypeId
     * @return EntityTypeOperation[]
     */
    getAllOperationsByEntityTypeIdAsync(entityTypeId) {
        return new Promise((resolve, reject) => {
            const entityTypeOperationList = this.arrayUtilityService
                .clone(MockDatabase$1.EntityTypesOperations)
                .filter((operation) => operation.entityTypeId === entityTypeId);
            if (entityTypeOperationList) {
                resolve(entityTypeOperationList);
            }
            else {
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'error',
                    detailKey: 'errorGetEntityTypeOperationsList',
                }));
                reject('Error');
            }
        });
    }
    /**
     * add or update entity type operation
     * @param entityTypeOperation
     * @return EntityTypeOperation
     */
    saveEntityTypeOperationAsync(entityTypeOperation) {
        return new Promise(async (resolve, reject) => {
            if (entityTypeOperation.id) {
                const entityTypeOperationToUpdate = MockDatabase$1.EntityTypesOperations.find((eto) => eto.id === entityTypeOperation.id);
                if (entityTypeOperationToUpdate) {
                    entityTypeOperationToUpdate.httpVerb = entityTypeOperation.httpVerb;
                    entityTypeOperationToUpdate.universalStateId =
                        entityTypeOperation.universalStateId;
                    entityTypeOperationToUpdate.guiSettings =
                        entityTypeOperation.guiSettings;
                    entityTypeOperationToUpdate.imports = entityTypeOperation.imports;
                    entityTypeOperationToUpdate.override = entityTypeOperation.override;
                    entityTypeOperationToUpdate.universalStateId =
                        entityTypeOperation.universalStateId;
                    resolve(this.objectsUtilityService.cloneObject(entityTypeOperationToUpdate));
                    /*  this.setEntityTypeOperationByEntityTypeId(
                      this.objectsUtilityService.cloneObject(entityTypeOperationToUpdate)
                    );*/
                    this.notificationsService.successNotification(new PrgSucess({
                        titleKey: 'success',
                        detailKey: 'entityTypeOperationUpdatedSucess',
                    }));
                }
                else {
                    this.notificationsService.errorNotification(new PrgError({
                        titleKey: 'error',
                        detailKey: 'entityTypeOperationUpdatedError',
                    }));
                    reject(null);
                }
            }
            else {
                const newEntityTypeOperation = new EntityTypeOperation({
                    id: this.utilityService.newGuid(),
                    universalStateId: entityTypeOperation.universalStateId,
                    transactionId: null,
                    operationId: null,
                    name: entityTypeOperation.name,
                    createdBy: null,
                    modifiedBy: null,
                    createdOn: null,
                    modifiedOn: null,
                    workspaceId: '1',
                    entityTypeId: entityTypeOperation.entityTypeId,
                    guiSettings: entityTypeOperation.guiSettings,
                    override: entityTypeOperation.override,
                    imports: entityTypeOperation.imports,
                    sourceCode: 'source code',
                    httpVerb: entityTypeOperation.httpVerb,
                });
                const entityTypeOperationList = MockDatabase$1.EntityTypesOperations;
                entityTypeOperationList.unshift(newEntityTypeOperation);
                resolve(this.objectsUtilityService.cloneObject(newEntityTypeOperation));
                /*this.setEntityTypeOperationByEntityTypeId(
                  this.objectsUtilityService.cloneObject(newEntityTypeOperation)
                );*/
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'success',
                    detailKey: 'entityTypeOperationSuccessAdded',
                }));
            }
        });
    }
    /**
     * get all attributes of an entity
     * @param entityTypeId
     * @return EntityTypeAttribute[]
     */
    getAllAttributesByEntityTypeIdAsync(entityTypeId) {
        return new Promise((resolve, reject) => {
            const entityTypeAttributeList = this.arrayUtilityService
                .clone(MockDatabase$1.EntityTypeAttribute)
                .filter((operation) => operation.entityTypeId === entityTypeId);
            if (entityTypeAttributeList) {
                resolve(entityTypeAttributeList);
            }
            else {
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'error',
                    detailKey: 'errorGetEntityTypeAttributeListList',
                }));
                reject('Error');
            }
        });
    }
    /**
     * add or update entity type attribute
     * @param entityTypeAttribute
     * @return EntityTypeAttribute
     */
    saveEntityTypeAttributeAsync(entityTypeAttribute) {
        return new Promise(async (resolve, reject) => {
            if (entityTypeAttribute.id) {
                const entityTypeAttributeToUpdate = MockDatabase$1.EntityTypeAttribute.find((eta) => eta.id === entityTypeAttribute.id);
                if (entityTypeAttributeToUpdate) {
                    Object.assign(entityTypeAttributeToUpdate, entityTypeAttribute);
                    resolve(this.objectsUtilityService.cloneObject(entityTypeAttributeToUpdate));
                    //TODO: UPDATE CACHE
                    this.notificationsService.successNotification(new PrgSucess({
                        titleKey: 'success',
                        detailKey: 'entityTypeAttributeUpdatedSucess',
                    }));
                }
                else {
                    this.notificationsService.errorNotification(new PrgError({
                        titleKey: 'error',
                        detailKey: 'entityTypeAttributeUpdatedError',
                    }));
                    reject(null);
                }
            }
            else {
                const newEntityTypeAttribute = new EntityTypeAttribute({
                    id: this.utilityService.newGuid(),
                    universalStateId: entityTypeAttribute.universalStateId,
                    transactionId: null,
                    operationId: null,
                    name: entityTypeAttribute.name,
                    createdBy: null,
                    label: null,
                    modifiedBy: null,
                    createdOn: null,
                    modifiedOn: null,
                    workspaceId: '1',
                    entityTypeId: entityTypeAttribute.entityTypeId,
                    guiSettings: entityTypeAttribute.guiSettings,
                    dataTypeId: entityTypeAttribute.dataTypeId,
                    order: entityTypeAttribute.order,
                    reference: entityTypeAttribute.reference,
                    isArray: entityTypeAttribute.isArray,
                });
                const entityTypeAttributeList = MockDatabase$1.EntityTypeAttribute;
                entityTypeAttributeList.unshift(newEntityTypeAttribute);
                resolve(this.objectsUtilityService.cloneObject(newEntityTypeAttribute));
                //TODO: Update cache
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'success',
                    detailKey: 'entityTypeAttributeSuccessAdded',
                }));
            }
        });
    }
    /**
     * get all properties of an entity
     * @param entityTypeId
     * @return EntityTypeProperty[]
     */
    getAllPropertiesByEntityTypeIdAsync(entityTypeId) {
        return new Promise((resolve, reject) => {
            const entityTypePropertynList = this.arrayUtilityService
                .clone(MockDatabase$1.EntityTypeProperty)
                .filter((operation) => operation.entityTypeId === entityTypeId);
            if (entityTypePropertynList) {
                resolve(entityTypePropertynList);
            }
            else {
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'error',
                    detailKey: 'errorGetEntityTypePropertynListList',
                }));
                reject('Error');
            }
        });
    }
    /**
     * add or update entity type property
     * @param EntityTypeProperty
     * @return EntityTypeProperty
     */
    saveEntityTypePropertyAsync(entityTypeProperty) {
        return new Promise(async (resolve, reject) => {
            if (entityTypeProperty.id) {
                const entityTypePropertyToUpdate = MockDatabase$1.EntityTypeProperty.find((etp) => etp.id === entityTypeProperty.id);
                if (entityTypePropertyToUpdate) {
                    Object.assign(entityTypePropertyToUpdate, entityTypeProperty);
                    resolve(this.objectsUtilityService.cloneObject(entityTypePropertyToUpdate));
                    //TODO: UPDATE CACHE
                    this.notificationsService.successNotification(new PrgSucess({
                        titleKey: 'success',
                        detailKey: 'entityTypePropertyUpdatedSucess',
                    }));
                }
                else {
                    this.notificationsService.errorNotification(new PrgError({
                        titleKey: 'error',
                        detailKey: 'entityTypePropertyUpdatedError',
                    }));
                    reject(null);
                }
            }
            else {
                const newEntityTypeProperty = new EntityTypeProperty({
                    id: this.utilityService.newGuid(),
                    universalStateId: entityTypeProperty.universalStateId,
                    transactionId: null,
                    operationId: null,
                    name: entityTypeProperty.name,
                    createdBy: null,
                    modifiedBy: null,
                    label: null,
                    createdOn: null,
                    modifiedOn: null,
                    workspaceId: '1',
                    entityTypeId: entityTypeProperty.entityTypeId,
                    guiSettings: entityTypeProperty.guiSettings,
                    dataTypeId: entityTypeProperty.dataTypeId,
                    order: entityTypeProperty.order,
                    reference: entityTypeProperty.reference,
                    isArray: entityTypeProperty.isArray,
                });
                const entityTypePropertyList = MockDatabase$1.EntityTypeProperty;
                entityTypePropertyList.unshift(newEntityTypeProperty);
                resolve(this.objectsUtilityService.cloneObject(newEntityTypeProperty));
                //TODO: Update cache
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'success',
                    detailKey: 'entityTypePropertySuccessAdded',
                }));
            }
        });
    }
    /**
     * update entity type properties using patch logic
     * @param entityTypesPropertiesToPatch
     * @return EntityTypeProperty[]
     */
    updateEntityTypePropertiesAsync(entityTypesPropertiesToPatch) {
        return new Promise(async (resolve, reject) => {
            const updated = [];
            entityTypesPropertiesToPatch.forEach((fieldsToPatch, key) => {
                const entityTypePropertyToUpdate = MockDatabase$1.EntityTypeProperty.find((etp) => etp.id === key);
                updated.push(this.objectsUtilityService.cloneObject(Object.assign(entityTypePropertyToUpdate, fieldsToPatch)));
            });
            resolve(updated);
        });
    }
    /**
     * update entity type attributes using patch logic
     * @param entityTypesAttributesToPatch
     * @return EntityTypeAttribute[]
     */
    updateEntityTypeAttributesAsync(entityTypesAttributesToPatch) {
        return new Promise(async (resolve, reject) => {
            entityTypesAttributesToPatch.forEach((fieldsToPatch, key) => {
                const entityTypeAttributesToUpdate = MockDatabase$1.EntityTypeAttribute.find((eta) => eta.id === key);
                Object.assign(entityTypeAttributesToUpdate, fieldsToPatch);
            });
            resolve(this.arrayUtilityService.clone(MockDatabase$1.EntityTypeProperty));
        });
    }
    /**
     * this service returns all the data (properties, attributes and operations)
     * of a given entity type (by entity name)
     * @param entityTypeName
     */
    getAllEntityTypeDataByName(entityTypeName) {
        return new Promise(async (resolve, reject) => {
            let entityType = this.arrayUtilityService
                .clone(MockDatabase$1.EntityTypes)
                .find((entity) => entity.name === entityTypeName);
            if (entityType) {
                entityType.properties = this.arrayUtilityService
                    .clone(MockDatabase$1.EntityTypeProperty)
                    .filter((property) => property.entityTypeId === entityType.id);
                entityType.attributes = this.arrayUtilityService
                    .clone(MockDatabase$1.EntityTypeAttribute)
                    .filter((attribute) => attribute.entityTypeId === entityType.id);
                entityType.operations = this.arrayUtilityService
                    .clone(MockDatabase$1.EntityTypesOperations)
                    .filter((operation) => operation.entityTypeId === entityType.id);
                entityType = await this.getTranslationsAsync(entityType);
                resolve(entityType);
            }
        });
    }
    /**
     * this service returns an array of elements
     * of the entity sent as a parameter,
     *  based on the filter it receives as a parameter.
     * @param entityTypeName
     * @param FilterGroup
     */
    getEntityTypeElements(entityTypeName, filterGroup) {
        return new Promise(async (resolve, reject) => {
            let entityElementsAux = [];
            entityElementsAux = this.arrayUtilityService.clone(MockDatabase$1[entityTypeName]);
            if ('orderCollection' in filterGroup) {
                entityElementsAux = this.arrayUtilityService.sortByProperty(entityElementsAux, filterGroup.orderCollection[0].propertyName, filterGroup.orderCollection[0].orderType === 0 ? true : false);
            }
            if ('filterCollections' in filterGroup) {
                filterGroup.filterCollections.forEach((filter) => {
                    entityElementsAux = entityElementsAux.filter((element) => element[filter.propertyName].includes(filter.value));
                });
            }
            const qtdElement = entityElementsAux.length;
            entityElementsAux = entityElementsAux.slice(filterGroup.pageIndex * filterGroup.pageSize, (filterGroup.pageIndex + 1) * filterGroup.pageSize);
            resolve(new PaginationResponse({
                items: entityElementsAux,
                totalItems: qtdElement,
                currentPage: filterGroup.pageIndex,
            }));
        });
    }
    /**
     * Get all properties and attributes by entity type id
     * @param {string} entityTypeId
     * @returns {Promise<EntityTypeProperty[]>}
     */
    getAllPropertiesAndAttributesByEntityTypeIdAsync(entityTypeId) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            this.isLoadingData.hide();
            let entityType = MockDatabase$1.EntityTypes.find((entityType) => entityType.id === entityTypeId);
            const entityTypeProperties = [...MockDatabase$1.EntityTypeProperty].filter((entityTypeProperty) => entityTypeProperty.entityTypeId === entityTypeId);
            const entityTypeAttributes = [...MockDatabase$1.EntityTypeAttribute].filter((entityTypeAttributes) => entityTypeAttributes.entityTypeId === entityTypeId);
            entityType.properties = [...entityTypeProperties];
            entityType.attributes = [...entityTypeAttributes];
            const entityTypeToTranslate = (await this.getTranslationsAsync(entityType));
            const entityTypePropertyAndAttributesList = [
                ...entityTypeToTranslate.properties,
                ...entityTypeToTranslate.attributes,
            ];
            this.isLoadingData.hide();
            if (entityTypePropertyAndAttributesList.length > 0) {
                resolve(entityTypePropertyAndAttributesList);
            }
            else {
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'error',
                    detailKey: 'errorGetEntityTypePropertynListList',
                }));
                reject('Error');
            }
        });
    }
    /**
     * This service return a element from a entity type list by id
     * @param entityTypeName
     * @param elementId
     */
    getEntityTypeElementById(entityTypeName, elementId) {
        return new Promise(async (resolve, reject) => {
            const element = this.objectsUtilityService.cloneObject(MockDatabase$1[entityTypeName].find((element) => element.id === elementId));
            resolve(element);
        });
    }
    /**
     * this service excute an operation
     * @param entityName
     * @param operation
     * @param entity
     * @returns
     */
    executeAction(entityName, operation, entity) {
        return new Promise(async (resolve, reject) => {
            switch (operation.name) {
                case 'save':
                    resolve(this.saveOperationProduct(entity));
                    break;
                case 'delete':
                    resolve(this.deleteOperationProduct(entity));
                    break;
                case 'update':
                    resolve(this.updateOperationProduct(entity));
                    break;
                default:
                    this.notificationsService.errorNotification(new PrgError({
                        titleKey: 'error',
                        detailKey: 'operationNotFound',
                    }));
                    break;
            }
        });
    }
    /**
     * operations save product
     * @param element
     * @returns
     */
    saveOperationProduct(element) {
        if (element.id) {
            const productToUpdate = MockDatabase$1.product.find((product) => product.id === element.id);
            Object.assign(productToUpdate, element);
        }
        else {
            element['id'] = this.utilityService.newGuid();
            MockDatabase$1.product.unshift(element);
            return this.objectsUtilityService.cloneObject(element);
        }
    }
    /**
     * operation delte product
     * @param element
     * @returns
     */
    deleteOperationProduct(element) {
        const elementToDeleteIndex = MockDatabase$1.product.findIndex((product) => product.id === element.id);
        MockDatabase$1.product.splice(elementToDeleteIndex, 1);
        return element;
    }
    /**
     *  operation update product
     * @param element
     * @returns
     */
    updateOperationProduct(element) {
        const elementToUpdate = MockDatabase$1.product.find((product) => product.id === element.id);
        if (elementToUpdate) {
            Object.assign(elementToUpdate, element);
            return elementToUpdate;
        }
    }
}
MockEntityTypesService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockEntityTypesService, deps: [{ token: UtilityService }, { token: ObjectsUtilityService }, { token: NotificationsService }, { token: ArrayUtilityService }, { token: IsLoadingDataService }, { token: TranslateService }], target: i0.ɵɵFactoryTarget.Injectable });
MockEntityTypesService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockEntityTypesService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockEntityTypesService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: UtilityService }, { type: ObjectsUtilityService }, { type: NotificationsService, decorators: [{
                    type: Inject,
                    args: [NotificationsService]
                }] }, { type: ArrayUtilityService }, { type: IsLoadingDataService }, { type: i5.TranslateService, decorators: [{
                    type: Inject,
                    args: [TranslateService]
                }] }]; } });

/**
 * PrgEntityTypeElementPage
 */
class PrgEntityTypeElementPage {
    /**
     * constructor
     * @param route
     * @param router
     * @param entityTypeService
     * @param objectsUtilityService
     */
    constructor(route, router, entityTypeService, objectsUtilityService) {
        this.route = route;
        this.router = router;
        this.entityTypeService = entityTypeService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * viewMode
         */
        this.viewMode = ViewMode.Read;
    }
    /**
     * ngOnInit
     */
    async ngOnInit() {
        // get params from url
        this.route.paramMap.subscribe((params) => {
            this.entityTypeName = params.get('entityTypeName');
            this.entityTypeElementID = params.get('id');
        });
        this.getEntityTypeData(this.entityTypeName);
        if (this.entityTypeElementID == 'new') {
            this.element = {};
            this.viewMode = ViewMode.Edit;
        }
        else {
            const elementAux = await this.getEntityTypeElementData(this.entityTypeName, this.entityTypeElementID);
            // check if element exist
            if (elementAux) {
                this.element = this.objectsUtilityService.cloneObject(elementAux);
            }
            else {
                this.router.navigate(['../'], { relativeTo: this.route });
            }
        }
    }
    /**
     * this function fetches the data from the entityType based on the entity type name
     * @param entityTypeName
     */
    async getEntityTypeData(entityTypeName) {
        this.entityType = await this.entityTypeService.getAllEntityTypeDataByName(entityTypeName);
    }
    /**
     * this function fetches the data from the entityType
     * element based on the entity type name and element id
     * @param entitiesTypeName
     * @param elementId
     * @returns
     */
    async getEntityTypeElementData(entitiesTypeName, elementId) {
        return await this.entityTypeService.getEntityTypeElementById(entitiesTypeName, elementId);
    }
}
PrgEntityTypeElementPage.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypeElementPage, deps: [{ token: i1$1.ActivatedRoute }, { token: i1$1.Router }, { token: AbstractEntityTypeService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgEntityTypeElementPage.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgEntityTypeElementPage, selector: "prg-entity-type-element-page", ngImport: i0, template: "<div>\r\n  <prg-entity-type-element\r\n    [entityType]=\"entityType\"\r\n    [element]=\"element\"\r\n    [elementViewMode]=\"viewMode\"\r\n  ></prg-entity-type-element>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "component", type: PrgEntityTypeElementComponent, selector: "prg-entity-type-element", inputs: ["element", "entityType", "elementViewMode"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypeElementPage, decorators: [{
            type: Component,
            args: [{ selector: 'prg-entity-type-element-page', template: "<div>\r\n  <prg-entity-type-element\r\n    [entityType]=\"entityType\"\r\n    [element]=\"element\"\r\n    [elementViewMode]=\"viewMode\"\r\n  ></prg-entity-type-element>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1$1.ActivatedRoute }, { type: i1$1.Router }, { type: AbstractEntityTypeService }, { type: ObjectsUtilityService }]; } });

/**
 * page entity types
 */
class PrgEntityTypesPage {
}
PrgEntityTypesPage.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesPage, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgEntityTypesPage.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgEntityTypesPage, selector: "prg-entity-types", ngImport: i0, template: "<div><prg-list-entity-types></prg-list-entity-types></div>\r\n", styles: [""], dependencies: [{ kind: "component", type: PrgListEntityTypesComponent, selector: "prg-list-entity-types" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesPage, decorators: [{
            type: Component,
            args: [{ selector: 'prg-entity-types', template: "<div><prg-list-entity-types></prg-list-entity-types></div>\r\n" }]
        }] });

/**
 * Specific Entity type page
 */
/**
 * PrgSpecificEntityTypePage
 */
class PrgSpecificEntityTypePage {
    /**
     * constructor
     * @param route
     */
    constructor(route) {
        this.route = route;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.route.paramMap.subscribe((params) => {
            this.entityTypeName = params.get('entityTypeName');
        });
    }
}
PrgSpecificEntityTypePage.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSpecificEntityTypePage, deps: [{ token: i1$1.ActivatedRoute }], target: i0.ɵɵFactoryTarget.Component });
PrgSpecificEntityTypePage.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSpecificEntityTypePage, selector: "prg-specific-entity-type", ngImport: i0, template: "<div>\r\n  <prg-list-specific-entity-type\r\n    [entityTypeName]=\"entityTypeName\"\r\n  ></prg-list-specific-entity-type>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "component", type: PrgListSpecificEntityTypeComponent, selector: "prg-list-specific-entity-type", inputs: ["entityTypeName", "onClickGoTo"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSpecificEntityTypePage, decorators: [{
            type: Component,
            args: [{ selector: 'prg-specific-entity-type', template: "<div>\r\n  <prg-list-specific-entity-type\r\n    [entityTypeName]=\"entityTypeName\"\r\n  ></prg-list-specific-entity-type>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1$1.ActivatedRoute }]; } });

/**
 * Authentication routing module routes
 */
const standardRoutes$5 = [];
class PrgEntityTypesRoutingModule {
}
PrgEntityTypesRoutingModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesRoutingModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
PrgEntityTypesRoutingModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesRoutingModule, imports: [i1$1.RouterModule], exports: [RouterModule] });
PrgEntityTypesRoutingModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesRoutingModule, providers: [
        {
            provide: ROUTES,
            useFactory: () => {
                let routes = [];
                routes.push({
                    path: entityTypesConfig.entityTypeBasePath,
                    component: PrgLayoutsHeaderSidebarComponent,
                    children: [
                        {
                            path: '',
                            component: PrgEntityTypesPage,
                        },
                        {
                            path: ':entityTypeName',
                            component: PrgSpecificEntityTypePage,
                        },
                        {
                            path: ':entityTypeName/:id',
                            component: PrgEntityTypeElementPage,
                        },
                    ],
                });
                return [...routes, ...standardRoutes$5];
            },
            multi: true,
        },
    ], imports: [RouterModule.forChild(standardRoutes$5), RouterModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesRoutingModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [RouterModule.forChild(standardRoutes$5)],
                    exports: [RouterModule],
                    providers: [
                        {
                            provide: ROUTES,
                            useFactory: () => {
                                let routes = [];
                                routes.push({
                                    path: entityTypesConfig.entityTypeBasePath,
                                    component: PrgLayoutsHeaderSidebarComponent,
                                    children: [
                                        {
                                            path: '',
                                            component: PrgEntityTypesPage,
                                        },
                                        {
                                            path: ':entityTypeName',
                                            component: PrgSpecificEntityTypePage,
                                        },
                                        {
                                            path: ':entityTypeName/:id',
                                            component: PrgEntityTypeElementPage,
                                        },
                                    ],
                                });
                                return [...routes, ...standardRoutes$5];
                            },
                            multi: true,
                        },
                    ],
                }]
        }] });

/**
 * Injectable
 */
class EntityTypeService extends AbstractEntityTypeService {
    /**
     * constructor
     * @param notificationsService notificationsService
     * @param translateService translateService
     */
    constructor(notificationsService, translateService) {
        super(notificationsService, translateService);
    }
    /**
     * Get all Entity Types
     *
     * @Returns Entity types[]
     */
    getEntityTypeListAsync() {
        throw new Error('Method not implemented.');
    }
    /**
     * Get entity type list with operation
     *
     *  * @Returns Entity types[]
     */
    getEntityTypeListWithOperationAsync() {
        throw new Error('Method not implemented.');
    }
    /**
     * save entity type
     * @param entityType
     * @return Entity type
     */
    saveEntityTypeAsync(entityType) {
        throw new Error('Method not implemented.');
    }
    /**
     * get all operations of an entity
     * @param entityTypeId
     * @return EntityTypeOperation[]
     */
    getAllOperationsByEntityTypeIdAsync(entityTypeId) {
        throw new Error('Method not implemented.');
    }
    /**
     * add or update entity type operation
     * @param entityTypeOperation
     * @return EntityTypeOperation
     */
    saveEntityTypeOperationAsync(entityTypeOperation) {
        throw new Error('Method not implemented.');
    }
    /**
     * get all attributes of an entity
     * @param entityTypeId
     * @return EntityTypeAttribute[]
     */
    getAllAttributesByEntityTypeIdAsync(entityTypeId) {
        throw new Error('Method not implemented.');
    }
    /**
     * add or update entity type attribute
     * @param entityTypeAttribute
     * @return EntityTypeAttribute
     */
    saveEntityTypeAttributeAsync(entityTypeAttribute) {
        throw new Error('Method not implemented.');
    }
    /**
     * get all properties of an entity
     * @param entityTypeId
     * @return EntityTypeProperty[]
     */
    getAllPropertiesByEntityTypeIdAsync(entityTypeId) {
        throw new Error('Method not implemented.');
    }
    /**
     * add or update entity type property
     * @param EntityTypeProperty
     * @return EntityTypeProperty
     */
    saveEntityTypePropertyAsync(entityTypeProperty) {
        throw new Error('Method not implemented.');
    }
    /**
     * update entity type properties using patch logic
     * @param entityTypesPropertiesToPatch
     * @return EntityTypeProperty[]
     */
    updateEntityTypePropertiesAsync(entityTypesPropertiesToPatch) {
        throw new Error('Method not implemented.');
    }
    /**
     * update entity type attributes using patch logic
     * @param entityTypesAttributesToPatch
     * @return EntityTypeAttribute[]
     */
    updateEntityTypeAttributesAsync(entityTypesAttributesToPatch) {
        throw new Error('Method not implemented.');
    }
    /**
     * this service returns all the data (properties, attributes and operations)
     * of a given entity type (by entity name)
     * @param entityTypeName
     */
    getAllEntityTypeDataByName(entityTypeName) {
        throw new Error('Method not implemented.');
    }
    /**
     * this service returns an array of elements
     * of the entity sent as a parameter,
     *  based on the filter it receives as a parameter.
     * @param entityTypeName
     * @param FilterGroup
     */
    getEntityTypeElements(entityTypeName, FilterGroup) {
        throw new Error('Method not implemented.');
    }
    /*
     * Get all properties and attributes by entity type id
     * @param {string} entityTypeId
     * @returns {Promise<EntityTypeProperty[]>}
     */
    getAllPropertiesAndAttributesByEntityTypeIdAsync(entityTypeId) {
        throw new Error('Method not implemented.');
    }
    /**
     * This service return a element from a entity type list by id
     * @param entityTypeName
     * @param elementId
     */
    getEntityTypeElementById(entityTypeName, elementId) {
        throw new Error('Method not implemented.');
    }
    /**
     * this service excute in database the operation received as parameter
     * @param entityName
     * @param operation
     * @param entity
     */
    executeAction(entityName, operation, entity) {
        throw new Error('Method not implemented.');
    }
}
EntityTypeService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: EntityTypeService, deps: [{ token: NotificationsService }, { token: TranslateService }], target: i0.ɵɵFactoryTarget.Injectable });
EntityTypeService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: EntityTypeService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: EntityTypeService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: NotificationsService, decorators: [{
                    type: Inject,
                    args: [NotificationsService]
                }] }, { type: i5.TranslateService, decorators: [{
                    type: Inject,
                    args: [TranslateService]
                }] }]; } });

class PrgEntityTypesModule {
    constructor(injector) {
        this.injector = injector;
        appInjector$5 = this.injector;
    }
    static forRoot(prgEntityTypesConfig) {
        entityTypesConfig = prgEntityTypesConfig;
        return {
            ngModule: PrgEntityTypesModule,
            providers: [
                {
                    provide: PRG_ENTITY_TYPES_CONFIG,
                    useValue: prgEntityTypesConfig,
                },
                {
                    provide: AbstractEntityTypeService,
                    useClass: prgEntityTypesConfig.useMockServices
                        ? MockEntityTypesService
                        : EntityTypeService,
                },
            ],
        };
    }
}
PrgEntityTypesModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgEntityTypesModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesModule, declarations: [PrgEntityTypesPage,
        PrgListEntityTypesComponent,
        PrgEntityTypeComponent,
        PrgEntityTypeConfigsComponent,
        PrgListSpecificEntityTypeComponent,
        PrgSpecificEntityTypePage,
        PrgEntityTypeElementComponent,
        PrgEntityTypeElementPage], imports: [PrgSharedComponentsModule,
        PrgEntityTypesRoutingModule,
        PrgCoreDynamicFormModule], exports: [PrgListEntityTypesComponent,
        PrgListSpecificEntityTypeComponent,
        PrgEntityTypeElementComponent] });
PrgEntityTypesModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesModule, providers: [DynamicDialogConfig, DynamicDialogRef], imports: [PrgSharedComponentsModule,
        PrgEntityTypesRoutingModule,
        PrgCoreDynamicFormModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        PrgEntityTypesPage,
                        PrgListEntityTypesComponent,
                        PrgEntityTypeComponent,
                        PrgEntityTypeConfigsComponent,
                        PrgListSpecificEntityTypeComponent,
                        PrgSpecificEntityTypePage,
                        PrgEntityTypeElementComponent,
                        PrgEntityTypeElementPage,
                    ],
                    imports: [
                        PrgSharedComponentsModule,
                        PrgEntityTypesRoutingModule,
                        PrgCoreDynamicFormModule,
                    ],
                    exports: [
                        PrgListEntityTypesComponent,
                        PrgListSpecificEntityTypeComponent,
                        PrgEntityTypeElementComponent,
                    ],
                    entryComponents: [PrgEntityTypeComponent, PrgEntityTypeElementComponent],
                    providers: [DynamicDialogConfig, DynamicDialogRef],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
let appInjector$5;
/**
 * Exports the EntityTypesConfig object
 */
let entityTypesConfig;

/**
 * Lookup table items component
 */
class PrgLookupTableItemsTableComponent {
    /**
     * construtor
     *
     * @param prgLookupTableConfig prgLookupTableConfig
     * @param lookupTableService
     * @param isLoadingDataService isLoadingDataService
     * @param formBuilder
     * @param formGroupService
     * @param objectsUtilityService
     */
    constructor(prgLookupTableConfig, lookupTableService, isLoadingDataService, formBuilder, formGroupService, objectsUtilityService) {
        this.prgLookupTableConfig = prgLookupTableConfig;
        this.lookupTableService = lookupTableService;
        this.isLoadingDataService = isLoadingDataService;
        this.formBuilder = formBuilder;
        this.formGroupService = formGroupService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * Output with item saved
         */
        this.savedItems = new EventEmitter();
        /**
         *  new Lookup Table Id Prefix
         */
        this.newLookupTableItemIdPrefix = 'newLookupTable:';
        /**
         * Table columns
         */
        this.lookupTableItemsColumns = this.prgLookupTableConfig.lookupTableItemsColumns;
        /**
         * Map to save temporarily the items in edit mode
         */
        this.clonedLookupTableItems = new Map();
        /**
         * auxiliary variable to help define the id of the new lookuptables
         */
        this.newLookupTableItemIdCount = 0;
    }
    set lookupTableItems(items) {
        this.lookupTableItemsForm = this.formBuilder.group({
            lookupTableItemsDetails: this.formBuilder.array([]),
        });
        if (items) {
            this._lookupTableItems = items;
            this.populateFormGroup();
        }
    }
    /**
     * Return lookup table form array
     */
    get lookupTableItemsDetails() {
        return this.lookupTableItemsForm.get('lookupTableItemsDetails');
    }
    /**
     * return lookup table control for given lookup table item
     * @param lookupTableItemId
     * @returns Control
     */
    getLookupTableItemControlById(lookupTableItemId) {
        return this.lookupTableItemsDetails.controls.find((control) => control.value.id === lookupTableItemId);
    }
    /**
     * this function is responsible for adding a new row
     * to the table for the user to configure the new lookuptableItem
     *
     */
    addNewLookupTableItem() {
        const newLookupTableItem = {
            id: `${this.newLookupTableItemIdPrefix}${this.newLookupTableItemIdCount}`,
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: null,
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: null,
            description: null,
            lookupTableId: this.lookupTableId,
        };
        this.newLookupTableItemIdCount++;
        // add new element to form Array
        this.lookupTableItemsDetails.insert(0, this.formGroupService.toFormGroupOneObject(newLookupTableItem, this.lookupTableItemsColumns));
        this.lookupTableItemsForm.markAllAsTouched();
        this.dataTableItems.editingRowKeys[newLookupTableItem.id] = true;
    }
    /**
     * this function is responsible for creating a
     * clone of a lookup Table item that is selected for editing
     *
     * @param lookupTable
     */
    onRowEditInit(item) {
        this.clonedLookupTableItems.set(item.id, { ...item });
    }
    /**
     * this function is responsible for saving a lookup table item,
     * either an update or adding a new lookup table item to the database
     *
     * @param lookupTable
     */
    async onRowEditSave(item) {
        const lookupTableItemToSave = this.objectsUtilityService.cloneObject(item);
        if (lookupTableItemToSave.id.includes(this.newLookupTableItemIdPrefix)) {
            lookupTableItemToSave.id = null;
        }
        this.lookupTableService
            .saveLookupTableItemAsync(lookupTableItemToSave)
            .then((response) => {
            this.getLookupTableItemControlById(item.id).setValue(response);
            delete this.dataTableItems.editingRowKeys[item.id];
            this.clonedLookupTableItems.delete(item.id);
            this.savedItems.emit(this.lookupTableId);
        });
    }
    /**
     * this function is responsible for restoring the data
     * that was there before starting the edit if the
     * lookup table item is already in the database,
     * otherwise it just deletes the row that was temporarily created
     *
     * @param lookupTable
     */
    onRowEditCancel(item) {
        if (item.id.includes(this.newLookupTableItemIdPrefix)) {
            this.lookupTableItemsDetails.removeAt(this.getLookupTableItemControlIndexById(item.id));
        }
        else {
            const lookupTableItemOrignal = this.clonedLookupTableItems.get(item.id);
            this.getLookupTableItemControlById(item.id).setValue(lookupTableItemOrignal);
        }
    }
    /**
     * this function is responsible for saving
     * all active edits (new lines or updating existing ones)
     */
    async saveAllChanges() {
        let lookupTablesItemsToSave = [];
        Object.getOwnPropertyNames(this.dataTableItems.editingRowKeys).forEach((element) => {
            if (element.includes(this.newLookupTableItemIdPrefix)) {
                const lookupTableAux = this.objectsUtilityService.cloneObject(this.getLookupTableItemControlById(element).value);
                lookupTableAux.id = null;
                lookupTablesItemsToSave.push(lookupTableAux);
            }
            else {
                lookupTablesItemsToSave.push(this.objectsUtilityService.cloneObject(this.getLookupTableItemControlById(element).value));
            }
        });
        this.lookupTableService
            .saveMultipleLookupTableItemsAsync(lookupTablesItemsToSave)
            .then((response) => {
            response.forEach((slt) => {
                const lookupTableById = this.getLookupTableItemControlById(slt.id);
                if (lookupTableById) {
                    lookupTableById.setValue(slt);
                }
                else {
                    this.lookupTableItemsDetails.push(this.formGroupService.toFormGroupOneObject(slt, this.lookupTableItemsColumns));
                }
            });
            this.clonedLookupTableItems.clear();
            this.deleteAllTempLookupTable();
            this.dataTableItems.editingRowKeys = {};
            this.savedItems.emit(this.lookupTableId);
        });
    }
    /**
     * this function is responsible for discarding
     * all active edits, and resetting the data that
     * was set before starting the edit
     */
    discardAllChanges() {
        Object.getOwnPropertyNames(this.dataTableItems.editingRowKeys).forEach((element) => {
            if (element.includes(this.newLookupTableItemIdPrefix)) {
                this.lookupTableItemsDetails.removeAt(this.getLookupTableItemControlIndexById(element));
            }
            else {
                this.getLookupTableItemControlById(element).setValue(this.clonedLookupTableItems.get(element));
            }
        });
        this.clonedLookupTableItems.clear();
        this.dataTableItems.editingRowKeys = {};
    }
    /**
     * this function is responsible for sorting a given column
     * @param event
     */
    customSort(event) {
        event.data.sort((data1, data2) => {
            let value1 = data1.value[event.field];
            let value2 = data2.value[event.field];
            let result = null;
            if (value1 == null && value2 != null)
                result = -1;
            else if (value1 != null && value2 == null)
                result = 1;
            else if (value1 == null && value2 == null)
                result = 0;
            else if (typeof value1 === 'string' && typeof value2 === 'string')
                result = value1.localeCompare(value2);
            else
                result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
            return event.order * result;
        });
    }
    /**
     * return lookup table item control for given lookup table item id
     * @param lookupTableItemId
     * @returns number
     */
    getLookupTableItemControlIndexById(lookupTableItemId) {
        return this.lookupTableItemsDetails.controls.findIndex((control) => control.value.id === lookupTableItemId);
    }
    /**
     * Populate data into Form
     */
    populateFormGroup() {
        const aux = this.formGroupService.toFormGroupMultipleObjects(this._lookupTableItems, this.lookupTableItemsColumns);
        aux.forEach((a) => {
            this.lookupTableItemsDetails.push(a);
        });
    }
    /**
     * this function is an auxiliary function that is used in the [saveAllChanges]{@link #saveAllChanges}
     *  function to delete all temporary rows that will be added later
     */
    deleteAllTempLookupTable() {
        const tempLookupTable = this.lookupTableItemsDetails.controls.filter((control) => control.value.id.includes(this.newLookupTableItemIdPrefix));
        if (tempLookupTable.length > 0) {
            tempLookupTable.forEach((tlt) => {
                this.lookupTableItemsDetails.removeAt(this.getLookupTableItemControlIndexById(tlt.value.id));
            });
        }
    }
}
PrgLookupTableItemsTableComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableItemsTableComponent, deps: [{ token: PRG_LOOKUP_TABLE_CONFIG }, { token: AbstractLookupTableService }, { token: IsLoadingDataService }, { token: i3.FormBuilder }, { token: FormGroupService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgLookupTableItemsTableComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgLookupTableItemsTableComponent, selector: "prg-lookup-table-items-table", inputs: { lookupTableId: "lookupTableId", lookupTableItems: "lookupTableItems" }, outputs: { savedItems: "savedItems" }, viewQueries: [{ propertyName: "dataTableItems", first: true, predicate: Table, descendants: true }], ngImport: i0, template: "<form [formGroup]=\"lookupTableItemsForm\">\r\n  <div formArrayName=\"lookupTableItemsDetails\">\r\n    <p-table\r\n      *ngIf=\"lookupTableItemsDetails\"\r\n      #table\r\n      [value]=\"lookupTableItemsDetails.controls\"\r\n      dataKey=\"value.id\"\r\n      responsiveLayout=\"scroll\"\r\n      editMode=\"row\"\r\n      (sortFunction)=\"customSort($event)\"\r\n      [customSort]=\"true\"\r\n    >\r\n      <ng-template pTemplate=\"header\">\r\n        <tr>\r\n          <ng-container *ngFor=\"let column of lookupTableItemsColumns\">\r\n            <th\r\n              [pSortableColumn]=\"column.key\"\r\n              [pSortableColumnDisabled]=\"\r\n                isLoadingDataService.visibility | async\r\n              \"\r\n            >\r\n              {{\r\n                'components.lookup-table.lookup-table-items.columns.' +\r\n                  column.key +\r\n                  '.label' | translate\r\n              }}\r\n              <p-sortIcon [field]=\"column.key\"></p-sortIcon>\r\n            </th>\r\n          </ng-container>\r\n          <th style=\"width: 10rem\">\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-plus-circle\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n              (click)=\"addNewLookupTableItem()\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-save\"\r\n              [disabled]=\"\r\n                (isLoadingDataService.visibility | async) ||\r\n                lookupTableItemsDetails.status === 'INVALID'\r\n              \"\r\n              (click)=\"saveAllChanges()\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-trash\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n              (click)=\"discardAllChanges()\"\r\n            ></p-button>\r\n          </th>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template\r\n        pTemplate=\"body\"\r\n        let-rowData\r\n        let-editing=\"editing\"\r\n        let-ri=\"rowIndex\"\r\n      >\r\n        <tr [pEditableRow]=\"rowData\" [formGroupName]=\"ri\">\r\n          <ng-container *ngFor=\"let column of lookupTableItemsColumns\">\r\n            <td pEditableColumn *ngIf=\"editing; else elseBlock\">\r\n              <p-cellEditor>\r\n                <ng-template pTemplate=\"input\">\r\n                  <input\r\n                    *ngIf=\"\r\n                      !column.readonly ||\r\n                        !!rowData.value.id.includes('newLookupTable');\r\n                      else notEditableColumn\r\n                    \"\r\n                    [placeholder]=\"'placeholder' + column.key | translate\"\r\n                    pInputText\r\n                    type=\"text\"\r\n                    [formControlName]=\"column.key\"\r\n                  />\r\n                  <ng-template pTemplate=\"input\" #notEditableColumn>\r\n                    {{ rowData.value[column.key] | translate }}\r\n                  </ng-template>\r\n                </ng-template>\r\n              </p-cellEditor>\r\n            </td>\r\n            <!-- Fixes bug that allows user to edit row without first clicking on the edit button-->\r\n            <ng-template #elseBlock>\r\n              <td>{{ rowData.value[column.key] | translate }}</td>\r\n            </ng-template>\r\n          </ng-container>\r\n\r\n          <td style=\"text-align: center\">\r\n            <button\r\n              *ngIf=\"!editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pInitEditableRow\r\n              icon=\"pi pi-pencil\"\r\n              (click)=\"onRowEditInit(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text\"\r\n            ></button>\r\n\r\n            <button\r\n              *ngIf=\"editing\"\r\n              [disabled]=\"\r\n                getLookupTableItemControlById(rowData.value.id).status !==\r\n                'VALID'\r\n              \"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pSaveEditableRow\r\n              icon=\"pi pi-check-circle\"\r\n              (click)=\"onRowEditSave(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-success p-mr-2\"\r\n            ></button>\r\n            <button\r\n              *ngIf=\"editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pCancelEditableRow\r\n              icon=\"pi pi-times-circle\"\r\n              (click)=\"onRowEditCancel(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-danger\"\r\n            ></button>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n\r\n      <ng-template pTemplate=\"emptymessage\">\r\n        <tr class=\"emptyInfo\">\r\n          <td colspan=\"6\">\r\n            <p-progressSpinner\r\n              *ngIf=\"isLoadingDataService.visibility | async; else elseBlock\"\r\n              [style]=\"{ width: '50px', height: '50px' }\"\r\n            >\r\n            </p-progressSpinner>\r\n            <ng-template #elseBlock>\r\n              {{ 'withoutLookuptableItems' | translate }}\r\n            </ng-template>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n    </p-table>\r\n  </div>\r\n</form>\r\n", styles: [".emptyInfo td{text-align:center}\n"], dependencies: [{ kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i7.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i1$2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i9$1.ProgressSpinner, selector: "p-progressSpinner", inputs: ["style", "styleClass", "strokeWidth", "fill", "animationDuration"] }, { kind: "component", type: i10$2.Table, selector: "p-table", inputs: ["frozenColumns", "frozenValue", "style", "styleClass", "tableStyle", "tableStyleClass", "paginator", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "paginatorDropdownScrollHeight", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showJumpToPageInput", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "selectionMode", "selectionPageOnly", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "rowSelectable", "rowTrackBy", "lazy", "lazyLoadOnInit", "compareSelectionBy", "csvSeparator", "exportFilename", "filters", "globalFilterFields", "filterDelay", "filterLocale", "expandedRowKeys", "editingRowKeys", "rowExpandMode", "scrollable", "scrollDirection", "rowGroupMode", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "responsive", "contextMenu", "resizableColumns", "columnResizeMode", "reorderableColumns", "loading", "loadingIcon", "showLoader", "rowHover", "customSort", "showInitialSortBadge", "autoLayout", "exportFunction", "exportHeader", "stateKey", "stateStorage", "editMode", "groupRowsBy", "groupRowsByOrder", "responsiveLayout", "breakpoint", "virtualRowHeight", "value", "columns", "first", "rows", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection", "selectAll"], outputs: ["selectAllChange", "selectionChange", "contextMenuSelectionChange", "onRowSelect", "onRowUnselect", "onPage", "onSort", "onFilter", "onLazyLoad", "onRowExpand", "onRowCollapse", "onContextMenuSelect", "onColResize", "onColReorder", "onRowReorder", "onEditInit", "onEditComplete", "onEditCancel", "onHeaderCheckboxToggle", "sortFunction", "firstChange", "rowsChange", "onStateSave", "onStateRestore"] }, { kind: "directive", type: i10$2.SortableColumn, selector: "[pSortableColumn]", inputs: ["pSortableColumn", "pSortableColumnDisabled"] }, { kind: "directive", type: i10$2.EditableColumn, selector: "[pEditableColumn]", inputs: ["pEditableColumn", "pEditableColumnField", "pEditableColumnRowIndex", "pEditableColumnDisabled", "pFocusCellSelector"] }, { kind: "component", type: i10$2.CellEditor, selector: "p-cellEditor" }, { kind: "component", type: i10$2.SortIcon, selector: "p-sortIcon", inputs: ["field"] }, { kind: "directive", type: i10$2.EditableRow, selector: "[pEditableRow]", inputs: ["pEditableRow", "pEditableRowDisabled"] }, { kind: "directive", type: i10$2.InitEditableRow, selector: "[pInitEditableRow]" }, { kind: "directive", type: i10$2.SaveEditableRow, selector: "[pSaveEditableRow]" }, { kind: "directive", type: i10$2.CancelEditableRow, selector: "[pCancelEditableRow]" }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i8.Button, selector: "p-button", inputs: ["type", "iconPos", "icon", "badge", "label", "disabled", "loading", "loadingIcon", "style", "styleClass", "badgeClass", "ariaLabel"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "directive", type: i11.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i3.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i3.FormGroupName, selector: "[formGroupName]", inputs: ["formGroupName"] }, { kind: "directive", type: i3.FormArrayName, selector: "[formArrayName]", inputs: ["formArrayName"] }, { kind: "pipe", type: i1$2.AsyncPipe, name: "async" }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableItemsTableComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-lookup-table-items-table', template: "<form [formGroup]=\"lookupTableItemsForm\">\r\n  <div formArrayName=\"lookupTableItemsDetails\">\r\n    <p-table\r\n      *ngIf=\"lookupTableItemsDetails\"\r\n      #table\r\n      [value]=\"lookupTableItemsDetails.controls\"\r\n      dataKey=\"value.id\"\r\n      responsiveLayout=\"scroll\"\r\n      editMode=\"row\"\r\n      (sortFunction)=\"customSort($event)\"\r\n      [customSort]=\"true\"\r\n    >\r\n      <ng-template pTemplate=\"header\">\r\n        <tr>\r\n          <ng-container *ngFor=\"let column of lookupTableItemsColumns\">\r\n            <th\r\n              [pSortableColumn]=\"column.key\"\r\n              [pSortableColumnDisabled]=\"\r\n                isLoadingDataService.visibility | async\r\n              \"\r\n            >\r\n              {{\r\n                'components.lookup-table.lookup-table-items.columns.' +\r\n                  column.key +\r\n                  '.label' | translate\r\n              }}\r\n              <p-sortIcon [field]=\"column.key\"></p-sortIcon>\r\n            </th>\r\n          </ng-container>\r\n          <th style=\"width: 10rem\">\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-plus-circle\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n              (click)=\"addNewLookupTableItem()\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-save\"\r\n              [disabled]=\"\r\n                (isLoadingDataService.visibility | async) ||\r\n                lookupTableItemsDetails.status === 'INVALID'\r\n              \"\r\n              (click)=\"saveAllChanges()\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-trash\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n              (click)=\"discardAllChanges()\"\r\n            ></p-button>\r\n          </th>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template\r\n        pTemplate=\"body\"\r\n        let-rowData\r\n        let-editing=\"editing\"\r\n        let-ri=\"rowIndex\"\r\n      >\r\n        <tr [pEditableRow]=\"rowData\" [formGroupName]=\"ri\">\r\n          <ng-container *ngFor=\"let column of lookupTableItemsColumns\">\r\n            <td pEditableColumn *ngIf=\"editing; else elseBlock\">\r\n              <p-cellEditor>\r\n                <ng-template pTemplate=\"input\">\r\n                  <input\r\n                    *ngIf=\"\r\n                      !column.readonly ||\r\n                        !!rowData.value.id.includes('newLookupTable');\r\n                      else notEditableColumn\r\n                    \"\r\n                    [placeholder]=\"'placeholder' + column.key | translate\"\r\n                    pInputText\r\n                    type=\"text\"\r\n                    [formControlName]=\"column.key\"\r\n                  />\r\n                  <ng-template pTemplate=\"input\" #notEditableColumn>\r\n                    {{ rowData.value[column.key] | translate }}\r\n                  </ng-template>\r\n                </ng-template>\r\n              </p-cellEditor>\r\n            </td>\r\n            <!-- Fixes bug that allows user to edit row without first clicking on the edit button-->\r\n            <ng-template #elseBlock>\r\n              <td>{{ rowData.value[column.key] | translate }}</td>\r\n            </ng-template>\r\n          </ng-container>\r\n\r\n          <td style=\"text-align: center\">\r\n            <button\r\n              *ngIf=\"!editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pInitEditableRow\r\n              icon=\"pi pi-pencil\"\r\n              (click)=\"onRowEditInit(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text\"\r\n            ></button>\r\n\r\n            <button\r\n              *ngIf=\"editing\"\r\n              [disabled]=\"\r\n                getLookupTableItemControlById(rowData.value.id).status !==\r\n                'VALID'\r\n              \"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pSaveEditableRow\r\n              icon=\"pi pi-check-circle\"\r\n              (click)=\"onRowEditSave(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-success p-mr-2\"\r\n            ></button>\r\n            <button\r\n              *ngIf=\"editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pCancelEditableRow\r\n              icon=\"pi pi-times-circle\"\r\n              (click)=\"onRowEditCancel(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-danger\"\r\n            ></button>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n\r\n      <ng-template pTemplate=\"emptymessage\">\r\n        <tr class=\"emptyInfo\">\r\n          <td colspan=\"6\">\r\n            <p-progressSpinner\r\n              *ngIf=\"isLoadingDataService.visibility | async; else elseBlock\"\r\n              [style]=\"{ width: '50px', height: '50px' }\"\r\n            >\r\n            </p-progressSpinner>\r\n            <ng-template #elseBlock>\r\n              {{ 'withoutLookuptableItems' | translate }}\r\n            </ng-template>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n    </p-table>\r\n  </div>\r\n</form>\r\n", styles: [".emptyInfo td{text-align:center}\n"] }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_LOOKUP_TABLE_CONFIG]
                }] }, { type: AbstractLookupTableService }, { type: IsLoadingDataService }, { type: i3.FormBuilder }, { type: FormGroupService }, { type: ObjectsUtilityService }]; }, propDecorators: { dataTableItems: [{
                type: ViewChild,
                args: [Table]
            }], lookupTableId: [{
                type: Input
            }], lookupTableItems: [{
                type: Input,
                args: ['lookupTableItems']
            }], savedItems: [{
                type: Output
            }] } });

/**
 * LookupTables Component
 */
class PrgLookupTableTableComponent {
    /**
     * constructor
     *
     * @param lookupTableService
     * @param prgLookupTableConfig prgLookupTableConfig
     * @param isLoadingDataService isLoadingDataService
     * @param formBuilder
     * @param formGroupService
     * @param objectsUtilityService
     */
    constructor(lookupTableService, prgLookupTableConfig, isLoadingDataService, formBuilder, formGroupService, objectsUtilityService) {
        this.lookupTableService = lookupTableService;
        this.prgLookupTableConfig = prgLookupTableConfig;
        this.isLoadingDataService = isLoadingDataService;
        this.formBuilder = formBuilder;
        this.formGroupService = formGroupService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         *  new Lookup Table Id Prefix
         */
        this.newLookupTableIdPrefix = 'newLookupTable';
        /**
         * table columns
         */
        this.lookupTableColumns = this.prgLookupTableConfig.lookupTableColumns;
        /**
         * cloned Lookup Table
         * this map is used to temporarily store the elements in edit mode
         */
        this.clonedLookupTable = new Map();
        /**
         * auxiliary variable to help define the id of the new lookuptables
         */
        this.newLookupTableIdCount = 0;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.lookupTableForm = this.formBuilder.group({
            lookupTableFormArray: this.formBuilder.array([]),
        });
        this.populateData();
    }
    /**
     * Return lookup table form array
     */
    get lookupTableFormArray() {
        return this.lookupTableForm.get('lookupTableFormArray');
    }
    /**
     * this function is responsible for adding a new row
     * to the table for the user to configure the new lookuptable
     *
     */
    newLookupTable() {
        const newLookupTable = {
            id: `${this.newLookupTableIdPrefix}${this.newLookupTableIdCount}`,
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: null,
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            description: null,
            workspaceId: null,
            items: null,
        };
        this.newLookupTableIdCount++;
        this.lookupTableFormArray.insert(0, this.formGroupService.toFormGroupOneObject(newLookupTable, this.lookupTableColumns));
        //TODO: SEE this
        this.lookupTableFormArray.value.unshift(newLookupTable);
        this.lookupTableForm.markAllAsTouched();
        this.dataTable.editingRowKeys[newLookupTable.id] = true;
    }
    /**
     * return lookup table  control for given lookup table
     */
    getLookupTableControlById(lookupTableId) {
        return this.lookupTableFormArray.controls.find((control) => control.value.id === lookupTableId);
    }
    /**
     * this function is responsible for creating a
     * clone of a lookupTable that is selected for editing
     *
     * @param lookupTable
     */
    onRowEditInit(lookupTable) {
        this.clonedLookupTable.set(lookupTable.id, { ...lookupTable });
    }
    /**
     * this function is responsible for saving a lookup table,
     * either an update or adding a new lookup table to the database
     *
     * @param lookupTable
     */
    onRowEditSave(lookupTable) {
        const lookupTableToSave = this.objectsUtilityService.cloneObject(lookupTable);
        if (lookupTableToSave.id.includes(this.newLookupTableIdPrefix)) {
            lookupTableToSave.id = null;
        }
        this.lookupTableService
            .saveLookupTableAsync(lookupTableToSave)
            .then((response) => {
            this.getLookupTableControlById(lookupTable.id).setValue(response);
            delete this.dataTable.editingRowKeys[lookupTable.id];
            this.clonedLookupTable.delete(lookupTable.id);
        });
    }
    /**
     * this function is responsible for restoring the data
     * that was there before starting the edit if the
     * lookup table is already in the database,
     * otherwise it just deletes the row that was temporarily created
     *
     * @param lookupTable
     */
    onRowEditCancel(lookupTable) {
        if (lookupTable.id.includes(this.newLookupTableIdPrefix)) {
            this.lookupTableFormArray.removeAt(this.getLookupTableControlIndexById(lookupTable.id));
        }
        else {
            const lookupTableOrignal = this.clonedLookupTable.get(lookupTable.id);
            this.getLookupTableControlById(lookupTable.id).setValue(lookupTableOrignal);
        }
    }
    /**
     * this function is responsible for checking
     * if the lookup table already has the
     * items loaded, if not it calls the function to load them
     * @param lookupTable
     */
    expandLookupTable(lookupTable) {
        if (lookupTable.items === null) {
            this.loadLookupTableItemsByLookupTableId(lookupTable);
        }
    }
    /**
     * this function is responsible for saving
     * all active edits (new lines or updating existing ones)
     */
    async saveAllChanges() {
        let lookupTablesToSave = [];
        Object.getOwnPropertyNames(this.dataTable.editingRowKeys).forEach((element) => {
            if (element.includes(this.newLookupTableIdPrefix)) {
                const lookupTableAux = this.objectsUtilityService.cloneObject(this.getLookupTableControlById(element).value);
                lookupTableAux.id = null;
                lookupTablesToSave.push(lookupTableAux);
            }
            else {
                lookupTablesToSave.push(this.objectsUtilityService.cloneObject(this.getLookupTableControlById(element).value));
            }
        });
        this.lookupTableService
            .saveMultipleLookupTableAsync(lookupTablesToSave)
            .then((response) => {
            response.forEach((slt) => {
                const lookupTableById = this.getLookupTableControlById(slt.id);
                if (lookupTableById) {
                    lookupTableById.setValue(slt);
                }
                else {
                    this.lookupTableFormArray.push(this.formGroupService.toFormGroupOneObject(slt, this.lookupTableColumns));
                }
            });
            this.clonedLookupTable.clear();
            this.deleteAllTempLookupTable();
        });
    }
    /**
     * this function is responsible for discarding
     * all active edits, and resetting the data that
     * was set before starting the edit
     *
     */
    discardAllChanges() {
        Object.getOwnPropertyNames(this.dataTable.editingRowKeys).forEach((element) => {
            if (element.includes(this.newLookupTableIdPrefix)) {
                this.lookupTableFormArray.removeAt(this.getLookupTableControlIndexById(element));
            }
            else {
                this.getLookupTableControlById(element).setValue(this.clonedLookupTable.get(element));
            }
        });
        this.clonedLookupTable.clear();
        this.dataTable.editingRowKeys = {};
    }
    /**
     *this function is responsible for sorting a given column
     * @param event
     */
    customSort(event) {
        event.data.sort((data1, data2) => {
            let value1 = data1.value[event.field];
            let value2 = data2.value[event.field];
            let result = null;
            if (value1 == null && value2 != null)
                result = -1;
            else if (value1 != null && value2 == null)
                result = 1;
            else if (value1 == null && value2 == null)
                result = 0;
            else if (typeof value1 === 'string' && typeof value2 === 'string')
                result = value1.localeCompare(value2);
            else
                result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
            return event.order * result;
        });
    }
    /**
     * this function recive the item saved in child component
     * @param event
     */
    itemsSaved(event) {
        const lookupTable = this.getLookupTableControlById(event).value;
        this.loadLookupTableItemsByLookupTableId(lookupTable);
    }
    /**
     * return index of control for given lookup table
     */
    getLookupTableControlIndexById(lookupTableId) {
        return this.lookupTableFormArray.controls.findIndex((control) => control.value.id === lookupTableId);
    }
    /**
     * Populate data into Form
     */
    populateData() {
        this.lookupTableService.getAllLookupTableAsync().then((response) => {
            const aux = this.formGroupService.toFormGroupMultipleObjects(response, this.lookupTableColumns);
            aux.forEach((a) => {
                this.lookupTableForm.markAllAsTouched();
                this.lookupTableFormArray.push(a);
            });
        });
    }
    /**
     * this function is responsible for loading the
     * lookup table items for a given lookup table
     * @param lookupTable
     */
    loadLookupTableItemsByLookupTableId(lookupTable) {
        this.lookupTableService
            .getLookupTableItemsByLookupTableIdAsync(lookupTable.id)
            .then((response) => {
            lookupTable.items = response;
            this.getLookupTableControlById(lookupTable.id).setValue(lookupTable);
        });
    }
    /**
     * this function is an auxiliary function that is used in the [saveAllChanges]{@link #saveAllChanges}
     *  function to delete all temporary rows that will be added later
     */
    deleteAllTempLookupTable() {
        const tempLookupTable = this.lookupTableFormArray.controls.filter((control) => control.value.id.includes(this.newLookupTableIdPrefix));
        if (tempLookupTable.length > 0) {
            tempLookupTable.forEach((tlt) => {
                this.lookupTableFormArray.removeAt(this.getLookupTableControlIndexById(tlt.value.id));
            });
        }
    }
}
PrgLookupTableTableComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableTableComponent, deps: [{ token: AbstractLookupTableService }, { token: PRG_LOOKUP_TABLE_CONFIG }, { token: IsLoadingDataService }, { token: i3.FormBuilder }, { token: FormGroupService }, { token: ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgLookupTableTableComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgLookupTableTableComponent, selector: "prg-lookup-table-table", viewQueries: [{ propertyName: "dataTable", first: true, predicate: Table, descendants: true }], ngImport: i0, template: "<form [formGroup]=\"lookupTableForm\">\r\n  <div formArrayName=\"lookupTableFormArray\">\r\n    <p-table\r\n      [value]=\"lookupTableFormArray.controls\"\r\n      dataKey=\"value.id\"\r\n      responsiveLayout=\"scroll\"\r\n      editMode=\"row\"\r\n      (sortFunction)=\"customSort($event)\"\r\n      [customSort]=\"true\"\r\n    >\r\n      <ng-template pTemplate=\"header\">\r\n        <tr>\r\n          <th style=\"width: 3rem\"></th>\r\n          <ng-container *ngFor=\"let column of lookupTableColumns\">\r\n            <th\r\n              [pSortableColumn]=\"column.key\"\r\n              [pSortableColumnDisabled]=\"\r\n                isLoadingDataService.visibility | async\r\n              \"\r\n            >\r\n              {{\r\n                'components.lookup-table.columns.' + column.key + '.label'\r\n                  | translate\r\n              }}\r\n              <p-sortIcon [field]=\"column.key\"></p-sortIcon>\r\n            </th>\r\n          </ng-container>\r\n\r\n          <th style=\"width: 15rem\">\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-plus-circle\"\r\n              (click)=\"newLookupTable()\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-save\"\r\n              [disabled]=\"\r\n                (isLoadingDataService.visibility | async) ||\r\n                lookupTableFormArray.status === 'INVALID'\r\n              \"\r\n              (click)=\"saveAllChanges()\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-trash\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n              (click)=\"discardAllChanges()\"\r\n            ></p-button>\r\n          </th>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template\r\n        pTemplate=\"body\"\r\n        let-rowData\r\n        let-editing=\"editing\"\r\n        let-ri=\"rowIndex\"\r\n        let-expanded=\"expanded\"\r\n      >\r\n        <tr [pEditableRow]=\"rowData\" [formGroupName]=\"ri\">\r\n          <td>\r\n            <button\r\n              type=\"button\"\r\n              pButton\r\n              pRipple\r\n              *ngIf=\"!rowData.value.id.includes(newLookupTableIdPrefix)\"\r\n              [pRowToggler]=\"rowData\"\r\n              class=\"p-button-text p-button-rounded p-button-plain\"\r\n              [icon]=\"expanded ? 'pi pi-chevron-down' : 'pi pi-chevron-right'\"\r\n              (click)=\"expandLookupTable(rowData.value)\"\r\n            ></button>\r\n          </td>\r\n          <ng-container *ngFor=\"let column of lookupTableColumns\">\r\n            <td pEditableColumn *ngIf=\"editing; else elseBlock\">\r\n              <p-cellEditor>\r\n                <ng-template pTemplate=\"input\">\r\n                  <input\r\n                    *ngIf=\"\r\n                      !column.readonly ||\r\n                        rowData.value.id.includes(newLookupTableIdPrefix);\r\n                      else notEditableColumn\r\n                    \"\r\n                    [placeholder]=\"'placeholder' + column.key | translate\"\r\n                    pInputText\r\n                    type=\"text\"\r\n                    [formControlName]=\"column.key\"\r\n                  />\r\n                  <ng-template pTemplate=\"input\" #notEditableColumn>\r\n                    {{ rowData.value[column.key] | translate }}\r\n                  </ng-template>\r\n                </ng-template>\r\n              </p-cellEditor>\r\n            </td>\r\n            <!-- Fixes bug that allows user to edit row without first clicking on the edit button-->\r\n            <ng-template #elseBlock>\r\n              <td>{{ rowData.value[column.key] | translate }}</td>\r\n            </ng-template>\r\n          </ng-container>\r\n\r\n          <td style=\"text-align: center\">\r\n            <button\r\n              *ngIf=\"!editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pInitEditableRow\r\n              icon=\"pi pi-pencil\"\r\n              (click)=\"onRowEditInit(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text\"\r\n            ></button>\r\n\r\n            <button\r\n              *ngIf=\"editing\"\r\n              [disabled]=\"\r\n                getLookupTableControlById(rowData.value.id).status !== 'VALID'\r\n              \"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pSaveEditableRow\r\n              icon=\"pi pi-check-circle\"\r\n              (click)=\"onRowEditSave(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-success p-mr-2\"\r\n            ></button>\r\n            <button\r\n              *ngIf=\"editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pCancelEditableRow\r\n              icon=\"pi pi-times-circle\"\r\n              (click)=\"onRowEditCancel(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-danger\"\r\n            ></button>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template pTemplate=\"rowexpansion\" let-lookupTable>\r\n        <tr style=\"background: lime !important\">\r\n          <td colspan=\"7\">\r\n            <div class=\"p-3\">\r\n              <prg-lookup-table-items-table\r\n                [lookupTableItems]=\"lookupTable.value.items\"\r\n                [lookupTableId]=\"lookupTable.value.id\"\r\n                (savedItems)=\"itemsSaved($event)\"\r\n              ></prg-lookup-table-items-table>\r\n            </div>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template pTemplate=\"emptymessage\">\r\n        <tr style=\"background: white !important\" class=\"emptyInfo\">\r\n          <td colspan=\"6\">\r\n            <p-progressSpinner\r\n              *ngIf=\"isLoadingDataService.visibility | async; else elseBlock\"\r\n              [style]=\"{ width: '50px', height: '50px' }\"\r\n            ></p-progressSpinner>\r\n            <ng-template #elseBlock>\r\n              {{ 'withoutLookuptable' | translate }}</ng-template\r\n            >\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n    </p-table>\r\n  </div>\r\n</form>\r\n", styles: ["th,td{text-align:center!important}\n"], dependencies: [{ kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i7.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i1$2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i9$1.ProgressSpinner, selector: "p-progressSpinner", inputs: ["style", "styleClass", "strokeWidth", "fill", "animationDuration"] }, { kind: "component", type: i10$2.Table, selector: "p-table", inputs: ["frozenColumns", "frozenValue", "style", "styleClass", "tableStyle", "tableStyleClass", "paginator", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "paginatorDropdownScrollHeight", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showJumpToPageInput", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "selectionMode", "selectionPageOnly", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "rowSelectable", "rowTrackBy", "lazy", "lazyLoadOnInit", "compareSelectionBy", "csvSeparator", "exportFilename", "filters", "globalFilterFields", "filterDelay", "filterLocale", "expandedRowKeys", "editingRowKeys", "rowExpandMode", "scrollable", "scrollDirection", "rowGroupMode", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "responsive", "contextMenu", "resizableColumns", "columnResizeMode", "reorderableColumns", "loading", "loadingIcon", "showLoader", "rowHover", "customSort", "showInitialSortBadge", "autoLayout", "exportFunction", "exportHeader", "stateKey", "stateStorage", "editMode", "groupRowsBy", "groupRowsByOrder", "responsiveLayout", "breakpoint", "virtualRowHeight", "value", "columns", "first", "rows", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection", "selectAll"], outputs: ["selectAllChange", "selectionChange", "contextMenuSelectionChange", "onRowSelect", "onRowUnselect", "onPage", "onSort", "onFilter", "onLazyLoad", "onRowExpand", "onRowCollapse", "onContextMenuSelect", "onColResize", "onColReorder", "onRowReorder", "onEditInit", "onEditComplete", "onEditCancel", "onHeaderCheckboxToggle", "sortFunction", "firstChange", "rowsChange", "onStateSave", "onStateRestore"] }, { kind: "directive", type: i10$2.SortableColumn, selector: "[pSortableColumn]", inputs: ["pSortableColumn", "pSortableColumnDisabled"] }, { kind: "directive", type: i10$2.RowToggler, selector: "[pRowToggler]", inputs: ["pRowToggler", "pRowTogglerDisabled"] }, { kind: "directive", type: i10$2.EditableColumn, selector: "[pEditableColumn]", inputs: ["pEditableColumn", "pEditableColumnField", "pEditableColumnRowIndex", "pEditableColumnDisabled", "pFocusCellSelector"] }, { kind: "component", type: i10$2.CellEditor, selector: "p-cellEditor" }, { kind: "component", type: i10$2.SortIcon, selector: "p-sortIcon", inputs: ["field"] }, { kind: "directive", type: i10$2.EditableRow, selector: "[pEditableRow]", inputs: ["pEditableRow", "pEditableRowDisabled"] }, { kind: "directive", type: i10$2.InitEditableRow, selector: "[pInitEditableRow]" }, { kind: "directive", type: i10$2.SaveEditableRow, selector: "[pSaveEditableRow]" }, { kind: "directive", type: i10$2.CancelEditableRow, selector: "[pCancelEditableRow]" }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i8.Button, selector: "p-button", inputs: ["type", "iconPos", "icon", "badge", "label", "disabled", "loading", "loadingIcon", "style", "styleClass", "badgeClass", "ariaLabel"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "directive", type: i11.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i3.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i3.FormGroupName, selector: "[formGroupName]", inputs: ["formGroupName"] }, { kind: "directive", type: i3.FormArrayName, selector: "[formArrayName]", inputs: ["formArrayName"] }, { kind: "component", type: PrgLookupTableItemsTableComponent, selector: "prg-lookup-table-items-table", inputs: ["lookupTableId", "lookupTableItems"], outputs: ["savedItems"] }, { kind: "pipe", type: i1$2.AsyncPipe, name: "async" }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableTableComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-lookup-table-table', template: "<form [formGroup]=\"lookupTableForm\">\r\n  <div formArrayName=\"lookupTableFormArray\">\r\n    <p-table\r\n      [value]=\"lookupTableFormArray.controls\"\r\n      dataKey=\"value.id\"\r\n      responsiveLayout=\"scroll\"\r\n      editMode=\"row\"\r\n      (sortFunction)=\"customSort($event)\"\r\n      [customSort]=\"true\"\r\n    >\r\n      <ng-template pTemplate=\"header\">\r\n        <tr>\r\n          <th style=\"width: 3rem\"></th>\r\n          <ng-container *ngFor=\"let column of lookupTableColumns\">\r\n            <th\r\n              [pSortableColumn]=\"column.key\"\r\n              [pSortableColumnDisabled]=\"\r\n                isLoadingDataService.visibility | async\r\n              \"\r\n            >\r\n              {{\r\n                'components.lookup-table.columns.' + column.key + '.label'\r\n                  | translate\r\n              }}\r\n              <p-sortIcon [field]=\"column.key\"></p-sortIcon>\r\n            </th>\r\n          </ng-container>\r\n\r\n          <th style=\"width: 15rem\">\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-plus-circle\"\r\n              (click)=\"newLookupTable()\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-save\"\r\n              [disabled]=\"\r\n                (isLoadingDataService.visibility | async) ||\r\n                lookupTableFormArray.status === 'INVALID'\r\n              \"\r\n              (click)=\"saveAllChanges()\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-trash\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n              (click)=\"discardAllChanges()\"\r\n            ></p-button>\r\n          </th>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template\r\n        pTemplate=\"body\"\r\n        let-rowData\r\n        let-editing=\"editing\"\r\n        let-ri=\"rowIndex\"\r\n        let-expanded=\"expanded\"\r\n      >\r\n        <tr [pEditableRow]=\"rowData\" [formGroupName]=\"ri\">\r\n          <td>\r\n            <button\r\n              type=\"button\"\r\n              pButton\r\n              pRipple\r\n              *ngIf=\"!rowData.value.id.includes(newLookupTableIdPrefix)\"\r\n              [pRowToggler]=\"rowData\"\r\n              class=\"p-button-text p-button-rounded p-button-plain\"\r\n              [icon]=\"expanded ? 'pi pi-chevron-down' : 'pi pi-chevron-right'\"\r\n              (click)=\"expandLookupTable(rowData.value)\"\r\n            ></button>\r\n          </td>\r\n          <ng-container *ngFor=\"let column of lookupTableColumns\">\r\n            <td pEditableColumn *ngIf=\"editing; else elseBlock\">\r\n              <p-cellEditor>\r\n                <ng-template pTemplate=\"input\">\r\n                  <input\r\n                    *ngIf=\"\r\n                      !column.readonly ||\r\n                        rowData.value.id.includes(newLookupTableIdPrefix);\r\n                      else notEditableColumn\r\n                    \"\r\n                    [placeholder]=\"'placeholder' + column.key | translate\"\r\n                    pInputText\r\n                    type=\"text\"\r\n                    [formControlName]=\"column.key\"\r\n                  />\r\n                  <ng-template pTemplate=\"input\" #notEditableColumn>\r\n                    {{ rowData.value[column.key] | translate }}\r\n                  </ng-template>\r\n                </ng-template>\r\n              </p-cellEditor>\r\n            </td>\r\n            <!-- Fixes bug that allows user to edit row without first clicking on the edit button-->\r\n            <ng-template #elseBlock>\r\n              <td>{{ rowData.value[column.key] | translate }}</td>\r\n            </ng-template>\r\n          </ng-container>\r\n\r\n          <td style=\"text-align: center\">\r\n            <button\r\n              *ngIf=\"!editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pInitEditableRow\r\n              icon=\"pi pi-pencil\"\r\n              (click)=\"onRowEditInit(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text\"\r\n            ></button>\r\n\r\n            <button\r\n              *ngIf=\"editing\"\r\n              [disabled]=\"\r\n                getLookupTableControlById(rowData.value.id).status !== 'VALID'\r\n              \"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pSaveEditableRow\r\n              icon=\"pi pi-check-circle\"\r\n              (click)=\"onRowEditSave(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-success p-mr-2\"\r\n            ></button>\r\n            <button\r\n              *ngIf=\"editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pCancelEditableRow\r\n              icon=\"pi pi-times-circle\"\r\n              (click)=\"onRowEditCancel(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-danger\"\r\n            ></button>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template pTemplate=\"rowexpansion\" let-lookupTable>\r\n        <tr style=\"background: lime !important\">\r\n          <td colspan=\"7\">\r\n            <div class=\"p-3\">\r\n              <prg-lookup-table-items-table\r\n                [lookupTableItems]=\"lookupTable.value.items\"\r\n                [lookupTableId]=\"lookupTable.value.id\"\r\n                (savedItems)=\"itemsSaved($event)\"\r\n              ></prg-lookup-table-items-table>\r\n            </div>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template pTemplate=\"emptymessage\">\r\n        <tr style=\"background: white !important\" class=\"emptyInfo\">\r\n          <td colspan=\"6\">\r\n            <p-progressSpinner\r\n              *ngIf=\"isLoadingDataService.visibility | async; else elseBlock\"\r\n              [style]=\"{ width: '50px', height: '50px' }\"\r\n            ></p-progressSpinner>\r\n            <ng-template #elseBlock>\r\n              {{ 'withoutLookuptable' | translate }}</ng-template\r\n            >\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n    </p-table>\r\n  </div>\r\n</form>\r\n", styles: ["th,td{text-align:center!important}\n"] }]
        }], ctorParameters: function () { return [{ type: AbstractLookupTableService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_LOOKUP_TABLE_CONFIG]
                }] }, { type: IsLoadingDataService }, { type: i3.FormBuilder }, { type: FormGroupService }, { type: ObjectsUtilityService }]; }, propDecorators: { dataTable: [{
                type: ViewChild,
                args: [Table]
            }] } });

/**
 * MockDatabase object to be used while developing
 * <br /> and/or testing the front-end
 */
const MockDatabase = {
    LookupTable: [
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'GameStatus',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'Estados de jogo',
            items: null,
        },
        {
            id: '2',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'Sports',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'Despostos',
            items: null,
        },
        {
            id: 'dataType',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'dataType',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'dataType',
            items: null,
        },
        {
            id: 'language',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'language',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'language',
            items: null,
        },
        {
            id: 'stockStatus',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'stockStatus',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'stockStatus',
            items: null,
        },
        {
            id: 'theme',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'theme',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'theme',
            items: null,
        },
    ],
    LookupTableItems: [
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'standby',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'Standby',
            lookupTableId: '1',
        },
        {
            id: '2',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'running',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'Running',
            lookupTableId: '1',
        },
        {
            id: '3',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'ended',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'Ended',
            lookupTableId: '1',
        },
        {
            id: '4',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'waterPolo',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'Water polo',
            lookupTableId: '2',
        },
        {
            id: '5',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'football',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'Football',
            lookupTableId: '2',
        },
        {
            id: '6',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'ended',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'Ended',
            lookupTableId: '2',
        },
        {
            id: 'dataType.string',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'string',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'string',
            lookupTableId: 'dataType',
        },
        {
            id: 'dataType.number',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'number',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'number',
            lookupTableId: 'dataType',
        },
        {
            id: 'dataType.date',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'date',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'date',
            lookupTableId: 'dataType',
        },
        {
            id: 'dataType.default',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'default',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'default',
            lookupTableId: 'dataType',
        },
        {
            id: 'dataType.lookupTable',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'lookupTable',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'lookup table',
            lookupTableId: 'dataType',
        },
        {
            id: 'dataType.entityType',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'entityType',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'entity type',
            lookupTableId: 'dataType',
        },
        {
            id: 'stockStatus.unavailable',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'unavailable',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'unavailable',
            lookupTableId: 'stockStatus',
        },
        {
            id: 'stockStatus.available',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'available',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'entity type',
            lookupTableId: 'stockStatus',
        },
        {
            id: 'language.portuguese',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'portuguese',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'portuguese',
            lookupTableId: 'language',
        },
        {
            id: 'language.english',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'english',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'english',
            lookupTableId: 'language',
        },
        {
            id: 'theme.lara-light-blue',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'lara-light-blue',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'lara-light-blue',
            lookupTableId: 'theme',
        },
        {
            id: 'theme.bootstrap4-dark-purple',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'bootstrap4-dark-purple',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'bootstrap4-dark-purple',
            lookupTableId: 'theme',
        },
        {
            id: 'theme.bootstrap4-light-purple',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'bootstrap4-light-purple',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'bootstrap4-light-purple',
            lookupTableId: 'theme',
        },
        {
            id: 'theme.bootstrap4-light-blue',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'bootstrap4-light-blue',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'bootstrap4-light-blue',
            lookupTableId: 'theme',
        },
        {
            id: 'theme.rhea',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'rhea',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            description: 'rhea',
            lookupTableId: 'theme',
        },
    ],
};

/**
 * Injectable
 */
/**
 * class MockLookupTableService
 */
class MockLookupTableService extends AbstractLookupTableService {
    /**
     * Construtor
     *
     * @param isLoadingDataService
     * @param notificationsService
     * @param utilityService
     * @param objectsUtilityService
     */
    constructor(isLoadingDataService, notificationsService, utilityService, objectsUtilityService, translateService, arrayUtilityService) {
        super(translateService);
        this.isLoadingDataService = isLoadingDataService;
        this.notificationsService = notificationsService;
        this.utilityService = utilityService;
        this.objectsUtilityService = objectsUtilityService;
        this.arrayUtilityService = arrayUtilityService;
        /**
         * default time in seconds
         */
        this.sleepTimeSec = 0.5;
    }
    /**
     * this method returns all the lookuptables
     *
     * @returns  Promise<LookupTable[]
     */
    getAllLookupTableAsync() {
        return new Promise(async (resolve, reject) => {
            this.isLoadingDataService.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            this.isLoadingDataService.hide();
            if (this.isCacheValid()) {
                const lookupTables = this.getElementsList();
                resolve(lookupTables);
            }
            else {
            }
            const lookupTables = this.arrayUtilityService.clone(MockDatabase.LookupTable);
            if (lookupTables !== null && lookupTables.length > 0) {
                this.setToCache(lookupTables, 'name');
                resolve(lookupTables);
            }
            else {
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'error',
                    detailKey: 'errorGetLookupTableList',
                }));
                reject(null);
            }
        });
    }
    /**
     * this method is responsible for saving a new lookupTable
     * or update an existing one
     *
     * @param lookupTable
     * @returns LookupTable
     */
    saveLookupTableAsync(lookupTable) {
        return new Promise(async (resolve, reject) => {
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            if (lookupTable.id) {
                const lookupTableToUpdate = MockDatabase.LookupTable.find((ltAux) => ltAux.id === lookupTable.id);
                if (lookupTableToUpdate) {
                    lookupTableToUpdate.description = lookupTable.description;
                    lookupTableToUpdate.universalStateId = lookupTable.universalStateId;
                    resolve(this.objectsUtilityService.cloneObject(lookupTableToUpdate));
                    //set catch
                    this.setToCache(this.objectsUtilityService.cloneObject(lookupTableToUpdate), 'name');
                    this.notificationsService.successNotification(new PrgSucess({
                        titleKey: 'success',
                        detailKey: 'lookupTableSuccessAdded',
                    }));
                }
                else {
                    this.notificationsService.errorNotification(new PrgError({
                        titleKey: 'error',
                        detailKey: 'errorAddLookupTable',
                    }));
                    reject(null);
                }
            }
            else {
                const newLookupTable = {
                    id: this.utilityService.newGuid(),
                    universalStateId: lookupTable.universalStateId,
                    transactionId: null,
                    operationId: null,
                    name: lookupTable.name,
                    label: null,
                    createdBy: null,
                    modifiedBy: null,
                    createdOn: null,
                    modifiedOn: null,
                    description: lookupTable.description,
                    workspaceId: null,
                    items: null,
                };
                const lookupTableList = MockDatabase.LookupTable;
                lookupTableList.unshift(newLookupTable);
                this.setToCache(this.objectsUtilityService.cloneObject(newLookupTable), 'name');
                resolve(this.objectsUtilityService.cloneObject(newLookupTable));
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'success',
                    detailKey: 'lookupTableSuccessAdded',
                }));
            }
        });
    }
    /**
     * this method is responsible for adding or
     * updating a set of lookup tables
     *
     * @param lookupTables
     * @returns LookupTable[]
     */
    saveMultipleLookupTableAsync(lookupTables) {
        return new Promise(async (resolve, reject) => {
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            let savedLookupTable = [];
            lookupTables.forEach((lt) => {
                if (lt.id) {
                    const lookupTableToUpdate = MockDatabase.LookupTable.find((ltAux) => ltAux.id === lt.id);
                    if (lookupTableToUpdate) {
                        lookupTableToUpdate.description = lt.description;
                        lookupTableToUpdate.universalStateId = lt.universalStateId;
                        savedLookupTable.push(lookupTableToUpdate);
                    }
                }
                else {
                    const newLookupTable = {
                        id: this.utilityService.newGuid(),
                        universalStateId: lt.universalStateId,
                        transactionId: null,
                        operationId: null,
                        name: lt.name,
                        label: null,
                        createdBy: null,
                        modifiedBy: null,
                        createdOn: null,
                        modifiedOn: null,
                        description: lt.description,
                        workspaceId: null,
                        items: null,
                    };
                    const lookupTableList = MockDatabase.LookupTable;
                    lookupTableList.unshift(newLookupTable);
                    savedLookupTable.push(newLookupTable);
                }
            });
            resolve(savedLookupTable);
            this.notificationsService.successNotification(new PrgSucess({
                titleKey: 'success',
                detailKey: 'sucessedsaveMultipleLookupTableAsync',
            }));
        });
    }
    /**
     * this method returns the items of a given lookup table
     *
     * @param id
     * @returns LookupTableItem[]
     */
    getLookupTableItemsByLookupTableIdAsync(id) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingDataService.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const lookupTableItems = MockDatabase.LookupTableItems.filter((item) => item.lookupTableId == id);
            resolve(lookupTableItems);
            this.isLoadingDataService.hide();
        });
    }
    /**
     * this method returns the items of a given lookup table
     *
     * @param id
     * @returns LookupTableItem[]
     */
    getLookupTableItemsByLookupTableNameAsync(name) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingDataService.show();
            const lookupTable = this.getElementByKey(name);
            if (this.isCacheValid() &&
                lookupTable != null &&
                lookupTable.items != null) {
                resolve(lookupTable.items);
                this.isLoadingDataService.hide();
            }
            else {
                await this.utilityService.sleepSecAsync(this.sleepTimeSec);
                const lookupTable = MockDatabase.LookupTable.find((lookupTable) => lookupTable.name === name);
                const lookupTableItems = MockDatabase.LookupTableItems.filter((item) => item.lookupTableId == lookupTable.id);
                lookupTable.items = lookupTableItems;
                const lookupTableTranslated = await this.getTranslations(lookupTable);
                this.setToCache(lookupTableTranslated, 'name');
                resolve(lookupTableTranslated.items);
                this.isLoadingDataService.hide();
            }
        });
    }
    /**
     * this method is responsible for saving a new lookupTable
     * or update an existing one
     *
     * @param lookupTable
     * @returns LookupTable
     */
    saveLookupTableItemAsync(lookupTableItem) {
        return new Promise(async (resolve, reject) => {
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            if (lookupTableItem.id) {
                const lookupTableItemToUpdate = MockDatabase.LookupTableItems.find((ltiAux) => ltiAux.id === lookupTableItem.id);
                if (lookupTableItemToUpdate) {
                    lookupTableItemToUpdate.description = lookupTableItem.description;
                    lookupTableItemToUpdate.universalStateId =
                        lookupTableItem.universalStateId;
                    resolve(this.objectsUtilityService.cloneObject(lookupTableItemToUpdate));
                    this.notificationsService.successNotification(new PrgSucess({
                        titleKey: 'success',
                        detailKey: 'lookupTableSuccessAdded',
                    }));
                }
                else {
                    this.notificationsService.errorNotification(new PrgError({
                        titleKey: 'error',
                        detailKey: 'errorAddLookupTable',
                    }));
                    reject(null);
                }
            }
            else {
                const newLookupTableItem = {
                    id: this.utilityService.newGuid(),
                    universalStateId: lookupTableItem.universalStateId,
                    transactionId: null,
                    operationId: null,
                    name: lookupTableItem.name,
                    label: null,
                    createdBy: null,
                    modifiedBy: null,
                    createdOn: null,
                    modifiedOn: null,
                    description: lookupTableItem.description,
                    workspaceId: null,
                    lookupTableId: lookupTableItem.lookupTableId,
                };
                const lookupTableList = MockDatabase.LookupTableItems;
                lookupTableList.unshift(newLookupTableItem);
                resolve(this.objectsUtilityService.cloneObject(newLookupTableItem));
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'success',
                    detailKey: 'lookupTableItemSuccessAdded',
                }));
            }
        });
    }
    /**
     * this method is responsible for adding or
     * updating a set of lookup tables items
     *
     * @param lookupTablesItems
     * @returns LookupTableItems[]
     */
    saveMultipleLookupTableItemsAsync(lookupTables) {
        return new Promise(async (resolve, reject) => {
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            let savedLookupTableItems = [];
            lookupTables.forEach((lt) => {
                if (lt.id) {
                    const lookupTableItemToUpdate = MockDatabase.LookupTableItems.find((ltAux) => ltAux.id === lt.id);
                    if (lookupTableItemToUpdate) {
                        lookupTableItemToUpdate.description = lt.description;
                        lookupTableItemToUpdate.universalStateId = lt.universalStateId;
                        savedLookupTableItems.push(lookupTableItemToUpdate);
                    }
                }
                else {
                    const newLookupTableItem = {
                        id: this.utilityService.newGuid(),
                        universalStateId: lt.universalStateId,
                        transactionId: null,
                        operationId: null,
                        name: lt.name,
                        label: null,
                        createdBy: null,
                        modifiedBy: null,
                        createdOn: null,
                        modifiedOn: null,
                        description: lt.description,
                        workspaceId: null,
                        lookupTableId: lt.lookupTableId,
                    };
                    const lookupTableList = MockDatabase.LookupTableItems;
                    lookupTableList.unshift(newLookupTableItem);
                    savedLookupTableItems.push(newLookupTableItem);
                }
            });
            resolve(savedLookupTableItems);
            this.notificationsService.successNotification(new PrgSucess({
                titleKey: 'success',
                detailKey: 'sucessedsaveMultipleLookupTableAsync',
            }));
        });
    }
    /**
     * Get lookup table item by id
     * @param {string} lookUpTableItemId
     * @returns {Promise<LookupTableItem>}
     */
    getLookUpTableItemByIdAsync(lookUpTableItemId) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingDataService.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const lookUpTableItemsList = [...MockDatabase.LookupTableItems];
            this.isLoadingDataService.hide();
            let lookUpTableItem = lookUpTableItemsList.find((lookUpTableItem) => {
                return lookUpTableItem.id == lookUpTableItemId;
            });
            if (lookUpTableItem) {
                resolve(lookUpTableItem);
            }
            else {
                reject('');
            }
        });
    }
    /**
     *
     */
    getMultipleLookupTableByName(lookupTableNames) {
        return new Promise(async (resolve, reject) => {
            const lookupTablesList = [];
            const lookUpTables = this.arrayUtilityService.clone(MockDatabase.LookupTable);
            const lookUpTableItems = this.arrayUtilityService.clone(MockDatabase.LookupTableItems);
            if (this.isCacheValid()) {
                lookupTableNames.forEach((name) => {
                    let lookupTableAux = this.getElementByKey(name);
                    if (!lookupTableAux) {
                        lookupTableAux = lookUpTables.find((lt) => lt.name === name);
                        if (lookupTableAux) {
                            lookupTableAux.items = lookUpTableItems.filter((li) => li.lookupTableId === lookupTableAux.id);
                        }
                        //TODO: error not found lookuptable
                    }
                    else if (!lookupTableAux.items) {
                        lookupTableAux.items = lookUpTableItems.filter((li) => li.lookupTableId === lookupTableAux.id);
                    }
                    lookupTablesList.push(lookupTableAux);
                });
            }
            else {
                lookupTableNames.forEach(async (name) => {
                    const lookupTableAux = lookUpTables.find((lt) => lt.name === name);
                    if (lookupTableAux) {
                        lookupTableAux.items = lookUpTableItems.filter((li) => li.lookupTableId === lookupTableAux.id);
                        const lookupTableAuxTranslated = await this.getTranslations(lookupTableAux);
                        lookupTablesList.push(lookupTableAuxTranslated);
                    }
                });
            }
            resolve(lookupTablesList);
            this.setToCache(lookupTablesList, 'name');
        });
    }
}
MockLookupTableService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockLookupTableService, deps: [{ token: IsLoadingDataService }, { token: NotificationsService }, { token: UtilityService }, { token: ObjectsUtilityService }, { token: TranslateService }, { token: ArrayUtilityService }], target: i0.ɵɵFactoryTarget.Injectable });
MockLookupTableService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockLookupTableService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockLookupTableService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: IsLoadingDataService }, { type: NotificationsService }, { type: UtilityService }, { type: ObjectsUtilityService }, { type: i5.TranslateService, decorators: [{
                    type: Inject,
                    args: [TranslateService]
                }] }, { type: ArrayUtilityService }]; } });

/**
 * LookupTableItem class that defines a look up table
 * <br />item to be used in dropowns by the front-end.
 * <br />Its form must have an name and description
 * <br />input fields that will be saved in i18n
 * <br />using an unique identifier created through
 * <br />its normalized "name" property
 */
class LookupTableItem extends BaseEntity {
}
/**
 * LookupTable class that defines a look up table
 * <br />to be used in dropowns by the front-end.
 * <br />Its form must have an name and description
 * <br />input fields that will be saved in i18n
 * <br />using an unique identifier created through
 * <br />its normalized "name" property
 */
class LookupTable extends BaseEntity {
}

/**
 * Page lookup Table
 */
class PrgLookupTablePage {
}
PrgLookupTablePage.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTablePage, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgLookupTablePage.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgLookupTablePage, selector: "app-prg-lookup-table", ngImport: i0, template: "<div >\r\n  <prg-lookup-table-table></prg-lookup-table-table>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "component", type: PrgLookupTableTableComponent, selector: "prg-lookup-table-table" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTablePage, decorators: [{
            type: Component,
            args: [{ selector: 'app-prg-lookup-table', template: "<div >\r\n  <prg-lookup-table-table></prg-lookup-table-table>\r\n</div>\r\n" }]
        }] });

/**
 * lookup tables routing module routes
 */
const standardRoutes$4 = [];
class PrgLookupTableRoutingModule {
}
PrgLookupTableRoutingModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableRoutingModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
PrgLookupTableRoutingModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableRoutingModule, imports: [i1$1.RouterModule], exports: [RouterModule] });
PrgLookupTableRoutingModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableRoutingModule, providers: [
        {
            provide: ROUTES,
            useFactory: () => {
                let routes = [];
                routes.push({
                    path: lookupTableConfig.lookupTableBasePath,
                    component: PrgLayoutsHeaderSidebarComponent,
                    children: [
                        {
                            path: '',
                            component: PrgLookupTablePage,
                        },
                    ],
                });
                return [...routes, ...standardRoutes$4];
            },
            multi: true,
        },
    ], imports: [RouterModule.forChild(standardRoutes$4), RouterModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableRoutingModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [RouterModule.forChild(standardRoutes$4)],
                    exports: [RouterModule],
                    providers: [
                        {
                            provide: ROUTES,
                            useFactory: () => {
                                let routes = [];
                                routes.push({
                                    path: lookupTableConfig.lookupTableBasePath,
                                    component: PrgLayoutsHeaderSidebarComponent,
                                    children: [
                                        {
                                            path: '',
                                            component: PrgLookupTablePage,
                                        },
                                    ],
                                });
                                return [...routes, ...standardRoutes$4];
                            },
                            multi: true,
                        },
                    ],
                }]
        }] });

/** Injectable */
/**
 * Lookup table real service
 */
class LookupTableService extends AbstractLookupTableService {
    /** constructor */
    constructor(translateService) {
        super(translateService);
    }
    /**
     * Get all Lookup Tables
     */
    getAllLookupTableAsync() {
        throw new Error('Method not implemented.');
    }
    /**
     * this method is responsible for saving a new lookupTable
     * or update an existing one
     *
     * @param lookupTable
     * @returns LookupTable
     */
    saveLookupTableAsync(lookupTable) {
        throw new Error('Method not implemented.');
    }
    /**
     * this method is responsible for adding or
     * updating a set of lookup tables
     *
     * @param lookupTables
     * @returns LookupTable[]
     */
    saveMultipleLookupTableAsync(lookupTables) {
        throw new Error('Method not implemented.');
    }
    /**
     * Get lookup table items by lookup table id
     * @param id
     */
    getLookupTableItemsByLookupTableIdAsync(id) {
        throw new Error('Method not implemented.');
    }
    /**
     * Get lookup table items by lookup table name
     * @param name
     */
    getLookupTableItemsByLookupTableNameAsync(name) {
        throw new Error('Method not implemented.');
    }
    /**
     * this method is responsible for saving a new lookupTableItem
     * or update an existing one
     * @param lookupTableItem
     */
    saveLookupTableItemAsync(lookupTableItem) {
        throw new Error('Method not implemented.');
    }
    /**
     * this method is responsible for adding or
     * updating a set of lookup tables items
     *
     * @param lookupTablesItems
     * @returns LookupTableItems[]
     */
    saveMultipleLookupTableItemsAsync(lookupTables) {
        throw new Error('Method not implemented.');
    }
    /**
     * Get lookup table item by id
     * @param {string} lookUpTableItemId
     * @returns {Promise<LookupTableItem>}
     */
    getLookUpTableItemByIdAsync(lookUpTableItemId) {
        throw new Error('Method not implemented.');
    }
    getMultipleLookupTableByName(lookupTableNames) {
        throw new Error('Method not implemented.');
    }
}
LookupTableService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: LookupTableService, deps: [{ token: TranslateService }], target: i0.ɵɵFactoryTarget.Injectable });
LookupTableService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: LookupTableService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: LookupTableService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: i5.TranslateService, decorators: [{
                    type: Inject,
                    args: [TranslateService]
                }] }]; } });

class PrgLookupTableModule {
    constructor(injector) {
        this.injector = injector;
        appInjector$4 = this.injector;
    }
    static forRoot(prgLookupTableConfig) {
        lookupTableConfig = prgLookupTableConfig;
        return {
            ngModule: PrgLookupTableModule,
            providers: [
                {
                    provide: PRG_LOOKUP_TABLE_CONFIG,
                    useValue: prgLookupTableConfig,
                },
                {
                    provide: AbstractLookupTableService,
                    useClass: prgLookupTableConfig.useMockServices
                        ? MockLookupTableService
                        : LookupTableService,
                },
            ],
        };
    }
}
PrgLookupTableModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgLookupTableModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableModule, declarations: [PrgLookupTablePage,
        PrgLookupTableTableComponent,
        PrgLookupTableItemsTableComponent], imports: [PrgSharedComponentsModule, PrgLookupTableRoutingModule], exports: [PrgLookupTableTableComponent, PrgLookupTableItemsTableComponent] });
PrgLookupTableModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableModule, imports: [PrgSharedComponentsModule, PrgLookupTableRoutingModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        PrgLookupTablePage,
                        PrgLookupTableTableComponent,
                        PrgLookupTableItemsTableComponent,
                    ],
                    imports: [PrgSharedComponentsModule, PrgLookupTableRoutingModule],
                    exports: [PrgLookupTableTableComponent, PrgLookupTableItemsTableComponent],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
let appInjector$4;
/**
 * Exports the AuthCoreConfig object
 */
let lookupTableConfig;

/**
 * AbstractQueriesService class that defines an
 * <br />abstract queries service to
 * <br />be extended by the mock and real
 * <br />queries services
 */
class AbstractQueriesService {
    /**
     * Constructor
     * @param {TranslateService} translationService
     * @protected
     */
    constructor(translationService) {
        this.translationService = translationService;
        /**
         * Current Queries list
         */
        this.queriesChangedSubject = new BehaviorSubject(null);
    }
    /**
     * Getter for queriesChangedSubject
     * @returns {Observable<Query[]>} the queriesChangedSubject as an observable
     */
    getQueriesChangedObservable() {
        return this.queriesChangedSubject.asObservable();
    }
    /**
     * Getter for queriesChangedSubject
     * @returns {Query[]} the queriesChangedSubject current value
     */
    getQueriesChanged() {
        return this.queriesChangedSubject.getValue();
    }
    /**
     * A setter queriesChangedSubject
     * @param {Query[]} queries
     * @protected
     */
    setQueriesChanged(queries) {
        this.queriesChangedSubject.next(queries);
    }
    /**
     * Function responsible to translate Filters Expressions
     * @param {string[]} filterExpression
     * @returns {Promise<FilterExpressionToTranslate[]>}
     */
    async getFilterExpressionTranslationsAsync(filterExpression) {
        return new Promise(async (resolve, reject) => {
            let filterExpressionToTranslate = [];
            filterExpression.map(async (filter) => {
                filterExpressionToTranslate.push({
                    expression: await filter,
                    label: await this.translationService
                        .get('filters.filter-expression.' + filter + '.label')
                        .toPromise(),
                });
            });
            resolve(filterExpressionToTranslate);
        });
    }
    /**
     * Function responsible to translate Filters Operators
     * @param {string[]} filterOperators
     * @returns {Promise<FilterOperationByTypeToTranslate[]>}
     */
    async getFilterOperationsTranslationsAsync(filterOperators) {
        return new Promise(async (resolve, reject) => {
            let filterExpressionToTranslate = [];
            filterOperators.map(async (filter) => {
                filterExpressionToTranslate.push({
                    operators: await filter,
                    label: await this.translationService
                        .get('filters.filter-operators.' + filter + '.label')
                        .toPromise(),
                });
            });
            resolve(filterExpressionToTranslate);
        });
    }
}

var _a;
/**
 * QueryOrderType enum
 */
var QueryOrderType;
(function (QueryOrderType) {
    QueryOrderType[QueryOrderType["Ascending"] = 0] = "Ascending";
    QueryOrderType[QueryOrderType["Descending"] = 1] = "Descending";
})(QueryOrderType || (QueryOrderType = {}));
/**
 * QueryFilterExpression enum
 */
var QueryFilterExpression;
(function (QueryFilterExpression) {
    QueryFilterExpression["And"] = "And";
    QueryFilterExpression["Or"] = "Or";
})(QueryFilterExpression || (QueryFilterExpression = {}));
/**
 * QueryFilterOperation enum
 */
var QueryFilterOperation;
(function (QueryFilterOperation) {
    QueryFilterOperation["EqualTo"] = "EqualTo";
    QueryFilterOperation["NotEqualTo"] = "NotEqualTo";
    QueryFilterOperation["GreaterThan"] = "GreaterThan";
    QueryFilterOperation["GreaterThanOrEqualTo"] = "GreaterThanOrEqualTo";
    QueryFilterOperation["LessThan"] = "LessThan";
    QueryFilterOperation["LessThanOrEqualTo"] = "LessThanOrEqualTo";
    QueryFilterOperation["Between"] = "Between";
    QueryFilterOperation["Contains"] = "Contains";
    QueryFilterOperation["DoesNotContain"] = "DoesNotContain";
    QueryFilterOperation["EndsWith"] = "EndsWith";
    QueryFilterOperation["In"] = "In";
    QueryFilterOperation["IsEmpty"] = "IsEmpty";
    QueryFilterOperation["IsNotEmpty"] = "IsNotEmpty";
    QueryFilterOperation["IsNotNull"] = "IsNotNull";
    QueryFilterOperation["IsNotNullNorWhiteSpace"] = "IsNotNullNorWhiteSpace";
    QueryFilterOperation["IsNull"] = "IsNull";
    QueryFilterOperation["IsNullOrWhiteSpace"] = "IsNullOrWhiteSpace";
    QueryFilterOperation["StartsWith"] = "StartsWith";
    QueryFilterOperation["NotIn"] = "NotIn";
})(QueryFilterOperation || (QueryFilterOperation = {}));
/**
 * QueryFilterOperationByType class that defines allowed filters operations
 * for a datatype through static properties
 */
class QueryFilterOperationByType {
    /**
     * Function that returns the number of fields required for a query filter operation
     * send by parameter
     * @param queryFilterOperation
     */
    numberOfFields(queryFilterOperation) {
        return queryFilterOperation === QueryFilterOperation.Between ? 2 : 1;
    }
}
_a = QueryFilterOperationByType;
/**
 * Static property to define filter operations for data type "default"
 */
QueryFilterOperationByType.default = [
    QueryFilterOperation.IsNull,
    QueryFilterOperation.IsEmpty,
    QueryFilterOperation.IsNotEmpty,
    QueryFilterOperation.IsNotNull,
];
/**
 * Static property to define filter operations for data type "string"
 */
QueryFilterOperationByType.string = [
    ..._a.default,
    QueryFilterOperation.Contains,
    QueryFilterOperation.DoesNotContain,
    QueryFilterOperation.StartsWith,
    QueryFilterOperation.EndsWith,
];
/**
 * Static property to define filter operations for data type "date"
 */
QueryFilterOperationByType.date = [..._a.default, QueryFilterOperation.Between];
/**
 * Static property to define filter operations for data type "number"
 */
QueryFilterOperationByType.number = [
    ..._a.default,
    QueryFilterOperation.Between,
    QueryFilterOperation.EqualTo,
    QueryFilterOperation.NotEqualTo,
    QueryFilterOperation.LessThan,
    QueryFilterOperation.LessThanOrEqualTo,
    QueryFilterOperation.GreaterThan,
    QueryFilterOperation.GreaterThanOrEqualTo,
];
/**
 * QueryColumn class that defines query results'
 * <br />properties and order
 */
class QueryColumn extends BaseEntity {
    /**
     * Constructor
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/**
 * QueryFilter class that defines filters
 * <br/>for non-raw queries
 */
class QueryFilter extends BaseEntity {
    /**
     * Constructor
     * @param {Partial<QueryFilter>} init
     */
    constructor(init) {
        super();
        /**
         * Filter operation
         */
        this.filterOperation = QueryFilterOperation.Contains;
        /**
         * Filter expression
         */
        this.filterExpression = QueryFilterExpression.And;
        Object.assign(this, init);
    }
}
/**
 * QueryOrder class that defines the query
 * <br />ordenation
 */
class QueryOrder extends BaseEntity {
    /**
     * Constructor
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/**
 * Query class that defines a generic query
 * <br />to be executed on the database
 */
class Query extends BaseEntity {
    /**
     * Constructor
     */
    constructor(init) {
        super();
        /**
         * Is raw (sql command) query
         */
        this.isRaw = true;
        Object.assign(this, init);
    }
}

/**
 * MockDatabase object to be used while developing
 * <br /> and/or testing the front-end
 */
const QueriesBDMOCK = {
    Queries: [
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'Query1',
            createdBy: '1',
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            isRaw: true,
            raw: 'select * from batatas',
            filters: null,
            columns: null,
            orders: null,
            pageSize: 2,
            pageIndex: 1,
            entityTypeId: null,
            description: 'Description of the Query 1',
        },
        {
            id: '2',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'Query2',
            createdBy: '2',
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            isRaw: true,
            raw: 'select * from bananas',
            filters: null,
            columns: null,
            orders: null,
            pageSize: 2,
            pageIndex: 1,
            entityTypeId: null,
            description: 'Description of the Query 2',
        },
        {
            id: '3',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'Query3',
            createdBy: '2',
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            isRaw: false,
            raw: null,
            description: 'Description of the Query 3',
            filters: [
                {
                    id: '1',
                    universalStateId: '1',
                    transactionId: null,
                    operationId: null,
                    name: 'customername',
                    createdBy: null,
                    modifiedBy: null,
                    createdOn: null,
                    modifiedOn: null,
                    workspaceId: '1',
                    filterExpression: QueryFilterExpression.And,
                    filterOperation: QueryFilterOperation.Contains,
                    queryId: '2',
                    propertyName: 'customername',
                    startGroup: true,
                    value: 'João',
                    value2: null,
                },
                {
                    id: '1',
                    universalStateId: '1',
                    transactionId: null,
                    operationId: null,
                    name: 'customerId',
                    workspaceId: '1',
                    filterExpression: QueryFilterExpression.And,
                    filterOperation: QueryFilterOperation.EqualTo,
                    queryId: '2',
                    propertyName: 'customerId',
                    startGroup: true,
                    value: 15,
                    value2: null,
                    createdBy: null,
                    modifiedBy: null,
                    createdOn: null,
                    modifiedOn: null,
                },
            ],
            columns: null,
            orders: null,
            pageSize: 2,
            pageIndex: 1,
            entityTypeId: '1',
        },
        {
            id: '4',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'Query4',
            createdBy: '1',
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            isRaw: false,
            raw: null,
            description: 'Description of the Query 4',
            filters: [
                new QueryFilter({
                    id: '1',
                    universalStateId: '1',
                    transactionId: null,
                    operationId: null,
                    name: 'city',
                    workspaceId: '1',
                    filterExpression: QueryFilterExpression.And,
                    filterOperation: QueryFilterOperation.DoesNotContain,
                    queryId: '4',
                    propertyName: 'city',
                    startGroup: true,
                    value: 'Porto',
                    value2: null,
                    createdBy: null,
                    modifiedBy: null,
                    createdOn: null,
                    modifiedOn: null,
                }),
                new QueryFilter({
                    id: '1',
                    universalStateId: '1',
                    transactionId: null,
                    operationId: null,
                    name: 'VAT',
                    workspaceId: '1',
                    filterExpression: QueryFilterExpression.And,
                    filterOperation: QueryFilterOperation.EqualTo,
                    queryId: '4',
                    propertyName: 'VAT',
                    startGroup: true,
                    value: 510588966,
                    value2: null,
                    createdBy: null,
                    modifiedBy: null,
                    createdOn: null,
                    modifiedOn: null,
                }),
            ],
            columns: null,
            orders: null,
            pageSize: 2,
            pageIndex: 1,
            entityTypeId: '1',
        },
    ],
};

/**
 * Injectable
 */
/**
 * MOCK AbstractQueriesService implementation
 */
class MockQueriesService extends AbstractQueriesService {
    /**
     * constructor
     * @param {NotificationsService} notificationsService
     * @param {UtilityService} utilityService
     * @param {IsLoadingDataService} isLoadingData
     * @param {ObjectsUtilityService} objectUtility
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {AbstractAuthService} authService
     * @param {TranslateService} translateService
     */
    constructor(notificationsService, utilityService, isLoadingData, objectUtility, arrayUtilityService, authService, translateService) {
        super(translateService);
        this.notificationsService = notificationsService;
        this.utilityService = utilityService;
        this.isLoadingData = isLoadingData;
        this.objectUtility = objectUtility;
        this.arrayUtilityService = arrayUtilityService;
        this.authService = authService;
        /**
         * default time in seconds
         */
        this.sleepTimeSec = 0.5;
    }
    /**
     * Function responsible to store a new query
     * @param {Query} newQuery
     * @returns {Promise<Query>}
     */
    createQueryAsync(newQuery) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            let checkNameQuery = QueriesBDMOCK.Queries.find((query) => newQuery.name === query.name);
            this.isLoadingData.hide();
            if (!checkNameQuery) {
                let query = this.objectUtility.cloneObject(newQuery);
                query['createdBy'] = this.authService?.getLoggedUser()?.id;
                query['id'] = this.utilityService.newGuid();
                QueriesBDMOCK.Queries.push(query);
                const queriesUpdated = this.arrayUtilityService.clone(QueriesBDMOCK.Queries);
                await this.setQueriesChanged(queriesUpdated);
                resolve(query);
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'New Query Created.',
                    detailKey: 'Success.',
                }));
            }
            else {
                reject('Queries could not be loaded');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Query not save.',
                    detailKey: 'Query name already exists in database',
                }));
            }
        });
    }
    /**
     * Function responsible to update a query
     * @param {string} queryId
     * @param {Query} queryUpdated
     * @returns {Promise<Query>}
     */
    updateQueryAsync(queryId, queryUpdated) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const queryIndexToUpdate = QueriesBDMOCK.Queries.findIndex((query) => {
                return query.id == queryId;
            });
            if (queryIndexToUpdate > -1) {
                QueriesBDMOCK.Queries[queryIndexToUpdate] = queryUpdated;
            }
            const queriesUpdated = this.arrayUtilityService.clone(QueriesBDMOCK.Queries);
            await this.setQueriesChanged(queriesUpdated);
            this.isLoadingData.hide();
            resolve(queryUpdated);
            this.notificationsService.successNotification(new PrgSucess({
                titleKey: 'Query updated.',
                detailKey: 'Success.',
            }));
        });
    }
    /**
     * Get all Queries
     * @returns {Promise<Query[]>}
     */
    getAllQueriesAsync() {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const queries = this.objectUtility.cloneObject(QueriesBDMOCK.Queries);
            this.isLoadingData.hide();
            if (queries) {
                resolve(queries);
            }
            else {
                reject('Queries could not be loaded');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Queries could not be loaded.',
                    detailKey: 'Server is down',
                }));
            }
        });
    }
    /**
     * Get query by Id
     * @param {string} queryId
     * @returns {Promise<Query>}
     */
    getQueryByIdAsync(queryId) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const query = this.objectUtility.cloneObject(QueriesBDMOCK.Queries.find((query) => {
                return query.id === queryId;
            }));
            this.isLoadingData.hide();
            if (query) {
                resolve(query);
            }
            else {
                reject('Query could not be loaded');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Query could not be loaded.',
                    detailKey: 'Server is down',
                }));
            }
        });
    }
}
MockQueriesService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockQueriesService, deps: [{ token: NotificationsService }, { token: UtilityService }, { token: IsLoadingDataService }, { token: ObjectsUtilityService }, { token: ArrayUtilityService }, { token: AbstractAuthService }, { token: TranslateService }], target: i0.ɵɵFactoryTarget.Injectable });
MockQueriesService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockQueriesService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockQueriesService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: NotificationsService }, { type: UtilityService }, { type: IsLoadingDataService }, { type: ObjectsUtilityService }, { type: ArrayUtilityService }, { type: AbstractAuthService }, { type: i5.TranslateService, decorators: [{
                    type: Inject,
                    args: [TranslateService]
                }] }]; } });

/**
 * Class to be used on the map of Query Filter to link fields to operators and data type
 */
class OperatorsAndDataType {
}
/**
 * Constant that defines the properties for each column of the Queries Filter table
 */
const QueriesFilterColumns = [
    new BaseField({
        key: 'startGroup',
        validators: [Validators.required],
        value: true,
        readonly: true,
        basePathTranslation: 'queries.fields.query-filter.fields.',
    }),
    new BaseField({
        key: 'propertyName',
        validators: [Validators.required],
        readonly: true,
        basePathTranslation: 'queries.fields.query-filter.fields.',
    }),
    new BaseField({
        key: 'filterOperation',
        validators: [Validators.required],
        readonly: true,
        basePathTranslation: 'queries.fields.query-filter.fields.',
    }),
    new BaseField({
        key: 'value',
        validators: [Validators.required],
        readonly: true,
        basePathTranslation: 'queries.fields.query-filter.fields.',
    }),
    new BaseField({
        key: 'value2',
        readonly: true,
        basePathTranslation: 'queries.fields.query-filter.fields.',
    }),
    new BaseField({
        key: 'query-filter-row-actions',
        readonly: true,
        basePathTranslation: 'queries.query-modal.actions.',
    }),
    new BaseField({
        key: 'filterExpression',
        validators: [Validators.required],
        value: QueryFilterExpression.And,
        readonly: true,
        basePathTranslation: 'queries.fields.query-filter.fields.',
    }),
];

/**
 * Class Input Text
 */
class InputTextAreaConfiguration extends BaseField {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * control name
         */
        this.controlName = ControlName.inputTextArea;
        /*
        /!**
         * When present, it specifies that the element should be disabled.
         *!/
        public disabled: boolean = false;*/ //Property already on Base Field
        /**
         * When present, textarea size changes as being typed.
         */
        this.autoResize = false;
        /**
         * textarea number of rows.
         */
        this.rows = 0;
        /**
         * textarea number of columns.
         */
        this.cols = 0;
        Object.assign(this, init);
    }
}

/**
 * Constant that defines the fields and actions for the dynamic form query filter
 */
const QUERIES_FILTER_DYNAMIC_FORM = {
    fields: [
        new BaseField({
            controlName: ControlName.inputText,
            value: null,
            key: 'name',
            validators: [Validators.required],
            basePathTranslation: 'queries.fields',
        }),
        new InputTextAreaConfiguration({
            controlName: ControlName.inputTextArea,
            value: null,
            key: 'description',
            validators: [Validators.required],
            basePathTranslation: 'queries.fields',
            cols: 100,
            rows: 2,
            autoResize: true,
        }),
        new SelectConfiguration({
            referenceType: ReferenceType.EntityType,
            key: 'entityTypeId',
            validators: [Validators.required],
            optionLabel: 'label',
            optionValue: 'id',
            showClear: true,
            basePathTranslation: 'queries.fields',
            disabledOutputEvent: false,
        }),
    ],
    actions: [
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Save,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='read'",
        }),
    ],
};

/**
 * Constant that defines the fields and actions for the dynamic form query raw
 */
const QUERIES_RAW_DYNAMIC_FORM = {
    fields: [
        new BaseField({
            controlName: ControlName.inputText,
            value: null,
            key: 'name',
            validators: [Validators.required],
            basePathTranslation: 'queries.fields',
        }),
        new InputTextAreaConfiguration({
            controlName: ControlName.inputTextArea,
            value: null,
            key: 'description',
            validators: [Validators.required],
            basePathTranslation: 'queries.fields',
            cols: 100,
            rows: 2,
            autoResize: true,
        }),
        new InputTextAreaConfiguration({
            controlName: ControlName.inputTextArea,
            value: null,
            key: 'raw',
            validators: [Validators.required],
            basePathTranslation: 'queries.fields',
            cols: 100,
            rows: 2,
            autoResize: true,
        }),
    ],
    actions: [
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Save,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='read'",
        }),
    ],
};

/**
 * Query Modal Component
 */
class PrgQueryModalComponent {
    /**
     * Constructor
     * @param {DynamicDialogRef} querySelectedDialogRef querySelectedDialogRef
     * @param {DynamicDialogConfig} querySelectedDialogConfig querySelectedDialogConfig
     * @param {AbstractQueriesService} queriesService
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {FormGroupService} formGroupService
     * @param {NotificationsService} notificationsService
     * @param {PrimeNGConfig} primengConfig
     * @param {AbstractEntityTypeService} entityTypeService
     * @param {AbstractLookupTableService} lookupTableService
     */
    constructor(querySelectedDialogRef, querySelectedDialogConfig, queriesService, objectsUtilityService, arrayUtilityService, formGroupService, notificationsService, primengConfig, entityTypeService, lookupTableService) {
        this.querySelectedDialogRef = querySelectedDialogRef;
        this.querySelectedDialogConfig = querySelectedDialogConfig;
        this.queriesService = queriesService;
        this.objectsUtilityService = objectsUtilityService;
        this.arrayUtilityService = arrayUtilityService;
        this.formGroupService = formGroupService;
        this.notificationsService = notificationsService;
        this.primengConfig = primengConfig;
        this.entityTypeService = entityTypeService;
        this.lookupTableService = lookupTableService;
        /**
         * Map of Operators and datatype associated to field
         * @type {Map<string, OperatorsAndDataType>}
         */
        this.mappedOperatorsAndDataTypeByField = new Map();
        /**
         * A copy of mappedOperatorsAndDataTypeByField
         * @type {Map<string, OperatorsAndDataType>}
         */
        this.mappedOperatorsAndDataTypeByFieldCopy = new Map();
        /**
         * Display column "Value2" when a query has a filter with two inputs values.
         *
         * Default false, hidden column.
         */
        this.queryHasFilterWithTwoValues = false;
        /**
         * The filter expressions ex:"AND" and its translations
         * @type {FilterExpressionToTranslate[]}
         */
        this.filterExpressions = [];
        /**
         * Create an object type QueryFilterOperationByType to
         * access his method numberOfFields on template.
         */
        this.operatorType = new QueryFilterOperationByType();
        /**
         * A form array that belongs to the formQueryFilter
         */
        this.queryFilterArrayForm = new FormArray([]);
        /**
         * Property  with type boolean which bind to the checkbox in template to change query type.
         *
         * Default is true (raw query)
         */
        this.checkBoxQueryRaw = true;
        /**
         * The properties and attributes available for selection by entity type
         */
        this.optionsQueryFields = [];
        /**
         * A copy of OptionsQueryFields
         */
        this.optionsQueryFieldsCopy = [];
        /**
         * The dynamic form fields to build dynamic form filter query in template
         */
        this.queriesFilterDynamicFormFields = this.arrayUtilityService.clone(QUERIES_FILTER_DYNAMIC_FORM.fields);
        /**
         * The dynamic form actions to build dynamic form filter query in template
         */
        this.queriesFilterDynamicFormActions = this.arrayUtilityService.clone(QUERIES_FILTER_DYNAMIC_FORM.actions);
        /**
         * The dynamic form fields to build dynamic form raw query in template
         */
        this.queriesRawDynamicFormFields = this.arrayUtilityService.clone(QUERIES_RAW_DYNAMIC_FORM.fields);
        /**
         * The dynamic form actions to build dynamic form raw query in template
         */
        this.queriesRawDynamicFormActions = this.arrayUtilityService.clone(QUERIES_RAW_DYNAMIC_FORM.actions);
        /**
         * Query table columns to build the formQueryFilter
         */
        this.queriesFilterColumns = QueriesFilterColumns;
        /**
         * This property define if component is loading data from an existing query.
         *
         * Default is true.
         * @type {boolean}
         */
        this.isLoading = true;
        /**
         * The view mode type that comes from parent component. Default is "read"
         */
        this.queriesViewMode = ViewMode.Read;
        /**
         * Property that defines if you are editing a query or creating a new one.
         *
         * Default is false (new query)
         */
        this.editMode = false;
    }
    /**
     * ngOnInit
     *
     * Set up all configurations require to initiate properly the component
     */
    async ngOnInit() {
        let dataQueryFromTable = this.querySelectedDialogConfig.data.query;
        this.queriesViewMode = this.querySelectedDialogConfig.data.viewMode;
        this.checkBoxQueryRaw = dataQueryFromTable.isRaw;
        if (dataQueryFromTable.id) {
            this.query = this.objectsUtilityService.cloneObject(await this.queriesService.getQueryByIdAsync(dataQueryFromTable.id));
            this.editMode = true;
            this.currentEntityTypeIdSelected = this.query.entityTypeId;
        }
        else {
            this.query = this.objectsUtilityService.cloneObject(dataQueryFromTable);
            this.editMode = false;
        }
        this.originalQuery =
            this.objectsUtilityService.cloneObject(dataQueryFromTable);
        this.primengConfig.ripple = true;
        this.initFormQueryFilter();
        if (this.queriesViewMode === ViewMode.Read) {
            this.queryFilterArrayForm.disable();
        }
        this.onCheckNumberOfFields();
        await this.getInitialData();
        this.filterExpressions =
            await this.queriesService.getFilterExpressionTranslationsAsync(Object.keys(QueryFilterExpression));
        this.isLoading = false;
    }
    /**
     * Get initial data (async)
     *
     * Function responsible for getting all data from api/mock required to initialize form query filter
     * @private
     */
    async getInitialData() {
        this.entityTypeList = this.arrayUtilityService.clone(await this.entityTypeService.getEntityTypeListAsync());
        if (this.currentEntityTypeIdSelected && !this.checkBoxQueryRaw) {
            await this.getFieldsByEntityTypeSelect();
            await this.mapOperatorsAndDataTypeByField();
        }
    }
    /**
     * Get fields by entity type selected(async)
     *
     * Function responsible for getting all fields (properties and attributes) available
     * from api/mock by entity type selected
     * @private
     */
    async getFieldsByEntityTypeSelect() {
        /*Check if entity selected has properties and attributes*/
        try {
            if (!this.checkBoxQueryRaw && this.currentEntityTypeIdSelected) {
                let entityTypeNameSelected = this.entityTypeList.find((entity) => entity.id === this.currentEntityTypeIdSelected).name;
                let entityAllData = this.objectsUtilityService.cloneObject(await this.entityTypeService.getAllEntityTypeDataByName(entityTypeNameSelected));
                this.optionsQueryFields = this.arrayUtilityService.clone([
                    ...entityAllData.properties,
                    ...entityAllData.attributes,
                ]);
                if (this.optionsQueryFieldsCopy == null ||
                    this.optionsQueryFieldsCopy.length < 1) {
                    this.optionsQueryFieldsCopy = this.arrayUtilityService.clone(this.optionsQueryFields);
                }
            }
        }
        catch (e) {
            this.optionsQueryFields = [];
        }
    }
    /**
     * Query raw action output (async)
     *
     * This function is responsible to handle actions from the dynamic raw form
     * @param {DynamicFormActionOutput} event the output from the dynamic raw form
     */
    async onActionQueryRaw(event) {
        switch (event.action) {
            case BaseActionKey.Save:
                await this.queryRawSave(event);
                break;
            case BaseActionKey.Cancel:
                if (event.formEntity.id) {
                    this.query = this.objectsUtilityService.cloneObject(this.originalQuery);
                }
                else {
                    this.querySelectedDialogRef.close();
                }
                this.queriesViewMode = ViewMode.Read;
                break;
            case BaseActionKey.Edit:
                this.queriesViewMode = ViewMode.Edit;
                break;
            default:
                break;
        }
    }
    /**
     * Save raw query (async)
     *
     * This function is responsible to save a new raw query or update an existing one
     * @param {DynamicFormActionOutput} event the output from the dynamic raw form
     * @private
     */
    async queryRawSave(event) {
        this.queriesViewMode = ViewMode.Read;
        // @ts-ignore
        const { group, ...query } = event.formEntity;
        query.isRaw = true;
        let queryResolve;
        if (query.id == null || query.id.length === 0) {
            queryResolve = await this.queriesService.createQueryAsync(query);
        }
        else {
            delete query.filters;
            delete query.entityTypeId;
            queryResolve = await this.queriesService.updateQueryAsync(query.id, query);
        }
        this.querySelectedDialogRef.close(queryResolve);
    }
    /**
     * Initialize Form Array of Filter Query
     * @param {boolean} editMode
     * @private
     */
    initFormArray(editMode = false) {
        if (this.query['filters'] && !editMode) {
            const aux = this.formGroupService.toFormGroupMultipleObjects(this.query.filters, this.queriesFilterColumns);
            this.query.filters.forEach((value, index) => {
                this.queryFilterArrayForm.push(aux[index]);
            });
        }
        else {
            const newQueryFilter = PrgQueryModalComponent.newQueryFilterObject();
            this.queryFilterArrayForm.controls = [];
            const aux2 = this.formGroupService.toFormGroupOneObject(newQueryFilter, this.queriesFilterColumns);
            this.queryFilterArrayForm.push(aux2);
        }
    }
    /**
     * Initialize Query Filter Form
     * @private
     */
    initFormQueryFilter() {
        this.initFormArray();
        this.formQueryFilter = new FormGroup({
            filters: this.queryFilterArrayForm,
        });
    }
    /**
     * A getter for the form array controls
     * @returns {any}
     */
    get filters() {
        return this.formQueryFilter.get('filters').controls;
    }
    /**
     * Delete a row of the filter query table  (async)
     * @param {number} i The table row
     *
     */
    onDeleteRow(i) {
        if (this.queryFilterArrayForm.length > 1) {
            this.formQueryFilter.get('filters').removeAt(i);
        }
        else {
            this.formQueryFilter.get('filters').reset();
        }
    }
    /**
     * Changing field (async)
     *
     * Function is call whenever is a change of field value
     * @param {number} i The table row
     * @param {string}value the name of the field
     */
    async onChangeField(i, value) {
        this.formQueryFilter.get('filters').controls.forEach((arrayRow, index) => {
            if (index === i) {
                arrayRow.controls.filterOperation.reset();
            }
        });
    }
    /**
     * Add a new element to query filter array (async)
     * @param {number} i The table row
     */
    async onAddRow(i) {
        const newQueryFilter = PrgQueryModalComponent.newQueryFilterObject();
        this.queryFilterArrayForm.insert(i + 1, this.formGroupService.toFormGroupOneObject(newQueryFilter, this.queriesFilterColumns));
    }
    /**
     * Function is call whenever entity type value changes
     * @param {string} entityID
     *
     */
    async onChangeEntity(entityID) {
        if (entityID == null) {
            return;
        }
        else {
            this.currentEntityTypeIdSelected = entityID;
            await this.getFieldsByEntityTypeSelect();
            await this.mapOperatorsAndDataTypeByField();
            this.initFormArray(this.editMode);
        }
    }
    /**
     * Changing Query type
     *
     * Function is call whenever toggle button changes
     */
    async onChangeQueryType() {
        if (!this.checkBoxQueryRaw && !this.query.id) {
            await this.getFieldsByEntityTypeSelect();
            await this.mapOperatorsAndDataTypeByField();
            this.initFormArray();
        }
    }
    /**
     * Auxiliary function to create a new instance of class QueryFilter
     * with all its properties
     * @returns {QueryFilter} new Object QueryFilter
     * @private
     */
    static newQueryFilterObject() {
        return {
            id: null,
            universalStateId: null,
            transactionId: null,
            operationId: null,
            name: null,
            workspaceId: null,
            filterExpression: QueryFilterExpression.And,
            filterOperation: null,
            queryId: null,
            propertyName: null,
            startGroup: true,
            value: null,
            value2: null,
            createdBy: null,
            createdOn: null,
            modifiedBy: null,
            modifiedOn: null,
        };
    }
    /**
     * Function is call whenever operator input changes in each row
     *
     * Function is responsible to find out if any of filter rows has an
     * operator that requires two inputs values an if so makes field value2 visible and apply required validator
     */
    onCheckNumberOfFields() {
        if (this.queryFilterArrayForm != null &&
            this.queryFilterArrayForm.length > 0) {
            const allOperations = this.queryFilterArrayForm.controls.map((a) => {
                return a.value.filterOperation;
            });
            let checkMultipleFields = false;
            for (let operation of allOperations) {
                let index = allOperations.indexOf(operation);
                let operatorType = new QueryFilterOperationByType();
                if (operatorType.numberOfFields(operation) === 2) {
                    checkMultipleFields = true;
                    this.queryFilterArrayForm.controls[index]
                        .get('value2')
                        .setValidators(Validators.required);
                    break;
                }
            }
            this.queryHasFilterWithTwoValues = checkMultipleFields;
        }
    }
    /**
     * Query filter action output (async)
     *
     * This function is responsible to handle actions from the dynamic filter form
     * @param {DynamicFormActionOutput} event the output from the dynamic filter form
     */
    async onActionQueryFilter(event) {
        switch (event.action) {
            case BaseActionKey.Save:
                if (this.queryFilterArrayForm.status === 'INVALID') {
                    this.notificationsService.errorNotification(new PrgError({
                        titleKey: 'Error Submitting Query ',
                        detailKey: 'Filling missing fields',
                    }));
                    return;
                }
                await this.queryFilterSave(event);
                break;
            case BaseActionKey.Cancel:
                await this.queryFilterCancel(event);
                break;
            case BaseActionKey.Edit:
                this.queriesViewMode = ViewMode.Edit;
                this.queryFilterArrayForm.enable();
                break;
            default:
                break;
        }
    }
    /**
     * Save filter query (async)
     *
     * This function is responsible to save a new filter query or update an existing one
     * @param {DynamicFormActionOutput} event the output from the dynamic filter form
     * @private
     */
    async queryFilterSave(event) {
        this.queriesViewMode = ViewMode.Read;
        const newQuery = new Query({
            isRaw: false,
            id: this.query.id ? this.query.id : null,
            createdBy: this.query.createdBy ? this.query.createdBy : null,
            name: event.formEntity.name,
            description: event.formEntity.description,
            entityTypeId: event.formEntity.entityTypeId,
            filters: this.formQueryFilter.value.filters,
        });
        let queryResolve;
        if (newQuery.id == null || newQuery.id.length === 0) {
            queryResolve = await this.queriesService.createQueryAsync(newQuery);
        }
        else {
            queryResolve = await this.queriesService.updateQueryAsync(newQuery.id, newQuery);
        }
        this.querySelectedDialogRef.close(queryResolve);
    }
    /**
     * Cancel filter query (async)
     *
     * This function is responsible to handle operations whenever cancel button is pressed
     *
     * If editing an existing query it will reset all values of the form
     *
     * If is a new one will close dialog
     * @param {DynamicFormActionOutput} event the output from the dynamic filter form
     * @private
     */
    async queryFilterCancel(event) {
        if (event.formEntity.id) {
            this.formQueryFilter.reset();
            this.isLoading = true;
            this.currentEntityTypeIdSelected = this.query.entityTypeId;
            this.optionsQueryFields = this.arrayUtilityService.clone(this.optionsQueryFieldsCopy);
            this.mappedOperatorsAndDataTypeByField.clear();
            this.mappedOperatorsAndDataTypeByField =
                this.objectsUtilityService.cloneObject(this.mappedOperatorsAndDataTypeByFieldCopy);
            this.queryFilterArrayForm.controls = [];
            this.initFormArray();
            this.query = this.objectsUtilityService.cloneObject(this.originalQuery);
            this.isLoading = false;
        }
        else {
            this.querySelectedDialogRef.close();
        }
        this.queriesViewMode = ViewMode.Read;
        this.queryFilterArrayForm.disable();
    }
    /**
     * This Function is responsible to map datatype for the fields values and operators
     *
     * associated to the chosen property or attribute for each filter row
     * @returns {Promise<void>}
     */
    async mapOperatorsAndDataTypeByField() {
        if (this.optionsQueryFields != null && this.optionsQueryFields.length > 0) {
            this.mappedOperatorsAndDataTypeByField.clear();
            let initMappedCopy = false;
            if (this.mappedOperatorsAndDataTypeByFieldCopy == null ||
                this.mappedOperatorsAndDataTypeByFieldCopy.size < 1) {
                initMappedCopy = true;
            }
            for (const fields of this.optionsQueryFields) {
                let dataTypeAux = this.lookupTableService
                    .getLookUpTableItemByIdAsync(fields.dataTypeId)
                    .then((value) => {
                    return value.name;
                });
                let auxOperation = QueryFilterOperationByType[await dataTypeAux];
                let queryFilterOperationAux = await this.queriesService.getFilterOperationsTranslationsAsync(auxOperation);
                Promise.all([dataTypeAux, queryFilterOperationAux]).then((values) => {
                    this.mappedOperatorsAndDataTypeByField.set(fields.name, {
                        queryFilterOperationByType: values[1],
                        dataType: values[0],
                    });
                    if (initMappedCopy) {
                        this.mappedOperatorsAndDataTypeByFieldCopy.set(fields.name, {
                            queryFilterOperationByType: values[1],
                            dataType: values[0],
                        });
                    }
                });
            }
        }
    }
}
PrgQueryModalComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueryModalComponent, deps: [{ token: i2.DynamicDialogRef }, { token: i2.DynamicDialogConfig }, { token: AbstractQueriesService }, { token: ObjectsUtilityService }, { token: ArrayUtilityService }, { token: FormGroupService }, { token: NotificationsService }, { token: i7.PrimeNGConfig }, { token: AbstractEntityTypeService }, { token: AbstractLookupTableService }], target: i0.ɵɵFactoryTarget.Component });
PrgQueryModalComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgQueryModalComponent, selector: "prg-select-query", ngImport: i0, template: "<div *ngIf=\"!isLoading\">\r\n<div class=\"my-4\">\r\n  <p-toggleButton (onChange)=\"onChangeQueryType()\" onLabel=\"{{'queries.query-modal.actions.query-type.filter-query.label' |translate}}\" offLabel=\"{{'queries.query-modal.actions.query-type.raw-query.label' |translate}}\"\r\n                  onIcon=\"pi pi-filter-fill\" offIcon=\"pi pi-file\" iconPos=\"right\"\r\n                  [(ngModel)]=\"checkBoxQueryRaw\"></p-toggleButton>\r\n\r\n</div>\r\n<ng-template [ngIf]=\"checkBoxQueryRaw\" [ngIfElse]=\"noRawQuery\">\r\n\r\n\r\n  <div class=\"mt-3\">\r\n    <prg-dynamic-form [viewMode]=\"queriesViewMode\" [actions]=\"queriesRawDynamicFormActions\"\r\n                      [fields]=\"queriesRawDynamicFormFields\"\r\n                      [entity]=\"query\" (actionOutput)=\"onActionQueryRaw($event)\">\r\n    </prg-dynamic-form>\r\n  </div>\r\n\r\n</ng-template>\r\n\r\n\r\n<ng-template #noRawQuery >\r\n\r\n  <prg-dynamic-form (fieldChangeOutput)=\"onChangeEntity($event.value)\" #PrgDynamicFormComponent\r\n                    (actionOutput)=\"onActionQueryFilter($event)\" [viewMode]=\"queriesViewMode\"\r\n                    [fields]=\"queriesFilterDynamicFormFields\" [actions]=\"queriesFilterDynamicFormActions\"\r\n                    [entity]=\"query\">\r\n\r\n  </prg-dynamic-form >\r\n\r\n\r\n\r\n\r\n  <form [formGroup]=\"formQueryFilter\" *ngIf=\"!isLoading\">\r\n\r\n    <div class=\"mt-2\">\r\n      <ng-template [ngIf]=\"PrgDynamicFormComponent.form.value['entityTypeId']\">\r\n        <p-table styleClass=\"p-datatable-gridlines\" [value]=\"filters\" dataKey=\"value\" formArrayName=\"filters\">\r\n          <ng-template pTemplate=\"header\">\r\n            <tr >\r\n              <ng-container *ngFor=\"let col of queriesFilterColumns\">\r\n              <th style=\"width: 10rem;text-align: center\" *ngIf=\"col.key==='startGroup'||col.key==='filterExpression'; else otherFields \" [hidden]=\"queryFilterArrayForm.length<=1\">{{col.basePathTranslation+col.key+'.label'|translate}}</th>\r\n              <ng-template #otherFields>\r\n                <th style=\"width: 10rem;text-align: center\" *ngIf=\"col.key!=='value2'&&col.key!=='query-filter-row-actions'\">{{col.basePathTranslation+col.key+'.label'|translate}}</th>\r\n                <th style=\"width: 10rem;text-align: center\" *ngIf=\"col.key==='query-filter-row-actions'\">{{col.basePathTranslation+col.key+'.label'|translate}}</th>\r\n                <th style=\"width: 10rem;text-align: center\" *ngIf=\"col.key==='value2'&&queryHasFilterWithTwoValues\">{{col.basePathTranslation+col.key+'.label'|translate}}</th>\r\n              </ng-template>\r\n              </ng-container>\r\n            </tr>\r\n          </ng-template>\r\n\r\n          <ng-template pTemplate=\"body\" let-i=\"rowIndex\">\r\n\r\n            <tr [formGroupName]=\"i\">\r\n\r\n              <td style=\"width: 5rem;text-align: center\" [hidden]=\"queryFilterArrayForm.length<=1\">\r\n\r\n                <p-checkbox formControlName=\"startGroup\" [binary]=\"true\"></p-checkbox>\r\n              </td>\r\n\r\n              <td style=\"width: 10rem;text-align: center\">\r\n\r\n\r\n                <p-dropdown [hidden]=\"PrgDynamicFormComponent.form.value['entityTypeId']==null\"\r\n                            (onChange)=\"onChangeField(i,$event.value)\" formControlName=\"propertyName\"\r\n                            [options]=\"optionsQueryFields\" optionValue=\"name\" optionLabel=\"label\" [filter]=\"true\"\r\n                            [showClear]=\"true\" placeholder=\"{{'queries.fields.query-filter.fields.propertyName.placeholder'|translate}}\" #fieldInput>\r\n\r\n                  <!--optionsQueryFields-->\r\n\r\n                </p-dropdown>\r\n              </td>\r\n              <td style=\"width: 10rem;text-align: center\">\r\n\r\n                <p-dropdown [hidden]=\"fieldInput.value==null\" formControlName=\"filterOperation\" optionLabel=\"label\" optionValue=\"operators\"\r\n                            (onChange)=\"onCheckNumberOfFields()\"\r\n                            [options]=\"mappedOperatorsAndDataTypeByField?.get(fieldInput.value)?.queryFilterOperationByType\" [filter]=\"true\"\r\n                            [showClear]=\"true\" placeholder=\"{{'queries.fields.query-filter.fields.filterOperation.placeholder'|translate}}\" #operatorInput>\r\n\r\n\r\n                </p-dropdown>\r\n\r\n              </td>\r\n\r\n\r\n              <td style=\"width: 10rem;text-align: center\"><input *ngIf=\"operatorInput.value!=null\"\r\n                                                                 formControlName=\"value\" id=\"value\"\r\n                                                                 [type]=\"mappedOperatorsAndDataTypeByField?.get(fieldInput.value)?.dataType==='number'?'number':mappedOperatorsAndDataTypeByField?.get(fieldInput.value)?.dataType==='date'?'date':'text'\"\r\n                                                                 placeholder=\"{{'queries.fields.query-filter.fields.value.placeholder'|translate}}\" pInputText\r\n\r\n\r\n              >\r\n              </td>\r\n\r\n              <td *ngIf=\"queryHasFilterWithTwoValues\" style=\"width: 10rem;text-align: center\"><input\r\n                *ngIf=\"operatorType.numberOfFields(operatorInput.value)==2\"\r\n                formControlName=\"value2\" id=\"value2\"\r\n                [type]=\"mappedOperatorsAndDataTypeByField?.get(fieldInput.value)?.dataType==='number'?'number':mappedOperatorsAndDataTypeByField?.get(fieldInput.value)?.dataType==='date'?'date':'text'\"\r\n                placeholder=\"{{'queries.fields.query-filter.fields.value2.placeholder'|translate}}\"\r\n                pInputText>\r\n              </td>\r\n\r\n              <td style=\"width: 10rem;text-align: center\">\r\n\r\n                <button [disabled]=\"this.queryFilterArrayForm.disabled\" pButton pRipple type=\"button\"  icon=\"pi pi-plus-circle\"\r\n                        (click)=\"onAddRow(i)\"\r\n                  class=\"p-button-rounded p-button-text p-button-success p-mr-2\"\r\n                ></button>\r\n\r\n                <button [disabled]=\"this.queryFilterArrayForm.disabled\" (click)=\"onDeleteRow(i)\" pButton pRipple type=\"button\"  icon=\"pi pi-times-circle\" class=\"p-button-rounded p-button-text p-button-danger\"\r\n                ></button>\r\n              </td>\r\n              <td style=\"width: 3rem;text-align: center\" [hidden]=\"i===(queryFilterArrayForm.length-1)\">\r\n                <p-dropdown  formControlName=\"filterExpression\" optionLabel=\"label\" optionValue=\"expression\"\r\n                            [options]=\"filterExpressions\" [filter]=\"true\"\r\n                            [showClear]=\"true\" placeholder=\"{{'queries.fields.query-filter.fields.filterExpression.placeholder'|translate}}\">\r\n\r\n\r\n                </p-dropdown>\r\n              </td>\r\n\r\n\r\n            </tr>\r\n\r\n          </ng-template>\r\n\r\n\r\n        </p-table>\r\n\r\n      </ng-template>\r\n    </div>\r\n  </form>\r\n\r\n</ng-template>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i7.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i1$2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i10$2.Table, selector: "p-table", inputs: ["frozenColumns", "frozenValue", "style", "styleClass", "tableStyle", "tableStyleClass", "paginator", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "paginatorDropdownScrollHeight", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showJumpToPageInput", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "selectionMode", "selectionPageOnly", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "rowSelectable", "rowTrackBy", "lazy", "lazyLoadOnInit", "compareSelectionBy", "csvSeparator", "exportFilename", "filters", "globalFilterFields", "filterDelay", "filterLocale", "expandedRowKeys", "editingRowKeys", "rowExpandMode", "scrollable", "scrollDirection", "rowGroupMode", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "responsive", "contextMenu", "resizableColumns", "columnResizeMode", "reorderableColumns", "loading", "loadingIcon", "showLoader", "rowHover", "customSort", "showInitialSortBadge", "autoLayout", "exportFunction", "exportHeader", "stateKey", "stateStorage", "editMode", "groupRowsBy", "groupRowsByOrder", "responsiveLayout", "breakpoint", "virtualRowHeight", "value", "columns", "first", "rows", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection", "selectAll"], outputs: ["selectAllChange", "selectionChange", "contextMenuSelectionChange", "onRowSelect", "onRowUnselect", "onPage", "onSort", "onFilter", "onLazyLoad", "onRowExpand", "onRowCollapse", "onContextMenuSelect", "onColResize", "onColReorder", "onRowReorder", "onEditInit", "onEditComplete", "onEditCancel", "onHeaderCheckboxToggle", "sortFunction", "firstChange", "rowsChange", "onStateSave", "onStateRestore"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i1$5.Dropdown, selector: "p-dropdown", inputs: ["scrollHeight", "filter", "name", "style", "panelStyle", "styleClass", "panelStyleClass", "readonly", "required", "editable", "appendTo", "tabindex", "placeholder", "filterPlaceholder", "filterLocale", "inputId", "selectId", "dataKey", "filterBy", "autofocus", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "autoDisplayFirst", "group", "showClear", "emptyFilterMessage", "emptyMessage", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "autoZIndex", "baseZIndex", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "ariaLabel", "ariaLabelledBy", "filterMatchMode", "maxlength", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "disabled", "itemSize", "options", "filterValue"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onShow", "onHide", "onClear", "onLazyLoad"] }, { kind: "component", type: i9.Checkbox, selector: "p-checkbox", inputs: ["value", "name", "disabled", "binary", "label", "ariaLabelledBy", "ariaLabel", "tabindex", "inputId", "style", "styleClass", "labelStyleClass", "formControl", "checkboxIcon", "readonly", "required", "trueValue", "falseValue"], outputs: ["onChange"] }, { kind: "directive", type: i11.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i3.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i3.FormGroupName, selector: "[formGroupName]", inputs: ["formGroupName"] }, { kind: "directive", type: i3.FormArrayName, selector: "[formArrayName]", inputs: ["formArrayName"] }, { kind: "component", type: i1$a.ToggleButton, selector: "p-toggleButton", inputs: ["onLabel", "offLabel", "onIcon", "offIcon", "ariaLabelledBy", "disabled", "style", "styleClass", "inputId", "tabindex", "iconPos"], outputs: ["onChange"] }, { kind: "component", type: PrgDynamicFormComponent, selector: "prg-dynamic-form", inputs: ["context", "fields", "actions", "entity", "viewMode", "formGroupType"], outputs: ["actionOutput", "fieldChangeOutput"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueryModalComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-select-query', template: "<div *ngIf=\"!isLoading\">\r\n<div class=\"my-4\">\r\n  <p-toggleButton (onChange)=\"onChangeQueryType()\" onLabel=\"{{'queries.query-modal.actions.query-type.filter-query.label' |translate}}\" offLabel=\"{{'queries.query-modal.actions.query-type.raw-query.label' |translate}}\"\r\n                  onIcon=\"pi pi-filter-fill\" offIcon=\"pi pi-file\" iconPos=\"right\"\r\n                  [(ngModel)]=\"checkBoxQueryRaw\"></p-toggleButton>\r\n\r\n</div>\r\n<ng-template [ngIf]=\"checkBoxQueryRaw\" [ngIfElse]=\"noRawQuery\">\r\n\r\n\r\n  <div class=\"mt-3\">\r\n    <prg-dynamic-form [viewMode]=\"queriesViewMode\" [actions]=\"queriesRawDynamicFormActions\"\r\n                      [fields]=\"queriesRawDynamicFormFields\"\r\n                      [entity]=\"query\" (actionOutput)=\"onActionQueryRaw($event)\">\r\n    </prg-dynamic-form>\r\n  </div>\r\n\r\n</ng-template>\r\n\r\n\r\n<ng-template #noRawQuery >\r\n\r\n  <prg-dynamic-form (fieldChangeOutput)=\"onChangeEntity($event.value)\" #PrgDynamicFormComponent\r\n                    (actionOutput)=\"onActionQueryFilter($event)\" [viewMode]=\"queriesViewMode\"\r\n                    [fields]=\"queriesFilterDynamicFormFields\" [actions]=\"queriesFilterDynamicFormActions\"\r\n                    [entity]=\"query\">\r\n\r\n  </prg-dynamic-form >\r\n\r\n\r\n\r\n\r\n  <form [formGroup]=\"formQueryFilter\" *ngIf=\"!isLoading\">\r\n\r\n    <div class=\"mt-2\">\r\n      <ng-template [ngIf]=\"PrgDynamicFormComponent.form.value['entityTypeId']\">\r\n        <p-table styleClass=\"p-datatable-gridlines\" [value]=\"filters\" dataKey=\"value\" formArrayName=\"filters\">\r\n          <ng-template pTemplate=\"header\">\r\n            <tr >\r\n              <ng-container *ngFor=\"let col of queriesFilterColumns\">\r\n              <th style=\"width: 10rem;text-align: center\" *ngIf=\"col.key==='startGroup'||col.key==='filterExpression'; else otherFields \" [hidden]=\"queryFilterArrayForm.length<=1\">{{col.basePathTranslation+col.key+'.label'|translate}}</th>\r\n              <ng-template #otherFields>\r\n                <th style=\"width: 10rem;text-align: center\" *ngIf=\"col.key!=='value2'&&col.key!=='query-filter-row-actions'\">{{col.basePathTranslation+col.key+'.label'|translate}}</th>\r\n                <th style=\"width: 10rem;text-align: center\" *ngIf=\"col.key==='query-filter-row-actions'\">{{col.basePathTranslation+col.key+'.label'|translate}}</th>\r\n                <th style=\"width: 10rem;text-align: center\" *ngIf=\"col.key==='value2'&&queryHasFilterWithTwoValues\">{{col.basePathTranslation+col.key+'.label'|translate}}</th>\r\n              </ng-template>\r\n              </ng-container>\r\n            </tr>\r\n          </ng-template>\r\n\r\n          <ng-template pTemplate=\"body\" let-i=\"rowIndex\">\r\n\r\n            <tr [formGroupName]=\"i\">\r\n\r\n              <td style=\"width: 5rem;text-align: center\" [hidden]=\"queryFilterArrayForm.length<=1\">\r\n\r\n                <p-checkbox formControlName=\"startGroup\" [binary]=\"true\"></p-checkbox>\r\n              </td>\r\n\r\n              <td style=\"width: 10rem;text-align: center\">\r\n\r\n\r\n                <p-dropdown [hidden]=\"PrgDynamicFormComponent.form.value['entityTypeId']==null\"\r\n                            (onChange)=\"onChangeField(i,$event.value)\" formControlName=\"propertyName\"\r\n                            [options]=\"optionsQueryFields\" optionValue=\"name\" optionLabel=\"label\" [filter]=\"true\"\r\n                            [showClear]=\"true\" placeholder=\"{{'queries.fields.query-filter.fields.propertyName.placeholder'|translate}}\" #fieldInput>\r\n\r\n                  <!--optionsQueryFields-->\r\n\r\n                </p-dropdown>\r\n              </td>\r\n              <td style=\"width: 10rem;text-align: center\">\r\n\r\n                <p-dropdown [hidden]=\"fieldInput.value==null\" formControlName=\"filterOperation\" optionLabel=\"label\" optionValue=\"operators\"\r\n                            (onChange)=\"onCheckNumberOfFields()\"\r\n                            [options]=\"mappedOperatorsAndDataTypeByField?.get(fieldInput.value)?.queryFilterOperationByType\" [filter]=\"true\"\r\n                            [showClear]=\"true\" placeholder=\"{{'queries.fields.query-filter.fields.filterOperation.placeholder'|translate}}\" #operatorInput>\r\n\r\n\r\n                </p-dropdown>\r\n\r\n              </td>\r\n\r\n\r\n              <td style=\"width: 10rem;text-align: center\"><input *ngIf=\"operatorInput.value!=null\"\r\n                                                                 formControlName=\"value\" id=\"value\"\r\n                                                                 [type]=\"mappedOperatorsAndDataTypeByField?.get(fieldInput.value)?.dataType==='number'?'number':mappedOperatorsAndDataTypeByField?.get(fieldInput.value)?.dataType==='date'?'date':'text'\"\r\n                                                                 placeholder=\"{{'queries.fields.query-filter.fields.value.placeholder'|translate}}\" pInputText\r\n\r\n\r\n              >\r\n              </td>\r\n\r\n              <td *ngIf=\"queryHasFilterWithTwoValues\" style=\"width: 10rem;text-align: center\"><input\r\n                *ngIf=\"operatorType.numberOfFields(operatorInput.value)==2\"\r\n                formControlName=\"value2\" id=\"value2\"\r\n                [type]=\"mappedOperatorsAndDataTypeByField?.get(fieldInput.value)?.dataType==='number'?'number':mappedOperatorsAndDataTypeByField?.get(fieldInput.value)?.dataType==='date'?'date':'text'\"\r\n                placeholder=\"{{'queries.fields.query-filter.fields.value2.placeholder'|translate}}\"\r\n                pInputText>\r\n              </td>\r\n\r\n              <td style=\"width: 10rem;text-align: center\">\r\n\r\n                <button [disabled]=\"this.queryFilterArrayForm.disabled\" pButton pRipple type=\"button\"  icon=\"pi pi-plus-circle\"\r\n                        (click)=\"onAddRow(i)\"\r\n                  class=\"p-button-rounded p-button-text p-button-success p-mr-2\"\r\n                ></button>\r\n\r\n                <button [disabled]=\"this.queryFilterArrayForm.disabled\" (click)=\"onDeleteRow(i)\" pButton pRipple type=\"button\"  icon=\"pi pi-times-circle\" class=\"p-button-rounded p-button-text p-button-danger\"\r\n                ></button>\r\n              </td>\r\n              <td style=\"width: 3rem;text-align: center\" [hidden]=\"i===(queryFilterArrayForm.length-1)\">\r\n                <p-dropdown  formControlName=\"filterExpression\" optionLabel=\"label\" optionValue=\"expression\"\r\n                            [options]=\"filterExpressions\" [filter]=\"true\"\r\n                            [showClear]=\"true\" placeholder=\"{{'queries.fields.query-filter.fields.filterExpression.placeholder'|translate}}\">\r\n\r\n\r\n                </p-dropdown>\r\n              </td>\r\n\r\n\r\n            </tr>\r\n\r\n          </ng-template>\r\n\r\n\r\n        </p-table>\r\n\r\n      </ng-template>\r\n    </div>\r\n  </form>\r\n\r\n</ng-template>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i2.DynamicDialogRef }, { type: i2.DynamicDialogConfig }, { type: AbstractQueriesService }, { type: ObjectsUtilityService }, { type: ArrayUtilityService }, { type: FormGroupService }, { type: NotificationsService }, { type: i7.PrimeNGConfig }, { type: AbstractEntityTypeService }, { type: AbstractLookupTableService }]; } });

/**
 * Queries Table Component
 */
class PrgQueriesTableComponent {
    /**
     * Constructor
     * @param {AbstractQueriesService} queriesService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {ObjectsUtilityService} objectsUtilityService
     * @param {AbstractAuthService} userService
     * @param {PrgQueriesConfig} prgQueriesConfig
     * @param {DialogService} dialogService dialogService
     */
    constructor(queriesService, arrayUtilityService, objectsUtilityService, userService, prgQueriesConfig, dialogService) {
        this.queriesService = queriesService;
        this.arrayUtilityService = arrayUtilityService;
        this.objectsUtilityService = objectsUtilityService;
        this.userService = userService;
        this.prgQueriesConfig = prgQueriesConfig;
        this.dialogService = dialogService;
        /**
         * Queries Table columns
         */
        this.queriesTableColumns = this.prgQueriesConfig.queryTableColumns;
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         */
        this.subscription = [];
    }
    /**
     * ngOnInit
     */
    async ngOnInit() {
        await this.getAllQueries();
    }
    /**
     * ngOnDestroy
     *
     * Unsubscribe all subscriptions
     */
    ngOnDestroy() {
        this.subscription.forEach((subscription) => {
            subscription.unsubscribe();
        });
        this.subscription = [];
    }
    /**
     * Get queries list (async)
     *
     * Function responsible to fetch all queries from api to populate table
     * @private
     */
    async getAllQueries() {
        this.queries = await this.queriesService.getAllQueriesAsync();
        this.createTreeNode();
    }
    /**
     * Creation of Tree Node Object
     *
     * This function is responsible to group queries by creator  (logged user and others)
     * to organize query data for the table tree
     * @private
     */
    createTreeNode() {
        this.queries.forEach((query) => {
            if (this.userService.getLoggedUser()) {
                this.loggedUserId = this.userService.getLoggedUser().id;
                if (query.createdBy === this.loggedUserId) {
                    query['group'] = 'myQueries';
                }
                else {
                    query['group'] = 'otherQueries';
                }
            }
        });
        this.treeData = this.arrayUtilityService.groupByField(this.queries, 'group');
    }
    /**
     * Function responsible to open dialog when a query is clicked.
     *
     * It also manages the data that comes from dialog when it is closed.
     *
     * @param {Query} query the selected query
     */
    openQueryDialog(query) {
        let queryAux;
        if (query) {
            queryAux = this.objectsUtilityService.cloneObject(query);
        }
        else {
            queryAux = new Query();
        }
        this.querySelectedDialogRef = this.dialogService.open(PrgQueryModalComponent, {
            header: queryAux ? queryAux.name : 'New Query',
            width: '80%',
            height: '90vh',
            baseZIndex: 10000,
            data: {
                query: queryAux,
                viewMode: queryAux.id ? ViewMode.Read : ViewMode.Edit,
            },
        });
        this.subscription.push(this.querySelectedDialogRef.onClose.subscribe((newData) => {
            this.subscription.push(this.queriesService
                .getQueriesChangedObservable()
                .subscribe((queries) => {
                if (newData && queries) {
                    this.queries = this.arrayUtilityService.clone(queries);
                    this.createTreeNode();
                }
                this.querySelectedDialogRef.destroy();
            }));
        }));
    }
}
PrgQueriesTableComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesTableComponent, deps: [{ token: AbstractQueriesService }, { token: ArrayUtilityService }, { token: ObjectsUtilityService }, { token: AbstractAuthService }, { token: PRG_QUERIES_CONFIG }, { token: i2.DialogService }], target: i0.ɵɵFactoryTarget.Component });
PrgQueriesTableComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgQueriesTableComponent, selector: "prg-queries-table", ngImport: i0, template: "\r\n<div>\r\n  <p-treeTable [value]=\"treeData\" >\r\n    <ng-template pTemplate=\"header\">\r\n      <tr>\r\n\r\n        <th style=\"width: 10rem;text-align: center\" *ngFor=\"let col of queriesTableColumns\" [ttSortableColumn]=\"col.key\" pTooltip=\"{{col.basePathTranslation+'.'+col.key+'.tooltip'|translate }}\" tooltipPosition=\"top\">\r\n\r\n            {{ col.basePathTranslation+\".\"+col.key+\".label\"|translate }}\r\n\r\n          <p-treeTableSortIcon [field]=\"col.key\"></p-treeTableSortIcon>\r\n\r\n        </th>\r\n        <th style=\"width: 3rem;text-align: center\">\r\n          <p-button pTooltip=\"{{'queries.queries-list.actions.add.label'|translate}}\" tooltipPosition=\"bottom\" (click)=\" openQueryDialog(null)\" type=\"button\" icon=\"pi pi-plus-circle\"></p-button>\r\n        </th>\r\n      </tr>\r\n    </ng-template>\r\n\r\n    <ng-template pTemplate=\"body\" let-rowNode let-rowData=\"rowData\">\r\n      <tr\r\n        [ttRow]=\"rowNode\"\r\n        (click)=\"rowNode.level !== 0 && openQueryDialog(rowData)\"\r\n        [ngClass]=\"{ clickableRow: rowNode.level !== 0 }\"\r\n      >\r\n        <td *ngFor=\"let col of queriesTableColumns; let i = index ;let last = last \" [colSpan]=\"last?2:1\" [ngStyle]=\"{'text-align':(rowNode.level!==0)? 'center':''}\" >\r\n          <p-treeTableToggler\r\n            *ngIf=\"i == 0\"\r\n            [rowNode]=\"rowNode\"\r\n\r\n          ></p-treeTableToggler>\r\n\r\n          <ng-template [ngIf]=\"col.key=='isRaw' && rowNode.level!==0\">\r\n            {{rowData[col.key] ? 'Yes': 'No'}}\r\n          </ng-template>\r\n          <ng-template  [ngIf]=\"col.key!='isRaw' && rowNode.level!==0\" >\r\n            {{rowData[col.key]}}\r\n          </ng-template>\r\n\r\n          <ng-template  [ngIf]=\"i==0&&rowNode.level==0\">\r\n            {{'queries.queries-list.queries-group.'+rowData[col.key]+'.label'|translate }}\r\n\r\n          </ng-template>\r\n\r\n\r\n\r\n        </td>\r\n      </tr>\r\n    </ng-template>\r\n  </p-treeTable>\r\n\r\n</div>\r\n", styles: [".clickableRow{cursor:pointer}.clickableRow:hover{background-color:#cbf6f6}\n"], dependencies: [{ kind: "directive", type: i7$4.Tooltip, selector: "[pTooltip]", inputs: ["tooltipPosition", "tooltipEvent", "appendTo", "positionStyle", "tooltipStyleClass", "tooltipZIndex", "escape", "showDelay", "hideDelay", "life", "positionTop", "positionLeft", "fitContent", "pTooltip", "tooltipDisabled", "tooltipOptions"] }, { kind: "directive", type: i7.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i1$2.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1$2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i1$2.NgStyle, selector: "[ngStyle]", inputs: ["ngStyle"] }, { kind: "component", type: i8.Button, selector: "p-button", inputs: ["type", "iconPos", "icon", "badge", "label", "disabled", "loading", "loadingIcon", "style", "styleClass", "badgeClass", "ariaLabel"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "component", type: i10$1.TreeTable, selector: "p-treeTable", inputs: ["columns", "style", "styleClass", "tableStyle", "tableStyleClass", "autoLayout", "lazy", "lazyLoadOnInit", "paginator", "rows", "first", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "customSort", "selectionMode", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "compareSelectionBy", "rowHover", "loading", "loadingIcon", "showLoader", "scrollable", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "frozenColumns", "resizableColumns", "columnResizeMode", "reorderableColumns", "contextMenu", "rowTrackBy", "filters", "globalFilterFields", "filterDelay", "filterMode", "filterLocale", "virtualRowHeight", "value", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection"], outputs: ["selectionChange", "contextMenuSelectionChange", "onFilter", "onNodeExpand", "onNodeCollapse", "onPage", "onSort", "onLazyLoad", "sortFunction", "onColResize", "onColReorder", "onNodeSelect", "onNodeUnselect", "onContextMenuSelect", "onHeaderCheckboxToggle", "onEditInit", "onEditComplete", "onEditCancel"] }, { kind: "component", type: i10$1.TreeTableToggler, selector: "p-treeTableToggler", inputs: ["rowNode"] }, { kind: "directive", type: i10$1.TTSortableColumn, selector: "[ttSortableColumn]", inputs: ["ttSortableColumn", "ttSortableColumnDisabled"] }, { kind: "component", type: i10$1.TTSortIcon, selector: "p-treeTableSortIcon", inputs: ["field", "ariaLabelDesc", "ariaLabelAsc"] }, { kind: "directive", type: i10$1.TTRow, selector: "[ttRow]", inputs: ["ttRow"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesTableComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-queries-table', template: "\r\n<div>\r\n  <p-treeTable [value]=\"treeData\" >\r\n    <ng-template pTemplate=\"header\">\r\n      <tr>\r\n\r\n        <th style=\"width: 10rem;text-align: center\" *ngFor=\"let col of queriesTableColumns\" [ttSortableColumn]=\"col.key\" pTooltip=\"{{col.basePathTranslation+'.'+col.key+'.tooltip'|translate }}\" tooltipPosition=\"top\">\r\n\r\n            {{ col.basePathTranslation+\".\"+col.key+\".label\"|translate }}\r\n\r\n          <p-treeTableSortIcon [field]=\"col.key\"></p-treeTableSortIcon>\r\n\r\n        </th>\r\n        <th style=\"width: 3rem;text-align: center\">\r\n          <p-button pTooltip=\"{{'queries.queries-list.actions.add.label'|translate}}\" tooltipPosition=\"bottom\" (click)=\" openQueryDialog(null)\" type=\"button\" icon=\"pi pi-plus-circle\"></p-button>\r\n        </th>\r\n      </tr>\r\n    </ng-template>\r\n\r\n    <ng-template pTemplate=\"body\" let-rowNode let-rowData=\"rowData\">\r\n      <tr\r\n        [ttRow]=\"rowNode\"\r\n        (click)=\"rowNode.level !== 0 && openQueryDialog(rowData)\"\r\n        [ngClass]=\"{ clickableRow: rowNode.level !== 0 }\"\r\n      >\r\n        <td *ngFor=\"let col of queriesTableColumns; let i = index ;let last = last \" [colSpan]=\"last?2:1\" [ngStyle]=\"{'text-align':(rowNode.level!==0)? 'center':''}\" >\r\n          <p-treeTableToggler\r\n            *ngIf=\"i == 0\"\r\n            [rowNode]=\"rowNode\"\r\n\r\n          ></p-treeTableToggler>\r\n\r\n          <ng-template [ngIf]=\"col.key=='isRaw' && rowNode.level!==0\">\r\n            {{rowData[col.key] ? 'Yes': 'No'}}\r\n          </ng-template>\r\n          <ng-template  [ngIf]=\"col.key!='isRaw' && rowNode.level!==0\" >\r\n            {{rowData[col.key]}}\r\n          </ng-template>\r\n\r\n          <ng-template  [ngIf]=\"i==0&&rowNode.level==0\">\r\n            {{'queries.queries-list.queries-group.'+rowData[col.key]+'.label'|translate }}\r\n\r\n          </ng-template>\r\n\r\n\r\n\r\n        </td>\r\n      </tr>\r\n    </ng-template>\r\n  </p-treeTable>\r\n\r\n</div>\r\n", styles: [".clickableRow{cursor:pointer}.clickableRow:hover{background-color:#cbf6f6}\n"] }]
        }], ctorParameters: function () { return [{ type: AbstractQueriesService }, { type: ArrayUtilityService }, { type: ObjectsUtilityService }, { type: AbstractAuthService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_QUERIES_CONFIG]
                }] }, { type: i2.DialogService }]; } });

/**
 * Page Queries
 */
class PrgQueriesPage {
}
PrgQueriesPage.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesPage, deps: [], target: i0.ɵɵFactoryTarget.Component });
PrgQueriesPage.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgQueriesPage, selector: "prg-queries", ngImport: i0, template: "<div>\r\n  <prg-queries-table></prg-queries-table>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "component", type: PrgQueriesTableComponent, selector: "prg-queries-table" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesPage, decorators: [{
            type: Component,
            args: [{ selector: 'prg-queries', template: "<div>\r\n  <prg-queries-table></prg-queries-table>\r\n</div>\r\n" }]
        }] });

const standardRoutes$3 = [];
class PrgQueriesRoutingModule {
}
PrgQueriesRoutingModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesRoutingModule, deps: [], target: i0.ɵɵFactoryTarget.NgModule });
PrgQueriesRoutingModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesRoutingModule, imports: [i1$1.RouterModule], exports: [RouterModule] });
PrgQueriesRoutingModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesRoutingModule, providers: [
        {
            provide: ROUTES,
            useFactory: () => {
                let routes = [];
                routes.push({
                    path: queriesConfig.queriesRoutingPath,
                    component: PrgLayoutsHeaderSidebarComponent,
                    children: [
                        {
                            path: '',
                            component: PrgQueriesPage,
                        },
                    ],
                });
                return [...routes, ...standardRoutes$3];
            },
            multi: true,
        },
    ], imports: [RouterModule.forChild(standardRoutes$3), RouterModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesRoutingModule, decorators: [{
            type: NgModule,
            args: [{
                    imports: [RouterModule.forChild(standardRoutes$3)],
                    exports: [RouterModule],
                    providers: [
                        {
                            provide: ROUTES,
                            useFactory: () => {
                                let routes = [];
                                routes.push({
                                    path: queriesConfig.queriesRoutingPath,
                                    component: PrgLayoutsHeaderSidebarComponent,
                                    children: [
                                        {
                                            path: '',
                                            component: PrgQueriesPage,
                                        },
                                    ],
                                });
                                return [...routes, ...standardRoutes$3];
                            },
                            multi: true,
                        },
                    ],
                }]
        }] });

/**
 * Injectable
 */
/**
 * REAL AbstractQueriesService implementation
 */
class QueriesService extends AbstractQueriesService {
    /**
     * Constructor
     * @param {TranslateService} translateService
     */
    constructor(translateService) {
        super(translateService);
    }
    /**
     * Function responsible to store a new query
     * @param {Query} newQuery
     * @returns {Promise<Query>}
     */
    createQueryAsync(newQuery) {
        throw new Error('Method not implemented.');
    }
    /**
     * Function responsible to update a query
     * @param {string} queryId
     * @param {Query} queryUpdated
     * @returns {Promise<Query>}
     */
    updateQueryAsync(queryId, queryUpdated) {
        throw new Error('Method not implemented.');
    }
    /**
     * Get all Queries
     * @returns {Promise<Query[]>}
     */
    getAllQueriesAsync() {
        throw new Error('Method not implemented.');
    }
    /**
     * Get query by Id
     * @param {string} queryId
     * @returns {Promise<Query>}
     */
    getQueryByIdAsync(queryId) {
        throw new Error('Method not implemented.');
    }
}
QueriesService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: QueriesService, deps: [{ token: TranslateService }], target: i0.ɵɵFactoryTarget.Injectable });
QueriesService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: QueriesService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: QueriesService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: i5.TranslateService, decorators: [{
                    type: Inject,
                    args: [TranslateService]
                }] }]; } });

class PrgQueriesModule {
    constructor(injector) {
        this.injector = injector;
        appInjector$3 = this.injector;
    }
    static forRoot(prgQueriesConfig) {
        queriesConfig = prgQueriesConfig;
        return {
            ngModule: PrgQueriesModule,
            providers: [
                {
                    provide: PRG_QUERIES_CONFIG,
                    useValue: prgQueriesConfig,
                },
                {
                    provide: AbstractQueriesService,
                    useClass: prgQueriesConfig.useMockServices
                        ? MockQueriesService
                        : QueriesService,
                },
            ],
        };
    }
}
PrgQueriesModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgQueriesModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesModule, declarations: [PrgQueriesTableComponent,
        PrgQueryModalComponent,
        PrgQueriesPage,
        PrgQueryModalComponent], imports: [PrgQueriesRoutingModule,
        PrgSharedComponentsModule,
        PrgCoreDynamicFormModule] });
PrgQueriesModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesModule, providers: [DialogService], imports: [PrgQueriesRoutingModule,
        PrgSharedComponentsModule,
        PrgCoreDynamicFormModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        PrgQueriesTableComponent,
                        PrgQueryModalComponent,
                        PrgQueriesPage,
                        PrgQueryModalComponent,
                    ],
                    imports: [
                        PrgQueriesRoutingModule,
                        PrgSharedComponentsModule,
                        PrgCoreDynamicFormModule,
                    ],
                    exports: [],
                    providers: [DialogService],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
let appInjector$3;
/**
 * Exports the QueriesCoreConfig object
 */
let queriesConfig;

/**
 * Role class that defines the basic properties
 * <br />of an Role.
 */
class Role extends BaseEntity {
}

/**
 * AbstractRolesScopesService class that defines an
 * <br />abstract roles and scopes service to
 * <br />be extended by the mock and real
 * <br />roles and scopes services
 */
class AbstractRolesScopesService {
    /**
     * constructor
     * @param translationService
     */
    constructor(translationService) {
        this.translationService = translationService;
    }
    /* this service get translations for all entity types,properties and attributes
     * @param {EntityType[] | EntityType} entities
     * @returns {Promise<EntityType[] | EntityType>}
     * @protected
     */
    async getTranslationsAsync(roles) {
        return new Promise((resolve, reject) => {
            if (Array.isArray(roles)) {
                //Translate Entities
                let rolesList = roles;
                rolesList.map(async (role) => {
                    role.label = await this.translationService
                        .get('roles.' + role.name.toLowerCase() + '.label')
                        .toPromise();
                });
                resolve(roles);
            }
        });
    }
}

/**
 * select role component
 */
class PrgSelectRoleComponent {
    /**
     * Constructor
     * @param rolesScopesService
     */
    constructor(rolesScopesService) {
        this.rolesScopesService = rolesScopesService;
        /**
         * allow multi select or not
         */
        this.multipleSelect = false;
        /**
         * field that should be used as an option
         */
        this.optionLabel = 'label';
        /**
         * show search bar or not
         */
        this.showHeader = true;
        /**
         * allow button to confirm selection or not
         */
        this.useButton = false;
        /**
         * Output with the selected roles
         */
        this.onSubmitRolesSelected = new EventEmitter();
        /**
         * Item selectable, if multiple is null else is 1
         */
        this.maxItemsSelectable = 1;
    }
    /**
     * default value selected to single selections
     */
    set defaultSelected(value) {
        if (value) {
            this.roleSelected = value;
        }
    }
    /**
     * ngOnInit
     *
     * set value to [rolesList]{@link #rolesList}
     *
     * call method [getAllRolesAsync]{@link /classes/AbstractRolesScopesService.html#getAllRolesAsync} from services
     */
    ngOnInit() {
        if (!this.rolesList) {
            this.getAllRoles();
        }
    }
    /**
     *this function get all roles
     */
    async getAllRoles() {
        this.rolesList = await this.rolesScopesService.getAllRolesAsync();
    }
    /**
     * This function fire [onSubmitRolesSelected]{@link #onSubmitRolesSelected} output
     */
    sendRolesSelected() {
        if (this.multipleSelect && this.rolesSelected.length > 0) {
            this.onSubmitRolesSelected.emit(this.rolesSelected);
        }
        else if (!this.multipleSelect && this.roleSelected) {
            this.onSubmitRolesSelected.emit(this.roleSelected);
        }
    }
}
PrgSelectRoleComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectRoleComponent, deps: [{ token: AbstractRolesScopesService }], target: i0.ɵɵFactoryTarget.Component });
PrgSelectRoleComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSelectRoleComponent, selector: "prg-select-role", inputs: { rolesList: "rolesList", multipleSelect: "multipleSelect", optionLabel: "optionLabel", showHeader: "showHeader", useButton: "useButton", defaultSelected: "defaultSelected" }, outputs: { onSubmitRolesSelected: "onSubmitRolesSelected" }, ngImport: i0, template: "<div>\r\n  <ng-container *ngIf=\"multipleSelect; else elseBlock\">\r\n    <p-multiSelect\r\n      [options]=\"rolesList\"\r\n      [(ngModel)]=\"rolesSelected\"\r\n      [optionLabel]=\"optionLabel\"\r\n      defaultLabel=\"{{\r\n        'components.roles-scopes.select-role.label' | translate\r\n      }}\"\r\n      [showHeader]=\"showHeader\"\r\n      (ngModelChange)=\"sendRolesSelected()\"\r\n      selectedItemsLabel=\"{{\r\n        'components.roles-scopes.select-role.roles-selected.label' | translate\r\n      }}\"\r\n      [maxSelectedLabels]=\"1\"\r\n    ></p-multiSelect>\r\n\r\n    <button\r\n      pButton\r\n      *ngIf=\"useButton\"\r\n      type=\"button\"\r\n      label=\"{{ 'buttons.select.label' | translate }}\"\r\n      (click)=\"sendRolesSelected()\"\r\n      [disabled]=\"!(rolesSelected.length > 0)\"\r\n    ></button>\r\n  </ng-container>\r\n  <ng-template #elseBlock>\r\n    <p-dropdown\r\n      [options]=\"rolesList\"\r\n      [(ngModel)]=\"roleSelected\"\r\n      [optionLabel]=\"optionLabel\"\r\n      placeholder=\"{{\r\n        'components.roles-scopes.select-role.label' | translate\r\n      }}\"\r\n      (ngModelChange)=\"sendRolesSelected()\"\r\n      [filter]=\"true\"\r\n      filterBy=\"name\"\r\n    ></p-dropdown>\r\n  </ng-template>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "directive", type: i1$2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i1$k.MultiSelect, selector: "p-multiSelect", inputs: ["style", "styleClass", "panelStyle", "panelStyleClass", "inputId", "disabled", "readonly", "group", "filter", "filterPlaceHolder", "filterLocale", "overlayVisible", "tabindex", "appendTo", "dataKey", "name", "label", "ariaLabelledBy", "displaySelectedLabel", "maxSelectedLabels", "selectionLimit", "selectedItemsLabel", "showToggleAll", "emptyFilterMessage", "emptyMessage", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "showHeader", "autoZIndex", "baseZIndex", "filterBy", "scrollHeight", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "filterMatchMode", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "display", "autocomplete", "showClear", "defaultLabel", "placeholder", "options", "filterValue", "itemSize"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onClear", "onPanelShow", "onPanelHide", "onLazyLoad"] }, { kind: "component", type: i1$5.Dropdown, selector: "p-dropdown", inputs: ["scrollHeight", "filter", "name", "style", "panelStyle", "styleClass", "panelStyleClass", "readonly", "required", "editable", "appendTo", "tabindex", "placeholder", "filterPlaceholder", "filterLocale", "inputId", "selectId", "dataKey", "filterBy", "autofocus", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "autoDisplayFirst", "group", "showClear", "emptyFilterMessage", "emptyMessage", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "autoZIndex", "baseZIndex", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "ariaLabel", "ariaLabelledBy", "filterMatchMode", "maxlength", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "disabled", "itemSize", "options", "filterValue"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onShow", "onHide", "onClear", "onLazyLoad"] }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectRoleComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-select-role', template: "<div>\r\n  <ng-container *ngIf=\"multipleSelect; else elseBlock\">\r\n    <p-multiSelect\r\n      [options]=\"rolesList\"\r\n      [(ngModel)]=\"rolesSelected\"\r\n      [optionLabel]=\"optionLabel\"\r\n      defaultLabel=\"{{\r\n        'components.roles-scopes.select-role.label' | translate\r\n      }}\"\r\n      [showHeader]=\"showHeader\"\r\n      (ngModelChange)=\"sendRolesSelected()\"\r\n      selectedItemsLabel=\"{{\r\n        'components.roles-scopes.select-role.roles-selected.label' | translate\r\n      }}\"\r\n      [maxSelectedLabels]=\"1\"\r\n    ></p-multiSelect>\r\n\r\n    <button\r\n      pButton\r\n      *ngIf=\"useButton\"\r\n      type=\"button\"\r\n      label=\"{{ 'buttons.select.label' | translate }}\"\r\n      (click)=\"sendRolesSelected()\"\r\n      [disabled]=\"!(rolesSelected.length > 0)\"\r\n    ></button>\r\n  </ng-container>\r\n  <ng-template #elseBlock>\r\n    <p-dropdown\r\n      [options]=\"rolesList\"\r\n      [(ngModel)]=\"roleSelected\"\r\n      [optionLabel]=\"optionLabel\"\r\n      placeholder=\"{{\r\n        'components.roles-scopes.select-role.label' | translate\r\n      }}\"\r\n      (ngModelChange)=\"sendRolesSelected()\"\r\n      [filter]=\"true\"\r\n      filterBy=\"name\"\r\n    ></p-dropdown>\r\n  </ng-template>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: AbstractRolesScopesService }]; }, propDecorators: { rolesList: [{
                type: Input
            }], multipleSelect: [{
                type: Input
            }], optionLabel: [{
                type: Input
            }], showHeader: [{
                type: Input
            }], useButton: [{
                type: Input
            }], defaultSelected: [{
                type: Input,
                args: ['defaultSelected']
            }], onSubmitRolesSelected: [{
                type: Output
            }] } });

/**
 * Modal create role
 */
class PrgModalCreateRoleComponent {
    /**
     * constructor
     *
     * @param modalCtrl
     */
    constructor(modalCtrl) {
        this.modalCtrl = modalCtrl;
        /**
         * list of roles to use as a basis for creating a new
         */
        this.rolesSelected = [];
    }
    /**
     * receive output onAction
     *
     * @param roles
     */
    onSubmitRolesSelected(roles) {
        this.rolesSelected = roles;
    }
    /**
     * cancel the creation of the new role
     * @returns
     */
    cancel() {
        return this.modalCtrl.dismiss(null, "cancel");
    }
    /**
     * create of the new role
     *
     * @returns
     */
    createRole() {
        return this.modalCtrl.dismiss(this.createNewRoleObject(), "confirm");
    }
    /**
     * Create new Role object
     *
     * @returns ROle
     */
    createNewRoleObject() {
        let newRole = new Role();
        newRole.name = this.newRoleName;
        let scopesAux = [];
        if (this.rolesSelected.length > 0) {
            this.rolesSelected.forEach((element) => {
                if (element.scopes) {
                    scopesAux = scopesAux.concat(element.scopes);
                }
            });
        }
        // remove repeats
        const setScopesAux = new Set(scopesAux);
        newRole.scopes = [...setScopesAux];
        return newRole;
    }
}
PrgModalCreateRoleComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgModalCreateRoleComponent, deps: [{ token: i1$q.ModalController }], target: i0.ɵɵFactoryTarget.Component });
PrgModalCreateRoleComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgModalCreateRoleComponent, selector: "prg-modal-create-role", ngImport: i0, template: "<div>\r\n  <input\r\n    type=\"text\"\r\n    placeholder=\"{{\r\n      'components.roles-scopes.create-role.placeholder' | translate\r\n    }}\"\r\n    [(ngModel)]=\"newRoleName\"\r\n    pInputText\r\n  />\r\n  <p>\r\n    {{ 'components.roles-scopes.create-role.based-roles.label' | translate }}\r\n  </p>\r\n  <prg-select-role\r\n    (onSubmitRolesSelected)=\"onSubmitRolesSelected($event)\"\r\n    [multipleSelect]=\"true\"\r\n  ></prg-select-role>\r\n\r\n  <div>\r\n    <button\r\n      pButton\r\n      type=\"button\"\r\n      label=\"{{ 'buttons.cancel.label' | translate }}\"\r\n      (click)=\"cancel()\"\r\n    ></button>\r\n    <button\r\n      pButton\r\n      type=\"button\"\r\n      label=\"{{ 'buttons.save.label' | translate }}\"\r\n      (click)=\"createRole()\"\r\n      [disabled]=\"!newRoleName\"\r\n    ></button>\r\n  </div>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "component", type: PrgSelectRoleComponent, selector: "prg-select-role", inputs: ["rolesList", "multipleSelect", "optionLabel", "showHeader", "useButton", "defaultSelected"], outputs: ["onSubmitRolesSelected"] }, { kind: "pipe", type: i5.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgModalCreateRoleComponent, decorators: [{
            type: Component,
            args: [{ selector: "prg-modal-create-role", template: "<div>\r\n  <input\r\n    type=\"text\"\r\n    placeholder=\"{{\r\n      'components.roles-scopes.create-role.placeholder' | translate\r\n    }}\"\r\n    [(ngModel)]=\"newRoleName\"\r\n    pInputText\r\n  />\r\n  <p>\r\n    {{ 'components.roles-scopes.create-role.based-roles.label' | translate }}\r\n  </p>\r\n  <prg-select-role\r\n    (onSubmitRolesSelected)=\"onSubmitRolesSelected($event)\"\r\n    [multipleSelect]=\"true\"\r\n  ></prg-select-role>\r\n\r\n  <div>\r\n    <button\r\n      pButton\r\n      type=\"button\"\r\n      label=\"{{ 'buttons.cancel.label' | translate }}\"\r\n      (click)=\"cancel()\"\r\n    ></button>\r\n    <button\r\n      pButton\r\n      type=\"button\"\r\n      label=\"{{ 'buttons.save.label' | translate }}\"\r\n      (click)=\"createRole()\"\r\n      [disabled]=\"!newRoleName\"\r\n    ></button>\r\n  </div>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1$q.ModalController }]; } });

/**
 * Create role component
 */
class PrgCreateRoleComponent {
    /**
     * constructor
     *
     * @param rolesScopesService
     */
    constructor(rolesScopesService, modalCtrl) {
        this.rolesScopesService = rolesScopesService;
        this.modalCtrl = modalCtrl;
        /**
         * Input placeholder
         */
        this.placeholder = "";
        /**
         * output if the newRole was added successfully
         */
        this.addedNewRole = new EventEmitter();
    }
    /**
     * Create role, this function call service method [createRoleAsync]{@link /classes/AbstractRolesScopesService.html#createRoleAsync}
     */
    createRole(role) {
        this.rolesScopesService.createRoleAsync(role).then((response) => {
            if (response) {
                this.newRoleName = "";
                this.addedNewRole.emit(response);
            }
            else {
                this.addedNewRole.emit(null);
            }
        });
    }
    /**
     * Function to open modal
     *
     * if click to save role call method [createRole]{@link #createRole}
     */
    async openModalCreateRole() {
        const modal = await this.modalCtrl.create({
            component: PrgModalCreateRoleComponent,
        });
        modal.present();
        const { data, role } = await modal.onWillDismiss();
        if (role === "confirm") {
            this.createRole(data);
        }
    }
}
PrgCreateRoleComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCreateRoleComponent, deps: [{ token: AbstractRolesScopesService }, { token: i1$q.ModalController }], target: i0.ɵɵFactoryTarget.Component });
PrgCreateRoleComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgCreateRoleComponent, selector: "prg-create-role", inputs: { placeholder: "placeholder", buttonLabel: "buttonLabel" }, outputs: { addedNewRole: "addedNewRole" }, ngImport: i0, template: "<div>\r\n  <button\r\n    pButton\r\n    type=\"button\"\r\n    [label]=\"buttonLabel\"\r\n    (click)=\"openModalCreateRole()\"\r\n  ></button>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCreateRoleComponent, decorators: [{
            type: Component,
            args: [{ selector: "prg-create-role", template: "<div>\r\n  <button\r\n    pButton\r\n    type=\"button\"\r\n    [label]=\"buttonLabel\"\r\n    (click)=\"openModalCreateRole()\"\r\n  ></button>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: AbstractRolesScopesService }, { type: i1$q.ModalController }]; }, propDecorators: { placeholder: [{
                type: Input
            }], buttonLabel: [{
                type: Input
            }], addedNewRole: [{
                type: Output
            }] } });

/**
 * Scopes table component
 * Tri checkbox legend:
 * true-> all selected
 * false-> partial selected
 * null-> non selected
 */
class PrgScopesTableComponent {
    /**
     * constructor
     * @param objectsUtilityService
     * @param arrayUtilityService
     * @param rolesScopesService
     * @param prgRolesScopesConfig  prgRolesScopesConfig
     */
    constructor(objectsUtilityService, arrayUtilityService, rolesScopesService, abstractEntityTypeService, prgRolesScopesConfig) {
        this.objectsUtilityService = objectsUtilityService;
        this.arrayUtilityService = arrayUtilityService;
        this.rolesScopesService = rolesScopesService;
        this.abstractEntityTypeService = abstractEntityTypeService;
        this.prgRolesScopesConfig = prgRolesScopesConfig;
        /**
         * has a role selected
         */
        this.haveRole = false;
        /**
         * table columns
         */
        this.tableColumns = [];
        /**
         * haveChangesToSave
         */
        this.haveChangesToSave = false;
        /**
         * base scopes
         */
        this.baseScopes = this.prgRolesScopesConfig.baseScopes;
    }
    /**
     * Role that we want to configure
     */
    set role(value) {
        if (value) {
            this.haveRole = true;
            this._role = this.objectsUtilityService.cloneObject(value);
            if (this._role.scopes) {
                this.mappingTheScopesOfARole(value.scopes);
            }
            else {
                this.treeData = this.createDataStructure();
            }
        }
    }
    /**
     * ngOnInit
     *
     * set value to
     * [treeData]{@link #treeData}
     * [entityTypes]{@link #entityTypes}
     * [tableColumns]{@link #tableColumns}
     *
     * call method [getAllEntityType]{@link /classes/AbstractRolesScopesService.html#getAllEntityType} from services
     */
    ngOnInit() {
        // TODO: acho que fizemos um erro de spec, ou seja, estamos a usar as entitytypes para criar a estrutura
        //    quando deveriamos usar apenas as scopes ou pelo menos devemos poder acrescentar scopes sem entity type, a falar...
        this.abstractEntityTypeService
            .getEntityTypeListWithOperationAsync()
            .then((response) => {
            this.entityTypes = response;
            // this.treeData = this.createDataStructure();
        });
        this.tableColumns = this.tableColumns.concat(this.baseScopes);
        this.tableColumns.unshift('name');
        this.tableColumns.push(this.prgRolesS