import { Inject, Injectable } from '@angular/core';
import { PRG_TERMS_CONFIG } from '../prg-terms-configuration/prg-terms-configuration.service';
import * as i0 from "@angular/core";
import * as i1 from "@ngx-translate/core";
/**
 * Injectable
 */
/**
 * TermsService class is responsible to perform tasks and manage data related to the terms component
 */
export class TermsService {
    /**
     * constructor
     * @param {TranslateService} translateService
     * @param {PrgTermsConfig} termsConfig
     */
    constructor(translateService, termsConfig) {
        this.translateService = translateService;
        this.termsConfig = termsConfig;
    }
    /**
     * Method to get terms and sections base on a key and sort them according to predefined configuration
     * @param {string} baseTermsTranslationKey
     * @returns {Terms[]}
     */
    getTermsSections(baseTermsTranslationKey) {
        if (baseTermsTranslationKey == null ||
            baseTermsTranslationKey.length === 0) {
            baseTermsTranslationKey = this.termsConfig.baseTermsTranslationKey;
        }
        const sectionsTerms = this.translateService.instant(baseTermsTranslationKey);
        const sectionsTermsArray = [];
        if (sectionsTerms == null || sectionsTerms.sections == null) {
            return sectionsTermsArray;
        }
        Object.keys(sectionsTerms.sections).forEach(function (key) {
            sectionsTermsArray.push(sectionsTerms.sections[key]);
        });
        sectionsTermsArray.sort((a, b) => {
            return b.order < a.order ? 1 : -1;
        });
        return sectionsTermsArray;
    }
}
TermsService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: TermsService, deps: [{ token: i1.TranslateService }, { token: PRG_TERMS_CONFIG }], target: i0.ɵɵFactoryTarget.Injectable });
TermsService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: TermsService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: TermsService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: i1.TranslateService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_TERMS_CONFIG]
                }] }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVybXMuc2VydmljZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL1ByZ0ZyYW1ld29yay5GRS5Db3JlTGliL3NyYy9saWIvbW9kdWxlcy90ZXJtcy9zZXJ2aWNlcy90ZXJtcy90ZXJtcy5zZXJ2aWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxNQUFNLEVBQUUsVUFBVSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBSW5ELE9BQU8sRUFBRSxnQkFBZ0IsRUFBRSxNQUFNLDREQUE0RCxDQUFDOzs7QUFFOUY7O0dBRUc7QUFJSDs7R0FFRztBQUNILE1BQU0sT0FBTyxZQUFZO0lBQ3ZCOzs7O09BSUc7SUFDSCxZQUNVLGdCQUFrQyxFQUVsQyxXQUEyQjtRQUYzQixxQkFBZ0IsR0FBaEIsZ0JBQWdCLENBQWtCO1FBRWxDLGdCQUFXLEdBQVgsV0FBVyxDQUFnQjtJQUNsQyxDQUFDO0lBRUo7Ozs7T0FJRztJQUNJLGdCQUFnQixDQUFDLHVCQUErQjtRQUNyRCxJQUNFLHVCQUF1QixJQUFJLElBQUk7WUFDL0IsdUJBQXVCLENBQUMsTUFBTSxLQUFLLENBQUMsRUFDcEM7WUFDQSx1QkFBdUIsR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDLHVCQUF1QixDQUFDO1NBQ3BFO1FBRUQsTUFBTSxhQUFhLEdBQUcsSUFBSSxDQUFDLGdCQUFnQixDQUFDLE9BQU8sQ0FDakQsdUJBQXVCLENBQ3hCLENBQUM7UUFDRixNQUFNLGtCQUFrQixHQUFHLEVBQUUsQ0FBQztRQUU5QixJQUFJLGFBQWEsSUFBSSxJQUFJLElBQUksYUFBYSxDQUFDLFFBQVEsSUFBSSxJQUFJLEVBQUU7WUFDM0QsT0FBTyxrQkFBa0IsQ0FBQztTQUMzQjtRQUVELE1BQU0sQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFFBQVEsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxVQUFVLEdBQUc7WUFDdkQsa0JBQWtCLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQztRQUN2RCxDQUFDLENBQUMsQ0FBQztRQUVILGtCQUFrQixDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRTtZQUMvQixPQUFPLENBQUMsQ0FBQyxLQUFLLEdBQUcsQ0FBQyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNwQyxDQUFDLENBQUMsQ0FBQztRQUVILE9BQU8sa0JBQWtCLENBQUM7SUFDNUIsQ0FBQzs7eUdBM0NVLFlBQVksa0RBUWIsZ0JBQWdCOzZHQVJmLFlBQVksY0FMWCxNQUFNOzJGQUtQLFlBQVk7a0JBTnhCLFVBQVU7bUJBQUM7b0JBQ1YsVUFBVSxFQUFFLE1BQU07aUJBQ25COzswQkFZSSxNQUFNOzJCQUFDLGdCQUFnQiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEluamVjdCwgSW5qZWN0YWJsZSB9IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5pbXBvcnQgeyBUcmFuc2xhdGVTZXJ2aWNlIH0gZnJvbSAnQG5neC10cmFuc2xhdGUvY29yZSc7XHJcbmltcG9ydCB7IFByZ1Rlcm1zQ29uZmlnIH0gZnJvbSAnLi4vLi4vbW9kZWxzL3ByZy10ZXJtcy1jb25maWcnO1xyXG5pbXBvcnQgeyBUZXJtcyB9IGZyb20gJy4uLy4uL21vZGVscy90ZXJtcy5tb2RlbCc7XHJcbmltcG9ydCB7IFBSR19URVJNU19DT05GSUcgfSBmcm9tICcuLi9wcmctdGVybXMtY29uZmlndXJhdGlvbi9wcmctdGVybXMtY29uZmlndXJhdGlvbi5zZXJ2aWNlJztcclxuXHJcbi8qKlxyXG4gKiBJbmplY3RhYmxlXHJcbiAqL1xyXG5ASW5qZWN0YWJsZSh7XHJcbiAgcHJvdmlkZWRJbjogJ3Jvb3QnLFxyXG59KVxyXG4vKipcclxuICogVGVybXNTZXJ2aWNlIGNsYXNzIGlzIHJlc3BvbnNpYmxlIHRvIHBlcmZvcm0gdGFza3MgYW5kIG1hbmFnZSBkYXRhIHJlbGF0ZWQgdG8gdGhlIHRlcm1zIGNvbXBvbmVudFxyXG4gKi9cclxuZXhwb3J0IGNsYXNzIFRlcm1zU2VydmljZSB7XHJcbiAgLyoqXHJcbiAgICogY29uc3RydWN0b3JcclxuICAgKiBAcGFyYW0ge1RyYW5zbGF0ZVNlcnZpY2V9IHRyYW5zbGF0ZVNlcnZpY2VcclxuICAgKiBAcGFyYW0ge1ByZ1Rlcm1zQ29uZmlnfSB0ZXJtc0NvbmZpZ1xyXG4gICAqL1xyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgcHJpdmF0ZSB0cmFuc2xhdGVTZXJ2aWNlOiBUcmFuc2xhdGVTZXJ2aWNlLFxyXG4gICAgQEluamVjdChQUkdfVEVSTVNfQ09ORklHKVxyXG4gICAgcHJpdmF0ZSB0ZXJtc0NvbmZpZzogUHJnVGVybXNDb25maWdcclxuICApIHt9XHJcblxyXG4gIC8qKlxyXG4gICAqIE1ldGhvZCB0byBnZXQgdGVybXMgYW5kIHNlY3Rpb25zIGJhc2Ugb24gYSBrZXkgYW5kIHNvcnQgdGhlbSBhY2NvcmRpbmcgdG8gcHJlZGVmaW5lZCBjb25maWd1cmF0aW9uXHJcbiAgICogQHBhcmFtIHtzdHJpbmd9IGJhc2VUZXJtc1RyYW5zbGF0aW9uS2V5XHJcbiAgICogQHJldHVybnMge1Rlcm1zW119XHJcbiAgICovXHJcbiAgcHVibGljIGdldFRlcm1zU2VjdGlvbnMoYmFzZVRlcm1zVHJhbnNsYXRpb25LZXk6IHN0cmluZyk6IFRlcm1zW10ge1xyXG4gICAgaWYgKFxyXG4gICAgICBiYXNlVGVybXNUcmFuc2xhdGlvbktleSA9PSBudWxsIHx8XHJcbiAgICAgIGJhc2VUZXJtc1RyYW5zbGF0aW9uS2V5Lmxlbmd0aCA9PT0gMFxyXG4gICAgKSB7XHJcbiAgICAgIGJhc2VUZXJtc1RyYW5zbGF0aW9uS2V5ID0gdGhpcy50ZXJtc0NvbmZpZy5iYXNlVGVybXNUcmFuc2xhdGlvbktleTtcclxuICAgIH1cclxuXHJcbiAgICBjb25zdCBzZWN0aW9uc1Rlcm1zID0gdGhpcy50cmFuc2xhdGVTZXJ2aWNlLmluc3RhbnQoXHJcbiAgICAgIGJhc2VUZXJtc1RyYW5zbGF0aW9uS2V5XHJcbiAgICApO1xyXG4gICAgY29uc3Qgc2VjdGlvbnNUZXJtc0FycmF5ID0gW107XHJcblxyXG4gICAgaWYgKHNlY3Rpb25zVGVybXMgPT0gbnVsbCB8fCBzZWN0aW9uc1Rlcm1zLnNlY3Rpb25zID09IG51bGwpIHtcclxuICAgICAgcmV0dXJuIHNlY3Rpb25zVGVybXNBcnJheTtcclxuICAgIH1cclxuXHJcbiAgICBPYmplY3Qua2V5cyhzZWN0aW9uc1Rlcm1zLnNlY3Rpb25zKS5mb3JFYWNoKGZ1bmN0aW9uIChrZXkpIHtcclxuICAgICAgc2VjdGlvbnNUZXJtc0FycmF5LnB1c2goc2VjdGlvbnNUZXJtcy5zZWN0aW9uc1trZXldKTtcclxuICAgIH0pO1xyXG5cclxuICAgIHNlY3Rpb25zVGVybXNBcnJheS5zb3J0KChhLCBiKSA9PiB7XHJcbiAgICAgIHJldHVybiBiLm9yZGVyIDwgYS5vcmRlciA/IDEgOiAtMTtcclxuICAgIH0pO1xyXG5cclxuICAgIHJldHVybiBzZWN0aW9uc1Rlcm1zQXJyYXk7XHJcbiAgfVxyXG59XHJcbiJdfQ==