import { NgModule } from '@angular/core';
import { PrgCoreDynamicFormModule } from '../core/components/dynamic-form/prg-core-dynamic-form.module';
import { PrgSharedComponentsModule } from '../shared-components/shared-components.module';
import { PrgTermsComponent } from './components/prg-terms.component';
import { PrgTermsRoutingModule } from './prg-terms-routing.module';
import { PRG_TERMS_CONFIG } from './services/prg-terms-configuration/prg-terms-configuration.service';
import * as i0 from "@angular/core";
/**
 * Module that handles terms of use
 */
export class PrgTermsModule {
    constructor(injector) {
        this.injector = injector;
        appInjector = this.injector;
    }
    static forRoot(prgTermsConfig) {
        termsConfig = prgTermsConfig;
        return {
            ngModule: PrgTermsModule,
            providers: [
                {
                    provide: PRG_TERMS_CONFIG,
                    useValue: prgTermsConfig,
                },
            ],
        };
    }
}
PrgTermsModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTermsModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgTermsModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgTermsModule, declarations: [PrgTermsComponent], imports: [PrgSharedComponentsModule,
        PrgTermsRoutingModule,
        PrgCoreDynamicFormModule], exports: [PrgTermsComponent] });
PrgTermsModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTermsModule, imports: [PrgSharedComponentsModule,
        PrgTermsRoutingModule,
        PrgCoreDynamicFormModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTermsModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [PrgTermsComponent],
                    imports: [
                        PrgSharedComponentsModule,
                        PrgTermsRoutingModule,
                        PrgCoreDynamicFormModule,
                    ],
                    exports: [PrgTermsComponent],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
export let appInjector;
/**
 * Exports the TermsCoreConfig object, use ONLY in routing module
 * for everything else, use dependency injection through the injector
 */
export let termsConfig;
//# sourceMappingURL=data:application/json;base64,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