import { Component, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../services/terms/terms.service";
import * as i2 from "@angular/common";
import * as i3 from "primeng/image";
import * as i4 from "primeng/accordion";
/**
 * Terms Component
 */
export class PrgTermsComponent {
    /**
     * constructor
     * @param {TermsService} termsService
     */
    constructor(termsService) {
        this.termsService = termsService;
        /**
         * Terms and Condition list
         */
        this.terms = [];
        /**
         * Terms & Conditions title. Default is Terms & Conditions
         */
        this.termsTitle = 'Terms & Conditions';
        /**
         * Terms & Conditions image.
         */
        this.termsImage = 'assets/images/Terms-and-Conditions-1.png';
    }
    /**
     * ngOnInit
     *
     * Fetch terms & conditions
     */
    async ngOnInit() {
        this.terms = this.termsService.getTermsSections('');
    }
}
PrgTermsComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTermsComponent, deps: [{ token: i1.TermsService }], target: i0.ɵɵFactoryTarget.Component });
PrgTermsComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgTermsComponent, selector: "prg-terms", inputs: { termsTitle: "termsTitle", termsImage: "termsImage" }, ngImport: i0, template: "<div class=\"border-1 border-300 shadow-4 text-center\">\r\n  <p-image  [src]=\"termsImage\"  alt=\"\" ></p-image>\r\n  <!-- <h1 [innerText]=\"termsTitle|uppercase\"></h1>-->\r\n  <p-accordion  [multiple]=\"true\" >\r\n    <div *ngFor=\"let item of terms\">\r\n      <p-accordionTab  header=\"{{item.header}}\" style=\"width: 100%\">\r\n        <p [innerHTML]=\"item.content\"></p>\r\n      </p-accordionTab>\r\n    </div>\r\n  </p-accordion>\r\n</div>\r\n", styles: [".grid-layout{height:calc(100vh - 70px);width:100%}\n"], dependencies: [{ kind: "directive", type: i2.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "component", type: i3.Image, selector: "p-image", inputs: ["imageClass", "imageStyle", "styleClass", "style", "src", "alt", "width", "height", "appendTo", "preview", "showTransitionOptions", "hideTransitionOptions"], outputs: ["onShow", "onHide", "onImageError"] }, { kind: "component", type: i4.Accordion, selector: "p-accordion", inputs: ["multiple", "style", "styleClass", "expandIcon", "collapseIcon", "activeIndex"], outputs: ["onClose", "onOpen", "activeIndexChange"] }, { kind: "component", type: i4.AccordionTab, selector: "p-accordionTab", inputs: ["header", "disabled", "cache", "transitionOptions", "selected"], outputs: ["selectedChange"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgTermsComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-terms', template: "<div class=\"border-1 border-300 shadow-4 text-center\">\r\n  <p-image  [src]=\"termsImage\"  alt=\"\" ></p-image>\r\n  <!-- <h1 [innerText]=\"termsTitle|uppercase\"></h1>-->\r\n  <p-accordion  [multiple]=\"true\" >\r\n    <div *ngFor=\"let item of terms\">\r\n      <p-accordionTab  header=\"{{item.header}}\" style=\"width: 100%\">\r\n        <p [innerHTML]=\"item.content\"></p>\r\n      </p-accordionTab>\r\n    </div>\r\n  </p-accordion>\r\n</div>\r\n", styles: [".grid-layout{height:calc(100vh - 70px);width:100%}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.TermsService }]; }, propDecorators: { termsTitle: [{
                type: Input
            }], termsImage: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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