/**
 * AbstractRolesScopesService class that defines an
 * <br />abstract roles and scopes service to
 * <br />be extended by the mock and real
 * <br />roles and scopes services
 */
export class AbstractRolesScopesService {
    /**
     * constructor
     * @param translationService
     */
    constructor(translationService) {
        this.translationService = translationService;
    }
    /* this service get translations for all entity types,properties and attributes
     * @param {EntityType[] | EntityType} entities
     * @returns {Promise<EntityType[] | EntityType>}
     * @protected
     */
    async getTranslationsAsync(roles) {
        return new Promise((resolve, reject) => {
            if (Array.isArray(roles)) {
                //Translate Entities
                let rolesList = roles;
                rolesList.map(async (role) => {
                    role.label = await this.translationService
                        .get('roles.' + role.name.toLowerCase() + '.label')
                        .toPromise();
                });
                resolve(roles);
            }
        });
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWJzdHJhY3Qtcm9sZXMtc2NvcGVzLnNlcnZpY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9QcmdGcmFtZXdvcmsuRkUuQ29yZUxpYi9zcmMvbGliL21vZHVsZXMvcm9sZXMtc2NvcGVzL3NlcnZpY2VzL3JvbGVzLXNjb3Blcy9hYnN0cmFjdC1yb2xlcy1zY29wZXMuc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFHQTs7Ozs7R0FLRztBQUNILE1BQU0sT0FBZ0IsMEJBQTBCO0lBQzlDOzs7T0FHRztJQUVILFlBQW9CLGtCQUFvQztRQUFwQyx1QkFBa0IsR0FBbEIsa0JBQWtCLENBQWtCO0lBQUcsQ0FBQztJQXdCNUQ7Ozs7T0FJRztJQUNPLEtBQUssQ0FBQyxvQkFBb0IsQ0FDbEMsS0FBb0I7UUFFcEIsT0FBTyxJQUFJLE9BQU8sQ0FBZ0IsQ0FBQyxPQUFPLEVBQUUsTUFBTSxFQUFFLEVBQUU7WUFDcEQsSUFBSSxLQUFLLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxFQUFFO2dCQUN4QixvQkFBb0I7Z0JBQ3BCLElBQUksU0FBUyxHQUFXLEtBQUssQ0FBQztnQkFDOUIsU0FBUyxDQUFDLEdBQUcsQ0FBQyxLQUFLLEVBQUUsSUFBVSxFQUFFLEVBQUU7b0JBQ2pDLElBQUksQ0FBQyxLQUFLLEdBQUcsTUFBTSxJQUFJLENBQUMsa0JBQWtCO3lCQUN2QyxHQUFHLENBQUMsUUFBUSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsV0FBVyxFQUFFLEdBQUcsUUFBUSxDQUFDO3lCQUNsRCxTQUFTLEVBQUUsQ0FBQztnQkFDakIsQ0FBQyxDQUFDLENBQUM7Z0JBQ0gsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO2FBQ2hCO1FBQ0gsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBUcmFuc2xhdGVTZXJ2aWNlIH0gZnJvbSAnQG5neC10cmFuc2xhdGUvY29yZSc7XHJcbmltcG9ydCB7IFJvbGUgfSBmcm9tICcuLi8uLi9tb2RlbHMvcm9sZS5tb2RlbCc7XHJcblxyXG4vKipcclxuICogQWJzdHJhY3RSb2xlc1Njb3Blc1NlcnZpY2UgY2xhc3MgdGhhdCBkZWZpbmVzIGFuXHJcbiAqIDxiciAvPmFic3RyYWN0IHJvbGVzIGFuZCBzY29wZXMgc2VydmljZSB0b1xyXG4gKiA8YnIgLz5iZSBleHRlbmRlZCBieSB0aGUgbW9jayBhbmQgcmVhbFxyXG4gKiA8YnIgLz5yb2xlcyBhbmQgc2NvcGVzIHNlcnZpY2VzXHJcbiAqL1xyXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQWJzdHJhY3RSb2xlc1Njb3Blc1NlcnZpY2Uge1xyXG4gIC8qKlxyXG4gICAqIGNvbnN0cnVjdG9yXHJcbiAgICogQHBhcmFtIHRyYW5zbGF0aW9uU2VydmljZVxyXG4gICAqL1xyXG5cclxuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHRyYW5zbGF0aW9uU2VydmljZTogVHJhbnNsYXRlU2VydmljZSkge31cclxuICAvKipcclxuICAgKiBHZXQgYWxsIFJvbGVzXHJcbiAgICovXHJcbiAgcHVibGljIGFic3RyYWN0IGdldEFsbFJvbGVzQXN5bmMoKTogUHJvbWlzZTxSb2xlW10+O1xyXG5cclxuICAvKipcclxuICAgKiBDcmVhdGUgUm9sZSBBc3luY1xyXG4gICAqXHJcbiAgICogQHBhcmFtIHtzdHJpbmd9IHJvbGVOYW1lICBUaGUgbmV3IFJvbGUgbmFtZVxyXG4gICAqXHJcbiAgICogQFJldHVybnMgYm9vbGVhblxyXG4gICAqL1xyXG4gIHB1YmxpYyBhYnN0cmFjdCBjcmVhdGVSb2xlQXN5bmMocm9sZTogUm9sZSk6IFByb21pc2U8Um9sZT47XHJcblxyXG4gIC8qKlxyXG4gICAqIFVwZGF0ZSBTY29wZVxyXG4gICAqXHJcbiAgICogQHBhcmFtIHJvbGVcclxuICAgKlxyXG4gICAqIEBSZXR1cm5zIGJvb2xlYW5cclxuICAgKi9cclxuICBwdWJsaWMgYWJzdHJhY3QgdXBkYXRlUm9sZShyb2xlOiBSb2xlKTogUHJvbWlzZTxSb2xlPjtcclxuXHJcbiAgLyogdGhpcyBzZXJ2aWNlIGdldCB0cmFuc2xhdGlvbnMgZm9yIGFsbCBlbnRpdHkgdHlwZXMscHJvcGVydGllcyBhbmQgYXR0cmlidXRlc1xyXG4gICAqIEBwYXJhbSB7RW50aXR5VHlwZVtdIHwgRW50aXR5VHlwZX0gZW50aXRpZXNcclxuICAgKiBAcmV0dXJucyB7UHJvbWlzZTxFbnRpdHlUeXBlW10gfCBFbnRpdHlUeXBlPn1cclxuICAgKiBAcHJvdGVjdGVkXHJcbiAgICovXHJcbiAgcHJvdGVjdGVkIGFzeW5jIGdldFRyYW5zbGF0aW9uc0FzeW5jKFxyXG4gICAgcm9sZXM6IFJvbGVbXSB8IFJvbGVcclxuICApOiBQcm9taXNlPFJvbGVbXSB8IFJvbGU+IHtcclxuICAgIHJldHVybiBuZXcgUHJvbWlzZTxSb2xlW10gfCBSb2xlPigocmVzb2x2ZSwgcmVqZWN0KSA9PiB7XHJcbiAgICAgIGlmIChBcnJheS5pc0FycmF5KHJvbGVzKSkge1xyXG4gICAgICAgIC8vVHJhbnNsYXRlIEVudGl0aWVzXHJcbiAgICAgICAgbGV0IHJvbGVzTGlzdCA9IDxSb2xlW10+cm9sZXM7XHJcbiAgICAgICAgcm9sZXNMaXN0Lm1hcChhc3luYyAocm9sZTogUm9sZSkgPT4ge1xyXG4gICAgICAgICAgcm9sZS5sYWJlbCA9IGF3YWl0IHRoaXMudHJhbnNsYXRpb25TZXJ2aWNlXHJcbiAgICAgICAgICAgIC5nZXQoJ3JvbGVzLicgKyByb2xlLm5hbWUudG9Mb3dlckNhc2UoKSArICcubGFiZWwnKVxyXG4gICAgICAgICAgICAudG9Qcm9taXNlKCk7XHJcbiAgICAgICAgfSk7XHJcbiAgICAgICAgcmVzb2x2ZShyb2xlcyk7XHJcbiAgICAgIH1cclxuICAgIH0pO1xyXG4gIH1cclxufVxyXG4iXX0=