import { NgModule } from '@angular/core';
import { PrgSharedComponentsModule } from '../shared-components/shared-components.module';
import { PrgCreateRoleComponent } from './components/role-create/prg-create-role.component';
import { PrgModalCreateRoleComponent } from './components/role-create/prg-modal-create-role/prg-modal-create-role.component';
import { PrgSelectRoleComponent } from './components/roles-select/prg-select-role.component';
import { PrgScopesTableComponent } from './components/scopes-table/prg-scopes-table.component';
import { MockRolesScopesService } from './mock/services/roles-scopes/roles-scopes.service.mock';
import { PrgRolesScopesPage } from './pages/roles-scopes/prg-roles-scopes.page';
import { PrgRolesScopesRoutingModule } from './prg-roles-scopes-routing.module';
import { PRG_ROLES_SCOPES_CONFIG } from './services/roles-scopes-configuration/prg-roles-scopes-configuration.service';
import { AbstractRolesScopesService } from './services/roles-scopes/abstract-roles-scopes.service';
import { RolesScopesService } from './services/roles-scopes/roles-scopes.service';
import * as i0 from "@angular/core";
export class PrgRolesScopesModule {
    constructor(injector) {
        this.injector = injector;
        appInjector = this.injector;
    }
    static forRoot(prgRolesScopesConfig) {
        rolesScopesConfig = prgRolesScopesConfig;
        return {
            ngModule: PrgRolesScopesModule,
            providers: [
                {
                    provide: PRG_ROLES_SCOPES_CONFIG,
                    useValue: prgRolesScopesConfig,
                },
                {
                    provide: AbstractRolesScopesService,
                    useClass: prgRolesScopesConfig.useMockServices
                        ? MockRolesScopesService
                        : RolesScopesService,
                },
            ],
        };
    }
}
PrgRolesScopesModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRolesScopesModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgRolesScopesModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgRolesScopesModule, declarations: [PrgRolesScopesPage,
        PrgSelectRoleComponent,
        PrgCreateRoleComponent,
        PrgScopesTableComponent,
        PrgModalCreateRoleComponent], imports: [PrgRolesScopesRoutingModule, PrgSharedComponentsModule], exports: [PrgSelectRoleComponent,
        PrgCreateRoleComponent,
        PrgScopesTableComponent] });
PrgRolesScopesModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRolesScopesModule, imports: [PrgRolesScopesRoutingModule, PrgSharedComponentsModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRolesScopesModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        PrgRolesScopesPage,
                        PrgSelectRoleComponent,
                        PrgCreateRoleComponent,
                        PrgScopesTableComponent,
                        PrgModalCreateRoleComponent,
                    ],
                    imports: [PrgRolesScopesRoutingModule, PrgSharedComponentsModule],
                    exports: [
                        PrgSelectRoleComponent,
                        PrgCreateRoleComponent,
                        PrgScopesTableComponent,
                    ],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
export let appInjector;
/**
 * Exports the AuthCoreConfig object
 */
export let rolesScopesConfig;
//# sourceMappingURL=data:application/json;base64,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