import { Component } from "@angular/core";
import * as i0 from "@angular/core";
import * as i1 from "../../services/roles-scopes/abstract-roles-scopes.service";
import * as i2 from "primeng/toolbar";
import * as i3 from "../../components/roles-select/prg-select-role.component";
import * as i4 from "../../components/role-create/prg-create-role.component";
import * as i5 from "../../components/scopes-table/prg-scopes-table.component";
import * as i6 from "@ngx-translate/core";
/**
 * Roles and Scopes page component
 */
export class PrgRolesScopesPage {
    /**
     * constructor
     */
    constructor(rolesScopesService) {
        this.rolesScopesService = rolesScopesService;
    }
    /**
     * receive output onAction
     *
     * @param roles
     */
    onSubmitRolesSelected(role) {
        this.roleSelected = JSON.parse(JSON.stringify(role));
    }
    /**
     * Receives output when a new role is added
     *
     * @param added
     */
    addedNewRole(added) {
        this.roleSelected = added;
        this.getAllRoles();
    }
    /**
     *this function get all roles
     */
    async getAllRoles() {
        this.rolesList = await this.rolesScopesService.getAllRolesAsync();
    }
}
PrgRolesScopesPage.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRolesScopesPage, deps: [{ token: i1.AbstractRolesScopesService }], target: i0.ɵɵFactoryTarget.Component });
PrgRolesScopesPage.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgRolesScopesPage, selector: "app-prg-roles-scopes", ngImport: i0, template: "<div>\r\n  <p-toolbar>\r\n    <div class=\"p-toolbar-group-left\">\r\n      <prg-select-role\r\n        (onSubmitRolesSelected)=\"onSubmitRolesSelected($event)\"\r\n        [multipleSelect]=\"false\"\r\n        [defaultSelected]=\"roleSelected\"\r\n        [rolesList]=\"rolesList\"\r\n      ></prg-select-role>\r\n    </div>\r\n    <div class=\"p-toolbar-group-right\">\r\n      <prg-create-role\r\n        (addedNewRole)=\"addedNewRole($event)\"\r\n        placeholder=\"Insert Role name\"\r\n        buttonLabel=\"{{'buttons.add.label' | translate}}\"\r\n      ></prg-create-role>\r\n    </div>\r\n  </p-toolbar>\r\n  <prg-scopes-table [role]=\"roleSelected\"></prg-scopes-table>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "component", type: i2.Toolbar, selector: "p-toolbar", inputs: ["style", "styleClass"] }, { kind: "component", type: i3.PrgSelectRoleComponent, selector: "prg-select-role", inputs: ["rolesList", "multipleSelect", "optionLabel", "showHeader", "useButton", "defaultSelected"], outputs: ["onSubmitRolesSelected"] }, { kind: "component", type: i4.PrgCreateRoleComponent, selector: "prg-create-role", inputs: ["placeholder", "buttonLabel"], outputs: ["addedNewRole"] }, { kind: "component", type: i5.PrgScopesTableComponent, selector: "prg-scopes-table", inputs: ["role"] }, { kind: "pipe", type: i6.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgRolesScopesPage, decorators: [{
            type: Component,
            args: [{ selector: "app-prg-roles-scopes", template: "<div>\r\n  <p-toolbar>\r\n    <div class=\"p-toolbar-group-left\">\r\n      <prg-select-role\r\n        (onSubmitRolesSelected)=\"onSubmitRolesSelected($event)\"\r\n        [multipleSelect]=\"false\"\r\n        [defaultSelected]=\"roleSelected\"\r\n        [rolesList]=\"rolesList\"\r\n      ></prg-select-role>\r\n    </div>\r\n    <div class=\"p-toolbar-group-right\">\r\n      <prg-create-role\r\n        (addedNewRole)=\"addedNewRole($event)\"\r\n        placeholder=\"Insert Role name\"\r\n        buttonLabel=\"{{'buttons.add.label' | translate}}\"\r\n      ></prg-create-role>\r\n    </div>\r\n  </p-toolbar>\r\n  <prg-scopes-table [role]=\"roleSelected\"></prg-scopes-table>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.AbstractRolesScopesService }]; } });
//# sourceMappingURL=data:application/json;base64,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