import { Inject, Injectable } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { PrgError } from '../../../../core/models/error.model';
import { PrgSucess } from '../../../../core/models/success.model';
import { AbstractRolesScopesService } from '../../../services/roles-scopes/abstract-roles-scopes.service';
import { RolesScopesBDMOCk } from '../../rolesScopesDB.mock';
import * as i0 from "@angular/core";
import * as i1 from "../../../../core/services/notifications/notifications.service";
import * as i2 from "../../../../core/services/utility/utility.service";
import * as i3 from "../../../../core/services/is-loading-data/isloadingdata.service";
import * as i4 from "@ngx-translate/core";
/**
 * Injectable
 */
/**
 * MOCK MockRolesScopesService implementation
 */
export class MockRolesScopesService extends AbstractRolesScopesService {
    /**
     * constructor
     */
    constructor(notificationsService, utilityService, isLoadingDataService, translateService) {
        super(translateService);
        this.notificationsService = notificationsService;
        this.utilityService = utilityService;
        this.isLoadingDataService = isLoadingDataService;
        /**
         * default time in seconds
         */
        this.sleepTimeSec = 4;
    }
    /**
     * Get all Roles Async
     *
     * @returns Roles array promisse
     */
    getAllRolesAsync() {
        return new Promise(async (resolve, reject) => {
            this.isLoadingDataService.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            this.isLoadingDataService.hide();
            const roles = [...RolesScopesBDMOCk.Roles];
            if (roles.length > 0) {
                const rolesTranslation = await this.getTranslationsAsync(roles);
                resolve(rolesTranslation);
            }
            else {
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'error',
                    detailKey: 'errorGetScopesList',
                }));
            }
        });
    }
    /**
     * create role Async
     *
     * @param roleName
     * @returns Boolean promise, true when successful
     */
    async createRoleAsync(role) {
        this.isLoadingDataService.show();
        await this.utilityService.sleepSecAsync(this.sleepTimeSec);
        this.isLoadingDataService.hide();
        const newRole = {
            id: this.utilityService.newGuid(),
            universalStateId: '0',
            transactionId: null,
            operationId: null,
            name: role.name,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            scopes: role.scopes,
            label: null,
        };
        return new Promise((resolve) => {
            if (RolesScopesBDMOCk.Roles.push(newRole)) {
                resolve(newRole);
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'success',
                    detailKey: 'roleSuccessAdded',
                }));
            }
            else {
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'error',
                    detailKey: 'errorOnAddRole',
                }));
            }
        });
    }
    /**
     * update role
     *
     * @param role role with new data
     * @returns booler promise, true when successful
     */
    updateRole(role) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingDataService.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            this.isLoadingDataService.hide();
            const roles = [...RolesScopesBDMOCk.Roles];
            const roleToUpdate = roles.find((r) => r.id === role.id);
            if (roleToUpdate) {
                roleToUpdate.scopes = role.scopes;
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'success',
                    detailKey: 'roleSuccessUpdate',
                }));
                resolve(roleToUpdate);
            }
            else {
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'error',
                    detailKey: 'errorUpdateRole',
                }));
            }
        });
    }
}
MockRolesScopesService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockRolesScopesService, deps: [{ token: i1.NotificationsService }, { token: i2.UtilityService }, { token: i3.IsLoadingDataService }, { token: TranslateService }], target: i0.ɵɵFactoryTarget.Injectable });
MockRolesScopesService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockRolesScopesService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockRolesScopesService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: i1.NotificationsService }, { type: i2.UtilityService }, { type: i3.IsLoadingDataService }, { type: i4.TranslateService, decorators: [{
                    type: Inject,
                    args: [TranslateService]
                }] }]; } });
//# sourceMappingURL=data:application/json;base64,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