import { Component, Inject, Input } from '@angular/core';
import { PRG_ROLES_SCOPES_CONFIG } from '../../services/roles-scopes-configuration/prg-roles-scopes-configuration.service';
import * as i0 from "@angular/core";
import * as i1 from "../../../core/services/utility/objects-utility.service";
import * as i2 from "../../../core/services/utility/array-utility.service";
import * as i3 from "../../services/roles-scopes/abstract-roles-scopes.service";
import * as i4 from "../../../entity-types/services/entity-types/abstract-entity-type.service";
import * as i5 from "primeng/api";
import * as i6 from "@angular/common";
import * as i7 from "primeng/button";
import * as i8 from "primeng/multiselect";
import * as i9 from "primeng/checkbox";
import * as i10 from "primeng/treetable";
import * as i11 from "primeng/tristatecheckbox";
import * as i12 from "@angular/forms";
import * as i13 from "@ngx-translate/core";
/**
 * Scopes table component
 * Tri checkbox legend:
 * true-> all selected
 * false-> partial selected
 * null-> non selected
 */
export class PrgScopesTableComponent {
    /**
     * constructor
     * @param objectsUtilityService
     * @param arrayUtilityService
     * @param rolesScopesService
     * @param prgRolesScopesConfig  prgRolesScopesConfig
     */
    constructor(objectsUtilityService, arrayUtilityService, rolesScopesService, abstractEntityTypeService, prgRolesScopesConfig) {
        this.objectsUtilityService = objectsUtilityService;
        this.arrayUtilityService = arrayUtilityService;
        this.rolesScopesService = rolesScopesService;
        this.abstractEntityTypeService = abstractEntityTypeService;
        this.prgRolesScopesConfig = prgRolesScopesConfig;
        /**
         * has a role selected
         */
        this.haveRole = false;
        /**
         * table columns
         */
        this.tableColumns = [];
        /**
         * haveChangesToSave
         */
        this.haveChangesToSave = false;
        /**
         * base scopes
         */
        this.baseScopes = this.prgRolesScopesConfig.baseScopes;
    }
    /**
     * Role that we want to configure
     */
    set role(value) {
        if (value) {
            this.haveRole = true;
            this._role = this.objectsUtilityService.cloneObject(value);
            if (this._role.scopes) {
                this.mappingTheScopesOfARole(value.scopes);
            }
            else {
                this.treeData = this.createDataStructure();
            }
        }
    }
    /**
     * ngOnInit
     *
     * set value to
     * [treeData]{@link #treeData}
     * [entityTypes]{@link #entityTypes}
     * [tableColumns]{@link #tableColumns}
     *
     * call method [getAllEntityType]{@link /classes/AbstractRolesScopesService.html#getAllEntityType} from services
     */
    ngOnInit() {
        // TODO: acho que fizemos um erro de spec, ou seja, estamos a usar as entitytypes para criar a estrutura
        //    quando deveriamos usar apenas as scopes ou pelo menos devemos poder acrescentar scopes sem entity type, a falar...
        this.abstractEntityTypeService
            .getEntityTypeListWithOperationAsync()
            .then((response) => {
            this.entityTypes = response;
            // this.treeData = this.createDataStructure();
        });
        this.tableColumns = this.tableColumns.concat(this.baseScopes);
        this.tableColumns.unshift('name');
        this.tableColumns.push(this.prgRolesScopesConfig.otherScopes);
    }
    /**
     * this function receives the scopes and arranges
     * them by group into the correct structure
     * to be used in the treetable
     *
     * this function call [createEntityTypeColumns]{@link #createEntityTypeColumns} to create entity type columns
     * this function call [createGroupColumns]{@link #createGroupColumns} to create columns
     *
     * @returns TreeNode<PrgScopesNode>[]
     */
    createDataStructure() {
        if (this.entityTypes == null) {
            return null;
        }
        let entityTypesOrganisedByGroup = new Map();
        let entityTypesOrganizedTreeNode = [];
        this.entityTypes.forEach((element) => {
            if (element.operations != null && element.operations.length) {
                const treeNodeEntityType = {
                    data: {
                        isGroup: false,
                        name: element.name,
                        label: element.label,
                        columns: this.createEntityTypeColumns(element),
                    },
                };
                if (entityTypesOrganisedByGroup.has(element.group)) {
                    entityTypesOrganisedByGroup
                        .get(element.group)
                        .push(treeNodeEntityType);
                }
                else {
                    entityTypesOrganisedByGroup.set(element.group, [treeNodeEntityType]);
                }
            }
        });
        entityTypesOrganisedByGroup.forEach((nodes, groupName) => {
            let treeNodeGroup = {};
            treeNodeGroup.data = {
                isGroup: true,
                name: groupName,
                label: groupName,
                columns: this.createGroupColumns(nodes),
            };
            treeNodeGroup.children = nodes;
            treeNodeGroup.expanded = true;
            entityTypesOrganizedTreeNode.push(treeNodeGroup);
        });
        return entityTypesOrganizedTreeNode;
    }
    /**
     * this function create Entity Columns
     * @param entityType
     * @returns PrgScopesColumns
     */
    createEntityTypeColumns(entityType) {
        const prgScopesColumns = {
            value: null,
            children: new Map(),
        };
        if (!entityType.operations) {
            return prgScopesColumns;
        }
        entityType.operations.forEach((item) => {
            if (this.baseScopes.includes(item.name)) {
                // create columns when is a base scope
                prgScopesColumns.children.set(item.name, {
                    value: null,
                    scope: entityType.name + ':' + item.name,
                    children: null,
                    label: 'ola1',
                });
            }
            else {
                // create columns when is other scopes
                let other = prgScopesColumns.children.get(this.prgRolesScopesConfig.otherScopes);
                if (!other) {
                    other = {
                        value: null,
                        scope: null,
                        children: new Map(),
                        data: [],
                        label: 'ola2',
                    };
                    prgScopesColumns.children.set(this.prgRolesScopesConfig.otherScopes, other);
                }
                other.children.set(item.name, {
                    parent: other,
                    value: false,
                    scope: entityType.name + ':' + item.name,
                    children: null,
                    data: [],
                    label: item.label,
                });
            }
        });
        return prgScopesColumns;
    }
    /**
     * this function create group columns
     * @param nodes
     * @returns PrgScopesColumns
     */
    createGroupColumns(nodes) {
        const prgScopesColumns = {
            value: null,
            children: new Map(),
        };
        // loop base scopes to check if exist a child with this scope action
        this.baseScopes.forEach((col) => {
            if (nodes.find((n) => n.data.columns.children.has(col)) != null) {
                prgScopesColumns.children.set(col, {
                    value: null,
                    scope: null,
                    children: null,
                    label: 'ola4',
                });
            }
        });
        // check if exist a child with other scope action
        if (nodes.find((n) => n.data.columns.children.has(this.prgRolesScopesConfig.otherScopes)) == null) {
            return prgScopesColumns;
        }
        prgScopesColumns.children.set(this.prgRolesScopesConfig.otherScopes, {
            value: null,
            scope: null,
            children: null,
            label: 'ola5',
        });
        return prgScopesColumns;
    }
    /**
     * this function returns an array with all scopes
     *
     * @returns PrgScopeColumnData[]
     */
    getScopeObjectsFromTree() {
        return this.treeData.reduce((prev, next) => this.getScopeObjectsFromTreeChildrens(prev, next.children), []);
    }
    /**
     * is an auxiliary function, which makes use of
     * recursion to return all the scopes of
     * all the children of the tree
     *
     * @param prev
     * @param items
     * @returns PrgScopeColumnData[]
     */
    getScopeObjectsFromTreeChildrens(prev, items) {
        if (items == null)
            return prev;
        items.forEach((x) => {
            if (x?.scope) {
                prev.push(x);
            }
            else if (x?.data?.columns?.children) {
                this.getScopeObjectsFromTreeChildrens(prev, x.data.columns.children);
            }
            else if (x?.value?.children) {
                this.getScopeObjectsFromTreeChildrens(prev, x.value.children);
            }
            else if (x?.children) {
                this.getScopeObjectsFromTreeChildrens(prev, x.children);
            }
        });
        return prev;
    }
    /**
     * This function is responsible for checking all scopes received as parameters
     *
     * this function call [getScopeObjectsFromTree]{@link #getScopeObjectsFromTree} to get all scopes
     *
     * @param scopes
     */
    setSelectedScopes(scopes) {
        this.getScopeObjectsFromTree().forEach((x) => {
            x.value = scopes.find((y) => y === x.scope) != null;
            if (x.parent) {
                x.parent.data.push(x.scope);
                x.parent.value =
                    x.parent.data.length == x.parent.children.size
                        ? true
                        : x.parent.data.length > 0
                            ? false
                            : null;
            }
        });
    }
    /**
     * this function maps the scopes of the selected role in the table data
     *
     *
     * @param roleScopes
     * @returns
     */
    mappingTheScopesOfARole(roleScopes) {
        // clean treeData
        this.treeData = this.createDataStructure();
        if (this.treeData == null) {
            return;
        }
        if (roleScopes && roleScopes.length > 0) {
            this.setSelectedScopes(roleScopes);
            //loop to check row, columns and groups
            this.treeData.forEach((group) => {
                const groupName = group.data.name;
                group.children.forEach((child) => {
                    this.checkIfAllScopesAreSelectedByRow(child.data.name, groupName);
                });
                [...group.data.columns.children.keys()].forEach((key) => {
                    this.checkIfAllScopesAreSelectedByGroupColumn(group.data.name, key);
                });
                this.checkIfAllScopesAreSelectedByGroup(groupName);
            });
        }
    }
    /**
     * this function is responsible for checking or unchecking
     * all the other scopes of a row, making all
     * the necessary checks to validate the state
     * of the group, column and row
     *
     * @param event
     * @param groupName
     * @param rowData
     */
    otherCheckedChange(event, groupName, rowData) {
        const otherChild = rowData.columns.children.get(this.prgRolesScopesConfig.otherScopes);
        // put all children a false
        otherChild.children.forEach((row) => {
            row.value = false;
        });
        // clean array with selected other scopes
        otherChild.data = [];
        //use event value to check other scopes again
        event.value.forEach((val) => {
            const value = val.substr(val.indexOf(':') + 1);
            const node = otherChild.children.get(value);
            node.value = !node.value;
            otherChild.data.push(val);
        });
        const checkedCount = [...otherChild.children.values()].filter((n) => n.value === true).length;
        otherChild.value =
            checkedCount === otherChild.children.size
                ? true
                : checkedCount > 0
                    ? false
                    : null;
        // check row, column and group status
        this.checkIfAllScopesAreSelectedByGroupColumn(groupName, this.prgRolesScopesConfig.otherScopes);
        this.checkIfAllScopesAreSelectedByRow(rowData.name, groupName);
        this.checkIfAllScopesAreSelectedByGroup(groupName);
        this.compareOriginalScopesWithCurrentScopesSelection();
    }
    /**
     * toogle column in group
     *
     * @param rowData
     * @param column
     */
    columnCheckedChange(rowData, column) {
        const groupName = rowData.name;
        const group = this.treeData.find((obj) => obj.data.name === groupName);
        // if the current status is other than true, we must pass the value to true, otherwise to null
        const status = group.data.columns.children.get(column).value !== true;
        group.data.columns.children.get(column).value = status ? true : null;
        group.children.forEach((element) => {
            if (element.data.columns.children.has(column)) {
                if (column === this.prgRolesScopesConfig.otherScopes) {
                    this.groupOtherSelectionChange(status, element.data.columns.children.get(column));
                }
                else {
                    element.data.columns.children.get(column).value = status;
                }
            }
        });
        this.checkIfAllScopesAreSelectedByGroup(groupName);
        group.children.forEach((element) => {
            this.checkIfAllScopesAreSelectedByRow(element.data.name, groupName);
        });
        this.compareOriginalScopesWithCurrentScopesSelection();
    }
    /**
     * this function is responsible for checking or unchecking
     * all other scopes in a group
     *
     * @param toogleStatus
     * @param otherColumnsData
     */
    groupOtherSelectionChange(toogleStatus, otherColumnsData) {
        otherColumnsData.value = toogleStatus ? true : null;
        otherColumnsData.data = [];
        otherColumnsData.children.forEach((otherChild, otherKey) => {
            otherChild.value = toogleStatus;
            if (toogleStatus) {
                otherColumnsData.data.push(otherKey);
            }
        });
    }
    /**
     * this function is responsible for checking or unchecking
     * all the scopes of a row, doing all the state
     * validations for the group and columns
     *
     * call method [groupOtherSelectionChange]{@link #groupOtherSelectionChange} to toogle other scopes
     *
     * @param groupName
     * @param rowData
     */
    rowSelectionChange(groupName, rowData) {
        // if the current status is other than true, we must pass the value to true, otherwise to null
        const status = rowData.columns.value !== true;
        rowData.columns.value = status ? true : null;
        rowData.columns.children.forEach((child, key) => {
            if (key === this.prgRolesScopesConfig.otherScopes) {
                this.groupOtherSelectionChange(status, child);
            }
            else {
                child.value = status;
            }
        });
        //check columns
        [...rowData.columns.children.keys()].forEach((key) => {
            this.checkIfAllScopesAreSelectedByGroupColumn(groupName, key);
        });
        //check group
        this, this.checkIfAllScopesAreSelectedByGroup(groupName);
        this.compareOriginalScopesWithCurrentScopesSelection();
    }
    /**
     * this function is responsible for checking or
     * unchecking all scopes in a given group
     *
     * call method [groupOtherSelectionChange]{@link #groupOtherSelectionChange} to toogle other scopes
     * @param groupName
     */
    groupSelectionChange(groupName) {
        const group = this.treeData.find((obj) => obj.data.name === groupName);
        // if the current status is other than true, we must pass the value to true, otherwise to null
        const status = group.data.columns.value !== true;
        group.data.columns.value = status ? true : null;
        group.data.columns.children.forEach((child) => {
            child.value = status ? true : null;
        });
        group.children.forEach((child) => {
            child.data.columns.value = status ? true : null;
        });
        group.children.forEach((child) => {
            child.data.columns.children.forEach((scopeChild, key) => {
                if (key === this.prgRolesScopesConfig.otherScopes) {
                    this.groupOtherSelectionChange(status, scopeChild);
                }
                else {
                    scopeChild.value = status;
                }
            });
        });
        this.compareOriginalScopesWithCurrentScopesSelection();
    }
    /**
     * This function is responsible for making the
     * necessary changes when a scope has its state changed.
     * Using auxiliary functions, it validates if the column,
     * row and the group in which it is inserted are totally or
     * partially with a selection or without any selection;
     *
     * Auxiliar functions:
     * [checkIfAllScopesAreSelectedByGroupColumn]{@link #checkIfAllScopesAreSelectedByGroupColumn}
     * [checkIfAllScopesAreSelectedByRow]{@link #checkIfAllScopesAreSelectedByRow}
     * [checkIfAllScopesAreSelectedByGroup]{@link #checkIfAllScopesAreSelectedByGroup}
     *
     * @param groupName
     * @param rowData
     * @param column
     */
    scopeSelectionChange(groupName, rowName, column) {
        this.compareOriginalScopesWithCurrentScopesSelection();
        // check row, columns and group
        this.checkIfAllScopesAreSelectedByGroupColumn(groupName, column);
        this.checkIfAllScopesAreSelectedByRow(rowName, groupName);
        this.checkIfAllScopesAreSelectedByGroup(groupName);
    }
    /**
     * This function validates if scopes are fully or
     * partially selected or if no scope is selected in a group
     *
     * @param rowName
     */
    checkIfAllScopesAreSelectedByRow(rowName, groupName) {
        const group = this.treeData.find((obj) => obj.data.name === groupName);
        const row = group.children.find((obj) => obj.data.name === rowName);
        // get all children checked
        const childrenColChecked = [...row.data.columns.children.values()].filter((c) => c.value === true);
        // if have other scopes check if have some scope selected
        let childrenColPartial = null;
        if (row.data.columns.children.has(this.prgRolesScopesConfig.otherScopes)) {
            childrenColPartial = row.data.columns.children.get(this.prgRolesScopesConfig.otherScopes).value;
        }
        row.data.columns.value =
            childrenColChecked.length == row.data.columns.children.size
                ? true
                : childrenColChecked.length > 0 || childrenColPartial !== null
                    ? false
                    : null;
    }
    /**
     * This function validates if scopes are fully or
     *  partially selected or if no scope is selected on a given column in a group
     *
     * Auxiliar functions:
     * [checkIfAllScopesAreSelectedForAdditional]{@link #checkIfAllScopesAreSelectedForAdditional}
     * [checkIfAllScopesAreSelectedForColumn]{@link #checkIfAllScopesAreSelectedForColumn}
     *
     * @param groupName
     * @param columnName
     */
    checkIfAllScopesAreSelectedByGroupColumn(groupName, columnName) {
        const group = this.treeData.find((obj) => obj.data.name === groupName);
        if (this.prgRolesScopesConfig.baseScopes.includes(columnName)) {
            group.data.columns.children.get(columnName).value =
                this.checkIfAllScopesAreSelectedForColumn(group.children, columnName);
        }
        else {
            group.data.columns.children.get(columnName).value =
                this.checkIfAllScopesAreSelectedForAdditional(group.children);
        }
    }
    /**
     * This function validates if scopes are fully or
     * partially selected or if no scope is selected in a group
     *
     * @param groupName
     */
    checkIfAllScopesAreSelectedByGroup(groupName) {
        const groupData = this.treeData.find((obj) => obj.data.name === groupName).data;
        // get all group columns checked
        const childrenColChecked = [...groupData.columns.children.values()].filter((c) => c.value === true);
        if (childrenColChecked.length == groupData.columns.children.size) {
            groupData.columns.value = true;
            return;
        }
        const childrenColPartial = [...groupData.columns.children.values()].filter((c) => c.value === false || c.value === true);
        groupData.columns.value = childrenColPartial.length > 0 ? false : null;
    }
    /**
     *this function validates whether the state of a column of other scopes
     * @param groupChildren
     * @returns boolean or null
     */
    checkIfAllScopesAreSelectedForAdditional(groupChildren) {
        //get list with all custom scopes selected
        const childrenColChecked = groupChildren.filter((c) => !c.data.columns.children.has(this.prgRolesScopesConfig.otherScopes) ||
            c.data.columns.children.get(this.prgRolesScopesConfig.otherScopes)
                .value === true);
        if (childrenColChecked.length == groupChildren.length) {
            return true;
        }
        const childrenColPartial = groupChildren.filter((c) => !c.data.columns.children.has(this.prgRolesScopesConfig.otherScopes) ||
            c.data.columns.children.get(this.prgRolesScopesConfig.otherScopes)
                .value === false);
        const childrenWithoutCol = groupChildren.filter((c) => !c.data.columns.children.has(this.prgRolesScopesConfig.otherScopes));
        return childrenColPartial.length - childrenWithoutCol.length > 0
            ? false
            : null;
    }
    /**
     * this is an auxiliary function that validates if a given column(default columns(crud))
     * of a group has its scopes totally or
     * partially selected or without any selection
     *
     * @param groupChildren
     * @param column
     * @returns boolean or null
     */
    checkIfAllScopesAreSelectedForColumn(groupChildren, column) {
        //get an array with the selected scopes from the column
        const childrenColChecked = groupChildren.filter((c) => !c.data.columns.children.has(column) ||
            c.data.columns.children.get(column).value === true);
        //get an array with the rows that have no scope in that column
        const childrenWithoutCol = groupChildren.filter((c) => !c.data.columns.children.has(column));
        return childrenColChecked.length == groupChildren.length
            ? true
            : childrenColChecked.length - childrenWithoutCol.length > 0
                ? false
                : null;
    }
    /**
     * this function compares the original scopes of the selected function with the currently selected scopes
     *
     * set value to [haveChangesToSave] {@link #haveChangesToSave}
     */
    compareOriginalScopesWithCurrentScopesSelection() {
        let originalScopesSelected = [];
        if (this._role && this._role.scopes) {
            originalScopesSelected = this._role.scopes.slice().sort();
        }
        const currentScopesSelected = this.getSelectedScopes();
        this.haveChangesToSave = !this.arrayUtilityService.compareTwoArray(originalScopesSelected, currentScopesSelected);
    }
    /**
     * this function returns an array with
     * all the selected scopes
     *
     * use the [getScopeObjectsFromTree] {@link getScopeObjectsFromTree} function to get a list of all the scopes
     * @returns  string[]
     */
    getSelectedScopes() {
        return this.getScopeObjectsFromTree().reduce((prev, x) => {
            if (x.value) {
                prev.push(x.scope);
            }
            return prev;
        }, []);
    }
    /**
     * this function saves all changes to a role
     *
     * calling the [updateRole]{@link /classes/AbstractRolesScopesService.html#updateRole} method from services
     */
    saveChanges() {
        let scopesSelected = [];
        scopesSelected = this.getSelectedScopes();
        this._role.scopes = scopesSelected;
        this.rolesScopesService.updateRole(this._role);
        this.haveChangesToSave = false;
    }
}
PrgScopesTableComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgScopesTableComponent, deps: [{ token: i1.ObjectsUtilityService }, { token: i2.ArrayUtilityService }, { token: i3.AbstractRolesScopesService }, { token: i4.AbstractEntityTypeService }, { token: PRG_ROLES_SCOPES_CONFIG }], target: i0.ɵɵFactoryTarget.Component });
PrgScopesTableComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgScopesTableComponent, selector: "prg-scopes-table", inputs: { role: "role" }, ngImport: i0, template: "<div>\r\n  <p-treeTable\r\n    [value]=\"treeData\"\r\n    [columns]=\"tableColumns\"\r\n    selectionMode=\"checkbox\"\r\n  >\r\n    <ng-template pTemplate=\"header\" let-columns>\r\n      <tr>\r\n        <th *ngFor=\"let col of columns\">\r\n          {{ 'components.roles-scopes.columns.' + col + '.label' | translate }}\r\n        </th>\r\n      </tr>\r\n    </ng-template>\r\n\r\n    <ng-template\r\n      pTemplate=\"body\"\r\n      let-rowNode\r\n      let-rowData=\"rowData\"\r\n      let-columns=\"columns\"\r\n    >\r\n      <ng-container *ngIf=\"haveRole\">\r\n        <tr\r\n          [ttContextMenuRow]=\"rowNode\"\r\n          [ngClass]=\"{ node: rowNode.level === 0 }\"\r\n        >\r\n          <td\r\n            *ngFor=\"\r\n              let col of tableColumns.slice(0, tableColumns.length - 1);\r\n              let i = index\r\n            \"\r\n          >\r\n            <p-treeTableToggler\r\n              *ngIf=\"i == 0\"\r\n              [rowNode]=\"rowNode\"\r\n            ></p-treeTableToggler>\r\n            <p-triStateCheckbox\r\n              *ngIf=\"i == 0 && rowData.isGroup; else elseBlockFirstCol\"\r\n              label=\"{{\r\n                'entity-type.groups.' + rowData.name.toLowerCase() + '.label'\r\n                  | translate\r\n              }}\"\r\n              [ngModel]=\"rowData.columns.value\"\r\n              (click)=\"groupSelectionChange(rowData.name)\"\r\n              checkboxFalseIcon=\"pi pi-minus\"\r\n            ></p-triStateCheckbox>\r\n\r\n            <ng-template #elseBlockFirstCol>\r\n              <p-triStateCheckbox\r\n                *ngIf=\"i == 0\"\r\n                [label]=\"rowData.label\"\r\n                [ngModel]=\"rowData.columns.value\"\r\n                (click)=\"rowSelectionChange(rowNode.parent.data.name, rowData)\"\r\n                checkboxFalseIcon=\"pi pi-minus\"\r\n              ></p-triStateCheckbox>\r\n            </ng-template>\r\n            <p-triStateCheckbox\r\n              *ngIf=\"\r\n                i > 0 &&\r\n                  rowData.columns.children.has(col) &&\r\n                  rowNode.node.children;\r\n                else elseBlock\r\n              \"\r\n              [ngModel]=\"rowData.columns.children.get(col).value\"\r\n              (click)=\"columnCheckedChange(rowData, col)\"\r\n              checkboxFalseIcon=\"pi pi-minus\"\r\n            ></p-triStateCheckbox>\r\n            <ng-template #elseBlock>\r\n              <p-checkbox\r\n                *ngIf=\"i > 0 && rowNode.node.data.columns.children.get(col)\"\r\n                [name]=\"rowData.name\"\r\n                [value]=\"rowData.name\"\r\n                [(ngModel)]=\"rowNode.node.data.columns.children.get(col).value\"\r\n                (onChange)=\"\r\n                  scopeSelectionChange(\r\n                    rowNode.parent.data.name,\r\n                    rowData.name,\r\n                    col\r\n                  )\r\n                \"\r\n                [binary]=\"true\"\r\n              ></p-checkbox>\r\n            </ng-template>\r\n          </td>\r\n          <td>\r\n            <p-multiSelect\r\n              *ngIf=\"\r\n                rowData.columns.children.has(\r\n                  prgRolesScopesConfig.otherScopes\r\n                ) && !rowData.isGroup\r\n              \"\r\n              [options]=\"\r\n                rowData.columns.children.get(prgRolesScopesConfig.otherScopes)\r\n                  .children | keyvalue\r\n              \"\r\n              optionValue=\"value.scope\"\r\n              [ngModel]=\"\r\n                rowData.columns.children.get(prgRolesScopesConfig.otherScopes)\r\n                  .data\r\n              \"\r\n              (onChange)=\"\r\n                otherCheckedChange($event, rowNode.parent.data.name, rowData)\r\n              \"\r\n              [resetFilterOnHide]=\"true\"\r\n              [emptyFilterMessage]=\"'messages.no-results' | translate\"\r\n              [filter]=\"false\"\r\n              defaultLabel=\"{{\r\n                'components.roles-scopes.other-operations-column.other-operations.label'\r\n                  | translate\r\n              }}\"\r\n            >\r\n              <ng-template let-value pTemplate=\"selectedItems\">\r\n                <ng-template\r\n                  [ngIf]=\"\r\n                    !rowData.columns.children.get(\r\n                      prgRolesScopesConfig.otherScopes\r\n                    ).data ||\r\n                    rowData.columns.children.get(\r\n                      prgRolesScopesConfig.otherScopes\r\n                    ).data.length === 0\r\n                  \"\r\n                  [ngIfElse]=\"withSelected\"\r\n                >\r\n                  {{\r\n                    'components.roles-scopes.other-operations-column.other-operations.label'\r\n                      | translate\r\n                  }}\r\n                </ng-template>\r\n                <ng-template #withSelected>\r\n                  <div\r\n                    *ngIf=\"\r\n                      rowData.columns.children.get(\r\n                        prgRolesScopesConfig.otherScopes\r\n                      ).data.length === 1;\r\n                      else elseBlockMultipleSelected\r\n                    \"\r\n                  >\r\n                    {{\r\n                      rowData.columns.children.get(\r\n                        prgRolesScopesConfig.otherScopes\r\n                      ).data.length\r\n                    }}\r\n                    {{\r\n                      'components.roles-scopes.other-operations-column.operation-selected.label'\r\n                        | translate\r\n                    }}\r\n                  </div>\r\n                  <ng-template #elseBlockMultipleSelected>\r\n                    {{\r\n                      rowData.columns.children.get(\r\n                        prgRolesScopesConfig.otherScopes\r\n                      ).data.length\r\n                    }}\r\n                    {{\r\n                      'components.roles-scopes.other-operations-column.operations-selected.label'\r\n                        | translate\r\n                    }}\r\n                  </ng-template>\r\n                </ng-template>\r\n              </ng-template>\r\n              <ng-template let-other pTemplate=\"item\">\r\n                {{ other.value.label | translate }}\r\n              </ng-template>\r\n            </p-multiSelect>\r\n\r\n            <p-triStateCheckbox\r\n              *ngIf=\"\r\n                rowData.columns.children.has(\r\n                  prgRolesScopesConfig.otherScopes\r\n                ) && rowData.isGroup\r\n              \"\r\n              [ngModel]=\"\r\n                rowData.columns.children.get(prgRolesScopesConfig.otherScopes)\r\n                  .value\r\n              \"\r\n              (click)=\"\r\n                columnCheckedChange(rowData, prgRolesScopesConfig.otherScopes)\r\n              \"\r\n              checkboxFalseIcon=\"pi pi-minus\"\r\n            ></p-triStateCheckbox>\r\n          </td>\r\n        </tr>\r\n      </ng-container>\r\n    </ng-template>\r\n  </p-treeTable>\r\n  <!-- *ngIf=\"haveRole\" -->\r\n  <button\r\n    pButton\r\n    type=\"button\"\r\n    label=\"{{ 'buttons.save.label' | translate }}\"\r\n    (click)=\"saveChanges()\"\r\n    [disabled]=\"!haveChangesToSave\"\r\n  ></button>\r\n</div>\r\n", styles: ["td{padding:4px!important;font-size:10px}.node{background:#f3f3f3!important}\n"], dependencies: [{ kind: "directive", type: i5.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i6.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i6.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i7.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i8.MultiSelect, selector: "p-multiSelect", inputs: ["style", "styleClass", "panelStyle", "panelStyleClass", "inputId", "disabled", "readonly", "group", "filter", "filterPlaceHolder", "filterLocale", "overlayVisible", "tabindex", "appendTo", "dataKey", "name", "label", "ariaLabelledBy", "displaySelectedLabel", "maxSelectedLabels", "selectionLimit", "selectedItemsLabel", "showToggleAll", "emptyFilterMessage", "emptyMessage", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "showHeader", "autoZIndex", "baseZIndex", "filterBy", "scrollHeight", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "filterMatchMode", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "display", "autocomplete", "showClear", "defaultLabel", "placeholder", "options", "filterValue", "itemSize"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onClear", "onPanelShow", "onPanelHide", "onLazyLoad"] }, { kind: "component", type: i9.Checkbox, selector: "p-checkbox", inputs: ["value", "name", "disabled", "binary", "label", "ariaLabelledBy", "ariaLabel", "tabindex", "inputId", "style", "styleClass", "labelStyleClass", "formControl", "checkboxIcon", "readonly", "required", "trueValue", "falseValue"], outputs: ["onChange"] }, { kind: "component", type: i10.TreeTable, selector: "p-treeTable", inputs: ["columns", "style", "styleClass", "tableStyle", "tableStyleClass", "autoLayout", "lazy", "lazyLoadOnInit", "paginator", "rows", "first", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "customSort", "selectionMode", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "compareSelectionBy", "rowHover", "loading", "loadingIcon", "showLoader", "scrollable", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "frozenColumns", "resizableColumns", "columnResizeMode", "reorderableColumns", "contextMenu", "rowTrackBy", "filters", "globalFilterFields", "filterDelay", "filterMode", "filterLocale", "virtualRowHeight", "value", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection"], outputs: ["selectionChange", "contextMenuSelectionChange", "onFilter", "onNodeExpand", "onNodeCollapse", "onPage", "onSort", "onLazyLoad", "sortFunction", "onColResize", "onColReorder", "onNodeSelect", "onNodeUnselect", "onContextMenuSelect", "onHeaderCheckboxToggle", "onEditInit", "onEditComplete", "onEditCancel"] }, { kind: "component", type: i10.TreeTableToggler, selector: "p-treeTableToggler", inputs: ["rowNode"] }, { kind: "directive", type: i10.TTContextMenuRow, selector: "[ttContextMenuRow]", inputs: ["ttContextMenuRow", "ttContextMenuRowDisabled"] }, { kind: "component", type: i11.TriStateCheckbox, selector: "p-triStateCheckbox", inputs: ["disabled", "name", "ariaLabelledBy", "tabindex", "inputId", "style", "styleClass", "label", "readonly", "checkboxTrueIcon", "checkboxFalseIcon"], outputs: ["onChange"] }, { kind: "directive", type: i12.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i12.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "pipe", type: i6.KeyValuePipe, name: "keyvalue" }, { kind: "pipe", type: i13.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgScopesTableComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-scopes-table', template: "<div>\r\n  <p-treeTable\r\n    [value]=\"treeData\"\r\n    [columns]=\"tableColumns\"\r\n    selectionMode=\"checkbox\"\r\n  >\r\n    <ng-template pTemplate=\"header\" let-columns>\r\n      <tr>\r\n        <th *ngFor=\"let col of columns\">\r\n          {{ 'components.roles-scopes.columns.' + col + '.label' | translate }}\r\n        </th>\r\n      </tr>\r\n    </ng-template>\r\n\r\n    <ng-template\r\n      pTemplate=\"body\"\r\n      let-rowNode\r\n      let-rowData=\"rowData\"\r\n      let-columns=\"columns\"\r\n    >\r\n      <ng-container *ngIf=\"haveRole\">\r\n        <tr\r\n          [ttContextMenuRow]=\"rowNode\"\r\n          [ngClass]=\"{ node: rowNode.level === 0 }\"\r\n        >\r\n          <td\r\n            *ngFor=\"\r\n              let col of tableColumns.slice(0, tableColumns.length - 1);\r\n              let i = index\r\n            \"\r\n          >\r\n            <p-treeTableToggler\r\n              *ngIf=\"i == 0\"\r\n              [rowNode]=\"rowNode\"\r\n            ></p-treeTableToggler>\r\n            <p-triStateCheckbox\r\n              *ngIf=\"i == 0 && rowData.isGroup; else elseBlockFirstCol\"\r\n              label=\"{{\r\n                'entity-type.groups.' + rowData.name.toLowerCase() + '.label'\r\n                  | translate\r\n              }}\"\r\n              [ngModel]=\"rowData.columns.value\"\r\n              (click)=\"groupSelectionChange(rowData.name)\"\r\n              checkboxFalseIcon=\"pi pi-minus\"\r\n            ></p-triStateCheckbox>\r\n\r\n            <ng-template #elseBlockFirstCol>\r\n              <p-triStateCheckbox\r\n                *ngIf=\"i == 0\"\r\n                [label]=\"rowData.label\"\r\n                [ngModel]=\"rowData.columns.value\"\r\n                (click)=\"rowSelectionChange(rowNode.parent.data.name, rowData)\"\r\n                checkboxFalseIcon=\"pi pi-minus\"\r\n              ></p-triStateCheckbox>\r\n            </ng-template>\r\n            <p-triStateCheckbox\r\n              *ngIf=\"\r\n                i > 0 &&\r\n                  rowData.columns.children.has(col) &&\r\n                  rowNode.node.children;\r\n                else elseBlock\r\n              \"\r\n              [ngModel]=\"rowData.columns.children.get(col).value\"\r\n              (click)=\"columnCheckedChange(rowData, col)\"\r\n              checkboxFalseIcon=\"pi pi-minus\"\r\n            ></p-triStateCheckbox>\r\n            <ng-template #elseBlock>\r\n              <p-checkbox\r\n                *ngIf=\"i > 0 && rowNode.node.data.columns.children.get(col)\"\r\n                [name]=\"rowData.name\"\r\n                [value]=\"rowData.name\"\r\n                [(ngModel)]=\"rowNode.node.data.columns.children.get(col).value\"\r\n                (onChange)=\"\r\n                  scopeSelectionChange(\r\n                    rowNode.parent.data.name,\r\n                    rowData.name,\r\n                    col\r\n                  )\r\n                \"\r\n                [binary]=\"true\"\r\n              ></p-checkbox>\r\n            </ng-template>\r\n          </td>\r\n          <td>\r\n            <p-multiSelect\r\n              *ngIf=\"\r\n                rowData.columns.children.has(\r\n                  prgRolesScopesConfig.otherScopes\r\n                ) && !rowData.isGroup\r\n              \"\r\n              [options]=\"\r\n                rowData.columns.children.get(prgRolesScopesConfig.otherScopes)\r\n                  .children | keyvalue\r\n              \"\r\n              optionValue=\"value.scope\"\r\n              [ngModel]=\"\r\n                rowData.columns.children.get(prgRolesScopesConfig.otherScopes)\r\n                  .data\r\n              \"\r\n              (onChange)=\"\r\n                otherCheckedChange($event, rowNode.parent.data.name, rowData)\r\n              \"\r\n              [resetFilterOnHide]=\"true\"\r\n              [emptyFilterMessage]=\"'messages.no-results' | translate\"\r\n              [filter]=\"false\"\r\n              defaultLabel=\"{{\r\n                'components.roles-scopes.other-operations-column.other-operations.label'\r\n                  | translate\r\n              }}\"\r\n            >\r\n              <ng-template let-value pTemplate=\"selectedItems\">\r\n                <ng-template\r\n                  [ngIf]=\"\r\n                    !rowData.columns.children.get(\r\n                      prgRolesScopesConfig.otherScopes\r\n                    ).data ||\r\n                    rowData.columns.children.get(\r\n                      prgRolesScopesConfig.otherScopes\r\n                    ).data.length === 0\r\n                  \"\r\n                  [ngIfElse]=\"withSelected\"\r\n                >\r\n                  {{\r\n                    'components.roles-scopes.other-operations-column.other-operations.label'\r\n                      | translate\r\n                  }}\r\n                </ng-template>\r\n                <ng-template #withSelected>\r\n                  <div\r\n                    *ngIf=\"\r\n                      rowData.columns.children.get(\r\n                        prgRolesScopesConfig.otherScopes\r\n                      ).data.length === 1;\r\n                      else elseBlockMultipleSelected\r\n                    \"\r\n                  >\r\n                    {{\r\n                      rowData.columns.children.get(\r\n                        prgRolesScopesConfig.otherScopes\r\n                      ).data.length\r\n                    }}\r\n                    {{\r\n                      'components.roles-scopes.other-operations-column.operation-selected.label'\r\n                        | translate\r\n                    }}\r\n                  </div>\r\n                  <ng-template #elseBlockMultipleSelected>\r\n                    {{\r\n                      rowData.columns.children.get(\r\n                        prgRolesScopesConfig.otherScopes\r\n                      ).data.length\r\n                    }}\r\n                    {{\r\n                      'components.roles-scopes.other-operations-column.operations-selected.label'\r\n                        | translate\r\n                    }}\r\n                  </ng-template>\r\n                </ng-template>\r\n              </ng-template>\r\n              <ng-template let-other pTemplate=\"item\">\r\n                {{ other.value.label | translate }}\r\n              </ng-template>\r\n            </p-multiSelect>\r\n\r\n            <p-triStateCheckbox\r\n              *ngIf=\"\r\n                rowData.columns.children.has(\r\n                  prgRolesScopesConfig.otherScopes\r\n                ) && rowData.isGroup\r\n              \"\r\n              [ngModel]=\"\r\n                rowData.columns.children.get(prgRolesScopesConfig.otherScopes)\r\n                  .value\r\n              \"\r\n              (click)=\"\r\n                columnCheckedChange(rowData, prgRolesScopesConfig.otherScopes)\r\n              \"\r\n              checkboxFalseIcon=\"pi pi-minus\"\r\n            ></p-triStateCheckbox>\r\n          </td>\r\n        </tr>\r\n      </ng-container>\r\n    </ng-template>\r\n  </p-treeTable>\r\n  <!-- *ngIf=\"haveRole\" -->\r\n  <button\r\n    pButton\r\n    type=\"button\"\r\n    label=\"{{ 'buttons.save.label' | translate }}\"\r\n    (click)=\"saveChanges()\"\r\n    [disabled]=\"!haveChangesToSave\"\r\n  ></button>\r\n</div>\r\n", styles: ["td{padding:4px!important;font-size:10px}.node{background:#f3f3f3!important}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.ObjectsUtilityService }, { type: i2.ArrayUtilityService }, { type: i3.AbstractRolesScopesService }, { type: i4.AbstractEntityTypeService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ROLES_SCOPES_CONFIG]
                }] }]; }, propDecorators: { role: [{
                type: Input,
                args: ['role']
            }] } });
//# sourceMappingURL=data:application/json;base64,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