import { Component, EventEmitter, Input, Output } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../../services/roles-scopes/abstract-roles-scopes.service";
import * as i2 from "@angular/common";
import * as i3 from "primeng/button";
import * as i4 from "primeng/multiselect";
import * as i5 from "primeng/dropdown";
import * as i6 from "@angular/forms";
import * as i7 from "@ngx-translate/core";
/**
 * select role component
 */
export class PrgSelectRoleComponent {
    /**
     * Constructor
     * @param rolesScopesService
     */
    constructor(rolesScopesService) {
        this.rolesScopesService = rolesScopesService;
        /**
         * allow multi select or not
         */
        this.multipleSelect = false;
        /**
         * field that should be used as an option
         */
        this.optionLabel = 'label';
        /**
         * show search bar or not
         */
        this.showHeader = true;
        /**
         * allow button to confirm selection or not
         */
        this.useButton = false;
        /**
         * Output with the selected roles
         */
        this.onSubmitRolesSelected = new EventEmitter();
        /**
         * Item selectable, if multiple is null else is 1
         */
        this.maxItemsSelectable = 1;
    }
    /**
     * default value selected to single selections
     */
    set defaultSelected(value) {
        if (value) {
            this.roleSelected = value;
        }
    }
    /**
     * ngOnInit
     *
     * set value to [rolesList]{@link #rolesList}
     *
     * call method [getAllRolesAsync]{@link /classes/AbstractRolesScopesService.html#getAllRolesAsync} from services
     */
    ngOnInit() {
        if (!this.rolesList) {
            this.getAllRoles();
        }
    }
    /**
     *this function get all roles
     */
    async getAllRoles() {
        this.rolesList = await this.rolesScopesService.getAllRolesAsync();
    }
    /**
     * This function fire [onSubmitRolesSelected]{@link #onSubmitRolesSelected} output
     */
    sendRolesSelected() {
        if (this.multipleSelect && this.rolesSelected.length > 0) {
            this.onSubmitRolesSelected.emit(this.rolesSelected);
        }
        else if (!this.multipleSelect && this.roleSelected) {
            this.onSubmitRolesSelected.emit(this.roleSelected);
        }
    }
}
PrgSelectRoleComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectRoleComponent, deps: [{ token: i1.AbstractRolesScopesService }], target: i0.ɵɵFactoryTarget.Component });
PrgSelectRoleComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSelectRoleComponent, selector: "prg-select-role", inputs: { rolesList: "rolesList", multipleSelect: "multipleSelect", optionLabel: "optionLabel", showHeader: "showHeader", useButton: "useButton", defaultSelected: "defaultSelected" }, outputs: { onSubmitRolesSelected: "onSubmitRolesSelected" }, ngImport: i0, template: "<div>\r\n  <ng-container *ngIf=\"multipleSelect; else elseBlock\">\r\n    <p-multiSelect\r\n      [options]=\"rolesList\"\r\n      [(ngModel)]=\"rolesSelected\"\r\n      [optionLabel]=\"optionLabel\"\r\n      defaultLabel=\"{{\r\n        'components.roles-scopes.select-role.label' | translate\r\n      }}\"\r\n      [showHeader]=\"showHeader\"\r\n      (ngModelChange)=\"sendRolesSelected()\"\r\n      selectedItemsLabel=\"{{\r\n        'components.roles-scopes.select-role.roles-selected.label' | translate\r\n      }}\"\r\n      [maxSelectedLabels]=\"1\"\r\n    ></p-multiSelect>\r\n\r\n    <button\r\n      pButton\r\n      *ngIf=\"useButton\"\r\n      type=\"button\"\r\n      label=\"{{ 'buttons.select.label' | translate }}\"\r\n      (click)=\"sendRolesSelected()\"\r\n      [disabled]=\"!(rolesSelected.length > 0)\"\r\n    ></button>\r\n  </ng-container>\r\n  <ng-template #elseBlock>\r\n    <p-dropdown\r\n      [options]=\"rolesList\"\r\n      [(ngModel)]=\"roleSelected\"\r\n      [optionLabel]=\"optionLabel\"\r\n      placeholder=\"{{\r\n        'components.roles-scopes.select-role.label' | translate\r\n      }}\"\r\n      (ngModelChange)=\"sendRolesSelected()\"\r\n      [filter]=\"true\"\r\n      filterBy=\"name\"\r\n    ></p-dropdown>\r\n  </ng-template>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i3.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i4.MultiSelect, selector: "p-multiSelect", inputs: ["style", "styleClass", "panelStyle", "panelStyleClass", "inputId", "disabled", "readonly", "group", "filter", "filterPlaceHolder", "filterLocale", "overlayVisible", "tabindex", "appendTo", "dataKey", "name", "label", "ariaLabelledBy", "displaySelectedLabel", "maxSelectedLabels", "selectionLimit", "selectedItemsLabel", "showToggleAll", "emptyFilterMessage", "emptyMessage", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "showHeader", "autoZIndex", "baseZIndex", "filterBy", "scrollHeight", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "filterMatchMode", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "display", "autocomplete", "showClear", "defaultLabel", "placeholder", "options", "filterValue", "itemSize"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onClear", "onPanelShow", "onPanelHide", "onLazyLoad"] }, { kind: "component", type: i5.Dropdown, selector: "p-dropdown", inputs: ["scrollHeight", "filter", "name", "style", "panelStyle", "styleClass", "panelStyleClass", "readonly", "required", "editable", "appendTo", "tabindex", "placeholder", "filterPlaceholder", "filterLocale", "inputId", "selectId", "dataKey", "filterBy", "autofocus", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "autoDisplayFirst", "group", "showClear", "emptyFilterMessage", "emptyMessage", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "autoZIndex", "baseZIndex", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "ariaLabel", "ariaLabelledBy", "filterMatchMode", "maxlength", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "disabled", "itemSize", "options", "filterValue"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onShow", "onHide", "onClear", "onLazyLoad"] }, { kind: "directive", type: i6.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i6.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "pipe", type: i7.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSelectRoleComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-select-role', template: "<div>\r\n  <ng-container *ngIf=\"multipleSelect; else elseBlock\">\r\n    <p-multiSelect\r\n      [options]=\"rolesList\"\r\n      [(ngModel)]=\"rolesSelected\"\r\n      [optionLabel]=\"optionLabel\"\r\n      defaultLabel=\"{{\r\n        'components.roles-scopes.select-role.label' | translate\r\n      }}\"\r\n      [showHeader]=\"showHeader\"\r\n      (ngModelChange)=\"sendRolesSelected()\"\r\n      selectedItemsLabel=\"{{\r\n        'components.roles-scopes.select-role.roles-selected.label' | translate\r\n      }}\"\r\n      [maxSelectedLabels]=\"1\"\r\n    ></p-multiSelect>\r\n\r\n    <button\r\n      pButton\r\n      *ngIf=\"useButton\"\r\n      type=\"button\"\r\n      label=\"{{ 'buttons.select.label' | translate }}\"\r\n      (click)=\"sendRolesSelected()\"\r\n      [disabled]=\"!(rolesSelected.length > 0)\"\r\n    ></button>\r\n  </ng-container>\r\n  <ng-template #elseBlock>\r\n    <p-dropdown\r\n      [options]=\"rolesList\"\r\n      [(ngModel)]=\"roleSelected\"\r\n      [optionLabel]=\"optionLabel\"\r\n      placeholder=\"{{\r\n        'components.roles-scopes.select-role.label' | translate\r\n      }}\"\r\n      (ngModelChange)=\"sendRolesSelected()\"\r\n      [filter]=\"true\"\r\n      filterBy=\"name\"\r\n    ></p-dropdown>\r\n  </ng-template>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.AbstractRolesScopesService }]; }, propDecorators: { rolesList: [{
                type: Input
            }], multipleSelect: [{
                type: Input
            }], optionLabel: [{
                type: Input
            }], showHeader: [{
                type: Input
            }], useButton: [{
                type: Input
            }], defaultSelected: [{
                type: Input,
                args: ['defaultSelected']
            }], onSubmitRolesSelected: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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