import { Component } from "@angular/core";
import { Role } from "../../../models/role.model";
import * as i0 from "@angular/core";
import * as i1 from "@ionic/angular";
import * as i2 from "primeng/inputtext";
import * as i3 from "primeng/button";
import * as i4 from "@angular/forms";
import * as i5 from "../../roles-select/prg-select-role.component";
import * as i6 from "@ngx-translate/core";
/**
 * Modal create role
 */
export class PrgModalCreateRoleComponent {
    /**
     * constructor
     *
     * @param modalCtrl
     */
    constructor(modalCtrl) {
        this.modalCtrl = modalCtrl;
        /**
         * list of roles to use as a basis for creating a new
         */
        this.rolesSelected = [];
    }
    /**
     * receive output onAction
     *
     * @param roles
     */
    onSubmitRolesSelected(roles) {
        this.rolesSelected = roles;
    }
    /**
     * cancel the creation of the new role
     * @returns
     */
    cancel() {
        return this.modalCtrl.dismiss(null, "cancel");
    }
    /**
     * create of the new role
     *
     * @returns
     */
    createRole() {
        return this.modalCtrl.dismiss(this.createNewRoleObject(), "confirm");
    }
    /**
     * Create new Role object
     *
     * @returns ROle
     */
    createNewRoleObject() {
        let newRole = new Role();
        newRole.name = this.newRoleName;
        let scopesAux = [];
        if (this.rolesSelected.length > 0) {
            this.rolesSelected.forEach((element) => {
                if (element.scopes) {
                    scopesAux = scopesAux.concat(element.scopes);
                }
            });
        }
        // remove repeats
        const setScopesAux = new Set(scopesAux);
        newRole.scopes = [...setScopesAux];
        return newRole;
    }
}
PrgModalCreateRoleComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgModalCreateRoleComponent, deps: [{ token: i1.ModalController }], target: i0.ɵɵFactoryTarget.Component });
PrgModalCreateRoleComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgModalCreateRoleComponent, selector: "prg-modal-create-role", ngImport: i0, template: "<div>\r\n  <input\r\n    type=\"text\"\r\n    placeholder=\"{{\r\n      'components.roles-scopes.create-role.placeholder' | translate\r\n    }}\"\r\n    [(ngModel)]=\"newRoleName\"\r\n    pInputText\r\n  />\r\n  <p>\r\n    {{ 'components.roles-scopes.create-role.based-roles.label' | translate }}\r\n  </p>\r\n  <prg-select-role\r\n    (onSubmitRolesSelected)=\"onSubmitRolesSelected($event)\"\r\n    [multipleSelect]=\"true\"\r\n  ></prg-select-role>\r\n\r\n  <div>\r\n    <button\r\n      pButton\r\n      type=\"button\"\r\n      label=\"{{ 'buttons.cancel.label' | translate }}\"\r\n      (click)=\"cancel()\"\r\n    ></button>\r\n    <button\r\n      pButton\r\n      type=\"button\"\r\n      label=\"{{ 'buttons.save.label' | translate }}\"\r\n      (click)=\"createRole()\"\r\n      [disabled]=\"!newRoleName\"\r\n    ></button>\r\n  </div>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "directive", type: i2.InputText, selector: "[pInputText]" }, { kind: "directive", type: i3.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "directive", type: i4.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i4.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i4.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "component", type: i5.PrgSelectRoleComponent, selector: "prg-select-role", inputs: ["rolesList", "multipleSelect", "optionLabel", "showHeader", "useButton", "defaultSelected"], outputs: ["onSubmitRolesSelected"] }, { kind: "pipe", type: i6.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgModalCreateRoleComponent, decorators: [{
            type: Component,
            args: [{ selector: "prg-modal-create-role", template: "<div>\r\n  <input\r\n    type=\"text\"\r\n    placeholder=\"{{\r\n      'components.roles-scopes.create-role.placeholder' | translate\r\n    }}\"\r\n    [(ngModel)]=\"newRoleName\"\r\n    pInputText\r\n  />\r\n  <p>\r\n    {{ 'components.roles-scopes.create-role.based-roles.label' | translate }}\r\n  </p>\r\n  <prg-select-role\r\n    (onSubmitRolesSelected)=\"onSubmitRolesSelected($event)\"\r\n    [multipleSelect]=\"true\"\r\n  ></prg-select-role>\r\n\r\n  <div>\r\n    <button\r\n      pButton\r\n      type=\"button\"\r\n      label=\"{{ 'buttons.cancel.label' | translate }}\"\r\n      (click)=\"cancel()\"\r\n    ></button>\r\n    <button\r\n      pButton\r\n      type=\"button\"\r\n      label=\"{{ 'buttons.save.label' | translate }}\"\r\n      (click)=\"createRole()\"\r\n      [disabled]=\"!newRoleName\"\r\n    ></button>\r\n  </div>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.ModalController }]; } });
//# sourceMappingURL=data:application/json;base64,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