import { Component, EventEmitter, Input, Output } from "@angular/core";
import { PrgModalCreateRoleComponent } from "./prg-modal-create-role/prg-modal-create-role.component";
import * as i0 from "@angular/core";
import * as i1 from "../../services/roles-scopes/abstract-roles-scopes.service";
import * as i2 from "@ionic/angular";
import * as i3 from "primeng/button";
/**
 * Create role component
 */
export class PrgCreateRoleComponent {
    /**
     * constructor
     *
     * @param rolesScopesService
     */
    constructor(rolesScopesService, modalCtrl) {
        this.rolesScopesService = rolesScopesService;
        this.modalCtrl = modalCtrl;
        /**
         * Input placeholder
         */
        this.placeholder = "";
        /**
         * output if the newRole was added successfully
         */
        this.addedNewRole = new EventEmitter();
    }
    /**
     * Create role, this function call service method [createRoleAsync]{@link /classes/AbstractRolesScopesService.html#createRoleAsync}
     */
    createRole(role) {
        this.rolesScopesService.createRoleAsync(role).then((response) => {
            if (response) {
                this.newRoleName = "";
                this.addedNewRole.emit(response);
            }
            else {
                this.addedNewRole.emit(null);
            }
        });
    }
    /**
     * Function to open modal
     *
     * if click to save role call method [createRole]{@link #createRole}
     */
    async openModalCreateRole() {
        const modal = await this.modalCtrl.create({
            component: PrgModalCreateRoleComponent,
        });
        modal.present();
        const { data, role } = await modal.onWillDismiss();
        if (role === "confirm") {
            this.createRole(data);
        }
    }
}
PrgCreateRoleComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCreateRoleComponent, deps: [{ token: i1.AbstractRolesScopesService }, { token: i2.ModalController }], target: i0.ɵɵFactoryTarget.Component });
PrgCreateRoleComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgCreateRoleComponent, selector: "prg-create-role", inputs: { placeholder: "placeholder", buttonLabel: "buttonLabel" }, outputs: { addedNewRole: "addedNewRole" }, ngImport: i0, template: "<div>\r\n  <button\r\n    pButton\r\n    type=\"button\"\r\n    [label]=\"buttonLabel\"\r\n    (click)=\"openModalCreateRole()\"\r\n  ></button>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "directive", type: i3.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgCreateRoleComponent, decorators: [{
            type: Component,
            args: [{ selector: "prg-create-role", template: "<div>\r\n  <button\r\n    pButton\r\n    type=\"button\"\r\n    [label]=\"buttonLabel\"\r\n    (click)=\"openModalCreateRole()\"\r\n  ></button>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.AbstractRolesScopesService }, { type: i2.ModalController }]; }, propDecorators: { placeholder: [{
                type: Input
            }], buttonLabel: [{
                type: Input
            }], addedNewRole: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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