import { Validators } from '@angular/forms';
import { InputTextAreaConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/input-text-area/input-text-area.model';
import { BaseAction, BaseActionKey, } from '../../core/components/dynamic-form/models/base-action';
import { BaseField } from '../../core/components/dynamic-form/models/base-field';
import { ActionName } from '../../core/components/dynamic-form/models/constants/action-names';
import { ControlName } from '../../core/components/dynamic-form/models/constants/control-names';
import { ToolbarSlot } from '../../core/components/dynamic-form/models/constants/toolbar-slots';
/**
 * Constant that defines the fields and actions for the dynamic form query raw
 */
export const QUERIES_RAW_DYNAMIC_FORM = {
    fields: [
        new BaseField({
            controlName: ControlName.inputText,
            value: null,
            key: 'name',
            validators: [Validators.required],
            basePathTranslation: 'queries.fields',
        }),
        new InputTextAreaConfiguration({
            controlName: ControlName.inputTextArea,
            value: null,
            key: 'description',
            validators: [Validators.required],
            basePathTranslation: 'queries.fields',
            cols: 100,
            rows: 2,
            autoResize: true,
        }),
        new InputTextAreaConfiguration({
            controlName: ControlName.inputTextArea,
            value: null,
            key: 'raw',
            validators: [Validators.required],
            basePathTranslation: 'queries.fields',
            cols: 100,
            rows: 2,
            autoResize: true,
        }),
    ],
    actions: [
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Save,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='read'",
        }),
    ],
};
//# sourceMappingURL=data:application/json;base64,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