import { Validators } from '@angular/forms';
import { InputTextAreaConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/input-text-area/input-text-area.model';
import { SelectConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/select/select.model';
import { BaseAction, BaseActionKey, } from '../../core/components/dynamic-form/models/base-action';
import { BaseField } from '../../core/components/dynamic-form/models/base-field';
import { ActionName } from '../../core/components/dynamic-form/models/constants/action-names';
import { ControlName } from '../../core/components/dynamic-form/models/constants/control-names';
import { ReferenceType } from '../../core/components/dynamic-form/models/constants/reference-type';
import { ToolbarSlot } from '../../core/components/dynamic-form/models/constants/toolbar-slots';
/**
 * Constant that defines the fields and actions for the dynamic form query filter
 */
export const QUERIES_FILTER_DYNAMIC_FORM = {
    fields: [
        new BaseField({
            controlName: ControlName.inputText,
            value: null,
            key: 'name',
            validators: [Validators.required],
            basePathTranslation: 'queries.fields',
        }),
        new InputTextAreaConfiguration({
            controlName: ControlName.inputTextArea,
            value: null,
            key: 'description',
            validators: [Validators.required],
            basePathTranslation: 'queries.fields',
            cols: 100,
            rows: 2,
            autoResize: true,
        }),
        new SelectConfiguration({
            referenceType: ReferenceType.EntityType,
            key: 'entityTypeId',
            validators: [Validators.required],
            optionLabel: 'label',
            optionValue: 'id',
            showClear: true,
            basePathTranslation: 'queries.fields',
            disabledOutputEvent: false,
        }),
    ],
    actions: [
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Save,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Right,
            visibleExpression: "this.viewMode==='read'",
        }),
    ],
};
//# sourceMappingURL=data:application/json;base64,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