import { NgModule } from '@angular/core';
import { DialogService } from 'primeng/dynamicdialog';
import { PrgCoreDynamicFormModule } from '../core/components/dynamic-form/prg-core-dynamic-form.module';
import { PrgSharedComponentsModule } from '../shared-components/shared-components.module';
import { PrgQueriesTableComponent } from './components/queries-table/prg-queries-table.component';
import { PrgQueryModalComponent } from './components/query-modal/prg-query-modal.component';
import { MockQueriesService } from './mock/services/queries.service.mock';
import { PrgQueriesPage } from './pages/prg-queries.page';
import { PrgQueriesRoutingModule } from './prg-queries-routing.module';
import { PRG_QUERIES_CONFIG } from './services/prg-queries-configuration/prg-queries-configuration.service';
import { AbstractQueriesService } from './services/queries/abstract-queries.service';
import { QueriesService } from './services/queries/queries.service';
import * as i0 from "@angular/core";
export class PrgQueriesModule {
    constructor(injector) {
        this.injector = injector;
        appInjector = this.injector;
    }
    static forRoot(prgQueriesConfig) {
        queriesConfig = prgQueriesConfig;
        return {
            ngModule: PrgQueriesModule,
            providers: [
                {
                    provide: PRG_QUERIES_CONFIG,
                    useValue: prgQueriesConfig,
                },
                {
                    provide: AbstractQueriesService,
                    useClass: prgQueriesConfig.useMockServices
                        ? MockQueriesService
                        : QueriesService,
                },
            ],
        };
    }
}
PrgQueriesModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgQueriesModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesModule, declarations: [PrgQueriesTableComponent,
        PrgQueryModalComponent,
        PrgQueriesPage,
        PrgQueryModalComponent], imports: [PrgQueriesRoutingModule,
        PrgSharedComponentsModule,
        PrgCoreDynamicFormModule] });
PrgQueriesModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesModule, providers: [DialogService], imports: [PrgQueriesRoutingModule,
        PrgSharedComponentsModule,
        PrgCoreDynamicFormModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgQueriesModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        PrgQueriesTableComponent,
                        PrgQueryModalComponent,
                        PrgQueriesPage,
                        PrgQueryModalComponent,
                    ],
                    imports: [
                        PrgQueriesRoutingModule,
                        PrgSharedComponentsModule,
                        PrgCoreDynamicFormModule,
                    ],
                    exports: [],
                    providers: [DialogService],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
export let appInjector;
/**
 * Exports the QueriesCoreConfig object
 */
export let queriesConfig;
//# sourceMappingURL=data:application/json;base64,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