var _a;
import { BaseEntity } from '../../core/models/base-entity.model';
/**
 * QueryOrderType enum
 */
export var QueryOrderType;
(function (QueryOrderType) {
    QueryOrderType[QueryOrderType["Ascending"] = 0] = "Ascending";
    QueryOrderType[QueryOrderType["Descending"] = 1] = "Descending";
})(QueryOrderType || (QueryOrderType = {}));
/**
 * QueryFilterExpression enum
 */
export var QueryFilterExpression;
(function (QueryFilterExpression) {
    QueryFilterExpression["And"] = "And";
    QueryFilterExpression["Or"] = "Or";
})(QueryFilterExpression || (QueryFilterExpression = {}));
/**
 * QueryFilterOperation enum
 */
export var QueryFilterOperation;
(function (QueryFilterOperation) {
    QueryFilterOperation["EqualTo"] = "EqualTo";
    QueryFilterOperation["NotEqualTo"] = "NotEqualTo";
    QueryFilterOperation["GreaterThan"] = "GreaterThan";
    QueryFilterOperation["GreaterThanOrEqualTo"] = "GreaterThanOrEqualTo";
    QueryFilterOperation["LessThan"] = "LessThan";
    QueryFilterOperation["LessThanOrEqualTo"] = "LessThanOrEqualTo";
    QueryFilterOperation["Between"] = "Between";
    QueryFilterOperation["Contains"] = "Contains";
    QueryFilterOperation["DoesNotContain"] = "DoesNotContain";
    QueryFilterOperation["EndsWith"] = "EndsWith";
    QueryFilterOperation["In"] = "In";
    QueryFilterOperation["IsEmpty"] = "IsEmpty";
    QueryFilterOperation["IsNotEmpty"] = "IsNotEmpty";
    QueryFilterOperation["IsNotNull"] = "IsNotNull";
    QueryFilterOperation["IsNotNullNorWhiteSpace"] = "IsNotNullNorWhiteSpace";
    QueryFilterOperation["IsNull"] = "IsNull";
    QueryFilterOperation["IsNullOrWhiteSpace"] = "IsNullOrWhiteSpace";
    QueryFilterOperation["StartsWith"] = "StartsWith";
    QueryFilterOperation["NotIn"] = "NotIn";
})(QueryFilterOperation || (QueryFilterOperation = {}));
/**
 * QueryFilterOperationByType class that defines allowed filters operations
 * for a datatype through static properties
 */
export class QueryFilterOperationByType {
    /**
     * Function that returns the number of fields required for a query filter operation
     * send by parameter
     * @param queryFilterOperation
     */
    numberOfFields(queryFilterOperation) {
        return queryFilterOperation === QueryFilterOperation.Between ? 2 : 1;
    }
}
_a = QueryFilterOperationByType;
/**
 * Static property to define filter operations for data type "default"
 */
QueryFilterOperationByType.default = [
    QueryFilterOperation.IsNull,
    QueryFilterOperation.IsEmpty,
    QueryFilterOperation.IsNotEmpty,
    QueryFilterOperation.IsNotNull,
];
/**
 * Static property to define filter operations for data type "string"
 */
QueryFilterOperationByType.string = [
    ..._a.default,
    QueryFilterOperation.Contains,
    QueryFilterOperation.DoesNotContain,
    QueryFilterOperation.StartsWith,
    QueryFilterOperation.EndsWith,
];
/**
 * Static property to define filter operations for data type "date"
 */
QueryFilterOperationByType.date = [..._a.default, QueryFilterOperation.Between];
/**
 * Static property to define filter operations for data type "number"
 */
QueryFilterOperationByType.number = [
    ..._a.default,
    QueryFilterOperation.Between,
    QueryFilterOperation.EqualTo,
    QueryFilterOperation.NotEqualTo,
    QueryFilterOperation.LessThan,
    QueryFilterOperation.LessThanOrEqualTo,
    QueryFilterOperation.GreaterThan,
    QueryFilterOperation.GreaterThanOrEqualTo,
];
/**
 * QueryColumn class that defines query results'
 * <br />properties and order
 */
export class QueryColumn extends BaseEntity {
    /**
     * Constructor
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/**
 * QueryFilter class that defines filters
 * <br/>for non-raw queries
 */
export class QueryFilter extends BaseEntity {
    /**
     * Constructor
     * @param {Partial<QueryFilter>} init
     */
    constructor(init) {
        super();
        /**
         * Filter operation
         */
        this.filterOperation = QueryFilterOperation.Contains;
        /**
         * Filter expression
         */
        this.filterExpression = QueryFilterExpression.And;
        Object.assign(this, init);
    }
}
/**
 * QueryOrder class that defines the query
 * <br />ordenation
 */
export class QueryOrder extends BaseEntity {
    /**
     * Constructor
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/**
 * Query class that defines a generic query
 * <br />to be executed on the database
 */
export class Query extends BaseEntity {
    /**
     * Constructor
     */
    constructor(init) {
        super();
        /**
         * Is raw (sql command) query
         */
        this.isRaw = true;
        Object.assign(this, init);
    }
}
//# sourceMappingURL=data:application/json;base64,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