import { Validators } from '@angular/forms';
import { BaseField } from '../../core/components/dynamic-form/models/base-field';
import { QueryFilterExpression } from './query.model';
/**
 * Class to be used on the map of Query Filter to link fields to operators and data type
 */
export class OperatorsAndDataType {
}
/**
 * Constant that defines the properties for each column of the Queries Filter table
 */
export const QueriesFilterColumns = [
    new BaseField({
        key: 'startGroup',
        validators: [Validators.required],
        value: true,
        readonly: true,
        basePathTranslation: 'queries.fields.query-filter.fields.',
    }),
    new BaseField({
        key: 'propertyName',
        validators: [Validators.required],
        readonly: true,
        basePathTranslation: 'queries.fields.query-filter.fields.',
    }),
    new BaseField({
        key: 'filterOperation',
        validators: [Validators.required],
        readonly: true,
        basePathTranslation: 'queries.fields.query-filter.fields.',
    }),
    new BaseField({
        key: 'value',
        validators: [Validators.required],
        readonly: true,
        basePathTranslation: 'queries.fields.query-filter.fields.',
    }),
    new BaseField({
        key: 'value2',
        readonly: true,
        basePathTranslation: 'queries.fields.query-filter.fields.',
    }),
    new BaseField({
        key: 'query-filter-row-actions',
        readonly: true,
        basePathTranslation: 'queries.query-modal.actions.',
    }),
    new BaseField({
        key: 'filterExpression',
        validators: [Validators.required],
        value: QueryFilterExpression.And,
        readonly: true,
        basePathTranslation: 'queries.fields.query-filter.fields.',
    }),
];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicXVlcnktdGFibGUtZmlsdGVyLm1vZGVsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvUHJnRnJhbWV3b3JrLkZFLkNvcmVMaWIvc3JjL2xpYi9tb2R1bGVzL3F1ZXJpZXMvbW9kZWxzL3F1ZXJ5LXRhYmxlLWZpbHRlci5tb2RlbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sZ0JBQWdCLENBQUM7QUFDNUMsT0FBTyxFQUFFLFNBQVMsRUFBRSxNQUFNLHNEQUFzRCxDQUFDO0FBQ2pGLE9BQU8sRUFBRSxxQkFBcUIsRUFBd0IsTUFBTSxlQUFlLENBQUM7QUFFNUU7O0dBRUc7QUFDSCxNQUFNLE9BQU8sb0JBQW9CO0NBU2hDO0FBK0JEOztHQUVHO0FBQ0gsTUFBTSxDQUFDLE1BQU0sb0JBQW9CLEdBQWdCO0lBQy9DLElBQUksU0FBUyxDQUFDO1FBQ1osR0FBRyxFQUFFLFlBQVk7UUFDakIsVUFBVSxFQUFFLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUNqQyxLQUFLLEVBQUUsSUFBSTtRQUNYLFFBQVEsRUFBRSxJQUFJO1FBQ2QsbUJBQW1CLEVBQUUscUNBQXFDO0tBQzNELENBQUM7SUFDRixJQUFJLFNBQVMsQ0FBQztRQUNaLEdBQUcsRUFBRSxjQUFjO1FBQ25CLFVBQVUsRUFBRSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDakMsUUFBUSxFQUFFLElBQUk7UUFDZCxtQkFBbUIsRUFBRSxxQ0FBcUM7S0FDM0QsQ0FBQztJQUNGLElBQUksU0FBUyxDQUFDO1FBQ1osR0FBRyxFQUFFLGlCQUFpQjtRQUN0QixVQUFVLEVBQUUsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ2pDLFFBQVEsRUFBRSxJQUFJO1FBQ2QsbUJBQW1CLEVBQUUscUNBQXFDO0tBQzNELENBQUM7SUFDRixJQUFJLFNBQVMsQ0FBQztRQUNaLEdBQUcsRUFBRSxPQUFPO1FBQ1osVUFBVSxFQUFFLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUNqQyxRQUFRLEVBQUUsSUFBSTtRQUNkLG1CQUFtQixFQUFFLHFDQUFxQztLQUMzRCxDQUFDO0lBQ0YsSUFBSSxTQUFTLENBQUM7UUFDWixHQUFHLEVBQUUsUUFBUTtRQUNiLFFBQVEsRUFBRSxJQUFJO1FBQ2QsbUJBQW1CLEVBQUUscUNBQXFDO0tBQzNELENBQUM7SUFDRixJQUFJLFNBQVMsQ0FBQztRQUNaLEdBQUcsRUFBRSwwQkFBMEI7UUFDL0IsUUFBUSxFQUFFLElBQUk7UUFDZCxtQkFBbUIsRUFBRSw4QkFBOEI7S0FDcEQsQ0FBQztJQUNGLElBQUksU0FBUyxDQUFDO1FBQ1osR0FBRyxFQUFFLGtCQUFrQjtRQUN2QixVQUFVLEVBQUUsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ2pDLEtBQUssRUFBRSxxQkFBcUIsQ0FBQyxHQUFHO1FBQ2hDLFFBQVEsRUFBRSxJQUFJO1FBQ2QsbUJBQW1CLEVBQUUscUNBQXFDO0tBQzNELENBQUM7Q0FDSCxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVmFsaWRhdG9ycyB9IGZyb20gJ0Bhbmd1bGFyL2Zvcm1zJztcclxuaW1wb3J0IHsgQmFzZUZpZWxkIH0gZnJvbSAnLi4vLi4vY29yZS9jb21wb25lbnRzL2R5bmFtaWMtZm9ybS9tb2RlbHMvYmFzZS1maWVsZCc7XHJcbmltcG9ydCB7IFF1ZXJ5RmlsdGVyRXhwcmVzc2lvbiwgUXVlcnlGaWx0ZXJPcGVyYXRpb24gfSBmcm9tICcuL3F1ZXJ5Lm1vZGVsJztcclxuXHJcbi8qKlxyXG4gKiBDbGFzcyB0byBiZSB1c2VkIG9uIHRoZSBtYXAgb2YgUXVlcnkgRmlsdGVyIHRvIGxpbmsgZmllbGRzIHRvIG9wZXJhdG9ycyBhbmQgZGF0YSB0eXBlXHJcbiAqL1xyXG5leHBvcnQgY2xhc3MgT3BlcmF0b3JzQW5kRGF0YVR5cGUge1xyXG4gIC8qKlxyXG4gICAqIEFsbG93ZWQgb3BlcmF0aW9uIHR5cGVzIGZvciB0aGUgc2VsZWN0ZWQgZmllbGRcclxuICAgKi9cclxuICBwdWJsaWMgcXVlcnlGaWx0ZXJPcGVyYXRpb25CeVR5cGU6IEZpbHRlck9wZXJhdGlvbkJ5VHlwZVRvVHJhbnNsYXRlW107XHJcbiAgLyoqXHJcbiAgICogVGhlIGRhdGEgdHlwZSBmb3IgdGhlIHNlbGVjdGVkIGZpZWxkXHJcbiAgICovXHJcbiAgcHVibGljIGRhdGFUeXBlOiBzdHJpbmc7XHJcbn1cclxuXHJcbi8qKlxyXG4gKiBJbnRlcmZhY2UgdGhhdCBkZWZpbmVzIHRoZSBmaWx0ZXJzIGV4cHJlc3Npb25zIGFuZCBoaXMgbGFiZWxzIHRvIGJlIGFibGUgdG8gdHJhbnNsYXRlIHRoZW1cclxuICovXHJcbmV4cG9ydCBpbnRlcmZhY2UgRmlsdGVyRXhwcmVzc2lvblRvVHJhbnNsYXRlIHtcclxuICAvKipcclxuICAgKiBGaWx0ZXJzIEV4cHJlc3Npb25cclxuICAgKi9cclxuICBleHByZXNzaW9uOiBRdWVyeUZpbHRlckV4cHJlc3Npb247XHJcbiAgLyoqXHJcbiAgICogRGVmaW5lIGxhYmVsIHRvIGJlIHVzZSBpbiB0ZW1wbGF0ZSB0byB0cmFuc2xhdGVcclxuICAgKi9cclxuICBsYWJlbDogc3RyaW5nO1xyXG59XHJcblxyXG4vKipcclxuICogSW50ZXJmYWNlIHRoYXQgZGVmaW5lcyB0aGUgZmlsdGVycyBvcGVyYXRvcnMgYW5kIGhpcyBsYWJlbHMgdG8gYmUgdXNlIG9uIE9wZXJhdG9yc0FuZERhdGFUeXBlIGNsYXNzXHJcbiAqIGFuZCB0cmFuc2xhdGUgdGhlbVxyXG4gKi9cclxuZXhwb3J0IGludGVyZmFjZSBGaWx0ZXJPcGVyYXRpb25CeVR5cGVUb1RyYW5zbGF0ZSB7XHJcbiAgLyoqXHJcbiAgICogT3BlcmF0b3JzIGZpbHRlcnNcclxuICAgKi9cclxuICBvcGVyYXRvcnM6IFF1ZXJ5RmlsdGVyT3BlcmF0aW9uO1xyXG4gIC8qKlxyXG4gICAqIERlZmluZSBsYWJlbCB0byBiZSB1c2UgaW4gdGVtcGxhdGUgdG8gdHJhbnNsYXRlXHJcbiAgICovXHJcbiAgbGFiZWw6IHN0cmluZztcclxufVxyXG5cclxuLyoqXHJcbiAqIENvbnN0YW50IHRoYXQgZGVmaW5lcyB0aGUgcHJvcGVydGllcyBmb3IgZWFjaCBjb2x1bW4gb2YgdGhlIFF1ZXJpZXMgRmlsdGVyIHRhYmxlXHJcbiAqL1xyXG5leHBvcnQgY29uc3QgUXVlcmllc0ZpbHRlckNvbHVtbnM6IEJhc2VGaWVsZFtdID0gW1xyXG4gIG5ldyBCYXNlRmllbGQoe1xyXG4gICAga2V5OiAnc3RhcnRHcm91cCcsXHJcbiAgICB2YWxpZGF0b3JzOiBbVmFsaWRhdG9ycy5yZXF1aXJlZF0sXHJcbiAgICB2YWx1ZTogdHJ1ZSxcclxuICAgIHJlYWRvbmx5OiB0cnVlLFxyXG4gICAgYmFzZVBhdGhUcmFuc2xhdGlvbjogJ3F1ZXJpZXMuZmllbGRzLnF1ZXJ5LWZpbHRlci5maWVsZHMuJyxcclxuICB9KSxcclxuICBuZXcgQmFzZUZpZWxkKHtcclxuICAgIGtleTogJ3Byb3BlcnR5TmFtZScsXHJcbiAgICB2YWxpZGF0b3JzOiBbVmFsaWRhdG9ycy5yZXF1aXJlZF0sXHJcbiAgICByZWFkb25seTogdHJ1ZSxcclxuICAgIGJhc2VQYXRoVHJhbnNsYXRpb246ICdxdWVyaWVzLmZpZWxkcy5xdWVyeS1maWx0ZXIuZmllbGRzLicsXHJcbiAgfSksXHJcbiAgbmV3IEJhc2VGaWVsZCh7XHJcbiAgICBrZXk6ICdmaWx0ZXJPcGVyYXRpb24nLFxyXG4gICAgdmFsaWRhdG9yczogW1ZhbGlkYXRvcnMucmVxdWlyZWRdLFxyXG4gICAgcmVhZG9ubHk6IHRydWUsXHJcbiAgICBiYXNlUGF0aFRyYW5zbGF0aW9uOiAncXVlcmllcy5maWVsZHMucXVlcnktZmlsdGVyLmZpZWxkcy4nLFxyXG4gIH0pLFxyXG4gIG5ldyBCYXNlRmllbGQoe1xyXG4gICAga2V5OiAndmFsdWUnLFxyXG4gICAgdmFsaWRhdG9yczogW1ZhbGlkYXRvcnMucmVxdWlyZWRdLFxyXG4gICAgcmVhZG9ubHk6IHRydWUsXHJcbiAgICBiYXNlUGF0aFRyYW5zbGF0aW9uOiAncXVlcmllcy5maWVsZHMucXVlcnktZmlsdGVyLmZpZWxkcy4nLFxyXG4gIH0pLFxyXG4gIG5ldyBCYXNlRmllbGQoe1xyXG4gICAga2V5OiAndmFsdWUyJyxcclxuICAgIHJlYWRvbmx5OiB0cnVlLFxyXG4gICAgYmFzZVBhdGhUcmFuc2xhdGlvbjogJ3F1ZXJpZXMuZmllbGRzLnF1ZXJ5LWZpbHRlci5maWVsZHMuJyxcclxuICB9KSxcclxuICBuZXcgQmFzZUZpZWxkKHtcclxuICAgIGtleTogJ3F1ZXJ5LWZpbHRlci1yb3ctYWN0aW9ucycsXHJcbiAgICByZWFkb25seTogdHJ1ZSxcclxuICAgIGJhc2VQYXRoVHJhbnNsYXRpb246ICdxdWVyaWVzLnF1ZXJ5LW1vZGFsLmFjdGlvbnMuJyxcclxuICB9KSxcclxuICBuZXcgQmFzZUZpZWxkKHtcclxuICAgIGtleTogJ2ZpbHRlckV4cHJlc3Npb24nLFxyXG4gICAgdmFsaWRhdG9yczogW1ZhbGlkYXRvcnMucmVxdWlyZWRdLFxyXG4gICAgdmFsdWU6IFF1ZXJ5RmlsdGVyRXhwcmVzc2lvbi5BbmQsXHJcbiAgICByZWFkb25seTogdHJ1ZSxcclxuICAgIGJhc2VQYXRoVHJhbnNsYXRpb246ICdxdWVyaWVzLmZpZWxkcy5xdWVyeS1maWx0ZXIuZmllbGRzLicsXHJcbiAgfSksXHJcbl07XHJcbiJdfQ==