import { Inject, Injectable } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { PrgError } from '../../../core/models/error.model';
import { PrgSucess } from '../../../core/models/success.model';
import { AbstractQueriesService } from '../../services/queries/abstract-queries.service';
import { QueriesBDMOCK } from '../database.mock';
import * as i0 from "@angular/core";
import * as i1 from "../../../core/services/notifications/notifications.service";
import * as i2 from "../../../core/services/utility/utility.service";
import * as i3 from "../../../core/services/is-loading-data/isloadingdata.service";
import * as i4 from "../../../core/services/utility/objects-utility.service";
import * as i5 from "../../../core/services/utility/array-utility.service";
import * as i6 from "../../../auth/services/auth/abstract-auth.service";
import * as i7 from "@ngx-translate/core";
/**
 * Injectable
 */
/**
 * MOCK AbstractQueriesService implementation
 */
export class MockQueriesService extends AbstractQueriesService {
    /**
     * constructor
     * @param {NotificationsService} notificationsService
     * @param {UtilityService} utilityService
     * @param {IsLoadingDataService} isLoadingData
     * @param {ObjectsUtilityService} objectUtility
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {AbstractAuthService} authService
     * @param {TranslateService} translateService
     */
    constructor(notificationsService, utilityService, isLoadingData, objectUtility, arrayUtilityService, authService, translateService) {
        super(translateService);
        this.notificationsService = notificationsService;
        this.utilityService = utilityService;
        this.isLoadingData = isLoadingData;
        this.objectUtility = objectUtility;
        this.arrayUtilityService = arrayUtilityService;
        this.authService = authService;
        /**
         * default time in seconds
         */
        this.sleepTimeSec = 0.5;
    }
    /**
     * Function responsible to store a new query
     * @param {Query} newQuery
     * @returns {Promise<Query>}
     */
    createQueryAsync(newQuery) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            let checkNameQuery = QueriesBDMOCK.Queries.find((query) => newQuery.name === query.name);
            this.isLoadingData.hide();
            if (!checkNameQuery) {
                let query = this.objectUtility.cloneObject(newQuery);
                query['createdBy'] = this.authService?.getLoggedUser()?.id;
                query['id'] = this.utilityService.newGuid();
                QueriesBDMOCK.Queries.push(query);
                const queriesUpdated = this.arrayUtilityService.clone(QueriesBDMOCK.Queries);
                await this.setQueriesChanged(queriesUpdated);
                resolve(query);
                this.notificationsService.successNotification(new PrgSucess({
                    titleKey: 'New Query Created.',
                    detailKey: 'Success.',
                }));
            }
            else {
                reject('Queries could not be loaded');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Query not save.',
                    detailKey: 'Query name already exists in database',
                }));
            }
        });
    }
    /**
     * Function responsible to update a query
     * @param {string} queryId
     * @param {Query} queryUpdated
     * @returns {Promise<Query>}
     */
    updateQueryAsync(queryId, queryUpdated) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const queryIndexToUpdate = QueriesBDMOCK.Queries.findIndex((query) => {
                return query.id == queryId;
            });
            if (queryIndexToUpdate > -1) {
                QueriesBDMOCK.Queries[queryIndexToUpdate] = queryUpdated;
            }
            const queriesUpdated = this.arrayUtilityService.clone(QueriesBDMOCK.Queries);
            await this.setQueriesChanged(queriesUpdated);
            this.isLoadingData.hide();
            resolve(queryUpdated);
            this.notificationsService.successNotification(new PrgSucess({
                titleKey: 'Query updated.',
                detailKey: 'Success.',
            }));
        });
    }
    /**
     * Get all Queries
     * @returns {Promise<Query[]>}
     */
    getAllQueriesAsync() {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const queries = this.objectUtility.cloneObject(QueriesBDMOCK.Queries);
            this.isLoadingData.hide();
            if (queries) {
                resolve(queries);
            }
            else {
                reject('Queries could not be loaded');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Queries could not be loaded.',
                    detailKey: 'Server is down',
                }));
            }
        });
    }
    /**
     * Get query by Id
     * @param {string} queryId
     * @returns {Promise<Query>}
     */
    getQueryByIdAsync(queryId) {
        return new Promise(async (resolve, reject) => {
            this.isLoadingData.show();
            await this.utilityService.sleepSecAsync(this.sleepTimeSec);
            const query = this.objectUtility.cloneObject(QueriesBDMOCK.Queries.find((query) => {
                return query.id === queryId;
            }));
            this.isLoadingData.hide();
            if (query) {
                resolve(query);
            }
            else {
                reject('Query could not be loaded');
                this.notificationsService.errorNotification(new PrgError({
                    titleKey: 'Query could not be loaded.',
                    detailKey: 'Server is down',
                }));
            }
        });
    }
}
MockQueriesService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockQueriesService, deps: [{ token: i1.NotificationsService }, { token: i2.UtilityService }, { token: i3.IsLoadingDataService }, { token: i4.ObjectsUtilityService }, { token: i5.ArrayUtilityService }, { token: i6.AbstractAuthService }, { token: TranslateService }], target: i0.ɵɵFactoryTarget.Injectable });
MockQueriesService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockQueriesService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MockQueriesService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: i1.NotificationsService }, { type: i2.UtilityService }, { type: i3.IsLoadingDataService }, { type: i4.ObjectsUtilityService }, { type: i5.ArrayUtilityService }, { type: i6.AbstractAuthService }, { type: i7.TranslateService, decorators: [{
                    type: Inject,
                    args: [TranslateService]
                }] }]; } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicXVlcmllcy5zZXJ2aWNlLm1vY2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9QcmdGcmFtZXdvcmsuRkUuQ29yZUxpYi9zcmMvbGliL21vZHVsZXMvcXVlcmllcy9tb2NrL3NlcnZpY2VzL3F1ZXJpZXMuc2VydmljZS5tb2NrLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxNQUFNLEVBQUUsVUFBVSxFQUFFLE1BQU0sZUFBZSxDQUFDO0FBQ25ELE9BQU8sRUFBRSxnQkFBZ0IsRUFBRSxNQUFNLHFCQUFxQixDQUFDO0FBRXZELE9BQU8sRUFBRSxRQUFRLEVBQUUsTUFBTSxrQ0FBa0MsQ0FBQztBQUM1RCxPQUFPLEVBQUUsU0FBUyxFQUFFLE1BQU0sb0NBQW9DLENBQUM7QUFPL0QsT0FBTyxFQUFFLHNCQUFzQixFQUFFLE1BQU0saURBQWlELENBQUM7QUFDekYsT0FBTyxFQUFFLGFBQWEsRUFBRSxNQUFNLGtCQUFrQixDQUFDOzs7Ozs7Ozs7QUFFakQ7O0dBRUc7QUFLSDs7R0FFRztBQUNILE1BQU0sT0FBTyxrQkFBbUIsU0FBUSxzQkFBc0I7SUFNNUQ7Ozs7Ozs7OztPQVNHO0lBQ0gsWUFDVSxvQkFBMEMsRUFDMUMsY0FBOEIsRUFDOUIsYUFBbUMsRUFDbkMsYUFBb0MsRUFDcEMsbUJBQXdDLEVBQ3hDLFdBQWdDLEVBQ2QsZ0JBQWtDO1FBRTVELEtBQUssQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBUmhCLHlCQUFvQixHQUFwQixvQkFBb0IsQ0FBc0I7UUFDMUMsbUJBQWMsR0FBZCxjQUFjLENBQWdCO1FBQzlCLGtCQUFhLEdBQWIsYUFBYSxDQUFzQjtRQUNuQyxrQkFBYSxHQUFiLGFBQWEsQ0FBdUI7UUFDcEMsd0JBQW1CLEdBQW5CLG1CQUFtQixDQUFxQjtRQUN4QyxnQkFBVyxHQUFYLFdBQVcsQ0FBcUI7UUFyQjFDOztXQUVHO1FBQ0ssaUJBQVksR0FBRyxHQUFHLENBQUM7SUFzQjNCLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksZ0JBQWdCLENBQUMsUUFBZTtRQUNyQyxPQUFPLElBQUksT0FBTyxDQUFRLEtBQUssRUFBRSxPQUFPLEVBQUUsTUFBTSxFQUFFLEVBQUU7WUFDbEQsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUMxQixNQUFNLElBQUksQ0FBQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQztZQUMzRCxJQUFJLGNBQWMsR0FBRyxhQUFhLENBQUMsT0FBTyxDQUFDLElBQUksQ0FDN0MsQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEtBQUssS0FBSyxDQUFDLElBQUksQ0FDeEMsQ0FBQztZQUNGLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxFQUFFLENBQUM7WUFFMUIsSUFBSSxDQUFDLGNBQWMsRUFBRTtnQkFDbkIsSUFBSSxLQUFLLEdBQVUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLENBQUMsUUFBUSxDQUFDLENBQUM7Z0JBQzVELEtBQUssQ0FBQyxXQUFXLENBQUMsR0FBRyxJQUFJLENBQUMsV0FBVyxFQUFFLGFBQWEsRUFBRSxFQUFFLEVBQUUsQ0FBQztnQkFDM0QsS0FBSyxDQUFDLElBQUksQ0FBQyxHQUFHLElBQUksQ0FBQyxjQUFjLENBQUMsT0FBTyxFQUFFLENBQUM7Z0JBRTVDLGFBQWEsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO2dCQUNsQyxNQUFNLGNBQWMsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxDQUNuRCxhQUFhLENBQUMsT0FBTyxDQUN0QixDQUFDO2dCQUNGLE1BQU0sSUFBSSxDQUFDLGlCQUFpQixDQUFDLGNBQWMsQ0FBQyxDQUFDO2dCQUM3QyxPQUFPLENBQUMsS0FBSyxDQUFDLENBQUM7Z0JBQ2YsSUFBSSxDQUFDLG9CQUFvQixDQUFDLG1CQUFtQixDQUMzQyxJQUFJLFNBQVMsQ0FBQztvQkFDWixRQUFRLEVBQUUsb0JBQW9CO29CQUM5QixTQUFTLEVBQUUsVUFBVTtpQkFDdEIsQ0FBQyxDQUNILENBQUM7YUFDSDtpQkFBTTtnQkFDTCxNQUFNLENBQUMsNkJBQTZCLENBQUMsQ0FBQztnQkFDdEMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLGlCQUFpQixDQUN6QyxJQUFJLFFBQVEsQ0FBQztvQkFDWCxRQUFRLEVBQUUsaUJBQWlCO29CQUMzQixTQUFTLEVBQUUsdUNBQXVDO2lCQUNuRCxDQUFDLENBQ0gsQ0FBQzthQUNIO1FBQ0gsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQ7Ozs7O09BS0c7SUFDSSxnQkFBZ0IsQ0FDckIsT0FBZSxFQUNmLFlBQW1CO1FBRW5CLE9BQU8sSUFBSSxPQUFPLENBQVEsS0FBSyxFQUFFLE9BQU8sRUFBRSxNQUFNLEVBQUUsRUFBRTtZQUNsRCxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksRUFBRSxDQUFDO1lBQzFCLE1BQU0sSUFBSSxDQUFDLGNBQWMsQ0FBQyxhQUFhLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxDQUFDO1lBRTNELE1BQU0sa0JBQWtCLEdBQVcsYUFBYSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQ2hFLENBQUMsS0FBSyxFQUFFLEVBQUU7Z0JBQ1IsT0FBTyxLQUFLLENBQUMsRUFBRSxJQUFJLE9BQU8sQ0FBQztZQUM3QixDQUFDLENBQ0YsQ0FBQztZQUNGLElBQUksa0JBQWtCLEdBQUcsQ0FBQyxDQUFDLEVBQUU7Z0JBQzNCLGFBQWEsQ0FBQyxPQUFPLENBQUMsa0JBQWtCLENBQUMsR0FBRyxZQUFZLENBQUM7YUFDMUQ7WUFFRCxNQUFNLGNBQWMsR0FBRyxJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxDQUNuRCxhQUFhLENBQUMsT0FBTyxDQUN0QixDQUFDO1lBQ0YsTUFBTSxJQUFJLENBQUMsaUJBQWlCLENBQUMsY0FBYyxDQUFDLENBQUM7WUFDN0MsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUMxQixPQUFPLENBQUMsWUFBWSxDQUFDLENBQUM7WUFDdEIsSUFBSSxDQUFDLG9CQUFvQixDQUFDLG1CQUFtQixDQUMzQyxJQUFJLFNBQVMsQ0FBQztnQkFDWixRQUFRLEVBQUUsZ0JBQWdCO2dCQUMxQixTQUFTLEVBQUUsVUFBVTthQUN0QixDQUFDLENBQ0gsQ0FBQztRQUNKLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVEOzs7T0FHRztJQUNJLGtCQUFrQjtRQUN2QixPQUFPLElBQUksT0FBTyxDQUFVLEtBQUssRUFBRSxPQUFPLEVBQUUsTUFBTSxFQUFFLEVBQUU7WUFDcEQsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUMxQixNQUFNLElBQUksQ0FBQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQztZQUMzRCxNQUFNLE9BQU8sR0FBWSxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FDckQsYUFBYSxDQUFDLE9BQU8sQ0FDdEIsQ0FBQztZQUNGLElBQUksQ0FBQyxhQUFhLENBQUMsSUFBSSxFQUFFLENBQUM7WUFDMUIsSUFBSSxPQUFPLEVBQUU7Z0JBQ1gsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDO2FBQ2xCO2lCQUFNO2dCQUNMLE1BQU0sQ0FBQyw2QkFBNkIsQ0FBQyxDQUFDO2dCQUN0QyxJQUFJLENBQUMsb0JBQW9CLENBQUMsaUJBQWlCLENBQ3pDLElBQUksUUFBUSxDQUFDO29CQUNYLFFBQVEsRUFBRSw4QkFBOEI7b0JBQ3hDLFNBQVMsRUFBRSxnQkFBZ0I7aUJBQzVCLENBQUMsQ0FDSCxDQUFDO2FBQ0g7UUFDSCxDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRDs7OztPQUlHO0lBQ0ksaUJBQWlCLENBQUMsT0FBZTtRQUN0QyxPQUFPLElBQUksT0FBTyxDQUFRLEtBQUssRUFBRSxPQUFPLEVBQUUsTUFBTSxFQUFFLEVBQUU7WUFDbEQsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUMxQixNQUFNLElBQUksQ0FBQyxjQUFjLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxZQUFZLENBQUMsQ0FBQztZQUMzRCxNQUFNLEtBQUssR0FBVSxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FDakQsYUFBYSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQyxLQUFLLEVBQUUsRUFBRTtnQkFDbkMsT0FBTyxLQUFLLENBQUMsRUFBRSxLQUFLLE9BQU8sQ0FBQztZQUM5QixDQUFDLENBQUMsQ0FDSCxDQUFDO1lBQ0YsSUFBSSxDQUFDLGFBQWEsQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUMxQixJQUFJLEtBQUssRUFBRTtnQkFDVCxPQUFPLENBQUMsS0FBSyxDQUFDLENBQUM7YUFDaEI7aUJBQU07Z0JBQ0wsTUFBTSxDQUFDLDJCQUEyQixDQUFDLENBQUM7Z0JBQ3BDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxpQkFBaUIsQ0FDekMsSUFBSSxRQUFRLENBQUM7b0JBQ1gsUUFBUSxFQUFFLDRCQUE0QjtvQkFDdEMsU0FBUyxFQUFFLGdCQUFnQjtpQkFDNUIsQ0FBQyxDQUNILENBQUM7YUFDSDtRQUNILENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7K0dBbEtVLGtCQUFrQixtT0F1Qm5CLGdCQUFnQjttSEF2QmYsa0JBQWtCLGNBTmpCLE1BQU07MkZBTVAsa0JBQWtCO2tCQVA5QixVQUFVO21CQUFDO29CQUNWLFVBQVUsRUFBRSxNQUFNO2lCQUNuQjs7MEJBNEJJLE1BQU07MkJBQUMsZ0JBQWdCIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSW5qZWN0LCBJbmplY3RhYmxlIH0gZnJvbSAnQGFuZ3VsYXIvY29yZSc7XHJcbmltcG9ydCB7IFRyYW5zbGF0ZVNlcnZpY2UgfSBmcm9tICdAbmd4LXRyYW5zbGF0ZS9jb3JlJztcclxuaW1wb3J0IHsgQWJzdHJhY3RBdXRoU2VydmljZSB9IGZyb20gJy4uLy4uLy4uL2F1dGgvc2VydmljZXMvYXV0aC9hYnN0cmFjdC1hdXRoLnNlcnZpY2UnO1xyXG5pbXBvcnQgeyBQcmdFcnJvciB9IGZyb20gJy4uLy4uLy4uL2NvcmUvbW9kZWxzL2Vycm9yLm1vZGVsJztcclxuaW1wb3J0IHsgUHJnU3VjZXNzIH0gZnJvbSAnLi4vLi4vLi4vY29yZS9tb2RlbHMvc3VjY2Vzcy5tb2RlbCc7XHJcbmltcG9ydCB7IElzTG9hZGluZ0RhdGFTZXJ2aWNlIH0gZnJvbSAnLi4vLi4vLi4vY29yZS9zZXJ2aWNlcy9pcy1sb2FkaW5nLWRhdGEvaXNsb2FkaW5nZGF0YS5zZXJ2aWNlJztcclxuaW1wb3J0IHsgTm90aWZpY2F0aW9uc1NlcnZpY2UgfSBmcm9tICcuLi8uLi8uLi9jb3JlL3NlcnZpY2VzL25vdGlmaWNhdGlvbnMvbm90aWZpY2F0aW9ucy5zZXJ2aWNlJztcclxuaW1wb3J0IHsgQXJyYXlVdGlsaXR5U2VydmljZSB9IGZyb20gJy4uLy4uLy4uL2NvcmUvc2VydmljZXMvdXRpbGl0eS9hcnJheS11dGlsaXR5LnNlcnZpY2UnO1xyXG5pbXBvcnQgeyBPYmplY3RzVXRpbGl0eVNlcnZpY2UgfSBmcm9tICcuLi8uLi8uLi9jb3JlL3NlcnZpY2VzL3V0aWxpdHkvb2JqZWN0cy11dGlsaXR5LnNlcnZpY2UnO1xyXG5pbXBvcnQgeyBVdGlsaXR5U2VydmljZSB9IGZyb20gJy4uLy4uLy4uL2NvcmUvc2VydmljZXMvdXRpbGl0eS91dGlsaXR5LnNlcnZpY2UnO1xyXG5pbXBvcnQgeyBRdWVyeSB9IGZyb20gJy4uLy4uL21vZGVscy9xdWVyeS5tb2RlbCc7XHJcbmltcG9ydCB7IEFic3RyYWN0UXVlcmllc1NlcnZpY2UgfSBmcm9tICcuLi8uLi9zZXJ2aWNlcy9xdWVyaWVzL2Fic3RyYWN0LXF1ZXJpZXMuc2VydmljZSc7XHJcbmltcG9ydCB7IFF1ZXJpZXNCRE1PQ0sgfSBmcm9tICcuLi9kYXRhYmFzZS5tb2NrJztcclxuXHJcbi8qKlxyXG4gKiBJbmplY3RhYmxlXHJcbiAqL1xyXG5ASW5qZWN0YWJsZSh7XHJcbiAgcHJvdmlkZWRJbjogJ3Jvb3QnLFxyXG59KVxyXG5cclxuLyoqXHJcbiAqIE1PQ0sgQWJzdHJhY3RRdWVyaWVzU2VydmljZSBpbXBsZW1lbnRhdGlvblxyXG4gKi9cclxuZXhwb3J0IGNsYXNzIE1vY2tRdWVyaWVzU2VydmljZSBleHRlbmRzIEFic3RyYWN0UXVlcmllc1NlcnZpY2Uge1xyXG4gIC8qKlxyXG4gICAqIGRlZmF1bHQgdGltZSBpbiBzZWNvbmRzXHJcbiAgICovXHJcbiAgcHJpdmF0ZSBzbGVlcFRpbWVTZWMgPSAwLjU7XHJcblxyXG4gIC8qKlxyXG4gICAqIGNvbnN0cnVjdG9yXHJcbiAgICogQHBhcmFtIHtOb3RpZmljYXRpb25zU2VydmljZX0gbm90aWZpY2F0aW9uc1NlcnZpY2VcclxuICAgKiBAcGFyYW0ge1V0aWxpdHlTZXJ2aWNlfSB1dGlsaXR5U2VydmljZVxyXG4gICAqIEBwYXJhbSB7SXNMb2FkaW5nRGF0YVNlcnZpY2V9IGlzTG9hZGluZ0RhdGFcclxuICAgKiBAcGFyYW0ge09iamVjdHNVdGlsaXR5U2VydmljZX0gb2JqZWN0VXRpbGl0eVxyXG4gICAqIEBwYXJhbSB7QXJyYXlVdGlsaXR5U2VydmljZX0gYXJyYXlVdGlsaXR5U2VydmljZVxyXG4gICAqIEBwYXJhbSB7QWJzdHJhY3RBdXRoU2VydmljZX0gYXV0aFNlcnZpY2VcclxuICAgKiBAcGFyYW0ge1RyYW5zbGF0ZVNlcnZpY2V9IHRyYW5zbGF0ZVNlcnZpY2VcclxuICAgKi9cclxuICBjb25zdHJ1Y3RvcihcclxuICAgIHByaXZhdGUgbm90aWZpY2F0aW9uc1NlcnZpY2U6IE5vdGlmaWNhdGlvbnNTZXJ2aWNlLFxyXG4gICAgcHJpdmF0ZSB1dGlsaXR5U2VydmljZTogVXRpbGl0eVNlcnZpY2UsXHJcbiAgICBwcml2YXRlIGlzTG9hZGluZ0RhdGE6IElzTG9hZGluZ0RhdGFTZXJ2aWNlLFxyXG4gICAgcHJpdmF0ZSBvYmplY3RVdGlsaXR5OiBPYmplY3RzVXRpbGl0eVNlcnZpY2UsXHJcbiAgICBwcml2YXRlIGFycmF5VXRpbGl0eVNlcnZpY2U6IEFycmF5VXRpbGl0eVNlcnZpY2UsXHJcbiAgICBwcml2YXRlIGF1dGhTZXJ2aWNlOiBBYnN0cmFjdEF1dGhTZXJ2aWNlLFxyXG4gICAgQEluamVjdChUcmFuc2xhdGVTZXJ2aWNlKSB0cmFuc2xhdGVTZXJ2aWNlOiBUcmFuc2xhdGVTZXJ2aWNlXHJcbiAgKSB7XHJcbiAgICBzdXBlcih0cmFuc2xhdGVTZXJ2aWNlKTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIEZ1bmN0aW9uIHJlc3BvbnNpYmxlIHRvIHN0b3JlIGEgbmV3IHF1ZXJ5XHJcbiAgICogQHBhcmFtIHtRdWVyeX0gbmV3UXVlcnlcclxuICAgKiBAcmV0dXJucyB7UHJvbWlzZTxRdWVyeT59XHJcbiAgICovXHJcbiAgcHVibGljIGNyZWF0ZVF1ZXJ5QXN5bmMobmV3UXVlcnk6IFF1ZXJ5KTogUHJvbWlzZTxRdWVyeT4ge1xyXG4gICAgcmV0dXJuIG5ldyBQcm9taXNlPFF1ZXJ5Pihhc3luYyAocmVzb2x2ZSwgcmVqZWN0KSA9PiB7XHJcbiAgICAgIHRoaXMuaXNMb2FkaW5nRGF0YS5zaG93KCk7XHJcbiAgICAgIGF3YWl0IHRoaXMudXRpbGl0eVNlcnZpY2Uuc2xlZXBTZWNBc3luYyh0aGlzLnNsZWVwVGltZVNlYyk7XHJcbiAgICAgIGxldCBjaGVja05hbWVRdWVyeSA9IFF1ZXJpZXNCRE1PQ0suUXVlcmllcy5maW5kKFxyXG4gICAgICAgIChxdWVyeSkgPT4gbmV3UXVlcnkubmFtZSA9PT0gcXVlcnkubmFtZVxyXG4gICAgICApO1xyXG4gICAgICB0aGlzLmlzTG9hZGluZ0RhdGEuaGlkZSgpO1xyXG5cclxuICAgICAgaWYgKCFjaGVja05hbWVRdWVyeSkge1xyXG4gICAgICAgIGxldCBxdWVyeTogUXVlcnkgPSB0aGlzLm9iamVjdFV0aWxpdHkuY2xvbmVPYmplY3QobmV3UXVlcnkpO1xyXG4gICAgICAgIHF1ZXJ5WydjcmVhdGVkQnknXSA9IHRoaXMuYXV0aFNlcnZpY2U/LmdldExvZ2dlZFVzZXIoKT8uaWQ7XHJcbiAgICAgICAgcXVlcnlbJ2lkJ10gPSB0aGlzLnV0aWxpdHlTZXJ2aWNlLm5ld0d1aWQoKTtcclxuXHJcbiAgICAgICAgUXVlcmllc0JETU9DSy5RdWVyaWVzLnB1c2gocXVlcnkpO1xyXG4gICAgICAgIGNvbnN0IHF1ZXJpZXNVcGRhdGVkID0gdGhpcy5hcnJheVV0aWxpdHlTZXJ2aWNlLmNsb25lKFxyXG4gICAgICAgICAgUXVlcmllc0JETU9DSy5RdWVyaWVzXHJcbiAgICAgICAgKTtcclxuICAgICAgICBhd2FpdCB0aGlzLnNldFF1ZXJpZXNDaGFuZ2VkKHF1ZXJpZXNVcGRhdGVkKTtcclxuICAgICAgICByZXNvbHZlKHF1ZXJ5KTtcclxuICAgICAgICB0aGlzLm5vdGlmaWNhdGlvbnNTZXJ2aWNlLnN1Y2Nlc3NOb3RpZmljYXRpb24oXHJcbiAgICAgICAgICBuZXcgUHJnU3VjZXNzKHtcclxuICAgICAgICAgICAgdGl0bGVLZXk6ICdOZXcgUXVlcnkgQ3JlYXRlZC4nLFxyXG4gICAgICAgICAgICBkZXRhaWxLZXk6ICdTdWNjZXNzLicsXHJcbiAgICAgICAgICB9KVxyXG4gICAgICAgICk7XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgcmVqZWN0KCdRdWVyaWVzIGNvdWxkIG5vdCBiZSBsb2FkZWQnKTtcclxuICAgICAgICB0aGlzLm5vdGlmaWNhdGlvbnNTZXJ2aWNlLmVycm9yTm90aWZpY2F0aW9uKFxyXG4gICAgICAgICAgbmV3IFByZ0Vycm9yKHtcclxuICAgICAgICAgICAgdGl0bGVLZXk6ICdRdWVyeSBub3Qgc2F2ZS4nLFxyXG4gICAgICAgICAgICBkZXRhaWxLZXk6ICdRdWVyeSBuYW1lIGFscmVhZHkgZXhpc3RzIGluIGRhdGFiYXNlJyxcclxuICAgICAgICAgIH0pXHJcbiAgICAgICAgKTtcclxuICAgICAgfVxyXG4gICAgfSk7XHJcbiAgfVxyXG5cclxuICAvKipcclxuICAgKiBGdW5jdGlvbiByZXNwb25zaWJsZSB0byB1cGRhdGUgYSBxdWVyeVxyXG4gICAqIEBwYXJhbSB7c3RyaW5nfSBxdWVyeUlkXHJcbiAgICogQHBhcmFtIHtRdWVyeX0gcXVlcnlVcGRhdGVkXHJcbiAgICogQHJldHVybnMge1Byb21pc2U8UXVlcnk+fVxyXG4gICAqL1xyXG4gIHB1YmxpYyB1cGRhdGVRdWVyeUFzeW5jKFxyXG4gICAgcXVlcnlJZDogc3RyaW5nLFxyXG4gICAgcXVlcnlVcGRhdGVkOiBRdWVyeVxyXG4gICk6IFByb21pc2U8UXVlcnk+IHtcclxuICAgIHJldHVybiBuZXcgUHJvbWlzZTxRdWVyeT4oYXN5bmMgKHJlc29sdmUsIHJlamVjdCkgPT4ge1xyXG4gICAgICB0aGlzLmlzTG9hZGluZ0RhdGEuc2hvdygpO1xyXG4gICAgICBhd2FpdCB0aGlzLnV0aWxpdHlTZXJ2aWNlLnNsZWVwU2VjQXN5bmModGhpcy5zbGVlcFRpbWVTZWMpO1xyXG5cclxuICAgICAgY29uc3QgcXVlcnlJbmRleFRvVXBkYXRlOiBudW1iZXIgPSBRdWVyaWVzQkRNT0NLLlF1ZXJpZXMuZmluZEluZGV4KFxyXG4gICAgICAgIChxdWVyeSkgPT4ge1xyXG4gICAgICAgICAgcmV0dXJuIHF1ZXJ5LmlkID09IHF1ZXJ5SWQ7XHJcbiAgICAgICAgfVxyXG4gICAgICApO1xyXG4gICAgICBpZiAocXVlcnlJbmRleFRvVXBkYXRlID4gLTEpIHtcclxuICAgICAgICBRdWVyaWVzQkRNT0NLLlF1ZXJpZXNbcXVlcnlJbmRleFRvVXBkYXRlXSA9IHF1ZXJ5VXBkYXRlZDtcclxuICAgICAgfVxyXG5cclxuICAgICAgY29uc3QgcXVlcmllc1VwZGF0ZWQgPSB0aGlzLmFycmF5VXRpbGl0eVNlcnZpY2UuY2xvbmUoXHJcbiAgICAgICAgUXVlcmllc0JETU9DSy5RdWVyaWVzXHJcbiAgICAgICk7XHJcbiAgICAgIGF3YWl0IHRoaXMuc2V0UXVlcmllc0NoYW5nZWQocXVlcmllc1VwZGF0ZWQpO1xyXG4gICAgICB0aGlzLmlzTG9hZGluZ0RhdGEuaGlkZSgpO1xyXG4gICAgICByZXNvbHZlKHF1ZXJ5VXBkYXRlZCk7XHJcbiAgICAgIHRoaXMubm90aWZpY2F0aW9uc1NlcnZpY2Uuc3VjY2Vzc05vdGlmaWNhdGlvbihcclxuICAgICAgICBuZXcgUHJnU3VjZXNzKHtcclxuICAgICAgICAgIHRpdGxlS2V5OiAnUXVlcnkgdXBkYXRlZC4nLFxyXG4gICAgICAgICAgZGV0YWlsS2V5OiAnU3VjY2Vzcy4nLFxyXG4gICAgICAgIH0pXHJcbiAgICAgICk7XHJcbiAgICB9KTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIEdldCBhbGwgUXVlcmllc1xyXG4gICAqIEByZXR1cm5zIHtQcm9taXNlPFF1ZXJ5W10+fVxyXG4gICAqL1xyXG4gIHB1YmxpYyBnZXRBbGxRdWVyaWVzQXN5bmMoKTogUHJvbWlzZTxRdWVyeVtdPiB7XHJcbiAgICByZXR1cm4gbmV3IFByb21pc2U8UXVlcnlbXT4oYXN5bmMgKHJlc29sdmUsIHJlamVjdCkgPT4ge1xyXG4gICAgICB0aGlzLmlzTG9hZGluZ0RhdGEuc2hvdygpO1xyXG4gICAgICBhd2FpdCB0aGlzLnV0aWxpdHlTZXJ2aWNlLnNsZWVwU2VjQXN5bmModGhpcy5zbGVlcFRpbWVTZWMpO1xyXG4gICAgICBjb25zdCBxdWVyaWVzOiBRdWVyeVtdID0gdGhpcy5vYmplY3RVdGlsaXR5LmNsb25lT2JqZWN0KFxyXG4gICAgICAgIFF1ZXJpZXNCRE1PQ0suUXVlcmllc1xyXG4gICAgICApO1xyXG4gICAgICB0aGlzLmlzTG9hZGluZ0RhdGEuaGlkZSgpO1xyXG4gICAgICBpZiAocXVlcmllcykge1xyXG4gICAgICAgIHJlc29sdmUocXVlcmllcyk7XHJcbiAgICAgIH0gZWxzZSB7XHJcbiAgICAgICAgcmVqZWN0KCdRdWVyaWVzIGNvdWxkIG5vdCBiZSBsb2FkZWQnKTtcclxuICAgICAgICB0aGlzLm5vdGlmaWNhdGlvbnNTZXJ2aWNlLmVycm9yTm90aWZpY2F0aW9uKFxyXG4gICAgICAgICAgbmV3IFByZ0Vycm9yKHtcclxuICAgICAgICAgICAgdGl0bGVLZXk6ICdRdWVyaWVzIGNvdWxkIG5vdCBiZSBsb2FkZWQuJyxcclxuICAgICAgICAgICAgZGV0YWlsS2V5OiAnU2VydmVyIGlzIGRvd24nLFxyXG4gICAgICAgICAgfSlcclxuICAgICAgICApO1xyXG4gICAgICB9XHJcbiAgICB9KTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIEdldCBxdWVyeSBieSBJZFxyXG4gICAqIEBwYXJhbSB7c3RyaW5nfSBxdWVyeUlkXHJcbiAgICogQHJldHVybnMge1Byb21pc2U8UXVlcnk+fVxyXG4gICAqL1xyXG4gIHB1YmxpYyBnZXRRdWVyeUJ5SWRBc3luYyhxdWVyeUlkOiBzdHJpbmcpOiBQcm9taXNlPFF1ZXJ5PiB7XHJcbiAgICByZXR1cm4gbmV3IFByb21pc2U8UXVlcnk+KGFzeW5jIChyZXNvbHZlLCByZWplY3QpID0+IHtcclxuICAgICAgdGhpcy5pc0xvYWRpbmdEYXRhLnNob3coKTtcclxuICAgICAgYXdhaXQgdGhpcy51dGlsaXR5U2VydmljZS5zbGVlcFNlY0FzeW5jKHRoaXMuc2xlZXBUaW1lU2VjKTtcclxuICAgICAgY29uc3QgcXVlcnk6IFF1ZXJ5ID0gdGhpcy5vYmplY3RVdGlsaXR5LmNsb25lT2JqZWN0KFxyXG4gICAgICAgIFF1ZXJpZXNCRE1PQ0suUXVlcmllcy5maW5kKChxdWVyeSkgPT4ge1xyXG4gICAgICAgICAgcmV0dXJuIHF1ZXJ5LmlkID09PSBxdWVyeUlkO1xyXG4gICAgICAgIH0pXHJcbiAgICAgICk7XHJcbiAgICAgIHRoaXMuaXNMb2FkaW5nRGF0YS5oaWRlKCk7XHJcbiAgICAgIGlmIChxdWVyeSkge1xyXG4gICAgICAgIHJlc29sdmUocXVlcnkpO1xyXG4gICAgICB9IGVsc2Uge1xyXG4gICAgICAgIHJlamVjdCgnUXVlcnkgY291bGQgbm90IGJlIGxvYWRlZCcpO1xyXG4gICAgICAgIHRoaXMubm90aWZpY2F0aW9uc1NlcnZpY2UuZXJyb3JOb3RpZmljYXRpb24oXHJcbiAgICAgICAgICBuZXcgUHJnRXJyb3Ioe1xyXG4gICAgICAgICAgICB0aXRsZUtleTogJ1F1ZXJ5IGNvdWxkIG5vdCBiZSBsb2FkZWQuJyxcclxuICAgICAgICAgICAgZGV0YWlsS2V5OiAnU2VydmVyIGlzIGRvd24nLFxyXG4gICAgICAgICAgfSlcclxuICAgICAgICApO1xyXG4gICAgICB9XHJcbiAgICB9KTtcclxuICB9XHJcbn1cclxuIl19