import { BaseCacheService } from '../../../core/services/cache-service/base-cache.service';
/**
 * AbstractLookupTableService class that defines an
 * <br />abstract lookup tables service to
 * <br />be extended by the mock and real
 * <br />lookup tables services
 */
export class AbstractLookupTableService extends BaseCacheService {
    /** constructor */
    constructor(translationService) {
        super();
        this.translationService = translationService;
    }
    /**
     * this service get translations for all lookup table items
     *
     * @param lookupTable
     * @returns
     */
    async getTranslations(lookupTable) {
        return new Promise((resolve, reject) => {
            lookupTable.items.map(async (item) => {
                item.label = await this.translationService
                    .get('lookup-tables.' +
                    lookupTable.name +
                    '.items.' +
                    lookupTable.name +
                    '.' +
                    item['name'] +
                    '.name')
                    .toPromise();
                item.description = await this.translationService
                    .get('lookup-tables.' +
                    lookupTable.name +
                    '.items.' +
                    lookupTable.name +
                    '.' +
                    item['name'] +
                    '.description')
                    .toPromise();
            });
            resolve(lookupTable);
        });
        return lookupTable;
    }
}
//# sourceMappingURL=data:application/json;base64,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