import { NgModule } from '@angular/core';
import { PrgSharedComponentsModule } from '../shared-components/shared-components.module';
import { PrgLookupTableItemsTableComponent } from './components/lookupTableTable/components/lookupTableItemsTable/prg-lookup-table-items-table.component';
import { PrgLookupTableTableComponent } from './components/lookupTableTable/prg-lookup-table-table.component';
import { MockLookupTableService } from './mock/services/lookup-table/lookup-table.mock.service';
import { PrgLookupTablePage } from './pages/prg-lookup-table.page';
import { PrgLookupTableRoutingModule } from './prg-lookup-table-routing.module';
import { PRG_LOOKUP_TABLE_CONFIG } from './services/lookup-table-configuration/prg-lookup-table-configuration.service';
import { AbstractLookupTableService } from './services/lookup-table/abstract-lookup-table.service';
import { LookupTableService } from './services/lookup-table/lookup-table.service';
import * as i0 from "@angular/core";
export class PrgLookupTableModule {
    constructor(injector) {
        this.injector = injector;
        appInjector = this.injector;
    }
    static forRoot(prgLookupTableConfig) {
        lookupTableConfig = prgLookupTableConfig;
        return {
            ngModule: PrgLookupTableModule,
            providers: [
                {
                    provide: PRG_LOOKUP_TABLE_CONFIG,
                    useValue: prgLookupTableConfig,
                },
                {
                    provide: AbstractLookupTableService,
                    useClass: prgLookupTableConfig.useMockServices
                        ? MockLookupTableService
                        : LookupTableService,
                },
            ],
        };
    }
}
PrgLookupTableModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgLookupTableModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableModule, declarations: [PrgLookupTablePage,
        PrgLookupTableTableComponent,
        PrgLookupTableItemsTableComponent], imports: [PrgSharedComponentsModule, PrgLookupTableRoutingModule], exports: [PrgLookupTableTableComponent, PrgLookupTableItemsTableComponent] });
PrgLookupTableModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableModule, imports: [PrgSharedComponentsModule, PrgLookupTableRoutingModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        PrgLookupTablePage,
                        PrgLookupTableTableComponent,
                        PrgLookupTableItemsTableComponent,
                    ],
                    imports: [PrgSharedComponentsModule, PrgLookupTableRoutingModule],
                    exports: [PrgLookupTableTableComponent, PrgLookupTableItemsTableComponent],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
export let appInjector;
/**
 * Exports the AuthCoreConfig object
 */
export let lookupTableConfig;
//# sourceMappingURL=data:application/json;base64,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