import { BaseEntity } from '../../core/models/base-entity.model';
/**
 * LookupTableItem class that defines a look up table
 * <br />item to be used in dropowns by the front-end.
 * <br />Its form must have an name and description
 * <br />input fields that will be saved in i18n
 * <br />using an unique identifier created through
 * <br />its normalized "name" property
 */
export class LookupTableItem extends BaseEntity {
}
/**
 * LookupTable class that defines a look up table
 * <br />to be used in dropowns by the front-end.
 * <br />Its form must have an name and description
 * <br />input fields that will be saved in i18n
 * <br />using an unique identifier created through
 * <br />its normalized "name" property
 */
export class LookupTable extends BaseEntity {
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9va3VwLXRhYmxlLm1vZGVsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvUHJnRnJhbWV3b3JrLkZFLkNvcmVMaWIvc3JjL2xpYi9tb2R1bGVzL2xvb2t1cC10YWJsZS9tb2RlbHMvbG9va3VwLXRhYmxlLm1vZGVsLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBLE9BQU8sRUFBRSxVQUFVLEVBQUUsTUFBTSxxQ0FBcUMsQ0FBQztBQUVqRTs7Ozs7OztHQU9HO0FBQ0gsTUFBTSxPQUFPLGVBQWdCLFNBQVEsVUFBVTtDQWtCOUM7QUFFRDs7Ozs7OztHQU9HO0FBQ0gsTUFBTSxPQUFPLFdBQVksU0FBUSxVQUFVO0NBa0IxQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEJhc2VFbnRpdHkgfSBmcm9tICcuLi8uLi9jb3JlL21vZGVscy9iYXNlLWVudGl0eS5tb2RlbCc7XHJcblxyXG4vKipcclxuICogTG9va3VwVGFibGVJdGVtIGNsYXNzIHRoYXQgZGVmaW5lcyBhIGxvb2sgdXAgdGFibGVcclxuICogPGJyIC8+aXRlbSB0byBiZSB1c2VkIGluIGRyb3Bvd25zIGJ5IHRoZSBmcm9udC1lbmQuXHJcbiAqIDxiciAvPkl0cyBmb3JtIG11c3QgaGF2ZSBhbiBuYW1lIGFuZCBkZXNjcmlwdGlvblxyXG4gKiA8YnIgLz5pbnB1dCBmaWVsZHMgdGhhdCB3aWxsIGJlIHNhdmVkIGluIGkxOG5cclxuICogPGJyIC8+dXNpbmcgYW4gdW5pcXVlIGlkZW50aWZpZXIgY3JlYXRlZCB0aHJvdWdoXHJcbiAqIDxiciAvPml0cyBub3JtYWxpemVkIFwibmFtZVwiIHByb3BlcnR5XHJcbiAqL1xyXG5leHBvcnQgY2xhc3MgTG9va3VwVGFibGVJdGVtIGV4dGVuZHMgQmFzZUVudGl0eSB7XHJcbiAgLyoqXHJcbiAgICogbGFiZWwgdHJhbnNsYXRlZFxyXG4gICAqL1xyXG4gIHB1YmxpYyBsYWJlbDogc3RyaW5nO1xyXG4gIC8qKlxyXG4gICAqIERlc2NyaXB0aW9uXHJcbiAgICovXHJcbiAgcHVibGljIGRlc2NyaXB0aW9uOiBzdHJpbmc7XHJcblxyXG4gIC8qKlxyXG4gICAqIFdvcmtzcGFjZSBpZCAoZm9yZWlnbiBrZXkpXHJcbiAgICovXHJcbiAgcHVibGljIHdvcmtzcGFjZUlkOiBzdHJpbmc7XHJcbiAgLyoqXHJcbiAgICogTG9va3VwIHRhYmxlIGlkIChmb3JlaWduIGtleSlcclxuICAgKi9cclxuICBwdWJsaWMgbG9va3VwVGFibGVJZDogc3RyaW5nOyAvLyBGb3JlaWduIGtleVxyXG59XHJcblxyXG4vKipcclxuICogTG9va3VwVGFibGUgY2xhc3MgdGhhdCBkZWZpbmVzIGEgbG9vayB1cCB0YWJsZVxyXG4gKiA8YnIgLz50byBiZSB1c2VkIGluIGRyb3Bvd25zIGJ5IHRoZSBmcm9udC1lbmQuXHJcbiAqIDxiciAvPkl0cyBmb3JtIG11c3QgaGF2ZSBhbiBuYW1lIGFuZCBkZXNjcmlwdGlvblxyXG4gKiA8YnIgLz5pbnB1dCBmaWVsZHMgdGhhdCB3aWxsIGJlIHNhdmVkIGluIGkxOG5cclxuICogPGJyIC8+dXNpbmcgYW4gdW5pcXVlIGlkZW50aWZpZXIgY3JlYXRlZCB0aHJvdWdoXHJcbiAqIDxiciAvPml0cyBub3JtYWxpemVkIFwibmFtZVwiIHByb3BlcnR5XHJcbiAqL1xyXG5leHBvcnQgY2xhc3MgTG9va3VwVGFibGUgZXh0ZW5kcyBCYXNlRW50aXR5IHtcclxuICAvKipcclxuICAgKiBUcmFuc2xhdGVkTmFtZVxyXG4gICAqL1xyXG4gIHB1YmxpYyBsYWJlbDogc3RyaW5nO1xyXG4gIC8qKlxyXG4gICAqIERlc2NyaXB0aW9uXHJcbiAgICovXHJcbiAgcHVibGljIGRlc2NyaXB0aW9uOiBzdHJpbmc7XHJcblxyXG4gIC8qKlxyXG4gICAqIEVudGl0eSB0eXBlIHdvcmtzcGFjZSBpZCAoZm9yZWlnbiBrZXkpXHJcbiAgICovXHJcbiAgcHVibGljIHdvcmtzcGFjZUlkOiBzdHJpbmc7IC8vIEZvcmVpZ24ga2V5XHJcbiAgLyoqXHJcbiAgICogTG9va3VwVGFibGVJdGVtcyBhcnJheVxyXG4gICAqL1xyXG4gIHB1YmxpYyBpdGVtczogTG9va3VwVGFibGVJdGVtW107XHJcbn1cclxuIl19