import { Component, Inject, ViewChild } from '@angular/core';
import { Table } from 'primeng/table';
import { PRG_LOOKUP_TABLE_CONFIG } from '../../services/lookup-table-configuration/prg-lookup-table-configuration.service';
import * as i0 from "@angular/core";
import * as i1 from "../../services/lookup-table/abstract-lookup-table.service";
import * as i2 from "../../../core/services/is-loading-data/isloadingdata.service";
import * as i3 from "@angular/forms";
import * as i4 from "../../../core/services/form-group/form-group.service";
import * as i5 from "../../../core/services/utility/objects-utility.service";
import * as i6 from "primeng/inputtext";
import * as i7 from "primeng/api";
import * as i8 from "@angular/common";
import * as i9 from "primeng/progressspinner";
import * as i10 from "primeng/table";
import * as i11 from "primeng/button";
import * as i12 from "primeng/ripple";
import * as i13 from "./components/lookupTableItemsTable/prg-lookup-table-items-table.component";
import * as i14 from "@ngx-translate/core";
/**
 * LookupTables Component
 */
export class PrgLookupTableTableComponent {
    /**
     * constructor
     *
     * @param lookupTableService
     * @param prgLookupTableConfig prgLookupTableConfig
     * @param isLoadingDataService isLoadingDataService
     * @param formBuilder
     * @param formGroupService
     * @param objectsUtilityService
     */
    constructor(lookupTableService, prgLookupTableConfig, isLoadingDataService, formBuilder, formGroupService, objectsUtilityService) {
        this.lookupTableService = lookupTableService;
        this.prgLookupTableConfig = prgLookupTableConfig;
        this.isLoadingDataService = isLoadingDataService;
        this.formBuilder = formBuilder;
        this.formGroupService = formGroupService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         *  new Lookup Table Id Prefix
         */
        this.newLookupTableIdPrefix = 'newLookupTable';
        /**
         * table columns
         */
        this.lookupTableColumns = this.prgLookupTableConfig.lookupTableColumns;
        /**
         * cloned Lookup Table
         * this map is used to temporarily store the elements in edit mode
         */
        this.clonedLookupTable = new Map();
        /**
         * auxiliary variable to help define the id of the new lookuptables
         */
        this.newLookupTableIdCount = 0;
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.lookupTableForm = this.formBuilder.group({
            lookupTableFormArray: this.formBuilder.array([]),
        });
        this.populateData();
    }
    /**
     * Return lookup table form array
     */
    get lookupTableFormArray() {
        return this.lookupTableForm.get('lookupTableFormArray');
    }
    /**
     * this function is responsible for adding a new row
     * to the table for the user to configure the new lookuptable
     *
     */
    newLookupTable() {
        const newLookupTable = {
            id: `${this.newLookupTableIdPrefix}${this.newLookupTableIdCount}`,
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: null,
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            description: null,
            workspaceId: null,
            items: null,
        };
        this.newLookupTableIdCount++;
        this.lookupTableFormArray.insert(0, this.formGroupService.toFormGroupOneObject(newLookupTable, this.lookupTableColumns));
        //TODO: SEE this
        this.lookupTableFormArray.value.unshift(newLookupTable);
        this.lookupTableForm.markAllAsTouched();
        this.dataTable.editingRowKeys[newLookupTable.id] = true;
    }
    /**
     * return lookup table  control for given lookup table
     */
    getLookupTableControlById(lookupTableId) {
        return this.lookupTableFormArray.controls.find((control) => control.value.id === lookupTableId);
    }
    /**
     * this function is responsible for creating a
     * clone of a lookupTable that is selected for editing
     *
     * @param lookupTable
     */
    onRowEditInit(lookupTable) {
        this.clonedLookupTable.set(lookupTable.id, { ...lookupTable });
    }
    /**
     * this function is responsible for saving a lookup table,
     * either an update or adding a new lookup table to the database
     *
     * @param lookupTable
     */
    onRowEditSave(lookupTable) {
        const lookupTableToSave = this.objectsUtilityService.cloneObject(lookupTable);
        if (lookupTableToSave.id.includes(this.newLookupTableIdPrefix)) {
            lookupTableToSave.id = null;
        }
        this.lookupTableService
            .saveLookupTableAsync(lookupTableToSave)
            .then((response) => {
            this.getLookupTableControlById(lookupTable.id).setValue(response);
            delete this.dataTable.editingRowKeys[lookupTable.id];
            this.clonedLookupTable.delete(lookupTable.id);
        });
    }
    /**
     * this function is responsible for restoring the data
     * that was there before starting the edit if the
     * lookup table is already in the database,
     * otherwise it just deletes the row that was temporarily created
     *
     * @param lookupTable
     */
    onRowEditCancel(lookupTable) {
        if (lookupTable.id.includes(this.newLookupTableIdPrefix)) {
            this.lookupTableFormArray.removeAt(this.getLookupTableControlIndexById(lookupTable.id));
        }
        else {
            const lookupTableOrignal = this.clonedLookupTable.get(lookupTable.id);
            this.getLookupTableControlById(lookupTable.id).setValue(lookupTableOrignal);
        }
    }
    /**
     * this function is responsible for checking
     * if the lookup table already has the
     * items loaded, if not it calls the function to load them
     * @param lookupTable
     */
    expandLookupTable(lookupTable) {
        if (lookupTable.items === null) {
            this.loadLookupTableItemsByLookupTableId(lookupTable);
        }
    }
    /**
     * this function is responsible for saving
     * all active edits (new lines or updating existing ones)
     */
    async saveAllChanges() {
        let lookupTablesToSave = [];
        Object.getOwnPropertyNames(this.dataTable.editingRowKeys).forEach((element) => {
            if (element.includes(this.newLookupTableIdPrefix)) {
                const lookupTableAux = this.objectsUtilityService.cloneObject(this.getLookupTableControlById(element).value);
                lookupTableAux.id = null;
                lookupTablesToSave.push(lookupTableAux);
            }
            else {
                lookupTablesToSave.push(this.objectsUtilityService.cloneObject(this.getLookupTableControlById(element).value));
            }
        });
        this.lookupTableService
            .saveMultipleLookupTableAsync(lookupTablesToSave)
            .then((response) => {
            response.forEach((slt) => {
                const lookupTableById = this.getLookupTableControlById(slt.id);
                if (lookupTableById) {
                    lookupTableById.setValue(slt);
                }
                else {
                    this.lookupTableFormArray.push(this.formGroupService.toFormGroupOneObject(slt, this.lookupTableColumns));
                }
            });
            this.clonedLookupTable.clear();
            this.deleteAllTempLookupTable();
        });
    }
    /**
     * this function is responsible for discarding
     * all active edits, and resetting the data that
     * was set before starting the edit
     *
     */
    discardAllChanges() {
        Object.getOwnPropertyNames(this.dataTable.editingRowKeys).forEach((element) => {
            if (element.includes(this.newLookupTableIdPrefix)) {
                this.lookupTableFormArray.removeAt(this.getLookupTableControlIndexById(element));
            }
            else {
                this.getLookupTableControlById(element).setValue(this.clonedLookupTable.get(element));
            }
        });
        this.clonedLookupTable.clear();
        this.dataTable.editingRowKeys = {};
    }
    /**
     *this function is responsible for sorting a given column
     * @param event
     */
    customSort(event) {
        event.data.sort((data1, data2) => {
            let value1 = data1.value[event.field];
            let value2 = data2.value[event.field];
            let result = null;
            if (value1 == null && value2 != null)
                result = -1;
            else if (value1 != null && value2 == null)
                result = 1;
            else if (value1 == null && value2 == null)
                result = 0;
            else if (typeof value1 === 'string' && typeof value2 === 'string')
                result = value1.localeCompare(value2);
            else
                result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
            return event.order * result;
        });
    }
    /**
     * this function recive the item saved in child component
     * @param event
     */
    itemsSaved(event) {
        const lookupTable = this.getLookupTableControlById(event).value;
        this.loadLookupTableItemsByLookupTableId(lookupTable);
    }
    /**
     * return index of control for given lookup table
     */
    getLookupTableControlIndexById(lookupTableId) {
        return this.lookupTableFormArray.controls.findIndex((control) => control.value.id === lookupTableId);
    }
    /**
     * Populate data into Form
     */
    populateData() {
        this.lookupTableService.getAllLookupTableAsync().then((response) => {
            const aux = this.formGroupService.toFormGroupMultipleObjects(response, this.lookupTableColumns);
            aux.forEach((a) => {
                this.lookupTableForm.markAllAsTouched();
                this.lookupTableFormArray.push(a);
            });
        });
    }
    /**
     * this function is responsible for loading the
     * lookup table items for a given lookup table
     * @param lookupTable
     */
    loadLookupTableItemsByLookupTableId(lookupTable) {
        this.lookupTableService
            .getLookupTableItemsByLookupTableIdAsync(lookupTable.id)
            .then((response) => {
            lookupTable.items = response;
            this.getLookupTableControlById(lookupTable.id).setValue(lookupTable);
        });
    }
    /**
     * this function is an auxiliary function that is used in the [saveAllChanges]{@link #saveAllChanges}
     *  function to delete all temporary rows that will be added later
     */
    deleteAllTempLookupTable() {
        const tempLookupTable = this.lookupTableFormArray.controls.filter((control) => control.value.id.includes(this.newLookupTableIdPrefix));
        if (tempLookupTable.length > 0) {
            tempLookupTable.forEach((tlt) => {
                this.lookupTableFormArray.removeAt(this.getLookupTableControlIndexById(tlt.value.id));
            });
        }
    }
}
PrgLookupTableTableComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableTableComponent, deps: [{ token: i1.AbstractLookupTableService }, { token: PRG_LOOKUP_TABLE_CONFIG }, { token: i2.IsLoadingDataService }, { token: i3.FormBuilder }, { token: i4.FormGroupService }, { token: i5.ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgLookupTableTableComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgLookupTableTableComponent, selector: "prg-lookup-table-table", viewQueries: [{ propertyName: "dataTable", first: true, predicate: Table, descendants: true }], ngImport: i0, template: "<form [formGroup]=\"lookupTableForm\">\r\n  <div formArrayName=\"lookupTableFormArray\">\r\n    <p-table\r\n      [value]=\"lookupTableFormArray.controls\"\r\n      dataKey=\"value.id\"\r\n      responsiveLayout=\"scroll\"\r\n      editMode=\"row\"\r\n      (sortFunction)=\"customSort($event)\"\r\n      [customSort]=\"true\"\r\n    >\r\n      <ng-template pTemplate=\"header\">\r\n        <tr>\r\n          <th style=\"width: 3rem\"></th>\r\n          <ng-container *ngFor=\"let column of lookupTableColumns\">\r\n            <th\r\n              [pSortableColumn]=\"column.key\"\r\n              [pSortableColumnDisabled]=\"\r\n                isLoadingDataService.visibility | async\r\n              \"\r\n            >\r\n              {{\r\n                'components.lookup-table.columns.' + column.key + '.label'\r\n                  | translate\r\n              }}\r\n              <p-sortIcon [field]=\"column.key\"></p-sortIcon>\r\n            </th>\r\n          </ng-container>\r\n\r\n          <th style=\"width: 15rem\">\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-plus-circle\"\r\n              (click)=\"newLookupTable()\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-save\"\r\n              [disabled]=\"\r\n                (isLoadingDataService.visibility | async) ||\r\n                lookupTableFormArray.status === 'INVALID'\r\n              \"\r\n              (click)=\"saveAllChanges()\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-trash\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n              (click)=\"discardAllChanges()\"\r\n            ></p-button>\r\n          </th>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template\r\n        pTemplate=\"body\"\r\n        let-rowData\r\n        let-editing=\"editing\"\r\n        let-ri=\"rowIndex\"\r\n        let-expanded=\"expanded\"\r\n      >\r\n        <tr [pEditableRow]=\"rowData\" [formGroupName]=\"ri\">\r\n          <td>\r\n            <button\r\n              type=\"button\"\r\n              pButton\r\n              pRipple\r\n              *ngIf=\"!rowData.value.id.includes(newLookupTableIdPrefix)\"\r\n              [pRowToggler]=\"rowData\"\r\n              class=\"p-button-text p-button-rounded p-button-plain\"\r\n              [icon]=\"expanded ? 'pi pi-chevron-down' : 'pi pi-chevron-right'\"\r\n              (click)=\"expandLookupTable(rowData.value)\"\r\n            ></button>\r\n          </td>\r\n          <ng-container *ngFor=\"let column of lookupTableColumns\">\r\n            <td pEditableColumn *ngIf=\"editing; else elseBlock\">\r\n              <p-cellEditor>\r\n                <ng-template pTemplate=\"input\">\r\n                  <input\r\n                    *ngIf=\"\r\n                      !column.readonly ||\r\n                        rowData.value.id.includes(newLookupTableIdPrefix);\r\n                      else notEditableColumn\r\n                    \"\r\n                    [placeholder]=\"'placeholder' + column.key | translate\"\r\n                    pInputText\r\n                    type=\"text\"\r\n                    [formControlName]=\"column.key\"\r\n                  />\r\n                  <ng-template pTemplate=\"input\" #notEditableColumn>\r\n                    {{ rowData.value[column.key] | translate }}\r\n                  </ng-template>\r\n                </ng-template>\r\n              </p-cellEditor>\r\n            </td>\r\n            <!-- Fixes bug that allows user to edit row without first clicking on the edit button-->\r\n            <ng-template #elseBlock>\r\n              <td>{{ rowData.value[column.key] | translate }}</td>\r\n            </ng-template>\r\n          </ng-container>\r\n\r\n          <td style=\"text-align: center\">\r\n            <button\r\n              *ngIf=\"!editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pInitEditableRow\r\n              icon=\"pi pi-pencil\"\r\n              (click)=\"onRowEditInit(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text\"\r\n            ></button>\r\n\r\n            <button\r\n              *ngIf=\"editing\"\r\n              [disabled]=\"\r\n                getLookupTableControlById(rowData.value.id).status !== 'VALID'\r\n              \"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pSaveEditableRow\r\n              icon=\"pi pi-check-circle\"\r\n              (click)=\"onRowEditSave(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-success p-mr-2\"\r\n            ></button>\r\n            <button\r\n              *ngIf=\"editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pCancelEditableRow\r\n              icon=\"pi pi-times-circle\"\r\n              (click)=\"onRowEditCancel(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-danger\"\r\n            ></button>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template pTemplate=\"rowexpansion\" let-lookupTable>\r\n        <tr style=\"background: lime !important\">\r\n          <td colspan=\"7\">\r\n            <div class=\"p-3\">\r\n              <prg-lookup-table-items-table\r\n                [lookupTableItems]=\"lookupTable.value.items\"\r\n                [lookupTableId]=\"lookupTable.value.id\"\r\n                (savedItems)=\"itemsSaved($event)\"\r\n              ></prg-lookup-table-items-table>\r\n            </div>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template pTemplate=\"emptymessage\">\r\n        <tr style=\"background: white !important\" class=\"emptyInfo\">\r\n          <td colspan=\"6\">\r\n            <p-progressSpinner\r\n              *ngIf=\"isLoadingDataService.visibility | async; else elseBlock\"\r\n              [style]=\"{ width: '50px', height: '50px' }\"\r\n            ></p-progressSpinner>\r\n            <ng-template #elseBlock>\r\n              {{ 'withoutLookuptable' | translate }}</ng-template\r\n            >\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n    </p-table>\r\n  </div>\r\n</form>\r\n", styles: ["th,td{text-align:center!important}\n"], dependencies: [{ kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i7.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i8.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i8.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i9.ProgressSpinner, selector: "p-progressSpinner", inputs: ["style", "styleClass", "strokeWidth", "fill", "animationDuration"] }, { kind: "component", type: i10.Table, selector: "p-table", inputs: ["frozenColumns", "frozenValue", "style", "styleClass", "tableStyle", "tableStyleClass", "paginator", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "paginatorDropdownScrollHeight", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showJumpToPageInput", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "selectionMode", "selectionPageOnly", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "rowSelectable", "rowTrackBy", "lazy", "lazyLoadOnInit", "compareSelectionBy", "csvSeparator", "exportFilename", "filters", "globalFilterFields", "filterDelay", "filterLocale", "expandedRowKeys", "editingRowKeys", "rowExpandMode", "scrollable", "scrollDirection", "rowGroupMode", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "responsive", "contextMenu", "resizableColumns", "columnResizeMode", "reorderableColumns", "loading", "loadingIcon", "showLoader", "rowHover", "customSort", "showInitialSortBadge", "autoLayout", "exportFunction", "exportHeader", "stateKey", "stateStorage", "editMode", "groupRowsBy", "groupRowsByOrder", "responsiveLayout", "breakpoint", "virtualRowHeight", "value", "columns", "first", "rows", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection", "selectAll"], outputs: ["selectAllChange", "selectionChange", "contextMenuSelectionChange", "onRowSelect", "onRowUnselect", "onPage", "onSort", "onFilter", "onLazyLoad", "onRowExpand", "onRowCollapse", "onContextMenuSelect", "onColResize", "onColReorder", "onRowReorder", "onEditInit", "onEditComplete", "onEditCancel", "onHeaderCheckboxToggle", "sortFunction", "firstChange", "rowsChange", "onStateSave", "onStateRestore"] }, { kind: "directive", type: i10.SortableColumn, selector: "[pSortableColumn]", inputs: ["pSortableColumn", "pSortableColumnDisabled"] }, { kind: "directive", type: i10.RowToggler, selector: "[pRowToggler]", inputs: ["pRowToggler", "pRowTogglerDisabled"] }, { kind: "directive", type: i10.EditableColumn, selector: "[pEditableColumn]", inputs: ["pEditableColumn", "pEditableColumnField", "pEditableColumnRowIndex", "pEditableColumnDisabled", "pFocusCellSelector"] }, { kind: "component", type: i10.CellEditor, selector: "p-cellEditor" }, { kind: "component", type: i10.SortIcon, selector: "p-sortIcon", inputs: ["field"] }, { kind: "directive", type: i10.EditableRow, selector: "[pEditableRow]", inputs: ["pEditableRow", "pEditableRowDisabled"] }, { kind: "directive", type: i10.InitEditableRow, selector: "[pInitEditableRow]" }, { kind: "directive", type: i10.SaveEditableRow, selector: "[pSaveEditableRow]" }, { kind: "directive", type: i10.CancelEditableRow, selector: "[pCancelEditableRow]" }, { kind: "directive", type: i11.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i11.Button, selector: "p-button", inputs: ["type", "iconPos", "icon", "badge", "label", "disabled", "loading", "loadingIcon", "style", "styleClass", "badgeClass", "ariaLabel"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "directive", type: i12.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i3.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i3.FormGroupName, selector: "[formGroupName]", inputs: ["formGroupName"] }, { kind: "directive", type: i3.FormArrayName, selector: "[formArrayName]", inputs: ["formArrayName"] }, { kind: "component", type: i13.PrgLookupTableItemsTableComponent, selector: "prg-lookup-table-items-table", inputs: ["lookupTableId", "lookupTableItems"], outputs: ["savedItems"] }, { kind: "pipe", type: i8.AsyncPipe, name: "async" }, { kind: "pipe", type: i14.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableTableComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-lookup-table-table', template: "<form [formGroup]=\"lookupTableForm\">\r\n  <div formArrayName=\"lookupTableFormArray\">\r\n    <p-table\r\n      [value]=\"lookupTableFormArray.controls\"\r\n      dataKey=\"value.id\"\r\n      responsiveLayout=\"scroll\"\r\n      editMode=\"row\"\r\n      (sortFunction)=\"customSort($event)\"\r\n      [customSort]=\"true\"\r\n    >\r\n      <ng-template pTemplate=\"header\">\r\n        <tr>\r\n          <th style=\"width: 3rem\"></th>\r\n          <ng-container *ngFor=\"let column of lookupTableColumns\">\r\n            <th\r\n              [pSortableColumn]=\"column.key\"\r\n              [pSortableColumnDisabled]=\"\r\n                isLoadingDataService.visibility | async\r\n              \"\r\n            >\r\n              {{\r\n                'components.lookup-table.columns.' + column.key + '.label'\r\n                  | translate\r\n              }}\r\n              <p-sortIcon [field]=\"column.key\"></p-sortIcon>\r\n            </th>\r\n          </ng-container>\r\n\r\n          <th style=\"width: 15rem\">\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-plus-circle\"\r\n              (click)=\"newLookupTable()\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-save\"\r\n              [disabled]=\"\r\n                (isLoadingDataService.visibility | async) ||\r\n                lookupTableFormArray.status === 'INVALID'\r\n              \"\r\n              (click)=\"saveAllChanges()\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-trash\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n              (click)=\"discardAllChanges()\"\r\n            ></p-button>\r\n          </th>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template\r\n        pTemplate=\"body\"\r\n        let-rowData\r\n        let-editing=\"editing\"\r\n        let-ri=\"rowIndex\"\r\n        let-expanded=\"expanded\"\r\n      >\r\n        <tr [pEditableRow]=\"rowData\" [formGroupName]=\"ri\">\r\n          <td>\r\n            <button\r\n              type=\"button\"\r\n              pButton\r\n              pRipple\r\n              *ngIf=\"!rowData.value.id.includes(newLookupTableIdPrefix)\"\r\n              [pRowToggler]=\"rowData\"\r\n              class=\"p-button-text p-button-rounded p-button-plain\"\r\n              [icon]=\"expanded ? 'pi pi-chevron-down' : 'pi pi-chevron-right'\"\r\n              (click)=\"expandLookupTable(rowData.value)\"\r\n            ></button>\r\n          </td>\r\n          <ng-container *ngFor=\"let column of lookupTableColumns\">\r\n            <td pEditableColumn *ngIf=\"editing; else elseBlock\">\r\n              <p-cellEditor>\r\n                <ng-template pTemplate=\"input\">\r\n                  <input\r\n                    *ngIf=\"\r\n                      !column.readonly ||\r\n                        rowData.value.id.includes(newLookupTableIdPrefix);\r\n                      else notEditableColumn\r\n                    \"\r\n                    [placeholder]=\"'placeholder' + column.key | translate\"\r\n                    pInputText\r\n                    type=\"text\"\r\n                    [formControlName]=\"column.key\"\r\n                  />\r\n                  <ng-template pTemplate=\"input\" #notEditableColumn>\r\n                    {{ rowData.value[column.key] | translate }}\r\n                  </ng-template>\r\n                </ng-template>\r\n              </p-cellEditor>\r\n            </td>\r\n            <!-- Fixes bug that allows user to edit row without first clicking on the edit button-->\r\n            <ng-template #elseBlock>\r\n              <td>{{ rowData.value[column.key] | translate }}</td>\r\n            </ng-template>\r\n          </ng-container>\r\n\r\n          <td style=\"text-align: center\">\r\n            <button\r\n              *ngIf=\"!editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pInitEditableRow\r\n              icon=\"pi pi-pencil\"\r\n              (click)=\"onRowEditInit(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text\"\r\n            ></button>\r\n\r\n            <button\r\n              *ngIf=\"editing\"\r\n              [disabled]=\"\r\n                getLookupTableControlById(rowData.value.id).status !== 'VALID'\r\n              \"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pSaveEditableRow\r\n              icon=\"pi pi-check-circle\"\r\n              (click)=\"onRowEditSave(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-success p-mr-2\"\r\n            ></button>\r\n            <button\r\n              *ngIf=\"editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pCancelEditableRow\r\n              icon=\"pi pi-times-circle\"\r\n              (click)=\"onRowEditCancel(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-danger\"\r\n            ></button>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template pTemplate=\"rowexpansion\" let-lookupTable>\r\n        <tr style=\"background: lime !important\">\r\n          <td colspan=\"7\">\r\n            <div class=\"p-3\">\r\n              <prg-lookup-table-items-table\r\n                [lookupTableItems]=\"lookupTable.value.items\"\r\n                [lookupTableId]=\"lookupTable.value.id\"\r\n                (savedItems)=\"itemsSaved($event)\"\r\n              ></prg-lookup-table-items-table>\r\n            </div>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template pTemplate=\"emptymessage\">\r\n        <tr style=\"background: white !important\" class=\"emptyInfo\">\r\n          <td colspan=\"6\">\r\n            <p-progressSpinner\r\n              *ngIf=\"isLoadingDataService.visibility | async; else elseBlock\"\r\n              [style]=\"{ width: '50px', height: '50px' }\"\r\n            ></p-progressSpinner>\r\n            <ng-template #elseBlock>\r\n              {{ 'withoutLookuptable' | translate }}</ng-template\r\n            >\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n    </p-table>\r\n  </div>\r\n</form>\r\n", styles: ["th,td{text-align:center!important}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.AbstractLookupTableService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_LOOKUP_TABLE_CONFIG]
                }] }, { type: i2.IsLoadingDataService }, { type: i3.FormBuilder }, { type: i4.FormGroupService }, { type: i5.ObjectsUtilityService }]; }, propDecorators: { dataTable: [{
                type: ViewChild,
                args: [Table]
            }] } });
//# sourceMappingURL=data:application/json;base64,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