import { Component, EventEmitter, Inject, Input, Output, ViewChild, } from '@angular/core';
import { Table } from 'primeng/table';
import { PRG_LOOKUP_TABLE_CONFIG } from '../../../../services/lookup-table-configuration/prg-lookup-table-configuration.service';
import * as i0 from "@angular/core";
import * as i1 from "../../../../services/lookup-table/abstract-lookup-table.service";
import * as i2 from "../../../../../core/services/is-loading-data/isloadingdata.service";
import * as i3 from "@angular/forms";
import * as i4 from "../../../../../core/services/form-group/form-group.service";
import * as i5 from "../../../../../core/services/utility/objects-utility.service";
import * as i6 from "primeng/inputtext";
import * as i7 from "primeng/api";
import * as i8 from "@angular/common";
import * as i9 from "primeng/progressspinner";
import * as i10 from "primeng/table";
import * as i11 from "primeng/button";
import * as i12 from "primeng/ripple";
import * as i13 from "@ngx-translate/core";
/**
 * Lookup table items component
 */
export class PrgLookupTableItemsTableComponent {
    /**
     * construtor
     *
     * @param prgLookupTableConfig prgLookupTableConfig
     * @param lookupTableService
     * @param isLoadingDataService isLoadingDataService
     * @param formBuilder
     * @param formGroupService
     * @param objectsUtilityService
     */
    constructor(prgLookupTableConfig, lookupTableService, isLoadingDataService, formBuilder, formGroupService, objectsUtilityService) {
        this.prgLookupTableConfig = prgLookupTableConfig;
        this.lookupTableService = lookupTableService;
        this.isLoadingDataService = isLoadingDataService;
        this.formBuilder = formBuilder;
        this.formGroupService = formGroupService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * Output with item saved
         */
        this.savedItems = new EventEmitter();
        /**
         *  new Lookup Table Id Prefix
         */
        this.newLookupTableItemIdPrefix = 'newLookupTable:';
        /**
         * Table columns
         */
        this.lookupTableItemsColumns = this.prgLookupTableConfig.lookupTableItemsColumns;
        /**
         * Map to save temporarily the items in edit mode
         */
        this.clonedLookupTableItems = new Map();
        /**
         * auxiliary variable to help define the id of the new lookuptables
         */
        this.newLookupTableItemIdCount = 0;
    }
    set lookupTableItems(items) {
        this.lookupTableItemsForm = this.formBuilder.group({
            lookupTableItemsDetails: this.formBuilder.array([]),
        });
        if (items) {
            this._lookupTableItems = items;
            this.populateFormGroup();
        }
    }
    /**
     * Return lookup table form array
     */
    get lookupTableItemsDetails() {
        return this.lookupTableItemsForm.get('lookupTableItemsDetails');
    }
    /**
     * return lookup table control for given lookup table item
     * @param lookupTableItemId
     * @returns Control
     */
    getLookupTableItemControlById(lookupTableItemId) {
        return this.lookupTableItemsDetails.controls.find((control) => control.value.id === lookupTableItemId);
    }
    /**
     * this function is responsible for adding a new row
     * to the table for the user to configure the new lookuptableItem
     *
     */
    addNewLookupTableItem() {
        const newLookupTableItem = {
            id: `${this.newLookupTableItemIdPrefix}${this.newLookupTableItemIdCount}`,
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: null,
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: null,
            description: null,
            lookupTableId: this.lookupTableId,
        };
        this.newLookupTableItemIdCount++;
        // add new element to form Array
        this.lookupTableItemsDetails.insert(0, this.formGroupService.toFormGroupOneObject(newLookupTableItem, this.lookupTableItemsColumns));
        this.lookupTableItemsForm.markAllAsTouched();
        this.dataTableItems.editingRowKeys[newLookupTableItem.id] = true;
    }
    /**
     * this function is responsible for creating a
     * clone of a lookup Table item that is selected for editing
     *
     * @param lookupTable
     */
    onRowEditInit(item) {
        this.clonedLookupTableItems.set(item.id, { ...item });
    }
    /**
     * this function is responsible for saving a lookup table item,
     * either an update or adding a new lookup table item to the database
     *
     * @param lookupTable
     */
    async onRowEditSave(item) {
        const lookupTableItemToSave = this.objectsUtilityService.cloneObject(item);
        if (lookupTableItemToSave.id.includes(this.newLookupTableItemIdPrefix)) {
            lookupTableItemToSave.id = null;
        }
        this.lookupTableService
            .saveLookupTableItemAsync(lookupTableItemToSave)
            .then((response) => {
            this.getLookupTableItemControlById(item.id).setValue(response);
            delete this.dataTableItems.editingRowKeys[item.id];
            this.clonedLookupTableItems.delete(item.id);
            this.savedItems.emit(this.lookupTableId);
        });
    }
    /**
     * this function is responsible for restoring the data
     * that was there before starting the edit if the
     * lookup table item is already in the database,
     * otherwise it just deletes the row that was temporarily created
     *
     * @param lookupTable
     */
    onRowEditCancel(item) {
        if (item.id.includes(this.newLookupTableItemIdPrefix)) {
            this.lookupTableItemsDetails.removeAt(this.getLookupTableItemControlIndexById(item.id));
        }
        else {
            const lookupTableItemOrignal = this.clonedLookupTableItems.get(item.id);
            this.getLookupTableItemControlById(item.id).setValue(lookupTableItemOrignal);
        }
    }
    /**
     * this function is responsible for saving
     * all active edits (new lines or updating existing ones)
     */
    async saveAllChanges() {
        let lookupTablesItemsToSave = [];
        Object.getOwnPropertyNames(this.dataTableItems.editingRowKeys).forEach((element) => {
            if (element.includes(this.newLookupTableItemIdPrefix)) {
                const lookupTableAux = this.objectsUtilityService.cloneObject(this.getLookupTableItemControlById(element).value);
                lookupTableAux.id = null;
                lookupTablesItemsToSave.push(lookupTableAux);
            }
            else {
                lookupTablesItemsToSave.push(this.objectsUtilityService.cloneObject(this.getLookupTableItemControlById(element).value));
            }
        });
        this.lookupTableService
            .saveMultipleLookupTableItemsAsync(lookupTablesItemsToSave)
            .then((response) => {
            response.forEach((slt) => {
                const lookupTableById = this.getLookupTableItemControlById(slt.id);
                if (lookupTableById) {
                    lookupTableById.setValue(slt);
                }
                else {
                    this.lookupTableItemsDetails.push(this.formGroupService.toFormGroupOneObject(slt, this.lookupTableItemsColumns));
                }
            });
            this.clonedLookupTableItems.clear();
            this.deleteAllTempLookupTable();
            this.dataTableItems.editingRowKeys = {};
            this.savedItems.emit(this.lookupTableId);
        });
    }
    /**
     * this function is responsible for discarding
     * all active edits, and resetting the data that
     * was set before starting the edit
     */
    discardAllChanges() {
        Object.getOwnPropertyNames(this.dataTableItems.editingRowKeys).forEach((element) => {
            if (element.includes(this.newLookupTableItemIdPrefix)) {
                this.lookupTableItemsDetails.removeAt(this.getLookupTableItemControlIndexById(element));
            }
            else {
                this.getLookupTableItemControlById(element).setValue(this.clonedLookupTableItems.get(element));
            }
        });
        this.clonedLookupTableItems.clear();
        this.dataTableItems.editingRowKeys = {};
    }
    /**
     * this function is responsible for sorting a given column
     * @param event
     */
    customSort(event) {
        event.data.sort((data1, data2) => {
            let value1 = data1.value[event.field];
            let value2 = data2.value[event.field];
            let result = null;
            if (value1 == null && value2 != null)
                result = -1;
            else if (value1 != null && value2 == null)
                result = 1;
            else if (value1 == null && value2 == null)
                result = 0;
            else if (typeof value1 === 'string' && typeof value2 === 'string')
                result = value1.localeCompare(value2);
            else
                result = value1 < value2 ? -1 : value1 > value2 ? 1 : 0;
            return event.order * result;
        });
    }
    /**
     * return lookup table item control for given lookup table item id
     * @param lookupTableItemId
     * @returns number
     */
    getLookupTableItemControlIndexById(lookupTableItemId) {
        return this.lookupTableItemsDetails.controls.findIndex((control) => control.value.id === lookupTableItemId);
    }
    /**
     * Populate data into Form
     */
    populateFormGroup() {
        const aux = this.formGroupService.toFormGroupMultipleObjects(this._lookupTableItems, this.lookupTableItemsColumns);
        aux.forEach((a) => {
            this.lookupTableItemsDetails.push(a);
        });
    }
    /**
     * this function is an auxiliary function that is used in the [saveAllChanges]{@link #saveAllChanges}
     *  function to delete all temporary rows that will be added later
     */
    deleteAllTempLookupTable() {
        const tempLookupTable = this.lookupTableItemsDetails.controls.filter((control) => control.value.id.includes(this.newLookupTableItemIdPrefix));
        if (tempLookupTable.length > 0) {
            tempLookupTable.forEach((tlt) => {
                this.lookupTableItemsDetails.removeAt(this.getLookupTableItemControlIndexById(tlt.value.id));
            });
        }
    }
}
PrgLookupTableItemsTableComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableItemsTableComponent, deps: [{ token: PRG_LOOKUP_TABLE_CONFIG }, { token: i1.AbstractLookupTableService }, { token: i2.IsLoadingDataService }, { token: i3.FormBuilder }, { token: i4.FormGroupService }, { token: i5.ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgLookupTableItemsTableComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgLookupTableItemsTableComponent, selector: "prg-lookup-table-items-table", inputs: { lookupTableId: "lookupTableId", lookupTableItems: "lookupTableItems" }, outputs: { savedItems: "savedItems" }, viewQueries: [{ propertyName: "dataTableItems", first: true, predicate: Table, descendants: true }], ngImport: i0, template: "<form [formGroup]=\"lookupTableItemsForm\">\r\n  <div formArrayName=\"lookupTableItemsDetails\">\r\n    <p-table\r\n      *ngIf=\"lookupTableItemsDetails\"\r\n      #table\r\n      [value]=\"lookupTableItemsDetails.controls\"\r\n      dataKey=\"value.id\"\r\n      responsiveLayout=\"scroll\"\r\n      editMode=\"row\"\r\n      (sortFunction)=\"customSort($event)\"\r\n      [customSort]=\"true\"\r\n    >\r\n      <ng-template pTemplate=\"header\">\r\n        <tr>\r\n          <ng-container *ngFor=\"let column of lookupTableItemsColumns\">\r\n            <th\r\n              [pSortableColumn]=\"column.key\"\r\n              [pSortableColumnDisabled]=\"\r\n                isLoadingDataService.visibility | async\r\n              \"\r\n            >\r\n              {{\r\n                'components.lookup-table.lookup-table-items.columns.' +\r\n                  column.key +\r\n                  '.label' | translate\r\n              }}\r\n              <p-sortIcon [field]=\"column.key\"></p-sortIcon>\r\n            </th>\r\n          </ng-container>\r\n          <th style=\"width: 10rem\">\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-plus-circle\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n              (click)=\"addNewLookupTableItem()\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-save\"\r\n              [disabled]=\"\r\n                (isLoadingDataService.visibility | async) ||\r\n                lookupTableItemsDetails.status === 'INVALID'\r\n              \"\r\n              (click)=\"saveAllChanges()\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-trash\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n              (click)=\"discardAllChanges()\"\r\n            ></p-button>\r\n          </th>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template\r\n        pTemplate=\"body\"\r\n        let-rowData\r\n        let-editing=\"editing\"\r\n        let-ri=\"rowIndex\"\r\n      >\r\n        <tr [pEditableRow]=\"rowData\" [formGroupName]=\"ri\">\r\n          <ng-container *ngFor=\"let column of lookupTableItemsColumns\">\r\n            <td pEditableColumn *ngIf=\"editing; else elseBlock\">\r\n              <p-cellEditor>\r\n                <ng-template pTemplate=\"input\">\r\n                  <input\r\n                    *ngIf=\"\r\n                      !column.readonly ||\r\n                        !!rowData.value.id.includes('newLookupTable');\r\n                      else notEditableColumn\r\n                    \"\r\n                    [placeholder]=\"'placeholder' + column.key | translate\"\r\n                    pInputText\r\n                    type=\"text\"\r\n                    [formControlName]=\"column.key\"\r\n                  />\r\n                  <ng-template pTemplate=\"input\" #notEditableColumn>\r\n                    {{ rowData.value[column.key] | translate }}\r\n                  </ng-template>\r\n                </ng-template>\r\n              </p-cellEditor>\r\n            </td>\r\n            <!-- Fixes bug that allows user to edit row without first clicking on the edit button-->\r\n            <ng-template #elseBlock>\r\n              <td>{{ rowData.value[column.key] | translate }}</td>\r\n            </ng-template>\r\n          </ng-container>\r\n\r\n          <td style=\"text-align: center\">\r\n            <button\r\n              *ngIf=\"!editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pInitEditableRow\r\n              icon=\"pi pi-pencil\"\r\n              (click)=\"onRowEditInit(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text\"\r\n            ></button>\r\n\r\n            <button\r\n              *ngIf=\"editing\"\r\n              [disabled]=\"\r\n                getLookupTableItemControlById(rowData.value.id).status !==\r\n                'VALID'\r\n              \"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pSaveEditableRow\r\n              icon=\"pi pi-check-circle\"\r\n              (click)=\"onRowEditSave(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-success p-mr-2\"\r\n            ></button>\r\n            <button\r\n              *ngIf=\"editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pCancelEditableRow\r\n              icon=\"pi pi-times-circle\"\r\n              (click)=\"onRowEditCancel(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-danger\"\r\n            ></button>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n\r\n      <ng-template pTemplate=\"emptymessage\">\r\n        <tr class=\"emptyInfo\">\r\n          <td colspan=\"6\">\r\n            <p-progressSpinner\r\n              *ngIf=\"isLoadingDataService.visibility | async; else elseBlock\"\r\n              [style]=\"{ width: '50px', height: '50px' }\"\r\n            >\r\n            </p-progressSpinner>\r\n            <ng-template #elseBlock>\r\n              {{ 'withoutLookuptableItems' | translate }}\r\n            </ng-template>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n    </p-table>\r\n  </div>\r\n</form>\r\n", styles: [".emptyInfo td{text-align:center}\n"], dependencies: [{ kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i7.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i8.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i8.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i9.ProgressSpinner, selector: "p-progressSpinner", inputs: ["style", "styleClass", "strokeWidth", "fill", "animationDuration"] }, { kind: "component", type: i10.Table, selector: "p-table", inputs: ["frozenColumns", "frozenValue", "style", "styleClass", "tableStyle", "tableStyleClass", "paginator", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "paginatorDropdownScrollHeight", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showJumpToPageInput", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "selectionMode", "selectionPageOnly", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "rowSelectable", "rowTrackBy", "lazy", "lazyLoadOnInit", "compareSelectionBy", "csvSeparator", "exportFilename", "filters", "globalFilterFields", "filterDelay", "filterLocale", "expandedRowKeys", "editingRowKeys", "rowExpandMode", "scrollable", "scrollDirection", "rowGroupMode", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "responsive", "contextMenu", "resizableColumns", "columnResizeMode", "reorderableColumns", "loading", "loadingIcon", "showLoader", "rowHover", "customSort", "showInitialSortBadge", "autoLayout", "exportFunction", "exportHeader", "stateKey", "stateStorage", "editMode", "groupRowsBy", "groupRowsByOrder", "responsiveLayout", "breakpoint", "virtualRowHeight", "value", "columns", "first", "rows", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection", "selectAll"], outputs: ["selectAllChange", "selectionChange", "contextMenuSelectionChange", "onRowSelect", "onRowUnselect", "onPage", "onSort", "onFilter", "onLazyLoad", "onRowExpand", "onRowCollapse", "onContextMenuSelect", "onColResize", "onColReorder", "onRowReorder", "onEditInit", "onEditComplete", "onEditCancel", "onHeaderCheckboxToggle", "sortFunction", "firstChange", "rowsChange", "onStateSave", "onStateRestore"] }, { kind: "directive", type: i10.SortableColumn, selector: "[pSortableColumn]", inputs: ["pSortableColumn", "pSortableColumnDisabled"] }, { kind: "directive", type: i10.EditableColumn, selector: "[pEditableColumn]", inputs: ["pEditableColumn", "pEditableColumnField", "pEditableColumnRowIndex", "pEditableColumnDisabled", "pFocusCellSelector"] }, { kind: "component", type: i10.CellEditor, selector: "p-cellEditor" }, { kind: "component", type: i10.SortIcon, selector: "p-sortIcon", inputs: ["field"] }, { kind: "directive", type: i10.EditableRow, selector: "[pEditableRow]", inputs: ["pEditableRow", "pEditableRowDisabled"] }, { kind: "directive", type: i10.InitEditableRow, selector: "[pInitEditableRow]" }, { kind: "directive", type: i10.SaveEditableRow, selector: "[pSaveEditableRow]" }, { kind: "directive", type: i10.CancelEditableRow, selector: "[pCancelEditableRow]" }, { kind: "directive", type: i11.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i11.Button, selector: "p-button", inputs: ["type", "iconPos", "icon", "badge", "label", "disabled", "loading", "loadingIcon", "style", "styleClass", "badgeClass", "ariaLabel"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "directive", type: i12.Ripple, selector: "[pRipple]" }, { kind: "directive", type: i3.ɵNgNoValidate, selector: "form:not([ngNoForm]):not([ngNativeValidate])" }, { kind: "directive", type: i3.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i3.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i3.NgControlStatusGroup, selector: "[formGroupName],[formArrayName],[ngModelGroup],[formGroup],form:not([ngNoForm]),[ngForm]" }, { kind: "directive", type: i3.FormGroupDirective, selector: "[formGroup]", inputs: ["formGroup"], outputs: ["ngSubmit"], exportAs: ["ngForm"] }, { kind: "directive", type: i3.FormControlName, selector: "[formControlName]", inputs: ["formControlName", "disabled", "ngModel"], outputs: ["ngModelChange"] }, { kind: "directive", type: i3.FormGroupName, selector: "[formGroupName]", inputs: ["formGroupName"] }, { kind: "directive", type: i3.FormArrayName, selector: "[formArrayName]", inputs: ["formArrayName"] }, { kind: "pipe", type: i8.AsyncPipe, name: "async" }, { kind: "pipe", type: i13.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLookupTableItemsTableComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-lookup-table-items-table', template: "<form [formGroup]=\"lookupTableItemsForm\">\r\n  <div formArrayName=\"lookupTableItemsDetails\">\r\n    <p-table\r\n      *ngIf=\"lookupTableItemsDetails\"\r\n      #table\r\n      [value]=\"lookupTableItemsDetails.controls\"\r\n      dataKey=\"value.id\"\r\n      responsiveLayout=\"scroll\"\r\n      editMode=\"row\"\r\n      (sortFunction)=\"customSort($event)\"\r\n      [customSort]=\"true\"\r\n    >\r\n      <ng-template pTemplate=\"header\">\r\n        <tr>\r\n          <ng-container *ngFor=\"let column of lookupTableItemsColumns\">\r\n            <th\r\n              [pSortableColumn]=\"column.key\"\r\n              [pSortableColumnDisabled]=\"\r\n                isLoadingDataService.visibility | async\r\n              \"\r\n            >\r\n              {{\r\n                'components.lookup-table.lookup-table-items.columns.' +\r\n                  column.key +\r\n                  '.label' | translate\r\n              }}\r\n              <p-sortIcon [field]=\"column.key\"></p-sortIcon>\r\n            </th>\r\n          </ng-container>\r\n          <th style=\"width: 10rem\">\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-plus-circle\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n              (click)=\"addNewLookupTableItem()\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-save\"\r\n              [disabled]=\"\r\n                (isLoadingDataService.visibility | async) ||\r\n                lookupTableItemsDetails.status === 'INVALID'\r\n              \"\r\n              (click)=\"saveAllChanges()\"\r\n            ></p-button>\r\n            <p-button\r\n              type=\"button\"\r\n              icon=\"pi pi-trash\"\r\n              [disabled]=\"isLoadingDataService.visibility | async\"\r\n              (click)=\"discardAllChanges()\"\r\n            ></p-button>\r\n          </th>\r\n        </tr>\r\n      </ng-template>\r\n      <ng-template\r\n        pTemplate=\"body\"\r\n        let-rowData\r\n        let-editing=\"editing\"\r\n        let-ri=\"rowIndex\"\r\n      >\r\n        <tr [pEditableRow]=\"rowData\" [formGroupName]=\"ri\">\r\n          <ng-container *ngFor=\"let column of lookupTableItemsColumns\">\r\n            <td pEditableColumn *ngIf=\"editing; else elseBlock\">\r\n              <p-cellEditor>\r\n                <ng-template pTemplate=\"input\">\r\n                  <input\r\n                    *ngIf=\"\r\n                      !column.readonly ||\r\n                        !!rowData.value.id.includes('newLookupTable');\r\n                      else notEditableColumn\r\n                    \"\r\n                    [placeholder]=\"'placeholder' + column.key | translate\"\r\n                    pInputText\r\n                    type=\"text\"\r\n                    [formControlName]=\"column.key\"\r\n                  />\r\n                  <ng-template pTemplate=\"input\" #notEditableColumn>\r\n                    {{ rowData.value[column.key] | translate }}\r\n                  </ng-template>\r\n                </ng-template>\r\n              </p-cellEditor>\r\n            </td>\r\n            <!-- Fixes bug that allows user to edit row without first clicking on the edit button-->\r\n            <ng-template #elseBlock>\r\n              <td>{{ rowData.value[column.key] | translate }}</td>\r\n            </ng-template>\r\n          </ng-container>\r\n\r\n          <td style=\"text-align: center\">\r\n            <button\r\n              *ngIf=\"!editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pInitEditableRow\r\n              icon=\"pi pi-pencil\"\r\n              (click)=\"onRowEditInit(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text\"\r\n            ></button>\r\n\r\n            <button\r\n              *ngIf=\"editing\"\r\n              [disabled]=\"\r\n                getLookupTableItemControlById(rowData.value.id).status !==\r\n                'VALID'\r\n              \"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pSaveEditableRow\r\n              icon=\"pi pi-check-circle\"\r\n              (click)=\"onRowEditSave(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-success p-mr-2\"\r\n            ></button>\r\n            <button\r\n              *ngIf=\"editing\"\r\n              pButton\r\n              pRipple\r\n              type=\"button\"\r\n              pCancelEditableRow\r\n              icon=\"pi pi-times-circle\"\r\n              (click)=\"onRowEditCancel(rowData.value)\"\r\n              class=\"p-button-rounded p-button-text p-button-danger\"\r\n            ></button>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n\r\n      <ng-template pTemplate=\"emptymessage\">\r\n        <tr class=\"emptyInfo\">\r\n          <td colspan=\"6\">\r\n            <p-progressSpinner\r\n              *ngIf=\"isLoadingDataService.visibility | async; else elseBlock\"\r\n              [style]=\"{ width: '50px', height: '50px' }\"\r\n            >\r\n            </p-progressSpinner>\r\n            <ng-template #elseBlock>\r\n              {{ 'withoutLookuptableItems' | translate }}\r\n            </ng-template>\r\n          </td>\r\n        </tr>\r\n      </ng-template>\r\n    </p-table>\r\n  </div>\r\n</form>\r\n", styles: [".emptyInfo td{text-align:center}\n"] }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_LOOKUP_TABLE_CONFIG]
                }] }, { type: i1.AbstractLookupTableService }, { type: i2.IsLoadingDataService }, { type: i3.FormBuilder }, { type: i4.FormGroupService }, { type: i5.ObjectsUtilityService }]; }, propDecorators: { dataTableItems: [{
                type: ViewChild,
                args: [Table]
            }], lookupTableId: [{
                type: Input
            }], lookupTableItems: [{
                type: Input,
                args: ['lookupTableItems']
            }], savedItems: [{
                type: Output
            }] } });
//# sourceMappingURL=data:application/json;base64,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