import { Inject, Injectable } from '@angular/core';
import { BehaviorSubject } from 'rxjs';
import { PRG_AUTH_CONFIG } from '../../auth/services/prg-auth-configuration/prg-auth-configuration.service';
import { PRG_CONFIGURATION_ITEMS_CONFIG } from '../../configuration-items/services/prg-configuration-items-config/prg-configuration-items-config.service';
import { PRG_DASHBOARD_CONFIG } from '../../dashboard/services/prg-dashboard-configuration/prg-dashboard-configuration.service';
import { PRG_ENTITY_TYPES_CONFIG } from '../../entity-types/services/entity-types-configuration/prg-entity-types-configuration.service';
import { PRG_LOOKUP_TABLE_CONFIG } from '../../lookup-table/services/lookup-table-configuration/prg-lookup-table-configuration.service';
import { PRG_QUERIES_CONFIG } from '../../queries/services/prg-queries-configuration/prg-queries-configuration.service';
import { PRG_ROLES_SCOPES_CONFIG } from '../../roles-scopes/services/roles-scopes-configuration/prg-roles-scopes-configuration.service';
import { PRG_TERMS_CONFIG } from '../../terms/services/prg-terms-configuration/prg-terms-configuration.service';
import * as i0 from "@angular/core";
import * as i1 from "../../core/services/utility/array-utility.service";
import * as i2 from "@ngx-translate/core";
import * as i3 from "../../core/services/utility/utility.service";
/**
 * Injectable
 */
/**
 * Main Layout Service
 */
export class MainLayoutService {
    /**
     * constructor
     * @param {PrgAuthConfig} authConfig
     * @param {PrgEntityTypesConfig} entityTypesConfig
     * @param {PrgLookupTableConfig} lookupTableConfig
     * @param {PrgQueriesConfig} queriesConfig
     * @param {PrgRolesScopesConfig} rolesScopesConfig
     * @param {PrgTermsConfig} termsConfig
     * @param {PrgDashboardConfig} dashboardConfig
     * @param {PrgConfigurationItemsConfig} configItemsConfig
     * @param {ArrayUtilityService} arrayUtility
     * @param {TranslateService} translateService
     * @param {UtilityService} utilityService
     */
    constructor(authConfig, entityTypesConfig, lookupTableConfig, queriesConfig, rolesScopesConfig, termsConfig, configItemsConfig, dashboardConfig, arrayUtility, translateService, utilityService) {
        this.authConfig = authConfig;
        this.entityTypesConfig = entityTypesConfig;
        this.lookupTableConfig = lookupTableConfig;
        this.queriesConfig = queriesConfig;
        this.rolesScopesConfig = rolesScopesConfig;
        this.termsConfig = termsConfig;
        this.configItemsConfig = configItemsConfig;
        this.dashboardConfig = dashboardConfig;
        this.arrayUtility = arrayUtility;
        this.translateService = translateService;
        this.utilityService = utilityService;
        /**
         * Current state of SideBar
         */
        this.sideBarSubject = new BehaviorSubject(null);
        /**
         * Show/hide header subject
         * @type {BehaviorSubject<boolean>}
         * @private
         */
        this.displayHeaderSubject = new BehaviorSubject(true);
    }
    /**
     * Setter for sideBarSubject
     * @param value
     */
    setSideBarState(value) {
        this.sideBarSubject.next(value);
    }
    /**
     * Getter for sideBarSubject
     *
     * @returns The sideBarSubject as an observable
     */
    getSideBarStateObservable() {
        return this.sideBarSubject.asObservable();
    }
    /**
     * Getter for sideBarSubject
     *
     * @returns The sideBarSubject current value
     */
    getSideBarStateValue() {
        return this.sideBarSubject.getValue();
    }
    /**
     * Setter for displayHeaderSubject
     * @param value
     */
    setDisplayHeaderState(value) {
        this.displayHeaderSubject.next(value);
    }
    /**
     * Getter for displayHeaderSubject
     *
     * @returns The sideBarSubject as an observable
     */
    getDisplayHeaderStateObservable() {
        return this.displayHeaderSubject.asObservable();
    }
    /**
     * Getter for displayHeaderSubject
     *
     * @returns The sideBarSubject current value
     */
    getDisplayHeaderStateValue() {
        return this.displayHeaderSubject.getValue();
    }
    /**
  
    /**
     * Function responsible to complete sidebar menu with labels of selected language
     * @param {PrgMenuItem[]} mainMenu
     * @param {boolean} mainMenuExpanded
     * @returns {Promise<MenuItem[]>}
     */
    async getSideBarMenuItemsWithLabelsAsync(mainMenu, mainMenuExpanded) {
        let sideBarMenuItems = this.arrayUtility.clone(mainMenu);
        sideBarMenuItems.map(async (item) => {
            if (item.id) {
                if (mainMenuExpanded) {
                    item.label = await this.translateService
                        .get('components.sidebar.' + item.id + '.label')
                        .toPromise();
                }
                else {
                    if (!item.items) {
                        item.tooltipOptions = {
                            tooltipLabel: await this.translateService
                                .get('components.sidebar.' + item.id + '.label')
                                .toPromise(),
                        };
                    }
                }
            }
            if (item.items) {
                if (!mainMenuExpanded) {
                    item.items.unshift({
                        separator: true,
                    });
                    item.items.unshift({
                        label: await this.translateService
                            .get('components.sidebar.' + item.id + '.label')
                            .toPromise(),
                        style: {
                            'pointer-events': 'none',
                            'font-weight': 'bold',
                        },
                    });
                }
                item.items.map(async (itemChildren) => {
                    if (itemChildren.id) {
                        itemChildren.label = await this.translateService
                            .get('components.sidebar.' +
                            item.id +
                            '.' +
                            itemChildren.id +
                            '.label')
                            .toPromise();
                    }
                });
            }
        });
        return Promise.all(sideBarMenuItems);
    }
    /**
     * Function responsible to complete header menus (user and language) with labels of selected language
     * @param {PrgMenuItem[]} menuItem
     * @returns {Promise<PrgMenuItem[]>}
     */
    async getHeaderMenuItemsWithLabelsAsync(menuItem) {
        let menuItemWithLabels = this.arrayUtility.clone(menuItem);
        if (menuItem[0].id) {
            menuItemWithLabels[0].label = await this.translateService
                .get('components.header.' + menuItem[0].id + '.label')
                .toPromise();
        }
        menuItem[0].items.map(async (item, index) => {
            if (item.id) {
                menuItemWithLabels[0].items[index].label = await this.translateService
                    .get('components.header.' + menuItem[0].id + '.' + item.id + '.label')
                    .toPromise();
            }
        });
        return Promise.all(menuItemWithLabels);
    }
    /**
     * Function responsible to handle auxiliary string properties of menu type PrgMenuItem
     * @param {PrgMenuItem[]} menuItems
     * @param context
     * @returns {PrgMenuItem[]}
     */
    mapMenuItemsHelpers(menuItems, context) {
        let menuItemsWithHelpersMapped = this.arrayUtility.clone(menuItems);
        menuItemsWithHelpersMapped.map((items, mainIndex) => {
            if (items.commandString) {
                items.command = this.utilityService.evalFunction(items.commandString, context);
            }
            if (items.visibleString) {
                items.visible = this.utilityService.evalFunction(items.visibleString, context);
            }
            if (items.routerLinkString) {
                items.routerLink = this.utilityService.evalFunction(items.routerLinkString, this);
            }
            if (menuItemsWithHelpersMapped[mainIndex].items) {
                menuItemsWithHelpersMapped[mainIndex].items.forEach((subItems) => {
                    if (subItems.commandString) {
                        subItems.command = this.utilityService.evalFunction(subItems.commandString, context);
                    }
                    if (subItems.visibleString) {
                        subItems.visible = this.utilityService.evalFunction(subItems.visibleString, context);
                    }
                    if (subItems.routerLinkString) {
                        subItems.routerLink = this.utilityService.evalFunction(subItems.routerLinkString, this);
                    }
                });
            }
        });
        return menuItemsWithHelpersMapped;
    }
}
MainLayoutService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MainLayoutService, deps: [{ token: PRG_AUTH_CONFIG }, { token: PRG_ENTITY_TYPES_CONFIG }, { token: PRG_LOOKUP_TABLE_CONFIG }, { token: PRG_QUERIES_CONFIG }, { token: PRG_ROLES_SCOPES_CONFIG }, { token: PRG_TERMS_CONFIG }, { token: PRG_CONFIGURATION_ITEMS_CONFIG }, { token: PRG_DASHBOARD_CONFIG }, { token: i1.ArrayUtilityService }, { token: i2.TranslateService }, { token: i3.UtilityService }], target: i0.ɵɵFactoryTarget.Injectable });
MainLayoutService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MainLayoutService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: MainLayoutService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_AUTH_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ENTITY_TYPES_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_LOOKUP_TABLE_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_QUERIES_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ROLES_SCOPES_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_TERMS_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_CONFIGURATION_ITEMS_CONFIG]
                }] }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_DASHBOARD_CONFIG]
                }] }, { type: i1.ArrayUtilityService }, { type: i2.TranslateService }, { type: i3.UtilityService }]; } });
//# sourceMappingURL=data:application/json;base64,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