import { Component, } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "ngx-logger";
import * as i2 from "../../core/services/is-loading-data/isloadingdata.service";
import * as i3 from "@angular/router";
import * as i4 from "@angular/common";
import * as i5 from "primeng/progressspinner";
import * as i6 from "primeng/toast";
import * as i7 from "primeng/confirmdialog";
/**
 * Empty Layout component, contains a router-outlet
 * <br />that displays child components
 */
export class PrgLayoutsEmptyComponent {
    /**
     * Constructor
     * @param logger
     * @param isLoadingData isLoadingData
     * @param cdr
     */
    constructor(logger, isLoadingData, cdr) {
        this.logger = logger;
        this.isLoadingData = isLoadingData;
        this.cdr = cdr;
        /**
         * spinnerVisible value
         */
        this.spinnerVisible = false;
        /**
         * subscriptions
         */
        this.subscriptions = [];
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.logger.debug('EMPTY LAYOUT ON INIT');
    }
    /**
     * ngOnInit
     */
    ionViewWillEnter() {
        this.logger.debug('EMPTY LAYOUT WILL ENTER');
    }
    /**
     * ngOnInit
     */
    ionViewWillLeave() {
        this.logger.debug('EMPTY LAYOUT WILL LEAVE');
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.logger.debug('EMPTY LAYOUT ON DESTROY');
        this.subscriptions.forEach((subscription) => {
            subscription.unsubscribe();
        });
        this.subscriptions = [];
    }
    /**
     * ngAfterContentChecked
     */
    ngAfterContentChecked() {
        this.subscriptions.push(this.isLoadingData.visibility.subscribe((visible) => {
            this.spinnerVisible = visible;
            this.cdr.detectChanges();
        }));
    }
}
PrgLayoutsEmptyComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLayoutsEmptyComponent, deps: [{ token: i1.NGXLogger }, { token: i2.IsLoadingDataService }, { token: i0.ChangeDetectorRef }], target: i0.ɵɵFactoryTarget.Component });
PrgLayoutsEmptyComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgLayoutsEmptyComponent, selector: "prg-layouts-empty", ngImport: i0, template: "<main>\r\n  <router-outlet></router-outlet>\r\n  <p-toast\r\n    [showTransitionOptions]=\"'350ms'\"\r\n    [hideTransitionOptions]=\"'350ms'\"\r\n    [showTransformOptions]=\"'translateY(-100%)'\"\r\n    key=\"message\"\r\n    position=\"top-center\"\r\n    appendTo=\"body\"\r\n  ></p-toast>\r\n  <p-confirmDialog\r\n    [style]=\"{ width: '50vw' }\"\r\n    rejectButtonStyleClass=\"p-button-text\"\r\n    key=\"confirmationDialog\"\r\n    appendTo=\"body\"\r\n    [dismissableMask]=\"true\"\r\n  ></p-confirmDialog>\r\n\r\n  <p-progressSpinner\r\n    *ngIf=\"spinnerVisible\"\r\n    class=\"spinnerPNG\"\r\n    [style]=\"{ width: '120px', height: '120px' }\"\r\n  ></p-progressSpinner>\r\n  <div class=\"mainContainer\"></div>\r\n</main>\r\n", styles: [".spinnerPNG{width:100%;height:100%;position:sticky;display:flex;align-items:center;z-index:999999}.mainContainer{position:relative}main{height:100vh;overflow:auto}\n"], dependencies: [{ kind: "directive", type: i3.RouterOutlet, selector: "router-outlet", outputs: ["activate", "deactivate", "attach", "detach"], exportAs: ["outlet"] }, { kind: "directive", type: i4.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i5.ProgressSpinner, selector: "p-progressSpinner", inputs: ["style", "styleClass", "strokeWidth", "fill", "animationDuration"] }, { kind: "component", type: i6.Toast, selector: "p-toast", inputs: ["key", "autoZIndex", "baseZIndex", "style", "styleClass", "position", "preventOpenDuplicates", "preventDuplicates", "showTransformOptions", "hideTransformOptions", "showTransitionOptions", "hideTransitionOptions", "breakpoints"], outputs: ["onClose"] }, { kind: "component", type: i7.ConfirmDialog, selector: "p-confirmDialog", inputs: ["header", "icon", "message", "style", "styleClass", "maskStyleClass", "acceptIcon", "acceptLabel", "acceptAriaLabel", "acceptVisible", "rejectIcon", "rejectLabel", "rejectAriaLabel", "rejectVisible", "acceptButtonStyleClass", "rejectButtonStyleClass", "closeOnEscape", "dismissableMask", "blockScroll", "rtl", "closable", "appendTo", "key", "autoZIndex", "baseZIndex", "transitionOptions", "focusTrap", "defaultFocus", "breakpoints", "visible", "position"], outputs: ["onHide"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgLayoutsEmptyComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-layouts-empty', template: "<main>\r\n  <router-outlet></router-outlet>\r\n  <p-toast\r\n    [showTransitionOptions]=\"'350ms'\"\r\n    [hideTransitionOptions]=\"'350ms'\"\r\n    [showTransformOptions]=\"'translateY(-100%)'\"\r\n    key=\"message\"\r\n    position=\"top-center\"\r\n    appendTo=\"body\"\r\n  ></p-toast>\r\n  <p-confirmDialog\r\n    [style]=\"{ width: '50vw' }\"\r\n    rejectButtonStyleClass=\"p-button-text\"\r\n    key=\"confirmationDialog\"\r\n    appendTo=\"body\"\r\n    [dismissableMask]=\"true\"\r\n  ></p-confirmDialog>\r\n\r\n  <p-progressSpinner\r\n    *ngIf=\"spinnerVisible\"\r\n    class=\"spinnerPNG\"\r\n    [style]=\"{ width: '120px', height: '120px' }\"\r\n  ></p-progressSpinner>\r\n  <div class=\"mainContainer\"></div>\r\n</main>\r\n", styles: [".spinnerPNG{width:100%;height:100%;position:sticky;display:flex;align-items:center;z-index:999999}.mainContainer{position:relative}main{height:100vh;overflow:auto}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.NGXLogger }, { type: i2.IsLoadingDataService }, { type: i0.ChangeDetectorRef }]; } });
//# sourceMappingURL=data:application/json;base64,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