import { animate, animateChild, group, query, state, style, transition, trigger, } from '@angular/animations';
import { Component, Input } from '@angular/core';
import { SIDEBAR_MENU } from '../menus-structure/sidebar-menu-structure';
import * as i0 from "@angular/core";
import * as i1 from "../../services/main-layout.service";
import * as i2 from "../../../core/services/utility/array-utility.service";
import * as i3 from "@ngx-translate/core";
import * as i4 from "../../../auth/services/auth/abstract-auth.service";
import * as i5 from "../../../core/services/utility/objects-utility.service";
import * as i6 from "primeng/tieredmenu";
import * as i7 from "@angular/common";
import * as i8 from "primeng/button";
import * as i9 from "primeng/ripple";
//TODO: It's missing a way to save user and language preferences (Session / Locale Storage)
/**
 * Component decorator
 */
/**
 * Sidebar Component
 */
export class PrgSidebarComponent {
    /**
     * Constructor
     * @param {MainLayoutService} mainLayoutService mainLayoutService
     * @param {ArrayUtilityService} arrayUtility
     * @param {TranslateService} translateService
     * @param {AuthService} authService
     * @param {ObjectsUtilityService} objectsUtilityService
     */
    constructor(mainLayoutService, arrayUtility, translateService, authService, objectsUtilityService) {
        this.mainLayoutService = mainLayoutService;
        this.arrayUtility = arrayUtility;
        this.translateService = translateService;
        this.authService = authService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * The current state of sidebar menu. Expanded is true and collapsed is false.
         *
         * Default is false.
         * @type {boolean}
         */
        this.mainMenuExpanded = false;
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         * @type {Subscription}
         * @private
         */
        this.subscription = [];
        /**
         * The original Menu data
         * @type {PrgMenuItem[]}
         * @private
         */
        this.mainMenuOriginal = this.arrayUtility.clone(SIDEBAR_MENU);
        /**
         * Defines if header is displayed or not.
         * @type {boolean}
         */
        this.headerDisplay = true;
    }
    /**
     * ngOnInit
     *
     * This method is responsible for:
     *
     * Get the saved state of sidebar in local storage.
     *
     * Verify if are any changes on language selected through on observable
     *
     * @returns {Promise<void>}
     */
    async ngOnInit() {
        let savedStateSideBar = JSON.parse(localStorage.getItem('savedStateSideBar'));
        if (savedStateSideBar) {
            this.mainMenuExpanded = savedStateSideBar;
        }
        this.subscription.push(this.authService.getLoggedUserObservable().subscribe(async (user) => {
            if (user) {
                this.user = this.objectsUtilityService.cloneObject(user);
            }
            else {
                this.user = null;
            }
            await this.getMainMenuItems();
        }));
        await this.getMainMenuItems();
        this.subscription.push(this.translateService.onLangChange.subscribe(async () => {
            await this.getMainMenuItems();
        }));
        this.subscription.push(this.mainLayoutService
            .getDisplayHeaderStateObservable()
            .subscribe((display) => {
            this.headerDisplay = display;
        }));
    }
    /**
     * This method is responsible for calling the functions that will build the menus, one with labels and icons and other with only icons
     * @returns {Promise<void>}
     * @private
     */
    async getMainMenuItems() {
        this.mainMenu = this.arrayUtility.clone(this.mainLayoutService.mapMenuItemsHelpers(this.mainMenuOriginal, this));
        this.mainMenu = this.arrayUtility.clone(await this.mainLayoutService.getSideBarMenuItemsWithLabelsAsync(this.mainMenu, true));
        this.mainMenuIcons = this.arrayUtility.clone(this.mainLayoutService.mapMenuItemsHelpers(this.mainMenuOriginal, this));
        this.mainMenuIcons = this.arrayUtility.clone(await this.mainLayoutService.getSideBarMenuItemsWithLabelsAsync(this.mainMenuIcons, false));
    }
    /**
     * ngOnDestroy
     *
     * Unsubscribe all the observables
     */
    ngOnDestroy() {
        this.subscription.forEach((subscription) => {
            subscription.unsubscribe();
        });
    }
    /**
     * This function is responsible to save the current state of the sidebar menu (expanded - true or collapsed - false) in local storage
     * @returns {Promise<void>}
     */
    async onShowHideSideBarDetails() {
        localStorage.removeItem('savedStateSideBar');
        this.mainMenuExpanded = !this.mainMenuExpanded;
        localStorage.setItem('savedStateSideBar', JSON.stringify(this.mainMenuExpanded));
        this.mainLayoutService.setSideBarState(this.mainMenuExpanded);
    }
}
PrgSidebarComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSidebarComponent, deps: [{ token: i1.MainLayoutService }, { token: i2.ArrayUtilityService }, { token: i3.TranslateService }, { token: i4.AbstractAuthService }, { token: i5.ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgSidebarComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgSidebarComponent, selector: "prg-sidebar", inputs: { mainMenuOriginal: "mainMenuOriginal" }, ngImport: i0, template: "<div class=\"grid-nogutter max-w-max shadow-5\" [ngClass]=\"headerDisplay?'sidebar':'sidebar-no-header'\" >\r\n  <aside class=\"shadow-5 \" >\r\n    <div  class=\"flex flex-column \"\r\n          [@OnExpandSideBar]=\"mainMenuExpanded?'open':'closed'\" [ngClass]=\"headerDisplay?'sidebar':'sidebar-no-header'\">\r\n      <div class=\"pt-2\" *ngIf=\"!mainMenuExpanded\">\r\n        <p-tieredMenu  [styleClass]=\"'collapseSideBar'\"   [autoDisplay]=\"true\" [model]=\"mainMenuIcons\" ></p-tieredMenu>\r\n      </div>\r\n      <section  [@OnExpandSideBarText]=\"mainMenuExpanded?'show-content':'hide-content'\">\r\n        <div class=\"pt-2\" *ngIf=\"mainMenuExpanded\">\r\n          <p-tieredMenu   [autoDisplay]=\"true\" [model]=\"mainMenu\"></p-tieredMenu>\r\n        </div>\r\n      </section>\r\n      <div class=\"flex flex-column pb-2 flex-grow-1 justify-content-end\" [ngClass]=\"mainMenuExpanded?'align-items-end':'align-items-center'\">\r\n\r\n          <button (click)=\" onShowHideSideBarDetails()\" pButton pRipple type=\"button\" icon=\"{{mainMenuExpanded?'pi pi-angle-double-left':'pi pi-angle-double-right'}} text-2xl\" class=\"p-button-rounded p-button-text p-button-plain\"></button></div>\r\n      </div>\r\n\r\n\r\n\r\n  </aside>\r\n</div>\r\n\r\n\r\n<!--<div class=\"grid-nogutter max-w-max sidebar shadow-5\" >\r\n  <aside class=\"shadow-5\" >\r\n    <div  class=\"flex flex-column h-screen py-2\"\r\n          [@OnExpandSideBar]=\"mainMenuExpanded?'open':'closed'\">\r\n      <div class=\"pt-3\" *ngIf=\"!mainMenuExpanded\">\r\n        <p-tieredMenu  [styleClass]=\"'collapseSideBar'\"   [autoDisplay]=\"true\" [model]=\"mainMenuIcons\" ></p-tieredMenu>\r\n      </div>\r\n      <section  [@OnExpandSideBarText]=\"mainMenuExpanded?'show-content':'hide-content'\">\r\n        <div class=\"flex flex-column align-self-start pt-3\" *ngIf=\"mainMenuExpanded\">\r\n          <p-tieredMenu   [autoDisplay]=\"true\" [model]=\"mainMenu\"></p-tieredMenu>\r\n        </div>\r\n      </section>\r\n      <div class=\"flex flex-column h-screen justify-content-end\">\r\n        <div class=\"flex \" [ngClass]=\"mainMenuExpanded?'justify-content-end':'align-self-center'\" style=\"padding-bottom: 70px\">\r\n          <button (click)=\" onShowHideSideBarDetails()\" pButton pRipple type=\"button\" icon=\"{{mainMenuExpanded?'pi pi-angle-double-left':'pi pi-angle-double-right'}} text-2xl\" class=\"p-button-rounded p-button-text p-button-plain\"></button></div>\r\n      </div>\r\n    </div>\r\n\r\n\r\n  </aside>\r\n</div>-->\r\n\r\n\r\n\r\n\r\n\r\n", styles: [".sidebar{height:calc(100vh - 70px);z-index:100}.sidebar-no-header{height:100vh;z-index:100}:host ::ng-deep .p-tieredmenu .p-menuitem-link{padding:1.2rem 1.25rem}:host ::ng-deep .p-menuitem-link.p-menuitem-link-active{background:#d6e1ff}:host ::ng-deep .p-menuitem-link.p-menuitem-link-active .p-menuitem-text,:host ::ng-deep .p-menuitem-link.p-menuitem-link-active .p-menuitem-icon{color:#1d4ed8}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link .p-menuitem-text{color:#495057}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link .p-menuitem-icon,:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link .p-submenu-icon{color:#495057}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link-active .p-menuitem-text,:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link-active .p-menuitem-icon{color:#1d4ed8}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link.p-menuitem-link-active{background:#d6e1ff}:host ::ng-deep .p-tieredmenu{border:0;width:100%}:host ::ng-deep .collapseSideBar.p-tieredmenu{width:70px}:host ::ng-deep .p-tieredmenu .p-submenu-list{width:max-content;z-index:100}:host ::ng-deep .p-tieredmenu .p-menuitem-active>p-tieredmenusub>.p-submenu-list{left:102%}\n"], dependencies: [{ kind: "component", type: i6.TieredMenu, selector: "p-tieredMenu", inputs: ["model", "popup", "style", "styleClass", "appendTo", "autoZIndex", "baseZIndex", "autoDisplay", "showTransitionOptions", "hideTransitionOptions"], outputs: ["onShow", "onHide"] }, { kind: "directive", type: i7.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i7.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i8.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "directive", type: i9.Ripple, selector: "[pRipple]" }], animations: [
        trigger('OnExpandSideBar', [
            state('open', style({
                width: '100%',
            })),
            state('closed', style({
                width: '70px',
            })),
            transition('open => closed', [
                group([
                    query(':self', [animate('0s')]),
                    query('@OnExpandSideBarText', [animateChild()]),
                ]),
            ]),
            transition('closed => open', [
                group([
                    query(':self', [animate('0.2s')]),
                    query('@OnExpandSideBarText', [animateChild()]),
                ]),
            ]),
        ]),
        trigger('OnExpandSideBarText', [
            // ...
            state('show-content', style({
                opacity: '1',
            })),
            state('hide-content', style({
                opacity: '0',
                overflow: 'hidden',
            })),
            transition('show-content => hide-content', [animate('0s')]),
            transition('hide-content => show-content', [animate('0.2s 0.3s')]),
        ]),
    ] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgSidebarComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-sidebar', animations: [
                        trigger('OnExpandSideBar', [
                            state('open', style({
                                width: '100%',
                            })),
                            state('closed', style({
                                width: '70px',
                            })),
                            transition('open => closed', [
                                group([
                                    query(':self', [animate('0s')]),
                                    query('@OnExpandSideBarText', [animateChild()]),
                                ]),
                            ]),
                            transition('closed => open', [
                                group([
                                    query(':self', [animate('0.2s')]),
                                    query('@OnExpandSideBarText', [animateChild()]),
                                ]),
                            ]),
                        ]),
                        trigger('OnExpandSideBarText', [
                            // ...
                            state('show-content', style({
                                opacity: '1',
                            })),
                            state('hide-content', style({
                                opacity: '0',
                                overflow: 'hidden',
                            })),
                            transition('show-content => hide-content', [animate('0s')]),
                            transition('hide-content => show-content', [animate('0.2s 0.3s')]),
                        ]),
                    ], template: "<div class=\"grid-nogutter max-w-max shadow-5\" [ngClass]=\"headerDisplay?'sidebar':'sidebar-no-header'\" >\r\n  <aside class=\"shadow-5 \" >\r\n    <div  class=\"flex flex-column \"\r\n          [@OnExpandSideBar]=\"mainMenuExpanded?'open':'closed'\" [ngClass]=\"headerDisplay?'sidebar':'sidebar-no-header'\">\r\n      <div class=\"pt-2\" *ngIf=\"!mainMenuExpanded\">\r\n        <p-tieredMenu  [styleClass]=\"'collapseSideBar'\"   [autoDisplay]=\"true\" [model]=\"mainMenuIcons\" ></p-tieredMenu>\r\n      </div>\r\n      <section  [@OnExpandSideBarText]=\"mainMenuExpanded?'show-content':'hide-content'\">\r\n        <div class=\"pt-2\" *ngIf=\"mainMenuExpanded\">\r\n          <p-tieredMenu   [autoDisplay]=\"true\" [model]=\"mainMenu\"></p-tieredMenu>\r\n        </div>\r\n      </section>\r\n      <div class=\"flex flex-column pb-2 flex-grow-1 justify-content-end\" [ngClass]=\"mainMenuExpanded?'align-items-end':'align-items-center'\">\r\n\r\n          <button (click)=\" onShowHideSideBarDetails()\" pButton pRipple type=\"button\" icon=\"{{mainMenuExpanded?'pi pi-angle-double-left':'pi pi-angle-double-right'}} text-2xl\" class=\"p-button-rounded p-button-text p-button-plain\"></button></div>\r\n      </div>\r\n\r\n\r\n\r\n  </aside>\r\n</div>\r\n\r\n\r\n<!--<div class=\"grid-nogutter max-w-max sidebar shadow-5\" >\r\n  <aside class=\"shadow-5\" >\r\n    <div  class=\"flex flex-column h-screen py-2\"\r\n          [@OnExpandSideBar]=\"mainMenuExpanded?'open':'closed'\">\r\n      <div class=\"pt-3\" *ngIf=\"!mainMenuExpanded\">\r\n        <p-tieredMenu  [styleClass]=\"'collapseSideBar'\"   [autoDisplay]=\"true\" [model]=\"mainMenuIcons\" ></p-tieredMenu>\r\n      </div>\r\n      <section  [@OnExpandSideBarText]=\"mainMenuExpanded?'show-content':'hide-content'\">\r\n        <div class=\"flex flex-column align-self-start pt-3\" *ngIf=\"mainMenuExpanded\">\r\n          <p-tieredMenu   [autoDisplay]=\"true\" [model]=\"mainMenu\"></p-tieredMenu>\r\n        </div>\r\n      </section>\r\n      <div class=\"flex flex-column h-screen justify-content-end\">\r\n        <div class=\"flex \" [ngClass]=\"mainMenuExpanded?'justify-content-end':'align-self-center'\" style=\"padding-bottom: 70px\">\r\n          <button (click)=\" onShowHideSideBarDetails()\" pButton pRipple type=\"button\" icon=\"{{mainMenuExpanded?'pi pi-angle-double-left':'pi pi-angle-double-right'}} text-2xl\" class=\"p-button-rounded p-button-text p-button-plain\"></button></div>\r\n      </div>\r\n    </div>\r\n\r\n\r\n  </aside>\r\n</div>-->\r\n\r\n\r\n\r\n\r\n\r\n", styles: [".sidebar{height:calc(100vh - 70px);z-index:100}.sidebar-no-header{height:100vh;z-index:100}:host ::ng-deep .p-tieredmenu .p-menuitem-link{padding:1.2rem 1.25rem}:host ::ng-deep .p-menuitem-link.p-menuitem-link-active{background:#d6e1ff}:host ::ng-deep .p-menuitem-link.p-menuitem-link-active .p-menuitem-text,:host ::ng-deep .p-menuitem-link.p-menuitem-link-active .p-menuitem-icon{color:#1d4ed8}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link .p-menuitem-text{color:#495057}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link .p-menuitem-icon,:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link .p-submenu-icon{color:#495057}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link-active .p-menuitem-text,:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link-active .p-menuitem-icon{color:#1d4ed8}:host ::ng-deep .p-tieredmenu .p-menuitem.p-menuitem-active>.p-menuitem-link.p-menuitem-link-active{background:#d6e1ff}:host ::ng-deep .p-tieredmenu{border:0;width:100%}:host ::ng-deep .collapseSideBar.p-tieredmenu{width:70px}:host ::ng-deep .p-tieredmenu .p-submenu-list{width:max-content;z-index:100}:host ::ng-deep .p-tieredmenu .p-menuitem-active>p-tieredmenusub>.p-submenu-list{left:102%}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.MainLayoutService }, { type: i2.ArrayUtilityService }, { type: i3.TranslateService }, { type: i4.AbstractAuthService }, { type: i5.ObjectsUtilityService }]; }, propDecorators: { mainMenuOriginal: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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