/**
 * Constant that defines the menu items for main menu
 */
export const SIDEBAR_MENU = [
    {
        id: 'home',
        icon: 'pi pi-home',
        routerLink: [''],
        routerLinkActiveOptions: { exact: true },
    },
    {
        id: 'auth',
        icon: 'pi pi-user',
        items: [
            {
                icon: 'pi pi-sign-in',
                id: 'login',
                routerLinkString: "['/' + this.authConfig.authRoutingBasePath + '/' + this.authConfig.authRoutingLoginPath]",
                routerLinkActiveOptions: { exact: true },
                visibleString: '!this.user',
            },
            {
                icon: 'pi pi-book',
                id: 'signup',
                routerLinkString: "['/' + this.authConfig.authRoutingBasePath + '/' + this.authConfig.authRoutingSignupPath]",
                routerLinkActiveOptions: { exact: true },
                visibleString: '!this.user',
            },
            {
                icon: 'pi pi-key',
                id: 'request-pass',
                routerLinkString: "['/' + this.authConfig.authRoutingBasePath + '/' + this.authConfig.authRoutingRequestPasswordPath]",
                routerLinkActiveOptions: { exact: true },
            },
            {
                icon: 'pi pi-key',
                id: 'reset-pass',
                routerLinkString: "['/' + this.authConfig.authRoutingBasePath + '/' + this.authConfig.authRoutingResetPasswordPath]",
                routerLinkActiveOptions: { exact: true },
            },
        ],
    },
    {
        id: 'entity-types',
        icon: 'pi pi-database',
        routerLinkString: "['/' + this.entityTypesConfig.entityTypeBasePath]",
        routerLinkActiveOptions: { exact: true },
    },
    {
        id: 'lookup-table',
        icon: 'pi pi-map',
        routerLinkString: "['/' + this.lookupTableConfig.lookupTableBasePath]",
        routerLinkActiveOptions: { exact: true },
    },
    {
        id: 'queries',
        icon: 'pi pi-filter',
        routerLinkString: "['/' + this.queriesConfig.queriesRoutingPath]",
        routerLinkActiveOptions: { exact: true },
    },
    {
        id: 'roles-scopes',
        icon: 'pi pi-user-edit',
        routerLinkString: "['/' + this.rolesScopesConfig.rolesScopesBasePath]",
        routerLinkActiveOptions: { exact: true },
    },
    {
        id: 'terms',
        icon: 'pi pi-book',
        routerLinkString: "['/' + this.termsConfig.termsOfUseRoutingPath]",
        routerLinkActiveOptions: { exact: true },
    },
    {
        id: 'config-items',
        icon: 'pi pi-cog',
        items: [
            {
                icon: 'pi pi-user-edit',
                id: 'admin',
                routerLinkString: "['/' + this.configItemsConfig.configurationItemsRoutingBasePath + '/' + this.configItemsConfig.configurationItemsRoutingAdminPath]",
                routerLinkActiveOptions: { exact: true },
            },
            {
                icon: 'pi pi-user',
                id: 'user',
                routerLinkString: "['/' + this.configItemsConfig.configurationItemsRoutingBasePath + '/' + this.configItemsConfig.configurationItemsRoutingUserPath]",
                routerLinkActiveOptions: { exact: true },
            },
        ],
    },
    {
        id: 'dashboard',
        icon: 'pi pi-chart-bar',
        items: [
            {
                icon: 'pi pi-plus-circle',
                id: 'create',
                routerLinkString: "['/' + this.dashboardConfig.dashboardRoutingBasePath + '/' + this.dashboardConfig.dashboardCreateRoutingPath]",
                routerLinkActiveOptions: { exact: true },
            },
            {
                icon: 'pi pi-list',
                id: 'list',
                routerLinkString: "['/' + this.dashboardConfig.dashboardRoutingBasePath + '/' + this.dashboardConfig.dashboardListRoutingPath]",
                routerLinkActiveOptions: { exact: true },
            },
            {
                icon: 'pi pi-eye',
                id: 'display',
                routerLinkString: "['/' + this.dashboardConfig.dashboardRoutingBasePath + '/' + this.dashboardConfig.dashboardDisplayRoutingPath]",
                routerLinkActiveOptions: { exact: true },
            },
        ],
    },
];
//# sourceMappingURL=data:application/json;base64,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