/**
 * Constant that defines the menu items for user menu
 */
export const USER_MENU_HEADER = [
    {
        id: 'user-menu',
        items: [
            { separator: true },
            {
                icon: 'pi pi-user',
                id: 'my-account',
                visibleString: '!!this.user',
            },
            {
                icon: 'pi pi-sign-out',
                commandString: 'this.onClickLogout',
                id: 'logout',
                visibleString: '!!this.user',
            },
            {
                icon: 'pi pi-sign-in',
                visibleString: '!this.user',
                id: 'login',
                routerLinkString: "['/' + this.authConfig.authRoutingBasePath + '/' + this.authConfig.authRoutingLoginPath,]",
            },
        ],
    },
];
/**
 * Constant that defines the menu items for language menu on header
 */
export const LANGUAGE_MENU_HEADER = [
    {
        id: 'language-menu',
        items: [
            { separator: true },
            {
                id: 'pt',
                commandString: '($event) => this.changeLanguage($event.item.id)',
            },
            {
                id: 'en',
                commandString: '($event) => this.changeLanguage($event.item.id)',
            },
        ],
    },
];
//# sourceMappingURL=data:application/json;base64,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