import { Component, Input } from '@angular/core';
import { LANGUAGE_MENU_HEADER, USER_MENU_HEADER, } from '../menus-structure/menus-header-structure';
import * as i0 from "@angular/core";
import * as i1 from "../../../auth/services/auth/abstract-auth.service";
import * as i2 from "../../../core/services/utility/objects-utility.service";
import * as i3 from "../../../core/services/utility/array-utility.service";
import * as i4 from "@ngx-translate/core";
import * as i5 from "../../services/main-layout.service";
import * as i6 from "primeng/menu";
import * as i7 from "primeng/tooltip";
import * as i8 from "primeng/chip";
import * as i9 from "@angular/common";
import * as i10 from "primeng/button";
import * as i11 from "primeng/ripple";
//TODO: It's missing a way to save user and language preferences (Session / Locale Storage)
/**
 * Header Component
 */
export class PrgHeaderComponent {
    /**
     * Constructor
     * @param {AbstractAuthService} authService
     * @param {ObjectsUtilityService} objectUtilityService
     * @param {ArrayUtilityService} arrayUtilityService
     * @param {TranslateService} translateService
     * @param {MainLayoutService} mainLayoutService
     */
    constructor(authService, objectUtilityService, arrayUtilityService, translateService, mainLayoutService) {
        this.authService = authService;
        this.objectUtilityService = objectUtilityService;
        this.arrayUtilityService = arrayUtilityService;
        this.translateService = translateService;
        this.mainLayoutService = mainLayoutService;
        /**
         * Property of the class with type string which bind to menu logo.
         */
        this.imagePathLogo = '/assets/images/pragma_h.png';
        /**
         * Property of the class with type string which bind to user default image
         */
        this.imagePathUserDefault = '/assets/images/Profile_image.jpg';
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         * @type {Subscription[]}
         * @private
         */
        this.subscription = [];
        /**
         * A class property that defines if header is display
         * @type {boolean}
         */
        this.displayHeader = true;
        /**
         * Menu Items data of user menu
         * @type {PrgMenuItem[]}
         */
        this.menuItemsUser = this.arrayUtilityService.clone(USER_MENU_HEADER);
        /**
         * Menu Items data of language menu
         * @type {PrgMenuItem[]}
         */
        this.menuItemsLanguage = this.arrayUtilityService.clone(LANGUAGE_MENU_HEADER);
        /**
         * This method is responsible for calling the function that will log out user
         * @returns {Promise<void>}
         */
        this.onClickLogout = async () => {
            if (await this.authService.logoutAsync()) {
                //TODO Redirect after logout success. Route?
            }
        };
    }
    /**
     * ngOnInit
     *
     * @returns {Promise<void>}
     */
    async ngOnInit() {
        this.subscription.push(this.authService.getLoggedUserObservable().subscribe((user) => {
            this.user = this.objectUtilityService.cloneObject(user);
            if (this.user && this.user.token !== null) {
                this.imagePathUser = this.user.token.imageUrl;
            }
            else {
                this.imagePathUser = null;
            }
            this.initMenuUser();
        }));
        this.subscription.push(this.mainLayoutService
            .getDisplayHeaderStateObservable()
            .subscribe((display) => {
            this.displayHeader = display;
        }));
        await this.initMenuLanguage();
    }
    /**
     * Function responsible to reload menu data when user change language
     * @param {string} lang
     * @returns {Promise<void>}
     */
    async changeLanguage(lang) {
        this.translateService.use(lang);
        await this.initMenuLanguage();
        await this.initMenuUser();
    }
    /**
     * ngOnDestroy
     *
     * Unsubscribe the user logged observable
     */
    ngOnDestroy() {
        this.subscription.forEach((subscription) => {
            subscription.unsubscribe();
        });
        this.subscription = [];
    }
    /**
     * This method is responsible for calling the functions that will build the language menu
     * @returns {Promise<void>}
     */
    async initMenuLanguage() {
        this.menuItemsLanguage = this.arrayUtilityService.clone(this.mainLayoutService.mapMenuItemsHelpers(this.menuItemsLanguage, this));
        this.menuItemsLanguage = this.arrayUtilityService.clone(await this.mainLayoutService.getHeaderMenuItemsWithLabelsAsync(this.menuItemsLanguage));
    }
    /**
     * This method is responsible for calling the functions that will build the user menu
     * @returns {Promise<void>}
     */
    async initMenuUser() {
        this.menuItemsUser = this.arrayUtilityService.clone(this.mainLayoutService.mapMenuItemsHelpers(this.menuItemsUser, this));
        this.menuItemsUser = this.arrayUtilityService.clone(await this.mainLayoutService.getHeaderMenuItemsWithLabelsAsync(this.menuItemsUser));
    }
}
PrgHeaderComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgHeaderComponent, deps: [{ token: i1.AbstractAuthService }, { token: i2.ObjectsUtilityService }, { token: i3.ArrayUtilityService }, { token: i4.TranslateService }, { token: i5.MainLayoutService }], target: i0.ɵɵFactoryTarget.Component });
PrgHeaderComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgHeaderComponent, selector: "prg-header", inputs: { imagePathLogo: "imagePathLogo", imagePathUserDefault: "imagePathUserDefault", menuItemsUser: "menuItemsUser", menuItemsLanguage: "menuItemsLanguage" }, ngImport: i0, template: "<header class=\"shadow-5 \"  >\r\n  <div class=\"grid grid-nogutter p-1\" style=\"height: 70px\" *ngIf=\"displayHeader\">\r\n    <div class=\"col-2 flex justify-content-center \">\r\n      <img [src]=\"imagePathLogo\"  style=\"width: 80%;height: 90%\">\r\n    </div>\r\n    <div class=\"col flex align-items-center justify-content-end pr-6\">\r\n      <p-chip pTooltip=\"{{'components.header.user-menu.label'|translate}}\" tooltipPosition=\"top\" class=\"cursor-pointer px-3\" (click)=\"menuUser.toggle($event)\"\r\n              label=\"{{user?user.name:('components.header.user-menu.anonymous-user'|translate)}}\" image=\"{{imagePathUser?imagePathUser:imagePathUserDefault}}\"\r\n              styleClass=\"mr-2\"></p-chip>\r\n      <p-menu [showTransitionOptions]=\"'0.3s'\" [hideTransitionOptions]=\"'0.3s'\" #menuUser [popup]=\"true\"\r\n              [model]=\"menuItemsUser\"></p-menu>\r\n      <button pTooltip=\"{{'components.header.language-menu.label'|translate}}\" tooltipPosition=\"top\" (click)=\"menuLanguage.toggle($event)\"\r\n              pButton pRipple type=\"button\" icon=\"bi bi-globe text-2xl\"\r\n              class=\"px-3 p-button-rounded p-button-text p-button-plain \"></button>\r\n      <p-menu [showTransitionOptions]=\"'0.3s'\" [hideTransitionOptions]=\"'0.3s'\" #menuLanguage [popup]=\"true\"\r\n              [model]=\"menuItemsLanguage\"></p-menu>\r\n    </div>\r\n  </div>\r\n</header>\r\n", styles: [":host ::ng-deep .p-menu{width:max-content}\n"], dependencies: [{ kind: "component", type: i6.Menu, selector: "p-menu", inputs: ["model", "popup", "style", "styleClass", "appendTo", "autoZIndex", "baseZIndex", "showTransitionOptions", "hideTransitionOptions"], outputs: ["onShow", "onHide"] }, { kind: "directive", type: i7.Tooltip, selector: "[pTooltip]", inputs: ["tooltipPosition", "tooltipEvent", "appendTo", "positionStyle", "tooltipStyleClass", "tooltipZIndex", "escape", "showDelay", "hideDelay", "life", "positionTop", "positionLeft", "fitContent", "pTooltip", "tooltipDisabled", "tooltipOptions"] }, { kind: "component", type: i8.Chip, selector: "p-chip", inputs: ["label", "icon", "image", "style", "styleClass", "removable", "removeIcon"], outputs: ["onRemove", "onImageError"] }, { kind: "directive", type: i9.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i10.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "directive", type: i11.Ripple, selector: "[pRipple]" }, { kind: "pipe", type: i4.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgHeaderComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-header', template: "<header class=\"shadow-5 \"  >\r\n  <div class=\"grid grid-nogutter p-1\" style=\"height: 70px\" *ngIf=\"displayHeader\">\r\n    <div class=\"col-2 flex justify-content-center \">\r\n      <img [src]=\"imagePathLogo\"  style=\"width: 80%;height: 90%\">\r\n    </div>\r\n    <div class=\"col flex align-items-center justify-content-end pr-6\">\r\n      <p-chip pTooltip=\"{{'components.header.user-menu.label'|translate}}\" tooltipPosition=\"top\" class=\"cursor-pointer px-3\" (click)=\"menuUser.toggle($event)\"\r\n              label=\"{{user?user.name:('components.header.user-menu.anonymous-user'|translate)}}\" image=\"{{imagePathUser?imagePathUser:imagePathUserDefault}}\"\r\n              styleClass=\"mr-2\"></p-chip>\r\n      <p-menu [showTransitionOptions]=\"'0.3s'\" [hideTransitionOptions]=\"'0.3s'\" #menuUser [popup]=\"true\"\r\n              [model]=\"menuItemsUser\"></p-menu>\r\n      <button pTooltip=\"{{'components.header.language-menu.label'|translate}}\" tooltipPosition=\"top\" (click)=\"menuLanguage.toggle($event)\"\r\n              pButton pRipple type=\"button\" icon=\"bi bi-globe text-2xl\"\r\n              class=\"px-3 p-button-rounded p-button-text p-button-plain \"></button>\r\n      <p-menu [showTransitionOptions]=\"'0.3s'\" [hideTransitionOptions]=\"'0.3s'\" #menuLanguage [popup]=\"true\"\r\n              [model]=\"menuItemsLanguage\"></p-menu>\r\n    </div>\r\n  </div>\r\n</header>\r\n", styles: [":host ::ng-deep .p-menu{width:max-content}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.AbstractAuthService }, { type: i2.ObjectsUtilityService }, { type: i3.ArrayUtilityService }, { type: i4.TranslateService }, { type: i5.MainLayoutService }]; }, propDecorators: { imagePathLogo: [{
                type: Input
            }], imagePathUserDefault: [{
                type: Input
            }], menuItemsUser: [{
                type: Input
            }], menuItemsLanguage: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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