import { Inject, Injectable } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { NotificationsService } from '../../../core/services/notifications/notifications.service';
import { AbstractEntityTypeService } from './abstract-entity-type.service';
import * as i0 from "@angular/core";
import * as i1 from "../../../core/services/notifications/notifications.service";
import * as i2 from "@ngx-translate/core";
/**
 * Injectable
 */
export class EntityTypeService extends AbstractEntityTypeService {
    /**
     * constructor
     * @param notificationsService notificationsService
     * @param translateService translateService
     */
    constructor(notificationsService, translateService) {
        super(notificationsService, translateService);
    }
    /**
     * Get all Entity Types
     *
     * @Returns Entity types[]
     */
    getEntityTypeListAsync() {
        throw new Error('Method not implemented.');
    }
    /**
     * Get entity type list with operation
     *
     *  * @Returns Entity types[]
     */
    getEntityTypeListWithOperationAsync() {
        throw new Error('Method not implemented.');
    }
    /**
     * save entity type
     * @param entityType
     * @return Entity type
     */
    saveEntityTypeAsync(entityType) {
        throw new Error('Method not implemented.');
    }
    /**
     * get all operations of an entity
     * @param entityTypeId
     * @return EntityTypeOperation[]
     */
    getAllOperationsByEntityTypeIdAsync(entityTypeId) {
        throw new Error('Method not implemented.');
    }
    /**
     * add or update entity type operation
     * @param entityTypeOperation
     * @return EntityTypeOperation
     */
    saveEntityTypeOperationAsync(entityTypeOperation) {
        throw new Error('Method not implemented.');
    }
    /**
     * get all attributes of an entity
     * @param entityTypeId
     * @return EntityTypeAttribute[]
     */
    getAllAttributesByEntityTypeIdAsync(entityTypeId) {
        throw new Error('Method not implemented.');
    }
    /**
     * add or update entity type attribute
     * @param entityTypeAttribute
     * @return EntityTypeAttribute
     */
    saveEntityTypeAttributeAsync(entityTypeAttribute) {
        throw new Error('Method not implemented.');
    }
    /**
     * get all properties of an entity
     * @param entityTypeId
     * @return EntityTypeProperty[]
     */
    getAllPropertiesByEntityTypeIdAsync(entityTypeId) {
        throw new Error('Method not implemented.');
    }
    /**
     * add or update entity type property
     * @param EntityTypeProperty
     * @return EntityTypeProperty
     */
    saveEntityTypePropertyAsync(entityTypeProperty) {
        throw new Error('Method not implemented.');
    }
    /**
     * update entity type properties using patch logic
     * @param entityTypesPropertiesToPatch
     * @return EntityTypeProperty[]
     */
    updateEntityTypePropertiesAsync(entityTypesPropertiesToPatch) {
        throw new Error('Method not implemented.');
    }
    /**
     * update entity type attributes using patch logic
     * @param entityTypesAttributesToPatch
     * @return EntityTypeAttribute[]
     */
    updateEntityTypeAttributesAsync(entityTypesAttributesToPatch) {
        throw new Error('Method not implemented.');
    }
    /**
     * this service returns all the data (properties, attributes and operations)
     * of a given entity type (by entity name)
     * @param entityTypeName
     */
    getAllEntityTypeDataByName(entityTypeName) {
        throw new Error('Method not implemented.');
    }
    /**
     * this service returns an array of elements
     * of the entity sent as a parameter,
     *  based on the filter it receives as a parameter.
     * @param entityTypeName
     * @param FilterGroup
     */
    getEntityTypeElements(entityTypeName, FilterGroup) {
        throw new Error('Method not implemented.');
    }
    /*
     * Get all properties and attributes by entity type id
     * @param {string} entityTypeId
     * @returns {Promise<EntityTypeProperty[]>}
     */
    getAllPropertiesAndAttributesByEntityTypeIdAsync(entityTypeId) {
        throw new Error('Method not implemented.');
    }
    /**
     * This service return a element from a entity type list by id
     * @param entityTypeName
     * @param elementId
     */
    getEntityTypeElementById(entityTypeName, elementId) {
        throw new Error('Method not implemented.');
    }
    /**
     * this service excute in database the operation received as parameter
     * @param entityName
     * @param operation
     * @param entity
     */
    executeAction(entityName, operation, entity) {
        throw new Error('Method not implemented.');
    }
}
EntityTypeService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: EntityTypeService, deps: [{ token: NotificationsService }, { token: TranslateService }], target: i0.ɵɵFactoryTarget.Injectable });
EntityTypeService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: EntityTypeService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: EntityTypeService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: i1.NotificationsService, decorators: [{
                    type: Inject,
                    args: [NotificationsService]
                }] }, { type: i2.TranslateService, decorators: [{
                    type: Inject,
                    args: [TranslateService]
                }] }]; } });
//# sourceMappingURL=data:application/json;base64,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