import { Injectable } from '@angular/core';
import { BaseCacheService } from '../../../core/services/cache-service/base-cache.service';
import * as i0 from "@angular/core";
import * as i1 from "../../../core/services/notifications/notifications.service";
import * as i2 from "@ngx-translate/core";
/**
 * Injectable
 */
export class AbstractEntityTypeService extends BaseCacheService {
    /**
     * constructor
     * @param notificationsService notificationsService
     * @param translationService
     */
    constructor(notificationsService, translationService) {
        super();
        this.notificationsService = notificationsService;
        this.translationService = translationService;
        this.cacheTimeMs = 5000;
    }
    /* this service get translations for all entity types,properties and attributes
     * @param {EntityType[] | EntityType} entities
     * @returns {Promise<EntityType[] | EntityType>}
     * @protected
     */
    async getTranslationsAsync(entities) {
        return new Promise((resolve, reject) => {
            if (Array.isArray(entities)) {
                //Translate Entities
                let entitiesType = entities;
                entitiesType.map(async (entityType) => {
                    entityType.label = await this.translationService
                        .get('entities.' + entityType.name.toLowerCase() + '.label')
                        .toPromise();
                    if (entityType.operations) {
                        entityType.operations.map(async (operation) => {
                            operation.label = await this.translationService
                                .get('entities.' +
                                entityType.name.toLowerCase() +
                                '.operations.' +
                                operation.name.toLowerCase() +
                                '.label')
                                .toPromise();
                        });
                    }
                });
                resolve(entitiesType);
            }
            else {
                //Translate properties and attributes of the entity
                let entity = entities;
                if (entity.properties) {
                    entity.properties.map(async (property) => {
                        property.label = await this.translationService
                            .get('entities.' +
                            entity.name.toLowerCase() +
                            '.fields.' +
                            property.name.toLowerCase() +
                            '.label')
                            .toPromise();
                    });
                }
                if (entity.attributes) {
                    entity.attributes.map(async (attribute) => {
                        attribute.label = await this.translationService
                            .get('entities.' +
                            entity.name.toLowerCase() +
                            '.fields.' +
                            attribute.name.toLowerCase() +
                            '.label')
                            .toPromise();
                    });
                }
                if (entity.operations) {
                    entity.operations.map(async (operation) => {
                        operation.label = await this.translationService
                            .get('entities.' +
                            entity.name.toLowerCase() +
                            '.operations.' +
                            operation.name.toLowerCase() +
                            '.label')
                            .toPromise();
                    });
                }
                resolve(entity);
            }
        });
    }
}
AbstractEntityTypeService.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AbstractEntityTypeService, deps: [{ token: i1.NotificationsService }, { token: i2.TranslateService }], target: i0.ɵɵFactoryTarget.Injectable });
AbstractEntityTypeService.ɵprov = i0.ɵɵngDeclareInjectable({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AbstractEntityTypeService, providedIn: 'root' });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: AbstractEntityTypeService, decorators: [{
            type: Injectable,
            args: [{
                    providedIn: 'root',
                }]
        }], ctorParameters: function () { return [{ type: i1.NotificationsService }, { type: i2.TranslateService }]; } });
//# sourceMappingURL=data:application/json;base64,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