import { NgModule } from '@angular/core';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';
import { PrgCoreDynamicFormModule } from '../core/components/dynamic-form/prg-core-dynamic-form.module';
import { PrgSharedComponentsModule } from '../shared-components/shared-components.module';
import { PrgEntityTypeElementComponent } from './components/entity-type-element/prg-entity-type-element.component';
import { PrgEntityTypeConfigsComponent } from './components/entity-type/components/entity-type-configs/prg-entity-type-configs.component';
import { PrgEntityTypeComponent } from './components/entity-type/prg-entity-type.component';
import { PrgListEntityTypesComponent } from './components/list-entity-types/prg-list-entity-types.component';
import { PrgListSpecificEntityTypeComponent } from './components/list-specific-entity-type/prg-list-specific-entity-type.component';
import { MockEntityTypesService } from './mock/services/entity-types/entity-types.service.mock';
import { PrgEntityTypeElementPage } from './pages/entity-type-element/prg-entity-type-element.page';
import { PrgEntityTypesPage } from './pages/entity-types/prg-entity-types.page';
import { PrgSpecificEntityTypePage } from './pages/specific-entity-type/specific-entity-type.page';
import { PrgEntityTypesRoutingModule } from './prg-entity-types-routing.module';
import { PRG_ENTITY_TYPES_CONFIG } from './services/entity-types-configuration/prg-entity-types-configuration.service';
import { AbstractEntityTypeService } from './services/entity-types/abstract-entity-type.service';
import { EntityTypeService } from './services/entity-types/entity-type.service';
import * as i0 from "@angular/core";
export class PrgEntityTypesModule {
    constructor(injector) {
        this.injector = injector;
        appInjector = this.injector;
    }
    static forRoot(prgEntityTypesConfig) {
        entityTypesConfig = prgEntityTypesConfig;
        return {
            ngModule: PrgEntityTypesModule,
            providers: [
                {
                    provide: PRG_ENTITY_TYPES_CONFIG,
                    useValue: prgEntityTypesConfig,
                },
                {
                    provide: AbstractEntityTypeService,
                    useClass: prgEntityTypesConfig.useMockServices
                        ? MockEntityTypesService
                        : EntityTypeService,
                },
            ],
        };
    }
}
PrgEntityTypesModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgEntityTypesModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesModule, declarations: [PrgEntityTypesPage,
        PrgListEntityTypesComponent,
        PrgEntityTypeComponent,
        PrgEntityTypeConfigsComponent,
        PrgListSpecificEntityTypeComponent,
        PrgSpecificEntityTypePage,
        PrgEntityTypeElementComponent,
        PrgEntityTypeElementPage], imports: [PrgSharedComponentsModule,
        PrgEntityTypesRoutingModule,
        PrgCoreDynamicFormModule], exports: [PrgListEntityTypesComponent,
        PrgListSpecificEntityTypeComponent,
        PrgEntityTypeElementComponent] });
PrgEntityTypesModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesModule, providers: [DynamicDialogConfig, DynamicDialogRef], imports: [PrgSharedComponentsModule,
        PrgEntityTypesRoutingModule,
        PrgCoreDynamicFormModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypesModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        PrgEntityTypesPage,
                        PrgListEntityTypesComponent,
                        PrgEntityTypeComponent,
                        PrgEntityTypeConfigsComponent,
                        PrgListSpecificEntityTypeComponent,
                        PrgSpecificEntityTypePage,
                        PrgEntityTypeElementComponent,
                        PrgEntityTypeElementPage,
                    ],
                    imports: [
                        PrgSharedComponentsModule,
                        PrgEntityTypesRoutingModule,
                        PrgCoreDynamicFormModule,
                    ],
                    exports: [
                        PrgListEntityTypesComponent,
                        PrgListSpecificEntityTypeComponent,
                        PrgEntityTypeElementComponent,
                    ],
                    entryComponents: [PrgEntityTypeComponent, PrgEntityTypeElementComponent],
                    providers: [DynamicDialogConfig, DynamicDialogRef],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
export let appInjector;
/**
 * Exports the EntityTypesConfig object
 */
export let entityTypesConfig;
//# sourceMappingURL=data:application/json;base64,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