import { Component } from '@angular/core';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import * as i0 from "@angular/core";
import * as i1 from "@angular/router";
import * as i2 from "../../services/entity-types/abstract-entity-type.service";
import * as i3 from "../../../core/services/utility/objects-utility.service";
import * as i4 from "../../components/entity-type-element/prg-entity-type-element.component";
/**
 * PrgEntityTypeElementPage
 */
export class PrgEntityTypeElementPage {
    /**
     * constructor
     * @param route
     * @param router
     * @param entityTypeService
     * @param objectsUtilityService
     */
    constructor(route, router, entityTypeService, objectsUtilityService) {
        this.route = route;
        this.router = router;
        this.entityTypeService = entityTypeService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * viewMode
         */
        this.viewMode = ViewMode.Read;
    }
    /**
     * ngOnInit
     */
    async ngOnInit() {
        // get params from url
        this.route.paramMap.subscribe((params) => {
            this.entityTypeName = params.get('entityTypeName');
            this.entityTypeElementID = params.get('id');
        });
        this.getEntityTypeData(this.entityTypeName);
        if (this.entityTypeElementID == 'new') {
            this.element = {};
            this.viewMode = ViewMode.Edit;
        }
        else {
            const elementAux = await this.getEntityTypeElementData(this.entityTypeName, this.entityTypeElementID);
            // check if element exist
            if (elementAux) {
                this.element = this.objectsUtilityService.cloneObject(elementAux);
            }
            else {
                this.router.navigate(['../'], { relativeTo: this.route });
            }
        }
    }
    /**
     * this function fetches the data from the entityType based on the entity type name
     * @param entityTypeName
     */
    async getEntityTypeData(entityTypeName) {
        this.entityType = await this.entityTypeService.getAllEntityTypeDataByName(entityTypeName);
    }
    /**
     * this function fetches the data from the entityType
     * element based on the entity type name and element id
     * @param entitiesTypeName
     * @param elementId
     * @returns
     */
    async getEntityTypeElementData(entitiesTypeName, elementId) {
        return await this.entityTypeService.getEntityTypeElementById(entitiesTypeName, elementId);
    }
}
PrgEntityTypeElementPage.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypeElementPage, deps: [{ token: i1.ActivatedRoute }, { token: i1.Router }, { token: i2.AbstractEntityTypeService }, { token: i3.ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgEntityTypeElementPage.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgEntityTypeElementPage, selector: "prg-entity-type-element-page", ngImport: i0, template: "<div>\r\n  <prg-entity-type-element\r\n    [entityType]=\"entityType\"\r\n    [element]=\"element\"\r\n    [elementViewMode]=\"viewMode\"\r\n  ></prg-entity-type-element>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "component", type: i4.PrgEntityTypeElementComponent, selector: "prg-entity-type-element", inputs: ["element", "entityType", "elementViewMode"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypeElementPage, decorators: [{
            type: Component,
            args: [{ selector: 'prg-entity-type-element-page', template: "<div>\r\n  <prg-entity-type-element\r\n    [entityType]=\"entityType\"\r\n    [element]=\"element\"\r\n    [elementViewMode]=\"viewMode\"\r\n  ></prg-entity-type-element>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.ActivatedRoute }, { type: i1.Router }, { type: i2.AbstractEntityTypeService }, { type: i3.ObjectsUtilityService }]; } });
//# sourceMappingURL=data:application/json;base64,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