import { BaseEntity } from '../../core/models/base-entity.model';
/**
 * HttpVerb string enum
 */
export var HttpVerb;
(function (HttpVerb) {
    HttpVerb["Get"] = "GET";
    HttpVerb["Post"] = "POST";
    HttpVerb["Put"] = "PUT";
    HttpVerb["Patch"] = "PATCH";
    HttpVerb["Delete"] = "DELETE";
})(HttpVerb || (HttpVerb = {}));
/**
 * EntityTypeProperty class that defines a dynamic
 * <br />property of an EntityType, which WILL BE
 * <br />COMPILED into the dll
 */
export class EntityTypeProperty extends BaseEntity {
    /**
     * constructor
     * @param init
     */
    constructor(init) {
        super();
        /**
         * this field is to indicate if
         * we are going to have an array of some type
         */
        this.isArray = false;
        Object.assign(this, init);
    }
}
/**
 * EntityTypeAttribute class that defines an
 * <br />attribute of an EntityType, which WILL NOT
 * <br />BE COMPILED into the dll
 */
export class EntityTypeAttribute extends BaseEntity {
    /**constructor */
    constructor(init) {
        super();
        /**
         * this field is to indicate if
         * we are going to have an array of some type
         */
        this.isArray = false;
        Object.assign(this, init);
    }
}
/**
 * EntityTypeOperation class that defines a
 * <br />custom operation for an EntityType,
 * <br />which WILL BE COMPILED into the dll
 */
export class EntityTypeOperation extends BaseEntity {
    /**constructor */
    constructor(init) {
        super();
        /**
         * Operation order
         */
        this.order = 0;
        Object.assign(this, init);
    }
}
/**
 * EntityTypeOperation class that defines a
 * <br />generic EntityType, its properties,
 * <br />attributes and operations
 */
export class EntityType extends BaseEntity {
    /**
     * Constructor
     * this constructor receives the fields sent by the app,
     * and creates an object with the fields sent and the values per default
     * @param init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
//# sourceMappingURL=data:application/json;base64,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