import { DateTimeConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/input-date-time/date-time.model';
import { InputNumberConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/input-number/input-number.model';
import { InputTextConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/input-text/input-text.model';
import { ControlName } from '../../core/components/dynamic-form/models/constants/control-names';
import { ReferenceType } from '../../core/components/dynamic-form/models/constants/reference-type';
import { ToolbarSlot } from '../../core/components/dynamic-form/models/constants/toolbar-slots';
import { ExecutedActionBehaviour } from '../../core/models/executed-action-behaviourts';
import { ComponentType, ComponentTypeEnum, Dashboard, DashboardItem, } from '../../dashboard/models/dashboard.model';
import { HttpVerb, } from '../models/entity-type.model';
/**
 * Mock Database
 */
export const MockDatabase = {
    EntityTypes: [
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'Customer',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'qwertty',
            group: 'System',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '2',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'User',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: '12346',
            group: 'System',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '3',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'Refunds',
            createdBy: null,
            label: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'new ModelQualquer({list : {pagination:false, columns: string[]} ,form:{} })',
            group: 'Store',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '4',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'Orders',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'nccnnc',
            group: 'Store',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '5',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'product',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'new ModelQualquer({list : {pagination:false, columns: BaseFields[]} ,form:{} })',
            group: 'Store',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '6',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'dashboard',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'new ModelQualquer({list : {pagination:false, columns: BaseFields[]} ,form:{} })',
            group: 'System',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '7',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'dashboarditem',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'new ModelQualquer({list : {pagination:false, columns: BaseFields[]} ,form:{} })',
            group: 'System',
            properties: null,
            attributes: null,
            operations: null,
        },
        {
            id: '8',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'componentType',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            stateId: '1',
            workspaceId: '1',
            guiSettings: 'new ModelQualquer({list : {pagination:false, columns: BaseFields[]} ,form:{} })',
            group: 'System',
            properties: null,
            attributes: null,
            operations: null,
        },
    ],
    EntityTypeProperty: [
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'property1',
            createdBy: null,
            label: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            //referenceName
            reference: 'dataType',
        },
        {
            id: '2',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'property2',
            createdBy: null,
            label: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'number',
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 3,
            reference: 'sis',
        },
        {
            id: '3',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'property3',
            createdBy: null,
            label: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: "String(new InputTextConfiguration({disabled:true, visibleExpression:'sisisi'}))",
            dataTypeId: 'dataType.lookupTable',
            isArray: false,
            order: 3,
            reference: 'sis',
        },
        {
            id: '4',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label: null,
            name: 'property4',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 4,
            reference: 'sis',
        },
        {
            id: '5',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'customername',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'customername',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'customer name',
        },
        {
            id: '6',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'customerId',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'customerId',
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 1,
            reference: 'customerId',
        },
        {
            id: '7',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'dateofbirth',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'dateofbirth',
            dataTypeId: 'dataType.date',
            isArray: false,
            order: 1,
            reference: 'dateofbirth',
        },
        {
            id: '8',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'name',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'name',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'name',
        },
        {
            id: '9',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'userId',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'userId',
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 1,
            reference: 'userId',
        },
        {
            id: '10',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label: null,
            name: 'RegisterDate',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'RegisterDate',
            dataTypeId: 'dataType.date',
            isArray: false,
            order: 1,
            reference: 'RegisterDate',
        },
        {
            id: '99999991',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'id',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: null,
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: null,
        },
        {
            id: '99999992',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'name',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify(new InputTextConfiguration({
                readonly: false,
                key: 'name',
                validators: ['Validators.required'],
                basePathTranslation: 'entities.product.fields',
            })),
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 2,
            reference: null,
        },
        {
            id: '99999993',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'description',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify(new InputTextConfiguration({
                readonly: false,
                key: 'description',
                validators: ['Validators.maxLength(20)'],
                basePathTranslation: 'entities.product.fields',
            })),
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 2,
            reference: null,
        },
        {
            id: '99999994',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'expiryDate',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify(new DateTimeConfiguration({
                key: 'expiryDate',
                validators: ['Validators.required'],
            })),
            dataTypeId: 'dataType.date',
            isArray: true,
            order: 3,
            reference: null,
        },
        {
            id: '99999995',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'value',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify(new InputNumberConfiguration({
                readonly: false,
                key: 'value',
                validators: ['Validators.required'],
            })),
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 4,
            reference: null,
        },
        {
            id: '99999996',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'stock',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify({
                controlName: ControlName.dropdown,
                referenceType: ReferenceType.LookupTable,
                referenceName: 'stockStatus',
                readonly: false,
                key: 'stock',
                optionLabel: 'label',
                optionValue: 'id',
                validators: ['Validators.required'],
            }),
            dataTypeId: 'dataType.lookupTable',
            isArray: false,
            order: 4,
            reference: 'stockStatus',
        },
        {
            id: '9999996',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'stock',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify({
                controlName: ControlName.dropdown,
                referenceType: ReferenceType.LookupTable,
                referenceName: 'stockStatus',
                readonly: false,
                key: 'stock',
                optionLabel: 'label',
                optionValue: 'id',
                validators: ['Validators.required'],
            }),
            dataTypeId: 'dataType.lookupTable',
            isArray: false,
            order: 4,
            reference: 'stockStatus',
        },
        {
            id: '70000',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'name',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '6',
            guiSettings: JSON.stringify(new InputTextConfiguration({
                readonly: false,
                key: 'name',
                validators: ['Validators.required'],
                basePathTranslation: 'entities.product.fields', //mudar
            })),
            dataTypeId: 'dataType.text',
            isArray: false,
            order: 1,
            reference: null, //referencia lookup
        },
        {
            id: '700001',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'id',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '6',
            guiSettings: null,
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: null,
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.entityType',
            entityTypeId: '6',
            guiSettings: 'asa',
            id: '225f5414-e317-4fd8-a6ed-d5cdd23e1e9c',
            isArray: true,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'items',
            operationId: null,
            order: 1,
            reference: 'DashboardItem',
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '6',
            guiSettings: 'sda',
            id: 'b8f206a8-44f6-41d0-853f-d3204fba1fa0',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'path',
            operationId: null,
            order: 1,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.default',
            entityTypeId: '6',
            guiSettings: 'ddd',
            id: '1a244e5d-6968-4c2e-b115-49b2d985d223',
            isArray: false,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'isPublic',
            operationId: null,
            order: 1,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '6',
            guiSettings: 'dddd',
            id: '805b41f8-a758-4b7e-8482-8c369aac37df',
            isArray: false,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'settings',
            operationId: null,
            order: 1,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '6',
            guiSettings: 'fd',
            id: 'd13ed5eb-ac5e-48dc-9e23-cda2637a41f6',
            isArray: true,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'entityTypeIds',
            operationId: null,
            order: 1,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '6',
            guiSettings: 'sdasd',
            id: 'b1631498-aad2-4871-8ba2-ffdfeeb0d235',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'createdBy',
            operationId: null,
            order: 8,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '8',
            guiSettings: 'hgfhghf',
            id: '9184e87c-2476-48c9-a867-9ece03c5bbbf',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'generalSettings',
            operationId: null,
            order: 1,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '8',
            guiSettings: 'asdasd',
            id: '6c9711c5-f885-4b9d-ae36-b9f989605ce6',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'imageUrl',
            operationId: null,
            order: 2,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '8',
            guiSettings: 'asdsfdf',
            id: '290aa8e8-65c3-4857-a75c-b0d367655d44',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'type',
            operationId: null,
            order: 3,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '8',
            guiSettings: 'asdsad',
            id: '1d058896-3622-4af8-82b6-f700097a7c3b',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'label',
            operationId: null,
            order: 4,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
        {
            createdBy: null,
            createdOn: null,
            dataTypeId: 'dataType.string',
            entityTypeId: '8',
            guiSettings: 'sdads',
            id: '777bbf19-d863-41d3-8454-faefef83d381',
            isArray: null,
            label: null,
            modifiedBy: null,
            modifiedOn: null,
            name: 'id',
            operationId: null,
            order: 5,
            reference: null,
            transactionId: null,
            universalStateId: '1',
            workspaceId: '1',
        },
    ],
    EntityTypeAttribute: [
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'attribute111',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'sis',
        },
        {
            id: '2',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'attribute2',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 3,
            reference: 'sis',
        },
        {
            id: '3',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'attribute3',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            dataTypeId: 'dataType.default',
            isArray: false,
            order: 3,
            reference: 'sis',
        },
        {
            id: '4',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'attribute4',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 4,
            reference: 'sis',
        },
        {
            id: '5',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'customeraddress',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'customeraddress',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'customeraddress',
        },
        {
            id: '6',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'VAT',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'VAT',
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 1,
            reference: 'VAT',
        },
        {
            id: '7',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'city',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'city',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'city',
        },
        {
            id: '8',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'useraddress',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'useraddress',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'user address',
        },
        {
            id: '9',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'userdateofbirth',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'userdateofbirth',
            dataTypeId: 'dataType.date',
            isArray: false,
            order: 1,
            reference: 'user date of birth',
        },
        {
            id: '10',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'email',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            label: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '2',
            guiSettings: 'email',
            dataTypeId: 'dataType.string',
            isArray: false,
            order: 1,
            reference: 'email',
        },
        {
            id: '9999999',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'discount',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            label: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: null,
            dataTypeId: 'dataType.number',
            isArray: false,
            order: 5,
            reference: null,
        },
    ],
    EntityTypesOperations: [
        {
            id: '1',
            universalStateId: '1',
            label: null,
            transactionId: null,
            operationId: null,
            name: 'operation1',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '2',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label: null,
            name: 'operation2',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '3',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label: null,
            name: 'operation3',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '4',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label: null,
            name: 'operation4',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '5',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            label: null,
            name: 'operation5',
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '3',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '6',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'save',
            createdBy: null,
            modifiedBy: null,
            label: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify({
                disableWhenFormInvalid: true,
                visibleExpression: 'this.viewMode==="edit" && this.entity!= null && this.entity.id == null',
                key: 'save',
                toolbarSlot: ToolbarSlot.Left,
            }),
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Post,
            order: 0,
        },
        {
            id: '7',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'update',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify({
                key: 'update',
                disableWhenFormInvalid: true,
                visibleExpression: 'this.viewMode==="edit" && this.entity!= null && this.entity.id != null',
                toolbarSlot: ToolbarSlot.Left,
                executedActionBehaviour: new ExecutedActionBehaviour(),
            }),
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Put,
            order: 0,
        },
        {
            id: '8',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'delete',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: JSON.stringify({
                visibleExpression: 'this.entity!= null && this.entity.id != null',
                key: 'delete',
                toolbarSlot: ToolbarSlot.Left,
                confirmationModal: 'message.delete-confirmation',
                executedActionBehaviour: new ExecutedActionBehaviour(),
            }),
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Delete,
            order: 0,
        },
        {
            id: '9',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'get',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: null,
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '10',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'updatePut',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '5',
            guiSettings: null,
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Put,
            order: 0,
        },
        {
            id: '999282828',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'view',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'create',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'update',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
        {
            id: '1',
            universalStateId: '1',
            transactionId: null,
            operationId: null,
            name: 'delete',
            label: null,
            createdBy: null,
            modifiedBy: null,
            createdOn: null,
            modifiedOn: null,
            workspaceId: '1',
            entityTypeId: '1',
            guiSettings: 'string',
            override: false,
            imports: null,
            sourceCode: 'string',
            httpVerb: HttpVerb.Get,
            order: 0,
        },
    ],
    product: [
        {
            id: '1',
            name: 'produto-1',
            description: 'produto-1-descrição',
            expiryDate: new Date(),
            value: 20,
            stock: 'stockStatus.available',
        },
        {
            id: '2',
            name: 'produto-2',
            description: 'produto-2-descrição',
            expiryDate: new Date(),
            value: 40,
            stock: 'stockStatus.unavailable',
        },
        {
            id: '3',
            name: 'produto-3',
            description: 'produto-3-descrição',
            expiryDate: new Date(),
            value: 15,
            stock: 'stockStatus.unavailable',
        },
        {
            id: '4',
            name: 'produto-4',
            description: 'produto-4-descrição',
            expiryDate: new Date(),
            value: 24,
            stock: 'stockStatus.available',
        },
        {
            id: '5',
            name: 'produto-5',
            description: 'produto-5-descrição',
            expiryDate: new Date(),
            value: 100,
            stock: 'stockStatus.available',
        },
        {
            id: '6',
            name: 'produto-6',
            description: 'produto-6-descrição',
            expiryDate: new Date(),
            value: 2,
            stock: 'stockStatus.available',
        },
        {
            id: '7',
            name: 'produto-7',
            description: 'produto-7-descrição',
            expiryDate: new Date(),
            value: 15.99,
            stock: 'stockStatus.unavailable',
        },
        {
            id: '8',
            name: 'produto-8',
            description: 'produto-8-descrição',
            expiryDate: new Date(),
            value: 92,
            stock: 'stockStatus.unavailable',
            attributes: {
                discount: 50,
            },
        },
        {
            id: '9',
            name: 'produto-9',
            description: 'produto-9-descrição',
            expiryDate: new Date(),
            value: 165,
            stock: 'stockStatus.available',
        },
        {
            id: '10',
            name: 'produto-10',
            description: 'produto-10-descrição',
            expiryDate: new Date(),
            value: 11,
            stock: 'stockStatus.available',
        },
    ],
    dashboard: [
        new Dashboard({
            name: 'MainDashboard',
            id: '1',
            path: 'Config/DashBoards/1',
            isPublic: true,
            settings: null,
            items: [
                new DashboardItem({
                    universalStateId: '1',
                    x: 1,
                    y: 0,
                    cols: 1,
                    id: '1679938981323',
                    rows: 1,
                    dashboardId: '1',
                    settings: null,
                    componentType: 'Bar-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 0,
                    cols: 1,
                    id: '1679931545',
                    rows: 1,
                    dashboardId: '1',
                    settings: null,
                    componentType: 'Table',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 1,
                    cols: 1,
                    rows: 1,
                    id: '1679995',
                    dashboardId: '1',
                    settings: null,
                    componentType: 'Line-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 1,
                    y: 1,
                    cols: 1,
                    rows: 1,
                    dashboardId: '1',
                    id: '1678975',
                    settings: null,
                    componentType: 'Table',
                }),
            ],
            entityTypeIds: ['1'],
            createdBy: '1',
        }),
        new Dashboard({
            name: 'SecondDashboard',
            id: '2',
            path: 'Config/DashBoards/2',
            isPublic: true,
            settings: null,
            items: [
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 0,
                    cols: 2,
                    rows: 1,
                    id: '165455',
                    dashboardId: '1',
                    settings: null,
                    componentType: 'Bar-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 1,
                    cols: 1,
                    rows: 1,
                    id: '16547775',
                    dashboardId: '1',
                    settings: null,
                    componentType: 'Line-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 1,
                    y: 1,
                    cols: 1,
                    rows: 1,
                    dashboardId: '1',
                    id: '1654754878775',
                    settings: null,
                    componentType: 'Table',
                }),
            ],
            entityTypeIds: ['1'],
            createdBy: '1',
        }),
        new Dashboard({
            universalStateId: '1',
            isPublic: true,
            id: '3',
            name: 'ThirdDashboard',
            createdBy: '2',
            entityTypeIds: ['1', '4'],
            items: [
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 0,
                    cols: 1,
                    rows: 1,
                    dashboardId: '3',
                    id: '1679933',
                    settings: null,
                    componentType: 'Bar-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 1,
                    cols: 1,
                    rows: 1,
                    id: '16799387851543',
                    dashboardId: '3',
                    settings: null,
                    componentType: 'Bar-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 1,
                    y: 0,
                    cols: 1,
                    rows: 1,
                    id: '16799387851548',
                    dashboardId: '3',
                    settings: null,
                    componentType: 'Bar-Chart',
                }),
            ],
            settings: '{"gridType":"fit","scale":1,"fixedColWidth":250,"fixedRowHeight":250,"keepFixedHeightInMobile":false,"keepFixedWidthInMobile":false,"setGridSize":false,"useBodyForBreakpoint":false,"compactType":"none","mobileBreakpoint":640,"allowMultiLayer":false,"defaultLayerIndex":1,"maxLayerIndex":2,"baseLayerIndex":1,"minCols":1,"maxCols":100,"minRows":1,"maxRows":100,"defaultItemCols":1,"defaultItemRows":1,"maxItemCols":50,"maxItemRows":50,"minItemCols":1,"minItemRows":1,"minItemArea":1,"maxItemArea":2500,"addEmptyRowsCount":0,"rowHeightRatio":1,"margin":5,"outerMargin":true,"useTransformPositioning":true,"scrollSensitivity":10,"scrollSpeed":20,"draggable.enabled":true,"draggable.delayStart":0,"draggable.ignoreContentClass":"gridster-item-content","draggable.ignoreContent":false,"draggable.dragHandleClass":"drag-handle","draggable.dropOverItems":false,"resizable.enabled":true,"resizable.delayStart":0,"resizable.handles.s":true,"resizable.handles.e":true,"resizable.handles.n":true,"resizable.handles.w":true,"resizable.handles.se":true,"resizable.handles.ne":true,"resizable.handles.sw":true,"resizable.handles.nw":true,"swap":true,"swapWhileDragging":false,"pushItems":false,"disablePushOnDrag":false,"disablePushOnResize":false,"disableAutoPositionOnConflict":false,"pushDirections.north":true,"pushDirections.east":true,"pushDirections.south":true,"pushDirections.west":true,"pushResizeItems":false,"displayGrid":"always","disableWindowResize":false,"disableWarnings":false,"scrollToNewItems":false,"disableScrollHorizontal":false,"disableScrollVertical":false,"enableBoundaryControl":false,"enableEmptyCellClick":true,"enableEmptyCellContextMenu":false,"enableEmptyCellDrop":false,"enableEmptyCellDrag":true,"enableOccupiedCellDrop":false,"emptyCellDragMaxCols":50,"emptyCellDragMaxRows":50,"ignoreMarginInRow":false,"dirType":"ltr"}',
        }),
        new Dashboard({
            universalStateId: '1',
            isPublic: true,
            id: '725cc79c-6e7e-4391-81cc-42de6ed8781e',
            name: 'FouthDashboard',
            entityTypeIds: ['1', '2'],
            items: [
                new DashboardItem({
                    universalStateId: '1',
                    x: 1,
                    y: 0,
                    cols: 1,
                    rows: 1,
                    id: '16799387851888',
                    dashboardId: '725cc79c-6e7e-4391-81cc-42de6ed8781e',
                    settings: null,
                    componentType: 'Line-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 0,
                    cols: 1,
                    id: '1679938785788',
                    rows: 1,
                    dashboardId: '725cc79c-6e7e-4391-81cc-42de6ed8781e',
                    settings: null,
                    componentType: 'Doughnut-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 0,
                    y: 1,
                    cols: 1,
                    rows: 1,
                    dashboardId: '725cc79c-6e7e-4391-81cc-42de6ed8781e',
                    id: '1679938785788444',
                    settings: null,
                    componentType: 'Bar-Chart',
                }),
                new DashboardItem({
                    universalStateId: '1',
                    x: 1,
                    y: 1,
                    cols: 1,
                    id: '2679938785788',
                    rows: 1,
                    dashboardId: '725cc79c-6e7e-4391-81cc-42de6ed8781e',
                    settings: null,
                    componentType: 'Table',
                }),
            ],
            createdBy: '2',
            settings: '{"gridType":"fit","scale":1,"fixedColWidth":250,"fixedRowHeight":250,"keepFixedHeightInMobile":false,"keepFixedWidthInMobile":false,"setGridSize":false,"useBodyForBreakpoint":false,"compactType":"none","mobileBreakpoint":640,"allowMultiLayer":false,"defaultLayerIndex":1,"maxLayerIndex":2,"baseLayerIndex":1,"minCols":1,"maxCols":100,"minRows":1,"maxRows":100,"defaultItemCols":1,"defaultItemRows":1,"maxItemCols":50,"maxItemRows":50,"minItemCols":1,"minItemRows":1,"minItemArea":1,"maxItemArea":2500,"addEmptyRowsCount":0,"rowHeightRatio":1,"margin":5,"outerMargin":true,"useTransformPositioning":true,"scrollSensitivity":10,"scrollSpeed":20,"draggable.enabled":true,"draggable.delayStart":0,"draggable.ignoreContentClass":"gridster-item-content","draggable.ignoreContent":false,"draggable.dragHandleClass":"drag-handle","draggable.dropOverItems":false,"resizable.enabled":true,"resizable.delayStart":0,"resizable.handles.s":true,"resizable.handles.e":true,"resizable.handles.n":true,"resizable.handles.w":true,"resizable.handles.se":true,"resizable.handles.ne":true,"resizable.handles.sw":true,"resizable.handles.nw":true,"swap":true,"swapWhileDragging":false,"pushItems":false,"disablePushOnDrag":false,"disablePushOnResize":false,"disableAutoPositionOnConflict":false,"pushDirections.north":true,"pushDirections.east":true,"pushDirections.south":true,"pushDirections.west":true,"pushResizeItems":false,"displayGrid":"always","disableWindowResize":false,"disableWarnings":false,"scrollToNewItems":false,"disableScrollHorizontal":false,"disableScrollVertical":false,"enableBoundaryControl":false,"enableEmptyCellClick":true,"enableEmptyCellContextMenu":false,"enableEmptyCellDrop":false,"enableEmptyCellDrag":true,"enableOccupiedCellDrop":false,"emptyCellDragMaxCols":50,"emptyCellDragMaxRows":50,"ignoreMarginInRow":false,"dirType":"ltr"}',
        }),
    ],
    componentType: [
        new ComponentType({
            id: '1',
            type: ComponentTypeEnum.BarChart,
            name: 'Bar Chart',
            imageUrl: '/assets/images/component_type_images/bar-chart.PNG',
            generalSettings: null,
        }),
        new ComponentType({
            id: '2',
            type: ComponentTypeEnum.LineChart,
            name: 'Line Chart',
            imageUrl: '/assets/images/component_type_images/line-chart.PNG',
            generalSettings: null,
        }),
        new ComponentType({
            id: '3',
            type: ComponentTypeEnum.DoughnutChart,
            name: 'Donut Chart',
            imageUrl: '/assets/images/component_type_images/donut-chart.PNG',
            generalSettings: null,
        }),
        new ComponentType({
            id: '4',
            type: ComponentTypeEnum.Table,
            name: 'Table',
            imageUrl: '/assets/images/component_type_images/table.PNG',
            generalSettings: null,
        }),
    ],
};
//# sourceMappingURL=data:application/json;base64,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