import { Validators } from '@angular/forms';
import { CheckboxConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/checkbox/checkbox.model';
import { SelectConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/select/select.model';
import { ControlName } from '../../core/components/dynamic-form/models/constants/control-names';
import { ReferenceType } from '../../core/components/dynamic-form/models/constants/reference-type';
/**
 * Dynamic form fields configurations to Entity type property
 */
export const ENTITY_TYPE_PROPERTY_DYNAMIC_FORM = {
    fields: [
        {
            controlName: ControlName.inputText,
            readonly: false,
            key: 'name',
            validators: [Validators.required],
            basePathTranslation: 'entity-type.properties.fields',
        },
        {
            controlName: ControlName.inputText,
            readonly: false,
            key: 'guiSettings',
            validators: [Validators.required],
            basePathTranslation: 'entity-type.properties.fields',
        },
        new SelectConfiguration({
            referenceType: ReferenceType.LookupTable,
            referenceName: 'dataType',
            readonly: false,
            key: 'dataTypeId',
            optionLabel: 'label',
            optionValue: 'id',
            validators: [Validators.required],
            basePathTranslation: 'entity-type.properties.fields',
        }),
        new CheckboxConfiguration({
            key: 'isArray',
            basePathTranslation: 'entity-type.properties.fields',
        }),
        new SelectConfiguration({
            referenceType: ReferenceType.LookupTable,
            readonly: false,
            key: 'reference',
            optionLabel: 'label',
            optionValue: 'name',
            visibleExpression: "this.form.get('dataTypeId').getRawValue() && this.form.get('dataTypeId').getRawValue().toLowerCase()==='datatype.lookuptable'",
        }),
        new SelectConfiguration({
            referenceType: ReferenceType.EntityType,
            readonly: false,
            key: 'reference',
            optionLabel: 'name',
            optionValue: 'name',
            visibleExpression: "this.form.get('dataTypeId').getRawValue() && this.form.get('dataTypeId').getRawValue().toLowerCase()==='datatype.entitytype'",
        }),
    ],
};
//# sourceMappingURL=data:application/json;base64,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