import { Validators } from '@angular/forms';
import { SelectConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/select/select.model';
import { ControlName } from '../../core/components/dynamic-form/models/constants/control-names';
import { HttpVerb } from '../models/entity-type.model';
/**
 * Dynamic form fields configurations to Entity type operation
 */
export const ENTITY_TYPE_OPERATION_DYNAMIC_FORM = {
    fields: [
        {
            controlName: ControlName.inputText,
            value: null,
            readonly: false,
            key: 'name',
            validators: [Validators.required],
        },
        {
            controlName: ControlName.inputText,
            value: null,
            readonly: false,
            key: 'guiSettings',
            validators: [Validators.required],
        },
        new SelectConfiguration({
            controlName: ControlName.dropdown,
            value: null,
            readonly: false,
            key: 'httpVerb',
            options: [
                { value: HttpVerb.Get, label: 'get' },
                { value: HttpVerb.Post, label: 'post' },
                { value: HttpVerb.Delete, label: 'delete' },
                { value: HttpVerb.Put, label: 'put' },
                { value: HttpVerb.Patch, label: 'patch' },
            ],
            filter: true,
            validators: [Validators.required],
        }),
    ],
};
//# sourceMappingURL=data:application/json;base64,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