import { Validators } from '@angular/forms';
import { BaseAction, BaseActionKey, } from '../../core/components/dynamic-form/models/base-action';
import { BaseField } from '../../core/components/dynamic-form/models/base-field';
import { ActionName } from '../../core/components/dynamic-form/models/constants/action-names';
import { ControlName } from '../../core/components/dynamic-form/models/constants/control-names';
import { ToolbarSlot } from '../../core/components/dynamic-form/models/constants/toolbar-slots';
/**
 * Dynamic form fields and actions configurations to Entity type
 */
export const ENTITY_TYPE_DYNAMIC_FORM = {
    fields: [
        new BaseField({
            controlName: ControlName.inputText,
            value: null,
            key: 'name',
            validators: [Validators.required],
            basePathTranslation: 'entity-type.fields',
        }),
        new BaseField({
            controlName: ControlName.inputText,
            value: null,
            key: 'guiSettings',
            validators: [Validators.required],
            basePathTranslation: 'entity-type.fields',
        }),
        new BaseField({
            controlName: ControlName.inputText,
            value: null,
            key: 'group',
            validators: [Validators.required],
            basePathTranslation: 'entity-type.fields',
        }),
        new BaseField({
            controlName: ControlName.inputText,
            visibleExpression: ' this.entity!= null && this.entity.id',
            value: '1',
            key: 'universalStateId',
            basePathTranslation: 'entity-type.fields',
        }),
    ],
    actions: [
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Save,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='edit'",
        }),
        new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: true,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='read'",
        }),
    ],
};
//# sourceMappingURL=data:application/json;base64,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