import { Validators } from '@angular/forms';
import { SelectConfiguration } from '../../core/components/dynamic-form/dynamic-form-fields/fields/select/select.model';
import { ControlName } from '../../core/components/dynamic-form/models/constants/control-names';
import { ReferenceType } from '../../core/components/dynamic-form/models/constants/reference-type';
/**
 * Dynamic form fields configurations to Entity type Attribute
 */
export const ENTITY_TYPE_ATTRIBUTE_DYNAMIC_FORM = {
    fields: [
        {
            controlName: ControlName.inputText,
            readonly: false,
            key: 'name',
            validators: [Validators.required],
        },
        {
            controlName: ControlName.inputText,
            readonly: false,
            key: 'guiSettings',
            validators: [Validators.required],
        },
        new SelectConfiguration({
            referenceType: ReferenceType.LookupTable,
            referenceName: 'dataType',
            readonly: false,
            key: 'dataTypeId',
            optionLabel: 'name',
            optionValue: 'id',
            validators: [Validators.required],
        }),
    ],
};
//# sourceMappingURL=data:application/json;base64,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