import { Component, Inject, Input, ViewChild, } from '@angular/core';
import { ConfirmationService } from 'primeng/api';
import { DialogService } from 'primeng/dynamicdialog';
import { Table } from 'primeng/table';
import { ReferenceType } from '../../../core/components/dynamic-form/models/constants/reference-type';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { PrimeNgTypeToOurTypes, } from '../../../core/models/filters';
import { PRG_ENTITY_TYPES_CONFIG } from '../../services/entity-types-configuration/prg-entity-types-configuration.service';
import { PrgEntityTypeElementComponent } from '../entity-type-element/prg-entity-type-element.component';
import * as i0 from "@angular/core";
import * as i1 from "../../services/entity-types/abstract-entity-type.service";
import * as i2 from "primeng/dynamicdialog";
import * as i3 from "../../../core/services/utility/primeng-utility.service";
import * as i4 from "@ngx-translate/core";
import * as i5 from "@angular/router";
import * as i6 from "primeng/inputtext";
import * as i7 from "primeng/api";
import * as i8 from "@angular/common";
import * as i9 from "primeng/table";
import * as i10 from "primeng/button";
import * as i11 from "primeng/multiselect";
import * as i12 from "primeng/dropdown";
import * as i13 from "@angular/forms";
import * as i14 from "../../../core/components/dynamic-form/dynamic-form-fields/fields/select/select.model";
/**
 * list specific entity type elemens
 */
/**
 * PrgListSpecificEntityTypeComponent
 */
export class PrgListSpecificEntityTypeComponent {
    /**
     * constructor
     *
     * @param entityTypeService
     * @param lookupTableService
     * @param dialogService
     * @param prgEntityTypesConfig
     * @param primengUtilityService
     * @param translateService
     * @param router
     */
    constructor(entityTypeService, dialogService, prgEntityTypesConfig, primengUtilityService, translateService, router) {
        this.entityTypeService = entityTypeService;
        this.dialogService = dialogService;
        this.prgEntityTypesConfig = prgEntityTypesConfig;
        this.primengUtilityService = primengUtilityService;
        this.translateService = translateService;
        this.router = router;
        this.onClickGoTo = null;
        /**
         * entity type elemens
         */
        this.entityTypeAllElements = [];
        /**
         * auxiliar primeNgTypeToOurTypes enum
         */
        this.primeNgTypeToOurTypes = PrimeNgTypeToOurTypes;
        /**
         * auxiliar ReferenceType enum
         */
        this.ReferenceType = ReferenceType;
        /**
         * selected columns objects data
         */
        this.selectedColumnsObject = [];
        /**
         * A class property used to unsubscribe observables on ngOnDestroy
         */
        this.subscription = [];
        /**
         * glabal filter is active
         */
        this.globalFilterIsActive = false;
        /**
         * global filtar diabled
         */
        this.globalFilterDisabled = false;
    }
    /**
     * ngOnInit
     */
    async ngOnInit() {
        this.tableConfigs = this.prgEntityTypesConfig.specificEntityTypeListConfigs;
        this.entityType = await this.entityTypeService.getAllEntityTypeDataByName(this.entityTypeName);
        this.columnsSelectedLabel = await this.translateService
            .get('primeng.columns-selected')
            .toPromise();
        this.groupPropertyAndAttributesToColumnsSelect();
        this.getColumnsData();
        this.loading = true;
    }
    /**
     * ngOnDestroy
     *
     * Unsubscribe all subscriptions
     */
    ngOnDestroy() {
        this.subscription.forEach((subscription) => {
            subscription.unsubscribe();
        });
        this.subscription = [];
    }
    /**
     * this function is executed every time
     * there is a change in the table's settings (pagination filters, etc)
     * @param event
     */
    async lazyLoadElements(event) {
        if (event.globalFilter) {
            this.globalFilterIsActive = true;
        }
        else {
            this.globalFilterIsActive = false;
        }
        if (this.checkIfHaveColumnFilter(event.filters)) {
            this.globalFilterValue = '';
            this.globalFilterDisabled = true;
        }
        else {
            this.globalFilterDisabled = false;
        }
        this.createFilterGroup(event);
        this.getTableData();
    }
    /**
     * this function make an reset to table
     */
    clearAllFilters() {
        this.dataTableComponent.reset();
    }
    /**
     * open popup to edit or create an element
     * @param element
     */
    editElement(event, onPopup, element) {
        if (onPopup) {
            event.stopPropagation();
            this.elementOnPopUp(element, ViewMode.Read);
        }
        else {
            if (this.onClickGoTo) {
                this.router.navigate([this.onClickGoTo, element.id]);
            }
            else {
                this.router.navigate([this.router.url, element.id]);
            }
        }
    }
    /**
     * this function is responsible for opening the popup or
     * redirect to the page to be created a new element
     */
    addNewElement(onPopup) {
        if (onPopup) {
            this.elementOnPopUp({}, ViewMode.Edit);
        }
        else {
            this.router.navigate([this.router.url, 'new']);
        }
    }
    /**
     * this function is used when we have a custom filter,
     * and the value is a lookuptable, when we click on apply
     * we don't have the value set in the filters,
     * and I do this setter here, it just allows to have a search(not add option a and b)
     * @param value
     * @param field
     * @param matchMode
     */
    lookupTableFilterChange(value, field, matchMode) {
        let operator = 'and';
        const filterAux = this.dataTableComponent.filters[field];
        if (filterAux) {
            operator = filterAux[0].operator;
        }
        this.dataTableComponent.filters[field] = [
            { value: value, matchMode: matchMode, operator: operator },
        ];
    }
    /**
     * get columns object by columns name in table configs
     */
    getColumnsData() {
        this.tableConfigs.defaultColumns.forEach((col) => {
            let field = this.entityType.properties.find((property) => property.name === col);
            if (!field) {
                field = this.entityType.attributes.find((attribute) => attribute.name === col);
            }
            if (field) {
                this.selectedColumnsObject.push(field);
            }
        });
    }
    /**
     * create multiselect groups
     */
    groupPropertyAndAttributesToColumnsSelect() {
        this.entityGroups = [
            {
                label: 'Properties',
                value: 'properties',
                items: this.entityType.properties,
            },
            // {
            //   label: 'Attributes',
            //   value: 'attributes',
            //   items: this.entityType.attributes,
            // },
        ];
    }
    /**
     * this function makes the request to get the data to be showed in the table
     */
    async getTableData() {
        const paginationResponse = await this.entityTypeService.getEntityTypeElements(this.entityTypeName, this.filterGroup);
        this.entityTypeAllElements = paginationResponse.items;
        this.totalRecords = paginationResponse.totalItems;
        this.loading = false;
    }
    /**
     * this is an auxiliary function to check
     * if any of the table's filters are active
     * @param filters
     * @returns
     */
    checkIfHaveColumnFilter(filters) {
        let filtersKeys = Object.keys(filters);
        let findValue = false;
        if (filtersKeys.length) {
            let index = filtersKeys.indexOf('global');
            if (index !== -1) {
                filtersKeys.splice(index, 1);
            }
            filtersKeys.forEach((filterKey) => {
                if (filters[filterKey][0].value) {
                    findValue = true;
                }
            });
            return findValue;
        }
        else {
            return false;
        }
    }
    /**
     * this function calls the service that receives
     * the event (LazyLoadEvent) and creates a filterGroup
     * @param event
     * @returns
     */
    createFilterGroup(event) {
        this.filterGroup = this.primengUtilityService.getFilterGroupByLazyLoadEvent(event, this.tableConfigs.globalFilterFields);
    }
    /**
     * this function is responsible for creating
     *  the popup to edit or add an element
     * @param element
     * @param viewMode
     */
    elementOnPopUp(element, viewMode) {
        this.elementRef = this.dialogService.open(PrgEntityTypeElementComponent, {
            data: {
                element: element,
                entityType: this.entityType,
                viewMode: viewMode,
            },
            width: '90vw',
            showHeader: true,
            contentStyle: { 'max-height': '70%', overflow: 'auto' },
            dismissableMask: true,
        });
        this.subscription.push(this.elementRef.onClose.subscribe((data) => {
            if (data) {
                if (data.reloadData) {
                    this.getTableData();
                }
                else if (data.resetTable) {
                    this.dataTableComponent.reset();
                }
            }
            this.elementRef.destroy();
        }));
    }
}
PrgListSpecificEntityTypeComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgListSpecificEntityTypeComponent, deps: [{ token: i1.AbstractEntityTypeService }, { token: i2.DialogService }, { token: PRG_ENTITY_TYPES_CONFIG }, { token: i3.PrimengUtilityService }, { token: i4.TranslateService }, { token: i5.Router }], target: i0.ɵɵFactoryTarget.Component });
PrgListSpecificEntityTypeComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgListSpecificEntityTypeComponent, selector: "prg-list-specific-entity-type", inputs: { entityTypeName: "entityTypeName", onClickGoTo: "onClickGoTo" }, providers: [DialogService, ConfirmationService], viewQueries: [{ propertyName: "dataTableComponent", first: true, predicate: Table, descendants: true }], ngImport: i0, template: "<div>\r\n  <p-table\r\n    #dataTableComponent\r\n    [value]=\"entityTypeAllElements\"\r\n    [lazy]=\"true\"\r\n    (onLazyLoad)=\"lazyLoadElements($event)\"\r\n    [columns]=\"selectedColumnsObject\"\r\n    [paginator]=\"true\"\r\n    [rows]=\"tableConfigs.pagination.totalRows\"\r\n    [totalRecords]=\"totalRecords\"\r\n    [rowsPerPageOptions]=\"tableConfigs.pagination.rowsPerPageOptions\"\r\n    [reorderableColumns]=\"true\"\r\n    [globalFilterFields]=\"['name']\"\r\n    [filterDelay]=\"1000\"\r\n    [sortMode]=\"'multiple'\"\r\n    [multiSortMeta]=\"tableConfigs.multiSortMeta\"\r\n    responsiveLayout=\"scroll\"\r\n  >\r\n    <ng-template pTemplate=\"caption\">\r\n      <div style=\"text-align: left\">\r\n        <p-button\r\n          [label]=\"'buttons.add.label' | translate\"\r\n          (click)=\"addNewElement(false)\"\r\n        ></p-button>\r\n        <p-multiSelect\r\n          [options]=\"entityGroups\"\r\n          [group]=\"true\"\r\n          [(ngModel)]=\"selectedColumnsObject\"\r\n          scrollHeight=\"250px\"\r\n          optionLabel=\"name\"\r\n          [maxSelectedLabels]=\"1\"\r\n          selectedItemsLabel=\"{0} {{ columnsSelectedLabel }}\"\r\n        >\r\n          <ng-template let-group pTemplate=\"group\">\r\n            <div *ngIf=\"group.items.length\" class=\"flex align-items-center\">\r\n              <span>\r\n                {{ 'entity-type.tabs.' + group.value + '.label' | translate }}\r\n              </span>\r\n            </div>\r\n          </ng-template>\r\n        </p-multiSelect>\r\n        <!--we are calling this function on the input to trigger the lazy load function-->\r\n        <span class=\"p-input-icon-left ml-auto\">\r\n          <i class=\"pi pi-search\"></i>\r\n          <input\r\n            pInputText\r\n            type=\"text\"\r\n            (input)=\"\r\n              dataTableComponent.filterGlobal(\r\n                $any($event).target.value,\r\n                'contains'\r\n              )\r\n            \"\r\n            [ngModel]=\"globalFilterValue\"\r\n            [disabled]=\"globalFilterDisabled\"\r\n            placeholder=\"{{\r\n              'components.entity-type.global-search.placeholder' | translate\r\n            }}\"\r\n          />\r\n        </span>\r\n        <button\r\n          pButton\r\n          label=\"{{ 'buttons.reset-table.label' | translate }}\"\r\n          class=\"p-button-outlined\"\r\n          icon=\"pi pi-filter-slash\"\r\n          (click)=\"clearAllFilters()\"\r\n        ></button>\r\n      </div>\r\n    </ng-template>\r\n    <ng-template pTemplate=\"header\" let-columns>\r\n      <tr>\r\n        <th style=\"width: 2rem\">\r\n          <p-button\r\n            type=\"button\"\r\n            icon=\"pi pi-plus-circle\"\r\n            pAddRow\r\n            (click)=\"addNewElement(true)\"\r\n          ></p-button>\r\n        </th>\r\n        <ng-container *ngFor=\"let col of selectedColumnsObject\">\r\n          <th [pSortableColumn]=\"col.name\" pReorderableColumn>\r\n            {{\r\n              'entities.' + entityType.name + '.fields.' + col.name + '.label'\r\n                | translate\r\n            }}\r\n            <p-sortIcon [field]=\"col.name\"></p-sortIcon>\r\n            <p-columnFilter\r\n              [hidden]=\"globalFilterIsActive\"\r\n              [type]=\"primeNgTypeToOurTypes[col.dataTypeId]\"\r\n              [field]=\"col.name\"\r\n              [matchMode]=\"\r\n                col.dataTypeId === 'dataType.lookupTable' ? 'equals' : null\r\n              \"\r\n              display=\"menu\"\r\n              [showAddButton]=\"\r\n                col.dataTypeId === 'dataType.lookupTable' ? false : true\r\n              \"\r\n            >\r\n              <ng-template\r\n                *ngIf=\"col.dataTypeId === 'dataType.lookupTable'\"\r\n                pTemplate=\"filter\"\r\n                let-value\r\n                let-filter=\"filterCallback\"\r\n              >\r\n                <p-dropdown\r\n                  [setSelectConfigs]=\"{\r\n                    readonly: false,\r\n                    optionLabel: 'label',\r\n                    optionValue: 'id',\r\n                    key: col.name,\r\n                    value: dataTableComponent.filters[col.name][0].value,\r\n                    referenceType: ReferenceType.LookupTable,\r\n                    referenceName: col.reference\r\n                  }\"\r\n                  (onChange)=\"\r\n                    lookupTableFilterChange($event.value, col.name, 'equals')\r\n                  \"\r\n                  placeholder=\"Select any\"\r\n                >\r\n                </p-dropdown>\r\n              </ng-template>\r\n            </p-columnFilter>\r\n          </th>\r\n        </ng-container>\r\n      </tr>\r\n    </ng-template>\r\n    <ng-template pTemplate=\"body\" let-element>\r\n      <tr style=\"cursor: pointer\" (click)=\"editElement($event, false, element)\">\r\n        <td>\r\n          <i class=\"pi pi-eye\" (click)=\"editElement($event, true, element)\"></i>\r\n        </td>\r\n        <td *ngFor=\"let col of selectedColumnsObject; let i = index\">\r\n          <ng-container [ngSwitch]=\"col.dataTypeId\">\r\n            <p *ngSwitchCase=\"'dataType.lookupTable'\">\r\n              <p-dropdown\r\n                [setSelectConfigs]=\"{\r\n                  readonly: true,\r\n                  optionLabel: 'label',\r\n                  optionValue: 'id',\r\n                  key: col.name,\r\n                  value: element[col.name],\r\n                  referenceType: ReferenceType.LookupTable,\r\n                  referenceName: col.reference\r\n                }\"\r\n              ></p-dropdown>\r\n            </p>\r\n            <p *ngSwitchCase=\"'dataType.date'\">\r\n              {{ element[col.name] | date: ('app.date-format' | translate) }}\r\n            </p>\r\n            <p *ngSwitchDefault>{{ element[col.name] }}</p>\r\n          </ng-container>\r\n        </td>\r\n      </tr>\r\n    </ng-template>\r\n  </p-table>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "directive", type: i6.InputText, selector: "[pInputText]" }, { kind: "directive", type: i7.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i8.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i8.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i8.NgSwitch, selector: "[ngSwitch]", inputs: ["ngSwitch"] }, { kind: "directive", type: i8.NgSwitchCase, selector: "[ngSwitchCase]", inputs: ["ngSwitchCase"] }, { kind: "directive", type: i8.NgSwitchDefault, selector: "[ngSwitchDefault]" }, { kind: "component", type: i9.Table, selector: "p-table", inputs: ["frozenColumns", "frozenValue", "style", "styleClass", "tableStyle", "tableStyleClass", "paginator", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "paginatorDropdownScrollHeight", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showJumpToPageInput", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "selectionMode", "selectionPageOnly", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "rowSelectable", "rowTrackBy", "lazy", "lazyLoadOnInit", "compareSelectionBy", "csvSeparator", "exportFilename", "filters", "globalFilterFields", "filterDelay", "filterLocale", "expandedRowKeys", "editingRowKeys", "rowExpandMode", "scrollable", "scrollDirection", "rowGroupMode", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "responsive", "contextMenu", "resizableColumns", "columnResizeMode", "reorderableColumns", "loading", "loadingIcon", "showLoader", "rowHover", "customSort", "showInitialSortBadge", "autoLayout", "exportFunction", "exportHeader", "stateKey", "stateStorage", "editMode", "groupRowsBy", "groupRowsByOrder", "responsiveLayout", "breakpoint", "virtualRowHeight", "value", "columns", "first", "rows", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection", "selectAll"], outputs: ["selectAllChange", "selectionChange", "contextMenuSelectionChange", "onRowSelect", "onRowUnselect", "onPage", "onSort", "onFilter", "onLazyLoad", "onRowExpand", "onRowCollapse", "onContextMenuSelect", "onColResize", "onColReorder", "onRowReorder", "onEditInit", "onEditComplete", "onEditCancel", "onHeaderCheckboxToggle", "sortFunction", "firstChange", "rowsChange", "onStateSave", "onStateRestore"] }, { kind: "directive", type: i9.SortableColumn, selector: "[pSortableColumn]", inputs: ["pSortableColumn", "pSortableColumnDisabled"] }, { kind: "directive", type: i9.ReorderableColumn, selector: "[pReorderableColumn]", inputs: ["pReorderableColumnDisabled"] }, { kind: "component", type: i9.SortIcon, selector: "p-sortIcon", inputs: ["field"] }, { kind: "component", type: i9.ColumnFilter, selector: "p-columnFilter", inputs: ["field", "type", "display", "showMenu", "matchMode", "operator", "showOperator", "showClearButton", "showApplyButton", "showMatchModes", "showAddButton", "hideOnClear", "placeholder", "matchModeOptions", "maxConstraints", "minFractionDigits", "maxFractionDigits", "prefix", "suffix", "locale", "localeMatcher", "currency", "currencyDisplay", "useGrouping", "showButtons"] }, { kind: "directive", type: i10.ButtonDirective, selector: "[pButton]", inputs: ["iconPos", "loadingIcon", "label", "icon", "loading"] }, { kind: "component", type: i10.Button, selector: "p-button", inputs: ["type", "iconPos", "icon", "badge", "label", "disabled", "loading", "loadingIcon", "style", "styleClass", "badgeClass", "ariaLabel"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "component", type: i11.MultiSelect, selector: "p-multiSelect", inputs: ["style", "styleClass", "panelStyle", "panelStyleClass", "inputId", "disabled", "readonly", "group", "filter", "filterPlaceHolder", "filterLocale", "overlayVisible", "tabindex", "appendTo", "dataKey", "name", "label", "ariaLabelledBy", "displaySelectedLabel", "maxSelectedLabels", "selectionLimit", "selectedItemsLabel", "showToggleAll", "emptyFilterMessage", "emptyMessage", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "showHeader", "autoZIndex", "baseZIndex", "filterBy", "scrollHeight", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "filterMatchMode", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "display", "autocomplete", "showClear", "defaultLabel", "placeholder", "options", "filterValue", "itemSize"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onClear", "onPanelShow", "onPanelHide", "onLazyLoad"] }, { kind: "component", type: i12.Dropdown, selector: "p-dropdown", inputs: ["scrollHeight", "filter", "name", "style", "panelStyle", "styleClass", "panelStyleClass", "readonly", "required", "editable", "appendTo", "tabindex", "placeholder", "filterPlaceholder", "filterLocale", "inputId", "selectId", "dataKey", "filterBy", "autofocus", "resetFilterOnHide", "dropdownIcon", "optionLabel", "optionValue", "optionDisabled", "optionGroupLabel", "optionGroupChildren", "autoDisplayFirst", "group", "showClear", "emptyFilterMessage", "emptyMessage", "lazy", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "autoZIndex", "baseZIndex", "showTransitionOptions", "hideTransitionOptions", "ariaFilterLabel", "ariaLabel", "ariaLabelledBy", "filterMatchMode", "maxlength", "tooltip", "tooltipPosition", "tooltipPositionStyle", "tooltipStyleClass", "autofocusFilter", "disabled", "itemSize", "options", "filterValue"], outputs: ["onChange", "onFilter", "onFocus", "onBlur", "onClick", "onShow", "onHide", "onClear", "onLazyLoad"] }, { kind: "directive", type: i13.DefaultValueAccessor, selector: "input:not([type=checkbox])[formControlName],textarea[formControlName],input:not([type=checkbox])[formControl],textarea[formControl],input:not([type=checkbox])[ngModel],textarea[ngModel],[ngDefaultControl]" }, { kind: "directive", type: i13.NgControlStatus, selector: "[formControlName],[ngModel],[formControl]" }, { kind: "directive", type: i13.NgModel, selector: "[ngModel]:not([formControlName]):not([formControl])", inputs: ["name", "disabled", "ngModel", "ngModelOptions"], outputs: ["ngModelChange"], exportAs: ["ngModel"] }, { kind: "directive", type: i14.PrgSetSelectConfigsDirective, selector: "[setSelectConfigs]", inputs: ["form", "setSelectConfigs"] }, { kind: "pipe", type: i8.DatePipe, name: "date" }, { kind: "pipe", type: i4.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgListSpecificEntityTypeComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-list-specific-entity-type', providers: [DialogService, ConfirmationService], template: "<div>\r\n  <p-table\r\n    #dataTableComponent\r\n    [value]=\"entityTypeAllElements\"\r\n    [lazy]=\"true\"\r\n    (onLazyLoad)=\"lazyLoadElements($event)\"\r\n    [columns]=\"selectedColumnsObject\"\r\n    [paginator]=\"true\"\r\n    [rows]=\"tableConfigs.pagination.totalRows\"\r\n    [totalRecords]=\"totalRecords\"\r\n    [rowsPerPageOptions]=\"tableConfigs.pagination.rowsPerPageOptions\"\r\n    [reorderableColumns]=\"true\"\r\n    [globalFilterFields]=\"['name']\"\r\n    [filterDelay]=\"1000\"\r\n    [sortMode]=\"'multiple'\"\r\n    [multiSortMeta]=\"tableConfigs.multiSortMeta\"\r\n    responsiveLayout=\"scroll\"\r\n  >\r\n    <ng-template pTemplate=\"caption\">\r\n      <div style=\"text-align: left\">\r\n        <p-button\r\n          [label]=\"'buttons.add.label' | translate\"\r\n          (click)=\"addNewElement(false)\"\r\n        ></p-button>\r\n        <p-multiSelect\r\n          [options]=\"entityGroups\"\r\n          [group]=\"true\"\r\n          [(ngModel)]=\"selectedColumnsObject\"\r\n          scrollHeight=\"250px\"\r\n          optionLabel=\"name\"\r\n          [maxSelectedLabels]=\"1\"\r\n          selectedItemsLabel=\"{0} {{ columnsSelectedLabel }}\"\r\n        >\r\n          <ng-template let-group pTemplate=\"group\">\r\n            <div *ngIf=\"group.items.length\" class=\"flex align-items-center\">\r\n              <span>\r\n                {{ 'entity-type.tabs.' + group.value + '.label' | translate }}\r\n              </span>\r\n            </div>\r\n          </ng-template>\r\n        </p-multiSelect>\r\n        <!--we are calling this function on the input to trigger the lazy load function-->\r\n        <span class=\"p-input-icon-left ml-auto\">\r\n          <i class=\"pi pi-search\"></i>\r\n          <input\r\n            pInputText\r\n            type=\"text\"\r\n            (input)=\"\r\n              dataTableComponent.filterGlobal(\r\n                $any($event).target.value,\r\n                'contains'\r\n              )\r\n            \"\r\n            [ngModel]=\"globalFilterValue\"\r\n            [disabled]=\"globalFilterDisabled\"\r\n            placeholder=\"{{\r\n              'components.entity-type.global-search.placeholder' | translate\r\n            }}\"\r\n          />\r\n        </span>\r\n        <button\r\n          pButton\r\n          label=\"{{ 'buttons.reset-table.label' | translate }}\"\r\n          class=\"p-button-outlined\"\r\n          icon=\"pi pi-filter-slash\"\r\n          (click)=\"clearAllFilters()\"\r\n        ></button>\r\n      </div>\r\n    </ng-template>\r\n    <ng-template pTemplate=\"header\" let-columns>\r\n      <tr>\r\n        <th style=\"width: 2rem\">\r\n          <p-button\r\n            type=\"button\"\r\n            icon=\"pi pi-plus-circle\"\r\n            pAddRow\r\n            (click)=\"addNewElement(true)\"\r\n          ></p-button>\r\n        </th>\r\n        <ng-container *ngFor=\"let col of selectedColumnsObject\">\r\n          <th [pSortableColumn]=\"col.name\" pReorderableColumn>\r\n            {{\r\n              'entities.' + entityType.name + '.fields.' + col.name + '.label'\r\n                | translate\r\n            }}\r\n            <p-sortIcon [field]=\"col.name\"></p-sortIcon>\r\n            <p-columnFilter\r\n              [hidden]=\"globalFilterIsActive\"\r\n              [type]=\"primeNgTypeToOurTypes[col.dataTypeId]\"\r\n              [field]=\"col.name\"\r\n              [matchMode]=\"\r\n                col.dataTypeId === 'dataType.lookupTable' ? 'equals' : null\r\n              \"\r\n              display=\"menu\"\r\n              [showAddButton]=\"\r\n                col.dataTypeId === 'dataType.lookupTable' ? false : true\r\n              \"\r\n            >\r\n              <ng-template\r\n                *ngIf=\"col.dataTypeId === 'dataType.lookupTable'\"\r\n                pTemplate=\"filter\"\r\n                let-value\r\n                let-filter=\"filterCallback\"\r\n              >\r\n                <p-dropdown\r\n                  [setSelectConfigs]=\"{\r\n                    readonly: false,\r\n                    optionLabel: 'label',\r\n                    optionValue: 'id',\r\n                    key: col.name,\r\n                    value: dataTableComponent.filters[col.name][0].value,\r\n                    referenceType: ReferenceType.LookupTable,\r\n                    referenceName: col.reference\r\n                  }\"\r\n                  (onChange)=\"\r\n                    lookupTableFilterChange($event.value, col.name, 'equals')\r\n                  \"\r\n                  placeholder=\"Select any\"\r\n                >\r\n                </p-dropdown>\r\n              </ng-template>\r\n            </p-columnFilter>\r\n          </th>\r\n        </ng-container>\r\n      </tr>\r\n    </ng-template>\r\n    <ng-template pTemplate=\"body\" let-element>\r\n      <tr style=\"cursor: pointer\" (click)=\"editElement($event, false, element)\">\r\n        <td>\r\n          <i class=\"pi pi-eye\" (click)=\"editElement($event, true, element)\"></i>\r\n        </td>\r\n        <td *ngFor=\"let col of selectedColumnsObject; let i = index\">\r\n          <ng-container [ngSwitch]=\"col.dataTypeId\">\r\n            <p *ngSwitchCase=\"'dataType.lookupTable'\">\r\n              <p-dropdown\r\n                [setSelectConfigs]=\"{\r\n                  readonly: true,\r\n                  optionLabel: 'label',\r\n                  optionValue: 'id',\r\n                  key: col.name,\r\n                  value: element[col.name],\r\n                  referenceType: ReferenceType.LookupTable,\r\n                  referenceName: col.reference\r\n                }\"\r\n              ></p-dropdown>\r\n            </p>\r\n            <p *ngSwitchCase=\"'dataType.date'\">\r\n              {{ element[col.name] | date: ('app.date-format' | translate) }}\r\n            </p>\r\n            <p *ngSwitchDefault>{{ element[col.name] }}</p>\r\n          </ng-container>\r\n        </td>\r\n      </tr>\r\n    </ng-template>\r\n  </p-table>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.AbstractEntityTypeService }, { type: i2.DialogService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ENTITY_TYPES_CONFIG]
                }] }, { type: i3.PrimengUtilityService }, { type: i4.TranslateService }, { type: i5.Router }]; }, propDecorators: { dataTableComponent: [{
                type: ViewChild,
                args: [Table]
            }], entityTypeName: [{
                type: Input
            }], onClickGoTo: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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