import { Component, Inject } from '@angular/core';
import { DialogService } from 'primeng/dynamicdialog';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import { EntityType } from '../../models/entity-type.model';
import { PRG_ENTITY_TYPES_CONFIG } from '../../services/entity-types-configuration/prg-entity-types-configuration.service';
import { PrgEntityTypeComponent } from '../entity-type/prg-entity-type.component';
import * as i0 from "@angular/core";
import * as i1 from "../../services/entity-types/abstract-entity-type.service";
import * as i2 from "../../../core/services/utility/array-utility.service";
import * as i3 from "primeng/dynamicdialog";
import * as i4 from "../../../core/services/utility/objects-utility.service";
import * as i5 from "primeng/api";
import * as i6 from "@angular/common";
import * as i7 from "primeng/button";
import * as i8 from "primeng/treetable";
import * as i9 from "@ngx-translate/core";
/**
 * component List entity types
 */
/**
 * class PrgListEntityTypesComponent
 */
export class PrgListEntityTypesComponent {
    /**
     * constructor
     * @param entityTypeService
     * @param arrayUtilityService
     * @param prgEntityTypesConfig
     * @param dialogService dialogService
     * @param objectsUtilityService
     */
    constructor(entityTypeService, arrayUtilityService, prgEntityTypesConfig, dialogService, objectsUtilityService) {
        this.entityTypeService = entityTypeService;
        this.arrayUtilityService = arrayUtilityService;
        this.prgEntityTypesConfig = prgEntityTypesConfig;
        this.dialogService = dialogService;
        this.objectsUtilityService = objectsUtilityService;
        /**
         * table columns
         */
        this.tableEntityTypeColumns = this.prgEntityTypesConfig.entityTypeTableColumns;
        /**
         * subscriptions
         */
        this.subscriptions = [];
        /**
         * property name to group
         */
        this.GROUP_BY_PROPERTY_NAME = 'group';
    }
    /**
     * ngOnInit
     */
    ngOnInit() {
        this.entityTypeService.getEntityTypeListAsync().then(() => {
            this.subscriptions.push(this.entityTypeService
                .getElementObservableByKey('product')
                .subscribe((value) => { }));
        });
        this.subscriptions.push(this.entityTypeService
            .getElementsListObservable()
            .subscribe((entityTypeList) => {
            this.treeData = this.arrayUtilityService.groupByField(entityTypeList, this.GROUP_BY_PROPERTY_NAME);
        }));
    }
    /**
     * ngOnDestroy
     */
    ngOnDestroy() {
        this.subscriptions.forEach((subscription) => {
            subscription.unsubscribe();
        });
        this.subscriptions = [];
    }
    /**
     * this function is responsible for generating and sending the necessary data to the dialog
     * @param entityType
     */
    showEntityTypeData(entityType) {
        let entityTypeAux;
        if (entityType) {
            entityTypeAux = this.objectsUtilityService.cloneObject(entityType);
        }
        else {
            entityTypeAux = new EntityType();
        }
        this.ref = this.dialogService.open(PrgEntityTypeComponent, {
            data: {
                entityType: entityTypeAux,
                viewMode: entityTypeAux.id ? ViewMode.Read : ViewMode.Edit,
            },
            width: '90vw',
            showHeader: true,
            contentStyle: { 'max-height': '70%', overflow: 'auto' },
            baseZIndex: 10000,
            //dismissableMask: true,
        });
    }
}
PrgListEntityTypesComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgListEntityTypesComponent, deps: [{ token: i1.AbstractEntityTypeService }, { token: i2.ArrayUtilityService }, { token: PRG_ENTITY_TYPES_CONFIG }, { token: i3.DialogService }, { token: i4.ObjectsUtilityService }], target: i0.ɵɵFactoryTarget.Component });
PrgListEntityTypesComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgListEntityTypesComponent, selector: "prg-list-entity-types", providers: [DialogService], ngImport: i0, template: "<div>\r\n  <p-button\r\n    [label]=\"'buttons.add.label' | translate\"\r\n    (click)=\"showEntityTypeData(null)\"\r\n  ></p-button>\r\n\r\n  <p-treeTable [value]=\"treeData\">\r\n    <ng-template pTemplate=\"header\">\r\n      <tr>\r\n        <th *ngFor=\"let col of tableEntityTypeColumns\">\r\n          {{ 'entity-type.fields.' + col.key + '.label' | translate }}\r\n        </th>\r\n      </tr>\r\n    </ng-template>\r\n    <ng-template pTemplate=\"body\" let-rowNode let-rowData=\"rowData\">\r\n      <tr\r\n        [ttRow]=\"rowNode\"\r\n        (click)=\"rowNode.level !== 0 && showEntityTypeData(rowData)\"\r\n        [ngClass]=\"{ clickableRow: rowNode.level !== 0 }\"\r\n      >\r\n        <td *ngFor=\"let col of tableEntityTypeColumns; let i = index\">\r\n          <p-treeTableToggler\r\n            *ngIf=\"i == 0\"\r\n            [rowNode]=\"rowNode\"\r\n          ></p-treeTableToggler>\r\n          <ng-container *ngIf=\"col.key === 'name'; else elseBlock\">\r\n            {{\r\n              (rowNode.level == 0 ? 'entity-type.groups.' : 'entities.') +\r\n                rowData[col.key].toLowerCase() +\r\n                '.label' | translate\r\n            }}\r\n          </ng-container>\r\n          <ng-template #elseBlock> {{ rowData[col.key] }} </ng-template>\r\n        </td>\r\n      </tr>\r\n    </ng-template>\r\n  </p-treeTable>\r\n</div>\r\n", styles: [".clickableRow{cursor:pointer}.clickableRow:hover{background-color:#cbf6f6}body .p-orderlist-controls{display:none!important}\n"], dependencies: [{ kind: "directive", type: i5.PrimeTemplate, selector: "[pTemplate]", inputs: ["type", "pTemplate"] }, { kind: "directive", type: i6.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i6.NgForOf, selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i6.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i7.Button, selector: "p-button", inputs: ["type", "iconPos", "icon", "badge", "label", "disabled", "loading", "loadingIcon", "style", "styleClass", "badgeClass", "ariaLabel"], outputs: ["onClick", "onFocus", "onBlur"] }, { kind: "component", type: i8.TreeTable, selector: "p-treeTable", inputs: ["columns", "style", "styleClass", "tableStyle", "tableStyleClass", "autoLayout", "lazy", "lazyLoadOnInit", "paginator", "rows", "first", "pageLinks", "rowsPerPageOptions", "alwaysShowPaginator", "paginatorPosition", "paginatorDropdownAppendTo", "currentPageReportTemplate", "showCurrentPageReport", "showJumpToPageDropdown", "showFirstLastIcon", "showPageLinks", "defaultSortOrder", "sortMode", "resetPageOnSort", "customSort", "selectionMode", "contextMenuSelection", "contextMenuSelectionMode", "dataKey", "metaKeySelection", "compareSelectionBy", "rowHover", "loading", "loadingIcon", "showLoader", "scrollable", "scrollHeight", "virtualScroll", "virtualScrollItemSize", "virtualScrollOptions", "virtualScrollDelay", "frozenWidth", "frozenColumns", "resizableColumns", "columnResizeMode", "reorderableColumns", "contextMenu", "rowTrackBy", "filters", "globalFilterFields", "filterDelay", "filterMode", "filterLocale", "virtualRowHeight", "value", "totalRecords", "sortField", "sortOrder", "multiSortMeta", "selection"], outputs: ["selectionChange", "contextMenuSelectionChange", "onFilter", "onNodeExpand", "onNodeCollapse", "onPage", "onSort", "onLazyLoad", "sortFunction", "onColResize", "onColReorder", "onNodeSelect", "onNodeUnselect", "onContextMenuSelect", "onHeaderCheckboxToggle", "onEditInit", "onEditComplete", "onEditCancel"] }, { kind: "component", type: i8.TreeTableToggler, selector: "p-treeTableToggler", inputs: ["rowNode"] }, { kind: "directive", type: i8.TTRow, selector: "[ttRow]", inputs: ["ttRow"] }, { kind: "pipe", type: i9.TranslatePipe, name: "translate" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgListEntityTypesComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-list-entity-types', providers: [DialogService], template: "<div>\r\n  <p-button\r\n    [label]=\"'buttons.add.label' | translate\"\r\n    (click)=\"showEntityTypeData(null)\"\r\n  ></p-button>\r\n\r\n  <p-treeTable [value]=\"treeData\">\r\n    <ng-template pTemplate=\"header\">\r\n      <tr>\r\n        <th *ngFor=\"let col of tableEntityTypeColumns\">\r\n          {{ 'entity-type.fields.' + col.key + '.label' | translate }}\r\n        </th>\r\n      </tr>\r\n    </ng-template>\r\n    <ng-template pTemplate=\"body\" let-rowNode let-rowData=\"rowData\">\r\n      <tr\r\n        [ttRow]=\"rowNode\"\r\n        (click)=\"rowNode.level !== 0 && showEntityTypeData(rowData)\"\r\n        [ngClass]=\"{ clickableRow: rowNode.level !== 0 }\"\r\n      >\r\n        <td *ngFor=\"let col of tableEntityTypeColumns; let i = index\">\r\n          <p-treeTableToggler\r\n            *ngIf=\"i == 0\"\r\n            [rowNode]=\"rowNode\"\r\n          ></p-treeTableToggler>\r\n          <ng-container *ngIf=\"col.key === 'name'; else elseBlock\">\r\n            {{\r\n              (rowNode.level == 0 ? 'entity-type.groups.' : 'entities.') +\r\n                rowData[col.key].toLowerCase() +\r\n                '.label' | translate\r\n            }}\r\n          </ng-container>\r\n          <ng-template #elseBlock> {{ rowData[col.key] }} </ng-template>\r\n        </td>\r\n      </tr>\r\n    </ng-template>\r\n  </p-treeTable>\r\n</div>\r\n", styles: [".clickableRow{cursor:pointer}.clickableRow:hover{background-color:#cbf6f6}body .p-orderlist-controls{display:none!important}\n"] }]
        }], ctorParameters: function () { return [{ type: i1.AbstractEntityTypeService }, { type: i2.ArrayUtilityService }, { type: undefined, decorators: [{
                    type: Inject,
                    args: [PRG_ENTITY_TYPES_CONFIG]
                }] }, { type: i3.DialogService }, { type: i4.ObjectsUtilityService }]; } });
//# sourceMappingURL=data:application/json;base64,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