import { Component, Input } from '@angular/core';
import { BaseAction, BaseActionKey, } from '../../../core/components/dynamic-form/models/base-action';
import { ActionName } from '../../../core/components/dynamic-form/models/constants/action-names';
import { ToolbarSlot } from '../../../core/components/dynamic-form/models/constants/toolbar-slots';
import { ViewMode } from '../../../core/models/constants/view-mode.enum';
import * as i0 from "@angular/core";
import * as i1 from "../../../core/services/utility/array-utility.service";
import * as i2 from "../../../core/services/utility/utility.service";
import * as i3 from "../../services/entity-types/abstract-entity-type.service";
import * as i4 from "primeng/dynamicdialog";
import * as i5 from "../../../core/services/utility/objects-utility.service";
import * as i6 from "../../../core/services/notifications/notifications.service";
import * as i7 from "@ngx-translate/core";
import * as i8 from "@angular/router";
import * as i9 from "../../../core/components/dynamic-form/prg-dynamic-form.component";
export class PrgEntityTypeElementComponent {
    /**
     * constructor
     *
     * @param arrayUtilityService
     * @param utilityService
     * @param entityTypeService
     * @param ref
     * @param config
     * @param objectsUtilityService
     */
    constructor(arrayUtilityService, utilityService, entityTypeService, ref, config, objectsUtilityService, notificationsService, translateService, router, route) {
        this.arrayUtilityService = arrayUtilityService;
        this.utilityService = utilityService;
        this.entityTypeService = entityTypeService;
        this.ref = ref;
        this.config = config;
        this.objectsUtilityService = objectsUtilityService;
        this.notificationsService = notificationsService;
        this.translateService = translateService;
        this.router = router;
        this.route = route;
        /**
         * entity type view mode
         */
        this.elementViewMode = ViewMode.Read;
        /**
         * entity type form fields
         */
        this.entityTypeDynamicFormElementFields = [];
        /**
         * entity type form actions
         */
        this.entityTypeDynamicFormElementActions = [];
        /**
         * variable to save if is a popup
         */
        this.isPopup = false;
    }
    /**
     * element input
     */
    set element(element) {
        this._element = element;
    }
    /**
     * element getter
     */
    get element() {
        return this._element;
    }
    /**
     * entity type input
     */
    set entityType(entityType) {
        if (entityType) {
            this._entityType = entityType;
            this.getBaseFieldsFromEntityType(entityType);
            this.getActionsFromEntityType(entityType.operations);
        }
    }
    /**
     * entity type getter
     */
    get entityType() {
        return this._entityType;
    }
    /**
     * ngOnInit
     *
     *  if this component is contained in a dialog it fetches the data from the config
     */
    ngOnInit() {
        if (this.config.hasOwnProperty('data')) {
            this._entityType = this.config.data.entityType;
            this._element = this.config.data.element;
            this.elementViewMode = this.config.data.viewMode;
            this.getBaseFieldsFromEntityType(this.config.data.entityType);
            this.getActionsFromEntityType(this.config.data.entityType.operations);
            this.isPopup = true;
        }
        this.entityTypeDynamicFormElementActions.push(new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Edit,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: "this.viewMode==='read'",
        }), new BaseAction({
            controlName: ActionName.Button,
            key: BaseActionKey.Cancel,
            disableWhenFormInvalid: false,
            toolbarSlot: ToolbarSlot.Left,
            visibleExpression: ' this.entity!= null && this.entity.id == null',
        }));
    }
    /**
     * this function receives the output and depending on
     * the action clicked performs a certain set of actions
     *
     * @param event
     */
    async onActionOutputed(event) {
        switch (event.action) {
            case BaseActionKey.Cancel:
                if (event.formEntity.id) {
                    this.element = this.objectsUtilityService.cloneObject(this.element);
                    this.elementViewMode = ViewMode.Read;
                }
                if (this.isPopup) {
                    this.ref.close();
                }
                else {
                    window.location.href = window.location.href.replace('/new', '');
                }
                break;
            case BaseActionKey.Edit:
                this.elementViewMode = ViewMode.Edit;
                break;
            default:
                let actionResult;
                const action = this.entityTypeDynamicFormElementActions.find((a) => a.key === event.action);
                if (action == null || action['operation'] == null) {
                    return;
                }
                if (action.hasOwnProperty('confirmationModal') &&
                    action.hasOwnProperty('confirmationModal') !== null) {
                    if (await this.notificationsService.prgConfirmationService('messages.delete-confirmation', await this.translateService
                        .get('entities.' + this.entityType.name + '.label')
                        .toPromise())) {
                        actionResult = await this.entityTypeService.executeAction(this.entityType.name, action['operation'], event.formEntity);
                    }
                }
                else {
                    actionResult = await this.entityTypeService.executeAction(this.entityType.name, action['operation'], event.formEntity);
                }
                if (!action.executedActionBehaviour) {
                    break;
                }
                if (action.executedActionBehaviour.changeViewModeToRead) {
                    this.elementViewMode = ViewMode.Read;
                }
                if (action.executedActionBehaviour.redirectToList) {
                    if (this.isPopup) {
                        this.ref.close(action.executedActionBehaviour);
                    }
                    else {
                        this.router.navigate(['../'], { relativeTo: this.route });
                    }
                }
                break;
        }
    }
    /**
     * this function creates the filds for the dynamic
     * form according to the properties of an entity type
     * @param entityType
     */
    getBaseFieldsFromEntityType(entityType) {
        if (entityType.properties.length) {
            entityType.properties.forEach((property) => {
                if (property.guiSettings) {
                    const guiSettings = this.utilityService.guiSettingToObject(property.guiSettings, 'entities.' + entityType.name + '.fields');
                    if (!guiSettings.key) {
                        guiSettings.key = property.name;
                    }
                    this.entityTypeDynamicFormElementFields.push(guiSettings);
                }
            });
        }
        this.entityTypeDynamicFormElementFields = this.arrayUtilityService.clone(this.entityTypeDynamicFormElementFields);
    }
    /**
     * this function creates the actions depending
     * on the operations associated to a given entity type
     *
     * @param entityTypeOperations
     */
    getActionsFromEntityType(entityTypeOperations) {
        entityTypeOperations.forEach((operation) => {
            if (operation.guiSettings) {
                const guiSettingsObject = this.utilityService.guiSettingToObject(operation.guiSettings);
                guiSettingsObject.operation = operation;
                const baseAction = new BaseAction(guiSettingsObject);
                this.entityTypeDynamicFormElementActions.push(baseAction);
            }
        });
        this.entityTypeDynamicFormElementActions = this.arrayUtilityService.clone(this.entityTypeDynamicFormElementActions);
    }
}
PrgEntityTypeElementComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypeElementComponent, deps: [{ token: i1.ArrayUtilityService }, { token: i2.UtilityService }, { token: i3.AbstractEntityTypeService }, { token: i4.DynamicDialogRef }, { token: i4.DynamicDialogConfig }, { token: i5.ObjectsUtilityService }, { token: i6.NotificationsService }, { token: i7.TranslateService }, { token: i8.Router }, { token: i8.ActivatedRoute }], target: i0.ɵɵFactoryTarget.Component });
PrgEntityTypeElementComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.2.0", type: PrgEntityTypeElementComponent, selector: "prg-entity-type-element", inputs: { element: "element", entityType: "entityType", elementViewMode: "elementViewMode" }, ngImport: i0, template: "<div>\r\n  <prg-dynamic-form\r\n    [fields]=\"entityTypeDynamicFormElementFields\"\r\n    [actions]=\"entityTypeDynamicFormElementActions\"\r\n    [entity]=\"element\"\r\n    [viewMode]=\"elementViewMode\"\r\n    (actionOutput)=\"onActionOutputed($event)\"\r\n  ></prg-dynamic-form>\r\n</div>\r\n", styles: [""], dependencies: [{ kind: "component", type: i9.PrgDynamicFormComponent, selector: "prg-dynamic-form", inputs: ["context", "fields", "actions", "entity", "viewMode", "formGroupType"], outputs: ["actionOutput", "fieldChangeOutput"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgEntityTypeElementComponent, decorators: [{
            type: Component,
            args: [{ selector: 'prg-entity-type-element', template: "<div>\r\n  <prg-dynamic-form\r\n    [fields]=\"entityTypeDynamicFormElementFields\"\r\n    [actions]=\"entityTypeDynamicFormElementActions\"\r\n    [entity]=\"element\"\r\n    [viewMode]=\"elementViewMode\"\r\n    (actionOutput)=\"onActionOutputed($event)\"\r\n  ></prg-dynamic-form>\r\n</div>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.ArrayUtilityService }, { type: i2.UtilityService }, { type: i3.AbstractEntityTypeService }, { type: i4.DynamicDialogRef }, { type: i4.DynamicDialogConfig }, { type: i5.ObjectsUtilityService }, { type: i6.NotificationsService }, { type: i7.TranslateService }, { type: i8.Router }, { type: i8.ActivatedRoute }]; }, propDecorators: { element: [{
                type: Input
            }], entityType: [{
                type: Input
            }], elementViewMode: [{
                type: Input
            }] } });
//# sourceMappingURL=data:application/json;base64,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