import { BehaviorSubject } from 'rxjs';
/**
 * AbstractQueriesService class that defines an
 * <br />abstract dashboard service to
 * <br />be extended by the mock and real
 * <br />dashboard services
 */
export class AbstractDashboardService {
    /**
     * Constructor
     * @param {HttpClient} http
     */
    constructor(http) {
        this.http = http;
        /**
         * Detect changes on dashboard options made on prg-dashboard-options.component
         */
        this.dashboardOptionsChangesSubject = new BehaviorSubject(null);
        /**
         * Detect changes on the size of dashboardItems
         * @type {BehaviorSubject<GridsterItemComponentInterface>}
         * @protected
         */
        this.dashboardItemsResizeSubject = new BehaviorSubject(null);
        /**
         * Detect changes on the list of dashboards
         * @type {BehaviorSubject<Dashboard[]>}
         * @protected
         */
        this.dashboardListUpdatedSubject = new BehaviorSubject(null);
    }
    /**
     * Setter for dashboardOptionsChangesSubject
     * @param {GridConfigsAndItems} value
     */
    setDashboardOptionsChanges(value) {
        this.dashboardOptionsChangesSubject.next(value);
    }
    /**
     * Getter for dashboardOptionsChangesSubject
     * @returns {Observable<GridConfigsAndItems>}
     */
    getDashboardOptionsChangesObservable() {
        return this.dashboardOptionsChangesSubject.asObservable();
    }
    /**
     * Getter for dashboardOptionsChangesSubject
     * @returns {GridConfigsAndItems}
     */
    getDashboardOptionsChangesValue() {
        return this.dashboardOptionsChangesSubject.getValue();
    }
    /**
     * Setter for dashboardItemsResizeSubject
     * @param {GridsterItemComponentInterface} value
     */
    setDashboardItemsResize(value) {
        this.dashboardItemsResizeSubject.next(value);
    }
    /**
     * Getter for dashboardItemsResizeSubject
     * @returns {Observable<GridsterItemComponentInterface>}
     */
    getDashboardItemsResizeObservable() {
        return this.dashboardItemsResizeSubject.asObservable();
    }
    /**
     * Getter for dashboardItemsResizeSubject
     * @returns {GridsterItemComponentInterface}
     */
    getDashboardItemsResizeValue() {
        return this.dashboardItemsResizeSubject.getValue();
    }
    /**
     * Setter for dashboardListUpdatedSubject
     * @param {Dashboard[]} value
     */
    setDashboardListUpdated(value) {
        this.dashboardListUpdatedSubject.next(value);
    }
    /**
     * Getter for dashboardListUpdatedSubject
     * @returns {Observable<Dashboard[]>}
     */
    getDashboardListUpdatedObservable() {
        return this.dashboardListUpdatedSubject.asObservable();
    }
    /**
     * Getter for dashboardListUpdatedSubject
     * @returns {Dashboard[]}
     */
    getDashboardListUpdatedValue() {
        return this.dashboardListUpdatedSubject.getValue();
    }
}
//# sourceMappingURL=data:application/json;base64,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