import { NgModule } from '@angular/core';
import { GridsterModule } from 'angular-gridster2';
import { DynamicModule } from 'ng-dynamic-component';
import { ChartModule } from 'primeng/chart';
import { DragDropModule } from 'primeng/dragdrop';
import { OverlayPanelModule } from 'primeng/overlaypanel';
import { PrgCoreDynamicFormModule } from '../core/components/dynamic-form/prg-core-dynamic-form.module';
import { PrgEntityTypesModule } from '../entity-types/prg-entity-types.module';
import { PrgSharedComponentsModule } from '../shared-components/shared-components.module';
import { PrgDashboardDisplayComponent } from './components/dashboard-display/prg-dashboard-display.component';
import { PrgDashboardItemsOptionsComponent } from './components/dashboard-items-options/prg-dashboard-items-options.component';
import { PrgBarChartComponent } from './components/dashboard-items/bar-chart/prg-bar-chart.component';
import { PrgDoughnutChartComponent } from './components/dashboard-items/doughnut-chart/prg-doughnut-chart.component';
import { PrgLineChartComponent } from './components/dashboard-items/line-chart/prg-line-chart.component';
import { PrgTableComponent } from './components/dashboard-items/table/prg-table.component';
import { PrgDashboardListComponent } from './components/dashboard-list/prg-dashboard-list.component';
import { PrgDashboardOptionsComponent } from './components/dashboard-options/prg-dashboard-options.component';
import { PrgDashboardComponent } from './components/dashboard/prg-dashboard.component';
import { MockDashboardService } from './mock/services/dashboard.service.mock';
import { PrgDashboardRoutingModule } from './prg-dashboard-routing.module';
import { AbstractDashboardService } from './services/dashboard/abstract-dashboard.service';
import { DashboardService } from './services/dashboard/dashboard.service';
import { PRG_DASHBOARD_CONFIG } from './services/prg-dashboard-configuration/prg-dashboard-configuration.service';
import * as i0 from "@angular/core";
/**
 * Constant of dynamic components to be used on dashboard
 * @type {(PrgBarChartComponent | PrgLineChartComponent | PrgDoughnutChartComponent | PrgTableComponent)[]}
 */
const dynamicsComponents = [
    PrgBarChartComponent,
    PrgLineChartComponent,
    PrgDoughnutChartComponent,
    PrgTableComponent,
];
/**
 * Module that handles Dashboard
 */
export class PrgDashboardModule {
    constructor(injector) {
        this.injector = injector;
        appInjector = this.injector;
    }
    static forRoot(prgDashboardConfig) {
        dashboardConfig = prgDashboardConfig;
        return {
            ngModule: PrgDashboardModule,
            providers: [
                {
                    provide: PRG_DASHBOARD_CONFIG,
                    useValue: prgDashboardConfig,
                },
                {
                    provide: AbstractDashboardService,
                    useClass: prgDashboardConfig.useMockServices
                        ? MockDashboardService
                        : DashboardService,
                },
            ],
        };
    }
}
PrgDashboardModule.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardModule, deps: [{ token: i0.Injector }], target: i0.ɵɵFactoryTarget.NgModule });
PrgDashboardModule.ɵmod = i0.ɵɵngDeclareNgModule({ minVersion: "14.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardModule, declarations: [PrgDashboardComponent,
        PrgDashboardDisplayComponent,
        PrgDashboardListComponent,
        PrgDashboardOptionsComponent,
        PrgDashboardItemsOptionsComponent, PrgBarChartComponent,
        PrgLineChartComponent,
        PrgDoughnutChartComponent,
        PrgTableComponent], imports: [PrgDashboardRoutingModule,
        PrgSharedComponentsModule,
        PrgCoreDynamicFormModule,
        GridsterModule,
        ChartModule,
        DynamicModule,
        OverlayPanelModule,
        DragDropModule,
        PrgEntityTypesModule], exports: [PrgDashboardComponent, PrgDashboardListComponent] });
PrgDashboardModule.ɵinj = i0.ɵɵngDeclareInjector({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardModule, imports: [PrgDashboardRoutingModule,
        PrgSharedComponentsModule,
        PrgCoreDynamicFormModule,
        GridsterModule,
        ChartModule,
        DynamicModule,
        OverlayPanelModule,
        DragDropModule,
        PrgEntityTypesModule] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.2.0", ngImport: i0, type: PrgDashboardModule, decorators: [{
            type: NgModule,
            args: [{
                    declarations: [
                        PrgDashboardComponent,
                        PrgDashboardDisplayComponent,
                        PrgDashboardListComponent,
                        PrgDashboardOptionsComponent,
                        PrgDashboardItemsOptionsComponent,
                        ...dynamicsComponents,
                    ],
                    imports: [
                        PrgDashboardRoutingModule,
                        PrgSharedComponentsModule,
                        PrgCoreDynamicFormModule,
                        GridsterModule,
                        ChartModule,
                        DynamicModule,
                        OverlayPanelModule,
                        DragDropModule,
                        PrgEntityTypesModule,
                    ],
                    exports: [PrgDashboardComponent, PrgDashboardListComponent],
                    entryComponents: [
                        PrgDashboardOptionsComponent,
                        PrgDashboardItemsOptionsComponent,
                        ...dynamicsComponents,
                    ],
                }]
        }], ctorParameters: function () { return [{ type: i0.Injector }]; } });
/**
 * This variable allows you to access all the injectors on the entire app
 */
export let appInjector;
/**
 * Exports the DashboardCoreConfig object
 */
export let dashboardConfig;
//# sourceMappingURL=data:application/json;base64,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