import { BaseEntity } from '../../core/models/base-entity.model';
import { PrgBarChartComponent, PrgDoughnutChartComponent, PrgLineChartComponent, PrgTableComponent, } from '../components/dashboard-items';
/**
 * Enum for dynamic components to be used on dashboards
 */
export var ComponentTypeEnum;
(function (ComponentTypeEnum) {
    ComponentTypeEnum["BarChart"] = "Bar-Chart";
    ComponentTypeEnum["LineChart"] = "Line-Chart";
    ComponentTypeEnum["DoughnutChart"] = "Doughnut-Chart";
    ComponentTypeEnum["Table"] = "Table";
})(ComponentTypeEnum || (ComponentTypeEnum = {}));
/**
 * Map name of componentType to classes
 */
export const MapComponentTypesToClass = new Map([
    [ComponentTypeEnum.BarChart, PrgBarChartComponent],
    [ComponentTypeEnum.LineChart, PrgLineChartComponent],
    [ComponentTypeEnum.DoughnutChart, PrgDoughnutChartComponent],
    [ComponentTypeEnum.Table, PrgTableComponent],
]);
/**
 * Dashboard Class
 */
export class Dashboard extends BaseEntity {
    /**
     * Cosntructor
     * @param {Partial<Dashboard>} init
     */
    constructor(init) {
        super();
        /**
         * Read only
         * @type {boolean}
         */
        this.isPublic = true;
        Object.assign(this, init);
    }
}
/**
 * Dashboard Items CLass
 */
export class DashboardItem extends BaseEntity {
    /**
     * Constructor
     * @param {Partial<DashboardItem>} init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
/**
 * Component Type Class
 */
export class ComponentType extends BaseEntity {
    /**
     * Constructor
     * @param {Partial<DashboardItem>} init
     */
    constructor(init) {
        super();
        Object.assign(this, init);
    }
}
//# sourceMappingURL=data:application/json;base64,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